var WEBBase = require("../../web.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
class IcAPI extends WEBBase {
    constructor() {
        super();
        // this.utilsProductSve = system.getObject("service.utilsSve.utilsProductSve");
        this.centerorderSve = system.getObject("service.common.centerorderSve");
        // this.utilsFqAliyunSve = system.getObject("service.utilsSve.utilsFqAliyunSve");
    }
    /**
      * 接口跳转-POST请求
      * action_process  执行的流程
      * action_type     执行的类型
      * action_body     执行的参数
      */
    async springBoard(pobj, qobj, req) {
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        if(pobj.actionType=='getPolicyNeedList' || pobj.actionType=='submitPolicyNeedNotes' ){
            if (!pobj.userInfo) {
                return system.getResult(system.noLogin, "user no login!");
            }
            if (!pobj.appInfo) {
                return system.getResult(system.noLogin, "app is null!");
            }
        }
        var result = await this.opActionProcess(pobj, pobj.actionType, req);
        return result;
    }
    async opActionProcess(pobj, action_type, req) {
        var opResult = null;
        switch (action_type) {   
            // case "testPushBusinessOrder":
            //     opResult=await this.utilsFqAliyunSve.testPushBusinessOrder();
            //     break;
            case "submitProgramme"://提交公司注册方案
                opResult = await this.centerorderSve.submitProgramme(pobj);
                break;
            case "getProgrammeListByUser"://获取方案列表（获取用户所有方案）
                opResult = await this.centerorderSve.reqCenterOrderApi(pobj);
                break;
            case "getProgrammeInfoByNeedNo"://根据需求查看方案列表
                opResult = await this.centerorderSve.reqCenterOrderApi(pobj);
                break;
            case "receiveFeedback"://接收方案反馈信息(即方案作废)
                opResult = await this.centerorderSve.reqCenterOrderApi(pobj);
                break;
            case "abolishProgramme"://服务商方案作废
                opResult = await this.centerorderSve.abolishProgramme(pobj);
                break;
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }

}
module.exports = IcAPI;