//百度工商注册
var APIBase = require("../../api.base");
var system = require("../../../system");
const regCfg = require("./regCfg");

class Consultation extends APIBase {
    constructor() {
        super();
        this.gatewaypushlogSve = system.getObject("service.common.gatewaypushlogSve");
    }

    async submit(pobj,req) {
        if(!pobj.appInfo || !pobj.appInfo.uapp_key || !pobj.appInfo.uapp_secret){
            return regCfg.getResultFail("未知应用或应用未启用");
        }
        if (!pobj.intentionBizId) {
            return regCfg.getResultFail("intentionBizId不能为空");
        }
        if (!pobj.phone) {
            return regCfg.getResultFail("mobile不能为空");
        }
        if (!pobj.consultType) {
            return regCfg.getResultFail("consultType不能为空");
        }
        pobj.type = pobj.consultType;
        pobj.mobile = pobj.phone;
        pobj.action_type = "submitRegNeed";
        if (pobj.area) {
            pobj.area = regCfg.baiduArea[pobj.area]
        }
        if (!pobj.area) {
            return regCfg.getResultFail("area参数错误");
        }
        var param = {
            requestId: req.requestId || regCfg.getUUID(),
            requestUrl: "/ic/consultation/submit",
            requestjson: JSON.stringify(pobj),//请求地址
            pushUrl: "/action/intentionapi/springBoard",//调用地址
            pushActionType: "submitRegNeed",//调用参数
            pushtimes: 0,//推送次数
            pushStatus: "wts",//推送状态
        }
        await this.gatewaypushlogSve.create(param);
        return regCfg.getResultSuccess(param.requestId);
    }

}
module.exports = Consultation;