var APIBase = require("../../api.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
const uuidv4 = require('uuid/v4');
/**
 * icp通知接口（百度icp接入）
 * 庄冰 2020.10.22
 */
class Feedback extends APIBase {
    constructor() {
        super();
        this.gatewaypushlogSve = system.getObject("service.common.gatewaypushlogSve");
    }

    getUUID() {
        var uuid = uuidv4();
        var u = uuid.replace(/\-/g, "");
        return u;
    }
    getResultSuccess(requestId) {
        return {
        "status": 0,
        "msg": "success",
        "data":null,
        "requestId": requestId
        };
    }
    getResultFail(errmsg) {
        var self = this;
        return {
        "status":-1,
        "msg": errmsg,
        "requestId": self.getUUID(),
        "data":null,
        "bizmsg":"empty"
        };
    }

    //icp需求反馈
    async submit(pobj,obj,req) {
        var self = this;
        if(!pobj.appInfo || !pobj.appInfo.uapp_key || !pobj.appInfo.uapp_secret){
            return self.getResultFail("未知应用或应用未启用");
        }
        if (!pobj.intentionBizId) {
            return self.getResultFail("intentionBizId不能为空");
        }
        if (!pobj.description) {
            return self.getResultFail("description不能为空");
        }
        if (!pobj.intentionStatus) {
            return self.getResultFail("intentionStatus不能为空");
        }
        pobj.action_type = "icpFeedbackSubmitNew";
        var param = {
            requestId: req.requestId || self.getUUID(),
            requestUrl: "/icp/feedback/submit",
            requestjson: JSON.stringify(pobj),//请求地址
            pushUrl: "/action/intentionapi/springBoard",//调用地址
            pushActionType: "icpFeedbackSubmitNew",//调用参数
            pushtimes: 0,//推送次数
            pushStatus: "wts",//推送状态
        }
        await self.gatewaypushlogSve.create(param);
        return self.getResultSuccess(param.requestId);
    }

   
}
module.exports = Feedback;