const system = require("../../../system");
const ServiceBase = require("../../sve.base");
var settings = require("../../../../config/settings");
class PushlogService extends ServiceBase {
  constructor() {
    super("common", ServiceBase.getDaoName(PushlogService));
    this.logCtl = system.getObject("service.common.oplogSve");
    this.pushfaillogDao = system.getObject("db.common.pushfaillogDao");
  }
  async createDb(qobj) {
    try {
      qobj.optitle = (new Date()).Format("yyyy-MM-dd hh:mm:ss") + "：" + qobj.optitle;
      this.dao.create(qobj);
    } catch (e) {
      //日志记录
      this.logCtl.error({
        appid: qobj.appid || "",
        appkey: qobj.appkey || "",
        requestId: qobj.requestId || "",
        op: qobj.op || "",
        content: qobj.content + "-->error：" + e.stack,
        clientIp: qobj.clientIp || "",
        optitle: qobj.optitle || "" + "-->添加日志失败center_channel_pushlog->createDb",
      });
    }
  }
  async createFailLogDb(qobj) {
    try {
      qobj.optitle = (new Date()).Format("yyyy-MM-dd hh:mm:ss") + "：" + qobj.optitle;
      this.pushfaillogDao.create(qobj);
    } catch (e) {
      //日志记录
      this.logCtl.error({
        appid: qobj.appid || "",
        appkey: qobj.appkey || "",
        requestId: qobj.requestId || "",
        op: qobj.op || "",
        content: qobj.content + "-->error：" + e.stack,
        clientIp: qobj.clientIp || "",
        optitle: qobj.optitle || "" + "-->添加日志失败center_channel_pushfaillog->createFailLogDb",
      });
    }
  }
  async delDbPushfaillogById(id) {
    this.pushfaillogDao.bulkDeleteByWhere({ where: { id: id } });
  }
  async getFailLogList() {
    var sql = "SELECT id,`content`,failType,pushNumber,opTitle FROM `center_channel_pushfaillog` WHERE failType IN(1,2,4) AND pushNumber<10 LIMIT 200";
    var list = await this.pushfaillogDao.customQuery(sql);
    var result = system.getResultSuccess(list);
    return result;
  }

  async addPublicServiceLog(pobj, req) {
    var sql = "INSERT INTO `igirl_api`.`center_channel_public_servicelog` (`appkey`,`pushUrl`,`pushContent`,`resultInfo`,`pushNumber`,`clientIp`,created_at)" +
      "VALUES(:appkey,:pushUrl,:pushContent,:resultInfo,:pushNumber,:clientIp,:created_at)";
    var params = {
      appkey: pobj.appInfo ? pobj.appInfo.uapp_key || "" : "",
      pushUrl: pobj.actionBody.pushUrl,
      pushContent: pobj.actionBody.pushContent ? JSON.stringify(pobj.actionBody.pushContent) : "",
      resultInfo: pobj.actionBody.resultInfo ? JSON.stringify(pobj.actionBody.resultInfo) : "",
      pushNumber: pobj.actionBody.pushNumber || 0,
      clientIp: req.clientIp || "",
      created_at: new Date()
    }
    await this.pushfaillogDao.customInsert(sql, params);
    return system.getResultSuccess();
  }
  async delPublicServiceLog(id) {
    var sql = "DELETE FROM `center_channel_public_servicelog`  WHERE id=:id";
    var params = {
      id: id
    }
    await this.pushfaillogDao.customDelete(sql, params);
    return system.getResultSuccess();
  }
  async getPublicServiceLogList() {
    var sql = "SELECT id,appkey,`pushUrl`,pushContent,pushNumber,clientIp FROM `center_channel_public_servicelog` WHERE pushNumber<10 LIMIT 10";
    var list = await this.pushfaillogDao.customQuery(sql);
    var result = system.getResultSuccess(list);
    return result;
  }
}
module.exports = PushlogService;
