const system = require("../../../system");
const crypto = require('crypto');
var settings = require("../../../../config/settings");
const AppServiceBase = require("../../app.base");

/**
 * 资质信息提报相关接口(ICP\EDI)
 */
class QcCenterOrderService extends AppServiceBase {
  constructor() {
    super();
    this.centerOrderUrl = settings.centerOrderUrl();
    this.execClient = system.getObject("util.execClient");
    this.aliclient = system.getObject("util.aliyunClient");
    this.cacheManager = system.getObject("db.common.cacheManager");
    this.utilsOrderSve = system.getObject("service.utilsSve.utilsOrderSve");
    this.utilsPushSve = system.getObject("service.utilsSve.utilsPushSve");
    this.utilsTmAliyunSve = system.getObject("service.utilsSve.utilsTmAliyunSve");//测试用
    this.opPushQueueUrl = settings.opPushQueueUrl();

  };
  //调用center-order 
  async reqCenterOrderApi(pobj, reqUrl) {
    var url = this.centerOrderUrl + "action/qcapi/springBoard";
    if (reqUrl) {
      var url = this.centerOrderUrl + reqUrl;
    }
    var rtn = await this.execClient.execPost(pobj, url);
    var data = JSON.parse(rtn.stdout);
    return data;
  }

  //提交Icp注册方案
  async submitIcpProgramme(pobj) {
    var res = await this.reqCenterOrderApi(pobj, "action/qcapi/springBoard");
    if (res && res.status == 0 && res.data && res.data.needinfo && res.data.needsolution) {
      var needinfo = res.data.needinfo;//需求信息
      var needsolution = res.data.needsolution;//方案信息
      var ab = pobj.actionBody;
      if (typeof (ab.solutionContent) == "string") {
        ab.solutionContent = JSON.parse(ab.solutionContent);
      }
      if (typeof (needsolution.solutionContent) == "string") {
        needsolution.solutionContent = JSON.parse(needsolution.solutionContent);
      }
      var solution = needsolution.solutionContent.solution;
      //推送数据至阿里
      var pushObj = {
        IntentionBizId: needinfo.channelNeedNo,
        CompanyName: solution.CompanyName, IcpType: solution.IcpType, CompanyAddress: solution.CompanyAddress,
        Area: solution.Area, Note: solution.Note,
        ActionType: solution.actionType,
        Source: "官网"
      };
      if (needsolution.channelSolutionNo) {
        pushObj["BizId"] = needsolution.channelSolutionNo;
      }
      var self = this;
      //推送方案
      var pushIcpSolutionRes = await this.pushIcpSolution(pushObj, needsolution.solutionNo, pobj.appInfo, self);
      this.logCtl.info({
        appid: pobj.appInfo ? pobj.appInfo.uapp_id || "" : "",
        appkey: pobj.appInfo ? pobj.appInfo.uapp_key || "" : "",
        requestId: pobj.requestId || "",
        op: "service/impl/common/qcCenterOrderSve.js/submitIcpProgramme",
        content: JSON.stringify(pobj),
        resultInfo: JSON.stringify(needinfo),
        optitle: "createSolution推送蜂擎获取的接口信息->aliBusiness2Delivery",
      });
      var reqParams = {
        actionBody: {
          intentionBizId: needinfo.channelNeedNo,
          status: "createSolution"
        },
        appInfo: pobj.appInfo
      }
      this.utilsPushSve.aliBusiness2Delivery(reqParams, "updateChanceStatus");
      // 
      return system.getResultSuccess(pushIcpSolutionRes);
    }
    return res;
  }
  //推送ICP方案
  async pushIcpSolution(pushObj, solutionNo, appInfo, self) {
    //推送方案信息
    var pushRes = await self.aliclient.reqbyget({ action: "SubmitIcpSolution", reqbody: pushObj, apiVersion: "2019-05-08" });
    if (pushRes && pushRes.status == 0 && pushRes.data) {
      var resData = pushRes.data;
      if (resData.BizId) {
        var reqObj2 = {
          actionType: "receiveProgrammeNo",
          appInfo: appInfo,
          actionBody: {
            solutionNo: solutionNo,
            solutionBizId: resData.BizId
          }
        };
        var a = await self.reqCenterOrderApi(reqObj2);//保存渠道方案id
        if (a && a.status == 0) {
          //推送方案确认信息
          var confirmRes = await self.aliclient.reqbyget({ action: "ConfirmIntention", reqbody: { BizId: pushObj.IntentionBizId }, apiVersion: "2019-05-08" });
          if (confirmRes && confirmRes.status == 0 && confirmRes.data) {
            var confirmResData = confirmRes.data;
            if (confirmResData.ConfirmUrl) {
              var reqObj3 = {
                actionType: "receiveIcpConfirmUrl",
                appInfo: appInfo,
                actionBody: {
                  solutionNo: solutionNo,
                  confirmUrl: confirmResData.ConfirmUrl
                }
              };
              var a = await self.reqCenterOrderApi(reqObj3);//保存用户确认方案url
            }
          }
          return confirmRes;
        }
      }
    }
  }

  //服务商icp方案关闭
  async abolishIcpProgramme(pobj) {
    var res = await this.reqCenterOrderApi(pobj, "action/qcapi/springBoard");
    if (res && res.status == 0 && res.data) {
      var needsolution = res.data;//方案信息
      var ab = pobj.actionBody;
      if (typeof (ab.material) == "string") {
        ab.material = JSON.parse(ab.material);
      }
      //推送数据至阿里
      var pushObj = {
        BizId: ab.BizId, Note: ab.Note
      };
      //关闭方案
      this.aliclient.reqbyget({ action: "CloseIcpProduce", reqbody: pushObj, apiVersion: "2019-05-08" });
      return system.getResultSuccess();
    }
    return res;
  }

  //交付材料提交
  async serviceProviderSubmitMaterial(pobj) {
    var res = await this.reqCenterOrderApi(pobj, "action/qcapi/springBoard");
    if (res && res.status == 0 && res.data) {
      var needsolution = res.data;//方案信息
      var ab = pobj.actionBody;
      if (typeof (ab.material) == "string") {
        ab.material = JSON.parse(ab.material);
      }
      var material = ab.material;
      //推送数据至阿里 
      var BizId = needsolution.channelSolutionNo;//⽅案业务ID
      var pushObj = {
        "BizId": BizId,
        "Domain": material.Domain,
        "CorporateName": material.CorporateName,
        "IncludeForeignInvestment": material.IncludeForeignInvestment,
        "PartnerBusinessLicense": material.PartnerBusinessLicense,
        "PartnerIdCardList": material.PartnerIdCardList,
        "PartnerDomainCertificate": material.PartnerDomainCertificate,
        "PartnerPreviewOtherList": material.PartnerPreviewOtherList || [],
        "PartnerPlan": material.PartnerPlan || "",
        "PartnerForeignInvestment": material.PartnerForeignInvestment || "",
        "PartnerLaw": material.PartnerLaw || "",
        "PartnerStampOtherList": material.PartnerStampOtherList || [],
        "PartnerSignOtherList": material.PartnerSignOtherList || [],
        "PartnerSignAndStampOtherList": material.PartnerSignAndStampOtherList || []
      };
      var self = this;
      //推送方案材料
      if (pobj.appInfo.uapp_id == 18) {
        self.aliclient.reqbyget({ action: "SavePartnerSubmitMaterial", reqbody: pushObj, apiVersion: "2019-05-08" });
      }
      return system.getResultSuccess();
    }
    return res;
  }
  //通知交付状态变更
  async serviceProviderNotification(pobj) {
    var res = await this.reqCenterOrderApi(pobj, "action/qcapi/springBoard");
    if (res && res.status == 0 && res.data) {
      pobj.actionType = "getOrderByOrderNo";
      let orderUrl = settings.centerOrderUrl() + "action/order/springBoard";
      let orderResult = await this.restPostUrl(pobj, orderUrl);
      if (orderResult.status != 0) {
        return system.getResultFail(-1, '查询订单失败')
      }
      let uapp_id = orderResult.data.uapp_id;
      pobj.appInfo = { uapp_id: uapp_id };
      pobj.actionType = "getAppInterface";
      var reqUrl = settings.centerAppUrl() + "action/opProduct/springBoard";
      var productItemInterfaceResult = await this.restPostUrl(pobj, reqUrl);
      if (productItemInterfaceResult.status != 0) {
        system.getResultFail(-1, '获取接口参数失败')
      }
      pobj.interface_info = productItemInterfaceResult.data;
      pobj.pushObj = res.data;
      this.utilsPushSve.pushBusInfo(pobj, 'pushStatus', 1);
      
      return system.getResultSuccess();
    }
    return res;
  }
  //交付单关闭
  async closeOrderDelivery(pobj) {
    var res = await this.reqCenterOrderApi(pobj, "action/qcapi/springBoard");
    if (res && res.status == 0 && res.data) {
      var needsolution = res.data;//方案信息
      var ab = pobj.actionBody;
      //推送数据至阿里
      var pushObj = {
        BizId: needsolution.channelSolutionNo, Note: ab.note
      };
      //关闭方案
      this.aliclient.reqbyget({ action: "CloseIcpProduce", reqbody: pushObj, apiVersion: "2019-05-08" });
      return system.getResultSuccess();
    }
    return res;
  }
}
module.exports = QcCenterOrderService;
