const system = require("../../../system");
var settings = require("../../../../config/settings");
/**
 * 微信token
 * zhuangbing
 * 2020.02.17
 */
class WxTokenService{
    constructor(){
        this.rc=system.getObject("util.execClient");
        this.logDao = system.getObject("db.common.oplogDao");
    }
    /**
     * 获取微信access_token,用于微信H5链接分享
     * 返回结果：
     * component_access_token	第三方平台access_token
     * expires_in	有效期
     */
    async getToken(){
        try{
            var wxconfig = {
                AppID : "wx4c91e81bbb6039cd",
                Secret : "12048e66dba64f2581e02b306680b232",
                Token:"bosstoken",
                AccessTokenUrl : "https://api.weixin.qq.com/cgi-bin/token",
              };
            // var url="https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=wx8aa8a8d4ff3da8bd&secret=5b64d43832cfd08327e9369aa455f799";
            var url="https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=wx4c91e81bbb6039cd&secret=12048e66dba64f2581e02b306680b232";
            
            var rtn=await this.rc.execGet({},url);
            console.log(rtn);
            this.logDao.create({
                op: "WxTokenService/getToken",
                content: JSON.stringify(rtn),
                optitle: "获取政策微信access_token",
            });
            var result=JSON.parse(rtn.stdout);
            return result;
        }catch(e){
            return null;
        }
    }
    /**
     * 获取微信getJsapiTicket，用于微信H5链接分享
     */
    async getJsapiTicket(access_token){
        try{
            var url="https://api.weixin.qq.com/cgi-bin/ticket/getticket?access_token=" + access_token + "&type=jsapi";
            var rtn=await this.rc.execGet({},url);
            console.log(rtn);
            this.logDao.create({
                op: "WxTokenService/getJsapiTicket",
                content: JSON.stringify(rtn),
                optitle: "获取政策微信getJsapiTicket",
            });
            var result=JSON.parse(rtn.stdout);
            return result;
        }catch(e){
            return null;
        }
    }
    /**
     * 通过code换取网页授权access_token，用于政策H5 oauth授权登录
     * 注意：
     * 里通过code换取的是一个特殊的网页授权access_token,
     * 与基础支持中的access_token（该access_token用于调用其他接口）不同。
     * 公众号可通过下述接口来获取网页授权access_token。
     * 如果网页授权的作用域为snsapi_base，则本步骤中获取到网页授权access_token的同时，也获取到了openid，
     * snsapi_base式的网页授权流程即到此为止。
     * 
     */
    async getTokenAndOpenid(obj){
        try {
            if(!obj || !obj.code){
                return system.getResultFail(-1,"code参数不能为空");  
            }
            var url = "https://api.weixin.qq.com/sns/oauth2/access_token?appid=wx6f3ebe44defe336a&secret=82e8e32421647f0a86bbad14f041959b&code="+
            obj.code+"&grant_type=authorization_code";
            var rtn=await this.rc.execGet({},url);
            console.log(rtn);
            this.logDao.create({
                op: "WxTokenService/getToken2",
                content: JSON.stringify(rtn),
                optitle: "获取政策微信getToken2",
            });
            var result=JSON.parse(rtn.stdout);
            return system.getResultSuccess(result);  
        } catch (e) {
            var err = JSON.stringify(e.stack);
            return system.getResultFail(-200,err);  
        }
        

    }
    
}
module.exports=WxTokenService;