const system = require("../../../system");
const settings = require("../../../../config/settings");
const AppServiceBase = require("../../app.base");
const jwt = require('jsonwebtoken');
const { PDICT } = require("../../../../config/businessConfig");
//用户权限操作
class UtilsAuthService extends AppServiceBase {
  constructor() {
    super();
    this.centerAppUrl = settings.centerAppUrl();
  }
  //---------------登录-----------------------------------------------------

  /**
   * 解密信息
   * @param {*} encryptStr 加密字符串
   */
  async decryptInfo(encryptStr) {
    var result = await this.decryptStr(PDICT.encrypt_key, PDICT.encrypt_secret, encryptStr);
    return result;
  }
  async getReqTokenByHosts(actionBody, req) { //获取token----改成jwt方式--sy-2020-10-21
    if (["hosts", "appkey"].indexOf(actionBody.reqType) < 0) {
      return system.getResult(null, "actionBody.reqType is error");
    }
    if (actionBody.reqType == "hosts") {
      if (!actionBody.appHosts) {
        return system.getResult(null, "actionBody.appHosts can not be empty");
      }
    }
    if (actionBody.reqType == "appkey") {
      if (!actionBody.appkey) {
        return system.getResult(null, "actionBody.appkey can not be empty");
      }
      if (!actionBody.secret) {
        return system.getResult(null, "actionBody.secret can not be empty");
      }
    }
    var tmpResult = await this.execPostByTimeOut(req, actionBody, settings.centerAppUrl() + "auth/accessAuth/getTokenByHosts");
    if (!tmpResult || tmpResult.status != 0) {
      return system.getResult(null, "data is empty");
    }
    if (!tmpResult.data || tmpResult.data.status != 0) {
      return system.getResult(null, "data is empty!");
    }
    let encrypt_info = await this.encryptStr(PDICT.encrypt_key, PDICT.encrypt_secret, JSON.stringify(tmpResult.data.data));
    let bodyInfo = {
      env: settings.env,
      id: tmpResult.data.data.id,
      uapp_id: tmpResult.data.data.uapp_id,
      token_secret: encrypt_info
    };
    const tokenSecret = settings.env == "localhost" || settings.env == "dev" ? PDICT.token_secret_dev : PDICT.token_secret_prod;
    //生成tokenid
    const tokenid = jwt.sign(bodyInfo, tokenSecret, { //  expiresIn：过期时间单位是秒
      expiresIn: 60 * 60 * 4 //单位秒，4小时

    });
    return system.getResultSuccess({ token: tokenid });
  }
  /**
   * 渠道通过账户进行登录，有则返回用户信息，没有则创建用户
   * @param {*} pobj
   * @param {*} actionBody {channelUserId:XX}
   */
  async getLoginByUserName(req, pobj, actionBody) {//渠道通过账户进行登录，有则返回用户信息，没有则创建用户---actionBody.channelUserId
    if (!actionBody.channelUserId) {
      return system.getResult(null, "actionBody.channelUserId can not be empty");
    }
    var tmpResult = await this.execPostByTimeOut(req, pobj, settings.centerAppUrl() + "auth/accessAuth/getLoginByUserName");
    if (!tmpResult || tmpResult.status != 0) {
      return system.getResult(null, "data is empty");
    }
    if (!tmpResult.data || tmpResult.data.status != 0) {
      return system.getResult(null, "data is empty!");
    }
    let encrypt_info = await this.encryptStr(PDICT.encrypt_key, PDICT.encrypt_secret, JSON.stringify(tmpResult.data.data));
    let bodyInfo = {
      env: settings.env,
      user_id: tmpResult.data.data.id,
      uapp_id: tmpResult.data.data.uapp_id,
      userpin_secret: encrypt_info
    };
    const tokenSecret = settings.env == "localhost" || settings.env == "dev" ? PDICT.token_secret_dev : PDICT.token_secret_prod;
    //生成tokenid
    const tokenid = jwt.sign(bodyInfo, tokenSecret, { //  expiresIn：过期时间单位是秒
      expiresIn: 60 * 60 * 4 //单位秒，4小时

    });
    return system.getResultSuccess({ userpin: tokenid });
  }

  /**
   * 通过账户和密码登录
   * @param {*} req 
   * @param {*} pobj 
   * @param {*} actionBody {userName:XX,password:XXX}
   */
  async getReqUserPinByLgoin(req, pobj, actionBody) {
    if (!actionBody.userName) {
      return system.getResult(null, "用户名不能为空");
    }
    if (!actionBody.password) {
      return system.getResult(null, "密码不能为空");
    }
    var tmpResult = await this.execPostByTimeOut(req, pobj, settings.centerAppUrl() + "auth/accessAuth/login");
    if (!tmpResult || tmpResult.status != 0) {
      return system.getResult(null, "用户名或密码错误");
    }
    if (!tmpResult.data || tmpResult.data.status != 0) {
      return system.getResult(null, "用户名或密码错误!");
    }
    let encrypt_info = await this.encryptStr(PDICT.encrypt_key, PDICT.encrypt_secret, JSON.stringify(tmpResult.data.data));
    let bodyInfo = {
      env: settings.env,
      user_id: tmpResult.data.data.id,
      uapp_id: tmpResult.data.data.uapp_id,
      userpin_secret: encrypt_info
    };
    const tokenSecret = settings.env == "localhost" || settings.env == "dev" ? PDICT.token_secret_dev : PDICT.token_secret_prod;
    //生成tokenid
    const tokenid = jwt.sign(bodyInfo, tokenSecret, { //  expiresIn：过期时间单位是秒
      expiresIn: 60 * 60 * 4 //单位秒，4小时

    });
    return system.getResultSuccess({ userpin: tokenid });
  }
  /**
   * 通过短信登录或注册信息
   * @param {*} req
   * @param {*} pobj
   * @param {*} actionBody {mobile:XXX,vcode:XXX,reqType:"reg",password:XXX-reqType为reg时有此值}
   */
  async getReqUserPinByLgoinVcode(req, pobj, actionBody) {
    if (!actionBody.mobile) {
      return system.getResult(null, "电话号码不能为空");
    }
    if (!actionBody.vcode) {
      return system.getResult(null, "验证码不能为空");
    }
    if (actionBody.reqType == "reg") {
      if (!actionBody.password) {
        return system.getResult(null, "actionBody.password can not be empty");
      }
    }
    const tmpResult = await this.execPostByTimeOut(req, pobj, this.centerAppUrl + "auth/accessAuth/loginByVerifyCode", null, null);
    if (!tmpResult || tmpResult.status != 0) {
      return system.getResult(null, tmpResult.msg);
    }
    if (!tmpResult.data || tmpResult.data.status != 0) {
      return system.getResult(null, tmpResult.data.msg);
    }
    let encrypt_info = await this.encryptStr(PDICT.encrypt_key, PDICT.encrypt_secret, JSON.stringify(tmpResult.data.data));
    let bodyInfo = {
      env: settings.env,
      user_id: tmpResult.data.data.id || 0,//新建立的用户时user_id为0
      uapp_id: tmpResult.data.data.uapp_id,
      userpin_secret: encrypt_info
    };
    const tokenSecret = settings.env == "localhost" || settings.env == "dev" ? PDICT.token_secret_dev : PDICT.token_secret_prod;
    //生成tokenid
    const tokenid = jwt.sign(bodyInfo, tokenSecret, { //  expiresIn：过期时间单位是秒
      expiresIn: 60 * 60 * 4 //单位秒，4小时

    });
    return system.getResultSuccess({ userpin: tokenid });
  }

  /**
   * 获取默认模板的手机验证码
   * @param {*} req
   * @param {*} pobj 
   * @param {*} actionBody {mobile:XXX}
   */
  async getVerifyCodeByMoblie(req, pobj, actionBody) {
    if (!actionBody.mobile) {
      return system.getResult(null, "actionBody.mobile can not be empty ！");
    }
    const result = await this.execPostByTimeOut(req, pobj, this.centerAppUrl + "auth/accessAuth/getVerifyCodeByMoblie", null, null);
    if (result.status === 0 && result.data.status != 0) {
      return result.data;
    }
    return system.getResultSuccess();
  }

  /**
   * 通过手机验证码修改用户密码
   * @param {*} pobj
   * @param {*} actionBody {mobile:XX,vcode:XXX,newPwd:XXX,userpin:XXXXX}
   */
  async putUserPwdByMobile(pobj, actionBody) {
    if (!actionBody.mobile) {
      return system.getResult(null, "pobj.mobile can not be empty ！");
    }
    if (!actionBody.vcode) {
      return system.getResult(null, "pobj.vcode can not be empty ！");
    }
    if (!actionBody.newPwd) {
      return system.getResult(null, "pobj.newPwd can not be empty ！");
    }
    if (!pobj.appInfo) {
      return system.getResult(null, "pobj.appInfo can not be empty ！");
    }
    var result = await this.restPostUrl(pobj, this.centerAppUrl + "auth/accessAuth/modiPasswordByMobile");
    if (result.status == 0) {
      this.userLogout(pobj, actionBody);
    }
    return result;
  }

  /**
   * 通过手机验证码修改用户手机号，邮箱
   * @param {*} pobj
   * @param {*} actionBody {mobile:XX,vcode:XXX,newPwd:XXX,userpin:XXXXX}
   */
  async putUserMobileByVcode(pobj, actionBody) {
    if (!actionBody.vcode) {
      return system.getResult(null, "pobj.vcode can not be empty ！");
    }
    if (!pobj.appInfo) {
      return system.getResult(null, "pobj.appInfo can not be empty ！");
    }
    var result = await this.restPostUrl(pobj, this.centerAppUrl + "auth/accessAuth/putUserMobileByVcode");
    if (result.status == 0) {
      this.userLogout(pobj, actionBody);
    }
    return result;
  }
  /**
   * 通过userpin获取用户登录信息
   * @param {*} pobj
   * @param {*} actionBody {userpin:XXXXX}
   */
  async getLoginInfo(pobj, actionBody) {
    if (!actionBody.userpin) {
      return system.getResult(null, "pobj.userpin can not be empty ！");
    }
    if (!pobj.appInfo) {
      return system.getResult(null, "pobj.appInfo can not be empty ！");
    }
    var result = await this.restPostUrl(pobj, this.centerAppUrl + "auth/accessAuth/getLoginInfo");
    return result;
  }
  /**
   * 用户退出
   * @param {*} pobj
   * @param {*} actionBody {userpin:XXXX}
   */
  async userLogout(pobj, actionBody) {
    console.log(actionBody.userpin);
    if (!actionBody.userpin) {
      return system.getResult(null, "actionBody.userpin can not be empty ！");
    }
    var applogout = await this.restPostUrl(pobj, this.centerAppUrl + "auth/accessAuth/logout");
    return applogout;
  }

  /**
   * 解析用户，获取认证token
   * @param pobj
   * @param actionBody
   * @param req
   * @returns {Promise<void>}
   */
  async channelUserLogin(pobj, actionBody, req) {
    let opResult = system.getResultSuccess()
    let pin = actionBody.pin;
    let result = await this.get360Token();
    let token = result.access_token;
    //360验证接口
    let subData = "pin=" + pin + "&token=" + token;
    let url = settings.requestUrl360() + 'api/v1/VerifyPin';
    let rtn = await this.restClient.execGet(subData,url);
    if (!rtn || !rtn.stdout) {
      return system.getResult(null, "restGet data is empty");
    }
    let checkRet = JSON.parse(rtn.stdout);
    if(checkRet.code != 200){
      return system.getResultFail(-1,checkRet.msg)
    }
    //---渠道用户登录，有则返回userpin ，没有则注册用户并返回userpin
    actionBody.channelUserId = pin;
    opResult = await this.getLoginByUserName(req,pobj, actionBody);
    return opResult;
  }

  async get360Token() {
    let rtn = await this.execClient.exec360GetToken(settings.tokenUrl360())
    if (!rtn || !rtn.stdout) {
      return system.getResult(null, "restPost data is empty");
    }
    let result = JSON.parse(rtn.stdout);
    return result;
  }

}
module.exports = UtilsAuthService;
