var system = require("../../../system");
var settings = require("../../../../config/settings");
const AppServiceBase = require("../../app.base");
const fs = require("fs");
const { json } = require("sequelize");
const { getResult, getResultSuccess } = require("../../../system");
//需求操作类----ali对接的需求
class UtilsNeedService extends AppServiceBase {
  constructor() {
    super();
    this.centerOrderUrl = settings.centerOrderUrl();
    this.utilsPushSve = system.getObject("service.utilsSve.utilsPushSve");
    this.aliclient = system.getObject("util.aliyunClient");
    this.ossClient = system.getObject("util.ossClient");
    this.restClient = system.getObject("util.restClient");
    this.utilsOrderSve = system.getObject("service.utilsSve.utilsOrderSve");
    this.utilsneedSve = system.getObject("service.common.gatewaypushlogSve");
    this.qcCenterOrderSve = system.getObject("service.common.qcCenterOrderSve");
    this.opPushQueueUrl = settings.opPushQueueUrl();
    this.utilsAuthSve = system.getObject("service.utilsSve.utilsAuthSve");
  }

  /**
    * 提交需求
   * @param {*} pobj
    * @param {*} actionBody
    */
  async submitNeed(pobj, actionBody) {
    if (actionBody.type == "esp.wangwen" || actionBody.type == "esp.food") {
      actionBody.area = this.wangwenAreaChange(actionBody.area)
    }
    if (!actionBody.intentionBizId) {
      return system.getResult(null, "actionBody.intentionBizId can not be empty，100380");
    }
    var sobj = pobj;
    sobj.actionType = "getProductTypeInfo";
    var url = settings.centerAppUrl() + "action/opProduct/springBoard";
    var rtn = await this.execClient.execPost(sobj, url);
    if (!rtn || !rtn.stdout) {
      return system.getResultFail(-5015, "需求類型查询失败");
    }
    var data = JSON.parse(rtn.stdout);
    if (data.status != 0) {
      return system.getResultFail(-5015, "需求類型查询失败");
    }
    pobj.actionBody.type_code = data.data.type_code;
    pobj.actionBody.type_name = data.data.type_name;
    pobj.actionBody.channel_type_code = data.data.channel_type_code;
    pobj.actionBody.channel_type_name = data.data.channel_type_name;
    pobj.actionBody.type = pobj.actionBody.channel_type_code;
    if (pobj.actionBody.channel_type_code == 5) {
      pobj.actionBody.type = "ali.icp";
    } else if (pobj.actionBody.channel_type_code == 7) {
      pobj.actionBody.type = "ali.edi";
    } else if (pobj.actionBody.channel_type_code == "tmjy") {
      pobj.actionBody.type = "ali.tmd";
    }


    if (pobj.actionBody.description && pobj.actionBody.description.indexOf("备#") < 0) {
      pobj.actionBody.level = "A";
    } else {
      // var levelurl = "http://106.13.228.212:8000/recProbability";
      // var levelresult = await this.restPostUrl({ intentionBizId: pobj.actionBody.intentionBizId, type: pobj.actionBody.type, note: pobj.actionBody.description }, levelurl);
      // if (levelresult.status == 0) {
      //   pobj.actionBody.level = levelresult.data.level;
      //   pobj.actionBody.probability = levelresult.data.per;
      // } else {
      //   pobj.actionBody.level = "C"
      // }
      pobj.actionBody.level = "C"
    }

    if (pobj.actionBody.phone == "17319425791") {
      pobj.actionBody.level = "F";
    }

    pobj.actionType = "submitNeed";
    var reqUrl = this.centerOrderUrl + "action/need/springBoard";
    var result = await this.restPostUrl(pobj, reqUrl);
    if (result.status == 0) {
      if (pobj.actionBody.channel_type_code == "esp.companyreg") {
        this.utilsPushSve.aliBusiness2Fq(pobj, "pushNeedBusiness");
      } else {
        var reqParams = {
          actionBody: pobj.actionBody,
          appInfo: pobj.appInfo
        }
        this.utilsPushSve.aliBusiness2Delivery(reqParams, "addChance");

        pobj.actionBody.description = pobj.actionBody.description + "   成交概率：" + pobj.actionBody.level
        if (pobj.actionBody.probability) {
          pobj.actionBody.description = pobj.actionBody.description + "（" + pobj.actionBody.probability + "） "
        }
        this.utilsPushSve.aliBusiness2Fq(pobj, "pushNeedICPBusiness");
      }
    }
    return result;
  }


  //调用center-order  icp需求反馈
  async reqCenterOrderQcApi(pobj, reqUrl) {
    var url = this.centerOrderUrl + "action/qcapi/springBoard";
    if (reqUrl) {
      var url = this.centerOrderUrl + reqUrl;
    }
    var self = this;
    pobj.actionType = "receiveIcpFeedback";
    if (pobj.actionBody && pobj.actionBody.intentionStatus) {
      pobj.intentionStatus = pobj.actionBody.intentionStatus;
    }
    var rtn = await this.execClient.execPost(pobj, url);
    // 2020 0803 lin 修改;
    if (pobj.intentionStatus) {
      // 如果需求当前字段为5（已关闭）则通知fq
      if (pobj.intentionStatus == 5) {
        self.utilsPushSve.aliBusiness2Fq(pobj, "pushCloseICPNeed");
      }
    }
    var data = JSON.parse(rtn.stdout);
    return data;
  }

  /**
   * 提交需求-----del
   * @param {*} pobj
   * @param {*} actionBody
   */
  async submitNeedH5(pobj, actionBody) {
    var sobj = pobj;
    sobj.actionType = "getProductTypeInfo";
    var url = settings.centerAppUrl() + "action/opProduct/springBoard";
    var rtn = await this.execClient.execPost(sobj, url);
    if (!rtn || !rtn.stdout) {
      return system.getResultFail(-5015, "需求类型查询失败");
    }
    var data = JSON.parse(rtn.stdout);
    if (data.status != 0) {
      return system.getResultFail(-5015, "需求类型查询失败");
    }
    pobj.actionBody.type_code = data.data.type_code;
    pobj.actionBody.type_name = data.data.type_name;
    pobj.actionBody.channel_type_code = data.data.channel_type_code;
    pobj.actionBody.channel_type_name = data.data.channel_type_name;
    pobj.actionType = "submitNeedH5";
    var reqUrl = this.centerOrderUrl + "action/need/springBoard";
    var result = await this.restPostUrl(pobj, reqUrl);
    if (result.status == 0) {
      if (pobj.actionBody.channel_type_code == "esp.companyreg") {
        this.utilsPushSve.aliBusiness2Fq(pobj, "pushNeedBusiness");
      }
      // else{
      //   if(pobj.actionBody.channel_type_code==5){
      //     pobj.actionBody.regType="ali.icp";
      //   }else{
      //     pobj.actionBody.regType="ali.edi";
      //   }
      //   this.utilsPushSve.aliBusiness2Fq(pobj, "intention");
      // }
    }
    return result;
  }

  /**
  * 获取需求详情
 * @param {*} pobj
  * @param {*} actionBody needNo 需求号
  */
  async getItemByNeedNo(pobj, actionBody) {
    if (!actionBody.needNo) {
      return system.getResult(null, "actionBody.needNo can not be empty，100385");
    }
    var reqUrl = this.centerOrderUrl + "action/need/springBoard";
    var itemResult = await this.restPostUrl(pobj, reqUrl);
    return itemResult;
  }
  /**
  * 获取需求详情
 * @param {*} pobj
  * @param {*} actionBody needNo 需求号
  */
  async getItemByChannelNeedNo(pobj, actionBody) {
    if (!actionBody.needNo) {
      return system.getResult(null, "actionBody.needNo can not be empty，100390");
    }
    var reqUrl = this.centerOrderUrl + "action/need/springBoard";
    var itemResult = await this.restPostUrl(pobj, reqUrl);
    return itemResult;
  }
  /**
  * 获取方案详情
 * @param {*} pobj
  * @param {*} actionBody needNo 需求号
  */
  async getSolutionByChannelSolutionNo(pobj, actionBody) {
    if (!actionBody.bizId) {
      return system.getResult(null, "actionBody.bizId can not be empty，100390");
    }
    var reqUrl = this.centerOrderUrl + "action/need/springBoard";
    var itemResult = await this.restPostUrl(pobj, reqUrl);
    return itemResult;
  }
  /**
  * 获取需求详情
 * @param {*} pobj
  * @param {*} actionBody bizId 渠道方案号
  */
  async getItemByChannelSolutionNo(pobj, actionBody) {
    if (!actionBody.bizId) {
      return system.getResult(null, "actionBody.bizId can not be empty，100390");
    }
    var reqUrl = this.centerOrderUrl + "action/need/springBoard";
    var itemResult = await this.restPostUrl(pobj, reqUrl);
    return itemResult;
  }
   /**
    * 获取方案详情
    * @param {*} pobj
    * @param {*} actionBody bizId 渠道方案号
  */
  async getSolutionByChannelOrderNo(pobj, actionBody) {
    if (!actionBody.orderNo) {
      return system.getResult(null, "actionBody.orderNo can not be empty，100390");
    }
    var reqUrl = this.centerOrderUrl + "action/need/springBoard";
    var itemResult = await this.restPostUrl(pobj, reqUrl);
    return itemResult;
  }
  /**
  * 关闭需求
 * @param {*} pobj
  * @param {*} actionBody
  */
  async needClose(pobj, actionBody) {
    if (!actionBody.intentionBizId) {
      return system.getResult(null, "actionBody.intentionBizId can not be empty，100395");
    }
    if (!actionBody.note) {
      return system.getResult(null, "actionBody.note can not be empty，100395");
    }
    pobj.actionBody.channelNeedNo = pobj.actionBody.intentionBizId;
    // 2020 1016 lin 新增 需求关闭时判断 方案状态 订单状态，打个比方如果已经生成订单了 那么肯定不能直接关闭需求
    var self = this;
    pobj.actionType = "abolishIcpProgrammeByNeed"
    var reqUrl = this.centerOrderUrl + "action/qcapi/springBoard";
    var result = await this.restPostUrl(pobj, reqUrl);
    // 2020 1015 lin 新增 这里为什么只推送蜂擎 没有推送交付？
    // 明天找栋源确认 如果需要增加 在这个文件搜索updateChanceStatus
    // 2020 1016 lin 新增 需求关闭时判断 方案状态 订单状态，打个比方如果已经生成订单了 那么肯定不能直接关闭需求
    if (result.status == 0) {
      if (result.data) {
        pobj.actionBody.orderNo = result.data;
        var orderrtn = await self.utilsOrderSve.delOrder(pobj, pobj.actionBody);
        if (orderrtn.status < 0) {
          return system.getResultFail(-5022, "订单关闭失败");
        }
      }

      //推送交付系统
      var reqParams = {
        actionBody: {
          intentionBizId: pobj.actionBody.channelNeedNo,
          status: "closeNeed"
        },
        opType: "updateChanceStatus",
        appInfo: pobj.appInfo
      }
      self.utilsPushSve.aliBusiness2Delivery(reqParams, "updateChanceStatus");
      self.utilsPushSve.aliBusiness2Fq(pobj, "pushCloseICPNeed");
    } 
    return result;
  }

  /**
  * icp关闭需求
 * @param {*} pobj
  * @param {*} actionBody
  */
  async needCloseIcp(pobj, actionBody) {
    if (!actionBody.channelNeedNo) {
      return system.getResult(null, "actionBody.channelNeedNo can not be empty，100395");
    }
    if (!actionBody.note) {
      return system.getResult(null, "actionBody.note can not be empty，100395");
    }
    var self = this;
    pobj.actionBody.intentionBizId = pobj.actionBody.channelNeedNo;
    pobj.actionType = "abolishIcpProgrammeByNeed"
    var reqUrl = this.centerOrderUrl + "action/qcapi/springBoard";
    var result = await this.restPostUrl(pobj, reqUrl);
    this.logCtl.info({
      appid: pobj.appInfo ? pobj.appInfo.uapp_id || "" : "",
      appkey: pobj.appInfo ? pobj.appInfo.uapp_key || "" : "",
      requestId: pobj.requestId || "",
      op: "service/impl/utilsSve/utilsNeedSve.js/needCloseIcp",
      content: JSON.stringify(pobj),
      resultInfo: JSON.stringify(result),
      optitle: "abolishIcpProgrammeByNeed推送蜂擎获取的接口信息->aliBusiness2Delivery",
    });
    if (result.status == 0) {
      if (result.data) {
        pobj.actionBody.orderNo = result.data;
        var orderrtn = await self.utilsOrderSve.delOrder(pobj, pobj.actionBody);
        if (orderrtn.status < 0) {
          return system.getResultFail(-5022, "订单关闭失败");
        }
      }

      //推送交付系统
      var reqParams = {
        actionBody: {
          intentionBizId: pobj.actionBody.channelNeedNo,
          status: "closeNeed"
        },
        opType: "updateChanceStatus",
        appInfo: pobj.appInfo
      }
      self.utilsPushSve.aliBusiness2Delivery(reqParams, "updateChanceStatus");
      //日志记录
      self.logCtl.info({
        appid: pobj.appInfo ? pobj.appInfo.uapp_id || "" : "",
        appkey: pobj.appInfo ? pobj.appInfo.uapp_key || "" : "",
        requestId: pobj.requestId || "",
        op: "service/impl/utilsSve/utilsNeedSve.js/needCloseIcp",
        content: JSON.stringify(reqParams),
        resultInfo: "",
        optitle: "updateChanceStatus推送蜂擎获取的接口信息->aliBusiness2Delivery",
      });
      // 推送ali
      var a = await self.aliclient.reqbyget({ action: "CloseIntention", reqbody: { BizId: actionBody.channelNeedNo, Note: actionBody.note }, apiVersion: "2019-05-08" });
      console.log(a);
      self.utilsPushSve.aliBusiness2Fq(pobj, "pushCloseICPNeed");
    }
    return  result
  }

  //查询需求详情
  async getItemByNeedNo(pobj, actionBody) {
    if (!actionBody.needNo) {
      return system.getResult(null, "actionBody.needNo can not be empty，100395");
    }
    var reqUrl = this.centerOrderUrl + "action/need/springBoard";
    var result = await this.restPostUrl(pobj, reqUrl);
    return result;
  }

  //状态更新
  async icpNotify(pobj) {
    var actionBody = pobj.actionBody;
    var self = this;
    if (!actionBody.bizId) {
      return system.getResult(null, "actionBody.bizId can not be empty，100495");
    }
    actionBody.BizId = actionBody.bizId;
    if (!actionBody.status) {
      return system.getResult(null, "actionBody.status can not be empty，100495");
    }
    if (actionBody.businessLicense) {
      actionBody.newbusinessLicense = await self.opDownFileInfo(actionBody.businessLicense);
    }
    if (actionBody.idCardUrlList) {
      var jsonidCardUrlList = JSON.parse(actionBody.idCardUrlList);
      var newidCardUrlList = [];
      for (var i = 0; i < jsonidCardUrlList.length; i++) {
        var key = jsonidCardUrlList[i];
        newidCardUrlList.push(await self.opDownFileInfo(key));
      }
      actionBody.newidCardUrlList = newidCardUrlList;
    }
    if (actionBody.userPlan) {
      actionBody.newuserPlan = await self.opDownFileInfo(actionBody.userPlan);
    }
    if (actionBody.userForeig) {
      actionBody.newuserForeig = await self.opDownFileInfo(actionBody.userForeig);
    }
    if (actionBody.userLaw) {
      actionBody.newuserLaw = await self.opDownFileInfo(actionBody.userLaw);
    }
    if (actionBody.userOtherList) {
      var jsonuserOtherList = JSON.parse(actionBody.userOtherList);
      var newuserOtherList = [];
      for (var i = 0; i < jsonuserOtherList.length; i++) {
        var key = jsonuserOtherList[i];
        newuserOtherList.push(await self.opDownFileInfo(key));
      }
      actionBody.newuserOtherList = newuserOtherList;
    }
    if (actionBody.isDirectBuy === "true" && (actionBody.status == 1 || actionBody.status == 0)) {//已支付直购不调用
      return system.getResultSuccess();
    }
    pobj.actionType = "receiveIcpStatusNotify";
    var url = settings.centerOrderUrl() + "action/qcapi/springBoard";
    var rtn = await this.restPostUrl(pobj, url);
    console.log("receiveIcpStatusNotify-->",rtn)
    if (actionBody.status == 2) {
      var deliveryObj = {
        actionBody: {
          orderNo: rtn.data.orderNo,//pobj.actionBody.channelOrder.channelOrderNo,
          needsolution: rtn.data.solutionContent,
          channelNeedNo: rtn.data.channelNeedNo || "",
          channelSolutionNo: rtn.data.channelSolutionNo,
          servicer: {
            code: 'gsb',
            name: '公司宝'
          }
        },
        appInfo: pobj.appInfo
      }
      this.utilsPushSve.aliBusiness2Delivery(deliveryObj, "pushDeliveryOrder");
    }
    if (rtn.status == 0 && actionBody.status != 1 && actionBody.status != 2 && rtn.data) {
      var tmpObj = {
        actionBody: {
          orderNo: rtn.data.orderNo,
          channelNeedNo: rtn.data.channelNeedNo,
          needsolution: rtn.data.solutionContent
        },
        appInfo: pobj.appInfo
      }
      this.utilsPushSve.aliBusiness2Delivery(tmpObj, "pushDeliveryStatusNotify");
      pobj.actionBody.orderNo = rtn.data.orderNo;
      if (actionBody.status == 11) {
        var orderrtn = await self.utilsOrderSve.delOrder(pobj, pobj.actionBody);
        if (orderrtn.status < 0) {
          return system.getResultFail(-5022, "订单关闭失败");
        }
        tmpObj.actionBody.orderNo = rtn.data.channelSolutionNo;
        self.utilsPushSve.aliBusiness2Fq(tmpObj, "pushOrderICPClose");
      }
    }//通知更新状态
    return rtn;
  }
  /**
   * 推送交付信息至企业宝（交付系统）
   */
  async pushOrderDelivery2Qfb(pobj, needsolution) {

  }

  async opDownFileInfo(docUrl, result) {  //从oss下载到本地并上传到自己oss，之后删除本地文件
    /*docUrl下载链接，全路径，如：https://XXXXXX.pdf?XXXXX */
    try {
      var tmpFileName = docUrl.substring(0, docUrl.lastIndexOf("?"));
      var fileName = tmpFileName.substr(tmpFileName.lastIndexOf("/") + 1, tmpFileName.length);
      // 2020 0803 lin 修改;
      var urlJson = this.urlSplit(decodeURI(docUrl));
      if (urlJson["Expires"]) {
        // url中过期时间与服务器时间对比结果为已过期
        if (urlJson["Expires"] < new Date().getTime()) {
          return "http://gsb-zc.oss-cn-beijing.aliyuncs.com/" + fileName;
        }
      }
      //解码后的文件全名:xxx.pdf
      var fileAllName = decodeURIComponent(fileName);//为xxx.pdf
      var saveFilePath = '/tmp/' + fileAllName;
      // 下载文件到指定的路径
      var tmpp = await this.restClient.execDownload("'" + docUrl + "'", saveFilePath);
      //上传 saveFilePath的文件 到ossClient
      var rtn = await this.ossClient.upfile(fileAllName, saveFilePath);
      result = rtn.url;
      //删除本地文件
      fs.unlink(saveFilePath, function (err) { });
    } catch (e) {

    }
    return result;
  }

  async needDetailByChannelNo(pobj) {
    if (!pobj.actionBody.bizId) {
      return system.getResult(null, "actionBody.bizId can not be empty，100491");
    }
    var solutionobj = {
      actionType: "getIcpProgrammeDetail",
      actionBody: { BizId: pobj.actionBody.bizId },
      appInfo: pobj.appInfo,
      actionProcess: pobj.actionProcess
    }
    var url = this.centerOrderUrl + "action/icpapi/springBoard";
    var solutionrtn = await this.execClient.execPost(solutionobj, url);
    if (!solutionrtn || !solutionrtn.stdout) {
      return system.getResultFail(-5011, "方案查询失败");
    }
    var solutiondata = JSON.parse(solutionrtn.stdout);
    if (solutiondata.status != 0) {
      return system.getResultFail(-5011, "方案查询失败");
    }
    if (solutiondata.data && solutiondata.data[0].channelNeedNo) {
      pobj.actionBody.needNo = solutiondata.data[0].channelNeedNo;
      pobj.actionBody.needId = solutiondata.data[0].channelNeedNo;
      pobj.actionBody.channelSolutionNo = solutiondata.data[0].channelSolutionNo;
    }
    var sobj = {
      actionType: "getItemByChannelNeedNo",
      actionBody: pobj.actionBody,
      appInfo: pobj.appInfo,
      actionProcess: pobj.actionProcess
    }
    var reqUrl = this.centerOrderUrl + "action/need/springBoard";
    var itemResult = await this.restPostUrl(sobj, reqUrl);
    if (itemResult.status == 0) {
      itemResult.data.channelSolutionNo = pobj.actionBody.channelSolutionNo;
    }
    return itemResult;
  }

  async writeCommunicationLog(pobj) {
    if (!pobj.actionBody.intentionBizId) {
      return system.getResult(null, "actionBody.intentionBizId can not be empty，100491");
    }
    if (!pobj.actionBody.note) {
      return system.getResult(null, "actionBody.note can not be empty，100492");
    }
    var self = this;
    var reqUrl = this.centerOrderUrl + "action/need/springBoard";
    var result = await this.restPostUrl(pobj, reqUrl);
    var res = await self.aliclient.reqbyget({ action: "WriteCommunicationLog", reqbody: { BizId: pobj.actionBody.intentionBizId, Note: pobj.actionBody.note }, apiVersion: "2019-05-08" });
    console.log("res", res)
    //推送交付系统
    var reqParams = {
      actionBody: {
        intentionBizId: pobj.actionBody.intentionBizId,
        status: "followingUp"
      },
      opType: "updateChanceStatus",
      appInfo: pobj.appInfo
    }
    self.utilsPushSve.aliBusiness2Delivery(reqParams, "updateChanceStatus");
    var fqobj = {
      actionBody: {
        "bizId": pobj.actionBody.intentionBizId,
        "follow_date": (new Date()).toISOString(),
        "follow_content": pobj.actionBody.note
      },
      opType: "aliFollowup",
      appInfo: pobj.appInfo
    }
    self.utilsPushSve.aliBusiness2Fq(fqobj, "aliFollowup");
    return system.getResultSuccess();
  }

  async queryExpertApplyCommunicationLogs(pobj) {
    if (!pobj.actionBody.intentionBizId) {
      return system.getResult(null, "actionBody.intentionBizId can not be empty，100493");
    }
    if (!pobj.actionBody.userFeedBack) {
      return system.getResult(null, "actionBody.userFeedBack can not be empty，100494");
    }
    let res = await this.aliclient.reqbyget({
      action: "QueryExpertApplyCommunicationLogs", reqbody: {
        BeginTime: pobj.actionBody.BeginTime ? pobj.actionBody.BeginTime : "",
        EndTime: pobj.actionBody.EndTime ? pobj.actionBody.EndTime : "",
        BizId: pobj.actionBody.intentionBizId,
        UserFeedBack: pobj.actionBody.userFeedBack,
        PageNum: pobj.actionBody.pageNum || 1,
        PageSize: pobj.actionBody.pageSize || 10,
      }, apiVersion: "2019-05-08"
    });
    // 2020 0820 lin 新增 拉去有跟进信息的需求但 并 记录
    // console.log(pobj.actionBody.intentionBizId,res.data.TotalItemNum)
    // if(res.data.TotalItemNum > 0) {
    //     var sql = "update testneed set status=1 where channelNeedNo=:channelNeedNo"
    //     var paramWhere = {
    //       channelNeedNo: pobj.actionBody.intentionBizId
    //     };
    //     var updateRes = await this.utilsneedSve.dao.customUpdate(sql, paramWhere);
    // }
    // func();
    return system.getResultSuccess(res);
  }

  /**
  * 2020 0827 lin 新增 4.1 用户在公司宝前端提交需求
  * @param {*} pobj
  * @param {*} actionBody
  */
  async submitIcpIntention(pobj, actionBody) {
    // 校验文档上必填字段
    if (!actionBody.UserName) {
      return system.getResult(null, "actionBody.UserName can not be empty，100400");
    }
    if (!actionBody.Description) {
      return system.getResult(null, "actionBody.Description can not be empty，100405");
    }
    if (!actionBody.Area) {
      return system.getResult(null, "actionBody.Area can not be empty，100410");
    }
    if (!actionBody.BizType) {
      return system.getResult(null, "actionBody.BizType can not be empty，100415");
    }
    // 调用center-order 生成新的需求
    var reqUrl = this.centerOrderUrl + "action/need/springBoard";
    var result = await this.restPostUrl(pobj, reqUrl);
    // 生成成功 通知ali
    if (result.status == 0) {
      var aliResult = await this.aliclient.reqbyget({ action: "SubmitIcpIntention", reqbody: actionBody, apiVersion: "2019-05-08" });
      console.log(aliResult);
    }
    return result;
  }

  /**
  * 2020 0827 lin 新增 4.2 需求列表查询
  * @param {*} pobj
  * @param {*} actionBody
  */
  async queryIntentionList(pobj, actionBody) {
    var aliResult = await self.aliclient.reqbyget({ action: "QueryIntentionList", reqbody: actionBody, apiVersion: "2019-05-08" });
    if (aliResult.code == 200) {
      return system.getResultSuccess();
    } else {
      return system.getResult(null, "查询失败 10420");
    }
  }

  /**
  * 2020 0827 lin 新增 4.3 用户需求确认 未测试
  * @param {*} pobj
  * @param {*} actionBody
  */
  async confirmIcpIntention(pobj, actionBody) {
    if (!actionBody.intentionBizId) {
      return system.getResult(null, "actionBody.intentionBizId can not be empty，100395");
    }
    var reqUrl = this.centerOrderUrl + "action/need/springBoard";
    var result = await this.restPostUrl(pobj, reqUrl);
    if (result.status == 0) {
      this.utilsPushSve.aliBusiness2Fq(pobj, "pushCloseNeed");
      return system.getResultSuccess();
    } else {
      return system.getResult(null, "推送失敗　100388");
    }
  }
  async queryTradeIntentionUserList(pobj) {
    // if (!pobj.actionBody.intentionBizId) {
    //   return system.getResult(null, "actionBody.intentionBizId can not be empty，100493");
    // }
    // if (!pobj.actionBody.userFeedBack) {
    //   return system.getResult(null, "actionBody.userFeedBack can not be empty，100494");
    // }
    pobj.actionBody.data = [];
    await this.queryByAli(pobj, 1);
    pobj.actionType = "getUnCreated";
    let reqUrl = this.centerOrderUrl + "action/need/springBoard";
    let result = await this.restPostUrl(pobj, reqUrl);
    if (result.status == 0) {
      pobj.actionBody = {
        type: "tmjy"
      };
      for (let item of result.data) {
        if (item.Type == 1 && item.RegisterNumber) {
          pobj.actionBody.intentionBizId = item.BizId;
          pobj.actionBody.mobile = item.Mobile ? item.Mobile : "";
          //pobj.actionBody.Area = item.Area || "北京"
          pobj.actionBody.area = '大陆地区 '
          pobj.actionBody.userName = item.UserName ? item.UserName : "";
          pobj.actionBody.description = item.RegisterNumber
          pobj.notes = `${item.RegisterNumber ? "RegisterNumber:" + item.RegisterNumber : ""}${item.Classification ? "Classification:" + item.Classification : ""}`;
          let res = await this.submitNeed(JSON.parse(JSON.stringify(pobj)), { intentionBizId: item.BizId });
          console.log(res)
        }
      }
      return system.getResultSuccess();
    } else {
      return system.getResultFail(result.status, result.msg);
    }
    return system.getResultFail(res.status, res.msg);
  }
  async queryByAli(pobj, page) {
    let res = await this.aliclient.reqbyget({
      action: "QueryTradeIntentionUserList", reqbody: {
        Begin: pobj.actionBody.Begin ? pobj.actionBody.Begin : "",
        End: pobj.actionBody.End ? pobj.actionBody.End : "",
        PageNum: page,
        PageSize: 10,
      }, apiVersion: "2019-05-08"
    });
    if (res.status == 0) {
      pobj.actionBody.data.push(...res.data.Data);
      if (page < res.data.TotalPageNum) {
        await this.queryByAli(pobj, page + 1)
      }
    }
  }

  // 2020 0914 lin 新增 刷单一条龙服务
  async needBatchUpload(pobj, actionBody) {
    var BizIds = "";
    var demands = [];
    // 声明两个数组 用来走后四步用
    var npobj = [];
    var spobj = [];
    // 遍历生成阿里需求 并把bizId 填充进数组
    for (var i = 0; i < actionBody.demands.length; i++) {
      // 第一步 
      // 地区转换
      var area = this.areaChange(actionBody.demands[i].area)
      // SubmitIcpIntention需要的类型转换ICP许可证 = 5/EDI许可证 = 7
      var bizType = this.bizTypeChange(actionBody.demands[i].type)
      // 声明调用4.1需要的参数
      var obj = {
        Mobile: actionBody.demands[i].contactMobile,// 手机号
        UserName: actionBody.demands[i].contactName,// 用户名
        Description: actionBody.demands[i].description,
        Area: area,
        BizType: bizType,
        Channel: "gsb",
        Token: "gsb",
      }
      // 4.1 提交阿里需求
      // 2020 0924 lin 修改 reqbyget 为 reqbyLTget
      var aliResult = await this.aliclient.reqbyLTget({ action: "SubmitIcpIntention", reqbody: obj, apiVersion: "2019-05-08" });
      console.log("needBatchUpload-aliResult", aliResult)
      // 整合前端需要的数据1
      BizIds += aliResult.data.BizId + ",";
      npobj.push({
        "intentionBizId": aliResult.data.BizId,
        "type": this.bizTypeChange(actionBody.demands[i].type),
        "description": actionBody.demands[i].description,
        "mobile": actionBody.demands[i].contactMobile
      })
      spobj.push({
        "needNo": aliResult.data.BizId,//渠道需求号
        "solutionContent": {
          // submitIcpProgramme需要的类型转换 ICP许可证 = icpsq/EDI许可证 = edisq
          "bizType": actionBody.demands[i].type,//产品类型 icpsq  edisq
          "solution": {
            // "IcpType":1,//方案类型 不传默认1 1:icp 2: edi 参数无效
            "CompanyName": actionBody.demands[i].companyName,
            "CompanyAddress": actionBody.demands[i].companyAddress,
            "Area": actionBody.demands[i].area + "（渠道）",
            "Note": actionBody.demands[i].description
          }
        }
      })
      if (aliResult.status != 0) {
        // 统计失败次数
      }
    }
    // 判断数据是否符合 执行后四步 的条件
    if (npobj.length != actionBody.demands.length || spobj.length != actionBody.demands.length) {
      return system.getResultFail(-5018, "提交阿里需求失败");
    }
    // 睡3秒 意义：等待阿里异步分配成功。如果不等待则提交方案会失败 无法生成支付链接，需求状态错误
    await this.sleep(3000)
    // 遍历 执行后面步骤 创建企服需求单（提交方案需要）。提交方案。需求沟通提交
    for (var i = 0; i < actionBody.demands.length; i++) {
      // 第二步
      // 创建企服通需求单
      var objString1 = JSON.stringify(pobj);
      var obj1 = JSON.parse(objString1);
      obj1.actionBody = npobj[i];
      var opResult = await this.submitNeed(obj1, obj1.actionBody);
      console.log("needBatchUpload-opResult", opResult)
      // 第三步 
      // 提交Icp注册方案
      // 程序执行比异步分配需求快，所以写成两个循环
      var objString2 = JSON.stringify(pobj);
      var obj2 = JSON.parse(objString2);
      obj2.actionType = "submitIcpProgramme";
      obj2.actionBody = spobj[i];
      var subRes = await this.qcCenterOrderSve.submitIcpProgramme(obj2);
      console.log("----------------------------------start");
      console.log("needBatchUpload-res", subRes)
      console.log("----------------------------------end");
      // 第四步
      // 需求沟通记录接口
      var writeRes = await this.writeCommunicationLog({ actionBody: { intentionBizId: npobj[i].intentionBizId, note: "测试反馈" } });
      console.log("needBatchUpload-writeRes", writeRes)
      // 整合前端需要的数据2
      demands.push({
        uniqueCode: actionBody.demands[i].uniqueCode,
        demandCode: npobj[i].intentionBizId
      })
    }
    // 第五步 用户需求确认
    // 首先切割掉BizId最后一位 是，
    BizIds = BizIds.substr(0, BizIds.length - 1);
    // 2020 0924 lin 修改 reqbyget 为 reqbyLTget
    var aliConfirmResult = await this.aliclient.reqbyLTget({ action: "ConfirmIcpIntention", reqbody: { BizIds: BizIds }, apiVersion: "2019-05-08" });
    console.log("needBatchUpload-aliConfirmResult", aliConfirmResult)
    // 获取链接失败
    if (aliConfirmResult.status != 0) {
      return system.getResultFail(-5018, "confirmIcpIntention fail");
    }
    var res = {
      paymentLink: aliConfirmResult.data.ConfirmUrl,
      batchNumber: actionBody.batchNumber,
      demands: demands
    }
    // 2020 0916 lin 新增返回格式 成功status为1 因为queue判断成功请求的条件为status1
    return system.getResultRedisQueueSuccess(res);
  }
  async testsymq(pobj) {
    var a = null;
    try {
      a = await this.utilsPushSve.aliBusiness2Delivery(pobj.actionBody, pobj.actionBody.pushtype);
      return system.getResultSuccess(a);
    } catch (error) {
      return system.getResultSuccess(error);
    }

  }

  areaChange(area) {
    switch (area) {
      case "北京":
        return "1";
      case "上海":
        return "2"
      case "福建":
        return "3"
      case "广西":
        return "4"
      case "广东":
        return "5"
      case "安徽":
        return "6"
      case "河南":
        return "7"
      case "湖北":
        return "8"
      case "浙江":
        return "9"
      case "江苏":
        return "10"
      case "山东":
        return "11"
      case "陕西":
        return "12"
      case "宁夏":
        return "13"
      case "甘肃":
        return "14"
      case "新疆":
        return "15"
      case "青海":
        return "16"
      case "天津":
        return "17"
      case "重庆":
        return "18"
      case "河北":
        return "19"
      case "山西":
        return "20"
      case "辽宁":
        return "21"
      case "吉林":
        return "22"
      case "黑龙江":
        return "23"
      case "江西":
        return "24"
      case "湖南":
        return "25"
      case "四川":
        return "26"
      case "贵州":
        return "27"
      case "云南":
        return "28"
      case "内蒙古":
        return "29"
      case "西藏":
        return "30"
      case "含外资":
        return "31"
      case "全外资":
        return "32"
      case "香港":
        return "33"
      case "海南":
        return "34"
      default:
        return "35"
    }
  }
  // 2020 1012 lin 新增 针对网文的地区转换。转换根据是栋源1012 11：22钉钉发来的
  wangwenAreaChange(area) {
    switch (area) {
      case "110000":
        return "北京市";
      case "120000":
        return "天津市"
      case "130000":
        return "河北省"
      case "140000":
        return "山西省"
      case "150000":
        return "内蒙古自治区"
      case "210000":
        return "辽宁省"
      case "220000":
        return "吉林省"
      case "230000":
        return "黑龙江省"
      case "310000":
        return "上海市"
      case "320000":
        return "江苏省"
      case "330000":
        return "浙江省"
      case "340000":
        return "安徽省"
      case "350000":
        return "福建省"
      case "360000":
        return "江西省"
      case "370000":
        return "山东省"
      case "410000":
        return "河南省"
      case "420000":
        return "湖北省"
      case "430000":
        return "湖南省"
      case "440000":
        return "广东省"
      case "450000":
        return "广西壮族自治区"
      case "460000":
        return "海南省"
      case "500000":
        return "重庆市"
      case "510000":
        return "四川省"
      case "520000":
        return "贵州省"
      case "530000":
        return "云南省"
      case "540000":
        return "西藏自治区"
      case "610000":
        return "陕西省"
      case "620000":
        return "甘肃省"
      case "630000":
        return "青海省"
      case "640000":
        return "宁夏回族自治区"
      case "650000":
        return "新疆维吾尔自治区"
      // case "全外资":
      //   return "32"
      // case "香港":
      //   return "33"
      // case "海南":
      //   return "34"
      // default:
      //   return "35"
    }
  }
  bizTypeChange(bizType) {
    switch (bizType) {
      case "ICP许可证":
        return "5"
      case "EDI许可证":
        return "7"
    }
  }
  needBizTypeChange(type) {
    switch (type) {
      case "ICP许可证":
        return "icpsq"
      case "EDI许可证":
        return "edisq"
    }
  }

  sleep(t) {
    return new Promise(res => setTimeout(res, t))
  }

  urlSplit(url) {
    var arr = url.split("?");           //根据？跟个url
    var arr2 = arr[1].split("&");         //根据&重新分割参数
    var jsonarr = {};                    //定义一个json对象放置url  参数
    for (var i = 0; i < arr2.length; i++) {   //循环将参数放到json里面
      jsonarr[arr2[i].substring(0, 1)] = arr2[i].substring(2, 3);
    }
    return jsonarr;
  }

  // async test() {
  //   var aliConfirmResult = await this.aliclient.reqbyget({ action: "ConfirmIcpIntention", reqbody: {BizIds:"20200916170117000001,20200916170117000002,20200916170117000003,20200916170118000001,20200916170118000002,20200916170118000003,20200916170119000001,20200916170119000002,20200916170120000001,20200916170120000002,20200916170120000003,20200916170121000001,20200916170121000002,20200916170121000003,20200916170122000001,20200916170122000002,20200916170122000003,20200916170123000001,20200916170123000002"}, apiVersion: "2019-05-08" });
  //   console.log("needBatchUpload-aliConfirmResult",aliConfirmResult)
  // }
  // async test1() {

  //   var a = await this.aliclient.reqbyget({ action: "CloseIntention", reqbody: { BizId: "20200416125415000001", Note: "测试需求关闭" }, apiVersion: "2019-05-08" });
  //   console.log(a.data);
  //   return a;
  // }

  /**
  * 2020 0925 lin 新增 阿里文网文 服务商侧提供接口2.1 提交用户需求给服务商
  * @param {*} pobj
  * @param {*} actionBody
  */
  async submitNeedAliEsp(pobj, actionBody) {
    var obj = {
      "intentionBizId": actionBody.intentionBizId,
      "type": actionBody.type,
      "description": actionBody.description,
      "mobile": actionBody.mobile
    }
    var res = await this.submitNeed(pobj, obj);
    if (res.status == 0) {
      return system.getResultSuccess(res.data);
    }
    return system.getResult(null, res)
  }

  /**
  * 2020 0926 lin 新增 阿里文网文 服务商侧提供接口2.2 关闭需求通知服务商
  * @param {*} pobj
  * @param {*} actionBody
  */
  async needCloseAliEsp(pobj, actionBody) {
    var obj = {
      "intentionBizId": actionBody.intentionBizId,
      "mobile": actionBody.mobile
    }
    pobj.actionType = "needClose";
    var res = await this.needClose(pobj, obj);
    if (res.status == 0) {
      return system.getResultSuccess(res.data);
    }
    return system.getResult(null, res)
  }

  /**
  * 2020 0926 lin 新增 阿里文网文 服务商侧提供接口2.3 服务单通知服务商
  * @param {*} pobj
  * @param {*} actionBody
  */
  async produceNoticeAliEsp(req, pobj, actionBody) {
    switch (actionBody.operationType) {
      case "USER_PAY_PRODUCE":
        // 修改需求，方案 订单状态
        // 第一步查处需求单 原因 询价/创建 需要商品数据 用户数据
        pobj.actionBody.needNo = pobj.actionBody.intentionBizId
        pobj.actionType = "getItemByChannelNeedNo";
        var url = this.centerOrderUrl + "action/need/springBoard";
        var needInfoResult = await this.restPostUrl(pobj, url);
        if (needInfoResult.status != 0) {
          return system.getResult(null, "needInfo is empty");
        }
        // 第二部 询价
        // 询价前县查出方案
        pobj.actionBody.channelSolutionNo = pobj.actionBody.solutionBizId;
        pobj.actionType = "getProgrammeInfoByChannelSolutionNo";
        var url = settings.centerOrderUrl() + "action/icapi/springBoard";
        var solutionrtn = await this.execClient.execPost(pobj, url);
        if (!solutionrtn || !solutionrtn.stdout) {
          return system.getResultFail(-5011, "方案查询失败");
        }
        var solutiondata = JSON.parse(solutionrtn.stdout);
        if (solutiondata.status != 0) {
          return system.getResultFail(-5011, "方案查询失败");
        }
        if (!solutiondata.data) {
          return system.getResultFail(-5012, "方案查询数据为空");
        }
        if (solutiondata.data && solutiondata.data.channelNeedNo) {
          pobj.actionBody.needId = solutiondata.data.channelNeedNo;
        }
        // 具体询价操作
        // 城市 明天需要国旗存一下 这里也要询价 2020 1017 已存
        pobj.actionBody.city = solutiondata.data.solutionContent.solution.solutionCity;
        // pobj.actionBody.city = needInfoResult.data.city
        pobj.actionBody.channelItemCode = needInfoResult.data.channelTypeCode;
        pobj.actionBody.pathCode = "/zzfw/wangwen/";// 写死 needInfo不支持
        pobj.actionType = "getProductPrice";
        var url = settings.centerAppUrl() + "action/opProduct/springBoard";
        var productPriceResult = await this.restPostUrl(pobj, url);
        if (productPriceResult.status != 0) {
          return system.getResult(null, "productPrice is empty");
        }
        // 获取userpin 为什么在这里获取？原因：getWay获取不到手机号 再去调用其他接口浪费资源
        pobj.actionType = "getLoginByUserName";
        pobj.actionBody.channelUserId = needInfoResult.data.publishMobile; // 即：86_18512345678
        pobj.actionBody.userName = needInfoResult.data.publishMobile;
        pobj.actionBody.mobile = needInfoResult.data.publishMobile;
        // pobj.actionBody.userpin = pobj.actionBody.userpin || this.getUUID();//采用jwt方式封装userpin
        var tmpOpResult = await this.utilsAuthSve.getLoginByUserName(req, pobj, pobj.actionBody);
        if (tmpOpResult.status != 0) {
          return system.getResult(null, "创建用户信息失败");
        }
        pobj.userInfo = {
          channel_userid: needInfoResult.data.publishMobile,
          channel_username: needInfoResult.data.publishMobile,
          mobile: needInfoResult.data.publishMobile
        }
        // 第三步 走addOrder流程
        // var pobjStr = JSON.stringify(pobj);
        // var qobj = JSON.parse(pobjStr);
        // qobj.actionBody =  {
        //   "bizId": actionBody.bizId,
        //   "userName": needInfoResult.data.publishName,
        //   "mobile": needInfoResult.data.publishMobile,
        //   "price": qobj.Price,
        //   "channelItemCode":needInfoResult.data.channelTypeCode,
        //   "payCode": productPriceResult.data.payCode,
        //   "quantity":1,
        //   "totalSum": productPriceResult.data.price,
        //   "payTotalSum": productPriceResult.data.Price,
        //   "channelOrder":{
        //     "channelServiceNo": actionBody.bizId,
        //     "channelOrderNo": actionBody.bizId
        //   }
        // }
        // qobj.actionType = "getProductDetail";
        // var url = settings.centerAppUrl() + "action/opProduct/springBoard";
        // var productItemResult = await this.restPostUrl(qobj, url);
        // if (productItemResult.status != 0) {
        //   return productItemResult;
        // }
        // qobj.actionBody.product_info = productItemResult.data;
        // var verifyResult = await this.utilsOrderSve.isOrderVerify(qobj, qobj.actionBody);
        // if (verifyResult.status != 0) {
        //   return verifyResult;
        // }
        // qobj.actionType = "getProductInterface";
        // qobj.actionBody.product_id = qobj.actionBody.product_info.id;
        // var productItemInterfaceResult = await this.restPostUrl(qobj, url);
        // qobj.actionBody.product_info.interface_info = productItemInterfaceResult.data;

        // qobj.actionType = "addOrder";
        // var reqUrl = this.centerOrderUrl + "action/order/springBoard";
        // qobj.actionBody.channelOrder.orderStatus = 2;// 2作为orderinfo的orderStatus的值。含义为已付款
        // var result = await this.restPostUrl(qobj, reqUrl);
        pobj.actionBody.bizId = actionBody.bizId;
        pobj.actionBody.userName = needInfoResult.data.publishName;
        pobj.actionBody.mobile = needInfoResult.data.publishMobile;
        pobj.actionBody.orderNo = actionBody.bizId;
        pobj.actionBody.totalSum = productPriceResult.data.price;
        pobj.actionBody.orderPrice = productPriceResult.data.price;
        pobj.actionBody.payTotalSum = productPriceResult.data.price;
        pobj.actionBody.price = productPriceResult.data.price;
        pobj.actionBody.payCode = productPriceResult.data.payCode;
        pobj.actionBody.channelItemCode = needInfoResult.data.channelTypeCode;
        pobj.actionBody.channelNeedNo = needInfoResult.data.channelNeedNo;
        pobj.actionBody.needNo = needInfoResult.data.needNo;
        pobj.actionBody.quantity = 1;
        pobj.actionBody.channelOrder = {
          channelServiceNo: actionBody.bizId,
          channelOrderNo: actionBody.bizId,
          orderStatus: 2
        }
        var orderrtn = await this.utilsOrderSve.addOrder(pobj, pobj.actionBody);
        console.log("orderrtn---------------start");
        console.log(orderrtn)
        console.log("orderrtn---------------end")
        if (orderrtn.status != 0 && orderrtn.status != -1) {
          return system.getResultFail(-5012, "订单创建失败");
        }
        if (orderrtn.data) {
          pobj.actionBody.orderNo = orderrtn.data.orderNo;
        }
        // 2020 1017 lin 新增更新方案状态/价格/订单号
        pobj.actionType = "receiveSolutionPayInfo";
        var url = settings.centerOrderUrl() + "action/icapi/springBoard";
        var solutionrtn = await this.execClient.execPost(pobj, url);
        if (!solutionrtn || !solutionrtn.stdout) {
          return system.getResultFail(-5011, "方案查询失败");
        }
        var solutiondata = JSON.parse(solutionrtn.stdout);
        if (solutiondata.status != 0) {
          return system.getResultFail(-5011, "方案查询失败");
        }
        if (!solutiondata.data) {
          return system.getResultFail(-5012, "方案查询数据为空");
        }
        // 第四步 整合推送参数 并推送

        var fqobj = {
          actionBody: {
            area: needInfoResult.data.city,
            city: needInfoResult.data.city,
            regType: "esp.wangwen",//1
            orderNo: actionBody.bizId,
            orderPrice: Number(pobj.actionBody.orderPrice / 100),
            phone: needInfoResult.data.publishMobile,
            needId: solutiondata.data.channelNeedNo,
            companyName: solutiondata.data.solutionContent.solution.CompanyName || ''//1
          },
          appInfo: pobj.appInfo
        }
        var deliveryObj = {
          actionBody: {
            // 2020 1019 lin 修改 orderrtn.data.orderNo 为 pobj.actionBody.orderNo
            // 2020 1020 lin 修改 pobj.actionBody.orderNo 为 orderrtn.data.channelOrderNo
            orderNo: orderrtn.data.channelOrderNo,//pobj.actionBody.channelOrder.channelOrderNo,
            needsolution: solutiondata.data.solutionContent,
            channelNeedNo: solutiondata.data.channelNeedNo,
            channelSolutionNo: solutiondata.data.channelSolutionNo,
            skuCode: productPriceResult.data.payCode,
            servicer: {
              code: 'gsb',
              name: '公司宝'
            }
          },
          appInfo: pobj.appInfo
        }
        this.utilsPushSve.aliBusiness2Fq(fqobj, "pushOrderICPBusiness");
        this.utilsPushSve.aliBusiness2Delivery(deliveryObj, "pushDeliveryOrder");
        break;
      case "USER_CONFIRM_PRODUCE":
        break;
      case "USER_REFUSE_PRODUCE":
        break;
      case "ABC_CLOSE_PRODUCE":
        break;
      case "USER_UPLOAD_PRODUCE":
        break;
      default:
        return system.getResult(null, "operationType参数错误");
    }
    return getResultSuccess(orderrtn);
  }

  // 2020 0927 lin 新增 edi状态更新
  async ediNotify(pobj, actionBody) {
    // 如果状态为USER_UPLOAD_PRODUCE需要转换url
    if (actionBody.operationType == "USER_UPLOAD_PRODUCE") {
      if (actionBody.extInfo) {
        // businessLicense:['business_license/12195411 61213057/1599115976393/p08xo9frgzj.png']
        // idCardList:[' ["card/1219541161213057/1599115980036/s1nn3sozulo.png"] ']
        // 注意idCardList 是二维数组 需要再转换一下 不知道为什么
        var extJson = JSON.parse(actionBody.extInfo);
        var businessLicenseArr = [];
        if (extJson.idCardList) {
          // 抽出数组
          var idCardListA = extJson.idCardList;
          var idCardListArr = [];
          for (var i = 0; i < idCardListA.length; i++) {
            idCardListArr.push(await this.opDownFileInfo(idCardListA[i]));
          }
        }
        for (var i = 0; i < extJson.businessLicense.length; i++) {
          businessLicenseArr.push(await this.opDownFileInfo(extJson.businessLicense[i]));
        }
        actionBody.extInfo = {
          businessLicenseArr,
          idCardListArr
        }
        // 2020 1020 lin 新增 因为下面receiveEdiStatusNotify ，JSON.parse(ab.extInfo);
        // rejectReason需要转换 否则驳回理由处可能有问题
        actionBody.extInfo = JSON.stringify(actionBody.extInfo)
        console.log(actionBody.extInfo)
      }
    }
    var self = this;
    actionBody.BizId = actionBody.bizId;
    pobj.actionType = "receiveEdiStatusNotify";
    var url = settings.centerOrderUrl() + "action/ediApi/springBoard";
    var rtn = await this.restPostUrl(pobj, url);
    if (rtn.status) {
      return rtn;
    }
    // 只有上传材料才在这里推送，produceNoticeAliEsp不做关于材料上传的推送
    if ((actionBody.operationType == "USER_UPLOAD_PRODUCE") && rtn.data) {
      var deliveryObj = {
        actionBody: {
          // 2020 1020 lin 新增 orderNo也要改为p开头的订单号 想想怎么做 在receiveEdiStatusNotify查询了order。把channelOrderNo返回了
          orderNo: rtn.data.channelOrderNo,//pobj.actionBody.channelOrder.channelOrderNo,
          needsolution: rtn.data.solutionContent,
          channelNeedNo: rtn.data.channelNeedNo,
          channelSolutionNo: rtn.data.channelSolutionNo,
          servicer: {
            code: 'gsb',
            name: '公司宝'
          }
        },
        appInfo: pobj.appInfo
      }
      console.log(deliveryObj)
      this.utilsPushSve.aliBusiness2Delivery(deliveryObj, "pushDeliveryOrder");
    }
    if (rtn.status == 0 && actionBody.operationType != "USER_PAY_PRODUCE" && actionBody.operationType != "USER_UPLOAD_PRODUCE" && rtn.data) {
      console.log("pushDeliveryStatusNotify start ------")
      var tmpObj = {
        actionBody: {
          orderNo: rtn.data.channelOrderNo,
          channelNeedNo: rtn.data.channelNeedNo,
          needsolution: rtn.data.solutionContent
        },
        appInfo: pobj.appInfo
      }
      console.log(tmpObj)
      var res = await this.utilsPushSve.aliBusiness2Delivery(tmpObj, "pushDeliveryStatusNotify");
      console.log("res")
      console.log(res);
      console.log("pushDeliveryStatusNotify end ------")
      pobj.actionBody.orderNo = rtn.data.orderNo;
      if (actionBody.operationType == "ABC_CLOSE_PRODUCE") {
        var orderrtn = await self.utilsOrderSve.delOrder(pobj, pobj.actionBody);
        if (orderrtn.status < 0) {
          return system.getResultFail(-5022, "订单关闭失败");
        }
        tmpObj.actionBody.orderNo = rtn.data.channelSolutionNo;
        self.utilsPushSve.aliBusiness2Fq(tmpObj, "pushOrderICPClose");
      }
    }//通知更新状态
    return rtn;
  }

  /**
  * 2020 0928 lin 新增 阿里文网文 服务商侧提供接口2.4 ⽤户⽅案反馈通知服务商
  * @param {*} pobj
  * @param {*} actionBody
  */
  async soulutionFeebackAliEsp(pobj, actionBody) {
    // 待定
    // solutionBizId
    // note
    if (actionBody.operateType == "INVALID") {
      var url = settings.centerOrderUrl() + "action/ediApi/springBoard";
      var rtn = await this.restPostUrl(pobj, url);
    }
    return rtn
  }

  //-----------接入百度ICP------start--------zhuangbing----2020.10.22----------------------
  /**
    * 提交需求
    * @param {*} pobj
    * @param {*} actionBody
    */
  async submitNeed2(pobj, actionBody) {
    // if (actionBody.type == "esp.wangwen" || actionBody.type == "esp.food") {
    //   actionBody.area = this.wangwenAreaChange(actionBody.area)
    // }
    if (!actionBody.intentionBizId) {
      return system.getResult(null, "actionBody.intentionBizId can not be empty，100380");
    }
    var sobj = pobj;
    sobj.actionType = "getProductTypeInfo";
    var url = settings.centerAppUrl() + "action/opProduct/springBoard";
    var rtn = await this.execClient.execPost(sobj, url);
    if (!rtn || !rtn.stdout) {
      return system.getResultFail(-5015, "需求類型查询失败");
    }
    var data = JSON.parse(rtn.stdout);
    if (data.status != 0) {
      return system.getResultFail(-5015, "需求類型查询失败");
    }
    pobj.actionBody.type_code = data.data.type_code;
    pobj.actionBody.type_name = data.data.type_name;
    pobj.actionBody.channel_type_code = data.data.channel_type_code;
    pobj.actionBody.channel_type_name = data.data.channel_type_name;
    pobj.actionBody.type = pobj.actionBody.channel_type_code;
    if (pobj.actionBody.channel_type_code == 5) {
      pobj.actionBody.type = "baidu.icp";
    } else if (pobj.actionBody.channel_type_code == 7) {
      pobj.actionBody.type = "baidu.edi";
    } else if (pobj.actionBody.channel_type_code == "NC") {
      pobj.actionBody.type = "baidu.wangwen";
    } else if (pobj.actionBody.channel_type_code == "RT") {
      pobj.actionBody.type = "baidu.radiotv";
    }
    if (pobj.actionBody.description && pobj.actionBody.description.indexOf("备#") < 0) {
      pobj.actionBody.level = "A";
    } else {
      // var levelurl = "http://106.13.228.212:8000/recProbability";
      // var levelresult = await this.restPostUrl({ intentionBizId: pobj.actionBody.intentionBizId, type: pobj.actionBody.type, note: pobj.actionBody.description }, levelurl);
      // if (levelresult.status == 0) {
      //   pobj.actionBody.level = levelresult.data.level;
      //   pobj.actionBody.probability = levelresult.data.per;
      // } else {
      //   pobj.actionBody.level = "C"
      // }
      pobj.actionBody.level = "C"
    }

    if (pobj.actionBody.phone == "17319425791") {
      pobj.actionBody.level = "F";
    }

    pobj.actionType = "submitNeed";
    var reqUrl = this.centerOrderUrl + "action/need/springBoard";
    var result = await this.restPostUrl(pobj, reqUrl);
    if (result.status == 0) {
      if (pobj.actionBody.channel_type_code == "esp.companyreg") {
        // this.utilsPushSve.aliBusiness2Fq(pobj, "pushNeedBusiness");
      } else {
        var reqParams = {
          actionBody: pobj.actionBody,
          appInfo: pobj.appInfo
        }
        // this.utilsPushSve.baiduBusiness2Delivery(reqParams, "addChance");

        pobj.actionBody.description = pobj.actionBody.description + "   成交概率：" + pobj.actionBody.level
        if (pobj.actionBody.probability) {
          pobj.actionBody.description = pobj.actionBody.description + "（" + pobj.actionBody.probability + "） "
        }
        pobj.actionBody.idempotentId = pobj.actionBody.intentionBizId;
        pobj.actionBody.idempotentSource = pobj.actionBody.type;
        pobj.actionBody.customerName = pobj.actionBody.userName;
        this.utilsPushSve.baiduBusiness2Fq(pobj, "pushNeedICPBusinessNew");
      }
    }
    return result;
  }
  //状态更新
  async icpNotifyNew(pobj) {
    var actionBody = pobj.actionBody;
    var self = this;
    if (actionBody.isDirectBuy && actionBody.isDirectBuy == 1) {
      actionBody.bizId = actionBody.orderNo
    }
    if (!actionBody.bizId) {
      return system.getResult(null, "actionBody.bizId can not be empty，100495");
    }
    actionBody.BizId = actionBody.bizId;
    if (!actionBody.status) {
      return system.getResult(null, "actionBody.status can not be empty，100495");
    }
    pobj.actionType = "receiveOrderStatusNotify";
    var url = settings.centerOrderUrl() + "action/qcapi/springBoard";
    var rtn = await this.restPostUrl(pobj, url);
    if (actionBody.status == 2) {
      var deliveryObj = {
        actionBody: {
          orderNo: rtn.data.orderNo,//pobj.actionBody.channelOrder.channelOrderNo,
          needsolution: rtn.data.solutionContent,
          channelNeedNo: rtn.data.channelNeedNo,
          channelSolutionNo: rtn.data.channelSolutionNo,
          servicer: {
            code: 'gsb',
            name: '公司宝'
          }
        },
        appInfo: pobj.appInfo
      }
      this.utilsPushSve.baiduBusiness2Delivery(deliveryObj, "pushDeliveryOrder");
    }
    if (rtn.status == 0 && actionBody.status != 1 && actionBody.status != 2 && rtn.data) {
      var tmpObj = {
        actionBody: {
          orderNo: rtn.data.orderNo,
          channelNeedNo: rtn.data.channelNeedNo,
          needsolution: rtn.data.solutionContent
        },
        appInfo: pobj.appInfo
      }
      this.utilsPushSve.baiduBusiness2Delivery(tmpObj, "pushDeliveryStatusNotify");
      pobj.actionBody.orderNo = rtn.data.orderNo;
      if (actionBody.status == 11) {
        var orderrtn = await self.utilsOrderSve.delOrder(pobj, pobj.actionBody);
        if (orderrtn.status < 0) {
          return system.getResultFail(-5022, "订单关闭失败");
        }
        tmpObj.actionBody.orderNo = rtn.data.channelSolutionNo;
        self.utilsPushSve.baiduBusiness2Fq(tmpObj, "pushOrderICPClose");
      }
    }//通知更新状态
    return rtn;
  }
  //关闭icp订单
  async icpOrderClose(pobj) {
    var actionBody = pobj.actionBody;
    var self = this;
    var url = settings.centerOrderUrl() + "action/qcapi/springBoard";
    var rtn = await this.restPostUrl(pobj, url);
    if (rtn.status == 0 && rtn.data) {
      var channelOrderNo = pobj.actionBody.orderNo;
      pobj.actionBody.orderNo = rtn.data.orderNo;
      pobj.actionType="delOrder";
      var orderrtn = await self.utilsOrderSve.delOrder(pobj, actionBody);
      if (orderrtn.status < 0) {
        return system.getResultFail(-5022, "订单关闭失败");
      }
      var tmpObj = {
        actionBody: {
          orderNo: rtn.data.orderNo,
          channelNeedNo: rtn.data.channelNeedNo,
          needsolution: rtn.data.solutionContent
        },
        appInfo: pobj.appInfo
      }
      this.utilsPushSve.baiduBusiness2Delivery(tmpObj, "pushDeliveryStatusNotify");
      // tmpObj.actionBody.orderNo = channelOrderNo;
      var tmpObj2 = {
        actionBody: {
          orderNo: channelOrderNo,
          channelNeedNo: rtn.data.channelNeedNo,
          needsolution: rtn.data.solutionContent
        },
        appInfo: pobj.appInfo
      };
      self.utilsPushSve.baiduBusiness2Fq(tmpObj2, "pushOrderICPClose");
    }//通知更新状态
    return rtn;
  }
  //-----------接入百度ICP------end----------------------------------
}

module.exports = UtilsNeedService;

// var a=new UtilsNeedService();
// a.queryExpertApplyCommunicationLogs({actionBody:{intentionBizId:"20200805103324000001",userFeedBack:true}});
// // var a=new UtilsNeedService();
// a.writeCommunicationLog({actionBody:{intentionBizId:"20200804200124000001",note:"测试反馈"}});

// var a=new UtilsNeedService();
// a.needCloseIcp({actionBody:{channelNeedNo:20200804200124000001,note:"ceshifankui"}},{channelNeedNo:20200803095203000001,note:"ceshifankui"});

// var a = new UtilsNeedService();
// a.queryTradeIntentionUserList({ actionBody: { intentionBizId: "20200803095203000001", userFeedBack: true } });

// var a = new UtilsNeedService();
// a.test();

// var a = new UtilsNeedService();
// a.ediNotify(null, {
//   operationType:'USER_UPLOAD_PRODUCE',
//   extInfo:"{\"businessLicense\":[\"https://companyreg-wangwen.oss-cn-shanghai.aliyuncs.com/business_license/1219541161213057/1603184928383/xk8suu62qo.jpg?Expires=1603193934&OSSAccessKeyId=hObpgEXoca42qH3V&Signature=BtHNsjWCN0Eqp2OQWwim8J62eWA%3D&response-content-disposition=fileName%3D%E8%90%A5%E4%B8%9A%E6%89%A7%E7%85%A7%3B\"],\"idCardList\":[\"https://companyreg-wangwen.oss-cn-shanghai.aliyuncs.com/card/1219541161213057/1603184933494/0m5epfgzhg79.jpg?Expires=1603193934&OSSAccessKeyId=hObpgEXoca42qH3V&Signature=5w%2FhkZuJ%2BxR5J9nC4QzkhqcrKy4%3D&response-content-disposition=fileName%3D%E7%9B%B8%E5%85%B3%E4%BA%BA%E5%91%98%E8%BA%AB%E4%BB%BD%E8%AF%81%3B\"]}"
// })
