const system = require("../../../system");
var settings = require("../../../../config/settings");
const querystring = require('querystring');
const AppServiceBase = require("../../app.base");
//订单操作类
class UtilsOpOrderService extends AppServiceBase {
  constructor() {
    super();
    this.centerOrderUrl = settings.centerOrderUrl();
    this.utilsPushSve = system.getObject("service.utilsSve.utilsPushSve");
  }

  async updateContacts(pobj, actionBody) {//修改联系人
    if (!actionBody.orderNo) {
      return system.getResult(null, "actionBody.orderNo can not be empty，100310");
    }
    var reqUrl = this.centerOrderUrl + "opaction/opOrder/springBoard";
    var result = await this.restPostUrl(pobj, reqUrl);
    if (result.status != 0) {
      result.data = null;
      return result;
    }
    if (result.data.orderStatus == 2) {
      this.opUpdatePushInfo(result, pobj, actionBody, "pushUpdateOrderContacts");
    }//状态为付款的订单进行推送   
    result.data = null;
    return result;
  }
  async updateTmOrder(pobj, actionBody) {//修改商标信息
    if (!actionBody.orderNo) {
      return system.getResult(null, "actionBody.orderNo can not be empty，100320");
    }
    var reqUrl = this.centerOrderUrl + "opaction/opOrder/springBoard";
    var result = await this.restPostUrl(pobj, reqUrl);
    if (result.status != 0) {
      result.data = null;
      return result;
    }
    if (result.data.orderStatus == 2) {
      this.opUpdatePushInfo(result, pobj, "pushUpdateOrder");
      if (pobj.actionBody.apply) {
        pobj.actionBody.apply.gzwtsUrl = result.data.gzwtsUrl;
        this.opUpdatePushInfo(result, pobj, "updateAliTmApplicant");
      }//ali 只做申请人信息修改
    }//状态为付款的订单进行推送
    result.data = null;
    return result;
  }
  async opUpdatePushInfo(result, pobj, opType) {//操作商标信息修改推送的操作－本类内部使用
    if (result.status == 0 && result.data.orderStatus < 4) {
      result.data.appInfo = {
        uapp_id: pobj.appInfo.uapp_id,
        uapp_key: pobj.appInfo.uapp_key,
        app_code: pobj.appInfo.app_code,
        app_name: pobj.appInfo.app_name
      };
      result.data.userInfo = {
        channel_userid: pobj.userInfo.channel_userid,
        channel_username: pobj.userInfo.channel_username,
        channel_nickname: pobj.userInfo.channel_nickname
      };
      var tmpPobj = {
        appInfo: pobj.appInfo,
        actionBody: result.data
      }
      this.utilsPushSve.pushBusInfo(tmpPobj, opType, 1);
    }
  }

  async tmConfirm(pobj, actionBody) {//商标方案确认
    if (!actionBody.orderNo) {
      return system.getResult(null, "actionBody.orderNo can not be empty，100025");
    }
    var reqUrl = this.centerOrderUrl + "action/order/springBoard";
    var result = await this.restPostUrl(pobj, reqUrl);
    if (result && result.status == 0 && result.data) {
      this.pushTmConfirm(result, pobj, actionBody);//推送方案确认信息
      return system.getResultSuccess();
    }
    return result;
  }
  async pushTmConfirm(result, pobj, actionBody) {//推送方案确认信息
    var orderdelivery = result.data;
    var deliveryContent = orderdelivery.deliveryContent;
    if (deliveryContent) {
      var pushObj = {//推送参数
        serviceNo: deliveryContent.serviceNo,
        isConfirm: actionBody.isConfirm,
        channelCode: deliveryContent.channelCode,
        notes: actionBody.notes || "",
        appInfo: pobj.appInfo
      };
      var tmpPobj = {
        appInfo: pobj.appInfo,
        actionBody: pushObj
      }
      //获取产品详情
      var getProductDetailUrl = settings.centerAppUrl() + "action/opProduct/springBoard";
      var getProductDetailObj = {
        "actionType": "getProductDetail",
        "appInfo": pobj.appInfo,
        "actionBody": { "channelItemCode": deliveryContent.itemCode }
      };
      var productItemResult = await this.restPostUrl(getProductDetailObj, getProductDetailUrl);
      if (productItemResult.status != 0) {
        return productItemResult;
      }
      tmpPobj.actionBody.product_info = productItemResult.data;
      tmpPobj.actionBody.product_id = tmpPobj.actionBody.product_info.id;
      //获取推送接口并推送
      var pushInterfaceResult = await this.getOpInterfaceByProductId(pobj.appInfo, tmpPobj.actionBody.product_id);
      if (pushInterfaceResult.status == 0) {
        tmpPobj.actionBody.product_info.interface_info = pushInterfaceResult.data;
        this.utilsPushSve.pushBusInfo(tmpPobj, "pushOpSolution", 1);
      }
    }
  }
}
module.exports = UtilsOpOrderService;
