const system = require("../../../system");
var settings = require("../../../../config/settings");
const querystring = require('querystring');
const AppServiceBase = require("../../app.base");
const axios = require('axios')
const md5 = require('md5')
class UtilsOrderService extends AppServiceBase {
  constructor() {
    super();
    this.utilsPushSve = system.getObject("service.utilsSve.utilsPushSve");
    this.utilsFqAliyunSve = system.getObject("service.utilsSve.utilsFqAliyunSve");
    this.logCtl = system.getObject("service.common.oplogSve");
    this.centerOrderUrl = settings.centerOrderUrl();
    this.qifuPayAfterH5JumpUrl = settings.qifuPayAfterH5JumpUrl();
    this.qifuPayAfterPcJumpUrl = settings.qifuPayAfterPcJumpUrl();
    this.qifuH5PayNotifyUrl = settings.qifuH5PayNotifyUrl();
    this.centerAppUrl = settings.centerAppUrl();
    this.centerAppPayUrl = settings.centerAppUrl() + "payment/paymentApi/springBoard";
    this.paySecret = settings.paySecret()
    this.utils360Sve = system.getObject("service.utilsSve.utils360Sve");
  };
  /*
* 订单验证
*/
  async isOrderVerify(pobj, actionBody) {
    var price_list = actionBody.product_info.price_list;
    if (!price_list) {
      return system.getResult(null, "产品价格列表信息有误，100040");
    }
    var productIndex = price_list.findIndex(f => f.pay_code == actionBody.payCode && f.is_show == 1);
    if (productIndex < 0) {
      return system.getResult(null, "支付价格payCode信息有误，100050");
    }
    var totalSum = Number(price_list[productIndex].price) * Number(actionBody.quantity);
    var additionsIndex = -1;
    if (actionBody.additions && actionBody.additions.payCode) {
      additionsIndex = price_list.findIndex(f => f.pay_code == actionBody.additions.payCode && f.is_show == 0);
      if (additionsIndex >= 0) {
        totalSum = totalSum + Number(price_list[additionsIndex].price) * Number(actionBody.additions.quantity);
      }
    }
    var buyTotalSum = Number(actionBody.totalSum || 0);
    var buyPayTotalSum = Number(actionBody.payTotalSum || 0);
    if (buyTotalSum == 0) {
      actionBody.totalSum = totalSum;
    }
    if (buyPayTotalSum == 0) {
      actionBody.payTotalSum = totalSum;
    }
    console.log("buyTotalSum", buyTotalSum)
    console.log("totalSum", totalSum)
   // if (buyTotalSum < totalSum) {
   //   return system.getResult(null, "订单金额有误，100060");
   // }
    let tmpPriceList = [];
    pobj.actionBody.product_info.price_item = price_list[productIndex];
    tmpPriceList.push(pobj.actionBody.product_info.price_item);
    if (additionsIndex >= 0) {
      pobj.actionBody.product_info.price_additions_item = price_list[additionsIndex];
      tmpPriceList.push(pobj.actionBody.product_info.price_additions_item);
    }
    pobj.actionBody.product_info.price_list = tmpPriceList;
    return system.getResultSuccess();
  }
  /**
   * 创建订单
   * @param {*} pobj
   * @param {*} actionBody {channelItemCode:渠道产品的编码，id:定价id,quantity:订单数量,totalSum:300}
   */
  async addOrder(pobj, actionBody) {
    if (!actionBody.channelItemCode) {
      return system.getResult(null, "产品编码有误，100010");
    }
    if (!actionBody.payCode) {
      return system.getResult(null, "支付价格payCode不能为空，100020");
    }
    if (!actionBody.quantity || Number(actionBody.quantity) <= 0) {
      return system.getResult(null, "订单数量为空或有误，100030");
    }
    pobj.actionType = "getProductDetail";
    var url = settings.centerAppUrl() + "action/opProduct/springBoard";
    var productItemResult = await this.execPostByTimeOut(null, pobj, url);
    if (productItemResult.status != 0) {
      return productItemResult;
    }
    if (productItemResult.data.status != 0) {
      return productItemResult.data;
    }
    pobj.actionBody.product_info = productItemResult.data.data;
    var verifyResult = await this.isOrderVerify(pobj, pobj.actionBody);
    if (verifyResult.status != 0) {
      return verifyResult;
    }
    pobj.actionType = "getProductInterface";
    pobj.actionBody.product_id = pobj.actionBody.product_info.id;
    var productItemInterfaceResult = await this.execPostByTimeOut(null, pobj, url);
    pobj.actionBody.product_info.interface_info = productItemInterfaceResult.data.data;

    pobj.actionType = "addOrder";
    var reqUrl = this.centerOrderUrl + "action/order/springBoard";
    // console.log(pobj);
    var result = await this.execPostByTimeOut(null, pobj, reqUrl);
    if (result.status != 0) {
      return result;
    }
    if (result.data.status != 0) {
      return result.data;
    }
    result.data.totalSum = actionBody.totalSum;
    return result.data;
  }
  async delOrder(pobj, actionBody) {
    if (!actionBody.orderNo) {
      return system.getResult(null, "actionBody.orderNo can not be empty，100025");
    }
    var reqUrl = this.centerOrderUrl + "action/order/springBoard";
    var result = await this.restPostUrl(pobj, reqUrl);
    return result;
  }

  //reg关闭订单2020-12-20
  async delOrders(pobj, actionBody) {
    if (!actionBody.orderNo) {
      return system.getResult(null, "actionBody.orderNo can not be empty，100025");
    }
    var reqUrl = this.centerOrderUrl + "action/order/springBoard";
    var result = await this.restPostUrl(pobj, reqUrl);
    return result;
  }
  async getOrderInfo(pobj, actionBody) {
    var reqUrl = this.centerOrderUrl + "action/order/springBoard";
    var result = await this.restPostUrl(pobj, reqUrl);
    return result;
  }
  async getOrderDetails(pobj, actionBody) {
    var reqUrl = this.centerOrderUrl + "action/order/springBoard";
    var result = await this.restPostUrl(pobj, reqUrl);
    return result;
  }
  async getOrderDeliveryInfo(pobj, actionBody) {
    if (!actionBody.orderNo) {
      return system.getResult(null, "actionBody.orderNo can not be empty，100290");
    }
    var reqUrl = this.centerOrderUrl + "action/order/springBoard";
    var result = await this.restPostUrl(pobj, reqUrl);
    return result;
  }
  async getOrderDeliveryFlowInfo(pobj, actionBody) {
    if (!actionBody.sourceOrderNo) {
      return system.getResult(null, "actionBody.sourceOrderNo can not be empty，100300");
    }
    var reqUrl = this.centerOrderUrl + "action/order/springBoard";
    var result = await this.restPostUrl(pobj, reqUrl);
    return result;
  }
  async getOrderDeliveryFlowList(pobj, actionBody) {
    if (!actionBody.sourceOrderNoList) {
      return system.getResult(null, "actionBody.sourceOrderNoList can not be empty，100070");
    }
    if (actionBody.sourceOrderNoList.length == 0) {
      return system.getResult(null, "actionBody.sourceOrderNoList length can not be empty，100080");
    }
    var reqUrl = this.centerOrderUrl + "action/order/springBoard";
    var result = await this.restPostUrl(pobj, reqUrl);
    return result;
  }
  async getOrderLogInfo(pobj, actionBody) {
    if (!actionBody.sourceOrderNo) {
      return system.getResult(null, "actionBody.sourceOrderNo can not be empty，100090");
    }
    var reqUrl = this.centerOrderUrl + "action/order/springBoard";
    var result = await this.restPostUrl(pobj, reqUrl);
    return result;
  }
  async icOrderStatusNotify(pobj, actionBody) {
    if (!actionBody.orderNo) {
      return system.getResult(null, "actionBody.orderNo can not be empty，100100");
    }
    var reqUrl = this.centerOrderUrl + "notifyaction/oporder/springBoard";
    var result = await this.restPostUrl(pobj, reqUrl);
    return result;
  }
  /**
   * 获取H5支付地址
   * @param {*} pobj
   * @param {*} actionBody
   */
  async getH5PayUrl(pobj, actionBody) {
    if (!actionBody.orderNo) {
      return system.getResult(null, "actionBody.orderNo can not be empty，100110");
    }
    pobj.actionType = "getPayOrderInfo";
    var orderUrl = settings.centerOrderUrl() + "action/order/springBoard";
    var orderResult = await this.restPostUrl(pobj, orderUrl);
    if (orderResult.status != 0) {
      return orderResult;
    }
    pobj.actionBody.body_desc = orderResult.data.orderProduct.channelItemName;
    pobj.actionBody.total_fee = Number(orderResult.data.receiptVoucher.totalSum) * 100;
    pobj.actionBody.order_num = orderResult.data.receiptVoucher.sourceOrderNo;
    pobj.actionBody.returl = orderResult.data.orderProduct.payAfterJumpH5Url || this.qifuPayAfterH5JumpUrl;
    pobj.actionBody.notify_url = this.qifuH5PayNotifyUrl;
    pobj.actionType = "getH5PayUrl";

    var result = await this.restPostUrl(pobj, this.centerAppPayUrl);
    if (result.status != 0) {
      return result;
    }
    await this.cacheManager["TlPayLocker"].init(orderResult.data.receiptVoucher.sourceOrderNo);
    return result;
  }
  /**
   * 获取二维码
   * @param {*} pobj
   * @param {*} actionBody {orderNo:XXXX,opType:"wx"}---"wx":"微信","alipay":"支付宝"
   */
  async getOrderQrCode(pobj, actionBody) {
    if (!actionBody.orderNo) {
      return system.getResult(null, "actionBody.orderNo can not be empty，100120");
    }
    pobj.actionType = "getPayOrderInfo";
    var orderUrl = settings.centerOrderUrl() + "action/order/springBoard";
    var orderResult = await this.restPostUrl(pobj, orderUrl);
    if (orderResult.status != 0) {
      return orderResult;
    }
    //查询支付流水号是否已经支付
    var receiptVoucher = orderResult.data.receiptVoucher;
    pobj.actionType = "queryOrderStatus";
    var url = this.centerAppUrl + "payment/paymentApi/springBoard";
    if (receiptVoucher.busPayOrderCode != receiptVoucher.wxPayOrderCode) {
      pobj.actionBody.trxid = receiptVoucher.wxPayOrderCode;
      var wxPayStatus = await this.restPostUrl(pobj, url);
      if (wxPayStatus && wxPayStatus.status == 0 && wxPayStatus.data.trxstatus == "0000") {
        return system.getResultFail(-100130, "订单已支付，请勿重复付款，100130");
      }
    }
    if (receiptVoucher.busPayOrderCode != receiptVoucher.aliPayOrderCode) {
      pobj.actionBody.trxid = receiptVoucher.aliPayOrderCode;
      var aliPayStatus = await this.restPostUrl(pobj, url);
      if (aliPayStatus && aliPayStatus.status == 0 && aliPayStatus.data.trxstatus == "0000") {
        return system.getResultFail(-100140, "订单已支付，请勿重复付款，100140");
      }
    }

    // pobj.actionBody.body_desc, pobj.actionBody.total_fee, pobj.actionBody.order_num, pobj.actionBody.op_type
    pobj.actionBody.body_desc = orderResult.data.orderProduct.channelItemName;
    pobj.actionBody.total_fee = Number(receiptVoucher.totalSum) * 100;
    pobj.actionBody.order_num = receiptVoucher.sourceOrderNo;
    pobj.actionBody.op_type = actionBody.opType;
    pobj.actionType = "getOrderQrCode";

    var result = await this.restPostUrl(pobj, this.centerAppPayUrl);
    if (result.status != 0) {
      return result;
    }
    //更新DB付款信息
    var isPut = 0;
    var setField = {};
    if (actionBody.opType == "wx") {
      if (actionBody.trxid != receiptVoucher.wxPayOrderCode) {
        setField.wxPayOrderCode = result.data.trxid;
        receiptVoucher.wxPayOrderCode = result.data.trxid;
        isPut = 1;
      }
    } else {
      //支付宝
      if (actionBody.trxid != receiptVoucher.aliPayOrderCode) {
        setField.aliPayOrderCode = result.data.trxid;
        receiptVoucher.aliPayOrderCode = result.data.trxid;
        isPut = 1;
      }
    }
    pobj.actionBody.isPut = isPut;
    pobj.actionBody.setField = setField;
    pobj.actionBody.receiptVoucherId = receiptVoucher.id;
    pobj.actionBody.trxid = result.data.trxid;
    pobj.actionType = "putReceiptVoucherInfo";
    var putOrderResult = await this.restPostUrl(pobj, orderUrl);
    if (putOrderResult.status != 0) {
      return putOrderResult;
    }
    if (isPut > 0) {
      await this.cacheManager["TlPayLocker"].init(receiptVoucher.sourceOrderNo);
    }
    result.wxPayOrderCode = receiptVoucher.wxPayOrderCode;
    result.aliPayOrderCode = receiptVoucher.aliPayOrderCode;
    return result;
  }
  /**
   * 查询订单状态
   * @param {*} pobj
   * @param {*} actionBody {orderNo:XXXX,opType:"wx"}---"wx":"微信","alipay":"支付宝"
   */
  async queryOrderStatus(pobj, actionBody) {
    if (!actionBody.orderNo) {
      return system.getResult(null, "actionBody.orderNo can not be empty，100150");
    }
    if (!actionBody.opType) {
      return system.getResult(null, "actionBody.opType can not be empty，100160");
    }
    pobj.actionType = "getPayOrderInfo";
    var orderUrl = settings.centerOrderUrl() + "action/order/springBoard";
    var orderResult = await this.restPostUrl(pobj, orderUrl);
    if (orderResult.status != 0) {
      return orderResult;
    }
    //检查流水号是否已经支付
    var receiptVoucher = orderResult.data.receiptVoucher;
    var payTrxid = actionBody.opType == "wx" ? receiptVoucher.wxPayOrderCode : receiptVoucher.aliPayOrderCode;
    pobj.actionBody.trxid = payTrxid;
    pobj.actionType = "queryOrderStatus";

    var payStatus = await this.restPostUrl(pobj, this.centerAppPayUrl);

    if (payStatus.data && payStatus.data.trxstatus == "0000") {
      //TODO:处理支付成功的业务逻辑
      payStatus.data.out_trade_no = receiptVoucher.sourceOrderNo;
      this.opPayStatusSuccess(payStatus.data, pobj.appInfo, null);
      // return system.getResultFail(-100130,'订单已支付，请勿重复付款，100130')
      return system.getResultSuccess(payStatus.data, '订单已支付，请勿重复付款，100130');
    }
    else if (payStatus.data && payStatus.data.trxstatus == "3045") {
      return system.getResultFail(-100170, "超时未支付，请刷新页面，100170");
    }
    return system.getResultFail(-100180, "请及时支付，100180");
  }
  async opPayStatusSuccess(parmas, appInfo, client_ip) { //操作回调业务逻辑---查询支付状态为已支付时进行调用
    try {
      //日志记录
      this.logCtl.info({
        optitle: (new Date()).Format("yyyy-MM-dd hh:mm:ss") + "回调处理订单参数：，method=opPayStatusSuccess",
        op: "service/impl/utilsSve/utilsOrderSve.js/opPayStatusSuccess",
        content: JSON.stringify(parmas),
        clientIp: client_ip || ""
      });
      //获取充值业务锁
      // await this.cacheManager["TlPayLocker"].init(parmas.out_trade_no);//---测试时放开
      var locker = await this.cacheManager["TlPayLocker"].enter(parmas.out_trade_no);
      if (!locker || locker != "1") {
        this.logCtl.info({
          appid: appInfo.uapp_id,
          appkey: appInfo.uapp_key,
          op: "service/impl/utilsSve/utilsOrderSve.js/opPayStatusSuccess",
          content: "参数=" + JSON.stringify(parmas),
          clientIp: parmas.client_ip || "",
          optitle: "通联回调操作频繁---太频繁了，太频繁了"
        });
        return system.getResultFail(-200, "回调操作频繁---太频繁了，太频繁了");
      }
      if (parmas.trxcode == "VSP501") {
        parmas.pay_type = "wx";
      } else {
        parmas.pay_type = "alipay";
      }
      parmas.appInfo = appInfo;
      parmas.orderNo = parmas.out_trade_no;
      //修改并返回订单支付状态，创建收款单
      var url = this.centerOrderUrl + "opaction/opPayOrder/receivePayCallBackNotify";
      var opResult = await this.restPostUrl(parmas, url);
      if (opResult.status == 0) {
        opResult.data.appInfo = {
          uapp_id: appInfo.uapp_id,
          uapp_key: appInfo.uapp_key,
          app_code: appInfo.app_code,
          contact_mobile: appInfo.contact_mobile
        };
        opResult.data.userInfo = {
          channel_userid: opResult.data.order_info.channelUserId,
          channel_username: opResult.data.order_info.channelUserId,
          channel_nickname: opResult.data.order_info.channelUserId
        };
        var pobj = {
          appInfo: opResult.data.appInfo,
          actionBody: opResult.data
        }
        // this.utilsPushSve.pushBusInfo(opResult.data, "pushOrderBusiness",0);
        this.utilsPushSve.pushBusInfo(pobj, "pushOrder", 0);
      }
      opResult.data = null;
      return opResult;

    } catch (e) {
      await this.cacheManager["TlPayLocker"].release(parmas.out_trade_no);
      this.logCtl.error({
        optitle: "回调处理订单---error异常",
        op: "center-app/app/base/service/impl/utilsSve/utilstlbankSve.js/opPayStatusSuccess",
        content: "参数=" + JSON.stringify(parmas) + "，error：" + e.stack,
        clientIp: client_ip || ""
      });
      return system.getResultFail(-200, e.stack);
    }
  }
  /**
   * 获取pc端支付二维码--不跟订单关联
   * @param {*} pobj
   * @param {*} actionBody
   * "actionBody": {
        "order_num": order.orderNo,
        "total_fee": Number(order.totalSum) * 100,
        "body_desc": order.itemName,
        "op_type": obj.opType
      }
   */
  async getQrCode(pobj, actionBody) {
    if (!actionBody.order_num) {
      return system.getResult(null, "actionBody.order_num can not be empty，100190");
    }
    if (!actionBody.total_fee) {
      return system.getResult(null, "actionBody.total_fee can not be empty，100200");
    }
    if (!actionBody.body_desc) {
      return system.getResult(null, "actionBody.body_desc can not be empty，100210");
    }
    if (!actionBody.op_type) {
      return system.getResult(null, "actionBody.op_type can not be empty，100220");
    }
    if (actionBody.op_type != "wx" && actionBody.op_type != "alipay") {
      return system.getResult(null, "actionBody.op_type param error，100230");
    }

    return await this.restPostUrl(pobj, this.centerAppPayUrl);
  }
  /**
   * 只是检查支付状态--不跟订单关联
   * @param {*} pobj
   * @param {*} actionBody { "trxid": payTrxid 支付流水号}
   */
  async queryOrder(pobj, actionBody) {
    if (!actionBody.trxid) {
      return system.getResult(null, "actionBody.trxid can not be empty，100240");
    }

    return await this.restPostUrl(pobj, this.centerAppPayUrl);
  }
  async receiveCallBackNotify(parmas, client_ip) {
    try {
      if (!parmas || !parmas.trxcode) {
        return system.getResult(null, "回调parmas中参数信息为空，100250");
      }
      //日志记录
      this.logCtl.info({
        optitle: (new Date()).Format("yyyy-MM-dd hh:mm:ss") + "记录回调参数：，method=" + parmas.trxcode,
        op: "service/impl/utilsSve/utilsOrderSve.js/receiveCallBackNotify",
        content: JSON.stringify(parmas),
        clientIp: client_ip || ""
      });
      var param = {
        "actionBody": { parmas: parmas },
        "client_ip": client_ip
      };
      var qftstr = await this.restClient.execPost(param, this.centerAppUrl + "payment/paymentApi/receiveCallBackNotify");
      if (!qftstr.stdout) {
        return system.getResult(null, "回调app中receiveCallBackNotify方法返回信息为空，100255");
      }
      var qftjson = JSON.parse(qftstr.stdout);
      return qftjson;
    } catch (e) {
      this.logCtl.error({
        optitle: "回调业务处理---error异常",
        op: "center-app/app/base/service/impl/utilsSve/utilstlbankSve.js/receiveCallBackNotify",
        content: "参数=" + JSON.stringify(parmas) + "，error：" + e.stack,
        clientIp: client_ip || ""
      });
      return system.getResultFail(-200, e.stack);
    }
  }

  async opBackNotify(parmas, client_ip) { //操作回调业务逻辑
    try {
      if (!parmas.uappid) {
        return system.getResult(null, "uappid参数不能为空，100260");
      }
      //日志记录
      this.logCtl.info({
        optitle: (new Date()).Format("yyyy-MM-dd hh:mm:ss") + "回调处理订单参数：，method=" + parmas.trxcode,
        op: "service/impl/utilsSve/utilsOrderSve.js/opBackNotify",
        content: JSON.stringify(parmas),
        clientIp: client_ip || ""
      });

      var url = this.centerAppUrl + "payment/paymentApi/getAppInfo";
      var opResult = await this.restPostUrl({ uappId: parmas.uappid }, url);
      if (opResult.status != 0) {
        opResult.msg = opResult.msg + "，100270";
        return opResult;
      }
      var appInfo = opResult.data;
      var resultSign = await this.verifySign(parmas, appInfo.uapp_secret);
      if (!resultSign || resultSign.status != 0) {
        return resultSign;
      }
      //获取充值业务锁
      // await this.cacheManager["TlPayLocker"].init(parmas.out_trade_no);//---测试时放开
      var locker = await this.cacheManager["TlPayLocker"].enter(parmas.out_trade_no);
      if (!locker || locker != "1") {
        this.logCtl.info({
          appid: appInfo.uapp_id,
          appkey: appInfo.uapp_key,
          op: "service/impl/utilsSve/utilsOrderSve.js/opBackNotify",
          content: "参数=" + JSON.stringify(parmas),
          clientIp: parmas.client_ip || "",
          optitle: "通联回调操作频繁---太频繁了，太频繁了"
        });
        return system.getResultFail(-200, "回调操作频繁---太频繁了，太频繁了");
      }
      if (parmas.trxcode == "VSP501") {
        parmas.pay_type = "wx";
      } else {
        parmas.pay_type = "alipay";
      }
      parmas.appInfo = appInfo;
      parmas.orderNo = parmas.out_trade_no;
      //修改并返回订单支付状态，创建收款单
      var url = this.centerOrderUrl + "opaction/opPayOrder/receivePayCallBackNotify";
      var opResult = await this.restPostUrl(parmas, url);
      if (opResult.status == 0) {
        opResult.data.appInfo = {
          uapp_id: appInfo.uapp_id,
          uapp_key: appInfo.uapp_key,
          app_code: appInfo.app_code,
          app_name: appInfo.app_name,
          contact_mobile: appInfo.contact_mobile
        };
        opResult.data.userInfo = {
          channel_userid: opResult.data.order_info.channelUserId,
          channel_username: opResult.data.order_info.channelUserId,
          channel_nickname: opResult.data.order_info.channelUserId
        };
        var pobj = {
          appInfo: opResult.data.appInfo,
          actionBody: opResult.data
        }
        // this.utilsPushSve.pushBusInfo(opResult.data, "pushOrderBusiness",0);
        this.utilsPushSve.pushBusInfo(pobj, "pushOrder", 0);
      }
      opResult.data = null;
      return opResult;

    } catch (e) {
      await this.cacheManager["TlPayLocker"].release(parmas.out_trade_no);
      this.logCtl.error({
        optitle: "回调处理订单---error异常",
        op: "center-app/app/base/service/impl/utilsSve/utilstlbankSve.js/opBackNotify",
        content: "参数=" + JSON.stringify(parmas) + "，error：" + e.stack,
        clientIp: client_ip || ""
      });
      return system.getResultFail(-200, e.stack);
    }
  }
  async opH5AliDingPayBackNotify(parmas, client_ip) { //操作回调业务逻辑
    try {
      //日志记录
      this.logCtl.info({
        optitle: (new Date()).Format("yyyy-MM-dd hh:mm:ss") + "阿里钉钉支付回调参数信息",
        op: "service/impl/utilsSve/utilsOrderSve.js/opH5AliDingPayBackNotify",
        content: JSON.stringify(parmas),
        clientIp: client_ip || ""
      });
      if (!parmas.trade_status) {
        return system.getResult(null, "trade_status参数不能为空，100470");
      }
      if (parmas.trade_status != "TRADE_FINISHED" && parmas.trade_status != "TRADE_SUCCESS") {
        return system.getResult(null, "trade_status状态有误，100473");
      }
      // 2020 0621验签操作
      var url = this.centerAppUrl + "payment/aliPayment/verifyAliPayReturnSign";
      var opResult = await this.restPostUrl(parmas, url);
      if (opResult.status != 0) {
        opResult.msg = opResult.msg + "，100480";
        return opResult;
      }
      // data:{
      //   orderNo: outTradeInfo[0],
      //   uappId: outTradeInfo[1],
      //   productId: outTradeInfo.length == 3 ? outTradeInfo[2] : 0
      //  }
      // opResult.data = {
      //   orderNo: "TM36202004191028Sgir",
      //   uappId: 36,
      //   productId: 42
      // };
      // //获取充值业务锁
      // await this.cacheManager["TlPayLocker"].init(opResult.data.orderNo);//---测试时放开
      var locker = await this.cacheManager["TlPayLocker"].enter(opResult.data.orderNo);
      if (!locker || locker != "1") {
        this.logCtl.info({
          appid: opResult.data.uappId,
          appkey: "",
          op: "service/impl/utilsSve/utilsOrderSve.js/opH5AliDingPayBackNotify",
          content: "参数=" + JSON.stringify(parmas),
          clientIp: parmas.client_ip || "",
          optitle: "阿里回调操作频繁---太频繁了，太频繁了"
        });
        return system.getResultFail(-200, "阿里回调操作频繁---太频繁了，太频繁了");
      }
      parmas.appInfo = { appInfo: { uapp_id: opResult.data.uappId } };
      parmas.orderNo = opResult.data.orderNo;
      parmas.pay_type = "alipay";
      //修改并返回订单支付状态，创建收款单
      var url = this.centerOrderUrl + "opaction/opPayOrder/receivePayCallBackNotifyByAliDing";
      var opOrderResult = await this.restPostUrl(parmas, url);
      if (opOrderResult.status != 0) {
        opOrderResult.data = null;
        return opOrderResult;
      }
      opOrderResult.data.appInfo = {
        uapp_id: opResult.data.uappId
      };
      opOrderResult.data.userInfo = {
        channel_userid: opOrderResult.data.order_info.channelUserId,
        channel_username: opOrderResult.data.order_info.channelUserId,
        channel_nickname: opOrderResult.data.order_info.channelUserId
      };
      opOrderResult.data.orderNo = opResult.data.orderNo;
      var pobj = {
        appInfo: opOrderResult.data.appInfo,
        actionBody: opOrderResult.data
      }
      this.utilsPushSve.pushBusInfo(pobj, "createAliTmApply", 1);
      opOrderResult.data = null;
      return opOrderResult;
    } catch (e) {
      await this.cacheManager["TlPayLocker"].release(parmas.out_trade_no);
      this.logCtl.error({
        optitle: "回调处理订单---error异常",
        op: "center-app/app/base/service/impl/utilsSve/utilstlbankSve.js/opBackNotify",
        content: "参数=" + JSON.stringify(parmas) + "，error：" + e.stack,
        clientIp: client_ip || ""
      });
      return system.getResultFail(-200, e.stack);
    }
  }
  async orderClose(pobj) {//阿里退款
    if (!pobj.actionBody.orderNo) {
      return system.getResult(null, "actionBody.prderNo can not be empty");
    }
    try {
      pobj.actionType = "channeldelOrder";
      await this.delOrder(pobj, pobj.actionBody);
      pobj.actionType = "updateStausByRefundOrder";
      var url = settings.centerOrderUrl() + "action/icapi/springBoard";
      await this.execClient.execPost(pobj, url);
      this.utilsPushSve.aliBusiness2Fq(pobj, "pushRefundIC");
      return system.getResultSuccess();
    } catch (e) {
      return system.getResultFail(-200, e.stack);
    }

  }

  async aliPayNotify(parmas, client_ip) { // 支付宝回调
    try {
      console.log("支付宝回调参数信息--------------------start")
      console.log(JSON.stringify(parmas))
      console.log(typeof (parmas))
      console.log(parmas.toString())
      console.log("支付宝回调参数信息--------------------end")
      //日志记录
      this.logCtl.info({
        optitle: (new Date()).Format("yyyy-MM-dd hh:mm:ss") + "支付宝回调参数信息",
        op: "service/impl/utilsSve/utilsOrderSve.js/aliPayNotify",
        content: JSON.stringify(parmas),
        //   content: parmas.toString(),
        clientIp: client_ip || ""
      });
      if (!parmas.trade_status) {
        return system.getResult(null, "trade_status参数不能为空，100470");
      }
      if (parmas.trade_status != "TRADE_FINISHED" && parmas.trade_status != "TRADE_SUCCESS") {
        return system.getResult(null, "trade_status状态有误，100473");
      }
      console.log("parmas.trade_status 校验通过--------------")
      // 2020 0621 支付宝验签接口
      var url = "https://yf-api.gongsibao.com/pay/v1/checkAliPaySign";
      let params = {
        "app": "ukgc", //应用名称 固定
        "key": "a1519e2eab53dfb909e4c32a86b2ea2b", //应用 key 固定
        "tData": parmas
      }
      var sign = JSON.stringify(params);
      // sign +=  "ab53dfb909e4c32a"
      sign += this.paySecret
      sign = md5(sign).toUpperCase()
      params.sign = sign
      console.log("准备验签名params-------------------start")
      console.log(params)
      console.log("准备验签名params-------------------end")
      // let res = await axios.post(url, params)
      // this.logCtl.info({
      //     optitle: (new Date()).Format("yyyy-MM-dd hh:mm:ss") + "支付宝回调参数验签结果",
      //     op: "service/impl/utilsSve/utilsOrderSve.js/aliPayNotify",
      //     content: JSON.stringify(res),
      //     clientIp: client_ip || ""
      // });
      // if (res.status != 0) {
      //     res.msg = res.msg + "，100480";
      //   return res;
      // }
      // 模拟验签结果
      var outTradeInfo = parmas.out_trade_no.split('-');
      console.log("模拟验签结果--------------", outTradeInfo)
      //
      var opResult = {}
      opResult.data = {
        orderNo: outTradeInfo[0],
        uappId: Number(outTradeInfo[1]),
        productId: outTradeInfo.length == 3 ? Number(outTradeInfo[2]) : 0
      }
      // 2020 07.03 lin 修改 获取app信息 推送蜂擎使用
      var url = this.centerAppUrl + "payment/paymentApi/getAppInfo";
      var appInfoResult = await this.restPostUrl({ uappId: opResult.data.uappId }, url);
      if (appInfoResult.status != 0) {
        appInfoResult.msg = appInfoResult.msg + "，100270";
        return appInfoResult;
      }
      var appInfo = appInfoResult.data;
      // 拿锁
      var locker = await this.cacheManager["TlPayLocker"].enter(opResult.data.orderNo);
      console.log("拿锁结果", locker)
      if (!locker || locker != "1") {
        this.logCtl.info({
          appid: opResult.data.uappId,
          appkey: "",
          op: "service/impl/utilsSve/utilsOrderSve.js/aliPayNotify",
          content: "参数=" + JSON.stringify(parmas),
          clientIp: parmas.client_ip || "",
          optitle: "阿里回调操作频繁---太频繁了，太频繁了"
        });
        return system.getResultFail(-200, "阿里回调操作频繁---太频繁了，太频繁了");
      }
      parmas.appInfo = { appInfo: { uapp_id: opResult.data.uappId } };
      parmas.orderNo = opResult.data.orderNo;
      parmas.pay_type = "alipay";
      //修改并返回订单支付状态，创建收款单
      // 这里修改了order_info的状态（status/paytime等）
      var url = this.centerOrderUrl + "opaction/opPayOrder/receivePayCallBackNotifyByAliDing";
      var opOrderResult = await this.restPostUrl(parmas, url);
      if (opOrderResult.status != 0) {
        opOrderResult.data = null;
        return opOrderResult;
      }
      opOrderResult.data.appInfo = {
        uapp_id: opResult.data.uappId,
        uapp_key: appInfo.uapp_key,
        app_code: appInfo.app_code,
        app_name: appInfo.app_name
      };
      opOrderResult.data.userInfo = {
        channel_userid: opOrderResult.data.order_info.channelUserId,
        channel_username: opOrderResult.data.order_info.channelUserId,
        channel_nickname: opOrderResult.data.order_info.channelUserId
      };
      opOrderResult.data.orderNo = opResult.data.orderNo;
      opOrderResult.data.order_info.pay_flow_no = parmas.trade_no;// 2020 0704 lin 新增 推送fq必填字段
      opOrderResult.data.order_info.pay_channel = "支付宝";//付款方式
      opOrderResult.data.order_info.pay_time = parmas.gmt_payment;//付款时间
      opOrderResult.data.order_info.pay_payer_bank_no = parmas.buyer_email;//付款账号
      opOrderResult.data.order_contact = opOrderResult.data.delivery_content.orderContact;
      var pobj = {
        appInfo: opOrderResult.data.appInfo,
        actionBody: opOrderResult.data
      }
      // 推送
      this.utilsPushSve.pushBusInfo(pobj, "pushOrder", 0);
      opOrderResult.data = null;
      return opOrderResult;
    } catch (e) {
      await this.cacheManager["TlPayLocker"].release(parmas.out_trade_no);
      this.logCtl.error({
        optitle: "回调处理订单---error异常",
        op: "center-app/app/base/service/impl/utilsSve/utilsOrderSve.js/aliPayNotify",
        content: "参数=" + JSON.stringify(parmas) + "，error：" + e.stack,
        clientIp: client_ip || ""
      });
      return system.getResultFail(-200, e.stack);
    }
  }


  async wxPayNotify(parmas, client_ip) { // 微信宝回调 ----暂时不用
    try {
      //日志记录
      this.logCtl.info({
        optitle: (new Date()).Format("yyyy-MM-dd hh:mm:ss") + "微信回调参数信息",
        op: "service/impl/utilsSve/utilsOrderSve.js/wxPayNotify",
        content: JSON.stringify(parmas),
        clientIp: client_ip || ""
      });
      if (!parmas.result_code) {
        return system.getResult(null, "result_code参数不能为空，100670");
      }
      if (parmas.result_code != "SUCCESS") {
        return system.getResult(null, "result_code状态有误，100673");
      }
      // 2020 0621 支付宝验签接口
      // var url = "https://yf-api.gongsibao.com/pay/v1/checkWXPaySign";
      // let params = {
      //     "app": "ukgc", //应用名称 固定
      //     "key": "a1519e2eab53dfb909e4c32a86b2ea2b", //应用 key 固定
      //     "tData" : parmas
      // }
      // var sign = JSON.stringify(params);
      // sign +=  "ab53dfb909e4c32a"
      // sign = md5(sign).toUpperCase()
      // params.sign = sign
      // let res = await axios.post(url, params)
      // this.logCtl.info({
      //     optitle: (new Date()).Format("yyyy-MM-dd hh:mm:ss") + "微信回调参数验签结果",
      //     op: "service/impl/utilsSve/utilsOrderSve.js/wxPayNotify",
      //     content: JSON.stringify(res),
      //     clientIp: client_ip || ""
      // });
      // if (res.status != 0) {
      //     res.msg = res.msg + "，100480";
      //   return res;
      // }
      // 模拟验签结果
      var outTradeInfo = parmas.out_trade_no.split('-');
      //
      var opResult = {}
      opResult.data = {
        orderNo: outTradeInfo[0],
        uappId: Number(outTradeInfo[1]),
        productId: outTradeInfo.length == 3 ? Number(outTradeInfo[2]) : 0
      }
      // 拿锁
      var locker = await this.cacheManager["TlPayLocker"].enter(opResult.data.orderNo);
      if (!locker || locker != "1") {
        this.logCtl.info({
          appid: opResult.data.uappId,
          appkey: "",
          op: "service/impl/utilsSve/utilsOrderSve.js/wxPayNotify",
          content: "参数=" + JSON.stringify(parmas),
          clientIp: parmas.client_ip || "",
          optitle: "微信回调操作频繁---太频繁了，太频繁了"
        });
        return system.getResultFail(-200, "微信回调操作频繁---太频繁了，太频繁了");
      }
      parmas.appInfo = { appInfo: { uapp_id: opResult.data.uappId } };
      parmas.orderNo = opResult.data.orderNo;
      // 注意 微信支付要写wx 不要wxpay等其他。c_order_receiptvoucher收款单的accountType会对应wx:微信"alipay":"支付宝","other":"其它"等其他方式
      parmas.pay_type = "wx";
      //修改并返回订单支付状态，创建收款单
      // 这里修改了order_info的状态（status/paytime等）
      // var url = this.centerOrderUrl + "opaction/opPayOrder/receivePayCallBackNotifyByAliDing";
      var url = this.centerOrderUrl + "opaction/opPayOrder/receivePayCallBackNotifyByWX";
      var opOrderResult = await this.restPostUrl(parmas, url);
      if (opOrderResult.status != 0) {
        opOrderResult.data = null;
        return opOrderResult;
      }
      opOrderResult.data.appInfo = {
        uapp_id: opResult.data.uappId
      };
      opOrderResult.data.userInfo = {
        channel_userid: opOrderResult.data.order_info.channelUserId,
        channel_username: opOrderResult.data.order_info.channelUserId,
        channel_nickname: opOrderResult.data.order_info.channelUserId
      };
      opOrderResult.data.orderNo = opResult.data.orderNo;
      var pobj = {
        appInfo: opOrderResult.data.appInfo,
        actionBody: opOrderResult.data
      }
      this.utilsPushSve.pushBusInfo(pobj, "createAliTmApply", 1);
      opOrderResult.data = null;
      return opOrderResult;
    } catch (e) {
      await this.cacheManager["TlPayLocker"].release(parmas.out_trade_no);
      this.logCtl.error({
        optitle: "回调处理订单---error异常",
        op: "center-app/app/base/service/impl/utilsSve/utilstlbankSve.js/opBackNotify",
        content: "参数=" + JSON.stringify(parmas) + "，error：" + e.stack,
        clientIp: client_ip || ""
      });
      return system.getResultFail(-200, e.stack);
    }
  }

  async channelPayNotify(params, client_ip) {//渠道订单支付通知
    try {
      this.logCtl.info({
        optitle: (new Date()).Format("yyyy-MM-dd hh:mm:ss") + "渠道订单支付回调参数信息",
        op: "service/impl/utilsSve/utilsOrderSve.js/channelPayNotify",
        content: JSON.stringify(params),
        clientIp: client_ip || ""
      });
      if (!params.appkey) {
        return system.getResult(null, 'appKey can be not null')
      }
      if (!params.orderNo) {
        return system.getResult(null, 'orderNo can be not null')
      }
      if (!params.payTotalSum) {
        return system.getResult(null, 'payTotalSum can be not null')
      }
      if (!params.signature) {
        return system.getResult(null, 'signature can be not null')
      }
      if (!params.payType) {
        return system.getResult(null, 'payType can be not null')
      }
      if (!params.payOrderNo) {
        return system.getResult(null, 'payOrderNo can be not null')
      }
      let url = this.centerAppUrl + 'payment/paymentApi/getAppInfoByAppKey';
      let appInfoRt = await this.restPostUrl({ appKey: params.appkey }, url);
      if (appInfoRt.status != 0) {
        appInfoRt.msg = appInfoRt.msg + "，100270";
        return appInfoRt;
      }
      let singStr = params.appkey + params.orderNo + params.payTotalSum + appInfoRt.data.uapp_secret
      let sign = md5(singStr).toUpperCase();
      if (sign != params.signature) {
        return system.getResultFail(-1, '验证签名失败')
      }
      var appInfo = appInfoRt.data;
      // 拿锁
      // var locker = await this.cacheManager["TlPayLocker"].enter(params.orderNo);
      // console.log("拿锁结果", locker)
      // if (!locker || locker != "1") {
      //   this.logCtl.info({
      //     appid: appInfoRt.data.uappId,
      //     appkey: "",
      //     op: "service/impl/utilsSve/utilsOrderSve.js/channelPayNotify",
      //     content: "参数=" + JSON.stringify(params),
      //     clientIp: params.client_ip || "",
      //     optitle: "阿里回调操作频繁---太频繁了，太频繁了"
      //   });
      //   return system.getResultFail(-200, "阿里回调操作频繁---太频繁了，太频繁了");
      // }
      params.appInfo = { uapp_id: appInfo.uapp_id };
      params.pay_type = params.payType;
      params.time_end = params.payTime;
      //修改并返回订单支付状态，创建收款单
      // 这里修改了order_info的状态（status/paytime等）
      var orderUrl = this.centerOrderUrl + "opaction/opPayOrder/receivePayCallBackNotifyByChannel";
      var opOrderResult = await this.restPostUrl(params, orderUrl);
      if (opOrderResult.status != 0) {
        opOrderResult.data = null;
        return opOrderResult;
      }
      if (!opOrderResult.data) {
        return opOrderResult;
      }
      opOrderResult.data.appInfo = {
        uapp_id: appInfo.uapp_id,
        uapp_key: appInfo.uapp_key,
        app_code: appInfo.app_code,
        app_name: appInfo.app_name,
        contact_mobile:appInfo.contact_mobile
      };
      opOrderResult.data.userInfo = {
        channel_userid: opOrderResult.data.order_info.channelUserId,
        channel_username: opOrderResult.data.order_info.channelUserId,
        channel_nickname: opOrderResult.data.order_info.channelUserId
      };
      opOrderResult.data.orderNo = params.orderNo;
      opOrderResult.data.order_info.pay_flow_no = params.trade_no || "";// 2020 0704 lin 新增 推送fq必填字段
      opOrderResult.data.order_info.pay_channel = params.payType || "";//付款方式
      opOrderResult.data.order_info.pay_time = params.payTime;//付款时间
      opOrderResult.data.order_info.pay_payer_bank_no = params.buyer_email || "";//付款账号
      opOrderResult.data.order_contact = opOrderResult.data.delivery_content.orderContact;
      var pobj = {
        appInfo: opOrderResult.data.appInfo,
        actionBody: opOrderResult.data
      }
      // 推送
      let yfRet = await this.utilsPushSve.pushBusInfo(pobj, "pushOrder", 0);
      if(yfRet.status !=0){
        return yfRet;
      }
      if (['icpsq', 'edisq'].includes(opOrderResult.data.product_info.channel_item_code)) {
        //创建方案
        pobj.salesmanInfo ={
          "salesmanId":yfRet.data.orderList[0].operator || "",
          "salesmanName":yfRet.data.orderList[0].operatorName || "",
          "salesmanMobile":yfRet.data.orderList[0].phone ||"",
          "salesmanChannelId":yfRet.data.orderList[0].channelUserId || ""
        }
        let pushRet = await this.packagingPushData(pobj);
        if (pushRet.status != 0) {
          throw new Error('推送失败')
        }
        pobj.actionBody = pushRet.data;
        this.utilsPushSve.aliBusiness2Delivery(pobj, "pushDeliveryOrder");
      }
      //订单状态 已接单 目前360在用

      if(pobj.appInfo.uapp_id == '50'){
        pobj.actionBody.orderNo = params.orderNo;
        let ApplicationStatus = 30;
        if(opOrderResult.data.product_info.channel_item_code == 'zzsbzc'){
          ApplicationStatus = 2;
        }
        if(opOrderResult.data.product_info.channel_item_code == 'fzsbzc' || opOrderResult.data.product_info.channel_item_code == 'dbsbzc'){
          ApplicationStatus = 1;
        }
        pobj.pushObj = {
          ApplicationStatus
        };
        this.utils360Sve.pushOrderStatus(pobj)
      }
      opOrderResult.data = null;
      return opOrderResult;
    } catch (e) {
      // await this.cacheManager["TlPayLocker"].release(params.orderNo);
      this.logCtl.error({
        optitle: "回调处理订单---error异常",
        op: "center-app/app/base/service/impl/utilsSve/utilsOrderSve.js/channelPayNotify",
        content: "参数=" + JSON.stringify(params) + "，error：" + e.stack,
        clientIp: client_ip || ""
      });
      return system.getResultFail(-200, e.stack);
    }
  }

  //组装推送交付系统数据
  async packagingPushData(pobj) {
    let ab = pobj.actionBody;
    pobj.actionType = 'createSolution';
    ab.bizId = ab.orderNo;
    let channelSolutionNo = await this.getBusUid("NS");
    ab.channelSolutionNo = channelSolutionNo;
    let url = this.centerOrderUrl + "action/need/springBoard"
    let solutionRet = await this.restPostUrl(pobj, url);
    if (solutionRet.status != 0) {
      return system.getResultFail(-1, '创建方案失败')
    }
    let solution = {
      "source": ab.appInfo.app_name,
      "IcpType": ab.product_info.channel_item_code,
      "actionType": "新办",
      "CompanyName": "",
      "licenseType": "",
      "solutionCity": ab.product_info.price_item.price_desc,
      "solutionPrice": Number(ab.order_info.totalSum)*100,
      "channelTypeCode": ab.product_info.service_business_code,
      "companyLocation": ab.product_info.price_item.price_desc
    }
    let needSolution = {
      "status": "USER_PAY_PRODUCE",
      "bizType": ab.product_info.channel_item_code,
      "solution": solution,
      "totalSum": Number(ab.order_info.totalSum)*100,
      "typeCode": ab.product_info.channel_item_code,
      "typeName": ab.product_info.channel_item_name,
      "statusName": "⽤户⽀付",
      "customerInfo": {
        "publishName": ab.order_contact.contactName || "",
        "publishMobile": ab.order_contact.mobile || ""
      },
      "salesmanInfo":pobj.salesmanInfo
    }
    //推送数据
    let pushObj = {
      "orderNo": ab.orderNo,
      "needsolution": needSolution,
      "channelNeedNo": "",
      "channelSolutionNo": channelSolutionNo,
      "skuCode": ab.product_info.price_item.payCode,
      "servicer": {
        "code": "gsb",
        "name": "公司宝"
      }
    };
    return system.getResultSuccess(pushObj);
  }


  async channelOrdersPayNotify(params, client_ip) {//渠道订单支付通知
    try {
      this.logCtl.info({
        optitle: (new Date()).Format("yyyy-MM-dd hh:mm:ss") + "渠道订单支付回调参数信息",
        op: "service/impl/utilsSve/utilsOrderSve.js/channelPayNotify",
        content: JSON.stringify(params),
        clientIp: client_ip || ""
      });
      if (!params.appkey) {
        return system.getResult(null, 'appKey can be not null')
      }
      if (!params.orderNo) {
        return system.getResult(null, 'orderNo can be not null')
      }
      if (!params.payTotalSum) {
        return system.getResult(null, 'payTotalSum can be not null')
      }
      if (!params.signature) {
        return system.getResult(null, 'signature can be not null')
      }
      if (!params.payType) {
        return system.getResult(null, 'payType can be not null')
      }
      if (!params.payOrderNo) {
        return system.getResult(null, 'payOrderNo can be not null')
      }
      let url = this.centerAppUrl + 'payment/paymentApi/getAppInfoByAppKey';
      let appInfoRt = await this.restPostUrl({ appKey: params.appkey }, url);
      if (appInfoRt.status != 0) {
        appInfoRt.msg = appInfoRt.msg + "，100270";
        return appInfoRt;
      }
      let singStr = params.appkey + params.orderNo + params.payTotalSum + appInfoRt.data.uapp_secret
      let sign = md5(singStr).toUpperCase();
      if (sign != params.signature) {
        return system.getResultFail(-1, '验证签名失败')
      }
      var appInfo = appInfoRt.data;
      params.appInfo = { uapp_id: appInfo.uapp_id };
      params.pay_type = params.payType;
      params.time_end = params.payTime;
      // 修改并返回订单支付状 态，创建收款单
      // 根据合同号获取所有订单 循环修改order_info 信息
      let seaUrl = this.centerOrderUrl + 'opaction/opPayOrder/getOrderListByOrderServiceNo';
      let seaRet = await this.restPostUrl(params, seaUrl);
      if (seaRet.status != 0) {
        seaRet.data = null;
        return seaRet;
      }
      let orderList = seaRet.data;
      for (let i = 0; i < orderList.length; i++) {
        params.orderNo = orderList[i].orderNo;
        // 这里修改了order_info的状态（status/paytime等）
        var orderUrl = this.centerOrderUrl + "opaction/opPayOrder/receivePayCallBackNotifyByChannel";
        var opOrderResult = await this.restPostUrl(params, orderUrl);
        if (opOrderResult.status != 0) {
          opOrderResult.data = null;
          continue;
        }
        if (!opOrderResult.data) {
          // return opOrderResult;
          continue;
        }
        opOrderResult.data.appInfo = {
          uapp_id: appInfo.uapp_id,
          uapp_key: appInfo.uapp_key,
          app_code: appInfo.app_code,
          app_name: appInfo.app_name
        };
        opOrderResult.data.userInfo = {
          channel_userid: opOrderResult.data.order_info.channelUserId,
          channel_username: opOrderResult.data.order_info.channelUserId,
          channel_nickname: opOrderResult.data.order_info.channelUserId
        };
        opOrderResult.data.orderNo = params.orderNo;
        opOrderResult.data.order_info.pay_flow_no = params.trade_no || "";// 2020 0704 lin 新增 推送fq必填字段
        opOrderResult.data.order_info.pay_channel = params.payType || "";//付款方式
        opOrderResult.data.order_info.pay_time = params.payTime;//付款时间
        opOrderResult.data.order_info.pay_payer_bank_no = params.buyer_email || "";//付款账号
        opOrderResult.data.order_contact = opOrderResult.data.delivery_content.orderContact;

        var pobj = {
          appInfo: opOrderResult.data.appInfo,
          actionBody: opOrderResult.data
        }

        // 推送
        this.utilsPushSve.pushBusInfo(pobj, "pushOrder", 0);
        // opOrderResult.data = null;
        // return opOrderResult;
      }
      return system.getResultSuccess();
    } catch (e) {
      // await this.cacheManager["TlPayLocker"].release(params.orderNo);
      this.logCtl.error({
        optitle: "回调处理订单---error异常",
        op: "center-app/app/base/service/impl/utilsSve/utilsOrderSve.js/channelPayNotify",
        content: "参数=" + JSON.stringify(params) + "，error：" + e.stack,
        clientIp: client_ip || ""
      });
      return system.getResultFail(-200, e.stack);
    }
  }


  async tmAccept(pobj) {// 2020 0828 lin 新增 ali商标交易 创建订单接口
    try {
      var actionBody = pobj.actionBody;
      // 检查商标注册号是否为上架
      pobj.actionType = "tmStatusCheck";
      pobj.actionBody.code = pobj.actionBody.registerNumber;
      var url = settings.centerTmtransactionUrl() + "tmtransaction/action/trademarktransaction/springBoard";
      var tmStatusCheckResult = await this.restPostUrl(pobj, url);
      if (!tmStatusCheckResult.data) {
        var result = {
          "errorCode": "error",
          "errorMsg": "标源状态不符合",
          "module": { "orderNumber": "" },
          "requestId": pobj.requestId,
          "success": false
        }
        return result;
      }
      if (tmStatusCheckResult.data.publish_status != "uppershelf") {
        var result = {
          "errorCode": "error",
          "errorMsg": "标源状态不符合",
          "module": { "orderNumber": "" },
          "requestId": pobj.requestId,
          "success": false
        }
        return result;
      }
      //走addOrder流程
      pobj.actionType = "getProductDetail";
      var url = settings.centerAppUrl() + "action/opProduct/springBoard";
      var productItemResult = await this.restPostUrl(pobj, url);
      if (productItemResult.status != 0) {
        return productItemResult;
      }
      productItemResult.data.price_list[0]["price"] = actionBody.price;
      pobj.actionBody.product_info = productItemResult.data;
      var verifyResult = await this.isOrderVerify(pobj, pobj.actionBody);
      if (verifyResult.status != 0) {
        return verifyResult;
      }
      pobj.actionType = "getProductInterface";
      pobj.actionBody.product_id = pobj.actionBody.product_info.id;
      var productItemInterfaceResult = await this.restPostUrl(pobj, url);
      pobj.actionBody.product_info.interface_info = productItemInterfaceResult.data;

      pobj.actionType = "addOrder";
      var reqUrl = this.centerOrderUrl + "action/order/springBoard";
      pobj.actionBody.channelOrder.orderStatus = 64;// 2020 0908 lin 新增。64作为orderinfo的orderStatus的值。含义为已付部分款
      var result = await this.restPostUrl(pobj, reqUrl);
      // 2020 0911 lin  新增 addOrder后修改标源状态
      pobj.actionType = "tmStatusUpdate";
      pobj.actionBody.tm = [{
        id: tmStatusCheckResult.data.id,
        code: tmStatusCheckResult.data.code
      }]
      pobj.actionBody.status = "lowershelf"
      var url = settings.centerTmtransactionUrl() + "tmtransaction/action/trademarktransaction/springBoard";
      var tmStatusUpdateResult = await this.restPostUrl(pobj, url);
      if (result) {
        var tmResult = {
          "errorCode": "OK",
          "errorMsg": "操作成功",
          "module": { "orderNumber": result.data.orderNo },
          "requestId": pobj.requestId,
          "success": true
        }
        console.log("utils", tmResult)
        return tmResult;
      }
    } catch (e) {
      var result = {
        "errorCode": "error",
        "errorMsg": e,
        "module": { "orderNumber": "" },
        "requestId": pobj.requestId,
        "success": false
      }
      return result;
    }
  }

  async tmRefuse(pobj) {// 2020 0828 lin 新增 ali商标交易 关闭订单接口
    try {
      var reqUrl = this.centerOrderUrl + "action/tmOrder/springBoard";
      var result = await this.restPostUrl(pobj, reqUrl);
      // 如果返回值正常
      if (result.status == 0) {
        var tmResult = {
          "errorCode": "OK",
          "errorMsg": "操作成功",
          "requestId": pobj.requestId,
          "success": true
        }
        return tmResult;
      }
      var tmResult = {
        "errorCode": "error",
        "errorMsg": result.msg,
        "requestId": pobj.requestId,
        "success": false
      }
      return tmResult;
    } catch (e) {
      var result = {
        "ErrorCode": "error",
        "ErrorMsg": e,
        "Module": { "orderNumber": "" },
        "RequestId": pobj.requestId,
        "Success": false
      }
      return result;
    }
  }

  //增加常用联系人，常用申请人
  async addUsuallyContacts(pobj, actionBody) {
    if (!actionBody.channel_user_id) {
      return system.getResultFail(-1, "渠道用户id不能为空");
    }
    if (!actionBody.contacts) {
      return system.getResultFail(-1, '用户信息不能为空')
    }
    if (Object.keys(actionBody.contacts).length < 0) {
      return system.getResultFail(-1, '用户信息不能为空')
    }
    var reqUrl = this.centerOrderUrl + "action/tmOrder/springBoard";
    var result = await this.restPostUrl(pobj, reqUrl);
    return result;
  }

  //删除常用联系人，常用申请人
  async delUsuallyContacts(pobj, actionBody) {
    if (!actionBody.id) {
      return system.getResultFail(-1, 'id不能为空')
    }
    var reqUrl = this.centerOrderUrl + "action/tmOrder/springBoard";
    var result = await this.restPostUrl(pobj, reqUrl);
    return result;
  }

  //修改常用联系人，常用申请人
  async updateUsuallyContacts(pobj, actionBody) {
    if (!actionBody.id) {
      return system.getResultFail(-1, 'id 不能为空');
    }
    if (!actionBody.channel_user_id) {
      return system.getResultFail(-1, 'id 不能为空');
    }
    if (Object.keys(actionBody.contacts).length < 0) {
      return system.getResultFail(-1, '信息不能为空');
    }
    var reqUrl = this.centerOrderUrl + "action/tmOrder/springBoard";
    var result = await this.restPostUrl(pobj, reqUrl);
    return result;
  }

  //查询常用联系人，常用申请人
  async getUsuallyContacts(pobj, actionBody) {
    if (!actionBody.channel_user_id) {
      return system.getResultFail(-1, '用户id不能为空')
    }
    var reqUrl = this.centerOrderUrl + "action/tmOrder/springBoard";
    var result = await this.restPostUrl(pobj, reqUrl);
    return result;
  }

  //创建订单 官网
  async addOrderWeb(pobj, actionBody) {
    if (!actionBody.quantity || Number(actionBody.quantity) <= 0) {
      return system.getResult(null, "订单数量为空或有误，100030");
    }
    if (!actionBody.goodsId) {
      return system.getResult(null, "官网产品id不能为空")
    }
    if (!actionBody.customerId) {
      return system.getResult(null, '客户Id不能为空')
    }
    if (actionBody.deliveryData.nclones.length <= 0) {
      return system.getResult(null, '尼斯不能为空')
    }
    if (actionBody.quantity != actionBody.deliveryData.nclones.length || Number(actionBody.quantity) != actionBody.deliveryData.nclones.length) {
      return system.getResult(null, "订单数量有误，100030");
    }
    let nclones = actionBody.deliveryData.nclones;//大项集合
    let product_item = [];//产品项
    for (let i = 0; i < nclones.length; i++) {
      let nclone = nclones[i];
      let totalSum = 300;
      if (nclone.nclThree.length > 10) {
        actionBody.additions = {
          "payCode": "zzsbzc-2", // Y 支付价格code
          "quantity": nclone.nclThree.length - 10// Y 购买数量
        }
        totalSum += (nclone.nclThree.length-10)*30
      }
      actionBody.totalSum = totalSum;
      actionBody.quantity = 1;
      actionBody.deliveryData.nclones = [nclone]
      actionBody.payTotalSum = actionBody.totalSum;
      let saveResult = await this.addOrder(pobj, actionBody);
      if (saveResult.status != 0) {
        return saveResult;
      }
      let obj = {
        idempotentId: saveResult.data.orderNo,//商标注册订单id
        nclCount: nclone.nclThree.length - 10 > 0 ? nclone.nclThree.length - 10 : 0//小项数量
      }
      product_item.push(obj);
    }
    actionBody.product_item = product_item;
    //新增订单(商标自助注册) IC
    let icOrderResult = await this.utilsFqAliyunSve.pushOrder2IC(pobj, "pushOrder2IC");
    let orderUrl = settings.centerOrderUrl() + 'action/order/springBoard';
    if (icOrderResult.status != 0) {
      for (let i = 0; i < product_item.length; i++) {
        actionBody.orderNo = product_item[i].idempotentId;
        pobj.actionType = 'delOrder';
        let rt = await this.restPostUrl(pobj, orderUrl);
      }
      return icOrderResult;
    }
    let ids = icOrderResult.data.orderList;
    let orderServiceNo = await this.getBusUid("CN");
    pobj.actionType = 'updateOrder';
    let orderNos = [];
    let orderIds = [];
    for (let i = 0; i < ids.length; i++) {
      let orderNo = ids[i].idempotentId;
      let contractNo = ids[i].contractNo;
      orderNos.push(ids[i].orderNo)
      orderIds.push(ids[i].orderId)
      actionBody.orderNo = orderNo;
      actionBody.channelServiceNo = contractNo;
      actionBody.channelOrderNo = ids[i].orderNo;
      actionBody.orderServiceNo = orderServiceNo;
      let rest = await this.restPostUrl(pobj, orderUrl);
    }
    let result = {
      orderNos,
      orderIds
    }
    return system.getResultSuccess(result)
  }

  //获取支付记录
  async getPayRecords(pobj, actionBody) {
    let url = this.centerOrderUrl + 'opaction/opPayOrder/getPayRecords';
    let result = await this.restPostUrl(pobj, url);
    return result;
  }

  //测试
  async pushTest(pobj,actionBody){
    let url = this.centerOrderUrl + "notifyaction/internalCallsNotify/updateTmStatus";
    let result = await this.restPostUrl(actionBody,url);
    return result
  }
}
module.exports = UtilsOrderService;
