const system = require("../../../system");
var settings = require("../../../../config/settings");
const querystring = require('querystring');
const AppServiceBase = require("../../app.base");
class UtilsPushService extends AppServiceBase {
  constructor() {
    super();
  };

  async aliBusiness2Delivery(pobj, opType) {//供业务调用，在代码中调用，不在db中做配置进行调用
    pobj.actionType = "getAppInterface";
    var reqUrl = settings.centerAppUrl() + "action/opProduct/springBoard";
    var productItemInterfaceResult = await this.restPostUrl(pobj, reqUrl);
    pobj.interface_info = productItemInterfaceResult.data;
    //日志记录
    this.logCtl.info({
      appid: pobj.appInfo ? pobj.appInfo.uapp_id || "" : "",
      appkey: pobj.appInfo ? pobj.appInfo.uapp_key || "" : "",
      requestId: pobj.requestId || "",
      op: "service/impl/utilsSve/utilsPushSve.js/service/app.base.js/aliBusiness2Delivery",
      content: JSON.stringify(pobj),
      resultInfo: productItemInterfaceResult.data ? JSON.stringify(productItemInterfaceResult.data) : "接口数据为空",
      optitle: opType + "推送蜂擎获取的接口信息->aliBusiness2Delivery",
    });
    if (pobj.interface_info) {
      await this.pushBusInfo(pobj, opType, 1);
      return system.getResultSuccess();
    }
    return system.getResult(null, "push Fail，interface_info　data is empty");
  }

  async business2Channel(pobj, opType) {//供业务调用，在代码中调用，不在db中做配置进行调用
    console.log("business2Channel++++++++start++++++++++");
    console.log(pobj,"business2Channel++++++++++++++++++");
    pobj.actionType = "getAppInterface";
    var reqUrl = settings.centerAppUrl() + "action/opProduct/springBoard";
    var productItemInterfaceResult = await this.restPostUrl(pobj, reqUrl);
    pobj.interface_info = productItemInterfaceResult.data;
    //日志记录
    this.logCtl.info({
      appid: pobj.appInfo ? pobj.appInfo.uapp_id || "" : "",
      appkey: pobj.appInfo ? pobj.appInfo.uapp_key || "" : "",
      requestId: pobj.requestId || "",
      op: "service/impl/utilsSve/utilsPushSve.js/service/app.base.js/business2Channel",
      content: JSON.stringify(pobj),
      resultInfo: productItemInterfaceResult.data ? JSON.stringify(productItemInterfaceResult.data) : "接口数据为空",
      optitle: opType + "推送获取的接口信息->business2Channel",
    });
    if (pobj.interface_info) {
      await this.pushBusInfo(pobj, opType, 1);
      return system.getResultSuccess();
    }
    return system.getResult(null, "push Fail，interface_info　data is empty");
  }


  async aliBusiness2Fq(pobj, opType) {//供业务调用，在代码中调用，不在db中做配置进行调用
    pobj.actionType = "getAppInterface";
    var reqUrl = settings.centerAppUrl() + "action/opProduct/springBoard";
    var productItemInterfaceResult = await this.restPostUrl(pobj, reqUrl);
    pobj.interface_info = productItemInterfaceResult.data;
    //日志记录
    this.logCtl.info({
      appid: pobj.appInfo ? pobj.appInfo.uapp_id || "" : "",
      appkey: pobj.appInfo ? pobj.appInfo.uapp_key || "" : "",
      requestId: pobj.requestId || "",
      op: "service/impl/utilsSve/utilsPushSve.js/service/app.base.js/aliBusiness2Fq",
      content: JSON.stringify(pobj),
      resultInfo: productItemInterfaceResult.data ? JSON.stringify(productItemInterfaceResult.data) : "接口数据为空",
      optitle: pobj.opType + "推送蜂擎获取的接口信息->aliBusiness2Fq",
    });
    if (pobj.interface_info) {
      await this.pushBusInfo(pobj, opType, 1);
      return system.getResultSuccess();
    }
    return system.getResult(null, "push Fail，interface_info　data is empty");
  }

  async pushBusInfo(pobj, opType, isDelProductInfo) {//推送业务总入口，不在db中做配置进行调用
    console.log(JSON.stringify(pobj), ".......pushBusInfo........................."+opType);
    var interface_list = pobj.interface_info ? pobj.interface_info : pobj.actionBody.product_info.interface_info;
    if (!interface_list) {
      return system.getResult(null, "暂无推送配置");
    }
    var interface_list_temp = interface_list.filter(f => f.op_type == opType);
    console.log(interface_list_temp,"interface_list_temp+++++++++++++++");
    if (!interface_list_temp || interface_list_temp.length == 0) {
      return system.getResult(null, "暂无【" + opType + "】的推送配置");
    }
    var self = this;
    let result;
    if (interface_list_temp && interface_list_temp.length == 1) {
      const element = interface_list_temp[0];
      let reflexActionRes = await self.reflexAction(element, opType, pobj, isDelProductInfo);
      self.execClientNew.execLogs("pushBusInfo-reflexAction-result:", pobj, "center-channel-reflexAction", reflexActionRes, null);
      return reflexActionRes;
    } else {
      for (let index = 0; index < interface_list_temp.length; index++) {
        const element = interface_list_temp[index];
        result = await self.reflexAction(element, opType, pobj, isDelProductInfo);
        self.execClientNew.execLogs("pushBusInfo-for---reflexAction-result:", pobj, "center-channel-reflexAction", result, null);
      }
      return result;
    }

  }

  async againPushBusInfo(pobj) {//再次推送业务总入口-重试
    var interface_info = pobj.interface_info ? pobj.interface_info : pobj.actionBody.product_info.interface_info;
    if (!interface_info) {
      return system.getResult(null, "暂无推送配置");
    }
    var result = await this.reflexAction(interface_info, pobj.opType, pobj, pobj.isDelProductInfo || 1);
    this.execClientNew.execLogs("againPushBusInfo-reflexAction-result:", pobj, "center-channel-reflexAction", result, null);
    if (result.status != 0) {
      return result;
    }
    return system.getResultSuccess();
  }

  async reflexAction(interface_info, opType, pobj, isDelProductInfo) {
    console.log(interface_info,"reflexAction+++++++++++++++"+opType);
    console.log(pobj,"reflexAction++++++2+++++++++"+opType);
    var refResult = null;
    pobj.interface_info = interface_info;
    pobj.opType = opType;
    pobj.isDelProductInfo = isDelProductInfo;
    try {
      if (interface_info.interface_type == "bd") {
        if (!interface_info.method_name) {
          return system.getResult(null, "产品接口参数信息有误，100350");
        }//操作的方法名称
        var invokeObj = system.getObject(interface_info.interface_url);
        if (!invokeObj[interface_info.method_name]) {
          return system.getResult(null, "产品接口参数方法信息有误，100360");
        }
        pobj.interface_params = interface_info.params;
        var params = [pobj];
        var doRes = await invokeObj[interface_info.method_name].apply(invokeObj, params);
        return doRes;
      }
      else if (interface_info.interface_type == "yc") {
        var actionBody = pobj.actionBody;
        if (!interface_info.interface_url) {
          return system.getResult(null, "产品接口interface_url参数不能为空，100370");
        }
        if (actionBody.product_info && actionBody.product_info.price_list) {
          delete actionBody.product_info["price_list"];
        }
        if (actionBody.product_info && actionBody.product_info.interface_info) {
          delete actionBody.product_info["interface_info"];
        }
        if (isDelProductInfo && isDelProductInfo == 1 && actionBody.product_info) {
          delete actionBody["product_info"];
        }//是否删除产品信息进行推送
        refResult = await this.restPostUrl(pobj.actionBody, interface_info.interface_url);
        if (refResult.code == 1) {
          refResult.status = 0
        }
        this.disposePushResult(pobj, refResult, "ycUrlPush->reflexAction->refResult", this.pushlogFailType.NEWRPC);
      }
      return system.getResultSuccess();
    } catch (e) {
      var errorResult = system.getResult(null, "送异常-->reflexAction->" + e.stack)
      return await this.disposePushResultFail(pobj, errorResult, "数据推送异常-->reflexAction-->errorResult", this.pushlogFailType.FAILLOG);
    }
  }
  //---------百度---zhuangbing--2020.10.28------start--------------------------------------------
  async baiduBusiness2Fq(pobj, opType) {//供业务调用，在代码中调用，不在db中做配置进行调用
    pobj.actionType = "getAppInterface";
    var reqUrl = settings.centerAppUrl() + "action/opProduct/springBoard";
    var productItemInterfaceResult = await this.restPostUrl(pobj, reqUrl);
    pobj.interface_info = productItemInterfaceResult.data;
    //日志记录
    this.logCtl.info({
      appid: pobj.appInfo ? pobj.appInfo.uapp_id || "" : "",
      appkey: pobj.appInfo ? pobj.appInfo.uapp_key || "" : "",
      requestId: pobj.requestId || "",
      op: "service/impl/utilsSve/utilsPushSve.js/service/app.base.js/baiduBusiness2Fq",
      content: JSON.stringify(pobj),
      resultInfo: productItemInterfaceResult.data ? JSON.stringify(productItemInterfaceResult.data) : "接口数据为空",
      optitle: pobj.opType + "推送蜂擎获取的接口信息->baiduBusiness2Fq",
      pobj:pobj
    });
    if (pobj.interface_info) {
      var pushBusInfo = await this.pushBusInfo(pobj, opType, 1);
      return system.getResultSuccess(pushBusInfo);
    }
    return system.getResult(null, "push Fail，interface_info　data is empty");
  }
  async baiduBusiness2Delivery(pobj, opType) {//供业务调用，在代码中调用，不在db中做配置进行调用
    pobj.actionType = "getAppInterface";
    var reqUrl = settings.centerAppUrl() + "action/opProduct/springBoard";
    var productItemInterfaceResult = await this.restPostUrl(pobj, reqUrl);
    pobj.interface_info = productItemInterfaceResult.data;
    console.log(pobj,"baiduBusiness2Delivery-zhuangbing------------------------------"+opType);
    console.log(productItemInterfaceResult);
    //日志记录
    this.logCtl.info({
      appid: pobj.appInfo ? pobj.appInfo.uapp_id || "" : "",
      appkey: pobj.appInfo ? pobj.appInfo.uapp_key || "" : "",
      requestId: pobj.requestId || "",
      op: "service/impl/utilsSve/utilsPushSve.js/service/app.base.js/baiduBusiness2Delivery",
      content: JSON.stringify(pobj),
      resultInfo: productItemInterfaceResult.data ? JSON.stringify(productItemInterfaceResult.data) : "接口数据为空",
      optitle: opType + "推送蜂擎获取的接口信息->baiduBusiness2Delivery",
      pobj:pobj
    });
    if (pobj.interface_info) {
      await this.pushBusInfo(pobj, opType, 1);
      return system.getResultSuccess();
    }
    return system.getResult(null, "push Fail，interface_info　data is empty");
  }
  //---------百度---zhuangbing--2020.10.28------end--------------------------------------------
}
module.exports = UtilsPushService;
