var system = require("../../../system");
var settings = require("../../../../config/settings");
const AppServiceBase = require("../../app.base");
const md5 = require('md5');
const { sign } = require("crypto");

//阿里支付类
class utils360Sve extends AppServiceBase {
  constructor() {
      super();
      this.centerAppUrl = settings.centerAppUrl();
      this.pannongServiceConfig = settings.pannongServiceConfig();
      this.utilsAuthSve = system.getObject("service.utilsSve.utilsAuthSve")
      this.pushlogSve = system.getObject("service.common.pushlogSve");
      this.utilsOrderSve = system.getObject("service.utilsSve.utilsOrderSve");
      this.utilsPushSve = system.getObject("service.utilsSve.utilsPushSve");
      this.signSve = system.getObject("service.common.signSve");
  }

  /**
  * 2020 1103 lin 磐农2.1 创建服务单
  * @param {*} pobj
  * @param {*} actionBody
  */
  async submitService(pobj, actionBody,req) {
    // 获取userpin 为什么在这里获取？原因：getWay获取不到手机号 再去调用其他接口浪费资源
    pobj.actionType = "getLoginByUserName";
    pobj.actionBody.channelUserId = actionBody.contactMobile; // 即：86_18512345678
    pobj.actionBody.userName = actionBody.contactMobile;
    pobj.actionBody.mobile = actionBody.contactMobile;
    // pobj.actionBody.userpin = pobj.actionBody.userpin || this.getUUID();//采用jwt方式封装userpin
    var tmpOpResult = await this.utilsAuthSve.getLoginByUserName(req, pobj, pobj.actionBody);
    if (tmpOpResult.status != 0) {
      return system.getResult(null, "创建用户信息失败");
    }
    pobj.userInfo = {
      channel_userid: actionBody.contactMobile,
      channel_username: actionBody.contactMobile,
      mobile: actionBody.contactMobile
    }

    // 询价
    pobj.actionBody.channelItemCode = "kjxg";
    pobj.actionBody.pathCode = "/kjfw/kjxg/";// 写死
    pobj.actionType = "getProductPrice";
    var url = settings.centerAppUrl() + "action/opProduct/springBoard";
    var productPriceResult = await this.restPostUrl(pobj, url);
    if (productPriceResult.status != 0) {
      return system.getResult(null, "productPrice is empty");
    }

    // addOrder
    pobj.actionBody.bizId = actionBody.bizId;
    pobj.actionBody.userName = actionBody.contactName;
    pobj.actionBody.mobile = actionBody.contactMobile;
    pobj.actionBody.orderNo = actionBody.bizId;
    pobj.actionBody.totalSum = productPriceResult.data.price;
    pobj.actionBody.orderPrice = productPriceResult.data.price;
    pobj.actionBody.payTotalSum = productPriceResult.data.price;
    pobj.actionBody.price = productPriceResult.data.price;
    pobj.actionBody.payCode = productPriceResult.data.payCode;
    pobj.actionBody.channelItemCode = productPriceResult.data.channelItemCode;
    pobj.actionBody.quantity = 1;
    pobj.actionBody.channelOrder = {
      channelServiceNo: actionBody.bizId,
      channelOrderNo: actionBody.bizId,
      orderStatus: 2
    }
    var orderrtn = await this.utilsOrderSve.addOrder(pobj, pobj.actionBody);
    this.logCtl.info({
      op: "service/impl/utilsSve/utilsServiceSve.js/submitService",
      content: "参数=" + JSON.stringify(pobj) + " 返回值=" + JSON.stringify(orderrtn),
      clientIp: req.client_ip || "",
      optitle: "服务单创建接口"
    });
    if (orderrtn.status != 0 && orderrtn.status != -1) {
      return system.getResultFail(-5012, "订单创建失败");
    }
    if (orderrtn.data) {
      pobj.actionBody.orderNo = orderrtn.data.orderNo;
    }

    var deliveryObj = {
      actionBody: {
        "bizId":pobj.actionBody.bizId,
        "orderNo":pobj.actionBody.orderNo,
        "contactName":pobj.actionBody.contactName,
        "contactMobile":pobj.actionBody.contactMobile,
        "timeUnit":pobj.actionBody.timeUnit,
        "quantity":pobj.actionBody.quantity,
        "companyInfo":{
         "corpName":pobj.actionBody.companyInfo.corpName,
         "taxpayerTypeEnum":pobj.actionBody.companyInfo.taxpayerTypeEnum,
         "acctgSystemId":pobj.actionBody.companyInfo.acctgSystemId,
         "enterpriseFormEnum":pobj.actionBody.companyInfo.enterpriseFormEnum,
         "taxIndustryId":pobj.actionBody.companyInfo.taxIndustryId,
         "taxNo":pobj.actionBody.companyInfo.taxNo,
         "serviceTypeEnum":pobj.actionBody.companyInfo.serviceTypeEnum,
         "taxClaimMethodEnum":pobj.actionBody.companyInfo.taxClaimMethodEnum
        }
      },
      appInfo: pobj.appInfo
    }
    // 还需要推送fq 需要提醒会计。目前没有
    this.utilsPushSve.aliBusiness2Delivery(deliveryObj, "submitService");
    return system.getResultSuccess({orderNo:pobj.actionBody.orderNo});
  }

  async notifyService(pobj, actionBody,req) {
    // 根据渠道订单号查出订单 判断订单状态是否可以变更
    pobj.actionBody.channelOrderNo = pobj.bizId;
    var sobj = {
      actionType: "getOrderByChannelOrderNo",
      actionBody: pobj.actionBody,
      appInfo: pobj.appInfo,
      userInfo: {
        channelUerId: ""// 获取不到userpin 模拟
      }
    }
    var url = settings.centerOrderUrl() + "action/order/springBoard";
    var orderInfoResult = await this.restPostUrl(sobj, url);
    if(orderInfoResult.status != 0) {
      return system.getResult(null, "order data is empty");
    }
    var orderInfo = orderInfoResult.data;
    
    // 2020 1106 lin 这里为什么要查出订单 再去修改 不直接修改？
    // 因为先暂时不做状态判断是否可以修改 后面优化
    pobj.actionBody.orderId = orderInfo.id;
    if(actionBody.status == 16) {// 2020 1106 lin 这里转换一下已关闭为16不合适 换为已作废
      var orderStatus = 32
    } else {
      var orderStatus = actionBody.status;
    }
    var sobj = {
      actionType: "updateOrderStatusById",
      actionBody: {
        orderStatus: orderStatus,
        orderId: orderInfo.id
      },
      appInfo: pobj.appInfo,
      userInfo: {
        channelUerId: ""// 获取不到userpin 模拟
      }
    }
    var url = settings.centerOrderUrl() + "action/order/springBoard";
    var orderInfoResult = await this.restPostUrl(sobj, url);
    if(orderInfoResult.status != 0) {
      return system.getResult(null, "order data is empty");
    }

    var deliveryObj = {
      actionBody: {
        "bizId": actionBody.bizId,
        "status": actionBody.status
      },
      appInfo: pobj.appInfo
    }
    if(actionBody.serviceStartTime && actionBody.serviceEndTime ) {
      deliveryObj.actionBody.serviceStartTime = actionBody.serviceStartTime,
      deliveryObj.actionBody.serviceEndTime = actionBody.serviceEndTime
    }
    this.utilsPushSve.aliBusiness2Delivery(deliveryObj, "notifyService");
    return system.getResultSuccess();

  }

  async noticeService(pobj, actionBody,req) {
    delete actionBody.appHosts
    var obj = {
      appid: this.pannongServiceConfig.appid,
      noncestr: this.getUUID(),
      timestamp: new Date().getTime(),
      body: actionBody
    }
    var signResult = await this.signSve.createSign(obj, this.pannongServiceConfig.appkey);
    if(signResult.status != 0) {
      return system.getResult(null, "create sign fail");
    }
    obj.sign = signResult.data;

    switch(pobj.actionType) {
      case "feedback":
        var url = settings.pannongUrl() + "pas-api/gsb/service/feedback";
        var result = await this.restPostUrl(obj, url);
        this.logCtl.info({
          op: "service/impl/utilsSve/utilsServiceSve.js/feedback",
          content: "参数=" + JSON.stringify(obj) + " 返回值=" + JSON.stringify(result),
          clientIp: req.client_ip || "",
          optitle: "服务单处理反馈接收接口"
        });
        return system.getResultSuccess(result);
      case "accountingInfo":
        var url = settings.pannongUrl() + "pas-api/gsb/service/accountingInfo";
        var result = await this.restPostUrl(obj, url);
        this.logCtl.info({
          op: "service/impl/utilsSve/utilsServiceSve.js/feedback",
          content: "参数=" + JSON.stringify(obj) + " 返回值=" + JSON.stringify(result),
          clientIp: req.client_ip || "",
          optitle: "回传会计信息"
        });
        return system.getResultSuccess(result);
      case "booksInfo":
        var url = settings.pannongUrl() + "pas-api/gsb/service/booksInfo";
        var result = await this.restPostUrl(obj, url);
        this.logCtl.info({
          op: "service/impl/utilsSve/utilsServiceSve.js/feedback",
          content: "参数=" + JSON.stringify(obj) + " 返回值=" + JSON.stringify(result),
          clientIp: req.client_ip || "",
          optitle: "帐套信息接受接口"
        });
        return system.getResultSuccess(result);
      default:
        return system.getResult(null, "actionType参数错误");
    }
  }
}

module.exports = utils360Sve;
