const system = require("../../../system");
var settings = require("../../../../config/settings");
const querystring = require('querystring');
const AppServiceBase = require("../../app.base");
const { or } = require("sequelize");
//订单操作类
class UtilsTmOrderCallService extends AppServiceBase {
  constructor() {
    super();
    this.aliclient = system.getObject("util.aliyunClient");
    this.centerOrderUrl = settings.centerOrderUrl();
    this.aliUappId = settings.aliUappId();
  }

  async queryTradeProduceList(pobj, actionBody) {//2020 0907 lin 新增 ali查询 用户确认资料支付尾款，并更新订单状态
    // 1查询渠道/商品为icp/edi的订单已经支付部分款的订单。
    // 这里写死 itemCode 和 订单状态
    pobj.actionBody.itemCode = "tmjy"
    // pobj.actionBody.orderStatus = 64
    pobj.actionType = "queryVOrderByOrderStatusAndItemCode";
    pobj.appInfo = {
      uapp_id: this.aliUappId
    }
    // 随便填的。因为center-order会校验if (!pobj.userInfo) {
    pobj.userInfo = {
      uapp_id: this.aliUappId
    }
    var url = this.centerOrderUrl + "action/order/springBoard";
    var orderInfoRes = await this.restPostUrl(pobj, url);
    if(orderInfoRes.status != 0) {
      return {
        status: -1,
        msg: "fail request qifu api filed",
        data: null
      }
    }
    var orderInfoList = orderInfoRes.data
    // 2查询渠道/商品为icp/edi的订单已经支付尾款的订单。
    // 3
    var obj = {
      // BuyerStatus: 11,
      // PageNum: 1,
      // PageSize: 20,
      // SortFiled: "updateTime",
      // SortOrder: "DESC",
    };
    var object = {
      action: "QueryTradeProduceList",
      reqbody: obj,
      type: 'TM'
    }
    let aliOrderList = await this.aliclient.reqbyget(object);
    if(aliOrderList.status != 0) {
      return {
        status: -1,
        msg: "fail request ali api filed",
        data: null
      }
    }
    var aliOrderInfo = aliOrderList.data.Data.TradeProduces
    // 返回值data
    var failList = [];
    var successList = []
    if(orderInfoList && aliOrderInfo) {
      for(var i = 0; i < orderInfoList.length;i++) {
        pobj.actionBody.orderId = orderInfoList[i].id;
        pobj.actionType = "updateOrderStatusById";
        var orderInfo = orderInfoList[i];
        var aliOrderIndex = aliOrderInfo.findIndex(f => f.BizId == orderInfo.channelServiceNo)
        
        console.log("------------------------------------")
        console.log(aliOrderIndex)
        console.log("------------------------------------")
        if (aliOrderIndex > -1 && aliOrderInfo[aliOrderIndex].BuyerStatus == 10) {
          // 合作方已提交转让文件 为企服orderStatus 4 服务中
          pobj.actionBody.orderStatus = 4;
          var url = this.centerOrderUrl + "action/order/springBoard";
          var orderInfoRes = await this.restPostUrl(pobj, url);
          if (orderInfoRes.status != 0) {
            failList.push(orderInfo.channelServiceNo);
          }
          successList.push({
            channelServiceNo: orderInfo.channelServiceNo,
            updateStatus: 4
          })
        }
        if (aliOrderIndex > -1 && aliOrderInfo[aliOrderIndex].BuyerStatus == 11) {
          // 已经支付尾款 为企服orderStatus 2 已付款
          pobj.actionBody.orderStatus = 2;
          var url = this.centerOrderUrl + "action/order/springBoard";
          var orderInfoRes = await this.restPostUrl(pobj, url);
          if (orderInfoRes.status != 0) {
            failList.push({
              channelServiceNo: orderInfo.channelServiceNo,
              updateStatus: 2
            });
          }
          successList.push({
            channelServiceNo: orderInfo.channelServiceNo,
            updateStatus: 2
          })
        }
        if (aliOrderIndex > -1 && (aliOrderInfo[aliOrderIndex].BuyerStatus == 40 || aliOrderInfo[aliOrderIndex].BuyerStatus == 41)) {
          // 交易成功/交易失败 为企服orderStatus 8 已完成
          pobj.actionBody.orderStatus = 8;
          var url = this.centerOrderUrl + "action/order/springBoard";
          var orderInfoRes = await this.restPostUrl(pobj, url);
          if (orderInfoRes.status != 0) {
            failList.push({
              channelServiceNo: orderInfo.channelServiceNo,
              updateStatus: 8
            });
          }
          successList.push({
            channelServiceNo: orderInfo.channelServiceNo,
            updateStatus: 8
          })
        }
      }
    }
    return {
      status: 0,
      msg: "success",
      data: {failList,successList}
    }
  }

  async createjsonfile() {
    var self = this;;
    var gobj = {
      action: "GenerateUploadFilePolicy",
      reqbody: { FileType: "PARTNER_SYNC_FILE" },
      type: 'TM'
    }
    var rst = await self.aliclient.reqbyget(gobj);
    console.log(rst);
    var obj={
      actionType:"createjsonfile",
      actionBody:{}
    }
    var getjsonurl=settings.tmtransactionUrl()+"/tmtransaction/action/trademarktransaction/springBoard"
    var jsonurl=await this.restPostUrl(obj,getjsonurl);
    if(!jsonurl){
      console.log(jsonurl);
      return system.getResultSuccess();
    }
    var upobj={
      ossurl:jsonurl.data.url,
      filedir:rst.data.FileDir,
      objectName:jsonurl.data.name,
      encodePolicy:rst.data.EncodedPolicy,
      endpoint:"http://oss-cn-beijing.aliyuncs.com",
      accessKeyId:rst.data.AccessId,
      bucketName:"partner-sync-file",
      signature:rst.data.Signature
    }

    var aliOssFileInfo = await this.execPostUrl(upobj, settings.aliossjavaUrl());
      if (aliOssFileInfo == true) {
        var fileUrl = rst.data.FileDir + "/" + jsonurl.data.name;
        console.log(fileUrl)
        return system.getResultSuccess(fileUrl);
      }

  }
}
module.exports = UtilsTmOrderCallService;

// var a=new UtilsTmOrderCallService();
// a.createjsonfile();