const crypto = require('crypto');
const sha256 = require('sha256');
const system = require("../system");
var settings = require("../../config/settings");
class baiduRegClient {
  constructor() {
    this.pushlogSve = system.getObject("service.common.pushlogSve");
    this.execClient = system.getObject("util.execClient");
    this.baiduRegClientParams = settings.baiduRegClientParams();
  }
  
  //2020 1027 laolan 调用百度网关
  async baiduPost( path, actionBody) {
    console.log('actionBody++',actionBody)
    let domain = this.baiduRegClientParams.domain;
    let url = domain+path;
    let version ="bce-auth-v1";
    let accessKey = this.baiduRegClientParams.accessKey;
    let secretKey = this.baiduRegClientParams.secretKey;
    let timestamp = new Date().toISOString()
    let site = timestamp.lastIndexOf(".");
    timestamp = timestamp.substring(0,site)+"Z"
    let signedHeaders = "host";
    let extime = 1800;
    let canonicalHeaders = "host:"+this.baiduRegClientParams.host;
    //中间结果1：规范化请求和前缀字符串
    var canonicalRequest = null
    var pathParams = path.split("?");
    if(pathParams && pathParams.length > 1){
      canonicalRequest = "POST" + "\n" + pathParams[0] + "\n" + pathParams[1] +  "\n" + canonicalHeaders;
    }else{
      canonicalRequest = "POST" + "\n" + path + "\n" + "\n" + canonicalHeaders;
    }
    // let canonicalRequest = "POST" + "\n" + path + "\n" + "\n" + canonicalHeaders;
    console.log('canonicalRequest+++++++',canonicalRequest)
    //authStringPrefix(前缀字符串，由除sk字段外的签名信息生成)
    let authStringPrefix = version+"/"+accessKey+"/"+timestamp+"/"+extime;
    //中间结果2：派生签名密钥 signingKey
    let signingKey = crypto.createHmac('sha256', secretKey)
                   .update(authStringPrefix)
                   .digest('hex');
    //中间结果3：签名摘要 signature
    let signature = crypto.createHmac('sha256', signingKey)
                   .update(canonicalRequest)
                   .digest('hex');
    //最终结果：认证字符串 authorization
    let authorization = authStringPrefix+"/"+signedHeaders+"/"+signature;
    var baiduObj={
      authorization:authorization,
      data:actionBody
    }
    var rtn = await this.execClient.execBaiduPost(baiduObj, url);
    console.log("baiduObj+++++",baiduObj)
    console.log("url+++++",url)
    console.log("rtn+++++",rtn)
    if (!rtn || !rtn.stdout) {
      return system.getResult(null, "execPost data is empty");
    }
    var result = JSON.parse(rtn.stdout);
    return result;
  }

  //百度接口 2020-10-27 laolan
  async baiduReqbyget(obj, cbk) {
    var path = obj.path;
    var reqbody = obj.reqbody;
    try {
      var res = await this.baiduPost( path, reqbody, {
        timeout: 10000, // default 3000 ms 修改3000为10000，原因ConfirmIcpIntention BizIds 超过5条会超时
        formatAction: true, // default true, format the action to Action
        formatParams: true, // default true, format the parameter name to first letter upper case
        method: 'POST', // set the http method, default is GET
        headers: {
          host:this.baiduRegClientParams.host
        }, // set the http request headers
      });
      console.log('baidu++++res+++',res)
      this.pushlogSve.createDb({
        op: "new-baiduRegReqbyget",
        content: JSON.stringify(obj),//推送的参数信息
        resultInfo: JSON.stringify(res),
        returnType: '1',
        logLevel: '1',
        opTitle: "new-baiduReqbyget推送百度信息返回成功"
      });
      return system.getResultSuccess(res);
    } catch (e) {
      this.pushlogSve.createFailLogDb({
        appid: obj.appInfo ? obj.appInfo.uapp_id || "" : "",
        appkey: obj.appInfo ? obj.appInfo.uapp_key || "" : "",
        requestId: obj.requestId || "",
        content: JSON.stringify(obj),//推送的参数信息
        resultInfo: "error:" + JSON.stringify(e),
        clientIp: obj.clientIp || "",
        failType: 1,
        opTitle: "new-baiduRegReqbyget推送百度信息返回异常",
        pushNumber: obj.pushNumber || 1
      });
      return system.getResultFail(-200, "出现异常，error：" + e.stack);
    }
  }
}
module.exports = baiduRegClient;
// var task = new baiduRegClient();
// console.log(task.baiduRegClientParams,"11111111111111111");