const Dao = require("../../dao.base");
class productDao extends Dao {
  constructor() {
    super(Dao.getModelName(productDao));
  }

  async getPage (page = 1, limit = 10, type = [1, 2], keywords) {
    let params = {
      where: { product_type: { [this.db.Op.in]: type }, source_id: 10001 },
      limit: limit,
      offset: (page - 1) * limit
    }
    if (keywords) {
      params.where.product_name = { [this.db.Op.like]: `%${keywords}%` }
    }
    return await this.model.findAndCountAll(params)
  }

  async getByIds (ids) {
    return await this.model.findAll({
      where: { id: { [this.db.Op.in]: ids }, source_id: 10001}
    })
  }

  async create (params) {
    return await this.model.create(params)
  }

  async update (params) {
    return await this.model.update(params, { where: { id: params.id } })
  }
}
module.exports = productDao;