const system = require("../system");

class Dictionary {
  constructor() {
    // 交易字典
    this.APP = {
      app_id: {"100001": "电子平台", "10000x": "xxxxxxxxxx"},
    };
    this.ACCOUNT_TRADE = {
      trade_type: {1: "交易", 2: "充值", 3: "退款"}
    };
  }

  getDict(module, field) {
    return (this[(module || "")] || {})[field] || {};
  }

  setRowName(module, row, fields, concat) {
    if(!module || !row || !fields || fields.length == 0) {
      return;
    }
    concat = concat || "_";
    for (let field of fields) {
      row[field + concat + "name"] = this.getDict(module, field)[row[field] || ""] || "";
    }
  }

  setRowsName(module, rows, fields, concat) {
    if(!module || !rows || !fields || fields.length == 0) {
      return;
    }
    for(let row of rows) {
      this.setRowName(module, row, fields, concat)
    }
  }
}

module.exports = Dictionary;
