<a name="menu">目录</a>
1. [商户签约](#merchantSign)
1. [查看签约](#signInfo)
1. [签约列表](#signList)



## **<a name="merchantSign"> 添加/修改签约</a>**
[返回到目录](#menu)
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`

``` javascript

    {
        "action_process": "test",
        "action_type": "saveMerchantSign",
        "action_body": {
            "merchantId": "11064625945481089",          // 商户id
            "nameA": "杨庆菊的主体2222",                  // 签约主体
            "contractNo": "杨庆菊录入合同2222号",          // 合同编号
            "beginDate": "2019-10-01",                  // 合同开始时间
            "endDate": "2019-10-07",                    // 合同截至时间
            "serviceRate": "332"                       // 服务费比率（例：3.32%, 这里需要传入300）
        }
    }

```

#### 返回结果
```javascript
    {
        "status": 0,
        "msg": "success"
    }

```


## **<a name="signInfo"> 查看签约</a>**
[返回到目录](#menu)
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`

``` javascript

    {
        "action_process": "test",
        "action_type": "merchantSignInfo",
        "action_body": {
            "merchantId": "11064625945481089"           // 商户ID
        }
    }

```

#### 返回结果
```javascript
    {
        "status": 0,
        "msg": "success",
        "data": {
            "merchant_id": "11064625945481089",         // 商户ID
            "merchantName": "杨庆菊的公司11编辑"           // 商户名称
            "nameA": "杨庆菊的主体2222",                  // 签约主体
            "contractNo": "杨庆菊录入合同2222号",          // 合同编号
            "beginDate": "2019-10-01",                  // 合同开始时间
            "endDate": "2019-10-07",                    // 合同截至时间
            "serviceRateShow": 3.22                     // 服务费比率显示
            "serviceRate": 322                          // 服务费比率（整数防止精度损失）
            "created_at": "2019-10-01 11:35",           // 创建时间
        },
        "requestid": "b6df9966b91f4567887a606686952fb0"
    }

```

## **<a name="signList"> 签约列表</a>**
[返回到目录](#menu)
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`

``` javascript

    {
        "action_process": "test",
        "action_type": "merchantSignList",
        "action_body": {
            "currentPage": "1",
            "pageSize": "10",
            "merchantId": "11064625945481089"           // 商户ID
        }
    }

```

#### 返回结果
```javascript
    {
    "status": 0,
    "msg": "success",
    "data": {
        "count": 1,
        "rows": [
            {
                "merchant_id": "11064625945481089",         // 商户id
                "merchantName": "杨庆菊的公司11编辑"           // 商户名称
                "nameA": "杨庆菊的主体2222",                  // 签约主体
                "contractNo": "杨庆菊录入合同2222号",          // 合同编号
                "beginDate": "2019-10-01",                  // 合同开始时间
                "endDate": "2019-10-07",                    // 合同截至时间
                "serviceRateShow": 3.22                     // 服务费比率显示
                "serviceRate": 322                          // 服务费比率（整数防止精度损失）
                "created_at": "2019-10-01 11:35",           // 创建时间
            }
        ]
    },
    "requestid": "83db094399374590b8fd5e09cf39ee9c"
}

```


