const CacheBase = require("../cache.base");
const system = require("../../system");
class MagCache extends CacheBase {
  constructor() {
    super();
    this.prefix = "magCache";
  }
  desc() {
    return "缓存管理";
  }
  prefix() {
    return "magCache:";
  }
  async buildCacheVal(cachekey, inputkey, val, ex, ...items) {
    return val;
  }
  async getCacheSmembersByKey(key) {
    return this.redisClient.smembers(key);
  }
  async delCacheBySrem(key, value) {
    return this.redisClient.srem(key, value)
  }
  async keys(p) {
    return this.redisClient.keys(p);
  }
  async get(k) {
    return this.redisClient.get(k);
  }
  async del(k) {
    return this.redisClient.delete(k);
  }
  async clearAll() {
    console.log("xxxxxxxxxxxxxxxxxxxclearAll............");
    return this.redisClient.flushall();
  }
}
module.exports = MagCache;
