var fs = require("fs");
var objsettings = require("../config/objsettings");
var settings = require("../config/settings");
class System {
	static declare(ns) {
		var ar = ns.split('.');
		var root = System;
		for (var i = 0, len = ar.length; i < len; ++i) {
			var n = ar[i];
			if (!root[n]) {
				root[n] = {};
				root = root[n];
			} else {
				root = root[n];
			}
		}
	}
	static register(key, ClassObj) {
		if (System.objTable[key] != null) {
			throw new Error("相同key的对象已经存在");
		} else {
			let obj = new ClassObj();
			System.objTable[key] = obj;
		}

		return System.objTable[key];
	}
	static getResult(data, opmsg = "操作成功", req) {
		return {
			status: !data ? -1 : 0,
			msg: opmsg,
			data: data,
			bizmsg: req && req.session && req.session.bizmsg ? req.session.bizmsg : "empty"
		};
	}
	/**
	 * 请求返回成功
	 * @param {*} data 操作成功返回的数据
	 * @param {*} okmsg 操作成功的描述
	 */
	static getResultSuccess(data, okmsg = "success") {
		return {
			status: 0,
			msg: okmsg,
			data: data,
		};
	}
	/**
	 * 请求返回失败
	 * @param {*} status 操作失败状态，默认为-1
	 * @param {*} errmsg 操作失败的描述，默认为fail
	 * @param {*} data 操作失败返回的数据
	 */
	static getResultFail(status = -1, errmsg = "fail", data = null) {
		return {
			status: status,
			msg: errmsg,
			data: data,
		};
	}
	static getObject(objpath) {
		var pathArray = objpath.split(".");
		var packageName = pathArray[0];
		var groupName = pathArray[1];
		var filename = pathArray[2];
		var classpath = "";
		if (filename) {
			classpath = objsettings[packageName] + "/" + groupName;
		} else {
			classpath = objsettings[packageName];
			filename = groupName;
		}

		var objabspath = classpath + "/" + filename + ".js";
		if (System.objTable[objabspath] != null) {
			console.log("get cached obj");
			return System.objTable[objabspath];
		} else {
			console.log("no cached...");
			var ClassObj = require(objabspath);
			return System.register(objabspath, ClassObj);
		}
	}
	static getUiConfig(appid) {
		var configPath = settings.basepath + "/app/base/db/metadata/" + appid + "/index.js";
		if (settings.env == "dev") {
			delete require.cache[configPath];
		}
		var configValue = require(configPath);
		return configValue;
	}
	static getUiConfig2(appid) {
		var configPath = settings.basepath + "/app/base/db/metadata/index.js";
		// if(settings.env=="dev"){
		// 	console.log("delete "+configPath+"cache config");
		// 	delete require.cache[configPath];
		// }
		delete require.cache[configPath];
		var configValue = require(configPath);
		return configValue[appid];
	}
	static get_client_ip(req) {
		var ip = req.headers['x-forwarded-for'] ||
			req.ip ||
			req.connection.remoteAddress ||
			req.socket.remoteAddress ||
			(req.connection.socket && req.connection.socket.remoteAddress) || '';
		var x = ip.match(/(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9])\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9]|0)\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9]|0)\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[0-9])$/);
		if (x) {
			return x[0];
		} else {
			return "localhost";
		}

	};
}
Date.prototype.Format = function (fmt) { //author: meizz
	var o = {
		"M+": this.getMonth() + 1,                 //月份
		"d+": this.getDate(),                    //日
		"h+": this.getHours(),                   //小时
		"m+": this.getMinutes(),                 //分
		"s+": this.getSeconds(),                 //秒
		"q+": Math.floor((this.getMonth() + 3) / 3), //季度
		"S": this.getMilliseconds()             //毫秒
	};
	if (/(y+)/.test(fmt))
		fmt = fmt.replace(RegExp.$1, (this.getFullYear() + "").substr(4 - RegExp.$1.length));
	for (var k in o)
		if (new RegExp("(" + k + ")").test(fmt))
			fmt = fmt.replace(RegExp.$1, (RegExp.$1.length == 1) ? (o[k]) : (("00" + o[k]).substr(("" + o[k]).length)));
	return fmt;
}
System.objTable = {};
module.exports = System;