{
    template: '${tmpl}',
        data: function() {
            var that = this;
            var validateMethod = function (rule, value, callback) {

                if (rule.field == "mobile") {
                    if (/^1[23456789]\d{9}$/.test(value) == false) {
                        return callback(new Error("请输入正确格式的手机号"));
                    } else {
                        return callback();
                    }
                }
                return callback();
            };
            return {
                input: "",
                businessType: [
                    {
                        value: 'zzzc',
                        label: '自助注册'
                    },
                    {
                        value: 'zzfzzc',
                        label: '专家辅助注册'
                    },

                ],
                DeliveryStatus: [
                    {
                        value: 'dsccl',
                        label: '待上传材料'
                    },
                    {
                        value: 'dqrfa',
                        label: '待确认方案'
                    },

                    {
                        value: 'fabtg',
                        label: '方案不通过'
                    },
                    {
                        value: 'dsh',
                        label: '待审核'
                    },
                    {
                        value: 'ddj',
                        label: '待递交'
                    },
                    {
                        value: 'ydj',
                        label: '已递交'
                    },
                    {
                        value: 'ywc',
                        label: '已完成'
                    },

                ],
                indentInfo: {
                    "channelServiceNo": "",
                    "deliveryOrderNo": "",
                    "itemCode": "",
                    "deliveryStatus": "",
                    "payStatus": "",
                    "tmName": "",
                    "name": "",
                    "startTime": "",
                    "entTime": "",
                    "pageIndex": 1,
                    "pageSize": 30
                },
                pickerOptions: {
                    shortcuts: [{
                        text: '最近一周',
                        onClick(picker) {
                            console.log(picker);
                            const end = new Date();
                            const start = new Date();
                            start.setTime(start.getTime() - 3600 * 1000 * 24 * 7);
                            picker.$emit('pick', [start, end]);
                        }
                    }, {
                        text: '最近一个月',
                        onClick(picker) {
                            const end = new Date();
                            const start = new Date();
                            start.setTime(start.getTime() - 3600 * 1000 * 24 * 30);
                            picker.$emit('pick', [start, end]);
                        }
                    }, {
                        text: '最近三个月',
                        onClick(picker) {
                            const end = new Date();
                            const start = new Date();
                            start.setTime(start.getTime() - 3600 * 1000 * 24 * 90);
                            picker.$emit('pick', [start, end]);
                        }
                    }]
                },

                /*input绑定值 */
                channelServiceNo: null,
                deliveryOrderNo: null,
                tmName: null,
                name: null,
                itemName: null,
                inputDate: null,
                startTime: null,
                entTime: null,
                deliveryStatus: null,
                /**$ */
                CreateDate: null,
                tableData: [],
                currentPage: 1,
                countPage: "",
                pageSize: null,
                /* 上传资料弹框 */

                loading: false,
                loading1: false,
                loading2: false,
                loading3: false,
                loadingKey: 0,
                sumparams: ["totalSum", "nclOneCodesNum"],
                multipleSelection: [],
                isSingleSelect: false,
                bizCode: "",
                centerDialogVisible: false,
                activeIndex: "1",
                totalSum: 0,
                sfs: [
                    { field: 'totalSum', label: '订单金额' },
                ],
                form: {
                    tmFormType: 3,
                    name: "",
                    picUrl: "",
                    colorizedPicUrl: "",
                    selecttype: "自主选择",
                    totalPublicExpense: 0,
                    totalTaxes: 0,
                    totalSum: 0,
                    totalDiscounts: 0,
                    totalServiceCharge: 0,
                    totalProfitSum: 0,
                    remark: "",
                    sveItemRateConfig: "",
                },
                form1: {
                    title: "",
                    taxNum: "",
                    email: "",
                },
                form2: {
                    title: "",
                    taxNum: "",
                    companyAddress: "",
                    companyMobile: "",
                    companyBank: "",
                    bankNum: "",
                    picUrl: "",
                    recipient: "",
                    mobile: "",
                    city: "",
                    address: "",
                },
                rules1: {
                    title: [
                        { required: true, message: '请输入发票抬头', trigger: 'blur' },
                    ],
                    taxNum: [
                        { required: true, message: '请输入纳税号', trigger: 'blur' },
                    ],
                    email: [
                        { required: true, message: '请输入发票接收邮箱', trigger: 'blur' },
                        { type: 'email', message: '请输入正确的邮箱地址', trigger: ['blur', 'change'] }
                    ]
                },
                rules2: {
                    title: [
                        { required: true, message: '请输入发票抬头', trigger: 'blur' },
                    ],
                    taxNum: [
                        { required: true, message: '请输入纳税号', trigger: 'blur' },
                    ],
                    companyAddress: [
                        { required: true, message: '请输入备案地址', trigger: 'blur' },
                    ],
                    companyMobile: [
                        { required: true, message: '请输入备案电话', trigger: 'blur' },
                    ],
                    companyBank: [
                        { required: true, message: '请输入开户银行', trigger: 'blur' },
                    ],
                    bankNum: [
                        { required: true, message: '请输入银行账户', trigger: 'blur' },
                    ],
                    fileUrl: [
                        { required: true, message: '请上传纳税资格证明', trigger: 'blur' },
                    ],
                    recipient: [
                        { required: true, message: '请输入收件人', trigger: 'blur' },
                    ],
                    mobile: [
                        { required: true, message: '请输入手机号', trigger: 'blur' },
                        { validator: validateMethod, trigger: 'blur' },
                    ],
                    address: [
                        { required: true, message: '请输入详细地址', trigger: 'blur' },
                    ],
                },
                d: {},
                action: "",
                addressInfo: [],
                index: 0,
                orderId: "",
                stuff: {},
                showUploadStuff: false,
                currentOrderNo: "",
                currentOrderType: "",
            }
        },
    created: function() {
        if (this.$route.query.channelUserId != "") {
            this.$root.channelUserId = this.$route.query.channelUserId;
            console.log(this.$route.query.channelUserId, "11111111111");
        }
    },
    mounted: function() {
        var that = this;
        var obj = this.$root.copyParams("", "getOssConfig", "/action/tmTools/springBoard");
        this.$root.postReq("/web/trademark/tmqueryCtl/doPost", obj).then(function (d) {
            console.log(d, `mmmmmmmmmmmmmmmmmmmmmmm`);
            that.d["key"] = "key";
            that.d["Bucket"] = d.data.Bucket;
            that.d["OSSAccessKeyId"] = d.data.OSSAccessKeyId;
            that.d["Signature"] = d.data.Signature;
            that.d["policy"] = d.data.policy;
            that.d["success_action_status"] = d.data.success_action_status;
            that.action = d.data.url;
            console.log(that.action, `oooooooooooooooooooooooooooo`);
        });
        if (this.$root.channelUserId != "") {
            this.handleSizeChange();
        }
    },

    methods: {
        tableRowClassName({ row, rowIndex }) {
            if (rowIndex === 1) {
                return 'warning-row';
            } else if (rowIndex === 3) {
                return 'success-row';
            }
            return '';
        },
        viewDetails(index, row) {
            console.log(index, row);
            this.currentOrderType = row.itemName;
            this.deliveryStatus = row.deliveryStatus;
            this.$router.push({
                path: "/1688/jdindentdetail",
                query: {
                    deliveryOrderNo: row.deliveryOrderNo,
                    channelUserId: this.$route.query.channelUserId,
                    deliveryStatus: this.deliveryStatus,
                    totalSum: row.totalSum,
                }
            });
        },
        showSelf(index, row){
            /* 
            console.log(index, row);
            */

            if ((row.deliveryStatus == "dsccl")) {
                if (this.showReg(index, row)) {
                    return false
                }
                return true;
            } else {
                return false;
            }
        },
        showSup(index, row){
            if (row.deliveryStatus == "dqrfa") {
                return true;
            } else {
                return false;
            }
        },
        showDetails(idx, row){
            if (row.deliveryStatus != "dqrfa") {
                if (this.showReg(idx, row)) {
                    return false
                }
                return true;
            } else {
                return false;
            }

        },
        showReg(idx, row){
            if (row.itemCode == 'zzsbzc') {
                if (!row.tmName || !row.nclOneCodes || !row.name) {
                    return true;
                } else {
                    return false;
                }
            }
        },
        goScheme(index, row){
            console.log(index, row);
            this.$router.push({
                path: '/1688/jdregscheme',
                query: {
                    channelUserId: this.$route.query.channelUserId,
                    deliveryOrderNo: row.deliveryOrderNo,
                }
            });
        },
        goSelftmreg(index, row){
            this.$router.push({
                path: '/1688/selftmreg',
                query: {
                    channelUserId: this.$route.query.channelUserId,
                    deliveryOrderNo: row.deliveryOrderNo,
                    channelOrderNo: row.channelServiceNo,
                }
            });
            window.scrollTo(0, 0);
        },
        handleSizeChange(){
            if (this.$route.query.channelUserId != "") {
                this.indentInfo.pageIndex = this.currentPage;
                var obj = this.$root.copyParams(this.indentInfo, "getTmOrderList", "/action/tmOrder/springBoard", "yes", "yes");
                this.$root.loading = true;
                this.$root.postReq("/web/trademark/tmqueryCtl/doPost", obj).then((d) => {
                    this.$root.loading = false;
                    console.log(d.data);
                    if (d.status == 0 && d.data) {
                        this.tableData = d.data;
                        /* 没有分页参数 需要重新改*/
                        this.countPage = 30 || d.data.length;
                        d.data.map((item, index) => {
                            if (item.submitTime) {
                                item.submitTime = new Date(item.submitTime).toLocaleString('chinese', { hour12: false });
                            } else {
                                item.submitTime = '--';
                            }
                            if (item.CreateDate) {
                                item.CreateDate = new Date(item.CreateDate).toLocaleDateString('chinese', { hour12: false });
                            } else {
                                item.CreateDate = '--';
                            }
                        });
                    } else {
                        console.log(d, "getTmOrderList...........");
                    }
                });
            }

        },
        reset(){
            this.channelServiceNo = null;
            this.deliveryOrderNo = null;
            this.name = null;
            this.itemName = null;
            this.tmName = null;
            this.CreateDate = null;
            console.log(this.CreateDate);
            this.deliveryStatus = null;
        },
        find(){
            this.indentInfo.channelServiceNo = this.channelServiceNo;
            this.indentInfo.deliveryOrderNo = this.deliveryOrderNo;
            this.indentInfo.name = this.name;
            this.indentInfo.itemName = this.itemName;
            this.indentInfo.tmName = this.tmName;
            this.indentInfo.CreateDate = this.CreateDate;
            this.indentInfo.deliveryStatus = this.deliveryStatus;
            this.indentInfo.startTime = this.startTime || "";
            this.indentInfo.entTime = this.entTime || "";
            this.handleSizeChange();
        },
        dateChecked(v){
            this.startTime = new Date(v[0]).toLocaleDateString('chinese', { hour12: false }).replace(/\//g, '-');
            this.entTime = new Date(v[1]).toLocaleDateString('chinese', { hour12: false }).replace(/\//g, '-');
            console.log(this.startTime, this.entTime);
        },
        /**上传资料弹窗 */
        setKey(name, flag){
            name = name.substring(name.length - 5);
            var myDate = new Date();
            var key = "zc_" + Math.round(Math.random() * 500) + myDate.getMonth() + myDate.getTime() + myDate.getFullYear() + myDate.getDate() + myDate.getHours() + myDate.getMinutes() + myDate.getSeconds() + myDate.getMilliseconds() + name.replace(" ", "");
            this.$refs[flag].d.key = key;
        },
        uploadsuccess(obj){
            var that = this;
            console.log(obj, `xxxxxxxxxxxxxxxxxxxxxxxx`);
            if (this.loadingKey == 1) {
                that.loading1 = true;
            } else if (this.loadingKey == 2) {
                that.loading2 = true;
            } else if (this.loadingKey == 3) {
                that.loading3 = true;
            } else if (this.loadingKey == 0) {
                that.loading = true;
            }

            if (obj.flag == "yyzz") {
                console.log(obj.result, "...........................");
                this.stuff.businessLicensePic = obj.result;
                var pic2pdf = { "key": obj.result };
                var pic2pdf = this.$root.copyParams(pic2pdf, "pic2pdf", "/action/tmTools/springBoard");
                this.$root.postReq("/web/trademark/tmqueryCtl/doPost", pic2pdf).then(function (d) {
                    that.loading1 = false;
                    that.loading2 = false;
                    that.loading3 = false;
                    that.loading = false;
                    if (d.status == 0) {
                        that.stuff.businessLicensePdf = d.data.url;
                    } else {
                        that.stuff.businessLicensePdf = "";

                        that.$message.warning(`上传失败请重新上传`);
                        return false;
                    }
                }).catch(function (e) {
                    that.stuff.businessLicensePic = "";
                    that.loading1 = false;
                    that.loading2 = false;
                    that.loading3 = false;
                    that.loading = false;
                    that.$message.warning(`上传失败请重新上传`);
                    return false;
                })
            }
            if (obj.flag == "sfz") {
                var sfz = { word: this.form.name };
                var sfz = this.$root.copyParams(sfz, "pic2pdf", "/action/tmTools/springBoard");
                this.$root.postReq("/web/trademark/tmqueryCtl/doPost", sfz).then(function (d) {
                    that.loading1 = false;
                    that.loading2 = false;
                    that.loading3 = false;
                    that.loading = false;
                    if (d.status == 0) {
                        that.stuff.identityCardPic = obj.result;
                        that.stuff.identityCardPdf = d.data.url;
                    } else {
                        that.stuff.identityCardPic = "";
                        that.stuff.identityCardPdf = "";
                        that.$message.warning(`上传失败请重新上传`);
                        return false;
                    }
                }).catch(function (e) {
                    that.stuff.identityCardPic = "";
                    that.loading1 = false;
                    that.loading2 = false;
                    that.loading3 = false;
                    that.loading = false;
                    that.$message.warning(`上传失败请重新上传`);
                    return false;
                })
            }
            if (obj.flag == "wts") {
                var adjustWTSSize = { "key": obj.result };
                var adjustWTSSize = this.$root.copyParams(adjustWTSSize, "adjustWTSSize", "/action/tmTools/springBoard");
                this.$root.postReq("/web/trademark/tmqueryCtl/doPost", adjustWTSSize).then(function (d) {
                    that.loading1 = false;
                    that.loading2 = false;
                    that.loading3 = false;
                    that.loading = false;
                    if (d.status == 0) {
                        that.stuff.gzwtsUrl = d.data.url;
                        console.log(d.data.url);
                    } else {
                        that.$refs[obj.flag][0].result = "";

                        that.$message.warning(`上传失败请重新上传`);
                        return false;
                    }

                }).catch(function () {
                    that.$refs[obj.flag][0].result = "";
                    that.loading1 = false;
                    that.loading2 = false;
                    that.loading3 = false;
                    that.loading = false;
                    that.$message.warning(`上传失败请重新上传`);
                    return false;
                });
            }
            if (obj.flag == "yxq") {
                that.loading1 = false;
                that.loading2 = false;
                that.loading3 = false;
                that.loading = false;
                that.stuff.smwjUrl = obj.result
            }
        },

        error(err){
            this.$message.warning(`上传失败，请重新上传`);
        },
        hideUploadStuff(){
            this.stuff = {};
            this.showUploadStuff = false;
        },
        uploadMaterials(index, row){
            console.log(row, `zzzzzzzzzzzzzzzzzzzzzz`);
            this.showUploadStuff = true;
            this.currentOrderNo = row.deliveryOrderNo;
            this.currentName = row.name;
            this.stuff.customerType = row.customerType;
            this.stuff.businessLicensePic = row.businessLicensePic;
            this.stuff.identityCardPic = row.identityCardPic;
            this.stuff.smwjUrl = row.smwjUrl;
        },
        uploadStuffs(){
            console.log(this.stuff);
            this.stuff.deliveryOrderNo = this.currentOrderNo;
            this.stuff.name = this.currentName;
            var obj = this.$root.copyParams(this.stuff, "updateOfficial", "/action/tmOrder/springBoard", "yes", "yes");
            this.$root.postReq("/web/trademark/tmqueryCtl/doPost", obj).then((res) => {
                console.log(res);
                if (res.status == 0) {
                    this.showUploadStuff = false;
                    this.$message({ message: "上传成功", type: 'success' });
                }
            }).catch((e) => {
                this.$message(e);
            });
        },
    },
    vname: "gsb-jdindentlist"
}
