{
    template: '${tmpl}',
        data: function() {
            var validateAddr = (rule, value, callback) => {
                var x = /(([省])|([中][国])|([中][华][人][民][共][和][国])|([北][京][市])|([上][海][市])|([天][津][市])|([重][庆][市])|([内][蒙][古])|([广][西])|([宁][夏])|([新][疆])|([西][藏])|([内][蒙][古][自][治][区])|([新][疆][维][吾][尔][自][治][区])|([广][西][壮][族][自][治][区])|([宁][夏][回][族][自][治][区])|([西][藏][自][治][区]))/g.test(value);
                if (!x) {
                    callback(new Error('请核对地址，必须写所在省份名称！'));
                } else {
                    callback();
                }
            };
            var mobileValidator = (rule, value, callback) => {
                var x = /((\d{11})|^((\d{7,8})|(\d{4}|\d{3})-(\d{7,8})|(\d{4}|\d{3})-(\d{7,8})-(\d{4}|\d{3}|\d{2}|\d{1})|(\d{7,8})-(\d{4}|\d{3}|\d{2}|\d{1}))$)/g.test(value);
                if (!x) {
                    callback(new Error('联系电话格式错误！'));
                } else {
                    callback();
                }
            };
            var emailValidator = (rule, value, callback) => {
                var x = /^([a-zA-Z0-9._-])+@([a-zA-Z0-9_-])+(\.[a-zA-Z0-9_-])+/.test(value);
                if (!x) {
                    callback(new Error('电子邮箱格式错误！'));
                } else {
                    callback();
                }
            };
            var colorizedtm = (rule, value, callback) => {
                if ((this.form.tmFormType == "7" || this.form.tmFormType == "6") && value == "") {
                    callback(new Error('请上传彩色商标图样'));
                } else {
                    callback();
                }
            };
            var validateIdCard = (rule, value, callback) => {
                if (this.form.type == "person") {
                    if (value == "") {
                        callback(new Error('请输入身份证号码'));
                    } else {
                        var x = /(^\d{15}$)|(^\d{18}$)|(^\d{17}(\d|X|x)$)/.test(value);
                        if (!x) {
                            callback(new Error('身份证格式错误'));
                        } else {
                            callback();
                        }
                    }
                } else {
                    callback();
                }
            };
            var validateSFZ = (rule, value, callback) => {
                if (this.apply.customerType == "person" && value == "") {
                    callback(new Error('身份证明不能为空'));
                } else {
                    callback();
                }
            };
            var code = (rule, value, callback) => {
                if (this.apply.customerType == "ent" && !this.apply.code) {
                    callback(new Error('请输入信用代码'));
                } else {
                    callback();
                }
            };
            return {
                ldms: [],
                form: {
                    tmFormType: 3,
                    name: "",
                    picUrl: "",
                    colorizedPicUrl: "",
                    selecttype: "自主选择",
                    totalPublicExpense: 0,
                    totalTaxes: 0,
                    totalSum: 0,
                    totalDiscounts: 0,
                    totalServiceCharge: 0,
                    totalProfitSum: 0,
                    remark: "",
                    sveItemRateConfig: "",
                },
                rules: {
                    name: [
                        { required: true, message: '请输入商标名称' }
                    ],
                    picUrl: [
                        { required: true, message: '请上传商标图样' }
                    ],
                    colorizedPicUrl: [
                        { validator: colorizedtm, trigger: 'blur' }
                    ],
                    tmFormType: [
                        { required: true, message: '请选择商标类型' }
                    ],
                },
                tm_form_type: { "1": "立体", "3": "文字图标", "4": "图形商标", "5": "图形及文字商标", "6": "颜色", "7": "彩色" },
                nclOne: [],
                apply: {
                    customerType: "ent",
                    name: "",
                    code: "",
                    identityCardNo: "",
                    applyAddr: "",
                    applyArea: "",
                    zipCode: "",
                    contacts: "",
                    mobile: "",
                    email: "",
                    tel: "",
                    fax: "",
                    businessLicensePic: "",
                    identityCardPic: "",
                    sealAuthorizeStuff: "",
                    descUrl: "",
                    notes: "",
                    centerDialogVisible: false
                },
                isRead: false,
                /*页面信息 */
                deliveryInfo: "",
                applyInfo: {},
                deliveryOrderNo: '',
                nclInfo: "",
                values: "",
            }
        },
    mounted: function() {
        this.initIndent();
    },
    created: function() {
        if (this.$route.query.channelUserId != "" && this.$route.query.deliveryOrderNo) {
            this.$root.channelUserId = this.$route.query.channelUserId;
            this.deliveryOrderNo = this.$route.query.deliveryOrderNo;
        }
    },
    methods: {
        submitForm(){
            this.apply.centerDialogVisible = false;
            console.log(this.values, `zzzzzzzzzzzzzzzzzzzzzzzz`);
            var obj = {};
            obj.deliveryOrderNo = this.deliveryOrderNo;
            obj.channelUserId = this.$root.channelUserId;
            obj.isConfirm = "0";
            obj.notes = this.values;
            if (this.notes == "") {
                this.$meesage({
                    message: "请输入理由!",
                    type: "warning"
                });
                return;
            }
            var obj = this.$root.copyParams(obj, "tmConfirm", "/action/tmOrder/springBoard");
            this.$root.postReq("/web/trademark/tmqueryCtl/doPost", obj).then((d) => {
                if (d.status == 0) {
                    this.$router.push({
                        path: "/1688/jdindentlist",
                        query: {
                            deliveryOrderNo: this.deliveryOrderNo,
                            channelUserId: this.$route.query.channelUserId,
                        }
                    });
                    console.log('[[[[[[[[[[[[[[[[[[[[[[[[[[[[');
                }else{
                    this.$message(d.msg);
                }
            });


        },
        agreedForm(){
            var obj = {};
            obj.deliveryOrderNo = this.deliveryOrderNo;
            obj.channelUserId = this.$root.channelUserId;
            obj.isConfirm = "1";
            var obj = this.$root.copyParams(obj, "tmConfirm", "/action/tmOrder/springBoard");
            this.$root.postReq("/web/trademark/tmqueryCtl/doPost", obj).then((d) => {
                if (d.status == 0) {
                    this.$message({
                        showClose: true,
                        message: '确认方案成功',
                        type: 'success'
                    });
                    this.$router.push({
                        path: "/1688/jdindentlist",
                        query: {
                            deliveryOrderNo: this.deliveryOrderNo,
                            channelUserId: this.$route.query.channelUserId,
                        }
                    });
                }else{
                    this.$message(d.msg);
                }
            });

        },
        /*初始化订单数据 */
        initIndent(){
            var deliveryObj = this.$root.copyParams({ "deliveryOrderNo": this.deliveryOrderNo, "channelUserId": this.$root.channelUserId }, "getTmOrderInfo", "/action/tmOrder/springBoard");
            var applyObj = this.$root.copyParams({ "deliveryOrderNo": this.deliveryOrderNo, "channelUserId": this.$root.channelUserId }, "getTmApplyInfo", "/action/tmOrder/springBoard");
            var nclObj = this.$root.copyParams({ "deliveryOrderNo": this.deliveryOrderNo, "channelUserId": this.$root.channelUserId }, "getTmNclList", "/action/tmOrder/springBoard");
            let [loadingA, loadingB, loadingC] = [1, 1, 1];
            this.$root.loading = true;
            this.$root.postReq("/web/trademark/tmqueryCtl/doPost", deliveryObj).then((d) => {
                loadingA = 0;
                if (d.status == 0 && d.data) {
                    console.log(d, `deliveryInfo`);
                    this.deliveryInfo = d.data.tm;
                    this.orderFlow = d.data.orderFlow;
                    this.orderFlow.map((item, index) => {
                        if(item.createDate){
                            item.createDate = new Date(item.createDate).toLocaleString('chinese', { hour12: false });
                        }
                    })
                }
            }).then(() => {
                if (loadingA == 0 && loadingB == 0 && loadingC == 0) {
                    this.$root.loading = false;
                }
            });
            this.$root.postReq("/web/trademark/tmqueryCtl/doPost", applyObj).then((d) => {
                loadingB = 0;
                console.log(d, `applyObj`);
                if (d.status == 0 && d.data) {
                    this.applyInfo = d.data;
                }
            }).then(() => {
                if (loadingA == 0 && loadingB == 0 && loadingC == 0) {
                    this.$root.loading = false;
                }
            });
            this.$root.postReq("/web/trademark/tmqueryCtl/doPost", nclObj).then((d) => {
                loadingC = 0;
                console.log(d, `nclObj`);
                if (d.status == 0 && d.data) {
                    this.nclInfo = d.data;
                    this.nclInfo.map((item, index) => {
                        item.nclSmallCodes = JSON.parse(item.nclSmallCodes);
                    })
                }
            }).then(() => {
                if (loadingA == 0 && loadingB == 0 && loadingC == 0) {
                    this.$root.loading = false;
                }
            });
        },
    },
    vname: "gsb-jdregscheme"
}
