const system = require("../../../system");
const ServiceBase = require("../../svems.base")
const settings = require("../../../../config/settings")
class MerchantrechargeService extends ServiceBase {
  constructor() {
    super();

    this.pushapiSve = system.getObject("service.push.pushapiSve");
  }

  async add(params) {
    // 
    var recharge = {};
    recharge.merchantId = params.merchant_id || params.merchantId;
    recharge.amt = Number(params.amt);
    recharge.outTradeNo = this.trim(params.outTradeNo);
    recharge.voucher = this.trim(params.voucher);

    if (recharge.amt <= 0) {
      return system.getResult(null, "充值金额不能小于0");
    }

    return await this.callms("merchant", "merchantRechargeAdd", params);
    // await this.transfield(res.data.rows);
    // return res;
  }

  async info(params) {
    var res = await this.callms("merchant", "merchantRechargeInfo", params);
    await this.transfield([res.data]);
    return res;
  }

  async audit(params) {
    var res = await this.callms("merchant", "merchantRechargeAudit", params);
    if (res.status == 0) {
      this.pushAudit(params);
    }
    return res;
  }

  async page(params) {
    var res = await this.callms("merchant", "merchantRechargePage", params);
    await this.transfield(res.data.rows);
    return res;
  }

  async pushAudit(params) {
    try {
      var recharge = await this.callms("merchant", "merchantRechargeInfo", params);
      recharge = recharge.data;
      // 查商户加密信息
      var merchant = await this.callms("merchant", "secretById", {
        id: recharge.merchant_id
      });
      merchant = merchant.data;
      // 推送审核信息
      await this.pushapiSve.push({
        merchantId: merchant.id,
        appKey: merchant.appSecret,
        dataType: 0,
        dataId: merchant.id,
        field: "rechargeAudit",
        params: {
          merchantId: merchant.id,
          outTradeNo: recharge.outTradeNo,
          status: recharge.status,
          remark: this.trim(recharge.remark)
        },
      });
    } catch (error) {
      console.log(error);
    }
  }

  async transfield(rows) {
    if (!rows) {
      return;
    }
    for (var item of rows) {
      if (!item) {
        continue;
      }
      item.amt = system.f2y(item.amt);
    }
  }
}
module.exports = MerchantrechargeService;
// var task=new UserService();
// task.getUserStatisticGroupByApp().then(function(result){
//   console.log((result));
// }).catch(function(e){
//   console.log(e);
// });