var APIBase = require("../../api.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
class RejAPI extends APIBase {
  constructor() {
    super()
    this.rejcbSve = system.getObject("service.reportcb.rejcbSve");
  }

  async getRejDataCb (pobj, q, req) {
    try {
      let result = await this.rejcbSve.getRejData();
      if (result.count) {
        result.code = 200
        result.msg = "数据获取成功"
      } else {
        result.code = 201
        result.msg = "无数据"
      }
      return result
    } catch (error) {
      console.log(error.message)
      return {
        code: -1,
        msg: error.message
      }
    }
  }

  async changeStatusCb (pobj, q, req) {
    try {
      await this.rejcbSve.changeStatus(pobj)
      return {
        code: 200,
        msg: "处理提报进度成功"
      }
    } catch (error) {
      console.log(error.message)
      return {
        code: -1,
        msg: error.message
      }
    }
  }

  async pushBcStatus (pobj, q, req) {
    try {
      this.rejcbSve.saveBcData(pobj)
      return {
        code: 200,
        msg: "商标局状态处理成功"
      }
    } catch (error) {
      console.log(error.message)
      return {
        code: -1,
        msg: error.message
      }
    }
  }

  async initBcStatusForTest (pobj, q, req) {
    try {
      await this.rejcbSve.initStatus()
      return {
        code: 200,
        msg: "重置成功"
      }
    } catch (error) {
      return {
        code: -1,
        msg: error.message
      }
    }
  }

  async testpost() {
    try {
      console.log('into')
      return await this.rejcbSve.testpost()
    } catch (error) {
    }
  }

  classDesc () {
    return {
      groupName: "auth",
      groupDesc: "认证相关的包",
      name: "AccessAuthAPI",
      desc: "关于认证的类",
      exam: `
             post  http://p.apps.com/api/auth/accessAuth/getAccessKey
             {
                appKey:xxxxx,
                secret:yyyyyy
             }
         `,
    };
  }
  methodDescs () {
    return [
      {
        methodDesc: "生成访问token,访问地址：http://......../api/auth/accessAuth/getAccessKey,访问token需要放置到后续API方法调用的请求头中",
        methodName: "getAccessKey",
        paramdescs: [
          {
            paramDesc: "访问appkey",
            paramName: "appkey",
            paramType: "string",
            defaultValue: "",
          },
          {
            paramDesc: "访问secret",
            paramName: "secret",
            paramType: "string",
            defaultValue: "",
          }
        ],
        rtnTypeDesc: "返回JSON对象字符串",
        rtnType: "json object {accessKey: xxxxxx, app: {xxx:xxx}},注意app,是当前app信息,详细见后面示例"
      },
    ];
  }
  exam () {
    return ``
  }
}
module.exports = RejAPI;
