var system = require("../../../system")
const CtlBase = require("../../ctl.base");
class TrademarkcaseCtl extends CtlBase {
  constructor() {
    super("rejreex", CtlBase.getServiceName(TrademarkcaseCtl));
  }

  async test () {
    console.log('test------')
    return system.getResult('test')
  }

  async createOrUpdate (pobj, qobj, req) {
    let q = false
    try {
      if (pobj.actionBody) {
        q = true
        pobj = pobj.actionBody
      }
      let result = await this.service.createOrUpdate(pobj)
      if (q) {
        return {
          status: 1,
          msg: "测试成功",
          data: null
        }
      } else {
        return system.getResultSuccess(result)
      }
    } catch (error) {
      console.log('err: ', error)
      if(q) {
        return {
          status: -1,
          msg: "测试失败",
          data: null
        }
      } else {
        return system.getResultFail(error.message)
      }
    }
  }

  async getCase (pobj, qobj, req) {
    try {
      let caseId = pobj.caseId
      let result = await this.service.getCase(caseId)
      return system.getResultSuccess(result)
    } catch (error) {
      console.log('err: ', error)
      return system.getResultFail(error.message)
    }
  }

  async findAndCountAll (pobj, qobj, req) {
    console.log('data -----', pobj, qobj)
    try {
      let result = await this.service.getCaseList(pobj)
      return system.getResultSuccess(result)
    } catch (error) {
      console.log('err: ', error)
      return system.getResultFail(error.message)
    }
  }

  async createOffical (pobj, qobj, req) {
    try {
      let result = await this.service.createOffical(pobj)
      return system.getResultSuccess(result)
    } catch (error) {
      return system.getResultFail(error.message)
    }
  }

  async pushQfTest (pobj, qobj, req) {
    return await this.service.pushQf(pobj.id)
  }

  async pushQffTest(pobj, qobj, req) {
    return await this.service.pushQff(pobj.id)
  }
}
module.exports = TrademarkcaseCtl;
