const system = require("../../../system");
const moment = require('moment');
const settings = require("../../../../config/settings");
const appconfig = system.getSysConfig();
/**
 * 方案表
 */
module.exports = (db, DataTypes) => {
  return db.define("scheme", {
    demand_code: { // 需求编码
      allowNull: false,
      type: DataTypes.STRING
    },
    scheme_number: { //方案编号
      allowNull: true,
      type: DataTypes.STRING
    },
    scheme_info: {//方案详情
      allowNull: false,
      type: DataTypes.JSON
    },
    scheme_status: { //方案状态
      allowNull: false,
      type: DataTypes.STRING
    },
    reject_reason: {//驳回理由
      allowNull: true,
      type: DataTypes.STRING
    },
    remark_info: { //备注
      allowNull: true,
      type: DataTypes.STRING
    },
    bizopt_id: { //商机id
      allowNull: true,
      type: DataTypes.STRING
    },
    facilitator_id: { //服务商id
      allowNull: true,
      type: DataTypes.STRING
    },
    facilitator_name: { //服务商名称
      allowNull: true,
      type: DataTypes.STRING
    },
    salesman_opcode: { //组织架构路径
      allowNull: true,
      type: DataTypes.STRING
    },
    salesman_id: { //业务员id
      allowNull: true,
      type: DataTypes.STRING
    },
    salesman_name: { //业务员名称
      allowNull: true,
      type: DataTypes.STRING
    },
    salesman_phone: { //业务员联系方式
      allowNull: true,
      type: DataTypes.STRING
    }

  }, {
    paranoid: false,//假的删除
    underscored: true,
    version: true,
    freezeTableName: true,
    //freezeTableName: true,
    // define the table's name
    tableName: 'scheme_information',
    validate: {

    },
    indexes: [
      // Create a unique index on email
      //  {
      //    unique: true,
      //    fields: ['email']
      //  },
      //
      //  // Creates a gin index on data with the jsonb_path_ops operator
      //  {
      //    fields: ['data'],
      //    using: 'gin',
      //    operator: 'jsonb_path_ops'
      //  },
      //
      //  // By default index name will be [table]_[fields]
      //  // Creates a multi column partial index
      //  {
      //    name: 'public_by_author',
      //    fields: ['author', 'status'],
      //    where: {
      //      status: 'public'
      //    }
      //  },
      //
      //  // A BTREE index with a ordered field
      //  {
      //    name: 'title_index',
      //    method: 'BTREE',
      //    fields: ['author', {attribute: 'title', collate: 'en_US', order: 'DESC', length: 5}]
      //  }
    ]
  });
}

