const system = require("../../../system");
const ServiceBase = require("../../sve.base");
const settings = require('../../../../config/settings')
class TmrejaskcaseService extends ServiceBase {
  constructor() {
    super("rejreex", ServiceBase.getDaoName(TmrejaskcaseService))
    this.restClient = system.getObject("util.restClient")
    this.tkurl = settings.qftkurl()
    this.qfurl = settings.qifuurl()
  }

  async create (data) {
    return await this.dao.create(data)
  }

  async pushQf (id, tp) {
    let tmpdata
    if (tp == 'od') {
      tmpdata = await this.dao.findOne({ orderId: id })
    } else {
      tmpdata = await this.dao.findOne({ id })
    }
    let reqdata = this.orgdata(tmpdata)

    let req = {
      actionType: "getAppTokenByHosts",
      actionBody: {}
    }
    let tkurl = this.tkurl
    let tokenData = await this.restClient.execPost(req, tkurl)
    console.log(tokenData)
    tokenData = JSON.parse(tokenData.stdout)
    if (tokenData.status == 0) {
      let token = tokenData.data.token
      console.log(token)
      let qfurl = this.qfurl
      req.actionType = "receiveDeliveryData"
      req.actionBody = reqdata
      let res = await this.restClient.execPostWithToken(req, qfurl, token)
      return res
    } else {
      return "--"
    }
  }

  orgdata (data) {
    let datat = {}
    datat.orderNo = data.orderId
    let apply = {
      askforId: data.askforId,
      tradeImg: data.tradeImg,
      tradeType: data.tradeType,
      applicantName: data.v_applicantName,
      usccode: data.usccode,
      agentname: data.agentName
    }
    datat.apply = apply
    datat.applyUser = data.applicant
    datat.applyUser.usccode = data.usccode

    datat.trademarkRejInfo = data.trademarkRejInfo

    datat.askForData = data.askForData

    datat.deliveryStatusName = data.tradeStatus

    datat.supData = data.supData
    datat.recDate = data.recDate
    datat.askforDate = data.askforDate
    return datat
  }
}
module.exports = TmrejaskcaseService;
