var path = require('path');
var ENVINPUT = {
  DB_HOST: process.env.DB_HOST,
  DB_PORT: process.env.DB_PORT,
  DB_USER: process.env.DB_USER,
  DB_PWD: process.env.DB_PWD,
  DB_NAME: process.env.DELIVERY_DB_NAME,
  REDIS_HOST: process.env.REDIS_HOST,
  REDIS_PORT: process.env.REDIS_PORT,
  REDIS_PWD: process.env.REDIS_PWD,
  REDIS_DB: process.env.PAAS_REDIS_DB,
  APP_ENV: process.env.APP_ENV ? process.env.APP_ENV : "dev"
};
var settings = {
  env: ENVINPUT.APP_ENV,
  salt: "%iatpD1gcxz7iF#B",
  defaultpwd: "gsb2020",
  basepath: path.normalize(path.join(__dirname, '../..')),
  port: process.env.NODE_PORT || 8777,
  kongurl: function () {
    if (this.env == "dev") {
      var localsettings = require("./localsettings");
      return localsettings.kongurl;
    } else {
      return ENVINPUT.KONG_ADMIAN;
    }
  },
  qifuurl: function () {
    if (this.env == 'dev') {
      return 'http://gsbweb.qifu-dev.gongsibao.com/web/opaction/tmReview/springBoard'
      // return 'http://192.168.201.235:4012/web/opaction/tmReview/springBoard'
    } else {
      return 'http://gsbweb.qifu.gongsibao.com/web/opaction/tmReview/springBoard'
    }
  },
  qftkurl: function () {
    if (this.env == 'dev') {
      return 'http://gsbweb.qifu-dev.gongsibao.com/web/auth/accessAuth/getAppTokenByHosts'
      // return 'http://gsbweb.qifu-dev.gongsibao.com:4012/web/auth/accessAuth/getAppTokenByHosts'
    } else {
      return 'http://gsbweb.qifu.gongsibao.com/web/auth/accessAuth/getAppTokenByHosts'
    }
  },
  receiveUrl: function () {
    if (this.env == "dev") {
      return "http://192.168.1.140:4011/api/receive/entService/springBoard";
    } else {
      return "http://brg-user-center-service/api/receive/entService/springBoard";
    }
  },
  queueUrl: function () {
    if (this.env == "dev") {
      return "http://192.168.18.101:4018/api/queueAction/producer/springBoard";
    } else {
      return "http://sytxpublic-msgq-service/api/queueAction/producer/springBoard";
    }
  },
  wdyUrl: function () {
    if (this.env == "dev") {
      return "http://192.168.1.113:4011/api/action/order/springBoard";
    } else {
      return "http://brg-user-center-service/api/action/order/springBoard";
    }
  },
  pmappid: 1,
  pmcompanyid: 1,
  pmroleid: { "ta": 1, "pr": 2 },
  redis: function () {
    if (this.env == "dev") {
      var localsettings = require("./localsettings");
      return localsettings.redis;
    } else {
      return {
        host: ENVINPUT.REDIS_HOST,
        port: ENVINPUT.REDIS_PORT,
        password: ENVINPUT.REDIS_PWD,
        db: ENVINPUT.REDIS_DB,
      };
    }
  },
  database: function () {
    if (this.env == "dev") {
      var localsettings = require("./localsettings");
      console.log(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>....")
      return localsettings.database;
    } else {
      return {
        dbname: ENVINPUT.DB_NAME,
        user: ENVINPUT.DB_USER,
        password: ENVINPUT.DB_PWD,
        config: {
          host: ENVINPUT.DB_HOST,
          port: ENVINPUT.DB_PORT,
          dialect: 'mysql',
          operatorsAliases: false,
          pool: {
            max: 5,
            min: 0,
            acquire: 90000000,
            idle: 1000000
          },
          debug: false,
          timezone: '+08:00',
          dialectOptions: {
            requestTimeout: 999999,
            // instanceName:'DEV'
          }  //设置MSSQL超时时间
        },
      };
    }
  }
};
settings.ENVINPUT = ENVINPUT;
module.exports = settings;
