const CacheBase = require("../cache.base");
const system = require("../../system");
const settings = require("../../../config/settings");
class ApiAccessKeyCache extends CacheBase {
  constructor() {
    super();
    this.restS = system.getObject("util.restClient");
  }
  desc() {
    return "应用中缓存访问token";
  }
  prefix() {
    return settings.cacheprefix + "_accesskey:";
  }
  async buildCacheVal(cachekey, inputkey, val, ex, ...items) {
    var p = { appkey: settings.appKey, secret: settings.secret };
    var url = settings.paasUrl() + "api/auth/accessAuth/getAccessKey";
    var acckapp = await this.restS.execPost(p, settings.paasUrl() + "api/auth/accessAuth/getAccessKey");

    console.log(url, p, acckapp, "req platform result -----------------------");
    var s = acckapp.stdout;
    if (s) {
      var tmp = JSON.parse(s);
      if (tmp.status == 0) {
        return JSON.stringify(tmp.data);
      }
    }
    return null;
  }
}
module.exports = ApiAccessKeyCache;
