const CacheBase = require("../cache.base");
const system = require("../../system");
const settings = require("../../../config/settings");
class ApiAppIdCheckCache extends CacheBase {
  constructor() {
    super();

    this.merchantSve = system.getObject("service.merchant.merchantSve");
  }
  desc() {
    return "应用中来访访问appid缓存";
  }
  prefix() {
    return settings.cacheprefix + "_verify_appid:";
  }
  async buildCacheVal(cachekey, inputkey, val, ex, ...items) {
    var item = await this.merchantSve.getById(inputkey);
    if (!item && item.data) {
      return null;
    }
    return JSON.stringify(item.data);
  }
}
module.exports = ApiAppIdCheckCache;