const system = require("../../../system");
const ServiceBase = require("../../svems.base");
var settings = require("../../../../config/settings");

class DeliverService extends ServiceBase {
  constructor() {
    super();
  }

  async all(params) {
    var rs = await this.callms("common", "deliverAll", {});
    await this.doPercent(rs.data);
    return rs;
  }

  async page(params) {
    var rs = await this.callms("common", "deliverPage", params);
    await this.doPercent(rs.data.rows);
    return rs;
  }

  async info(params) {
    var rs = await this.callms("common", "deliverInfo", params);
    await this.doPercent([rs.data]);
    return rs;
  }

  async save(params) {
    params.invoiceDivide = system.y2f(params.invoiceDivide);
    params.businessmenDivide = system.y2f(params.businessmenDivide);
    var rs = await this.callms("common", "deliverSave", params);
    await this.doPercent([rs.data]);
    return rs;
  }

  async del(params) {
    return await this.callms("common", "deliverDelete", params);
  }

  async doPercent(rows) {
    if(!rows) {
      return;
    }
    for(var row of rows) {
      if(!row) {
        continue;
      }
      row.invoiceDivide = system.f2y(row.invoiceDivide);
      row.businessmenDivide = system.f2y(row.businessmenDivide);
    }
  }
}
module.exports = DeliverService;