const system = require("../../../system");
const ServiceBase = require("../../svems.base")
const settings = require("../../../../config/settings")
class MerchantsignedService extends ServiceBase {
  constructor() {
    super();
  }

  async page(params) {
    var res = await this.callms("merchant", "merchantSignList", params);
    await this.doRate(res.data.rows);
    return res;
  }

  async save(params) {
    params.serviceRate = system.y2f(params.serviceRate);
    return await this.callms("merchant", "saveMerchantSign", params);
  }

  async info(params) {
    var res = await this.callms("merchant", "merchantSignInfo", params);
    await this.doRate([res.data]);
    return res;
  }

  async doRate(rows) {
    if (!rows) {
      return;
    }
    for (var item of rows) {
      if (!item) {
        continue;
      }
      item.serviceRate = system.f2y(item.serviceRate);
    }
  }
}
module.exports = MerchantsignedService;
// var task=new UserService();
// task.getUserStatisticGroupByApp().then(function(result){
//   console.log((result));
// }).catch(function(e){
//   console.log(e);
// });