var system = require("../../../system")
var settings = require("../../../../config/settings");
const CtlBase = require("../../ctlms.base");
const uuidv4 = require('uuid/v4');
var moment = require("moment");
var svgCaptcha = require('svg-captcha');

class DeliverCtl extends CtlBase {
  constructor() {
    super();
    this.deliverSve = system.getObject("service.common.deliverSve");
  }

  async all(pobj, pobj2, req) {
    try {
      return await this.deliverSve.all(pobj);
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }

  async page(pobj, pobj2, req) {
    try {
      return await this.deliverSve.page(pobj);
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }

  async info(pobj, pobj2, req) {
    try {
      return await this.deliverSve.info(pobj);
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }

  async enabled(pobj, pobj2, req) {
    pobj.isEnabled = Number(pobj.isEnabled || 0);
    try {
      return await this.deliverSve.enabled(pobj);
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }

  async resetPassword(pobj, pobj2, req) {

    let params = {
      admin_id: this.trim(pobj.admin_id),
      password: this.trim(pobj.password),
    }
    if(!params.password) {
      return system.getResult(null, "请输入密码");
    }

    try {
      return await this.deliverSve.resetPassword(pobj);
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }

  async save(pobj, pobj2, req) {
    try {
      let id = this.trim(pobj.id);
      let name = this.trim(pobj.name);
      let real_name = this.trim(pobj.real_name);
      let ucname = this.trim(pobj.ucname);
      let password = this.trim(pobj.password);
      let isEnabled = pobj.isEnabled || 0;

      if (!name) {
        return system.getResult(null, "请输入交付商名称");
      }
      if (!real_name) {
        return system.getResult(null, "请输入管理员名称");
      }
      if (!ucname) {
        return system.getResult(null, "请输入帐号名");
      }
      if (!id) {
        if (!password) {
          return system.getResult(null, "请输入密码");
        }
      }
      let params = {
        id: id,
        name: name,
        real_name: real_name,
        ucname: ucname,
        password: password,
        isEnabled: isEnabled,
        saas_id: pobj.saas_id,
      }
      return await this.deliverSve.save(params);
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }

  async del(pobj, pobj2, req) {
    try {
      return await this.deliverSve.del(pobj);
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }

}

module.exports = DeliverCtl;