var system = require("../../../system")
const http = require("http")
const querystring = require('querystring');
var settings = require("../../../../config/settings");
const CtlBase = require("../../ctlms.base");

var cacheBaseComp = null;

class OrderCtl extends CtlBase {
  constructor() {
    super();
    this.orderSve = system.getObject("service.order.orderSve");
    this.userSve = system.getObject("service.uc.userSve");
    this.TAX_CATEGORY = [1,2]; //计费模式
  }

  async processList(pobj, pobj2, req) {
    try {
      return this.orderSve.allProcess(pobj);
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }

  // ************************************

  async platformOrders(pobj, pobj2, req) {
    var condition = {
      currentPage: pobj.currentPage || 1,
      pageSize: pobj.pageSize || 10,
      id: this.trim(pobj.id),
      status: pobj.status,
      createdBegin: this.trim(pobj.createdBegin),
      createdEnd: this.trim(pobj.createdEnd),
    }

    this.doTimeCondition(condition, ["createdBegin", "createdEnd"]);
    try {
      return await this.orderSve.orders(condition);
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }

  async myOrders(pobj, pobj2, req) {
    var condition = {
      currentPage: pobj.currentPage || 1, 
      pageSize: pobj.pageSize || 10,
      id: this.trim(pobj.id),
      bd_path: req.loginUser.orgpath,
      deliver_id: this.trim(pobj.deliver_id),
      status: pobj.status,
      createdBegin: this.trim(pobj.createdBegin),
      createdEnd: this.trim(pobj.createdEnd),
    }
    if(!condition.bd_path) {
      return system.getResultSuccess({count: 0, rows:[], warning: "该用户组织机构为空"});
    }
    this.doTimeCondition(condition, ["createdBegin", "createdEnd"]);
    try {
      return await this.orderSve.orders(condition);
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }

  async orderInfo(pobj, pobj2, req) {
    try {
      return await this.orderSve.orderInfoAll({id: this.trim(pobj.id)});
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }

  async orderChooseProducts(pobj, pobj2, req) {
    let orderId = this.trim(pobj.id);

    let order = await this.orderSve.orderInfo({id: orderId});
    if(!order.data || !order.data.product_id) {
      return system.getResult(null, "订单不存在");
    }
    let params = {
      pid: order.data.product_id,
      is_choose: 1,
    }
    try {
      return await this.orderSve.productDics(params);
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }

  async orderAssign(pobj, pobj2, req) {
    var condition = {
      id: this.trim(pobj.id),
      status: pobj.status,
      bd_id: Number(pobj.deliverId),
      assign_user_id: req.loginUser.id,
    }
    // * @bd_path String 业务员权限
    let bd = await this.userSve.queryById({id: condition.bd_id});
    console.log(bd);
    bd = bd.data;
    if (!bd) {
      return system.getResult(null, "业务员不存在");
    }
    if (!bd.orgpath) {
      return system.getResult(null, "用户组织机构异常");
    }
    condition.bd_path = bd.orgpath;

    try {
      return await this.orderSve.handleStatus(condition);
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }

  async perfectInformation(pobj, pobj2, req) {
    let params = {};
    params.id = this.trim(pobj.id);
    params.status = this.trim(pobj.status);
    params.legal_name = this.trim(pobj.legal_name);
    params.id_card = this.trim(pobj.id_card);
    params.legal_mobile = this.trim(pobj.legal_mobile);
    params.names = this.trim(pobj.names);
    params.capital = this.trim(pobj.capital);
    params.domicile_id = this.trim(pobj.domicile_id);
    params.domicile_name = this.trim(pobj.domicile_name);
    params.business_scope_id = this.trim(pobj.business_scope_id);
    params.business_type = this.trim(pobj.business_type);
    params.business_scope = this.trim(pobj.business_scope);
    params.idcard_front = this.trim(pobj.idcard_front);
    params.idcard_back = this.trim(pobj.idcard_back);
    params.other_file = this.trim(pobj.other_file);
    params.guest_mail_addr = this.trim(pobj.guest_mail_addr);
    params.guest_mail_to = this.trim(pobj.guest_mail_to);
    params.guest_mail_mobile = this.trim(pobj.guest_mail_mobile);
    params.service_items = this.trim(pobj.service_items);
    params.service_remark = this.trim(pobj.service_remark);

    if(!params.id) {
      return system.getResult(null,`订单不存在`);
    }
    if(!params.status) {
      return system.getResult(null,`订单状态错误`);
    }
    if(!params.legal_name){
      return system.getResult(null,`参数错误 法人姓名不能为空`);
    }
    if(!params.id_card){
      return system.getResult(null,`参数错误 法人身份证不能为空`);
    }
    if(!params.legal_mobile){
      return system.getResult(null,`参数错误 法人电话不能为空`);
    }
    if(!params.names){
      return system.getResult(null,`参数错误 个体户名称不能为空`);
    }
    if(!params.capital){
      return system.getResult(null,`参数错误 注册资本不能为空`);
    }
    if(!params.domicile_id){
      return system.getResult(null,`参数错误 注册地id不能为空`);
    }
    if(!params.domicile_name){
      return system.getResult(null,`参数错误 注册地名称不能为空`);
    }
    if(!params.business_scope_id){
      return system.getResult(null,`参数错误 经营范围id不能为空`);
    }
    if(!params.business_type){
      return system.getResult(null,`参数错误 经营范围不能为空`);
    }
    if(!params.business_scope){
      return system.getResult(null,`参数错误 经营范围详情不能为空`);
    }
    if(!params.idcard_front){
      return system.getResult(null,`参数错误 身份证正面照片不能为空`);
    }
    if(!params.idcard_back){
      return system.getResult(null,`参数错误 身份证反面照片不能为空`);
    }
    if(!params.other_file){
      return system.getResult(null,`参数错误 其他文件不能为空`);
    }
    if(!params.guest_mail_addr){
      return system.getResult(null,`参数错误 邮寄客户地址不能为空`);
    }
    if(!params.guest_mail_to){
      return system.getResult(null,`参数错误 客户收件人不能为空`);
    }
    if(!params.guest_mail_mobile){
      return system.getResult(null,`参数错误 客户收件人电话不能为空`);
    }

    try {
      return await this.orderSve.handleStatus(params);
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }

  /**
   * 分配交付商
   * @param {*} params 
   */
  async assignDeliver(pobj, pobj2, req) {
    if (!pobj.id) {
      return system.getResult(null, `参数错误 订单ID不能为空`);
    }
    if (!pobj.deliver_id) {
      return system.getResult(null, `参数错误 交付商ID不能为空`);
    }
    if (!pobj.deliver_id) {
      return system.getResult(null, `参数错误 交付商ID不能为空`);
    }
    if (!pobj.hasOwnProperty(`deliver_divide`)) {
      return system.getResult(null, `参数错误 交付商分成不能为空`);
    }

    pobj.deliver_divide = system.y2f(pobj.deliver_divide);
    try {
      return await this.orderSve.handleStatus(pobj);
    } catch (error) {
      console.log(error);
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  /**
   * 交付商审核
   * @param {*} pobj 
   * @param {*} pobj2 
   * @param {*} req 
   */
  async platformDeliverAudit(pobj, pobj2, req) {
    if (!pobj.id) {
      return system.getResult(null, `参数错误 订单ID不能为空`);
    }
    if (!pobj.status) {
      return system.getResult(null, `参数错误 订单状态不能为空`);
    }

    if (pobj.status == "1160") {
      
      if (!pobj.audit_remark) {
        return system.getResult(null, `参数错误 交付审核备注不能为空`);
      }
      if (!pobj.deliver_content) {
        return system.getResult(null, `参数错误 交付内容注不能为空`);
      }
      if (!pobj.deliver_mail_addr) {
        return system.getResult(null, `参数错误 交付地址不能为空`);
      }
      if (!pobj.deliver_mail_to) {
        return system.getResult(null, `参数错误 收件人不能为空`);
      }
      if (!pobj.deliver_mail_mobile) {
        return system.getResult(null, `参数错误 联系电话不能为空`);
      }
    }
    try {
      return await this.orderSve.handleStatus(pobj);
    } catch (error) {
      console.log(error);
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  /**
   * 平台验收
   * @param {*} params 
   */
  async platformAuditDetermine(pobj, pobj2, req) {
    if (!pobj.id) {
      return system.getResult(null, `参数错误 订单ID不能为空`);
    }
    if (!pobj.status) {
      return system.getResult(null, `参数错误 订单ID不能为空`);
    }
    try {
      return await this.orderSve.handleStatus(pobj);
    } catch (error) {
      console.log(error);
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  /**
   * 客户交付
   * @param {*} params 
   */
  async deliverCustomer(pobj, pobj2, req) {
    if (!pobj.id) {
      return system.getResult(null, `参数错误 订单ID不能为空`);
    }
    if (!pobj.status) {
      return system.getResult(null, `参数错误 订单状态不能为空`);
    }
    if (!pobj.guest_mail_no) {
      return system.getResult(null, `参数错误 客户快递单号不能为空`);
    }
    if (!pobj.guest_mail_img) {
      return system.getResult(null, `参数错误 交付商交付快递单号图片不能为空`);
    }
    try {
      return await this.orderSve.handleStatus(pobj);
    } catch (error) {
      console.log(error);
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  /**
   * 订单完成
   * @param {*} params 
   */
  async orderComplete(pobj, pobj2, req) {
    if (!pobj.id) {
      return system.getResult(null, `参数错误 订单ID不能为空`);
    }
    if (!pobj.status) {
      return system.getResult(null, `参数错误 订单状态不能为空`);
    }
    if (!pobj.guest_accpet_file) {
      return system.getResult(null, `参数错误 客户验收文件不能为空`);
    }

    try {
      return await this.orderSve.handleStatus(pobj);
    } catch (error) {
      console.log(error);
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  
}

module.exports = OrderCtl;