(function(f){if(typeof exports==="object"&&typeof module!=="undefined"){module.exports=f()}else if(typeof define==="function"&&define.amd){define([],f)}else{var g;if(typeof window!=="undefined"){g=window}else if(typeof global!=="undefined"){g=global}else if(typeof self!=="undefined"){g=self}else{g=this}g.ExcelJS = f()}})(function(){var define,module,exports;return (function(){function r(e,n,t){function o(i,f){if(!n[i]){if(!e[i]){var c="function"==typeof require&&require;if(!f&&c)return c(i,!0);if(u)return u(i,!0);var a=new Error("Cannot find module '"+i+"'");throw a.code="MODULE_NOT_FOUND",a}var p=n[i]={exports:{}};e[i][0].call(p.exports,function(r){var n=e[i][1][r];return o(n||r)},p,p.exports,r,e,n,t)}return n[i].exports}for(var u="function"==typeof require&&require,i=0;i<t.length;i++)o(t[i]);return o}return r})()({1:[function(require,module,exports){
'use strict';

var PromiseLib = require('../utils/promise');

function setValue(key, value, overwrite) {
  if (overwrite === undefined) {
    // only avoid overwrite if explicitly disabled
    overwrite = true;
  }

  switch (key.toLowerCase()) {
    case 'promise':
      if (!overwrite && PromiseLib.Promise) return;
      PromiseLib.Promise = value;
      break;

    default:
      break;
  }
}

module.exports = setValue;


},{"../utils/promise":20}],2:[function(require,module,exports){
'use strict';

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

var fs = require('fs');

var csv = require('fast-csv');

var moment = require('moment');

var PromiseLib = require('../utils/promise');

var StreamBuf = require('../utils/stream-buf');

var utils = require('../utils/utils');

var CSV = module.exports = function (workbook) {
  this.workbook = workbook;
  this.worksheet = null;
};
/* eslint-disable quote-props */


var SpecialValues = {
  "true": true,
  "false": false,
  '#N/A': {
    error: '#N/A'
  },
  '#REF!': {
    error: '#REF!'
  },
  '#NAME?': {
    error: '#NAME?'
  },
  '#DIV/0!': {
    error: '#DIV/0!'
  },
  '#NULL!': {
    error: '#NULL!'
  },
  '#VALUE!': {
    error: '#VALUE!'
  },
  '#NUM!': {
    error: '#NUM!'
  }
};
/* eslint-ensable quote-props */

CSV.prototype = {
  readFile: function readFile(filename, options) {
    var self = this;
    options = options || {};
    var stream;
    return utils.fs.exists(filename).then(function (exists) {
      if (!exists) {
        throw new Error("File not found: ".concat(filename));
      }

      stream = fs.createReadStream(filename);
      return self.read(stream, options);
    }).then(function (worksheet) {
      stream.close();
      return worksheet;
    });
  },
  read: function read(stream, options) {
    var _this = this;

    options = options || {};
    return new PromiseLib.Promise(function (resolve, reject) {
      var csvStream = _this.createInputStream(options).on('worksheet', resolve).on('error', reject);

      stream.pipe(csvStream);
    });
  },
  createInputStream: function createInputStream(options) {
    options = options || {};
    var worksheet = this.workbook.addWorksheet(options.sheetName);
    var dateFormats = options.dateFormats || [moment.ISO_8601, 'MM-DD-YYYY', 'YYYY-MM-DD'];

    var map = options.map || function (datum) {
      if (datum === '') {
        return null;
      }

      var datumNumber = Number(datum);

      if (!Number.isNaN(datumNumber)) {
        return datumNumber;
      }

      var dt = moment(datum, dateFormats, true);

      if (dt.isValid()) {
        return new Date(dt.valueOf());
      }

      var special = SpecialValues[datum];

      if (special !== undefined) {
        return special;
      }

      return datum;
    };

    var csvStream = csv(options).on('data', function (data) {
      worksheet.addRow(data.map(map));
    }).on('end', function () {
      csvStream.emit('worksheet', worksheet);
    });
    return csvStream;
  },
  write: function write(stream, options) {
    var _this2 = this;

    return new PromiseLib.Promise(function (resolve, reject) {
      options = options || {}; // const encoding = options.encoding || 'utf8';
      // const separator = options.separator || ',';
      // const quoteChar = options.quoteChar || '\'';

      var worksheet = _this2.workbook.getWorksheet(options.sheetName || options.sheetId);

      var csvStream = csv.createWriteStream(options);
      stream.on('finish', function () {
        resolve();
      });
      csvStream.on('error', reject);
      csvStream.pipe(stream);
      var _options = options,
          dateFormat = _options.dateFormat,
          dateUTC = _options.dateUTC;

      var map = options.map || function (value) {
        if (value) {
          if (value.text || value.hyperlink) {
            return value.hyperlink || value.text || '';
          }

          if (value.formula || value.result) {
            return value.result || '';
          }

          if (value instanceof Date) {
            if (dateFormat) {
              return dateUTC ? moment.utc(value).format(dateFormat) : moment(value).format(dateFormat);
            }

            return dateUTC ? moment.utc(value).format() : moment(value).format();
          }

          if (value.error) {
            return value.error;
          }

          if (_typeof(value) === 'object') {
            return JSON.stringify(value);
          }
        }

        return value;
      };

      var includeEmptyRows = options.includeEmptyRows === undefined || options.includeEmptyRows;
      var lastRow = 1;

      if (worksheet) {
        worksheet.eachRow(function (row, rowNumber) {
          if (includeEmptyRows) {
            while (lastRow++ < rowNumber - 1) {
              csvStream.write([]);
            }
          }

          var values = row.values;
          values.shift();
          csvStream.write(values.map(map));
          lastRow = rowNumber;
        });
      }

      csvStream.end();
    });
  },
  writeFile: function writeFile(filename, options) {
    options = options || {};
    var streamOptions = {
      encoding: options.encoding || 'utf8'
    };
    var stream = fs.createWriteStream(filename, streamOptions);
    return this.write(stream, options);
  },
  writeBuffer: function writeBuffer(options) {
    var self = this;
    var stream = new StreamBuf();
    return self.write(stream, options).then(function () {
      return stream.read();
    });
  }
};


},{"../utils/promise":20,"../utils/stream-buf":22,"../utils/utils":25,"fast-csv":206,"fs":160,"moment":275}],3:[function(require,module,exports){
'use strict';

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var colCache = require('../utils/col-cache');

var Anchor =
/*#__PURE__*/
function () {
  function Anchor(worksheet, address) {
    var offset = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;

    _classCallCheck(this, Anchor);

    if (!address) {
      this.nativeCol = 0;
      this.nativeColOff = 0;
      this.nativeRow = 0;
      this.nativeRowOff = 0;
    } else if (typeof address === 'string') {
      var decoded = colCache.decodeAddress(address);
      this.nativeCol = decoded.col + offset;
      this.nativeColOff = 0;
      this.nativeRow = decoded.row + offset;
      this.nativeRowOff = 0;
    } else if (address.nativeCol) {
      this.nativeCol = address.nativeCol || 0;
      this.nativeColOff = address.nativeColOff || 0;
      this.nativeRow = address.nativeRow || 0;
      this.nativeRowOff = address.nativeRowOff || 0;
    } else if (address.col) {
      this.col = address.col + offset;
      this.row = address.row + offset;
    } else {
      this.nativeCol = 0;
      this.nativeColOff = 0;
      this.nativeRow = 0;
      this.nativeRowOff = 0;
    }

    this.worksheet = worksheet;
  }

  _createClass(Anchor, [{
    key: "col",
    get: function get() {
      return this.nativeCol + Math.min(this.colWidth - 1, this.nativeColOff) / this.colWidth;
    },
    set: function set(v) {
      this.nativeCol = Math.floor(v);
      this.nativeColOff = Math.floor((v - this.nativeCol) * this.colWidth);
    }
  }, {
    key: "row",
    get: function get() {
      return this.nativeRow + Math.min(this.rowHeight - 1, this.nativeRowOff) / this.rowHeight;
    },
    set: function set(v) {
      this.nativeRow = Math.floor(v);
      this.nativeRowOff = Math.floor((v - this.nativeRow) * this.rowHeight);
    }
  }, {
    key: "colWidth",
    get: function get() {
      return this.worksheet && this.worksheet.getColumn(this.nativeCol + 1) && this.worksheet.getColumn(this.nativeCol + 1).isCustomWidth ? Math.floor(this.worksheet.getColumn(this.nativeCol + 1).width * 10000) : 640000;
    }
  }, {
    key: "rowHeight",
    get: function get() {
      return this.worksheet && this.worksheet.getRow(this.nativeRow + 1) && this.worksheet.getRow(this.nativeRow + 1).height ? Math.floor(this.worksheet.getRow(this.nativeRow + 1).height * 10000) : 180000;
    }
  }, {
    key: "model",
    get: function get() {
      return {
        nativeCol: this.nativeCol,
        nativeColOff: this.nativeColOff,
        nativeRow: this.nativeRow,
        nativeRowOff: this.nativeRowOff
      };
    },
    set: function set(value) {
      this.nativeCol = value.nativeCol;
      this.nativeColOff = value.nativeColOff;
      this.nativeRow = value.nativeRow;
      this.nativeRowOff = value.nativeRowOff;
    }
  }], [{
    key: "asInstance",
    value: function asInstance(model) {
      return model instanceof Anchor || model == null ? model : new Anchor(model);
    }
  }]);

  return Anchor;
}();

module.exports = Anchor;


},{"../utils/col-cache":18}],4:[function(require,module,exports){
'use strict';

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var colCache = require('../utils/col-cache');

var _ = require('../utils/under-dash');

var Enums = require('./enums');

var _require = require('../utils/shared-formula'),
    slideFormula = _require.slideFormula;

var Note = require('./note'); // Cell requirements
//  Operate inside a worksheet
//  Store and retrieve a value with a range of types: text, number, date, hyperlink, reference, formula, etc.
//  Manage/use and manipulate cell format either as local to cell or inherited from column or row.


var Cell =
/*#__PURE__*/
function () {
  function Cell(row, column, address) {
    _classCallCheck(this, Cell);

    if (!row || !column) {
      throw new Error('A Cell needs a Row');
    }

    this._row = row;
    this._column = column;
    colCache.validateAddress(address);
    this._address = address; // TODO: lazy evaluation of this._value

    this._value = Value.create(Cell.Types.Null, this);
    this.style = this._mergeStyle(row.style, column.style, {});
    this._mergeCount = 0;
  }

  _createClass(Cell, [{
    key: "destroy",
    // help GC by removing cyclic (and other) references
    value: function destroy() {
      delete this.style;
      delete this._value;
      delete this._row;
      delete this._column;
      delete this._address;
    } // =========================================================================
    // Styles stuff

  }, {
    key: "_mergeStyle",
    value: function _mergeStyle(rowStyle, colStyle, style) {
      var numFmt = rowStyle && rowStyle.numFmt || colStyle && colStyle.numFmt;
      if (numFmt) style.numFmt = numFmt;
      var font = rowStyle && rowStyle.font || colStyle && colStyle.font;
      if (font) style.font = font;
      var alignment = rowStyle && rowStyle.alignment || colStyle && colStyle.alignment;
      if (alignment) style.alignment = alignment;
      var border = rowStyle && rowStyle.border || colStyle && colStyle.border;
      if (border) style.border = border;
      var fill = rowStyle && rowStyle.fill || colStyle && colStyle.fill;
      if (fill) style.fill = fill;
      var protection = rowStyle && rowStyle.protection || colStyle && colStyle.protection;
      if (protection) style.protection = protection;
      return style;
    } // =========================================================================
    // return the address for this cell

  }, {
    key: "toCsvString",
    value: function toCsvString() {
      return this._value.toCsvString();
    } // =========================================================================
    // Merge stuff

  }, {
    key: "addMergeRef",
    value: function addMergeRef() {
      this._mergeCount++;
    }
  }, {
    key: "releaseMergeRef",
    value: function releaseMergeRef() {
      this._mergeCount--;
    }
  }, {
    key: "merge",
    value: function merge(master) {
      this._value.release();

      this._value = Value.create(Cell.Types.Merge, this, master);
      this.style = master.style;
    }
  }, {
    key: "unmerge",
    value: function unmerge() {
      if (this.type === Cell.Types.Merge) {
        this._value.release();

        this._value = Value.create(Cell.Types.Null, this);
        this.style = this._mergeStyle(this._row.style, this._column.style, {});
      }
    }
  }, {
    key: "isMergedTo",
    value: function isMergedTo(master) {
      if (this._value.type !== Cell.Types.Merge) return false;
      return this._value.isMergedTo(master);
    }
  }, {
    key: "toString",
    value: function toString() {
      return this.text;
    }
  }, {
    key: "_upgradeToHyperlink",
    value: function _upgradeToHyperlink(hyperlink) {
      // if this cell is a string, turn it into a Hyperlink
      if (this.type === Cell.Types.String) {
        this._value = Value.create(Cell.Types.Hyperlink, this, {
          text: this._value.value,
          hyperlink: hyperlink
        });
      }
    } // =========================================================================
    // Formula stuff

  }, {
    key: "addName",
    value: function addName(name) {
      this.workbook.definedNames.addEx(this.fullAddress, name);
    }
  }, {
    key: "removeName",
    value: function removeName(name) {
      this.workbook.definedNames.removeEx(this.fullAddress, name);
    }
  }, {
    key: "removeAllNames",
    value: function removeAllNames() {
      this.workbook.definedNames.removeAllNames(this.fullAddress);
    } // =========================================================================
    // Data Validation stuff

  }, {
    key: "worksheet",
    get: function get() {
      return this._row.worksheet;
    }
  }, {
    key: "workbook",
    get: function get() {
      return this._row.worksheet.workbook;
    }
  }, {
    key: "numFmt",
    get: function get() {
      return this.style.numFmt;
    },
    set: function set(value) {
      this.style.numFmt = value;
    }
  }, {
    key: "font",
    get: function get() {
      return this.style.font;
    },
    set: function set(value) {
      this.style.font = value;
    }
  }, {
    key: "alignment",
    get: function get() {
      return this.style.alignment;
    },
    set: function set(value) {
      this.style.alignment = value;
    }
  }, {
    key: "border",
    get: function get() {
      return this.style.border;
    },
    set: function set(value) {
      this.style.border = value;
    }
  }, {
    key: "fill",
    get: function get() {
      return this.style.fill;
    },
    set: function set(value) {
      this.style.fill = value;
    }
  }, {
    key: "protection",
    get: function get() {
      return this.style.protection;
    },
    set: function set(value) {
      this.style.protection = value;
    }
  }, {
    key: "address",
    get: function get() {
      return this._address;
    }
  }, {
    key: "row",
    get: function get() {
      return this._row.number;
    }
  }, {
    key: "col",
    get: function get() {
      return this._column.number;
    }
  }, {
    key: "$col$row",
    get: function get() {
      return "$".concat(this._column.letter, "$").concat(this.row);
    } // =========================================================================
    // Value stuff

  }, {
    key: "type",
    get: function get() {
      return this._value.type;
    }
  }, {
    key: "effectiveType",
    get: function get() {
      return this._value.effectiveType;
    }
  }, {
    key: "isMerged",
    get: function get() {
      return this._mergeCount > 0 || this.type === Cell.Types.Merge;
    }
  }, {
    key: "master",
    get: function get() {
      if (this.type === Cell.Types.Merge) {
        return this._value.master;
      }

      return this; // an unmerged cell is its own master
    }
  }, {
    key: "isHyperlink",
    get: function get() {
      return this._value.type === Cell.Types.Hyperlink;
    }
  }, {
    key: "hyperlink",
    get: function get() {
      return this._value.hyperlink;
    } // return the value

  }, {
    key: "value",
    get: function get() {
      return this._value.value;
    } // set the value - can be number, string or raw
    ,
    set: function set(v) {
      // special case - merge cells set their master's value
      if (this.type === Cell.Types.Merge) {
        this._value.master.value = v;
        return;
      }

      this._value.release(); // assign value


      this._value = Value.create(Value.getType(v), this, v);
    }
  }, {
    key: "note",
    get: function get() {
      return this._comment && this._comment.note;
    },
    set: function set(note) {
      this._comment = new Note(note);
    }
  }, {
    key: "text",
    get: function get() {
      return this._value.toString();
    }
  }, {
    key: "html",
    get: function get() {
      return _.escapeHtml(this.text);
    }
  }, {
    key: "formula",
    get: function get() {
      return this._value.formula;
    }
  }, {
    key: "result",
    get: function get() {
      return this._value.result;
    }
  }, {
    key: "formulaType",
    get: function get() {
      return this._value.formulaType;
    } // =========================================================================
    // Name stuff

  }, {
    key: "fullAddress",
    get: function get() {
      var worksheet = this._row.worksheet;
      return {
        sheetName: worksheet.name,
        address: this.address,
        row: this.row,
        col: this.col
      };
    }
  }, {
    key: "name",
    get: function get() {
      return this.names[0];
    },
    set: function set(value) {
      this.names = [value];
    }
  }, {
    key: "names",
    get: function get() {
      return this.workbook.definedNames.getNamesEx(this.fullAddress);
    },
    set: function set(value) {
      var _this = this;

      var definedNames = this.workbook.definedNames;
      definedNames.removeAllNames(this.fullAddress);
      value.forEach(function (name) {
        definedNames.addEx(_this.fullAddress, name);
      });
    }
  }, {
    key: "_dataValidations",
    get: function get() {
      return this.worksheet.dataValidations;
    }
  }, {
    key: "dataValidation",
    get: function get() {
      return this._dataValidations.find(this.address);
    },
    set: function set(value) {
      this._dataValidations.add(this.address, value);
    } // =========================================================================
    // Model stuff

  }, {
    key: "model",
    get: function get() {
      var model = this._value.model;
      model.style = this.style;

      if (this._comment) {
        model.comment = this._comment.model;
      }

      return model;
    },
    set: function set(value) {
      this._value.release();

      this._value = Value.create(value.type, this);
      this._value.model = value;

      if (value.comment) {
        switch (value.comment.type) {
          case 'note':
            this._comment = new Note(value.comment.note);
            break;
        }
      }

      if (value.style) {
        this.style = value.style;
      } else {
        this.style = {};
      }
    }
  }]);

  return Cell;
}();

Cell.Types = Enums.ValueType; // =============================================================================
// Internal Value Types

var NullValue =
/*#__PURE__*/
function () {
  function NullValue(cell) {
    _classCallCheck(this, NullValue);

    this.model = {
      address: cell.address,
      type: Cell.Types.Null
    };
  }

  _createClass(NullValue, [{
    key: "toCsvString",
    value: function toCsvString() {
      return '';
    }
  }, {
    key: "release",
    value: function release() {}
  }, {
    key: "toString",
    value: function toString() {
      return '';
    }
  }, {
    key: "value",
    get: function get() {
      return null;
    },
    set: function set(value) {// nothing to do
    }
  }, {
    key: "type",
    get: function get() {
      return Cell.Types.Null;
    }
  }, {
    key: "effectiveType",
    get: function get() {
      return Cell.Types.Null;
    }
  }, {
    key: "address",
    get: function get() {
      return this.model.address;
    },
    set: function set(value) {
      this.model.address = value;
    }
  }]);

  return NullValue;
}();

var NumberValue =
/*#__PURE__*/
function () {
  function NumberValue(cell, value) {
    _classCallCheck(this, NumberValue);

    this.model = {
      address: cell.address,
      type: Cell.Types.Number,
      value: value
    };
  }

  _createClass(NumberValue, [{
    key: "toCsvString",
    value: function toCsvString() {
      return this.model.value.toString();
    }
  }, {
    key: "release",
    value: function release() {}
  }, {
    key: "toString",
    value: function toString() {
      return this.model.value.toString();
    }
  }, {
    key: "value",
    get: function get() {
      return this.model.value;
    },
    set: function set(value) {
      this.model.value = value;
    }
  }, {
    key: "type",
    get: function get() {
      return Cell.Types.Number;
    }
  }, {
    key: "effectiveType",
    get: function get() {
      return Cell.Types.Number;
    }
  }, {
    key: "address",
    get: function get() {
      return this.model.address;
    },
    set: function set(value) {
      this.model.address = value;
    }
  }]);

  return NumberValue;
}();

var StringValue =
/*#__PURE__*/
function () {
  function StringValue(cell, value) {
    _classCallCheck(this, StringValue);

    this.model = {
      address: cell.address,
      type: Cell.Types.String,
      value: value
    };
  }

  _createClass(StringValue, [{
    key: "toCsvString",
    value: function toCsvString() {
      return "\"".concat(this.model.value.replace(/"/g, '""'), "\"");
    }
  }, {
    key: "release",
    value: function release() {}
  }, {
    key: "toString",
    value: function toString() {
      return this.model.value;
    }
  }, {
    key: "value",
    get: function get() {
      return this.model.value;
    },
    set: function set(value) {
      this.model.value = value;
    }
  }, {
    key: "type",
    get: function get() {
      return Cell.Types.String;
    }
  }, {
    key: "effectiveType",
    get: function get() {
      return Cell.Types.String;
    }
  }, {
    key: "address",
    get: function get() {
      return this.model.address;
    },
    set: function set(value) {
      this.model.address = value;
    }
  }]);

  return StringValue;
}();

var RichTextValue =
/*#__PURE__*/
function () {
  function RichTextValue(cell, value) {
    _classCallCheck(this, RichTextValue);

    this.model = {
      address: cell.address,
      type: Cell.Types.String,
      value: value
    };
  }

  _createClass(RichTextValue, [{
    key: "toString",
    value: function toString() {
      return this.model.value.richText.map(function (t) {
        return t.text;
      }).join('');
    }
  }, {
    key: "toCsvString",
    value: function toCsvString() {
      return "\"".concat(this.text.replace(/"/g, '""'), "\"");
    }
  }, {
    key: "release",
    value: function release() {}
  }, {
    key: "value",
    get: function get() {
      return this.model.value;
    },
    set: function set(value) {
      this.model.value = value;
    }
  }, {
    key: "type",
    get: function get() {
      return Cell.Types.RichText;
    }
  }, {
    key: "effectiveType",
    get: function get() {
      return Cell.Types.RichText;
    }
  }, {
    key: "address",
    get: function get() {
      return this.model.address;
    },
    set: function set(value) {
      this.model.address = value;
    }
  }]);

  return RichTextValue;
}();

var DateValue =
/*#__PURE__*/
function () {
  function DateValue(cell, value) {
    _classCallCheck(this, DateValue);

    this.model = {
      address: cell.address,
      type: Cell.Types.Date,
      value: value
    };
  }

  _createClass(DateValue, [{
    key: "toCsvString",
    value: function toCsvString() {
      return this.model.value.toISOString();
    }
  }, {
    key: "release",
    value: function release() {}
  }, {
    key: "toString",
    value: function toString() {
      return this.model.value.toString();
    }
  }, {
    key: "value",
    get: function get() {
      return this.model.value;
    },
    set: function set(value) {
      this.model.value = value;
    }
  }, {
    key: "type",
    get: function get() {
      return Cell.Types.Date;
    }
  }, {
    key: "effectiveType",
    get: function get() {
      return Cell.Types.Date;
    }
  }, {
    key: "address",
    get: function get() {
      return this.model.address;
    },
    set: function set(value) {
      this.model.address = value;
    }
  }]);

  return DateValue;
}();

var HyperlinkValue =
/*#__PURE__*/
function () {
  function HyperlinkValue(cell, value) {
    _classCallCheck(this, HyperlinkValue);

    this.model = Object.assign({
      address: cell.address,
      type: Cell.Types.Hyperlink,
      text: value ? value.text : undefined,
      hyperlink: value ? value.hyperlink : undefined
    }, value && value.tooltip ? {
      tooltip: value.tooltip
    } : {});
  }

  _createClass(HyperlinkValue, [{
    key: "toCsvString",
    value: function toCsvString() {
      return this.model.hyperlink;
    }
  }, {
    key: "release",
    value: function release() {}
  }, {
    key: "toString",
    value: function toString() {
      return this.model.text;
    }
  }, {
    key: "value",
    get: function get() {
      return Object.assign({
        text: this.model.text,
        hyperlink: this.model.hyperlink
      }, this.model.tooltip ? {
        tooltip: this.model.tooltip
      } : {});
    },
    set: function set(value) {
      this.model = Object.assign({
        text: value.text,
        hyperlink: value.hyperlink
      }, value && value.tooltip ? {
        tooltip: value.tooltip
      } : {});
    }
  }, {
    key: "text",
    get: function get() {
      return this.model.text;
    },
    set: function set(value) {
      this.model.text = value;
    }
    /*
    get tooltip() {
      return this.model.tooltip;
    }
     set tooltip(value) {
      this.model.tooltip = value;
    } */

  }, {
    key: "hyperlink",
    get: function get() {
      return this.model.hyperlink;
    },
    set: function set(value) {
      this.model.hyperlink = value;
    }
  }, {
    key: "type",
    get: function get() {
      return Cell.Types.Hyperlink;
    }
  }, {
    key: "effectiveType",
    get: function get() {
      return Cell.Types.Hyperlink;
    }
  }, {
    key: "address",
    get: function get() {
      return this.model.address;
    },
    set: function set(value) {
      this.model.address = value;
    }
  }]);

  return HyperlinkValue;
}();

var MergeValue =
/*#__PURE__*/
function () {
  function MergeValue(cell, master) {
    _classCallCheck(this, MergeValue);

    this.model = {
      address: cell.address,
      type: Cell.Types.Merge,
      master: master ? master.address : undefined
    };
    this._master = master;

    if (master) {
      master.addMergeRef();
    }
  }

  _createClass(MergeValue, [{
    key: "isMergedTo",
    value: function isMergedTo(master) {
      return master === this._master;
    }
  }, {
    key: "toCsvString",
    value: function toCsvString() {
      return '';
    }
  }, {
    key: "release",
    value: function release() {
      this._master.releaseMergeRef();
    }
  }, {
    key: "toString",
    value: function toString() {
      return this.value.toString();
    }
  }, {
    key: "value",
    get: function get() {
      return this._master.value;
    },
    set: function set(value) {
      if (value instanceof Cell) {
        if (this._master) {
          this._master.releaseMergeRef();
        }

        value.addMergeRef();
        this._master = value;
      } else {
        this._master.value = value;
      }
    }
  }, {
    key: "master",
    get: function get() {
      return this._master;
    }
  }, {
    key: "type",
    get: function get() {
      return Cell.Types.Merge;
    }
  }, {
    key: "effectiveType",
    get: function get() {
      return this._master.effectiveType;
    }
  }, {
    key: "address",
    get: function get() {
      return this.model.address;
    },
    set: function set(value) {
      this.model.address = value;
    }
  }]);

  return MergeValue;
}();

var FormulaValue =
/*#__PURE__*/
function () {
  function FormulaValue(cell, value) {
    _classCallCheck(this, FormulaValue);

    this.cell = cell;
    this.model = {
      address: cell.address,
      type: Cell.Types.Formula,
      formula: value ? value.formula : undefined,
      sharedFormula: value ? value.sharedFormula : undefined,
      result: value ? value.result : undefined
    };
  }

  _createClass(FormulaValue, [{
    key: "validate",
    value: function validate(value) {
      switch (Value.getType(value)) {
        case Cell.Types.Null:
        case Cell.Types.String:
        case Cell.Types.Number:
        case Cell.Types.Date:
          break;

        case Cell.Types.Hyperlink:
        case Cell.Types.Formula:
        default:
          throw new Error('Cannot process that type of result value');
      }
    }
  }, {
    key: "_getTranslatedFormula",
    value: function _getTranslatedFormula() {
      if (!this._translatedFormula && this.model.sharedFormula) {
        var worksheet = this.cell.worksheet;
        var master = worksheet.findCell(this.model.sharedFormula);
        this._translatedFormula = master && slideFormula(master.formula, master.address, this.model.address);
      }

      return this._translatedFormula;
    }
  }, {
    key: "toCsvString",
    value: function toCsvString() {
      return "".concat(this.model.result || '');
    }
  }, {
    key: "release",
    value: function release() {}
  }, {
    key: "toString",
    value: function toString() {
      return this.model.result ? this.model.result.toString() : '';
    }
  }, {
    key: "value",
    get: function get() {
      return this.model.formula ? {
        formula: this.model.formula,
        result: this.model.result
      } : {
        sharedFormula: this.model.sharedFormula,
        result: this.model.result
      };
    },
    set: function set(value) {
      this.model.formula = value.formula;
      this.model.sharedFormula = value.sharedFormula;
      this.model.result = value.result;
    }
  }, {
    key: "dependencies",
    get: function get() {
      // find all the ranges and cells mentioned in the formula
      var ranges = this.formula.match(/([a-zA-Z0-9]+!)?[A-Z]{1,3}\d{1,4}:[A-Z]{1,3}\d{1,4}/g);
      var cells = this.formula.replace(/([a-zA-Z0-9]+!)?[A-Z]{1,3}\d{1,4}:[A-Z]{1,3}\d{1,4}/g, '').match(/([a-zA-Z0-9]+!)?[A-Z]{1,3}\d{1,4}/g);
      return {
        ranges: ranges,
        cells: cells
      };
    }
  }, {
    key: "formula",
    get: function get() {
      return this.model.formula || this._getTranslatedFormula();
    },
    set: function set(value) {
      this.model.formula = value;
    }
  }, {
    key: "formulaType",
    get: function get() {
      if (this.model.formula) {
        return Enums.FormulaType.Master;
      }

      if (this.model.sharedFormula) {
        return Enums.FormulaType.Shared;
      }

      return Enums.FormulaType.None;
    }
  }, {
    key: "result",
    get: function get() {
      return this.model.result;
    },
    set: function set(value) {
      this.model.result = value;
    }
  }, {
    key: "type",
    get: function get() {
      return Cell.Types.Formula;
    }
  }, {
    key: "effectiveType",
    get: function get() {
      var v = this.model.result;

      if (v === null || v === undefined) {
        return Enums.ValueType.Null;
      }

      if (v instanceof String || typeof v === 'string') {
        return Enums.ValueType.String;
      }

      if (typeof v === 'number') {
        return Enums.ValueType.Number;
      }

      if (v instanceof Date) {
        return Enums.ValueType.Date;
      }

      if (v.text && v.hyperlink) {
        return Enums.ValueType.Hyperlink;
      }

      if (v.formula) {
        return Enums.ValueType.Formula;
      }

      return Enums.ValueType.Null;
    }
  }, {
    key: "address",
    get: function get() {
      return this.model.address;
    },
    set: function set(value) {
      this.model.address = value;
    }
  }]);

  return FormulaValue;
}();

var SharedStringValue =
/*#__PURE__*/
function () {
  function SharedStringValue(cell, value) {
    _classCallCheck(this, SharedStringValue);

    this.model = {
      address: cell.address,
      type: Cell.Types.SharedString,
      value: value
    };
  }

  _createClass(SharedStringValue, [{
    key: "toCsvString",
    value: function toCsvString() {
      return this.model.value.toString();
    }
  }, {
    key: "release",
    value: function release() {}
  }, {
    key: "toString",
    value: function toString() {
      return this.model.value.toString();
    }
  }, {
    key: "value",
    get: function get() {
      return this.model.value;
    },
    set: function set(value) {
      this.model.value = value;
    }
  }, {
    key: "type",
    get: function get() {
      return Cell.Types.SharedString;
    }
  }, {
    key: "effectiveType",
    get: function get() {
      return Cell.Types.SharedString;
    }
  }, {
    key: "address",
    get: function get() {
      return this.model.address;
    },
    set: function set(value) {
      this.model.address = value;
    }
  }]);

  return SharedStringValue;
}();

var BooleanValue =
/*#__PURE__*/
function () {
  function BooleanValue(cell, value) {
    _classCallCheck(this, BooleanValue);

    this.model = {
      address: cell.address,
      type: Cell.Types.Boolean,
      value: value
    };
  }

  _createClass(BooleanValue, [{
    key: "toCsvString",
    value: function toCsvString() {
      return this.model.value ? 1 : 0;
    }
  }, {
    key: "release",
    value: function release() {}
  }, {
    key: "toString",
    value: function toString() {
      return this.model.value.toString();
    }
  }, {
    key: "value",
    get: function get() {
      return this.model.value;
    },
    set: function set(value) {
      this.model.value = value;
    }
  }, {
    key: "type",
    get: function get() {
      return Cell.Types.Boolean;
    }
  }, {
    key: "effectiveType",
    get: function get() {
      return Cell.Types.Boolean;
    }
  }, {
    key: "address",
    get: function get() {
      return this.model.address;
    },
    set: function set(value) {
      this.model.address = value;
    }
  }]);

  return BooleanValue;
}();

var ErrorValue =
/*#__PURE__*/
function () {
  function ErrorValue(cell, value) {
    _classCallCheck(this, ErrorValue);

    this.model = {
      address: cell.address,
      type: Cell.Types.Error,
      value: value
    };
  }

  _createClass(ErrorValue, [{
    key: "toCsvString",
    value: function toCsvString() {
      return this.toString();
    }
  }, {
    key: "release",
    value: function release() {}
  }, {
    key: "toString",
    value: function toString() {
      return this.model.value.error.toString();
    }
  }, {
    key: "value",
    get: function get() {
      return this.model.value;
    },
    set: function set(value) {
      this.model.value = value;
    }
  }, {
    key: "type",
    get: function get() {
      return Cell.Types.Error;
    }
  }, {
    key: "effectiveType",
    get: function get() {
      return Cell.Types.Error;
    }
  }, {
    key: "address",
    get: function get() {
      return this.model.address;
    },
    set: function set(value) {
      this.model.address = value;
    }
  }]);

  return ErrorValue;
}();

var JSONValue =
/*#__PURE__*/
function () {
  function JSONValue(cell, value) {
    _classCallCheck(this, JSONValue);

    this.model = {
      address: cell.address,
      type: Cell.Types.String,
      value: JSON.stringify(value),
      rawValue: value
    };
  }

  _createClass(JSONValue, [{
    key: "toCsvString",
    value: function toCsvString() {
      return this.model.value;
    }
  }, {
    key: "release",
    value: function release() {}
  }, {
    key: "toString",
    value: function toString() {
      return this.model.value;
    }
  }, {
    key: "value",
    get: function get() {
      return this.model.rawValue;
    },
    set: function set(value) {
      this.model.rawValue = value;
      this.model.value = JSON.stringify(value);
    }
  }, {
    key: "type",
    get: function get() {
      return Cell.Types.String;
    }
  }, {
    key: "effectiveType",
    get: function get() {
      return Cell.Types.String;
    }
  }, {
    key: "address",
    get: function get() {
      return this.model.address;
    },
    set: function set(value) {
      this.model.address = value;
    }
  }]);

  return JSONValue;
}(); // Value is a place to hold common static Value type functions


var Value = {
  getType: function getType(value) {
    if (value === null || value === undefined) {
      return Cell.Types.Null;
    }

    if (value instanceof String || typeof value === 'string') {
      return Cell.Types.String;
    }

    if (typeof value === 'number') {
      return Cell.Types.Number;
    }

    if (typeof value === 'boolean') {
      return Cell.Types.Boolean;
    }

    if (value instanceof Date) {
      return Cell.Types.Date;
    }

    if (value.text && value.hyperlink) {
      return Cell.Types.Hyperlink;
    }

    if (value.formula || value.sharedFormula) {
      return Cell.Types.Formula;
    }

    if (value.richText) {
      return Cell.Types.RichText;
    }

    if (value.sharedString) {
      return Cell.Types.SharedString;
    }

    if (value.error) {
      return Cell.Types.Error;
    }

    return Cell.Types.JSON;
  },
  // map valueType to constructor
  types: [{
    t: Cell.Types.Null,
    f: NullValue
  }, {
    t: Cell.Types.Number,
    f: NumberValue
  }, {
    t: Cell.Types.String,
    f: StringValue
  }, {
    t: Cell.Types.Date,
    f: DateValue
  }, {
    t: Cell.Types.Hyperlink,
    f: HyperlinkValue
  }, {
    t: Cell.Types.Formula,
    f: FormulaValue
  }, {
    t: Cell.Types.Merge,
    f: MergeValue
  }, {
    t: Cell.Types.JSON,
    f: JSONValue
  }, {
    t: Cell.Types.SharedString,
    f: SharedStringValue
  }, {
    t: Cell.Types.RichText,
    f: RichTextValue
  }, {
    t: Cell.Types.Boolean,
    f: BooleanValue
  }, {
    t: Cell.Types.Error,
    f: ErrorValue
  }].reduce(function (p, t) {
    p[t.t] = t.f;
    return p;
  }, []),
  create: function create(type, cell, value) {
    var T = this.types[type];

    if (!T) {
      throw new Error("Could not create Value of type ".concat(type));
    }

    return new T(cell, value);
  }
};
module.exports = Cell;


},{"../utils/col-cache":18,"../utils/shared-formula":21,"../utils/under-dash":24,"./enums":8,"./note":10}],5:[function(require,module,exports){
'use strict';

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var _ = require('../utils/under-dash');

var Enums = require('./enums');

var colCache = require('../utils/col-cache'); // Column defines the column properties for 1 column.
// This includes header rows, widths, key, (style), etc.
// Worksheet will condense the columns as appropriate during serialization


var Column =
/*#__PURE__*/
function () {
  function Column(worksheet, number, defn) {
    _classCallCheck(this, Column);

    this._worksheet = worksheet;
    this._number = number;

    if (defn !== false) {
      // sometimes defn will follow
      this.defn = defn;
    }
  }

  _createClass(Column, [{
    key: "toString",
    value: function toString() {
      return JSON.stringify({
        key: this.key,
        width: this.width,
        headers: this.headers.length ? this.headers : undefined
      });
    }
  }, {
    key: "equivalentTo",
    value: function equivalentTo(other) {
      return this.width === other.width && this.hidden === other.hidden && this.outlineLevel === other.outlineLevel && _.isEqual(this.style, other.style);
    }
  }, {
    key: "eachCell",
    value: function eachCell(options, iteratee) {
      var colNumber = this.number;

      if (!iteratee) {
        iteratee = options;
        options = null;
      }

      this._worksheet.eachRow(options, function (row, rowNumber) {
        iteratee(row.getCell(colNumber), rowNumber);
      });
    }
  }, {
    key: "_applyStyle",
    // =========================================================================
    // styles
    value: function _applyStyle(name, value) {
      this.style[name] = value;
      this.eachCell(function (cell) {
        cell[name] = value;
      });
      return value;
    }
  }, {
    key: "number",
    get: function get() {
      return this._number;
    }
  }, {
    key: "worksheet",
    get: function get() {
      return this._worksheet;
    }
  }, {
    key: "letter",
    get: function get() {
      return colCache.n2l(this._number);
    }
  }, {
    key: "isCustomWidth",
    get: function get() {
      return this.width !== undefined && this.width !== 8;
    }
  }, {
    key: "defn",
    get: function get() {
      return {
        header: this._header,
        key: this.key,
        width: this.width,
        style: this.style,
        hidden: this.hidden,
        outlineLevel: this.outlineLevel
      };
    },
    set: function set(value) {
      if (value) {
        this.key = value.key;
        this.width = value.width;
        this.outlineLevel = value.outlineLevel;

        if (value.style) {
          this.style = value.style;
        } else {
          this.style = {};
        } // headers must be set after style


        this.header = value.header;
        this._hidden = !!value.hidden;
      } else {
        delete this._header;
        delete this._key;
        delete this.width;
        this.style = {};
        this.outlineLevel = 0;
      }
    }
  }, {
    key: "headers",
    get: function get() {
      return this._header && this._header instanceof Array ? this._header : [this._header];
    }
  }, {
    key: "header",
    get: function get() {
      return this._header;
    },
    set: function set(value) {
      var _this = this;

      if (value !== undefined) {
        this._header = value;
        this.headers.forEach(function (text, index) {
          _this._worksheet.getCell(index + 1, _this.number).value = text;
        });
      } else {
        this._header = undefined;
      }
    }
  }, {
    key: "key",
    get: function get() {
      return this._key;
    },
    set: function set(value) {
      var column = this._key && this._worksheet.getColumnKey(this._key);

      if (column === this) {
        this._worksheet.deleteColumnKey(this._key);
      }

      this._key = value;

      if (value) {
        this._worksheet.setColumnKey(this._key, this);
      }
    }
  }, {
    key: "hidden",
    get: function get() {
      return !!this._hidden;
    },
    set: function set(value) {
      this._hidden = value;
    }
  }, {
    key: "outlineLevel",
    get: function get() {
      return this._outlineLevel || 0;
    },
    set: function set(value) {
      this._outlineLevel = value;
    }
  }, {
    key: "collapsed",
    get: function get() {
      return !!(this._outlineLevel && this._outlineLevel >= this._worksheet.properties.outlineLevelCol);
    }
  }, {
    key: "isDefault",
    get: function get() {
      if (this.isCustomWidth) {
        return false;
      }

      if (this.hidden) {
        return false;
      }

      if (this.outlineLevel) {
        return false;
      }

      var s = this.style;

      if (s && (s.font || s.numFmt || s.alignment || s.border || s.fill || s.protection)) {
        return false;
      }

      return true;
    }
  }, {
    key: "headerCount",
    get: function get() {
      return this.headers.length;
    }
  }, {
    key: "values",
    get: function get() {
      var v = [];
      this.eachCell(function (cell, rowNumber) {
        if (cell && cell.type !== Enums.ValueType.Null) {
          v[rowNumber] = cell.value;
        }
      });
      return v;
    },
    set: function set(v) {
      var _this2 = this;

      if (!v) {
        return;
      }

      var colNumber = this.number;
      var offset = 0;

      if (v.hasOwnProperty('0')) {
        // assume contiguous array, start at row 1
        offset = 1;
      }

      v.forEach(function (value, index) {
        _this2._worksheet.getCell(index + offset, colNumber).value = value;
      });
    }
  }, {
    key: "numFmt",
    get: function get() {
      return this.style.numFmt;
    },
    set: function set(value) {
      this._applyStyle('numFmt', value);
    }
  }, {
    key: "font",
    get: function get() {
      return this.style.font;
    },
    set: function set(value) {
      this._applyStyle('font', value);
    }
  }, {
    key: "alignment",
    get: function get() {
      return this.style.alignment;
    },
    set: function set(value) {
      this._applyStyle('alignment', value);
    }
  }, {
    key: "protection",
    get: function get() {
      return this.style.protection;
    },
    set: function set(value) {
      this._applyStyle('protection', value);
    }
  }, {
    key: "border",
    get: function get() {
      return this.style.border;
    },
    set: function set(value) {
      this._applyStyle('border', value);
    }
  }, {
    key: "fill",
    get: function get() {
      return this.style.fill;
    },
    set: function set(value) {
      this._applyStyle('fill', value);
    } // =============================================================================
    // static functions

  }], [{
    key: "toModel",
    value: function toModel(columns) {
      // Convert array of Column into compressed list cols
      var cols = [];
      var col = null;

      if (columns) {
        columns.forEach(function (column, index) {
          if (column.isDefault) {
            if (col) {
              col = null;
            }
          } else if (!col || !column.equivalentTo(col)) {
            col = {
              min: index + 1,
              max: index + 1,
              width: column.width,
              style: column.style,
              isCustomWidth: column.isCustomWidth,
              hidden: column.hidden,
              outlineLevel: column.outlineLevel,
              collapsed: column.collapsed
            };
            cols.push(col);
          } else {
            col.max = index + 1;
          }
        });
      }

      return cols.length ? cols : undefined;
    }
  }, {
    key: "fromModel",
    value: function fromModel(worksheet, cols) {
      cols = cols || [];
      var columns = [];
      var count = 1;
      var index = 0;

      while (index < cols.length) {
        var col = cols[index++];

        while (count < col.min) {
          columns.push(new Column(worksheet, count++));
        }

        while (count <= col.max) {
          columns.push(new Column(worksheet, count++, col));
        }
      }

      return columns.length ? columns : null;
    }
  }]);

  return Column;
}();

module.exports = Column;


},{"../utils/col-cache":18,"../utils/under-dash":24,"./enums":8}],6:[function(require,module,exports){
'use strict';

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var DataValidations =
/*#__PURE__*/
function () {
  function DataValidations(model) {
    _classCallCheck(this, DataValidations);

    this.model = model || {};
  }

  _createClass(DataValidations, [{
    key: "add",
    value: function add(address, validation) {
      return this.model[address] = validation;
    }
  }, {
    key: "find",
    value: function find(address) {
      return this.model[address];
    }
  }, {
    key: "remove",
    value: function remove(address) {
      this.model[address] = undefined;
    }
  }]);

  return DataValidations;
}();

module.exports = DataValidations;


},{}],7:[function(require,module,exports){
'use strict';

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var _ = require('../utils/under-dash');

var colCache = require('../utils/col-cache');

var CellMatrix = require('../utils/cell-matrix');

var Range = require('./range');

var rangeRegexp = /[$](\w+)[$](\d+)(:[$](\w+)[$](\d+))?/;

var DefinedNames =
/*#__PURE__*/
function () {
  function DefinedNames() {
    _classCallCheck(this, DefinedNames);

    this.matrixMap = {};
  }

  _createClass(DefinedNames, [{
    key: "getMatrix",
    value: function getMatrix(name) {
      var matrix = this.matrixMap[name] || (this.matrixMap[name] = new CellMatrix());
      return matrix;
    } // add a name to a cell. locStr in the form SheetName!$col$row or SheetName!$c1$r1:$c2:$r2

  }, {
    key: "add",
    value: function add(locStr, name) {
      var location = colCache.decodeEx(locStr);
      this.addEx(location, name);
    }
  }, {
    key: "addEx",
    value: function addEx(location, name) {
      var matrix = this.getMatrix(name);

      if (location.top) {
        for (var col = location.left; col <= location.right; col++) {
          for (var row = location.top; row <= location.bottom; row++) {
            var address = {
              sheetName: location.sheetName,
              address: colCache.n2l(col) + row,
              row: row,
              col: col
            };
            matrix.addCellEx(address);
          }
        }
      } else {
        matrix.addCellEx(location);
      }
    }
  }, {
    key: "remove",
    value: function remove(locStr, name) {
      var location = colCache.decodeEx(locStr);
      this.removeEx(location, name);
    }
  }, {
    key: "removeEx",
    value: function removeEx(location, name) {
      var matrix = this.getMatrix(name);
      matrix.removeCellEx(location);
    }
  }, {
    key: "removeAllNames",
    value: function removeAllNames(location) {
      _.each(this.matrixMap, function (matrix) {
        matrix.removeCellEx(location);
      });
    }
  }, {
    key: "forEach",
    value: function forEach(callback) {
      _.each(this.matrixMap, function (matrix, name) {
        matrix.forEach(function (cell) {
          callback(name, cell);
        });
      });
    } // get all the names of a cell

  }, {
    key: "getNames",
    value: function getNames(addressStr) {
      return this.getNamesEx(colCache.decodeEx(addressStr));
    }
  }, {
    key: "getNamesEx",
    value: function getNamesEx(address) {
      return _.map(this.matrixMap, function (matrix, name) {
        return matrix.findCellEx(address) && name;
      }).filter(Boolean);
    }
  }, {
    key: "_explore",
    value: function _explore(matrix, cell) {
      cell.mark = false;
      var sheetName = cell.sheetName;
      var range = new Range(cell.row, cell.col, cell.row, cell.col, sheetName);
      var x;
      var y; // grow vertical - only one col to worry about

      function vGrow(yy, edge) {
        var c = matrix.findCellAt(sheetName, yy, cell.col);

        if (!c || !c.mark) {
          return false;
        }

        range[edge] = yy;
        c.mark = false;
        return true;
      }

      for (y = cell.row - 1; vGrow(y, 'top'); y--) {
        ;
      }

      for (y = cell.row + 1; vGrow(y, 'bottom'); y++) {
        ;
      } // grow horizontal - ensure all rows can grow


      function hGrow(xx, edge) {
        var cells = [];

        for (y = range.top; y <= range.bottom; y++) {
          var c = matrix.findCellAt(sheetName, y, xx);

          if (c && c.mark) {
            cells.push(c);
          } else {
            return false;
          }
        }

        range[edge] = xx;

        for (var i = 0; i < cells.length; i++) {
          cells[i].mark = false;
        }

        return true;
      }

      for (x = cell.col - 1; hGrow(x, 'left'); x--) {
        ;
      }

      for (x = cell.col + 1; hGrow(x, 'right'); x++) {
        ;
      }

      return range;
    }
  }, {
    key: "getRanges",
    value: function getRanges(name, matrix) {
      var _this = this;

      matrix = matrix || this.matrixMap[name];

      if (!matrix) {
        return {
          name: name,
          ranges: []
        };
      } // mark and sweep!


      matrix.forEach(function (cell) {
        cell.mark = true;
      });
      var ranges = matrix.map(function (cell) {
        return cell.mark && _this._explore(matrix, cell);
      }).filter(Boolean).map(function (range) {
        return range.$shortRange;
      });
      return {
        name: name,
        ranges: ranges
      };
    }
  }, {
    key: "normaliseMatrix",
    value: function normaliseMatrix(matrix, sheetName) {
      // some of the cells might have shifted on specified sheet
      // need to reassign rows, cols
      matrix.forEachInSheet(sheetName, function (cell, row, col) {
        if (cell) {
          if (cell.row !== row || cell.col !== col) {
            cell.row = row;
            cell.col = col;
            cell.address = colCache.n2l(col) + row;
          }
        }
      });
    }
  }, {
    key: "spliceRows",
    value: function spliceRows(sheetName, start, numDelete, numInsert) {
      var _this2 = this;

      _.each(this.matrixMap, function (matrix) {
        matrix.spliceRows(sheetName, start, numDelete, numInsert);

        _this2.normaliseMatrix(matrix, sheetName);
      });
    }
  }, {
    key: "spliceColumns",
    value: function spliceColumns(sheetName, start, numDelete, numInsert) {
      var _this3 = this;

      _.each(this.matrixMap, function (matrix) {
        matrix.spliceColumns(sheetName, start, numDelete, numInsert);

        _this3.normaliseMatrix(matrix, sheetName);
      });
    }
  }, {
    key: "model",
    get: function get() {
      var _this4 = this;

      // To get names per cell - just iterate over all names finding cells if they exist
      return _.map(this.matrixMap, function (matrix, name) {
        return _this4.getRanges(name, matrix);
      }).filter(function (definedName) {
        return definedName.ranges.length;
      });
    },
    set: function set(value) {
      // value is [ { name, ranges }, ... ]
      var matrixMap = this.matrixMap = {};
      value.forEach(function (definedName) {
        var matrix = matrixMap[definedName.name] = new CellMatrix();
        definedName.ranges.forEach(function (rangeStr) {
          if (rangeRegexp.test(rangeStr.split('!').pop() || '')) {
            matrix.addCell(rangeStr);
          }
        });
      });
    }
  }]);

  return DefinedNames;
}();

module.exports = DefinedNames;


},{"../utils/cell-matrix":17,"../utils/col-cache":18,"../utils/under-dash":24,"./range":11}],8:[function(require,module,exports){
'use strict';

module.exports = {
  ValueType: {
    Null: 0,
    Merge: 1,
    Number: 2,
    String: 3,
    Date: 4,
    Hyperlink: 5,
    Formula: 6,
    SharedString: 7,
    RichText: 8,
    Boolean: 9,
    Error: 10
  },
  FormulaType: {
    None: 0,
    Master: 1,
    Shared: 2
  },
  RelationshipType: {
    None: 0,
    OfficeDocument: 1,
    Worksheet: 2,
    CalcChain: 3,
    SharedStrings: 4,
    Styles: 5,
    Theme: 6,
    Hyperlink: 7
  },
  DocumentType: {
    Xlsx: 1
  },
  ReadingOrder: {
    LeftToRight: 1,
    RightToLeft: 2
  },
  ErrorValue: {
    NotApplicable: '#N/A',
    Ref: '#REF!',
    Name: '#NAME?',
    DivZero: '#DIV/0!',
    Null: '#NULL!',
    Value: '#VALUE!',
    Num: '#NUM!'
  }
};


},{}],9:[function(require,module,exports){
"use strict";

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var colCache = require('../utils/col-cache');

var Anchor = require('./anchor');

var Image =
/*#__PURE__*/
function () {
  function Image(worksheet, model) {
    _classCallCheck(this, Image);

    this.worksheet = worksheet;
    this.model = model;
  }

  _createClass(Image, [{
    key: "model",
    get: function get() {
      switch (this.type) {
        case 'background':
          return {
            type: this.type,
            imageId: this.imageId
          };

        case 'image':
          return {
            type: this.type,
            imageId: this.imageId,
            range: {
              tl: this.range.tl.model,
              br: this.range.br && this.range.br.model,
              ext: this.range.ext
            }
          };

        default:
          throw new Error('Invalid Image Type');
      }
    },
    set: function set(_ref) {
      var type = _ref.type,
          imageId = _ref.imageId,
          range = _ref.range;
      this.type = type;
      this.imageId = imageId;

      if (type === 'image') {
        if (typeof range === 'string') {
          var decoded = colCache.decode(range);
          this.range = {
            tl: new Anchor(this.worksheet, {
              col: decoded.left,
              row: decoded.top
            }, -1),
            br: new Anchor(this.worksheet, {
              col: decoded.right,
              row: decoded.bottom
            }, 0),
            editAs: 'oneCell'
          };
        } else {
          this.range = {
            tl: new Anchor(this.worksheet, range.tl, 0),
            br: range.br && new Anchor(this.worksheet, range.br, 0),
            ext: range.ext,
            editAs: range.editAs
          };
        }
      }
    }
  }]);

  return Image;
}();

module.exports = Image;


},{"../utils/col-cache":18,"./anchor":3}],10:[function(require,module,exports){
"use strict";

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var Note =
/*#__PURE__*/
function () {
  function Note(note) {
    _classCallCheck(this, Note);

    if (typeof note === 'string') {
      this.note = {
        texts: [{
          text: note
        }]
      };
    } else {
      this.note = note;
    }
  }

  _createClass(Note, [{
    key: "model",
    get: function get() {
      return {
        type: 'note',
        note: this.note
      };
    },
    set: function set(value) {
      this.note = value.note;
    }
  }]);

  return Note;
}();

module.exports = Note;


},{}],11:[function(require,module,exports){
'use strict';

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var colCache = require('./../utils/col-cache'); // used by worksheet to calculate sheet dimensions


var Range =
/*#__PURE__*/
function () {
  function Range() {
    _classCallCheck(this, Range);

    this.decode(arguments);
  }

  _createClass(Range, [{
    key: "setTLBR",
    value: function setTLBR(t, l, b, r, s) {
      if (arguments.length < 4) {
        // setTLBR(tl, br, s)
        var tl = colCache.decodeAddress(t);
        var br = colCache.decodeAddress(l);
        this.model = {
          top: Math.min(tl.row, br.row),
          left: Math.min(tl.col, br.col),
          bottom: Math.max(tl.row, br.row),
          right: Math.max(tl.col, br.col),
          sheetName: b
        };
        this.setTLBR(tl.row, tl.col, br.row, br.col, s);
      } else {
        // setTLBR(t, l, b, r, s)
        this.model = {
          top: Math.min(t, b),
          left: Math.min(l, r),
          bottom: Math.max(t, b),
          right: Math.max(l, r),
          sheetName: s
        };
      }
    }
  }, {
    key: "decode",
    value: function decode(argv) {
      switch (argv.length) {
        case 5:
          // [t,l,b,r,s]
          this.setTLBR(argv[0], argv[1], argv[2], argv[3], argv[4]);
          break;

        case 4:
          // [t,l,b,r]
          this.setTLBR(argv[0], argv[1], argv[2], argv[3]);
          break;

        case 3:
          // [tl,br,s]
          this.setTLBR(argv[0], argv[1], argv[2]);
          break;

        case 2:
          // [tl,br]
          this.setTLBR(argv[0], argv[1]);
          break;

        case 1:
          {
            var value = argv[0];

            if (value instanceof Range) {
              // copy constructor
              this.model = {
                top: value.model.top,
                left: value.model.left,
                bottom: value.model.bottom,
                right: value.model.right,
                sheetName: value.sheetName
              };
            } else if (value instanceof Array) {
              // an arguments array
              this.decode(value);
            } else if (value.top && value.left && value.bottom && value.right) {
              // a model
              this.model = {
                top: value.top,
                left: value.left,
                bottom: value.bottom,
                right: value.right,
                sheetName: value.sheetName
              };
            } else {
              // [sheetName!]tl:br
              var tlbr = colCache.decodeEx(value);

              if (tlbr.top) {
                this.model = {
                  top: tlbr.top,
                  left: tlbr.left,
                  bottom: tlbr.bottom,
                  right: tlbr.right,
                  sheetName: tlbr.sheetName
                };
              } else {
                this.model = {
                  top: tlbr.row,
                  left: tlbr.col,
                  bottom: tlbr.row,
                  right: tlbr.col,
                  sheetName: tlbr.sheetName
                };
              }
            }

            break;
          }

        case 0:
          this.model = {
            top: 0,
            left: 0,
            bottom: 0,
            right: 0
          };
          break;

        default:
          throw new Error("Invalid number of arguments to _getDimensions() - ".concat(argv.length));
      }
    }
  }, {
    key: "expand",
    value: function expand(top, left, bottom, right) {
      if (!this.model.top || top < this.top) this.top = top;
      if (!this.model.left || left < this.left) this.left = left;
      if (!this.model.bottom || bottom > this.bottom) this.bottom = bottom;
      if (!this.model.right || right > this.right) this.right = right;
    }
  }, {
    key: "expandRow",
    value: function expandRow(row) {
      if (row) {
        var dimensions = row.dimensions,
            number = row.number;

        if (dimensions) {
          this.expand(number, dimensions.min, number, dimensions.max);
        }
      }
    }
  }, {
    key: "expandToAddress",
    value: function expandToAddress(addressStr) {
      var address = colCache.decodeEx(addressStr);
      this.expand(address.row, address.col, address.row, address.col);
    }
  }, {
    key: "toString",
    value: function toString() {
      return this.range;
    }
  }, {
    key: "intersects",
    value: function intersects(other) {
      if (other.sheetName && this.sheetName && other.sheetName !== this.sheetName) return false;
      if (other.bottom < this.top) return false;
      if (other.top > this.bottom) return false;
      if (other.right < this.left) return false;
      if (other.left > this.right) return false;
      return true;
    }
  }, {
    key: "contains",
    value: function contains(addressStr) {
      var address = colCache.decodeEx(addressStr);
      return this.containsEx(address);
    }
  }, {
    key: "containsEx",
    value: function containsEx(address) {
      if (address.sheetName && this.sheetName && address.sheetName !== this.sheetName) return false;
      return address.row >= this.top && address.row <= this.bottom && address.col >= this.left && address.col <= this.right;
    }
  }, {
    key: "top",
    get: function get() {
      return this.model.top || 1;
    },
    set: function set(value) {
      this.model.top = value;
    }
  }, {
    key: "left",
    get: function get() {
      return this.model.left || 1;
    },
    set: function set(value) {
      this.model.left = value;
    }
  }, {
    key: "bottom",
    get: function get() {
      return this.model.bottom || 1;
    },
    set: function set(value) {
      this.model.bottom = value;
    }
  }, {
    key: "right",
    get: function get() {
      return this.model.right || 1;
    },
    set: function set(value) {
      this.model.right = value;
    }
  }, {
    key: "sheetName",
    get: function get() {
      return this.model.sheetName;
    },
    set: function set(value) {
      this.model.sheetName = value;
    }
  }, {
    key: "_serialisedSheetName",
    get: function get() {
      var sheetName = this.model.sheetName;

      if (sheetName) {
        if (/^[a-zA-Z0-9]*$/.test(sheetName)) {
          return "".concat(sheetName, "!");
        }

        return "'".concat(sheetName, "'!");
      }

      return '';
    }
  }, {
    key: "tl",
    get: function get() {
      return colCache.n2l(this.left) + this.top;
    }
  }, {
    key: "$t$l",
    get: function get() {
      return "$".concat(colCache.n2l(this.left), "$").concat(this.top);
    }
  }, {
    key: "br",
    get: function get() {
      return colCache.n2l(this.right) + this.bottom;
    }
  }, {
    key: "$b$r",
    get: function get() {
      return "$".concat(colCache.n2l(this.right), "$").concat(this.bottom);
    }
  }, {
    key: "range",
    get: function get() {
      return "".concat(this._serialisedSheetName + this.tl, ":").concat(this.br);
    }
  }, {
    key: "$range",
    get: function get() {
      return "".concat(this._serialisedSheetName + this.$t$l, ":").concat(this.$b$r);
    }
  }, {
    key: "shortRange",
    get: function get() {
      return this.count > 1 ? this.range : this._serialisedSheetName + this.tl;
    }
  }, {
    key: "$shortRange",
    get: function get() {
      return this.count > 1 ? this.$range : this._serialisedSheetName + this.$t$l;
    }
  }, {
    key: "count",
    get: function get() {
      return (1 + this.bottom - this.top) * (1 + this.right - this.left);
    }
  }]);

  return Range;
}();

module.exports = Range;


},{"./../utils/col-cache":18}],12:[function(require,module,exports){
'use strict';

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var _ = require('../utils/under-dash');

var Enums = require('./enums');

var colCache = require('./../utils/col-cache');

var Cell = require('./cell');

var Row =
/*#__PURE__*/
function () {
  function Row(worksheet, number) {
    _classCallCheck(this, Row);

    this._worksheet = worksheet;
    this._number = number;
    this._cells = [];
    this.style = {};
    this.outlineLevel = 0;
  } // return the row number


  _createClass(Row, [{
    key: "commit",
    // Inform Streaming Writer that this row (and all rows before it) are complete
    // and ready to write. Has no effect on Worksheet document
    value: function commit() {
      this._worksheet._commitRow(this); // eslint-disable-line no-underscore-dangle

    } // helps GC by breaking cyclic references

  }, {
    key: "destroy",
    value: function destroy() {
      delete this._worksheet;
      delete this._cells;
      delete this.style;
    }
  }, {
    key: "findCell",
    value: function findCell(colNumber) {
      return this._cells[colNumber - 1];
    } // given {address, row, col}, find or create new cell

  }, {
    key: "getCellEx",
    value: function getCellEx(address) {
      var cell = this._cells[address.col - 1];

      if (!cell) {
        var column = this._worksheet.getColumn(address.col);

        cell = new Cell(this, column, address.address);
        this._cells[address.col - 1] = cell;
      }

      return cell;
    } // get cell by key, letter or column number

  }, {
    key: "getCell",
    value: function getCell(col) {
      if (typeof col === 'string') {
        // is it a key?
        var column = this._worksheet.getColumnKey(col);

        if (column) {
          col = column.number;
        } else {
          col = colCache.l2n(col);
        }
      }

      return this._cells[col - 1] || this.getCellEx({
        address: colCache.encodeAddress(this._number, col),
        row: this._number,
        col: col
      });
    } // remove cell(s) and shift all higher cells down by count

  }, {
    key: "splice",
    value: function splice(start, count) {
      var inserts = Array.prototype.slice.call(arguments, 2);
      var nKeep = start + count;
      var nExpand = inserts.length - count;
      var nEnd = this._cells.length;
      var i;
      var cSrc;
      var cDst;

      if (nExpand < 0) {
        // remove cells
        for (i = start + inserts.length; i <= nEnd; i++) {
          cDst = this._cells[i - 1];
          cSrc = this._cells[i - nExpand - 1];

          if (cSrc) {
            cDst = this.getCell(i);
            cDst.value = cSrc.value;
            cDst.style = cSrc.style;
          } else if (cDst) {
            cDst.value = null;
            cDst.style = {};
          }
        }
      } else if (nExpand > 0) {
        // insert new cells
        for (i = nEnd; i >= nKeep; i--) {
          cSrc = this._cells[i - 1];

          if (cSrc) {
            cDst = this.getCell(i + nExpand);
            cDst.value = cSrc.value;
            cDst.style = cSrc.style;
          } else {
            this._cells[i + nExpand - 1] = undefined;
          }
        }
      } // now add the new values


      for (i = 0; i < inserts.length; i++) {
        cDst = this.getCell(start + i);
        cDst.value = inserts[i];
        cDst.style = {};
      }
    } // Iterate over all non-null cells in this row

  }, {
    key: "eachCell",
    value: function eachCell(options, iteratee) {
      if (!iteratee) {
        iteratee = options;
        options = null;
      }

      if (options && options.includeEmpty) {
        var n = this._cells.length;

        for (var i = 1; i <= n; i++) {
          iteratee(this.getCell(i), i);
        }
      } else {
        this._cells.forEach(function (cell, index) {
          if (cell && cell.type !== Enums.ValueType.Null) {
            iteratee(cell, index + 1);
          }
        });
      }
    } // ===========================================================================
    // Page Breaks

  }, {
    key: "addPageBreak",
    value: function addPageBreak(lft, rght) {
      var ws = this._worksheet;
      var left = Math.max(0, lft - 1) || 0;
      var right = Math.max(0, rght - 1) || 16838;
      var pb = {
        id: this._number,
        max: right,
        man: 1
      };
      if (left) pb.min = left;
      ws.rowBreaks.push(pb);
    } // return a sparse array of cell values

  }, {
    key: "_applyStyle",
    // =========================================================================
    // styles
    value: function _applyStyle(name, value) {
      this.style[name] = value;

      this._cells.forEach(function (cell) {
        if (cell) {
          cell[name] = value;
        }
      });

      return value;
    }
  }, {
    key: "number",
    get: function get() {
      return this._number;
    }
  }, {
    key: "worksheet",
    get: function get() {
      return this._worksheet;
    }
  }, {
    key: "values",
    get: function get() {
      var values = [];

      this._cells.forEach(function (cell) {
        if (cell && cell.type !== Enums.ValueType.Null) {
          values[cell.col] = cell.value;
        }
      });

      return values;
    } // set the values by contiguous or sparse array, or by key'd object literal
    ,
    set: function set(value) {
      var _this = this;

      // this operation is not additive - any prior cells are removed
      this._cells = [];

      if (!value) {// empty row
      } else if (value instanceof Array) {
        var offset = 0;

        if (value.hasOwnProperty('0')) {
          // contiguous array - start at column 1
          offset = 1;
        }

        value.forEach(function (item, index) {
          if (item !== undefined) {
            _this.getCellEx({
              address: colCache.encodeAddress(_this._number, index + offset),
              row: _this._number,
              col: index + offset
            }).value = item;
          }
        });
      } else {
        // assume object with column keys
        this._worksheet.eachColumnKey(function (column, key) {
          if (value[key] !== undefined) {
            _this.getCellEx({
              address: colCache.encodeAddress(_this._number, column.number),
              row: _this._number,
              col: column.number
            }).value = value[key];
          }
        });
      }
    } // returns true if the row includes at least one cell with a value

  }, {
    key: "hasValues",
    get: function get() {
      return _.some(this._cells, function (cell) {
        return cell && cell.type !== Enums.ValueType.Null;
      });
    }
  }, {
    key: "cellCount",
    get: function get() {
      return this._cells.length;
    }
  }, {
    key: "actualCellCount",
    get: function get() {
      var count = 0;
      this.eachCell(function () {
        count++;
      });
      return count;
    } // get the min and max column number for the non-null cells in this row or null

  }, {
    key: "dimensions",
    get: function get() {
      var min = 0;
      var max = 0;

      this._cells.forEach(function (cell) {
        if (cell && cell.type !== Enums.ValueType.Null) {
          if (!min || min > cell.col) {
            min = cell.col;
          }

          if (max < cell.col) {
            max = cell.col;
          }
        }
      });

      return min > 0 ? {
        min: min,
        max: max
      } : null;
    }
  }, {
    key: "numFmt",
    get: function get() {
      return this.style.numFmt;
    },
    set: function set(value) {
      this._applyStyle('numFmt', value);
    }
  }, {
    key: "font",
    get: function get() {
      return this.style.font;
    },
    set: function set(value) {
      this._applyStyle('font', value);
    }
  }, {
    key: "alignment",
    get: function get() {
      return this.style.alignment;
    },
    set: function set(value) {
      this._applyStyle('alignment', value);
    }
  }, {
    key: "protection",
    get: function get() {
      return this.style.protection;
    },
    set: function set(value) {
      this._applyStyle('protection', value);
    }
  }, {
    key: "border",
    get: function get() {
      return this.style.border;
    },
    set: function set(value) {
      this._applyStyle('border', value);
    }
  }, {
    key: "fill",
    get: function get() {
      return this.style.fill;
    },
    set: function set(value) {
      this._applyStyle('fill', value);
    }
  }, {
    key: "hidden",
    get: function get() {
      return !!this._hidden;
    },
    set: function set(value) {
      this._hidden = value;
    }
  }, {
    key: "outlineLevel",
    get: function get() {
      return this._outlineLevel || 0;
    },
    set: function set(value) {
      this._outlineLevel = value;
    }
  }, {
    key: "collapsed",
    get: function get() {
      return !!(this._outlineLevel && this._outlineLevel >= this._worksheet.properties.outlineLevelRow);
    } // =========================================================================

  }, {
    key: "model",
    get: function get() {
      var cells = [];
      var min = 0;
      var max = 0;

      this._cells.forEach(function (cell) {
        if (cell) {
          var cellModel = cell.model;

          if (cellModel) {
            if (!min || min > cell.col) {
              min = cell.col;
            }

            if (max < cell.col) {
              max = cell.col;
            }

            cells.push(cellModel);
          }
        }
      });

      return this.height || cells.length ? {
        cells: cells,
        number: this.number,
        min: min,
        max: max,
        height: this.height,
        style: this.style,
        hidden: this.hidden,
        outlineLevel: this.outlineLevel,
        collapsed: this.collapsed
      } : null;
    },
    set: function set(value) {
      var _this2 = this;

      if (value.number !== this._number) {
        throw new Error('Invalid row number in model');
      }

      this._cells = [];
      var previousAddress;
      value.cells.forEach(function (cellModel) {
        switch (cellModel.type) {
          case Cell.Types.Merge:
            // special case - don't add this types
            break;

          default:
            {
              var address;

              if (cellModel.address) {
                address = colCache.decodeAddress(cellModel.address);
              } else if (previousAddress) {
                // This is a <c> element without an r attribute
                // Assume that it's the cell for the next column
                var _previousAddress = previousAddress,
                    row = _previousAddress.row;
                var col = previousAddress.col + 1;
                address = {
                  row: row,
                  col: col,
                  address: colCache.encodeAddress(row, col),
                  $col$row: "$".concat(colCache.n2l(col), "$").concat(row)
                };
              }

              previousAddress = address;

              var cell = _this2.getCellEx(address);

              cell.model = cellModel;
              break;
            }
        }
      });

      if (value.height) {
        this.height = value.height;
      } else {
        delete this.height;
      }

      this.hidden = value.hidden;
      this.outlineLevel = value.outlineLevel || 0;
      this.style = value.style && JSON.parse(JSON.stringify(value.style)) || {};
    }
  }]);

  return Row;
}();

module.exports = Row;


},{"../utils/under-dash":24,"./../utils/col-cache":18,"./cell":4,"./enums":8}],13:[function(require,module,exports){
"use strict";

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var colCache = require('./../utils/col-cache');

var Column =
/*#__PURE__*/
function () {
  // wrapper around column model, allowing access and manipulation
  function Column(table, column, index) {
    _classCallCheck(this, Column);

    this.table = table;
    this.column = column;
    this.index = index;
  }

  _createClass(Column, [{
    key: "_set",
    value: function _set(name, value) {
      this.table.cacheState();
      this.column[name] = value;
    }
    /* eslint-disable lines-between-class-members */

  }, {
    key: "name",
    get: function get() {
      return this.column.name;
    },
    set: function set(value) {
      this._set('name', value);
    }
  }, {
    key: "filterButton",
    get: function get() {
      return this.column.filterButton;
    },
    set: function set(value) {
      this.column.filterButton = value;
    }
  }, {
    key: "style",
    get: function get() {
      return this.column.style;
    },
    set: function set(value) {
      this.column.style = value;
    }
  }, {
    key: "totalsRowLabel",
    get: function get() {
      return this.column.totalsRowLabel;
    },
    set: function set(value) {
      this._set('totalsRowLabel', value);
    }
  }, {
    key: "totalsRowFunction",
    get: function get() {
      return this.column.totalsRowFunction;
    },
    set: function set(value) {
      this._set('totalsRowFunction', value);
    }
  }, {
    key: "totalsRowResult",
    get: function get() {
      return this.column.totalsRowResult;
    },
    set: function set(value) {
      this._set('totalsRowResult', value);
    }
  }, {
    key: "totalsRowFormula",
    get: function get() {
      return this.column.totalsRowFormula;
    },
    set: function set(value) {
      this._set('totalsRowFormula', value);
    }
    /* eslint-enable lines-between-class-members */

  }]);

  return Column;
}();

var Table =
/*#__PURE__*/
function () {
  function Table(worksheet, table) {
    _classCallCheck(this, Table);

    this.worksheet = worksheet;

    if (table) {
      this.table = table; // check things are ok first

      this.validate();
      this.store();
    }
  }

  _createClass(Table, [{
    key: "getFormula",
    value: function getFormula(column) {
      // get the correct formula to apply to the totals row
      switch (column.totalsRowFunction) {
        case 'none':
          return null;

        case 'average':
          return "SUBTOTAL(101,".concat(this.table.name, "[").concat(column.name, "])");

        case 'countNums':
          return "SUBTOTAL(102,".concat(this.table.name, "[").concat(column.name, "])");

        case 'count':
          return "SUBTOTAL(103,".concat(this.table.name, "[").concat(column.name, "])");

        case 'max':
          return "SUBTOTAL(104,".concat(this.table.name, "[").concat(column.name, "])");

        case 'min':
          return "SUBTOTAL(105,".concat(this.table.name, "[").concat(column.name, "])");

        case 'stdDev':
          return "SUBTOTAL(106,".concat(this.table.name, "[").concat(column.name, "])");

        case 'var':
          return "SUBTOTAL(107,".concat(this.table.name, "[").concat(column.name, "])");

        case 'custom':
          return column.totalsRowFormula;

        default:
          throw new Error("Invalid Totals Row Function: ".concat(column.totalsRowFunction));
      }
    }
  }, {
    key: "validate",
    value: function validate() {
      var _this = this;

      var table = this.table; // set defaults and check is valid

      var assign = function assign(o, name, dflt) {
        if (o[name] === undefined) {
          o[name] = dflt;
        }
      };

      assign(table, 'headerRow', true);
      assign(table, 'totalsRow', false);
      assign(table, 'style', {});
      assign(table.style, 'theme', 'TableStyleMedium2');
      assign(table.style, 'showFirstColumn', false);
      assign(table.style, 'showLastColumn', false);
      assign(table.style, 'showRowStripes', false);
      assign(table.style, 'showColumnStripes', false);

      var assert = function assert(test, message) {
        if (!test) {
          throw new Error(message);
        }
      };

      assert(table.ref, 'Table must have ref');
      assert(table.columns, 'Table must have column definitions');
      assert(table.rows, 'Table must have row definitions');
      table.tl = colCache.decodeAddress(table.ref);
      var _table$tl = table.tl,
          row = _table$tl.row,
          col = _table$tl.col;
      assert(row > 0, 'Table must be on valid row');
      assert(col > 0, 'Table must be on valid col');
      var width = this.width,
          filterHeight = this.filterHeight,
          tableHeight = this.tableHeight; // autoFilterRef is a range that includes optional headers only

      table.autoFilterRef = colCache.encode(row, col, row + filterHeight - 1, col + width - 1); // tableRef is a range that includes optional headers and totals

      table.tableRef = colCache.encode(row, col, row + tableHeight - 1, col + width - 1);
      table.columns.forEach(function (column, i) {
        assert(column.name, "Column ".concat(i, " must have a name"));

        if (i === 0) {
          assign(column, 'totalsRowLabel', 'Total');
        } else {
          assign(column, 'totalsRowFunction', 'none');
          column.totalsRowFormula = _this.getFormula(column);
        }
      });
    }
  }, {
    key: "store",
    value: function store() {
      var _this2 = this;

      // where the table needs to store table data, headers, footers in
      // the sheet...
      var assignStyle = function assignStyle(cell, style) {
        if (style) {
          Object.keys(style).forEach(function (key) {
            cell[key] = style[key];
          });
        }
      };

      var worksheet = this.worksheet,
          table = this.table;
      var _table$tl2 = table.tl,
          row = _table$tl2.row,
          col = _table$tl2.col;
      var count = 0;

      if (table.headerRow) {
        var r = worksheet.getRow(row + count++);
        table.columns.forEach(function (column, j) {
          var style = column.style,
              name = column.name;
          var cell = r.getCell(col + j);
          cell.value = name;
          assignStyle(cell, style);
        });
      }

      table.rows.forEach(function (data) {
        var r = worksheet.getRow(row + count++);
        data.forEach(function (value, j) {
          var cell = r.getCell(col + j);
          cell.value = value;
          assignStyle(cell, table.columns[j].style);
        });
      });

      if (table.totalsRow) {
        var _r = worksheet.getRow(row + count++);

        table.columns.forEach(function (column, j) {
          var cell = _r.getCell(col + j);

          if (j === 0) {
            cell.value = column.totalsRowLabel;
          } else {
            var formula = _this2.getFormula(column);

            if (formula) {
              cell.value = {
                formula: column.totalsRowFormula,
                result: column.totalsRowResult
              };
            } else {
              cell.value = null;
            }
          }

          assignStyle(cell, column.style);
        });
      }
    }
  }, {
    key: "load",
    value: function load(worksheet) {
      var _this3 = this;

      // where the table will read necessary features from a loaded sheet
      var table = this.table;
      var _table$tl3 = table.tl,
          row = _table$tl3.row,
          col = _table$tl3.col;
      var count = 0;

      if (table.headerRow) {
        var r = worksheet.getRow(row + count++);
        table.columns.forEach(function (column, j) {
          var cell = r.getCell(col + j);
          cell.value = column.name;
        });
      }

      table.rows.forEach(function (data) {
        var r = worksheet.getRow(row + count++);
        data.forEach(function (value, j) {
          var cell = r.getCell(col + j);
          cell.value = value;
        });
      });

      if (table.totalsRow) {
        var _r2 = worksheet.getRow(row + count++);

        table.columns.forEach(function (column, j) {
          var cell = _r2.getCell(col + j);

          if (j === 0) {
            cell.value = column.totalsRowLabel;
          } else {
            var formula = _this3.getFormula(column);

            if (formula) {
              cell.value = {
                formula: column.totalsRowFormula,
                result: column.totalsRowResult
              };
            }
          }
        });
      }
    }
  }, {
    key: "cacheState",
    // ================================================================
    // TODO: Mutating methods
    value: function cacheState() {
      if (!this._cache) {
        this._cache = {
          ref: this.ref,
          width: this.width,
          tableHeight: this.tableHeight
        };
      }
    }
  }, {
    key: "commit",
    value: function commit() {
      // changes may have been made that might have on-sheet effects
      if (!this._cache) {
        return;
      } // check things are ok first


      this.validate();
      var ref = colCache.decodeAddress(this._cache.ref);

      if (this.ref !== this._cache.ref) {
        // wipe out whole table footprint at previous location
        for (var i = 0; i < this._cache.tableHeight; i++) {
          var row = this.worksheet.getRow(ref.row + i);

          for (var j = 0; j < this._cache.width; j++) {
            var cell = row.getCell(ref.col + j);
            cell.value = null;
          }
        }
      } else {
        // clear out below table if it has shrunk
        for (var _i = this.tableHeight; _i < this._cache.tableHeight; _i++) {
          var _row = this.worksheet.getRow(ref.row + _i);

          for (var _j = 0; _j < this._cache.width; _j++) {
            var _cell = _row.getCell(ref.col + _j);

            _cell.value = null;
          }
        } // clear out to right of table if it has lost columns


        for (var _i2 = 0; _i2 < this.tableHeight; _i2++) {
          var _row2 = this.worksheet.getRow(ref.row + _i2);

          for (var _j2 = this.width; _j2 < this._cache.width; _j2++) {
            var _cell2 = _row2.getCell(ref.col + _j2);

            _cell2.value = null;
          }
        }
      }

      this.store();
    }
    /* eslint-disable no-unused-vars */

  }, {
    key: "addRow",
    value: function addRow(values, rowNumber) {
      // Add a row of data, either insert at rowNumber or append
      this.cacheState();

      if (rowNumber === undefined) {
        this.table.rows.push(values);
      } else {
        this.table.rows.splice(rowNumber, 0, values);
      }
    }
  }, {
    key: "removeRows",
    value: function removeRows(rowIndex) {
      var count = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 1;
      // Remove a rows of data
      this.cacheState();
      this.table.rows.splice(rowIndex, count);
    }
  }, {
    key: "getColumn",
    value: function getColumn(colIndex) {
      var column = this.table.columns[colIndex];
      return new Column(this, column, colIndex);
    }
  }, {
    key: "addColumn",
    value: function addColumn(column, values, colIndex) {
      // Add a new column, including column defn and values
      // Inserts at colNumber or adds to the right
      this.cacheState();

      if (colIndex === undefined) {
        this.table.columns.push(column);
        this.table.rows.forEach(function (row, i) {
          row.push(values[i]);
        });
      } else {
        this.table.columns.splice(colIndex, 0, column);
        this.table.rows.forEach(function (row, i) {
          row.splice(colIndex, 0, values[i]);
        });
      }
    }
  }, {
    key: "removeColumns",
    value: function removeColumns(colIndex) {
      var count = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 1;
      // Remove a column with data
      this.cacheState();
      this.table.columns.splice(colIndex, count);
      this.table.rows.forEach(function (row) {
        row.splice(colIndex, count);
      });
    }
  }, {
    key: "_assign",
    value: function _assign(target, prop, value) {
      this.cacheState();
      target[prop] = value;
    }
    /* eslint-disable lines-between-class-members */

  }, {
    key: "width",
    get: function get() {
      // width of the table
      return this.table.columns.length;
    }
  }, {
    key: "height",
    get: function get() {
      // height of the table data
      return this.table.rows.length;
    }
  }, {
    key: "filterHeight",
    get: function get() {
      // height of the table data plus optional header row
      return this.height + (this.table.headerRow ? 1 : 0);
    }
  }, {
    key: "tableHeight",
    get: function get() {
      // full height of the table on the sheet
      return this.filterHeight + (this.table.totalsRow ? 1 : 0);
    }
  }, {
    key: "model",
    get: function get() {
      return this.table;
    },
    set: function set(value) {
      this.table = value;
    }
  }, {
    key: "ref",
    get: function get() {
      return this.table.ref;
    },
    set: function set(value) {
      this._assign(this.table, 'ref', value);
    }
  }, {
    key: "name",
    get: function get() {
      return this.table.name;
    },
    set: function set(value) {
      this.table.name = value;
    }
  }, {
    key: "displayName",
    get: function get() {
      return this.table.displyName || this.table.name;
    }
  }, {
    key: "displayNamename",
    set: function set(value) {
      this.table.displayName = value;
    }
  }, {
    key: "headerRow",
    get: function get() {
      return this.table.headerRow;
    },
    set: function set(value) {
      this._assign(this.table, 'headerRow', value);
    }
  }, {
    key: "totalsRow",
    get: function get() {
      return this.table.totalsRow;
    },
    set: function set(value) {
      this._assign(this.table, 'totalsRow', value);
    }
  }, {
    key: "theme",
    get: function get() {
      return this.table.style.name;
    },
    set: function set(value) {
      this.table.style.name = value;
    }
  }, {
    key: "showFirstColumn",
    get: function get() {
      return this.table.style.showFirstColumn;
    },
    set: function set(value) {
      this.table.style.showFirstColumn = value;
    }
  }, {
    key: "showLastColumn",
    get: function get() {
      return this.table.style.showLastColumn;
    },
    set: function set(value) {
      this.table.style.showLastColumn = value;
    }
  }, {
    key: "showRowStripes",
    get: function get() {
      return this.table.style.showRowStripes;
    },
    set: function set(value) {
      this.table.style.showRowStripes = value;
    }
  }, {
    key: "showColumnStripes",
    get: function get() {
      return this.table.style.showColumnStripes;
    },
    set: function set(value) {
      this.table.style.showColumnStripes = value;
    }
    /* eslint-enable lines-between-class-members */

  }]);

  return Table;
}();

module.exports = Table;


},{"./../utils/col-cache":18}],14:[function(require,module,exports){
'use strict';

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var Worksheet = require('./worksheet');

var DefinedNames = require('./defined-names');

var XLSX = require('./../xlsx/xlsx');

var CSV = require('./../csv/csv'); // Workbook requirements
//  Load and Save from file and stream
//  Access/Add/Delete individual worksheets
//  Manage String table, Hyperlink table, etc.
//  Manage scaffolding for contained objects to write to/read from


var Workbook =
/*#__PURE__*/
function () {
  function Workbook() {
    _classCallCheck(this, Workbook);

    this.created = new Date();
    this.modified = this.created;
    this.properties = {};
    this._worksheets = [];
    this.views = [];
    this.media = [];
    this._definedNames = new DefinedNames();
  }

  _createClass(Workbook, [{
    key: "addWorksheet",
    value: function addWorksheet(name, options) {
      var id = this.nextId;

      if (name && name.length > 31) {
        console.warn("Worksheet name ".concat(name, " exceeds 31 chars. This will be truncated"));
      }

      name = (name || "sheet".concat(id)).substring(0, 31);

      if (this._worksheets.find(function (ws) {
        return ws && ws.name === name;
      })) {
        throw new Error("Worksheet name already exists: ".concat(name));
      } // if options is a color, call it tabColor (and signal deprecated message)


      if (options) {
        if (typeof options === 'string') {
          // eslint-disable-next-line no-console
          console.trace('tabColor argument is now deprecated. Please use workbook.addWorksheet(name, {properties: { tabColor: { argb: "rbg value" } }');
          options = {
            properties: {
              tabColor: {
                argb: options
              }
            }
          };
        } else if (options.argb || options.theme || options.indexed) {
          // eslint-disable-next-line no-console
          console.trace('tabColor argument is now deprecated. Please use workbook.addWorksheet(name, {properties: { tabColor: { ... } }');
          options = {
            properties: {
              tabColor: options
            }
          };
        }
      }

      var lastOrderNo = this._worksheets.reduce(function (acc, ws) {
        return (ws && ws.orderNo) > acc ? ws.orderNo : acc;
      }, 0);

      var worksheetOptions = Object.assign({}, options, {
        id: id,
        name: name,
        orderNo: lastOrderNo + 1,
        workbook: this
      });
      var worksheet = new Worksheet(worksheetOptions);
      this._worksheets[id] = worksheet;
      return worksheet;
    }
  }, {
    key: "removeWorksheetEx",
    value: function removeWorksheetEx(worksheet) {
      delete this._worksheets[worksheet.id];
    }
  }, {
    key: "removeWorksheet",
    value: function removeWorksheet(id) {
      var worksheet = this.getWorksheet(id);

      if (worksheet) {
        worksheet.destroy();
      }
    }
  }, {
    key: "getWorksheet",
    value: function getWorksheet(id) {
      if (id === undefined) {
        return this._worksheets.find(Boolean);
      }

      if (typeof id === 'number') {
        return this._worksheets[id];
      }

      if (typeof id === 'string') {
        return this._worksheets.find(function (worksheet) {
          return worksheet && worksheet.name === id;
        });
      }

      return undefined;
    }
  }, {
    key: "eachSheet",
    value: function eachSheet(iteratee) {
      this.worksheets.forEach(function (sheet) {
        iteratee(sheet, sheet.id);
      });
    }
  }, {
    key: "clearThemes",
    value: function clearThemes() {
      // Note: themes are not an exposed feature, meddle at your peril!
      this._themes = undefined;
    }
  }, {
    key: "addImage",
    value: function addImage(image) {
      // TODO:  validation?
      var id = this.media.length;
      this.media.push(Object.assign({}, image, {
        type: 'image'
      }));
      return id;
    }
  }, {
    key: "getImage",
    value: function getImage(id) {
      return this.media[id];
    }
  }, {
    key: "xlsx",
    get: function get() {
      if (!this._xlsx) this._xlsx = new XLSX(this);
      return this._xlsx;
    }
  }, {
    key: "csv",
    get: function get() {
      if (!this._csv) this._csv = new CSV(this);
      return this._csv;
    }
  }, {
    key: "nextId",
    get: function get() {
      // find the next unique spot to add worksheet
      for (var i = 1; i < this._worksheets.length; i++) {
        if (!this._worksheets[i]) {
          return i;
        }
      }

      return this._worksheets.length || 1;
    }
  }, {
    key: "worksheets",
    get: function get() {
      // return a clone of _worksheets
      return this._worksheets.slice(1).sort(function (a, b) {
        return a.orderNo - b.orderNo;
      }).filter(Boolean);
    }
  }, {
    key: "definedNames",
    get: function get() {
      return this._definedNames;
    }
  }, {
    key: "model",
    get: function get() {
      return {
        creator: this.creator || 'Unknown',
        lastModifiedBy: this.lastModifiedBy || 'Unknown',
        lastPrinted: this.lastPrinted,
        created: this.created,
        modified: this.modified,
        properties: this.properties,
        worksheets: this.worksheets.map(function (worksheet) {
          return worksheet.model;
        }),
        sheets: this.worksheets.map(function (ws) {
          return ws.model;
        }).filter(Boolean),
        definedNames: this._definedNames.model,
        views: this.views,
        company: this.company,
        manager: this.manager,
        title: this.title,
        subject: this.subject,
        keywords: this.keywords,
        category: this.category,
        description: this.description,
        language: this.language,
        revision: this.revision,
        contentStatus: this.contentStatus,
        themes: this._themes,
        media: this.media
      };
    },
    set: function set(value) {
      var _this = this;

      this.creator = value.creator;
      this.lastModifiedBy = value.lastModifiedBy;
      this.lastPrinted = value.lastPrinted;
      this.created = value.created;
      this.modified = value.modified;
      this.company = value.company;
      this.manager = value.manager;
      this.title = value.title;
      this.subject = value.subject;
      this.keywords = value.keywords;
      this.category = value.category;
      this.description = value.description;
      this.language = value.language;
      this.revision = value.revision;
      this.contentStatus = value.contentStatus;
      this.properties = value.properties;
      this._worksheets = [];
      value.worksheets.forEach(function (worksheetModel) {
        var id = worksheetModel.id,
            name = worksheetModel.name,
            state = worksheetModel.state;
        var orderNo = value.sheets && value.sheets.findIndex(function (ws) {
          return ws.id === id;
        });
        var worksheet = _this._worksheets[id] = new Worksheet({
          id: id,
          name: name,
          orderNo: orderNo,
          state: state,
          workbook: _this
        });
        worksheet.model = worksheetModel;
      });
      this._definedNames.model = value.definedNames;
      this.views = value.views;
      this._themes = value.themes;
      this.media = value.media || [];
    }
  }]);

  return Workbook;
}();

module.exports = Workbook;


},{"./../csv/csv":2,"./../xlsx/xlsx":111,"./defined-names":7,"./worksheet":15}],15:[function(require,module,exports){
"use strict";

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var _ = require('../utils/under-dash');

var colCache = require('./../utils/col-cache');

var Range = require('./range');

var Row = require('./row');

var Column = require('./column');

var Enums = require('./enums');

var Image = require('./image');

var Table = require('./table');

var DataValidations = require('./data-validations');

var Encryptor = require('../utils/encryptor');

var PromiseLib = require('../utils/promise'); // Worksheet requirements
//  Operate as sheet inside workbook or standalone
//  Load and Save from file and stream
//  Access/Add/Delete individual cells
//  Manage column widths and row heights


var Worksheet =
/*#__PURE__*/
function () {
  function Worksheet(options) {
    _classCallCheck(this, Worksheet);

    options = options || {}; // in a workbook, each sheet will have a number

    this.id = options.id;
    this.orderNo = options.orderNo; // and a name

    this.name = options.name || "Sheet".concat(this.id); // add a state

    this.state = options.state || 'visible'; // rows allows access organised by row. Sparse array of arrays indexed by row-1, col
    // Note: _rows is zero based. Must subtract 1 to go from cell.row to index

    this._rows = []; // column definitions

    this._columns = null; // column keys (addRow convenience): key ==> this._collumns index

    this._keys = {}; // keep record of all merges

    this._merges = {}; // record of all row and column pageBreaks

    this.rowBreaks = [];
    this._workbook = options.workbook; // for tabColor, default row height, outline levels, etc

    this.properties = Object.assign({}, {
      defaultRowHeight: 15,
      dyDescent: 55,
      outlineLevelCol: 0,
      outlineLevelRow: 0
    }, options.properties); // for all things printing

    this.pageSetup = Object.assign({}, {
      margins: {
        left: 0.7,
        right: 0.7,
        top: 0.75,
        bottom: 0.75,
        header: 0.3,
        footer: 0.3
      },
      orientation: 'portrait',
      horizontalDpi: 4294967295,
      verticalDpi: 4294967295,
      fitToPage: !!(options.pageSetup && (options.pageSetup.fitToWidth || options.pageSetup.fitToHeight) && !options.pageSetup.scale),
      pageOrder: 'downThenOver',
      blackAndWhite: false,
      draft: false,
      cellComments: 'None',
      errors: 'displayed',
      scale: 100,
      fitToWidth: 1,
      fitToHeight: 1,
      paperSize: undefined,
      showRowColHeaders: false,
      showGridLines: false,
      firstPageNumber: undefined,
      horizontalCentered: false,
      verticalCentered: false,
      rowBreaks: null,
      colBreaks: null
    }, options.pageSetup);
    this.headerFooter = {
      differentFirst: false,
      differentOddEven: false,
      oddHeader: null,
      oddFooter: null,
      evenHeader: null,
      evenFooter: null,
      firstHeader: null,
      firstFooter: null
    };
    this.dataValidations = new DataValidations(); // for freezepanes, split, zoom, gridlines, etc

    this.views = options.views || [];
    this.autoFilter = options.autoFilter || null; // for images, etc

    this._media = []; // worksheet protection

    this.sheetProtection = null; // for tables

    this.tables = {};
  }

  _createClass(Worksheet, [{
    key: "destroy",
    // when you're done with this worksheet, call this to remove from workbook
    value: function destroy() {
      this._workbook.removeWorksheetEx(this);
    } // Get the bounding range of the cells in this worksheet

  }, {
    key: "getColumnKey",
    value: function getColumnKey(key) {
      return this._keys[key];
    }
  }, {
    key: "setColumnKey",
    value: function setColumnKey(key, value) {
      this._keys[key] = value;
    }
  }, {
    key: "deleteColumnKey",
    value: function deleteColumnKey(key) {
      delete this._keys[key];
    }
  }, {
    key: "eachColumnKey",
    value: function eachColumnKey(f) {
      _.each(this._keys, f);
    } // get a single column by col number. If it doesn't exist, create it and any gaps before it

  }, {
    key: "getColumn",
    value: function getColumn(c) {
      if (typeof c === 'string') {
        // if it matches a key'd column, return that
        var col = this._keys[c];
        if (col) return col; // otherwise, assume letter

        c = colCache.l2n(c);
      }

      if (!this._columns) {
        this._columns = [];
      }

      if (c > this._columns.length) {
        var n = this._columns.length + 1;

        while (n <= c) {
          this._columns.push(new Column(this, n++));
        }
      }

      return this._columns[c - 1];
    }
  }, {
    key: "spliceColumns",
    value: function spliceColumns(start, count) {
      var _this = this;

      // each member of inserts is a column of data.
      var inserts = Array.prototype.slice.call(arguments, 2);
      var rows = this._rows;
      var nRows = rows.length;

      if (inserts.length > 0) {
        var _loop = function _loop(i) {
          var rowArguments = [start, count]; // eslint-disable-next-line no-loop-func

          inserts.forEach(function (insert) {
            rowArguments.push(insert[i] || null);
          });

          var row = _this.getRow(i + 1); // eslint-disable-next-line prefer-spread


          row.splice.apply(row, rowArguments);
        };

        // must iterate over all rows whether they exist yet or not
        for (var i = 0; i < nRows; i++) {
          _loop(i);
        }
      } else {
        // nothing to insert, so just splice all rows
        this._rows.forEach(function (r) {
          if (r) {
            r.splice(start, count);
          }
        });
      } // splice column definitions


      var nExpand = inserts.length - count;
      var nKeep = start + count;
      var nEnd = this._columns.length;

      if (nExpand < 0) {
        for (var i = start + inserts.length; i <= nEnd; i++) {
          this.getColumn(i).defn = this.getColumn(i - nExpand).defn;
        }
      } else if (nExpand > 0) {
        for (var _i = nEnd; _i >= nKeep; _i--) {
          this.getColumn(_i + nExpand).defn = this.getColumn(_i).defn;
        }
      }

      for (var _i2 = start; _i2 < start + inserts.length; _i2++) {
        this.getColumn(_i2).defn = null;
      } // account for defined names


      this.workbook.definedNames.spliceColumns(this.name, start, count, inserts.length);
    }
  }, {
    key: "_commitRow",
    // =========================================================================
    // Rows
    value: function _commitRow() {// nop - allows streaming reader to fill a document
    }
  }, {
    key: "findRow",
    // find a row (if exists) by row number
    value: function findRow(r) {
      return this._rows[r - 1];
    }
  }, {
    key: "getRow",
    // get a row by row number.
    value: function getRow(r) {
      var row = this._rows[r - 1];

      if (!row) {
        row = this._rows[r - 1] = new Row(this, r);
      }

      return row;
    }
  }, {
    key: "addRow",
    value: function addRow(value) {
      var row = this.getRow(this._nextRow);
      row.values = value;
      return row;
    }
  }, {
    key: "addRows",
    value: function addRows(value) {
      var _this2 = this;

      value.forEach(function (row) {
        _this2.addRow(row);
      });
    }
  }, {
    key: "spliceRows",
    value: function spliceRows(start, count) {
      var _this3 = this;

      // same problem as row.splice, except worse.
      var inserts = Array.prototype.slice.call(arguments, 2);
      var nKeep = start + count;
      var nExpand = inserts.length - count;
      var nEnd = this._rows.length;
      var i;
      var rSrc;

      if (nExpand < 0) {
        // remove rows
        for (i = nKeep; i <= nEnd; i++) {
          rSrc = this._rows[i - 1];

          if (rSrc) {
            (function () {
              var rDst = _this3.getRow(i + nExpand);

              rDst.values = rSrc.values;
              rDst.style = rSrc.style; // eslint-disable-next-line no-loop-func

              rSrc.eachCell({
                includeEmpty: true
              }, function (cell, colNumber) {
                rDst.getCell(colNumber).style = cell.style;
              });
              _this3._rows[i - 1] = undefined;
            })();
          } else {
            this._rows[i + nExpand - 1] = undefined;
          }
        }
      } else if (nExpand > 0) {
        // insert new cells
        for (i = nEnd; i >= nKeep; i--) {
          rSrc = this._rows[i - 1];

          if (rSrc) {
            (function () {
              var rDst = _this3.getRow(i + nExpand);

              rDst.values = rSrc.values;
              rDst.style = rSrc.style; // eslint-disable-next-line no-loop-func

              rSrc.eachCell({
                includeEmpty: true
              }, function (cell, colNumber) {
                rDst.getCell(colNumber).style = cell.style;
              });
            })();
          } else {
            this._rows[i + nExpand - 1] = undefined;
          }
        }
      } // now copy over the new values


      for (i = 0; i < inserts.length; i++) {
        var rDst = this.getRow(start + i);
        rDst.style = {};
        rDst.values = inserts[i];
      } // account for defined names


      this.workbook.definedNames.spliceRows(this.name, start, count, inserts.length);
    } // iterate over every row in the worksheet, including maybe empty rows

  }, {
    key: "eachRow",
    value: function eachRow(options, iteratee) {
      if (!iteratee) {
        iteratee = options;
        options = undefined;
      }

      if (options && options.includeEmpty) {
        var n = this._rows.length;

        for (var i = 1; i <= n; i++) {
          iteratee(this.getRow(i), i);
        }
      } else {
        this._rows.forEach(function (row) {
          if (row && row.hasValues) {
            iteratee(row, row.number);
          }
        });
      }
    } // return all rows as sparse array

  }, {
    key: "getSheetValues",
    value: function getSheetValues() {
      var rows = [];

      this._rows.forEach(function (row) {
        if (row) {
          rows[row.number] = row.values;
        }
      });

      return rows;
    } // =========================================================================
    // Cells
    // returns the cell at [r,c] or address given by r. If not found, return undefined

  }, {
    key: "findCell",
    value: function findCell(r, c) {
      var address = colCache.getAddress(r, c);
      var row = this._rows[address.row - 1];
      return row ? row.findCell(address.col) : undefined;
    } // return the cell at [r,c] or address given by r. If not found, create a new one.

  }, {
    key: "getCell",
    value: function getCell(r, c) {
      var address = colCache.getAddress(r, c);
      var row = this.getRow(address.row);
      return row.getCellEx(address);
    } // =========================================================================
    // Merge
    // convert the range defined by ['tl:br'], [tl,br] or [t,l,b,r] into a single 'merged' cell

  }, {
    key: "mergeCells",
    value: function mergeCells() {
      var dimensions = new Range(Array.prototype.slice.call(arguments, 0)); // convert arguments into Array
      // check cells aren't already merged

      _.each(this._merges, function (merge) {
        if (merge.intersects(dimensions)) {
          throw new Error('Cannot merge already merged cells');
        }
      }); // apply merge


      var master = this.getCell(dimensions.top, dimensions.left);

      for (var i = dimensions.top; i <= dimensions.bottom; i++) {
        for (var j = dimensions.left; j <= dimensions.right; j++) {
          // merge all but the master cell
          if (i > dimensions.top || j > dimensions.left) {
            this.getCell(i, j).merge(master);
          }
        }
      } // index merge


      this._merges[master.address] = dimensions;
    }
  }, {
    key: "_unMergeMaster",
    value: function _unMergeMaster(master) {
      // master is always top left of a rectangle
      var merge = this._merges[master.address];

      if (merge) {
        for (var i = merge.top; i <= merge.bottom; i++) {
          for (var j = merge.left; j <= merge.right; j++) {
            this.getCell(i, j).unmerge();
          }
        }

        delete this._merges[master.address];
      }
    }
  }, {
    key: "unMergeCells",
    // scan the range defined by ['tl:br'], [tl,br] or [t,l,b,r] and if any cell is part of a merge,
    // un-merge the group. Note this function can affect multiple merges and merge-blocks are
    // atomic - either they're all merged or all un-merged.
    value: function unMergeCells() {
      var dimensions = new Range(Array.prototype.slice.call(arguments, 0)); // convert arguments into Array
      // find any cells in that range and unmerge them

      for (var i = dimensions.top; i <= dimensions.bottom; i++) {
        for (var j = dimensions.left; j <= dimensions.right; j++) {
          var cell = this.findCell(i, j);

          if (cell) {
            if (cell.type === Enums.ValueType.Merge) {
              // this cell merges to another master
              this._unMergeMaster(cell.master);
            } else if (this._merges[cell.address]) {
              // this cell is a master
              this._unMergeMaster(cell);
            }
          }
        }
      }
    } // ===========================================================================
    // Shared Formula

  }, {
    key: "fillFormula",
    value: function fillFormula(range, formula, results) {
      // Define formula for top-left cell and share to rest
      var decoded = colCache.decode(range);
      var top = decoded.top,
          left = decoded.left,
          bottom = decoded.bottom,
          right = decoded.right;
      var width = right - left + 1;
      var masterAddress = colCache.encodeAddress(top, left); // work out result accessor

      var getResult;

      if (typeof results === 'function') {
        getResult = results;
      } else if (Array.isArray(results)) {
        if (Array.isArray(results[0])) {
          getResult = function getResult(row, col) {
            return results[row - top][col - left];
          };
        } else {
          getResult = function getResult(row, col) {
            return results[(row - top) * width + (col - left)];
          };
        }
      } else {
        getResult = function getResult() {
          return undefined;
        };
      }

      var first = true;

      for (var r = top; r <= bottom; r++) {
        for (var c = left; c <= right; c++) {
          if (first) {
            this.getCell(r, c).value = {
              formula: formula,
              result: getResult(r, c)
            };
            first = false;
          } else {
            this.getCell(r, c).value = {
              sharedFormula: masterAddress,
              result: getResult(r, c)
            };
          }
        }
      }
    } // =========================================================================
    // Images

  }, {
    key: "addImage",
    value: function addImage(imageId, range) {
      var model = {
        type: 'image',
        imageId: imageId,
        range: range
      };

      this._media.push(new Image(this, model));
    }
  }, {
    key: "getImages",
    value: function getImages() {
      return this._media.filter(function (m) {
        return m.type === 'image';
      });
    }
  }, {
    key: "addBackgroundImage",
    value: function addBackgroundImage(imageId) {
      var model = {
        type: 'background',
        imageId: imageId
      };

      this._media.push(new Image(this, model));
    }
  }, {
    key: "getBackgroundImageId",
    value: function getBackgroundImageId() {
      var image = this._media.find(function (m) {
        return m.type === 'background';
      });

      return image && image.imageId;
    } // =========================================================================
    // Worksheet Protection

  }, {
    key: "protect",
    value: function protect(password, options) {
      var _this4 = this;

      // TODO: make this function truly async
      // perhaps marshal to worker thread or something
      return new PromiseLib.Promise(function (resolve) {
        _this4.sheetProtection = {
          sheet: true
        };

        if (password) {
          _this4.sheetProtection.algorithmName = 'SHA-512';
          _this4.sheetProtection.saltValue = Encryptor.randomBytes(16).toString('base64');
          _this4.sheetProtection.spinCount = 100000;
          _this4.sheetProtection.hashValue = Encryptor.convertPasswordToHash(password, 'SHA512', _this4.sheetProtection.saltValue, _this4.sheetProtection.spinCount);
        }

        if (options) {
          _this4.sheetProtection = Object.assign(_this4.sheetProtection, options);
        }

        resolve();
      });
    }
  }, {
    key: "unprotect",
    value: function unprotect() {
      this.sheetProtection = null;
    } // =========================================================================
    // Tables

  }, {
    key: "addTable",
    value: function addTable(model) {
      var table = new Table(this, model);
      this.tables[model.name] = table;
      return table;
    }
  }, {
    key: "getTable",
    value: function getTable(name) {
      return this.tables[name];
    }
  }, {
    key: "removeTable",
    value: function removeTable(name) {
      delete this.tables[name];
    }
  }, {
    key: "getTables",
    value: function getTables() {
      return Object.values(this.tables);
    } // ===========================================================================
    // Deprecated

  }, {
    key: "_parseRows",
    value: function _parseRows(model) {
      var _this5 = this;

      this._rows = [];
      model.rows.forEach(function (rowModel) {
        var row = new Row(_this5, rowModel.number);
        _this5._rows[row.number - 1] = row;
        row.model = rowModel;
      });
    }
  }, {
    key: "_parseMergeCells",
    value: function _parseMergeCells(model) {
      var _this6 = this;

      _.each(model.mergeCells, function (merge) {
        _this6.mergeCells(merge);
      });
    }
  }, {
    key: "workbook",
    get: function get() {
      return this._workbook;
    }
  }, {
    key: "dimensions",
    get: function get() {
      var dimensions = new Range();

      this._rows.forEach(function (row) {
        if (row) {
          var rowDims = row.dimensions;

          if (rowDims) {
            dimensions.expand(row.number, rowDims.min, row.number, rowDims.max);
          }
        }
      });

      return dimensions;
    } // =========================================================================
    // Columns
    // get the current columns array.

  }, {
    key: "columns",
    get: function get() {
      return this._columns;
    } // set the columns from an array of column definitions.
    // Note: any headers defined will overwrite existing values.
    ,
    set: function set(value) {
      var _this7 = this;

      // calculate max header row count
      this._headerRowCount = value.reduce(function (pv, cv) {
        var headerCount = cv.header && 1 || cv.headers && cv.headers.length || 0;
        return Math.max(pv, headerCount);
      }, 0); // construct Column objects

      var count = 1;
      var columns = this._columns = [];
      value.forEach(function (defn) {
        var column = new Column(_this7, count++, false);
        columns.push(column);
        column.defn = defn;
      });
    }
  }, {
    key: "columnCount",
    get: function get() {
      var maxCount = 0;
      this.eachRow(function (row) {
        maxCount = Math.max(maxCount, row.cellCount);
      });
      return maxCount;
    }
  }, {
    key: "actualColumnCount",
    get: function get() {
      // performance nightmare - for each row, counts all the columns used
      var counts = [];
      var count = 0;
      this.eachRow(function (row) {
        row.eachCell(function (_ref) {
          var col = _ref.col;

          if (!counts[col]) {
            counts[col] = true;
            count++;
          }
        });
      });
      return count;
    }
  }, {
    key: "_lastRowNumber",
    get: function get() {
      // need to cope with results of splice
      var rows = this._rows;
      var n = rows.length;

      while (n > 0 && rows[n - 1] === undefined) {
        n--;
      }

      return n;
    }
  }, {
    key: "_nextRow",
    get: function get() {
      return this._lastRowNumber + 1;
    }
  }, {
    key: "lastRow",
    get: function get() {
      if (this._rows.length) {
        return this._rows[this._rows.length - 1];
      }

      return undefined;
    }
  }, {
    key: "rowCount",
    get: function get() {
      return this._lastRowNumber;
    }
  }, {
    key: "actualRowCount",
    get: function get() {
      // counts actual rows that have actual data
      var count = 0;
      this.eachRow(function () {
        count++;
      });
      return count;
    }
  }, {
    key: "hasMerges",
    get: function get() {
      // return true if this._merges has a merge object
      return _.some(this._merges, Boolean);
    }
  }, {
    key: "tabColor",
    get: function get() {
      // eslint-disable-next-line no-console
      console.trace('worksheet.tabColor property is now deprecated. Please use worksheet.properties.tabColor');
      return this.properties.tabColor;
    },
    set: function set(value) {
      // eslint-disable-next-line no-console
      console.trace('worksheet.tabColor property is now deprecated. Please use worksheet.properties.tabColor');
      this.properties.tabColor = value;
    } // ===========================================================================
    // Model

  }, {
    key: "model",
    get: function get() {
      var model = {
        id: this.id,
        name: this.name,
        dataValidations: this.dataValidations.model,
        properties: this.properties,
        state: this.state,
        pageSetup: this.pageSetup,
        headerFooter: this.headerFooter,
        rowBreaks: this.rowBreaks,
        views: this.views,
        autoFilter: this.autoFilter,
        media: this._media.map(function (medium) {
          return medium.model;
        }),
        sheetProtection: this.sheetProtection,
        tables: Object.values(this.tables).map(function (table) {
          return table.model;
        })
      }; // =================================================
      // columns

      model.cols = Column.toModel(this.columns); // ==========================================================
      // Rows

      var rows = model.rows = [];
      var dimensions = model.dimensions = new Range();

      this._rows.forEach(function (row) {
        var rowModel = row && row.model;

        if (rowModel) {
          dimensions.expand(rowModel.number, rowModel.min, rowModel.number, rowModel.max);
          rows.push(rowModel);
        }
      }); // ==========================================================
      // Merges


      model.merges = [];

      _.each(this._merges, function (merge) {
        model.merges.push(merge.range);
      });

      return model;
    },
    set: function set(value) {
      var _this8 = this;

      this.name = value.name;
      this._columns = Column.fromModel(this, value.cols);

      this._parseRows(value);

      this._parseMergeCells(value);

      this.dataValidations = new DataValidations(value.dataValidations);
      this.properties = value.properties;
      this.pageSetup = value.pageSetup;
      this.headerFooter = value.headerFooter;
      this.views = value.views;
      this.autoFilter = value.autoFilter;
      this._media = value.media.map(function (medium) {
        return new Image(_this8, medium);
      });
      this.sheetProtection = value.sheetProtection;
      this.tables = value.tables.reduce(function (tables, table) {
        var t = new Table();
        t.model = table;
        tables[table.name] = t;
        return tables;
      }, {});
    }
  }]);

  return Worksheet;
}();

module.exports = Worksheet;


},{"../utils/encryptor":19,"../utils/promise":20,"../utils/under-dash":24,"./../utils/col-cache":18,"./column":5,"./data-validations":6,"./enums":8,"./image":9,"./range":11,"./row":12,"./table":13}],16:[function(require,module,exports){
"use strict";

// for the benefit of browserify, include browser friendly promise
var setConfigValue = require('./config/set-value');

setConfigValue('promise', require('promish/dist/promish-node'), false);
var ExcelJS = {
  Workbook: require('./doc/workbook')
}; // Object.assign mono-fill

var Enums = require('./doc/enums');

Object.keys(Enums).forEach(function (key) {
  ExcelJS[key] = Enums[key];
});
module.exports = ExcelJS;


},{"./config/set-value":1,"./doc/enums":8,"./doc/workbook":14,"promish/dist/promish-node":307}],17:[function(require,module,exports){
"use strict";

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var _ = require('./under-dash');

var colCache = require('./col-cache');

var CellMatrix =
/*#__PURE__*/
function () {
  function CellMatrix(template) {
    _classCallCheck(this, CellMatrix);

    this.template = template;
    this.sheets = {};
  }

  _createClass(CellMatrix, [{
    key: "addCell",
    value: function addCell(addressStr) {
      this.addCellEx(colCache.decodeEx(addressStr));
    }
  }, {
    key: "getCell",
    value: function getCell(addressStr) {
      return this.findCellEx(colCache.decodeEx(addressStr), true);
    }
  }, {
    key: "findCell",
    value: function findCell(addressStr) {
      return this.findCellEx(colCache.decodeEx(addressStr), false);
    }
  }, {
    key: "findCellAt",
    value: function findCellAt(sheetName, rowNumber, colNumber) {
      var sheet = this.sheets[sheetName];
      var row = sheet && sheet[rowNumber];
      return row && row[colNumber];
    }
  }, {
    key: "addCellEx",
    value: function addCellEx(address) {
      if (address.top) {
        for (var row = address.top; row <= address.bottom; row++) {
          for (var col = address.left; col <= address.right; col++) {
            this.getCellAt(address.sheetName, row, col);
          }
        }
      } else {
        this.findCellEx(address, true);
      }
    }
  }, {
    key: "getCellEx",
    value: function getCellEx(address) {
      return this.findCellEx(address, true);
    }
  }, {
    key: "findCellEx",
    value: function findCellEx(address, create) {
      var sheet = this.findSheet(address, create);
      var row = this.findSheetRow(sheet, address, create);
      return this.findRowCell(row, address, create);
    }
  }, {
    key: "getCellAt",
    value: function getCellAt(sheetName, rowNumber, colNumber) {
      var sheet = this.sheets[sheetName] || (this.sheets[sheetName] = []);
      var row = sheet[rowNumber] || (sheet[rowNumber] = []);
      var cell = row[colNumber] || (row[colNumber] = {
        sheetName: sheetName,
        address: colCache.n2l(colNumber) + rowNumber,
        row: rowNumber,
        col: colNumber
      });
      return cell;
    }
  }, {
    key: "removeCellEx",
    value: function removeCellEx(address) {
      var sheet = this.findSheet(address);

      if (!sheet) {
        return;
      }

      var row = this.findSheetRow(sheet, address);

      if (!row) {
        return;
      }

      delete row[address.col];
    }
  }, {
    key: "forEachInSheet",
    value: function forEachInSheet(sheetName, callback) {
      var sheet = this.sheets[sheetName];

      if (sheet) {
        sheet.forEach(function (row, rowNumber) {
          if (row) {
            row.forEach(function (cell, colNumber) {
              if (cell) {
                callback(cell, rowNumber, colNumber);
              }
            });
          }
        });
      }
    }
  }, {
    key: "forEach",
    value: function forEach(callback) {
      var _this = this;

      _.each(this.sheets, function (sheet, sheetName) {
        _this.forEachInSheet(sheetName, callback);
      });
    }
  }, {
    key: "map",
    value: function map(callback) {
      var results = [];
      this.forEach(function (cell) {
        results.push(callback(cell));
      });
      return results;
    }
  }, {
    key: "findSheet",
    value: function findSheet(address, create) {
      var name = address.sheetName;

      if (this.sheets[name]) {
        return this.sheets[name];
      }

      if (create) {
        return this.sheets[name] = [];
      }

      return undefined;
    }
  }, {
    key: "findSheetRow",
    value: function findSheetRow(sheet, address, create) {
      var row = address.row;

      if (sheet && sheet[row]) {
        return sheet[row];
      }

      if (create) {
        return sheet[row] = [];
      }

      return undefined;
    }
  }, {
    key: "findRowCell",
    value: function findRowCell(row, address, create) {
      var col = address.col;

      if (row && row[col]) {
        return row[col];
      }

      if (create) {
        return row[col] = this.template ? Object.assign(address, JSON.parse(JSON.stringify(this.template))) : address;
      }

      return undefined;
    }
  }, {
    key: "spliceRows",
    value: function spliceRows(sheetName, start, numDelete, numInsert) {
      var sheet = this.sheets[sheetName];

      if (sheet) {
        var inserts = [];

        for (var i = 0; i < numInsert; i++) {
          inserts.push([]);
        }

        sheet.splice.apply(sheet, [start, numDelete].concat(inserts));
      }
    }
  }, {
    key: "spliceColumns",
    value: function spliceColumns(sheetName, start, numDelete, numInsert) {
      var sheet = this.sheets[sheetName];

      if (sheet) {
        var inserts = [];

        for (var i = 0; i < numInsert; i++) {
          inserts.push(null);
        }

        _.each(sheet, function (row) {
          row.splice.apply(row, [start, numDelete].concat(inserts));
        });
      }
    }
  }]);

  return CellMatrix;
}();

module.exports = CellMatrix;


},{"./col-cache":18,"./under-dash":24}],18:[function(require,module,exports){
"use strict";

// =========================================================================
// Column Letter to Number conversion
var colCache = {
  _dictionary: ['A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'],
  _l2n: {},
  _n2l: [],
  _level: function _level(n) {
    if (n <= 26) {
      return 1;
    }

    if (n <= 26 * 26) {
      return 2;
    }

    return 3;
  },
  _fill: function _fill(level) {
    var c;
    var v;
    var l1;
    var l2;
    var l3;
    var n = 1;

    if (level >= 1) {
      while (n <= 26) {
        c = this._dictionary[n - 1];
        this._n2l[n] = c;
        this._l2n[c] = n;
        n++;
      }
    }

    if (level >= 2) {
      while (n <= 26 + 26 * 26) {
        v = n - (26 + 1);
        l1 = v % 26;
        l2 = Math.floor(v / 26);
        c = this._dictionary[l2] + this._dictionary[l1];
        this._n2l[n] = c;
        this._l2n[c] = n;
        n++;
      }
    }

    if (level >= 3) {
      while (n <= 16384) {
        v = n - (26 * 26 + 26 + 1);
        l1 = v % 26;
        l2 = Math.floor(v / 26) % 26;
        l3 = Math.floor(v / (26 * 26));
        c = this._dictionary[l3] + this._dictionary[l2] + this._dictionary[l1];
        this._n2l[n] = c;
        this._l2n[c] = n;
        n++;
      }
    }
  },
  l2n: function l2n(l) {
    if (!this._l2n[l]) {
      this._fill(l.length);
    }

    if (!this._l2n[l]) {
      throw new Error("Out of bounds. Invalid column letter: ".concat(l));
    }

    return this._l2n[l];
  },
  n2l: function n2l(n) {
    if (n < 1 || n > 16384) {
      throw new Error("".concat(n, " is out of bounds. Excel supports columns from 1 to 16384"));
    }

    if (!this._n2l[n]) {
      this._fill(this._level(n));
    }

    return this._n2l[n];
  },
  // =========================================================================
  // Address processing
  _hash: {},
  // check if value looks like an address
  validateAddress: function validateAddress(value) {
    if (!value.match(/^[A-Z]+\d+$/)) {
      throw new Error("Invalid Address: ".concat(value));
    }

    return true;
  },
  // convert address string into structure
  decodeAddress: function decodeAddress(value) {
    var addr = this._hash[value];

    if (addr) {
      return addr;
    }

    var matchCol = value.match(/[A-Z]+/);
    var col;
    var colNumber;

    if (matchCol) {
      col = matchCol[0];
      colNumber = this.l2n(col);
    }

    var matchRow = value.match(/\d+/);
    var row;
    var rowNumber;

    if (matchRow) {
      row = matchRow[0];
      rowNumber = parseInt(row, 10);
    } // in case $row$col


    value = (col || '') + (row || '');
    var address = {
      address: value,
      col: colNumber,
      row: rowNumber,
      $col$row: "$".concat(col || '', "$").concat(row || '')
    }; // mem fix - cache only the tl 100x100 square

    if (colNumber <= 100 && rowNumber <= 100) {
      this._hash[value] = address;
      this._hash[address.$col$row] = address;
    }

    return address;
  },
  // convert r,c into structure (if only 1 arg, assume r is address string)
  getAddress: function getAddress(r, c) {
    if (c) {
      var address = this.n2l(c) + r;
      return this.decodeAddress(address);
    }

    return this.decodeAddress(r);
  },
  // convert [address], [tl:br] into address structures
  decode: function decode(value) {
    var parts = value.split(':');

    if (parts.length === 2) {
      var tl = this.decodeAddress(parts[0]);
      var br = this.decodeAddress(parts[1]);
      var result = {
        top: Math.min(tl.row, br.row),
        left: Math.min(tl.col, br.col),
        bottom: Math.max(tl.row, br.row),
        right: Math.max(tl.col, br.col)
      }; // reconstruct tl, br and dimensions

      result.tl = this.n2l(result.left) + result.top;
      result.br = this.n2l(result.right) + result.bottom;
      result.dimensions = "".concat(result.tl, ":").concat(result.br);
      return result;
    }

    return this.decodeAddress(value);
  },
  // convert [sheetName!][$]col[$]row[[$]col[$]row] into address or range structures
  decodeEx: function decodeEx(value) {
    var groups = value.match(/(?:(?:(?:'((?:[^']|'')*)')|([^'^ !]*))!)?(.*)/);
    var sheetName = groups[1] || groups[2]; // Qouted and unqouted groups

    var reference = groups[3]; // Remaining address

    var parts = reference.split(':');

    if (parts.length > 1) {
      var tl = this.decodeAddress(parts[0]);
      var br = this.decodeAddress(parts[1]);
      var top = Math.min(tl.row, br.row);
      var left = Math.min(tl.col, br.col);
      var bottom = Math.max(tl.row, br.row);
      var right = Math.max(tl.col, br.col);
      tl = this.n2l(left) + top;
      br = this.n2l(right) + bottom;
      return {
        top: top,
        left: left,
        bottom: bottom,
        right: right,
        sheetName: sheetName,
        tl: {
          address: tl,
          col: left,
          row: top,
          $col$row: "$".concat(this.n2l(left), "$").concat(top),
          sheetName: sheetName
        },
        br: {
          address: br,
          col: right,
          row: bottom,
          $col$row: "$".concat(this.n2l(right), "$").concat(bottom),
          sheetName: sheetName
        },
        dimensions: "".concat(tl, ":").concat(br)
      };
    }

    if (reference.startsWith('#')) {
      return sheetName ? {
        sheetName: sheetName,
        error: reference
      } : {
        error: reference
      };
    }

    var address = this.decodeAddress(reference);
    return sheetName ? Object.assign({
      sheetName: sheetName
    }, address) : address;
  },
  // convert row,col into address string
  encodeAddress: function encodeAddress(row, col) {
    return colCache.n2l(col) + row;
  },
  // convert row,col into string address or t,l,b,r into range
  encode: function encode() {
    switch (arguments.length) {
      case 2:
        return colCache.encodeAddress(arguments[0], arguments[1]);

      case 4:
        return "".concat(colCache.encodeAddress(arguments[0], arguments[1]), ":").concat(colCache.encodeAddress(arguments[2], arguments[3]));

      default:
        throw new Error('Can only encode with 2 or 4 arguments');
    }
  }
};
module.exports = colCache;


},{}],19:[function(require,module,exports){
(function (Buffer){
'use strict';

var crypto = require('crypto');

var Encryptor = {
  /**
   * Calculate a hash of the concatenated buffers with the given algorithm.
   * @param {string} algorithm - The hash algorithm.
   * @returns {Buffer} The hash
   */
  hash: function hash(algorithm) {
    var hash = crypto.createHash(algorithm);

    for (var _len = arguments.length, buffers = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
      buffers[_key - 1] = arguments[_key];
    }

    hash.update(Buffer.concat(buffers));
    return hash.digest();
  },

  /**
   * Convert a password into an encryption key
   * @param {string} password - The password
   * @param {string} hashAlgorithm - The hash algoritm
   * @param {string} saltValue - The salt value
   * @param {number} spinCount - The spin count
   * @param {number} keyBits - The length of the key in bits
   * @param {Buffer} blockKey - The block key
   * @returns {Buffer} The encryption key
   */
  convertPasswordToHash: function convertPasswordToHash(password, hashAlgorithm, saltValue, spinCount) {
    hashAlgorithm = hashAlgorithm.toLowerCase();
    var hashes = crypto.getHashes();

    if (hashes.indexOf(hashAlgorithm) < 0) {
      throw new Error("Hash algorithm '".concat(hashAlgorithm, "' not supported!"));
    } // Password must be in unicode buffer


    var passwordBuffer = Buffer.from(password, 'utf16le'); // Generate the initial hash

    var key = this.hash(hashAlgorithm, Buffer.from(saltValue, 'base64'), passwordBuffer); // Now regenerate until spin count

    for (var i = 0; i < spinCount; i++) {
      var iterator = Buffer.alloc(4); // this is the 'special' element of Excel password hashing
      // that stops us from using crypto.pbkdf2()

      iterator.writeUInt32LE(i, 0);
      key = this.hash(hashAlgorithm, key, iterator);
    }

    return key.toString('base64');
  },

  /**
   * Generates cryptographically strong pseudo-random data.
   * @param size The size argument is a number indicating the number of bytes to generate.
   */
  randomBytes: function randomBytes(size) {
    return crypto.randomBytes(size);
  }
};
module.exports = Encryptor;


}).call(this,require("buffer").Buffer)
},{"buffer":162,"crypto":170}],20:[function(require,module,exports){
"use strict";

module.exports = {
  Promise: typeof Promise !== 'undefined' ? Promise : null
};


},{}],21:[function(require,module,exports){
'use strict';

var colCache = require('./col-cache'); // const cellRefRegex = /(([a-z_\-0-9]*)!)?[$]?([a-z]+)[$]?([1-9][0-9]*)/i;


var replacementCandidateRx = /(([a-z_\-0-9]*)!)?([a-z0-9_$]{2,})([(])?/gi;
var CRrx = /^([$])?([a-z]+)([$])?([1-9][0-9]*)$/i;

function slideFormula(formula, fromCell, toCell) {
  var offset = colCache.decode(fromCell);
  var to = colCache.decode(toCell);
  return formula.replace(replacementCandidateRx, function (refMatch, sheet, sheetMaybe, addrPart, trailingParen) {
    if (trailingParen) {
      return refMatch;
    }

    var match = CRrx.exec(addrPart);

    if (match) {
      var colDollar = match[1];
      var colStr = match[2].toUpperCase();
      var rowDollar = match[3];
      var rowStr = match[4];

      if (colStr.length > 3 || colStr.length === 3 && colStr > 'XFD') {
        // > XFD is the highest col number in excel 2007 and beyond, so this is a named range
        return refMatch;
      }

      var col = colCache.l2n(colStr);
      var row = parseInt(rowStr, 10);

      if (!colDollar) {
        col += to.col - offset.col;
      }

      if (!rowDollar) {
        row += to.row - offset.row;
      }

      var res = (sheet || '') + (colDollar || '') + colCache.n2l(col) + (rowDollar || '') + row;
      return res;
    }

    return refMatch;
  });
}

module.exports = {
  slideFormula: slideFormula
};


},{"./col-cache":18}],22:[function(require,module,exports){
(function (process,Buffer){
'use strict';

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var Stream = require('stream');

var PromiseLib = require('./promise');

var utils = require('./utils');

var StringBuf = require('./string-buf'); // =============================================================================
// data chunks - encapsulating incoming data


var StringChunk =
/*#__PURE__*/
function () {
  function StringChunk(data, encoding) {
    _classCallCheck(this, StringChunk);

    this._data = data;
    this._encoding = encoding;
  }

  _createClass(StringChunk, [{
    key: "copy",
    // copy to target buffer
    value: function copy(target, targetOffset, offset, length) {
      return this.toBuffer().copy(target, targetOffset, offset, length);
    }
  }, {
    key: "toBuffer",
    value: function toBuffer() {
      if (!this._buffer) {
        this._buffer = Buffer.from(this._data, this._encoding);
      }

      return this._buffer;
    }
  }, {
    key: "length",
    get: function get() {
      return this.toBuffer().length;
    }
  }]);

  return StringChunk;
}();

var StringBufChunk =
/*#__PURE__*/
function () {
  function StringBufChunk(data) {
    _classCallCheck(this, StringBufChunk);

    this._data = data;
  }

  _createClass(StringBufChunk, [{
    key: "copy",
    // copy to target buffer
    value: function copy(target, targetOffset, offset, length) {
      // eslint-disable-next-line no-underscore-dangle
      return this._data._buf.copy(target, targetOffset, offset, length);
    }
  }, {
    key: "toBuffer",
    value: function toBuffer() {
      return this._data.toBuffer();
    }
  }, {
    key: "length",
    get: function get() {
      return this._data.length;
    }
  }]);

  return StringBufChunk;
}();

var BufferChunk =
/*#__PURE__*/
function () {
  function BufferChunk(data) {
    _classCallCheck(this, BufferChunk);

    this._data = data;
  }

  _createClass(BufferChunk, [{
    key: "copy",
    // copy to target buffer
    value: function copy(target, targetOffset, offset, length) {
      this._data.copy(target, targetOffset, offset, length);
    }
  }, {
    key: "toBuffer",
    value: function toBuffer() {
      return this._data;
    }
  }, {
    key: "length",
    get: function get() {
      return this._data.length;
    }
  }]);

  return BufferChunk;
}(); // =============================================================================
// ReadWriteBuf - a single buffer supporting simple read-write


var ReadWriteBuf =
/*#__PURE__*/
function () {
  function ReadWriteBuf(size) {
    _classCallCheck(this, ReadWriteBuf);

    this.size = size; // the buffer

    this.buffer = Buffer.alloc(size); // read index

    this.iRead = 0; // write index

    this.iWrite = 0;
  }

  _createClass(ReadWriteBuf, [{
    key: "toBuffer",
    value: function toBuffer() {
      if (this.iRead === 0 && this.iWrite === this.size) {
        return this.buffer;
      }

      var buf = Buffer.alloc(this.iWrite - this.iRead);
      this.buffer.copy(buf, 0, this.iRead, this.iWrite);
      return buf;
    }
  }, {
    key: "read",
    value: function read(size) {
      var buf; // read size bytes from buffer and return buffer

      if (size === 0) {
        // special case - return null if no data requested
        return null;
      }

      if (size === undefined || size >= this.length) {
        // if no size specified or size is at least what we have then return all of the bytes
        buf = this.toBuffer();
        this.iRead = this.iWrite;
        return buf;
      } // otherwise return a chunk


      buf = Buffer.alloc(size);
      this.buffer.copy(buf, 0, this.iRead, size);
      this.iRead += size;
      return buf;
    }
  }, {
    key: "write",
    value: function write(chunk, offset, length) {
      // write as many bytes from data from optional source offset
      // and return number of bytes written
      var size = Math.min(length, this.size - this.iWrite);
      chunk.copy(this.buffer, this.iWrite, offset, offset + size);
      this.iWrite += size;
      return size;
    }
  }, {
    key: "length",
    get: function get() {
      return this.iWrite - this.iRead;
    }
  }, {
    key: "eod",
    get: function get() {
      return this.iRead === this.iWrite;
    }
  }, {
    key: "full",
    get: function get() {
      return this.iWrite === this.size;
    }
  }]);

  return ReadWriteBuf;
}(); // =============================================================================
// StreamBuf - a multi-purpose read-write stream
//  As MemBuf - write as much data as you like. Then call toBuffer() to consolidate
//  As StreamHub - pipe to multiple writables
//  As readable stream - feed data into the writable part and have some other code read from it.
// Note: Not sure why but StreamBuf does not like JS "class" sugar. It fails the
// integration tests


var StreamBuf = function StreamBuf(options) {
  options = options || {};
  this.bufSize = options.bufSize || 1024 * 1024;
  this.buffers = []; // batch mode fills a buffer completely before passing the data on
  // to pipes or 'readable' event listeners

  this.batch = options.batch || false;
  this.corked = false; // where in the current writable buffer we're up to

  this.inPos = 0; // where in the current readable buffer we've read up to

  this.outPos = 0; // consuming pipe streams go here

  this.pipes = []; // controls emit('data')

  this.paused = false;
  this.encoding = null;
};

utils.inherits(StreamBuf, Stream.Duplex, {
  toBuffer: function toBuffer() {
    switch (this.buffers.length) {
      case 0:
        return null;

      case 1:
        return this.buffers[0].toBuffer();

      default:
        return Buffer.concat(this.buffers.map(function (rwBuf) {
          return rwBuf.toBuffer();
        }));
    }
  },
  // writable
  // event drain - if write returns false (which it won't), indicates when safe to write again.
  // finish - end() has been called
  // pipe(src) - pipe() has been called on readable
  // unpipe(src) - unpipe() has been called on readable
  // error - duh
  _getWritableBuffer: function _getWritableBuffer() {
    if (this.buffers.length) {
      var last = this.buffers[this.buffers.length - 1];

      if (!last.full) {
        return last;
      }
    }

    var buf = new ReadWriteBuf(this.bufSize);
    this.buffers.push(buf);
    return buf;
  },
  _pipe: function _pipe(chunk) {
    var write = function write(pipe) {
      return new PromiseLib.Promise(function (resolve) {
        pipe.write(chunk.toBuffer(), function () {
          resolve();
        });
      });
    };

    var promises = this.pipes.map(write);
    return promises.length ? PromiseLib.Promise.all(promises).then(utils.nop) : PromiseLib.Promise.resolve();
  },
  _writeToBuffers: function _writeToBuffers(chunk) {
    var inPos = 0;
    var inLen = chunk.length;

    while (inPos < inLen) {
      // find writable buffer
      var buffer = this._getWritableBuffer(); // write some data


      inPos += buffer.write(chunk, inPos, inLen - inPos);
    }
  },
  write: function write(data, encoding, callback) {
    if (encoding instanceof Function) {
      callback = encoding;
      encoding = 'utf8';
    }

    callback = callback || utils.nop; // encapsulate data into a chunk

    var chunk;

    if (data instanceof StringBuf) {
      chunk = new StringBufChunk(data);
    } else if (data instanceof Buffer) {
      chunk = new BufferChunk(data);
    } else {
      // assume string
      chunk = new StringChunk(data, encoding);
    } // now, do something with the chunk


    if (this.pipes.length) {
      if (this.batch) {
        this._writeToBuffers(chunk);

        while (!this.corked && this.buffers.length > 1) {
          this._pipe(this.buffers.shift());
        }
      } else if (!this.corked) {
        this._pipe(chunk).then(callback);
      } else {
        this._writeToBuffers(chunk);

        process.nextTick(callback);
      }
    } else {
      if (!this.paused) {
        this.emit('data', chunk.toBuffer());
      }

      this._writeToBuffers(chunk);

      this.emit('readable');
    }

    return true;
  },
  cork: function cork() {
    this.corked = true;
  },
  _flush: function _flush()
  /* destination */
  {
    // if we have comsumers...
    if (this.pipes.length) {
      // and there's stuff not written
      while (this.buffers.length) {
        this._pipe(this.buffers.shift());
      }
    }
  },
  uncork: function uncork() {
    this.corked = false;

    this._flush();
  },
  end: function end(chunk, encoding, callback) {
    var _this = this;

    var writeComplete = function writeComplete(error) {
      if (error) {
        callback(error);
      } else {
        _this._flush();

        _this.pipes.forEach(function (pipe) {
          pipe.end();
        });

        _this.emit('finish');
      }
    };

    if (chunk) {
      this.write(chunk, encoding, writeComplete);
    } else {
      writeComplete();
    }
  },
  // readable
  // event readable - some data is now available
  // event data - switch to flowing mode - feeds chunks to handler
  // event end - no more data
  // event close - optional, indicates upstream close
  // event error - duh
  read: function read(size) {
    var buffers; // read min(buffer, size || infinity)

    if (size) {
      buffers = [];

      while (size && this.buffers.length && !this.buffers[0].eod) {
        var first = this.buffers[0];
        var buffer = first.read(size);
        size -= buffer.length;
        buffers.push(buffer);

        if (first.eod && first.full) {
          this.buffers.shift();
        }
      }

      return Buffer.concat(buffers);
    }

    buffers = this.buffers.map(function (buf) {
      return buf.toBuffer();
    }).filter(Boolean);
    this.buffers = [];
    return Buffer.concat(buffers);
  },
  setEncoding: function setEncoding(encoding) {
    // causes stream.read or stream.on('data) to return strings of encoding instead of Buffer objects
    this.encoding = encoding;
  },
  pause: function pause() {
    this.paused = true;
  },
  resume: function resume() {
    this.paused = false;
  },
  isPaused: function isPaused() {
    return !!this.paused;
  },
  pipe: function pipe(destination) {
    // add destination to pipe list & write current buffer
    this.pipes.push(destination);

    if (!this.paused && this.buffers.length) {
      this.end();
    }
  },
  unpipe: function unpipe(destination) {
    // remove destination from pipe list
    this.pipes = this.pipes.filter(function (pipe) {
      return pipe !== destination;
    });
  },
  unshift: function unshift()
  /* chunk */
  {
    // some numpty has read some data that's not for them and they want to put it back!
    // Might implement this some day
    throw new Error('Not Implemented');
  },
  wrap: function wrap()
  /* stream */
  {
    // not implemented
    throw new Error('Not Implemented');
  }
});
module.exports = StreamBuf;


}).call(this,require('_process'),require("buffer").Buffer)
},{"./promise":20,"./string-buf":23,"./utils":25,"_process":305,"buffer":162,"stream":342}],23:[function(require,module,exports){
(function (Buffer){
"use strict";

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

// StringBuf - a way to keep string memory operations to a minimum
// while building the strings for the xml files
var StringBuf =
/*#__PURE__*/
function () {
  function StringBuf(options) {
    _classCallCheck(this, StringBuf);

    this._buf = Buffer.alloc(options && options.size || 16384);
    this._encoding = options && options.encoding || 'utf8'; // where in the buffer we are at

    this._inPos = 0; // for use by toBuffer()

    this._buffer = undefined;
  }

  _createClass(StringBuf, [{
    key: "toBuffer",
    value: function toBuffer() {
      // return the current data as a single enclosing buffer
      if (!this._buffer) {
        this._buffer = Buffer.alloc(this.length);

        this._buf.copy(this._buffer, 0, 0, this.length);
      }

      return this._buffer;
    }
  }, {
    key: "reset",
    value: function reset(position) {
      position = position || 0;
      this._buffer = undefined;
      this._inPos = position;
    }
  }, {
    key: "_grow",
    value: function _grow(min) {
      var size = this._buf.length * 2;

      while (size < min) {
        size *= 2;
      }

      var buf = Buffer.alloc(size);

      this._buf.copy(buf, 0);

      this._buf = buf;
    }
  }, {
    key: "addText",
    value: function addText(text) {
      this._buffer = undefined;

      var inPos = this._inPos + this._buf.write(text, this._inPos, this._encoding); // if we've hit (or nearing capacity), grow the buf


      while (inPos >= this._buf.length - 4) {
        this._grow(this._inPos + text.length); // keep trying to write until we've completely written the text


        inPos = this._inPos + this._buf.write(text, this._inPos, this._encoding);
      }

      this._inPos = inPos;
    }
  }, {
    key: "addStringBuf",
    value: function addStringBuf(inBuf) {
      if (inBuf.length) {
        this._buffer = undefined;

        if (this.length + inBuf.length > this.capacity) {
          this._grow(this.length + inBuf.length);
        } // eslint-disable-next-line no-underscore-dangle


        inBuf._buf.copy(this._buf, this._inPos, 0, inBuf.length);

        this._inPos += inBuf.length;
      }
    }
  }, {
    key: "length",
    get: function get() {
      return this._inPos;
    }
  }, {
    key: "capacity",
    get: function get() {
      return this._buf.length;
    }
  }, {
    key: "buffer",
    get: function get() {
      return this._buf;
    }
  }]);

  return StringBuf;
}();

module.exports = StringBuf;


}).call(this,require("buffer").Buffer)
},{"buffer":162}],24:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

var _ = {
  each: function each(obj, cb) {
    if (obj) {
      if (Array.isArray(obj)) {
        obj.forEach(cb);
      } else {
        Object.keys(obj).forEach(function (key) {
          cb(obj[key], key);
        });
      }
    }
  },
  some: function some(obj, cb) {
    if (obj) {
      if (Array.isArray(obj)) {
        return obj.some(cb);
      }

      return Object.keys(obj).some(function (key) {
        return cb(obj[key], key);
      });
    }

    return false;
  },
  every: function every(obj, cb) {
    if (obj) {
      if (Array.isArray(obj)) {
        return obj.every(cb);
      }

      return Object.keys(obj).every(function (key) {
        return cb(obj[key], key);
      });
    }

    return true;
  },
  map: function map(obj, cb) {
    if (obj) {
      if (Array.isArray(obj)) {
        return obj.map(cb);
      }

      return Object.keys(obj).map(function (key) {
        return cb(obj[key], key);
      });
    }

    return [];
  },
  isEqual: function isEqual(a, b) {
    var aType = _typeof(a);

    var bType = _typeof(b);

    var aArray = Array.isArray(a);
    var bArray = Array.isArray(b);

    if (aType !== bType) {
      return false;
    }

    switch (_typeof(a)) {
      case 'object':
        if (aArray || bArray) {
          if (aArray && bArray) {
            return a.length === b.length && a.every(function (aValue, index) {
              var bValue = b[index];
              return _.isEqual(aValue, bValue);
            });
          }

          return false;
        }

        return _.every(a, function (aValue, key) {
          var bValue = b[key];
          return _.isEqual(aValue, bValue);
        });

      default:
        return a === b;
    }
  },
  escapeHtml: function escapeHtml(html) {
    return html.replace(/&/g, '&amp;').replace(/</g, '&lt;').replace(/>/g, '&gt;').replace(/"/g, '&quot;').replace(/'/g, '&#039;');
  }
};
module.exports = _;


},{}],25:[function(require,module,exports){
(function (global,setImmediate){
"use strict";

var fs = require('fs');

var PromiseLib = require('./promise'); // useful stuff


var inherits = function inherits(cls, superCtor, statics, prototype) {
  // eslint-disable-next-line no-underscore-dangle
  cls.super_ = superCtor;

  if (!prototype) {
    prototype = statics;
    statics = null;
  }

  if (statics) {
    Object.keys(statics).forEach(function (i) {
      Object.defineProperty(cls, i, Object.getOwnPropertyDescriptor(statics, i));
    });
  }

  var properties = {
    constructor: {
      value: cls,
      enumerable: false,
      writable: false,
      configurable: true
    }
  };

  if (prototype) {
    Object.keys(prototype).forEach(function (i) {
      properties[i] = Object.getOwnPropertyDescriptor(prototype, i);
    });
  }

  cls.prototype = Object.create(superCtor.prototype, properties);
};

var utils = {
  nop: function nop() {},
  promiseImmediate: function promiseImmediate(value) {
    return new PromiseLib.Promise(function (resolve) {
      if (global.setImmediate) {
        setImmediate(function () {
          resolve(value);
        });
      } else {
        // poorman's setImmediate - must wait at least 1ms
        setTimeout(function () {
          resolve(value);
        }, 1);
      }
    });
  },
  inherits: inherits,
  dateToExcel: function dateToExcel(d, date1904) {
    return 25569 + d.getTime() / (24 * 3600 * 1000) - (date1904 ? 1462 : 0);
  },
  excelToDate: function excelToDate(v, date1904) {
    var millisecondSinceEpoch = Math.round((v - 25569 + (date1904 ? 1462 : 0)) * 24 * 3600 * 1000);
    return new Date(millisecondSinceEpoch);
  },
  parsePath: function parsePath(filepath) {
    var last = filepath.lastIndexOf('/');
    return {
      path: filepath.substring(0, last),
      name: filepath.substring(last + 1)
    };
  },
  getRelsPath: function getRelsPath(filepath) {
    var path = utils.parsePath(filepath);
    return "".concat(path.path, "/_rels/").concat(path.name, ".rels");
  },
  xmlEncode: function xmlEncode(text) {
    // eslint-disable-next-line no-control-regex
    return text.replace(/[<>&'"\x7F\x00-\x08\x0B-\x0C\x0E-\x1F]/g, function (c) {
      switch (c) {
        case '<':
          return '&lt;';

        case '>':
          return '&gt;';

        case '&':
          return '&amp;';

        case '\'':
          return '&apos;';

        case '"':
          return '&quot;';

        default:
          return '';
      }
    });
  },
  xmlDecode: function xmlDecode(text) {
    return text.replace(/&([a-z]*);/, function (c) {
      switch (c) {
        case '&lt;':
          return '<';

        case '&gt;':
          return '>';

        case '&amp;':
          return '&';

        case '&apos;':
          return '\'';

        case '&quot;':
          return '"';

        default:
          return c;
      }
    });
  },
  validInt: function validInt(value) {
    var i = parseInt(value, 10);
    return !Number.isNaN(i) ? i : 0;
  },
  isDateFmt: function isDateFmt(fmt) {
    if (!fmt) {
      return false;
    } // must remove all chars inside quotes and []


    fmt = fmt.replace(/\[[^\]]*]/g, '');
    fmt = fmt.replace(/"[^"]*"/g, ''); // then check for date formatting chars

    var result = fmt.match(/[ymdhMsb]+/) !== null;
    return result;
  },
  fs: {
    exists: function exists(path) {
      return new PromiseLib.Promise(function (resolve) {
        fs.exists(path, function (exists) {
          resolve(exists);
        });
      });
    }
  },
  toIsoDateString: function toIsoDateString(dt) {
    return dt.toIsoString().subsstr(0, 10);
  }
};
module.exports = utils;


}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {},require("timers").setImmediate)
},{"./promise":20,"fs":160,"timers":345}],26:[function(require,module,exports){
"use strict";

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var _ = require('./under-dash');

var utils = require('./utils'); // constants


var OPEN_ANGLE = '<';
var CLOSE_ANGLE = '>';
var OPEN_ANGLE_SLASH = '</';
var CLOSE_SLASH_ANGLE = '/>';
var EQUALS_QUOTE = '="';
var QUOTE = '"';
var SPACE = ' ';

function pushAttribute(xml, name, value) {
  xml.push(SPACE);
  xml.push(name);
  xml.push(EQUALS_QUOTE);
  xml.push(utils.xmlEncode(value.toString()));
  xml.push(QUOTE);
}

function pushAttributes(xml, attributes) {
  if (attributes) {
    _.each(attributes, function (value, name) {
      if (value !== undefined) {
        pushAttribute(xml, name, value);
      }
    });
  }
}

var XmlStream =
/*#__PURE__*/
function () {
  function XmlStream() {
    _classCallCheck(this, XmlStream);

    this._xml = [];
    this._stack = [];
    this._rollbacks = [];
  }

  _createClass(XmlStream, [{
    key: "openXml",
    value: function openXml(docAttributes) {
      var xml = this._xml; // <?xml version="1.0" encoding="UTF-8" standalone="yes"?>

      xml.push('<?xml');
      pushAttributes(xml, docAttributes);
      xml.push('?>\n');
    }
  }, {
    key: "openNode",
    value: function openNode(name, attributes) {
      var parent = this.tos;
      var xml = this._xml;

      if (parent && this.open) {
        xml.push(CLOSE_ANGLE);
      }

      this._stack.push(name); // start streaming node


      xml.push(OPEN_ANGLE);
      xml.push(name);
      pushAttributes(xml, attributes);
      this.leaf = true;
      this.open = true;
    }
  }, {
    key: "addAttribute",
    value: function addAttribute(name, value) {
      if (!this.open) {
        throw new Error('Cannot write attributes to node if it is not open');
      }

      pushAttribute(this._xml, name, value);
    }
  }, {
    key: "addAttributes",
    value: function addAttributes(attrs) {
      if (!this.open) {
        throw new Error('Cannot write attributes to node if it is not open');
      }

      pushAttributes(this._xml, attrs);
    }
  }, {
    key: "writeText",
    value: function writeText(text) {
      var xml = this._xml;

      if (this.open) {
        xml.push(CLOSE_ANGLE);
        this.open = false;
      }

      this.leaf = false;
      xml.push(utils.xmlEncode(text.toString()));
    }
  }, {
    key: "writeXml",
    value: function writeXml(xml) {
      if (this.open) {
        this._xml.push(CLOSE_ANGLE);

        this.open = false;
      }

      this.leaf = false;

      this._xml.push(xml);
    }
  }, {
    key: "closeNode",
    value: function closeNode() {
      var node = this._stack.pop();

      var xml = this._xml;

      if (this.leaf) {
        xml.push(CLOSE_SLASH_ANGLE);
      } else {
        xml.push(OPEN_ANGLE_SLASH);
        xml.push(node);
        xml.push(CLOSE_ANGLE);
      }

      this.open = false;
      this.leaf = false;
    }
  }, {
    key: "leafNode",
    value: function leafNode(name, attributes, text) {
      this.openNode(name, attributes);

      if (text !== undefined) {
        // zeros need to be written
        this.writeText(text);
      }

      this.closeNode();
    }
  }, {
    key: "closeAll",
    value: function closeAll() {
      while (this._stack.length) {
        this.closeNode();
      }
    }
  }, {
    key: "addRollback",
    value: function addRollback() {
      this._rollbacks.push({
        xml: this._xml.length,
        stack: this._stack.length,
        leaf: this.leaf,
        open: this.open
      });
    }
  }, {
    key: "commit",
    value: function commit() {
      this._rollbacks.pop();
    }
  }, {
    key: "rollback",
    value: function rollback() {
      var r = this._rollbacks.pop();

      if (this._xml.length > r.xml) {
        this._xml.splice(r.xml, this._xml.length - r.xml);
      }

      if (this._stack.length > r.stack) {
        this._stack.splice(r.stack, this._stack.length - r.stack);
      }

      this.leaf = r.leaf;
      this.open = r.open;
    }
  }, {
    key: "tos",
    get: function get() {
      return this._stack.length ? this._stack[this._stack.length - 1] : undefined;
    }
  }, {
    key: "xml",
    get: function get() {
      this.closeAll();
      return this._xml.join('');
    }
  }]);

  return XmlStream;
}();

XmlStream.StdDocAttributes = {
  version: '1.0',
  encoding: 'UTF-8',
  standalone: 'yes'
};
module.exports = XmlStream;


},{"./under-dash":24,"./utils":25}],27:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var events = require('events');

var JSZip = require('jszip');

var PromiseLib = require('./promise');

var StreamBuf = require('./stream-buf'); // The purpose of this module is to wrap the js-zip library into a streaming zip library
// since most of the exceljs code uses streams.
// One day I might find (or build) a properly streaming browser safe zip lib
// =============================================================================
// The ZipReader class
// Unpacks an incoming zip stream


var ZipReader =
/*#__PURE__*/
function (_events$EventEmitter) {
  _inherits(ZipReader, _events$EventEmitter);

  function ZipReader(options) {
    var _this;

    _classCallCheck(this, ZipReader);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(ZipReader).call(this));
    _this.count = 0;
    _this.jsZip = new JSZip();
    _this.stream = new StreamBuf();

    _this.stream.on('finish', function () {
      _this._process();
    });

    _this.getEntryType = options.getEntryType || function () {
      return 'string';
    };

    return _this;
  }

  _createClass(ZipReader, [{
    key: "_finished",
    value: function _finished() {
      var _this2 = this;

      if (! --this.count) {
        PromiseLib.Promise.resolve().then(function () {
          _this2.emit('finished');
        });
      }
    }
  }, {
    key: "_process",
    value: function _process() {
      var _this3 = this;

      var content = this.stream.read();
      this.jsZip.loadAsync(content).then(function (zip) {
        zip.forEach(function (path, entry) {
          if (!entry.dir) {
            _this3.count++;
            entry.async(_this3.getEntryType(path)).then(function (data) {
              var entryStream = new StreamBuf();
              entryStream.path = path;
              entryStream.write(data);

              entryStream.autodrain = function () {
                _this3._finished();
              };

              entryStream.on('finish', function () {
                _this3._finished();
              });

              _this3.emit('entry', entryStream);
            })["catch"](function (error) {
              _this3.emit('error', error);
            });
          }
        });
      })["catch"](function (error) {
        _this3.emit('error', error);
      });
    } // ==========================================================================
    // Stream.Writable interface

  }, {
    key: "write",
    value: function write(data, encoding, callback) {
      if (this.error) {
        if (callback) {
          callback(this.error);
        }

        throw this.error;
      } else {
        return this.stream.write(data, encoding, callback);
      }
    }
  }, {
    key: "cork",
    value: function cork() {
      return this.stream.cork();
    }
  }, {
    key: "uncork",
    value: function uncork() {
      return this.stream.uncork();
    }
  }, {
    key: "end",
    value: function end() {
      return this.stream.end();
    }
  }, {
    key: "destroy",
    value: function destroy(error) {
      this.emit('finished');
      this.error = error;
    }
  }]);

  return ZipReader;
}(events.EventEmitter); // =============================================================================
// The ZipWriter class
// Packs streamed data into an output zip stream


var ZipWriter =
/*#__PURE__*/
function (_events$EventEmitter2) {
  _inherits(ZipWriter, _events$EventEmitter2);

  function ZipWriter(options) {
    var _this4;

    _classCallCheck(this, ZipWriter);

    _this4 = _possibleConstructorReturn(this, _getPrototypeOf(ZipWriter).call(this));
    _this4.options = Object.assign({
      type: 'nodebuffer',
      compression: 'DEFLATE'
    }, options);
    _this4.zip = new JSZip();
    _this4.stream = new StreamBuf();
    return _this4;
  }

  _createClass(ZipWriter, [{
    key: "append",
    value: function append(data, options) {
      if (options.hasOwnProperty('base64') && options.base64) {
        this.zip.file(options.name, data, {
          base64: true
        });
      } else {
        this.zip.file(options.name, data);
      }
    }
  }, {
    key: "finalize",
    value: function finalize() {
      var _this5 = this;

      return this.zip.generateAsync(this.options).then(function (content) {
        _this5.stream.end(content);

        _this5.emit('finish');
      });
    } // ==========================================================================
    // Stream.Readable interface

  }, {
    key: "read",
    value: function read(size) {
      return this.stream.read(size);
    }
  }, {
    key: "setEncoding",
    value: function setEncoding(encoding) {
      return this.stream.setEncoding(encoding);
    }
  }, {
    key: "pause",
    value: function pause() {
      return this.stream.pause();
    }
  }, {
    key: "resume",
    value: function resume() {
      return this.stream.resume();
    }
  }, {
    key: "isPaused",
    value: function isPaused() {
      return this.stream.isPaused();
    }
  }, {
    key: "pipe",
    value: function pipe(destination, options) {
      return this.stream.pipe(destination, options);
    }
  }, {
    key: "unpipe",
    value: function unpipe(destination) {
      return this.stream.unpipe(destination);
    }
  }, {
    key: "unshift",
    value: function unshift(chunk) {
      return this.stream.unshift(chunk);
    }
  }, {
    key: "wrap",
    value: function wrap(stream) {
      return this.stream.wrap(stream);
    }
  }]);

  return ZipWriter;
}(events.EventEmitter); // =============================================================================


module.exports = {
  ZipReader: ZipReader,
  ZipWriter: ZipWriter
};


},{"./promise":20,"./stream-buf":22,"events":201,"jszip":244}],28:[function(require,module,exports){
"use strict";

module.exports = {
  0: {
    f: 'General'
  },
  1: {
    f: '0'
  },
  2: {
    f: '0.00'
  },
  3: {
    f: '#,##0'
  },
  4: {
    f: '#,##0.00'
  },
  9: {
    f: '0%'
  },
  10: {
    f: '0.00%'
  },
  11: {
    f: '0.00E+00'
  },
  12: {
    f: '# ?/?'
  },
  13: {
    f: '# ??/??'
  },
  14: {
    f: 'mm-dd-yy'
  },
  15: {
    f: 'd-mmm-yy'
  },
  16: {
    f: 'd-mmm'
  },
  17: {
    f: 'mmm-yy'
  },
  18: {
    f: 'h:mm AM/PM'
  },
  19: {
    f: 'h:mm:ss AM/PM'
  },
  20: {
    f: 'h:mm'
  },
  21: {
    f: 'h:mm:ss'
  },
  22: {
    f: 'm/d/yy "h":mm'
  },
  27: {
    'zh-tw': '[$-404]e/m/d',
    'zh-cn': 'yyyy"年"m"月"',
    'ja-jp': '[$-411]ge.m.d',
    'ko-kr': 'yyyy"年" mm"月" dd"日"'
  },
  28: {
    'zh-tw': '[$-404]e"年"m"月"d"日"',
    'zh-cn': 'm"月"d"日"',
    'ja-jp': '[$-411]ggge"年"m"月"d"日"',
    'ko-kr': 'mm-dd'
  },
  29: {
    'zh-tw': '[$-404]e"年"m"月"d"日"',
    'zh-cn': 'm"月"d"日"',
    'ja-jp': '[$-411]ggge"年"m"月"d"日"',
    'ko-kr': 'mm-dd'
  },
  30: {
    'zh-tw': 'm/d/yy ',
    'zh-cn': 'm-d-yy',
    'ja-jp': 'm/d/yy',
    'ko-kr': 'mm-dd-yy'
  },
  31: {
    'zh-tw': 'yyyy"年"m"月"d"日"',
    'zh-cn': 'yyyy"年"m"月"d"日"',
    'ja-jp': 'yyyy"年"m"月"d"日"',
    'ko-kr': 'yyyy"년" mm"월" dd"일"'
  },
  32: {
    'zh-tw': 'hh"時"mm"分"',
    'zh-cn': 'h"时"mm"分"',
    'ja-jp': 'h"時"mm"分"',
    'ko-kr': 'h"시" mm"분"'
  },
  33: {
    'zh-tw': 'hh"時"mm"分"ss"秒"',
    'zh-cn': 'h"时"mm"分"ss"秒"',
    'ja-jp': 'h"時"mm"分"ss"秒"',
    'ko-kr': 'h"시" mm"분" ss"초"'
  },
  34: {
    'zh-tw': '上午/下午 hh"時"mm"分"',
    'zh-cn': '上午/下午 h"时"mm"分"',
    'ja-jp': 'yyyy"年"m"月"',
    'ko-kr': 'yyyy-mm-dd'
  },
  35: {
    'zh-tw': '上午/下午 hh"時"mm"分"ss"秒"',
    'zh-cn': '上午/下午 h"时"mm"分"ss"秒"',
    'ja-jp': 'm"月"d"日"',
    'ko-kr': 'yyyy-mm-dd'
  },
  36: {
    'zh-tw': '[$-404]e/m/d',
    'zh-cn': 'yyyy"年"m"月"',
    'ja-jp': '[$-411]ge.m.d',
    'ko-kr': 'yyyy"年" mm"月" dd"日"'
  },
  37: {
    f: '#,##0 ;(#,##0)'
  },
  38: {
    f: '#,##0 ;[Red](#,##0)'
  },
  39: {
    f: '#,##0.00 ;(#,##0.00)'
  },
  40: {
    f: '#,##0.00 ;[Red](#,##0.00)'
  },
  45: {
    f: 'mm:ss'
  },
  46: {
    f: '[h]:mm:ss'
  },
  47: {
    f: 'mmss.0'
  },
  48: {
    f: '##0.0E+0'
  },
  49: {
    f: '@'
  },
  50: {
    'zh-tw': '[$-404]e/m/d',
    'zh-cn': 'yyyy"年"m"月"',
    'ja-jp': '[$-411]ge.m.d',
    'ko-kr': 'yyyy"年" mm"月" dd"日"'
  },
  51: {
    'zh-tw': '[$-404]e"年"m"月"d"日"',
    'zh-cn': 'm"月"d"日"',
    'ja-jp': '[$-411]ggge"年"m"月"d"日"',
    'ko-kr': 'mm-dd'
  },
  52: {
    'zh-tw': '上午/下午 hh"時"mm"分"',
    'zh-cn': 'yyyy"年"m"月"',
    'ja-jp': 'yyyy"年"m"月"',
    'ko-kr': 'yyyy-mm-dd'
  },
  53: {
    'zh-tw': '上午/下午 hh"時"mm"分"ss"秒"',
    'zh-cn': 'm"月"d"日"',
    'ja-jp': 'm"月"d"日"',
    'ko-kr': 'yyyy-mm-dd'
  },
  54: {
    'zh-tw': '[$-404]e"年"m"月"d"日"',
    'zh-cn': 'm"月"d"日"',
    'ja-jp': '[$-411]ggge"年"m"月"d"日"',
    'ko-kr': 'mm-dd'
  },
  55: {
    'zh-tw': '上午/下午 hh"時"mm"分"',
    'zh-cn': '上午/下午 h"时"mm"分"',
    'ja-jp': 'yyyy"年"m"月"',
    'ko-kr': 'yyyy-mm-dd'
  },
  56: {
    'zh-tw': '上午/下午 hh"時"mm"分"ss"秒"',
    'zh-cn': '上午/下午 h"时"mm"分"ss"秒"',
    'ja-jp': 'm"月"d"日"',
    'ko-kr': 'yyyy-mm-dd'
  },
  57: {
    'zh-tw': '[$-404]e/m/d',
    'zh-cn': 'yyyy"年"m"月"',
    'ja-jp': '[$-411]ge.m.d',
    'ko-kr': 'yyyy"年" mm"月" dd"日"'
  },
  58: {
    'zh-tw': '[$-404]e"年"m"月"d"日"',
    'zh-cn': 'm"月"d"日"',
    'ja-jp': '[$-411]ggge"年"m"月"d"日"',
    'ko-kr': 'mm-dd'
  },
  59: {
    'th-th': 't0'
  },
  60: {
    'th-th': 't0.00'
  },
  61: {
    'th-th': 't#,##0'
  },
  62: {
    'th-th': 't#,##0.00'
  },
  67: {
    'th-th': 't0%'
  },
  68: {
    'th-th': 't0.00%'
  },
  69: {
    'th-th': 't# ?/?'
  },
  70: {
    'th-th': 't# ??/??'
  },
  81: {
    'th-th': 'd/m/bb'
  }
};


},{}],29:[function(require,module,exports){
'use strict';

module.exports = {
  OfficeDocument: 'http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument',
  Worksheet: 'http://schemas.openxmlformats.org/officeDocument/2006/relationships/worksheet',
  CalcChain: 'http://schemas.openxmlformats.org/officeDocument/2006/relationships/calcChain',
  SharedStrings: 'http://schemas.openxmlformats.org/officeDocument/2006/relationships/sharedStrings',
  Styles: 'http://schemas.openxmlformats.org/officeDocument/2006/relationships/styles',
  Theme: 'http://schemas.openxmlformats.org/officeDocument/2006/relationships/theme',
  Hyperlink: 'http://schemas.openxmlformats.org/officeDocument/2006/relationships/hyperlink',
  Image: 'http://schemas.openxmlformats.org/officeDocument/2006/relationships/image',
  CoreProperties: 'http://schemas.openxmlformats.org/package/2006/relationships/metadata/core-properties',
  ExtenderProperties: 'http://schemas.openxmlformats.org/officeDocument/2006/relationships/extended-properties',
  Comments: 'http://schemas.openxmlformats.org/officeDocument/2006/relationships/comments',
  VmlDrawing: 'http://schemas.openxmlformats.org/officeDocument/2006/relationships/vmlDrawing',
  Table: 'http://schemas.openxmlformats.org/officeDocument/2006/relationships/table'
};


},{}],30:[function(require,module,exports){
"use strict";

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var Sax = require('sax');

var PromiseLib = require('../../utils/promise');

var XmlStream = require('../../utils/xml-stream');
/* 'virtual' methods used as a form of documentation */

/* eslint-disable class-methods-use-this */
// Base class for Xforms


var BaseXform =
/*#__PURE__*/
function () {
  function BaseXform() {
    _classCallCheck(this, BaseXform);
  }

  _createClass(BaseXform, [{
    key: "prepare",
    // constructor(/* model, name */) {}
    // ============================================================
    // Virtual Interface
    value: function prepare()
    /* model, options */
    {// optional preparation (mutation) of model so it is ready for write
    }
  }, {
    key: "render",
    value: function render()
    /* xmlStream, model */
    {// convert model to xml
    }
  }, {
    key: "parseOpen",
    value: function parseOpen()
    /* node */
    {// Sax Open Node event
    }
  }, {
    key: "parseText",
    value: function parseText()
    /* node */
    {// Sax Text event
    }
  }, {
    key: "parseClose",
    value: function parseClose()
    /* name */
    {// Sax Close Node event
    }
  }, {
    key: "reconcile",
    value: function reconcile()
    /* model, options */
    {} // optional post-parse step (opposite to prepare)
    // ============================================================

  }, {
    key: "reset",
    value: function reset() {
      // to make sure parses don't bleed to next iteration
      this.model = null; // if we have a map - reset them too

      if (this.map) {
        var keys = Object.keys(this.map);

        for (var i = 0; i < keys.length; i++) {
          this.map[keys[i]].reset();
        }
      }
    }
  }, {
    key: "mergeModel",
    value: function mergeModel(obj) {
      // set obj's props to this.model
      this.model = Object.assign(this.model || {}, obj);
    }
  }, {
    key: "parse",
    value: function parse(parser, stream) {
      var _this = this;

      return new PromiseLib.Promise(function (resolve, reject) {
        var abort = function abort(error) {
          // Abandon ship! Prevent the parser from consuming any more resources
          parser.removeAllListeners();
          parser.on('error', function () {}); // Ignore any parse errors from the chunk being processed

          stream.unpipe(parser);
          reject(error);
        };

        parser.on('opentag', function (node) {
          try {
            _this.parseOpen(node);
          } catch (error) {
            abort(error);
          }
        });
        parser.on('text', function (text) {
          try {
            _this.parseText(text);
          } catch (error) {
            abort(error);
          }
        });
        parser.on('closetag', function (name) {
          try {
            if (!_this.parseClose(name)) {
              resolve(_this.model);
            }
          } catch (error) {
            abort(error);
          }
        });
        parser.on('end', function () {
          resolve(_this.model);
        });
        parser.on('error', function (error) {
          abort(error);
        });
      });
    }
  }, {
    key: "parseStream",
    value: function parseStream(stream) {
      var parser = Sax.createStream(true, {});
      var promise = this.parse(parser, stream);
      stream.pipe(parser);
      return promise;
    }
  }, {
    key: "toXml",
    value: function toXml(model) {
      var xmlStream = new XmlStream();
      this.render(xmlStream, model);
      return xmlStream.xml;
    }
  }, {
    key: "xml",
    get: function get() {
      // convenience function to get the xml of this.model
      // useful for manager types that are built during the prepare phase
      return this.toXml(this.model);
    }
  }]);

  return BaseXform;
}();

module.exports = BaseXform;


},{"../../utils/promise":20,"../../utils/xml-stream":26,"sax":332}],31:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var BaseXform = require('../base-xform');

var colCache = require('../../../utils/col-cache');

var DefinedNamesXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(DefinedNamesXform, _BaseXform);

  function DefinedNamesXform() {
    _classCallCheck(this, DefinedNamesXform);

    return _possibleConstructorReturn(this, _getPrototypeOf(DefinedNamesXform).apply(this, arguments));
  }

  _createClass(DefinedNamesXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      // <definedNames>
      //   <definedName name="name">name.ranges.join(',')</definedName>
      //   <definedName name="_xlnm.Print_Area" localSheetId="0">name.ranges.join(',')</definedName>
      // </definedNames>
      xmlStream.openNode('definedName', {
        name: model.name,
        localSheetId: model.localSheetId
      });
      xmlStream.writeText(model.ranges.join(','));
      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      switch (node.name) {
        case 'definedName':
          this._parsedName = node.attributes.name;
          this._parsedLocalSheetId = node.attributes.localSheetId;
          this._parsedText = [];
          return true;

        default:
          return false;
      }
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      this._parsedText.push(text);
    }
  }, {
    key: "parseClose",
    value: function parseClose() {
      this.model = {
        name: this._parsedName,
        ranges: extractRanges(this._parsedText.join(''))
      };

      if (this._parsedLocalSheetId !== undefined) {
        this.model.localSheetId = parseInt(this._parsedLocalSheetId, 10);
      }

      return false;
    }
  }]);

  return DefinedNamesXform;
}(BaseXform);

function isValidRange(range) {
  try {
    colCache.decodeEx(range);
    return true;
  } catch (err) {
    return false;
  }
}

function extractRanges(parsedText) {
  var ranges = [];
  var quotesOpened = false;
  var last = '';
  parsedText.split(',').forEach(function (item) {
    if (!item) {
      return;
    }

    var quotes = (item.match(/'/g) || []).length;

    if (!quotes) {
      if (quotesOpened) {
        last += "".concat(item, ",");
      } else if (isValidRange(item)) {
        ranges.push(item);
      }

      return;
    }

    var quotesEven = quotes % 2 === 0;

    if (!quotesOpened && quotesEven && isValidRange(item)) {
      ranges.push(item);
    } else if (quotesOpened && !quotesEven) {
      quotesOpened = false;

      if (isValidRange(last + item)) {
        ranges.push(last + item);
      }

      last = '';
    } else {
      quotesOpened = true;
      last += "".concat(item, ",");
    }
  });
  return ranges;
}

module.exports = DefinedNamesXform;


},{"../../../utils/col-cache":18,"../base-xform":30}],32:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var utils = require('../../../utils/utils');

var BaseXform = require('../base-xform');

var WorksheetXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(WorksheetXform, _BaseXform);

  function WorksheetXform() {
    _classCallCheck(this, WorksheetXform);

    return _possibleConstructorReturn(this, _getPrototypeOf(WorksheetXform).apply(this, arguments));
  }

  _createClass(WorksheetXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.leafNode('sheet', {
        sheetId: model.id,
        name: model.name,
        state: model.state,
        'r:id': model.rId
      });
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (node.name === 'sheet') {
        this.model = {
          name: utils.xmlDecode(node.attributes.name),
          id: parseInt(node.attributes.sheetId, 10),
          state: node.attributes.state,
          rId: node.attributes['r:id']
        };
        return true;
      }

      return false;
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose() {
      return false;
    }
  }]);

  return WorksheetXform;
}(BaseXform);

module.exports = WorksheetXform;


},{"../../../utils/utils":25,"../base-xform":30}],33:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var BaseXform = require('../base-xform');

var WorksheetPropertiesXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(WorksheetPropertiesXform, _BaseXform);

  function WorksheetPropertiesXform() {
    _classCallCheck(this, WorksheetPropertiesXform);

    return _possibleConstructorReturn(this, _getPrototypeOf(WorksheetPropertiesXform).apply(this, arguments));
  }

  _createClass(WorksheetPropertiesXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.leafNode('workbookPr', {
        date1904: model.date1904 ? 1 : undefined,
        defaultThemeVersion: 164011,
        filterPrivacy: 1
      });
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (node.name === 'workbookPr') {
        this.model = {
          date1904: node.attributes.date1904 === '1'
        };
        return true;
      }

      return false;
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose() {
      return false;
    }
  }]);

  return WorksheetPropertiesXform;
}(BaseXform);

module.exports = WorksheetPropertiesXform;


},{"../base-xform":30}],34:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var BaseXform = require('../base-xform');

var WorkbookViewXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(WorkbookViewXform, _BaseXform);

  function WorkbookViewXform() {
    _classCallCheck(this, WorkbookViewXform);

    return _possibleConstructorReturn(this, _getPrototypeOf(WorkbookViewXform).apply(this, arguments));
  }

  _createClass(WorkbookViewXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      var attributes = {
        xWindow: model.x || 0,
        yWindow: model.y || 0,
        windowWidth: model.width || 12000,
        windowHeight: model.height || 24000,
        firstSheet: model.firstSheet,
        activeTab: model.activeTab
      };

      if (model.visibility && model.visibility !== 'visible') {
        attributes.visibility = model.visibility;
      }

      xmlStream.leafNode('workbookView', attributes);
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (node.name === 'workbookView') {
        var model = this.model = {};

        var addS = function addS(name, value, dflt) {
          var s = value !== undefined ? model[name] = value : dflt;

          if (s !== undefined) {
            model[name] = s;
          }
        };

        var addN = function addN(name, value, dflt) {
          var n = value !== undefined ? model[name] = parseInt(value, 10) : dflt;

          if (n !== undefined) {
            model[name] = n;
          }
        };

        addN('x', node.attributes.xWindow, 0);
        addN('y', node.attributes.yWindow, 0);
        addN('width', node.attributes.windowWidth, 25000);
        addN('height', node.attributes.windowHeight, 10000);
        addS('visibility', node.attributes.visibility, 'visible');
        addN('activeTab', node.attributes.activeTab, undefined);
        addN('firstSheet', node.attributes.firstSheet, undefined);
        return true;
      }

      return false;
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose() {
      return false;
    }
  }]);

  return WorkbookViewXform;
}(BaseXform);

module.exports = WorkbookViewXform;


},{"../base-xform":30}],35:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var _ = require('../../../utils/under-dash');

var colCache = require('../../../utils/col-cache');

var XmlStream = require('../../../utils/xml-stream');

var BaseXform = require('../base-xform');

var StaticXform = require('../static-xform');

var ListXform = require('../list-xform');

var DefinedNameXform = require('./defined-name-xform');

var SheetXform = require('./sheet-xform');

var WorkbookViewXform = require('./workbook-view-xform');

var WorkbookPropertiesXform = require('./workbook-properties-xform');

var WorkbookXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(WorkbookXform, _BaseXform);

  function WorkbookXform() {
    var _this;

    _classCallCheck(this, WorkbookXform);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(WorkbookXform).call(this));
    _this.map = {
      fileVersion: WorkbookXform.STATIC_XFORMS.fileVersion,
      workbookPr: new WorkbookPropertiesXform(),
      bookViews: new ListXform({
        tag: 'bookViews',
        count: false,
        childXform: new WorkbookViewXform()
      }),
      sheets: new ListXform({
        tag: 'sheets',
        count: false,
        childXform: new SheetXform()
      }),
      definedNames: new ListXform({
        tag: 'definedNames',
        count: false,
        childXform: new DefinedNameXform()
      }),
      calcPr: WorkbookXform.STATIC_XFORMS.calcPr
    };
    return _this;
  }

  _createClass(WorkbookXform, [{
    key: "prepare",
    value: function prepare(model) {
      model.sheets = model.worksheets; // collate all the print areas from all of the sheets and add them to the defined names

      var printAreas = [];
      var index = 0; // sheets is sparse array - calc index manually

      model.sheets.forEach(function (sheet) {
        if (sheet.pageSetup && sheet.pageSetup.printArea) {
          var printArea = sheet.pageSetup.printArea.split(':');
          var definedName = {
            name: '_xlnm.Print_Area',
            ranges: ["'".concat(sheet.name, "'!$").concat(printArea[0], ":$").concat(printArea[1])],
            localSheetId: index
          };
          printAreas.push(definedName);
        }

        if (sheet.pageSetup && (sheet.pageSetup.printTitlesRow || sheet.pageSetup.printTitlesColumn)) {
          var ranges = [];

          if (sheet.pageSetup.printTitlesColumn) {
            var titlesColumns = sheet.pageSetup.printTitlesColumn.split(':');
            ranges.push("'".concat(sheet.name, "'!$").concat(titlesColumns[0], ":$").concat(titlesColumns[1]));
          }

          if (sheet.pageSetup.printTitlesRow) {
            var titlesRows = sheet.pageSetup.printTitlesRow.split(':');
            ranges.push("'".concat(sheet.name, "'!$").concat(titlesRows[0], ":$").concat(titlesRows[1]));
          }

          var _definedName = {
            name: '_xlnm.Print_Titles',
            ranges: ranges,
            localSheetId: index
          };
          printAreas.push(_definedName);
        }

        index++;
      });

      if (printAreas.length) {
        model.definedNames = model.definedNames.concat(printAreas);
      }

      (model.media || []).forEach(function (medium, i) {
        // assign name
        medium.name = medium.type + (i + 1);
      });
    }
  }, {
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.openXml(XmlStream.StdDocAttributes);
      xmlStream.openNode('workbook', WorkbookXform.WORKBOOK_ATTRIBUTES);
      this.map.fileVersion.render(xmlStream);
      this.map.workbookPr.render(xmlStream, model.properties);
      this.map.bookViews.render(xmlStream, model.views);
      this.map.sheets.render(xmlStream, model.sheets);
      this.map.definedNames.render(xmlStream, model.definedNames);
      this.map.calcPr.render(xmlStream);
      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      switch (node.name) {
        case 'workbook':
          return true;

        default:
          this.parser = this.map[node.name];

          if (this.parser) {
            this.parser.parseOpen(node);
          }

          return true;
      }
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      if (this.parser) {
        this.parser.parseText(text);
      }
    }
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      if (this.parser) {
        if (!this.parser.parseClose(name)) {
          this.parser = undefined;
        }

        return true;
      }

      switch (name) {
        case 'workbook':
          this.model = {
            sheets: this.map.sheets.model,
            properties: this.map.workbookPr.model || {},
            views: this.map.bookViews.model
          };

          if (this.map.definedNames.model) {
            this.model.definedNames = this.map.definedNames.model;
          }

          return false;

        default:
          // not quite sure how we get here!
          return true;
      }
    }
  }, {
    key: "reconcile",
    value: function reconcile(model) {
      var rels = (model.workbookRels || []).reduce(function (map, rel) {
        map[rel.Id] = rel;
        return map;
      }, {}); // reconcile sheet ids, rIds and names

      var worksheets = [];
      var worksheet;
      var index = 0;
      (model.sheets || []).forEach(function (sheet) {
        var rel = rels[sheet.rId];

        if (!rel) {
          return;
        }

        worksheet = model.worksheetHash["xl/".concat(rel.Target)]; // If there are "chartsheets" in the file, rel.Target will
        // come out as chartsheets/sheet1.xml or similar here, and
        // that won't be in model.worksheetHash.
        // As we don't have the infrastructure to support chartsheets,
        // we will ignore them for now:

        if (worksheet) {
          worksheet.name = sheet.name;
          worksheet.id = sheet.id;
          worksheet.state = sheet.state;
          worksheets[index++] = worksheet;
        }
      }); // reconcile print areas

      var definedNames = [];

      _.each(model.definedNames, function (definedName) {
        if (definedName.name === '_xlnm.Print_Area') {
          worksheet = worksheets[definedName.localSheetId];

          if (worksheet) {
            if (!worksheet.pageSetup) {
              worksheet.pageSetup = {};
            }

            var range = colCache.decodeEx(definedName.ranges[0]);
            worksheet.pageSetup.printArea = range.dimensions;
          }
        } else if (definedName.name === '_xlnm.Print_Titles') {
          worksheet = worksheets[definedName.localSheetId];

          if (worksheet) {
            if (!worksheet.pageSetup) {
              worksheet.pageSetup = {};
            }

            var rangeString = definedName.ranges.join(',');
            var dollarRegex = /\$/g;
            var rowRangeRegex = /\$\d+:\$\d+/;
            var rowRangeMatches = rangeString.match(rowRangeRegex);

            if (rowRangeMatches && rowRangeMatches.length) {
              var _range = rowRangeMatches[0];
              worksheet.pageSetup.printTitlesRow = _range.replace(dollarRegex, '');
            }

            var columnRangeRegex = /\$[A-Z]+:\$[A-Z]+/;
            var columnRangeMatches = rangeString.match(columnRangeRegex);

            if (columnRangeMatches && columnRangeMatches.length) {
              var _range2 = columnRangeMatches[0];
              worksheet.pageSetup.printTitlesColumn = _range2.replace(dollarRegex, '');
            }
          }
        } else {
          definedNames.push(definedName);
        }
      });

      model.definedNames = definedNames; // used by sheets to build their image models

      model.media.forEach(function (media, i) {
        media.index = i;
      });
    }
  }]);

  return WorkbookXform;
}(BaseXform);

WorkbookXform.WORKBOOK_ATTRIBUTES = {
  xmlns: 'http://schemas.openxmlformats.org/spreadsheetml/2006/main',
  'xmlns:r': 'http://schemas.openxmlformats.org/officeDocument/2006/relationships',
  'xmlns:mc': 'http://schemas.openxmlformats.org/markup-compatibility/2006',
  'mc:Ignorable': 'x15',
  'xmlns:x15': 'http://schemas.microsoft.com/office/spreadsheetml/2010/11/main'
};
WorkbookXform.STATIC_XFORMS = {
  fileVersion: new StaticXform({
    tag: 'fileVersion',
    $: {
      appName: 'xl',
      lastEdited: 5,
      lowestEdited: 5,
      rupBuild: 9303
    }
  }),
  calcPr: new StaticXform({
    tag: 'calcPr',
    $: {
      calcId: 171027
    }
  })
};
module.exports = WorkbookXform;


},{"../../../utils/col-cache":18,"../../../utils/under-dash":24,"../../../utils/xml-stream":26,"../base-xform":30,"../list-xform":59,"../static-xform":89,"./defined-name-xform":31,"./sheet-xform":32,"./workbook-properties-xform":33,"./workbook-view-xform":34}],36:[function(require,module,exports){
"use strict";

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var RichTextXform = require('../strings/rich-text-xform');

var utils = require('../../../utils/utils');

var BaseXform = require('../base-xform');
/**
  <comment ref="B1" authorId="0">
    <text>
      <r>
        <rPr>
          <b/>
          <sz val="9"/>
          <rFont val="宋体"/>
          <charset val="134"/>
        </rPr>
        <t>51422:</t>
      </r>
      <r>
        <rPr>
          <sz val="9"/>
          <rFont val="宋体"/>
          <charset val="134"/>
        </rPr>
        <t xml:space="preserve">&#10;test</t>
      </r>
    </text>
  </comment>
 */


var CommentXform = module.exports = function (model) {
  this.model = model;
};

utils.inherits(CommentXform, BaseXform, {
  get tag() {
    return 'r';
  },

  get richTextXform() {
    if (!this._richTextXform) {
      this._richTextXform = new RichTextXform();
    }

    return this._richTextXform;
  },

  render: function render(xmlStream, model) {
    var _this = this;

    model = model || this.model;
    xmlStream.openNode('comment', {
      ref: model.ref,
      authorId: 0
    });
    xmlStream.openNode('text');

    if (model && model.note && model.note.texts) {
      model.note.texts.forEach(function (text) {
        _this.richTextXform.render(xmlStream, text);
      });
    }

    xmlStream.closeNode();
    xmlStream.closeNode();
  },
  parseOpen: function parseOpen(node) {
    if (this.parser) {
      this.parser.parseOpen(node);
      return true;
    }

    switch (node.name) {
      case 'comment':
        this.model = _objectSpread({
          texts: []
        }, node.attributes);
        return true;

      case 'r':
        this.parser = this.richTextXform;
        this.parser.parseOpen(node);
        return true;

      default:
        return false;
    }
  },
  parseText: function parseText(text) {
    if (this.parser) {
      this.parser.parseText(text);
    }
  },
  parseClose: function parseClose(name) {
    switch (name) {
      case 'comment':
        return false;

      case 'r':
        this.model.texts.push(this.parser.model);
        this.parser = undefined;
        return true;

      default:
        if (this.parser) {
          this.parser.parseClose(name);
        }

        return true;
    }
  }
});


},{"../../../utils/utils":25,"../base-xform":30,"../strings/rich-text-xform":91}],37:[function(require,module,exports){
"use strict";

var XmlStream = require('../../../utils/xml-stream');

var utils = require('../../../utils/utils');

var BaseXform = require('../base-xform');

var CommentXform = require('./comment-xform');

var CommentsXform = module.exports = function () {
  this.map = {
    comment: new CommentXform()
  };
};

utils.inherits(CommentsXform, BaseXform, {
  COMMENTS_ATTRIBUTES: {
    xmlns: 'http://schemas.openxmlformats.org/spreadsheetml/2006/main'
  }
}, {
  render: function render(xmlStream, model) {
    var _this = this;

    model = model || this.model;
    xmlStream.openXml(XmlStream.StdDocAttributes);
    xmlStream.openNode('comments', CommentsXform.COMMENTS_ATTRIBUTES); // authors
    // TODO: support authors properly

    xmlStream.openNode('authors');
    xmlStream.leafNode('author', null, 'Author');
    xmlStream.closeNode(); // comments

    xmlStream.openNode('commentList');
    model.comments.forEach(function (comment) {
      _this.map.comment.render(xmlStream, comment);
    });
    xmlStream.closeNode();
    xmlStream.closeNode();
  },
  parseOpen: function parseOpen(node) {
    if (this.parser) {
      this.parser.parseOpen(node);
      return true;
    }

    switch (node.name) {
      case 'commentList':
        this.model = {
          comments: []
        };
        return true;

      case 'comment':
        this.parser = this.map.comment;
        this.parser.parseOpen(node);
        return true;

      default:
        return false;
    }
  },
  parseText: function parseText(text) {
    if (this.parser) {
      this.parser.parseText(text);
    }
  },
  parseClose: function parseClose(name) {
    switch (name) {
      case 'commentList':
        return false;

      case 'comment':
        this.model.comments.push(this.parser.model);
        this.parser = undefined;
        return true;

      default:
        if (this.parser) {
          this.parser.parseClose(name);
        }

        return true;
    }
  }
});


},{"../../../utils/utils":25,"../../../utils/xml-stream":26,"../base-xform":30,"./comment-xform":36}],38:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var BaseXform = require('../base-xform'); // render the triangle in the cell for the comment


var VmlAnchorXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(VmlAnchorXform, _BaseXform);

  function VmlAnchorXform() {
    _classCallCheck(this, VmlAnchorXform);

    return _possibleConstructorReturn(this, _getPrototypeOf(VmlAnchorXform).apply(this, arguments));
  }

  _createClass(VmlAnchorXform, [{
    key: "getAnchorRect",
    value: function getAnchorRect(anchor) {
      var l = Math.floor(anchor.left);
      var lf = Math.floor((anchor.left - l) * 68);
      var t = Math.floor(anchor.top);
      var tf = Math.floor((anchor.top - t) * 18);
      var r = Math.floor(anchor.right);
      var rf = Math.floor((anchor.right - r) * 68);
      var b = Math.floor(anchor.bottom);
      var bf = Math.floor((anchor.bottom - b) * 18);
      return [l, lf, t, tf, r, rf, b, bf];
    }
  }, {
    key: "getDefaultRect",
    value: function getDefaultRect(ref) {
      var l = ref.col;
      var lf = 6;
      var t = Math.max(ref.row - 2, 0);
      var tf = 14;
      var r = l + 2;
      var rf = 2;
      var b = t + 4;
      var bf = 16;
      return [l, lf, t, tf, r, rf, b, bf];
    }
  }, {
    key: "render",
    value: function render(xmlStream, model) {
      var rect = model.anchor ? this.getAnchorRect(model.anchor) : this.getDefaultRect(model.refAddress);
      xmlStream.leafNode('x:Anchor', null, rect.join(', '));
    }
  }, {
    key: "tag",
    get: function get() {
      return 'x:Anchor';
    }
  }]);

  return VmlAnchorXform;
}(BaseXform);

module.exports = VmlAnchorXform;


},{"../base-xform":30}],39:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var BaseXform = require('../base-xform');

var VmlAnchorXform = require('./vml-anchor-xform'); // render the triangle in the cell for the comment


var VmlNoteXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(VmlNoteXform, _BaseXform);

  function VmlNoteXform() {
    _classCallCheck(this, VmlNoteXform);

    return _possibleConstructorReturn(this, _getPrototypeOf(VmlNoteXform).apply(this, arguments));
  }

  _createClass(VmlNoteXform, [{
    key: "render",
    value: function render(xmlStream, model, index) {
      xmlStream.openNode('v:shape', VmlNoteXform.V_SHAPE_ATTRIBUTES(index));
      xmlStream.leafNode('v:fill', {
        color2: 'infoBackground [80]'
      });
      xmlStream.leafNode('v:shadow', {
        color: 'none [81]',
        obscured: 't'
      });
      xmlStream.leafNode('v:path', {
        'o:connecttype': 'none'
      });
      xmlStream.openNode('v:textbox', {
        style: 'mso-direction-alt:auto'
      });
      xmlStream.leafNode('div', {
        style: 'text-align:left'
      });
      xmlStream.closeNode();
      xmlStream.openNode('x:ClientData', {
        ObjectType: 'Note'
      });
      xmlStream.leafNode('x:MoveWithCells');
      xmlStream.leafNode('x:SizeWithCells');
      VmlNoteXform.vmlAnchorXform.render(xmlStream, model);
      xmlStream.leafNode('x:AutoFill', null, 'False');
      xmlStream.leafNode('x:Row', null, model.refAddress.row - 1);
      xmlStream.leafNode('x:Column', null, model.refAddress.col - 1);
      xmlStream.closeNode();
      xmlStream.closeNode();
    }
  }, {
    key: "tag",
    get: function get() {
      return 'v:shape';
    }
  }]);

  return VmlNoteXform;
}(BaseXform);

module.exports = VmlNoteXform;

VmlNoteXform.V_SHAPE_ATTRIBUTES = function (index) {
  return {
    id: "_x0000_s".concat(1025 + index),
    type: '#_x0000_t202',
    style: 'position:absolute; margin-left:105.3pt;margin-top:10.5pt;width:97.8pt;height:59.1pt;z-index:1;visibility:hidden',
    fillcolor: 'infoBackground [80]',
    strokecolor: 'none [81]',
    'o:insetmode': 'auto'
  };
};

VmlNoteXform.vmlAnchorXform = new VmlAnchorXform();


},{"../base-xform":30,"./vml-anchor-xform":38}],40:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var XmlStream = require('../../../utils/xml-stream');

var BaseXform = require('../base-xform');

var VmlNoteXform = require('./vml-note-xform'); // This class is (currently) single purposed to insert the triangle
// drawing icons on commented cells


var VmlNotesXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(VmlNotesXform, _BaseXform);

  function VmlNotesXform() {
    _classCallCheck(this, VmlNotesXform);

    return _possibleConstructorReturn(this, _getPrototypeOf(VmlNotesXform).apply(this, arguments));
  }

  _createClass(VmlNotesXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.openXml(XmlStream.StdDocAttributes);
      xmlStream.openNode(this.tag, VmlNotesXform.DRAWING_ATTRIBUTES);
      xmlStream.openNode('o:shapelayout', {
        'v:ext': 'edit'
      });
      xmlStream.leafNode('o:idmap', {
        'v:ext': 'edit',
        data: 1
      });
      xmlStream.closeNode();
      xmlStream.openNode('v:shapetype', {
        id: '_x0000_t202',
        coordsize: '21600,21600',
        'o:spt': 202,
        path: 'm,l,21600r21600,l21600,xe'
      });
      xmlStream.leafNode('v:stroke', {
        joinstyle: 'miter'
      });
      xmlStream.leafNode('v:path', {
        gradientshapeok: 't',
        'o:connecttype': 'rect'
      });
      xmlStream.closeNode();
      model.comments.forEach(function (item, index) {
        VmlNotesXform.vmlCommentXform.render(xmlStream, item, index);
      });
      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      switch (node.name) {
        case this.tag:
          this.reset();
          this.model = {
            anchors: []
          };
          break;

        default:
          this.parser = this.map[node.name];

          if (this.parser) {
            this.parser.parseOpen(node);
          }

          break;
      }

      return true;
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      if (this.parser) {
        this.parser.parseText(text);
      }
    }
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      if (this.parser) {
        if (!this.parser.parseClose(name)) {
          this.model.anchors.push(this.parser.model);
          this.parser = undefined;
        }

        return true;
      }

      switch (name) {
        case this.tag:
          return false;

        default:
          // could be some unrecognised tags
          return true;
      }
    }
  }, {
    key: "reconcile",
    value: function reconcile(model, options) {
      var _this = this;

      model.anchors.forEach(function (anchor) {
        if (anchor.br) {
          _this.map['xdr:twoCellAnchor'].reconcile(anchor, options);
        } else {
          _this.map['xdr:oneCellAnchor'].reconcile(anchor, options);
        }
      });
    }
  }, {
    key: "tag",
    get: function get() {
      return 'xml';
    }
  }]);

  return VmlNotesXform;
}(BaseXform);

VmlNotesXform.DRAWING_ATTRIBUTES = {
  'xmlns:v': 'urn:schemas-microsoft-com:vml',
  'xmlns:o': 'urn:schemas-microsoft-com:office:office',
  'xmlns:x': 'urn:schemas-microsoft-com:office:excel'
};
VmlNotesXform.vmlCommentXform = new VmlNoteXform();
module.exports = VmlNotesXform;


},{"../../../utils/xml-stream":26,"../base-xform":30,"./vml-note-xform":39}],41:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var BaseXform = require('../base-xform');

var AppHeadingPairsXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(AppHeadingPairsXform, _BaseXform);

  function AppHeadingPairsXform() {
    _classCallCheck(this, AppHeadingPairsXform);

    return _possibleConstructorReturn(this, _getPrototypeOf(AppHeadingPairsXform).apply(this, arguments));
  }

  _createClass(AppHeadingPairsXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.openNode('HeadingPairs');
      xmlStream.openNode('vt:vector', {
        size: 2,
        baseType: 'variant'
      });
      xmlStream.openNode('vt:variant');
      xmlStream.leafNode('vt:lpstr', undefined, 'Worksheets');
      xmlStream.closeNode();
      xmlStream.openNode('vt:variant');
      xmlStream.leafNode('vt:i4', undefined, model.length);
      xmlStream.closeNode();
      xmlStream.closeNode();
      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      // no parsing
      return node.name === 'HeadingPairs';
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      return name !== 'HeadingPairs';
    }
  }]);

  return AppHeadingPairsXform;
}(BaseXform);

module.exports = AppHeadingPairsXform;


},{"../base-xform":30}],42:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var BaseXform = require('../base-xform');

var AppTitlesOfPartsXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(AppTitlesOfPartsXform, _BaseXform);

  function AppTitlesOfPartsXform() {
    _classCallCheck(this, AppTitlesOfPartsXform);

    return _possibleConstructorReturn(this, _getPrototypeOf(AppTitlesOfPartsXform).apply(this, arguments));
  }

  _createClass(AppTitlesOfPartsXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.openNode('TitlesOfParts');
      xmlStream.openNode('vt:vector', {
        size: model.length,
        baseType: 'lpstr'
      });
      model.forEach(function (sheet) {
        xmlStream.leafNode('vt:lpstr', undefined, sheet.name);
      });
      xmlStream.closeNode();
      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      // no parsing
      return node.name === 'TitlesOfParts';
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      return name !== 'TitlesOfParts';
    }
  }]);

  return AppTitlesOfPartsXform;
}(BaseXform);

module.exports = AppTitlesOfPartsXform;


},{"../base-xform":30}],43:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var XmlStream = require('../../../utils/xml-stream');

var BaseXform = require('../base-xform');

var StringXform = require('../simple/string-xform');

var AppHeadingPairsXform = require('./app-heading-pairs-xform');

var AppTitleOfPartsXform = require('./app-titles-of-parts-xform');

var AppXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(AppXform, _BaseXform);

  function AppXform() {
    var _this;

    _classCallCheck(this, AppXform);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(AppXform).call(this));
    _this.map = {
      Company: new StringXform({
        tag: 'Company'
      }),
      Manager: new StringXform({
        tag: 'Manager'
      }),
      HeadingPairs: new AppHeadingPairsXform(),
      TitleOfParts: new AppTitleOfPartsXform()
    };
    return _this;
  }

  _createClass(AppXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.openXml(XmlStream.StdDocAttributes);
      xmlStream.openNode('Properties', AppXform.PROPERTY_ATTRIBUTES);
      xmlStream.leafNode('Application', undefined, 'Microsoft Excel');
      xmlStream.leafNode('DocSecurity', undefined, '0');
      xmlStream.leafNode('ScaleCrop', undefined, 'false');
      this.map.HeadingPairs.render(xmlStream, model.worksheets);
      this.map.TitleOfParts.render(xmlStream, model.worksheets);
      this.map.Company.render(xmlStream, model.company || '');
      this.map.Manager.render(xmlStream, model.manager);
      xmlStream.leafNode('LinksUpToDate', undefined, 'false');
      xmlStream.leafNode('SharedDoc', undefined, 'false');
      xmlStream.leafNode('HyperlinksChanged', undefined, 'false');
      xmlStream.leafNode('AppVersion', undefined, '16.0300');
      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      switch (node.name) {
        case 'Properties':
          return true;

        default:
          this.parser = this.map[node.name];

          if (this.parser) {
            this.parser.parseOpen(node);
            return true;
          } // there's a lot we don't bother to parse


          return false;
      }
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      if (this.parser) {
        this.parser.parseText(text);
      }
    }
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      if (this.parser) {
        if (!this.parser.parseClose(name)) {
          this.parser = undefined;
        }

        return true;
      }

      switch (name) {
        case 'Properties':
          this.model = {
            worksheets: this.map.TitleOfParts.model,
            company: this.map.Company.model,
            manager: this.map.Manager.model
          };
          return false;

        default:
          return true;
      }
    }
  }]);

  return AppXform;
}(BaseXform);

AppXform.DateFormat = function (dt) {
  return dt.toISOString().replace(/[.]\d{3,6}/, '');
};

AppXform.DateAttrs = {
  'xsi:type': 'dcterms:W3CDTF'
};
AppXform.PROPERTY_ATTRIBUTES = {
  xmlns: 'http://schemas.openxmlformats.org/officeDocument/2006/extended-properties',
  'xmlns:vt': 'http://schemas.openxmlformats.org/officeDocument/2006/docPropsVTypes'
};
module.exports = AppXform;


},{"../../../utils/xml-stream":26,"../base-xform":30,"../simple/string-xform":88,"./app-heading-pairs-xform":41,"./app-titles-of-parts-xform":42}],44:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var XmlStream = require('../../../utils/xml-stream');

var BaseXform = require('../base-xform'); // used for rendering the [Content_Types].xml file
// not used for parsing


var ContentTypesXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(ContentTypesXform, _BaseXform);

  function ContentTypesXform() {
    _classCallCheck(this, ContentTypesXform);

    return _possibleConstructorReturn(this, _getPrototypeOf(ContentTypesXform).apply(this, arguments));
  }

  _createClass(ContentTypesXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.openXml(XmlStream.StdDocAttributes);
      xmlStream.openNode('Types', ContentTypesXform.PROPERTY_ATTRIBUTES);
      var mediaHash = {};
      (model.media || []).forEach(function (medium) {
        if (medium.type === 'image') {
          var imageType = medium.extension;

          if (!mediaHash[imageType]) {
            mediaHash[imageType] = true;
            xmlStream.leafNode('Default', {
              Extension: imageType,
              ContentType: "image/".concat(imageType)
            });
          }
        }
      });
      xmlStream.leafNode('Default', {
        Extension: 'rels',
        ContentType: 'application/vnd.openxmlformats-package.relationships+xml'
      });
      xmlStream.leafNode('Default', {
        Extension: 'xml',
        ContentType: 'application/xml'
      });
      xmlStream.leafNode('Override', {
        PartName: '/xl/workbook.xml',
        ContentType: 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml'
      });
      model.worksheets.forEach(function (worksheet) {
        var name = "/xl/worksheets/sheet".concat(worksheet.id, ".xml");
        xmlStream.leafNode('Override', {
          PartName: name,
          ContentType: 'application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml'
        });
      });
      xmlStream.leafNode('Override', {
        PartName: '/xl/theme/theme1.xml',
        ContentType: 'application/vnd.openxmlformats-officedocument.theme+xml'
      });
      xmlStream.leafNode('Override', {
        PartName: '/xl/styles.xml',
        ContentType: 'application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml'
      });
      var hasSharedStrings = model.sharedStrings && model.sharedStrings.count;

      if (hasSharedStrings) {
        xmlStream.leafNode('Override', {
          PartName: '/xl/sharedStrings.xml',
          ContentType: 'application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml'
        });
      }

      if (model.tables) {
        model.tables.forEach(function (table) {
          xmlStream.leafNode('Override', {
            PartName: "/xl/tables/".concat(table.target),
            ContentType: 'application/vnd.openxmlformats-officedocument.spreadsheetml.table+xml'
          });
        });
      }

      if (model.drawings) {
        model.drawings.forEach(function (drawing) {
          xmlStream.leafNode('Override', {
            PartName: "/xl/drawings/".concat(drawing.name, ".xml"),
            ContentType: 'application/vnd.openxmlformats-officedocument.drawing+xml'
          });
        });
      }

      if (model.commentRefs) {
        xmlStream.leafNode('Default', {
          Extension: 'vml',
          ContentType: 'application/vnd.openxmlformats-officedocument.vmlDrawing'
        });
        model.commentRefs.forEach(function (_ref) {
          var commentName = _ref.commentName;
          xmlStream.leafNode('Override', {
            PartName: "/xl/".concat(commentName, ".xml"),
            ContentType: 'application/vnd.openxmlformats-officedocument.spreadsheetml.comments+xml'
          });
        });
      }

      xmlStream.leafNode('Override', {
        PartName: '/docProps/core.xml',
        ContentType: 'application/vnd.openxmlformats-package.core-properties+xml'
      });
      xmlStream.leafNode('Override', {
        PartName: '/docProps/app.xml',
        ContentType: 'application/vnd.openxmlformats-officedocument.extended-properties+xml'
      });
      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen() {
      return false;
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose() {
      return false;
    }
  }]);

  return ContentTypesXform;
}(BaseXform);

ContentTypesXform.PROPERTY_ATTRIBUTES = {
  xmlns: 'http://schemas.openxmlformats.org/package/2006/content-types'
};
module.exports = ContentTypesXform;


},{"../../../utils/xml-stream":26,"../base-xform":30}],45:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var XmlStream = require('../../../utils/xml-stream');

var BaseXform = require('../base-xform');

var DateXform = require('../simple/date-xform');

var StringXform = require('../simple/string-xform');

var IntegerXform = require('../simple/integer-xform');

var CoreXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(CoreXform, _BaseXform);

  function CoreXform() {
    var _this;

    _classCallCheck(this, CoreXform);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(CoreXform).call(this));
    _this.map = {
      'dc:creator': new StringXform({
        tag: 'dc:creator'
      }),
      'dc:title': new StringXform({
        tag: 'dc:title'
      }),
      'dc:subject': new StringXform({
        tag: 'dc:subject'
      }),
      'dc:description': new StringXform({
        tag: 'dc:description'
      }),
      'dc:identifier': new StringXform({
        tag: 'dc:identifier'
      }),
      'dc:language': new StringXform({
        tag: 'dc:language'
      }),
      'cp:keywords': new StringXform({
        tag: 'cp:keywords'
      }),
      'cp:category': new StringXform({
        tag: 'cp:category'
      }),
      'cp:lastModifiedBy': new StringXform({
        tag: 'cp:lastModifiedBy'
      }),
      'cp:lastPrinted': new DateXform({
        tag: 'cp:lastPrinted',
        format: CoreXform.DateFormat
      }),
      'cp:revision': new IntegerXform({
        tag: 'cp:revision'
      }),
      'cp:version': new StringXform({
        tag: 'cp:version'
      }),
      'cp:contentStatus': new StringXform({
        tag: 'cp:contentStatus'
      }),
      'cp:contentType': new StringXform({
        tag: 'cp:contentType'
      }),
      'dcterms:created': new DateXform({
        tag: 'dcterms:created',
        attrs: CoreXform.DateAttrs,
        format: CoreXform.DateFormat
      }),
      'dcterms:modified': new DateXform({
        tag: 'dcterms:modified',
        attrs: CoreXform.DateAttrs,
        format: CoreXform.DateFormat
      })
    };
    return _this;
  }

  _createClass(CoreXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.openXml(XmlStream.StdDocAttributes);
      xmlStream.openNode('cp:coreProperties', CoreXform.CORE_PROPERTY_ATTRIBUTES);
      this.map['dc:creator'].render(xmlStream, model.creator);
      this.map['dc:title'].render(xmlStream, model.title);
      this.map['dc:subject'].render(xmlStream, model.subject);
      this.map['dc:description'].render(xmlStream, model.description);
      this.map['dc:identifier'].render(xmlStream, model.identifier);
      this.map['dc:language'].render(xmlStream, model.language);
      this.map['cp:keywords'].render(xmlStream, model.keywords);
      this.map['cp:category'].render(xmlStream, model.category);
      this.map['cp:lastModifiedBy'].render(xmlStream, model.lastModifiedBy);
      this.map['cp:lastPrinted'].render(xmlStream, model.lastPrinted);
      this.map['cp:revision'].render(xmlStream, model.revision);
      this.map['cp:version'].render(xmlStream, model.version);
      this.map['cp:contentStatus'].render(xmlStream, model.contentStatus);
      this.map['cp:contentType'].render(xmlStream, model.contentType);
      this.map['dcterms:created'].render(xmlStream, model.created);
      this.map['dcterms:modified'].render(xmlStream, model.modified);
      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      switch (node.name) {
        case 'cp:coreProperties':
        case 'coreProperties':
          return true;

        default:
          this.parser = this.map[node.name];

          if (this.parser) {
            this.parser.parseOpen(node);
            return true;
          }

          throw new Error("Unexpected xml node in parseOpen: ".concat(JSON.stringify(node)));
      }
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      if (this.parser) {
        this.parser.parseText(text);
      }
    }
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      if (this.parser) {
        if (!this.parser.parseClose(name)) {
          this.parser = undefined;
        }

        return true;
      }

      switch (name) {
        case 'cp:coreProperties':
        case 'coreProperties':
          this.model = {
            creator: this.map['dc:creator'].model,
            title: this.map['dc:title'].model,
            subject: this.map['dc:subject'].model,
            description: this.map['dc:description'].model,
            identifier: this.map['dc:identifier'].model,
            language: this.map['dc:language'].model,
            keywords: this.map['cp:keywords'].model,
            category: this.map['cp:category'].model,
            lastModifiedBy: this.map['cp:lastModifiedBy'].model,
            lastPrinted: this.map['cp:lastPrinted'].model,
            revision: this.map['cp:revision'].model,
            contentStatus: this.map['cp:contentStatus'].model,
            contentType: this.map['cp:contentType'].model,
            created: this.map['dcterms:created'].model,
            modified: this.map['dcterms:modified'].model
          };
          return false;

        default:
          throw new Error("Unexpected xml node in parseClose: ".concat(name));
      }
    }
  }]);

  return CoreXform;
}(BaseXform);

CoreXform.DateFormat = function (dt) {
  return dt.toISOString().replace(/[.]\d{3}/, '');
};

CoreXform.DateAttrs = {
  'xsi:type': 'dcterms:W3CDTF'
};
CoreXform.CORE_PROPERTY_ATTRIBUTES = {
  'xmlns:cp': 'http://schemas.openxmlformats.org/package/2006/metadata/core-properties',
  'xmlns:dc': 'http://purl.org/dc/elements/1.1/',
  'xmlns:dcterms': 'http://purl.org/dc/terms/',
  'xmlns:dcmitype': 'http://purl.org/dc/dcmitype/',
  'xmlns:xsi': 'http://www.w3.org/2001/XMLSchema-instance'
};
module.exports = CoreXform;


},{"../../../utils/xml-stream":26,"../base-xform":30,"../simple/date-xform":86,"../simple/integer-xform":87,"../simple/string-xform":88}],46:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var BaseXform = require('../base-xform');

var RelationshipXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(RelationshipXform, _BaseXform);

  function RelationshipXform() {
    _classCallCheck(this, RelationshipXform);

    return _possibleConstructorReturn(this, _getPrototypeOf(RelationshipXform).apply(this, arguments));
  }

  _createClass(RelationshipXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.leafNode('Relationship', model);
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      switch (node.name) {
        case 'Relationship':
          this.model = node.attributes;
          return true;

        default:
          return false;
      }
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose() {
      return false;
    }
  }]);

  return RelationshipXform;
}(BaseXform);

module.exports = RelationshipXform;


},{"../base-xform":30}],47:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var XmlStream = require('../../../utils/xml-stream');

var BaseXform = require('../base-xform');

var RelationshipXform = require('./relationship-xform');

var RelationshipsXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(RelationshipsXform, _BaseXform);

  function RelationshipsXform() {
    var _this;

    _classCallCheck(this, RelationshipsXform);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(RelationshipsXform).call(this));
    _this.map = {
      Relationship: new RelationshipXform()
    };
    return _this;
  }

  _createClass(RelationshipsXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      model = model || this._values;
      xmlStream.openXml(XmlStream.StdDocAttributes);
      xmlStream.openNode('Relationships', RelationshipsXform.RELATIONSHIPS_ATTRIBUTES);
      var self = this;
      model.forEach(function (relationship) {
        self.map.Relationship.render(xmlStream, relationship);
      });
      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      switch (node.name) {
        case 'Relationships':
          this.model = [];
          return true;

        default:
          this.parser = this.map[node.name];

          if (this.parser) {
            this.parser.parseOpen(node);
            return true;
          }

          throw new Error("Unexpected xml node in parseOpen: ".concat(JSON.stringify(node)));
      }
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      if (this.parser) {
        this.parser.parseText(text);
      }
    }
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      if (this.parser) {
        if (!this.parser.parseClose(name)) {
          this.model.push(this.parser.model);
          this.parser = undefined;
        }

        return true;
      }

      switch (name) {
        case 'Relationships':
          return false;

        default:
          throw new Error("Unexpected xml node in parseClose: ".concat(name));
      }
    }
  }]);

  return RelationshipsXform;
}(BaseXform);

RelationshipsXform.RELATIONSHIPS_ATTRIBUTES = {
  xmlns: 'http://schemas.openxmlformats.org/package/2006/relationships'
};
module.exports = RelationshipsXform;


},{"../../../utils/xml-stream":26,"../base-xform":30,"./relationship-xform":46}],48:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var BaseXform = require('../base-xform');

var BaseCellAnchorXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(BaseCellAnchorXform, _BaseXform);

  function BaseCellAnchorXform() {
    _classCallCheck(this, BaseCellAnchorXform);

    return _possibleConstructorReturn(this, _getPrototypeOf(BaseCellAnchorXform).apply(this, arguments));
  }

  _createClass(BaseCellAnchorXform, [{
    key: "parseOpen",
    value: function parseOpen(node) {
      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      switch (node.name) {
        case this.tag:
          this.reset();
          this.model = {
            range: {
              editAs: node.attributes.editAs || 'oneCell'
            }
          };
          break;

        default:
          this.parser = this.map[node.name];

          if (this.parser) {
            this.parser.parseOpen(node);
          }

          break;
      }

      return true;
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      if (this.parser) {
        this.parser.parseText(text);
      }
    }
  }, {
    key: "reconcilePicture",
    value: function reconcilePicture(model, options) {
      if (model && model.rId) {
        var rel = options.rels[model.rId];
        var match = rel.Target.match(/.*\/media\/(.+[.][a-z]{3,4})/);

        if (match) {
          var name = match[1];
          var mediaId = options.mediaIndex[name];
          return options.media[mediaId];
        }
      }

      return undefined;
    }
  }]);

  return BaseCellAnchorXform;
}(BaseXform);

module.exports = BaseCellAnchorXform;


},{"../base-xform":30}],49:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var BaseXform = require('../base-xform');

var BlipXform = require('./blip-xform');

var BlipFillXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(BlipFillXform, _BaseXform);

  function BlipFillXform() {
    var _this;

    _classCallCheck(this, BlipFillXform);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(BlipFillXform).call(this));
    _this.map = {
      'a:blip': new BlipXform()
    };
    return _this;
  }

  _createClass(BlipFillXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.openNode(this.tag);
      this.map['a:blip'].render(xmlStream, model); // TODO: options for this + parsing

      xmlStream.openNode('a:stretch');
      xmlStream.leafNode('a:fillRect');
      xmlStream.closeNode();
      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      switch (node.name) {
        case this.tag:
          this.reset();
          break;

        default:
          this.parser = this.map[node.name];

          if (this.parser) {
            this.parser.parseOpen(node);
          }

          break;
      }

      return true;
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      if (this.parser) {
        if (!this.parser.parseClose(name)) {
          this.parser = undefined;
        }

        return true;
      }

      switch (name) {
        case this.tag:
          this.model = this.map['a:blip'].model;
          return false;

        default:
          return true;
      }
    }
  }, {
    key: "tag",
    get: function get() {
      return 'xdr:blipFill';
    }
  }]);

  return BlipFillXform;
}(BaseXform);

module.exports = BlipFillXform;


},{"../base-xform":30,"./blip-xform":50}],50:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var BaseXform = require('../base-xform');

var BlipXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(BlipXform, _BaseXform);

  function BlipXform() {
    _classCallCheck(this, BlipXform);

    return _possibleConstructorReturn(this, _getPrototypeOf(BlipXform).apply(this, arguments));
  }

  _createClass(BlipXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.leafNode(this.tag, {
        'xmlns:r': 'http://schemas.openxmlformats.org/officeDocument/2006/relationships',
        'r:embed': model.rId,
        cstate: 'print'
      }); // TODO: handle children (e.g. a:extLst=>a:ext=>a14:useLocalDpi
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      switch (node.name) {
        case this.tag:
          this.model = {
            rId: node.attributes['r:embed']
          };
          return true;

        default:
          return true;
      }
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      switch (name) {
        case this.tag:
          return false;

        default:
          // unprocessed internal nodes
          return true;
      }
    }
  }, {
    key: "tag",
    get: function get() {
      return 'a:blip';
    }
  }]);

  return BlipXform;
}(BaseXform);

module.exports = BlipXform;


},{"../base-xform":30}],51:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var BaseXform = require('../base-xform');

var IntegerXform = require('../simple/integer-xform');

var CellPositionXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(CellPositionXform, _BaseXform);

  function CellPositionXform(options) {
    var _this;

    _classCallCheck(this, CellPositionXform);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(CellPositionXform).call(this));
    _this.tag = options.tag;
    _this.map = {
      'xdr:col': new IntegerXform({
        tag: 'xdr:col',
        zero: true
      }),
      'xdr:colOff': new IntegerXform({
        tag: 'xdr:colOff',
        zero: true
      }),
      'xdr:row': new IntegerXform({
        tag: 'xdr:row',
        zero: true
      }),
      'xdr:rowOff': new IntegerXform({
        tag: 'xdr:rowOff',
        zero: true
      })
    };
    return _this;
  }

  _createClass(CellPositionXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.openNode(this.tag);
      this.map['xdr:col'].render(xmlStream, model.nativeCol);
      this.map['xdr:colOff'].render(xmlStream, model.nativeColOff);
      this.map['xdr:row'].render(xmlStream, model.nativeRow);
      this.map['xdr:rowOff'].render(xmlStream, model.nativeRowOff);
      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      switch (node.name) {
        case this.tag:
          this.reset();
          break;

        default:
          this.parser = this.map[node.name];

          if (this.parser) {
            this.parser.parseOpen(node);
          }

          break;
      }

      return true;
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      if (this.parser) {
        this.parser.parseText(text);
      }
    }
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      if (this.parser) {
        if (!this.parser.parseClose(name)) {
          this.parser = undefined;
        }

        return true;
      }

      switch (name) {
        case this.tag:
          this.model = {
            nativeCol: this.map['xdr:col'].model,
            nativeColOff: this.map['xdr:colOff'].model,
            nativeRow: this.map['xdr:row'].model,
            nativeRowOff: this.map['xdr:rowOff'].model
          };
          return false;

        default:
          // not quite sure how we get here!
          return true;
      }
    }
  }]);

  return CellPositionXform;
}(BaseXform);

module.exports = CellPositionXform;


},{"../base-xform":30,"../simple/integer-xform":87}],52:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var colCache = require('../../../utils/col-cache');

var XmlStream = require('../../../utils/xml-stream');

var BaseXform = require('../base-xform');

var TwoCellAnchorXform = require('./two-cell-anchor-xform');

var OneCellAnchorXform = require('./one-cell-anchor-xform');

function getAnchorType(model) {
  var range = typeof model.range === 'string' ? colCache.decode(model.range) : model.range;
  return range.br ? 'xdr:twoCellAnchor' : 'xdr:oneCellAnchor';
}

var DrawingXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(DrawingXform, _BaseXform);

  function DrawingXform() {
    var _this;

    _classCallCheck(this, DrawingXform);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(DrawingXform).call(this));
    _this.map = {
      'xdr:twoCellAnchor': new TwoCellAnchorXform(),
      'xdr:oneCellAnchor': new OneCellAnchorXform()
    };
    return _this;
  }

  _createClass(DrawingXform, [{
    key: "prepare",
    value: function prepare(model) {
      var _this2 = this;

      model.anchors.forEach(function (item, index) {
        item.anchorType = getAnchorType(item);
        var anchor = _this2.map[item.anchorType];
        anchor.prepare(item, {
          index: index
        });
      });
    }
  }, {
    key: "render",
    value: function render(xmlStream, model) {
      var _this3 = this;

      xmlStream.openXml(XmlStream.StdDocAttributes);
      xmlStream.openNode(this.tag, DrawingXform.DRAWING_ATTRIBUTES);
      model.anchors.forEach(function (item) {
        var anchor = _this3.map[item.anchorType];
        anchor.render(xmlStream, item);
      });
      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      switch (node.name) {
        case this.tag:
          this.reset();
          this.model = {
            anchors: []
          };
          break;

        default:
          this.parser = this.map[node.name];

          if (this.parser) {
            this.parser.parseOpen(node);
          }

          break;
      }

      return true;
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      if (this.parser) {
        this.parser.parseText(text);
      }
    }
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      if (this.parser) {
        if (!this.parser.parseClose(name)) {
          this.model.anchors.push(this.parser.model);
          this.parser = undefined;
        }

        return true;
      }

      switch (name) {
        case this.tag:
          return false;

        default:
          // could be some unrecognised tags
          return true;
      }
    }
  }, {
    key: "reconcile",
    value: function reconcile(model, options) {
      var _this4 = this;

      model.anchors.forEach(function (anchor) {
        if (anchor.br) {
          _this4.map['xdr:twoCellAnchor'].reconcile(anchor, options);
        } else {
          _this4.map['xdr:oneCellAnchor'].reconcile(anchor, options);
        }
      });
    }
  }, {
    key: "tag",
    get: function get() {
      return 'xdr:wsDr';
    }
  }]);

  return DrawingXform;
}(BaseXform);

DrawingXform.DRAWING_ATTRIBUTES = {
  'xmlns:xdr': 'http://schemas.openxmlformats.org/drawingml/2006/spreadsheetDrawing',
  'xmlns:a': 'http://schemas.openxmlformats.org/drawingml/2006/main'
};
module.exports = DrawingXform;


},{"../../../utils/col-cache":18,"../../../utils/xml-stream":26,"../base-xform":30,"./one-cell-anchor-xform":55,"./two-cell-anchor-xform":58}],53:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var BaseXform = require('../base-xform');
/** https://en.wikipedia.org/wiki/Office_Open_XML_file_formats#DrawingML */


var EMU_PER_PIXEL_AT_96_DPI = 9525;

var ExtXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(ExtXform, _BaseXform);

  function ExtXform(options) {
    var _this;

    _classCallCheck(this, ExtXform);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(ExtXform).call(this));
    _this.tag = options.tag;
    _this.map = {};
    return _this;
  }

  _createClass(ExtXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.openNode(this.tag);
      var width = Math.floor(model.width * EMU_PER_PIXEL_AT_96_DPI);
      var height = Math.floor(model.height * EMU_PER_PIXEL_AT_96_DPI);
      xmlStream.addAttribute('cx', width);
      xmlStream.addAttribute('cy', height);
      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (node.name === this.tag) {
        this.model = {
          width: parseInt(node.attributes.cx || '0', 10) / EMU_PER_PIXEL_AT_96_DPI,
          height: parseInt(node.attributes.cy || '0', 10) / EMU_PER_PIXEL_AT_96_DPI
        };
        return true;
      }

      return false;
    }
  }, {
    key: "parseText",
    value: function parseText()
    /* text */
    {}
  }, {
    key: "parseClose",
    value: function parseClose()
    /* name */
    {
      return false;
    }
  }]);

  return ExtXform;
}(BaseXform);

module.exports = ExtXform;


},{"../base-xform":30}],54:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var BaseXform = require('../base-xform');

var StaticXform = require('../static-xform');

var NvPicPrXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(NvPicPrXform, _BaseXform);

  function NvPicPrXform() {
    _classCallCheck(this, NvPicPrXform);

    return _possibleConstructorReturn(this, _getPrototypeOf(NvPicPrXform).apply(this, arguments));
  }

  _createClass(NvPicPrXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      var xform = new StaticXform({
        tag: this.tag,
        c: [{
          tag: 'xdr:cNvPr',
          $: {
            id: model.index,
            name: "Picture ".concat(model.index)
          },
          c: [{
            tag: 'a:extLst',
            c: [{
              tag: 'a:ext',
              $: {
                uri: '{FF2B5EF4-FFF2-40B4-BE49-F238E27FC236}'
              },
              c: [{
                tag: 'a16:creationId',
                $: {
                  'xmlns:a16': 'http://schemas.microsoft.com/office/drawing/2014/main',
                  id: '{00000000-0008-0000-0000-000002000000}'
                }
              }]
            }]
          }]
        }, {
          tag: 'xdr:cNvPicPr',
          c: [{
            tag: 'a:picLocks',
            $: {
              noChangeAspect: '1'
            }
          }]
        }]
      });
      xform.render(xmlStream);
    }
  }, {
    key: "tag",
    get: function get() {
      return 'xdr:nvPicPr';
    }
  }]);

  return NvPicPrXform;
}(BaseXform);

module.exports = NvPicPrXform;


},{"../base-xform":30,"../static-xform":89}],55:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var BaseCellAnchorXform = require('./base-cell-anchor-xform');

var StaticXform = require('../static-xform');

var CellPositionXform = require('./cell-position-xform');

var ExtXform = require('./ext-xform');

var PicXform = require('./pic-xform');

var OneCellAnchorXform =
/*#__PURE__*/
function (_BaseCellAnchorXform) {
  _inherits(OneCellAnchorXform, _BaseCellAnchorXform);

  function OneCellAnchorXform() {
    var _this;

    _classCallCheck(this, OneCellAnchorXform);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(OneCellAnchorXform).call(this));
    _this.map = {
      'xdr:from': new CellPositionXform({
        tag: 'xdr:from'
      }),
      'xdr:ext': new ExtXform({
        tag: 'xdr:ext'
      }),
      'xdr:pic': new PicXform(),
      'xdr:clientData': new StaticXform({
        tag: 'xdr:clientData'
      })
    };
    return _this;
  }

  _createClass(OneCellAnchorXform, [{
    key: "prepare",
    value: function prepare(model, options) {
      this.map['xdr:pic'].prepare(model.picture, options);
    }
  }, {
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.openNode(this.tag, {
        editAs: model.range.editAs || 'oneCell'
      });
      this.map['xdr:from'].render(xmlStream, model.range.tl);
      this.map['xdr:ext'].render(xmlStream, model.range.ext);
      this.map['xdr:pic'].render(xmlStream, model.picture);
      this.map['xdr:clientData'].render(xmlStream, {});
      xmlStream.closeNode();
    }
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      if (this.parser) {
        if (!this.parser.parseClose(name)) {
          this.parser = undefined;
        }

        return true;
      }

      switch (name) {
        case this.tag:
          this.model.range.tl = this.map['xdr:from'].model;
          this.model.range.ext = this.map['xdr:ext'].model;
          this.model.picture = this.map['xdr:pic'].model;
          return false;

        default:
          // could be some unrecognised tags
          return true;
      }
    }
  }, {
    key: "reconcile",
    value: function reconcile(model, options) {
      model.medium = this.reconcilePicture(model.picture, options);
    }
  }, {
    key: "tag",
    get: function get() {
      return 'xdr:oneCellAnchor';
    }
  }]);

  return OneCellAnchorXform;
}(BaseCellAnchorXform);

module.exports = OneCellAnchorXform;


},{"../static-xform":89,"./base-cell-anchor-xform":48,"./cell-position-xform":51,"./ext-xform":53,"./pic-xform":56}],56:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var BaseXform = require('../base-xform');

var StaticXform = require('../static-xform');

var BlipFillXform = require('./blip-fill-xform');

var NvPicPrXform = require('./nv-pic-pr-xform');

var spPrJSON = require('./sp-pr');

var PicXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(PicXform, _BaseXform);

  function PicXform() {
    var _this;

    _classCallCheck(this, PicXform);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(PicXform).call(this));
    _this.map = {
      'xdr:nvPicPr': new NvPicPrXform(),
      'xdr:blipFill': new BlipFillXform(),
      'xdr:spPr': new StaticXform(spPrJSON)
    };
    return _this;
  }

  _createClass(PicXform, [{
    key: "prepare",
    value: function prepare(model, options) {
      model.index = options.index + 1;
    }
  }, {
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.openNode(this.tag);
      this.map['xdr:nvPicPr'].render(xmlStream, model);
      this.map['xdr:blipFill'].render(xmlStream, model);
      this.map['xdr:spPr'].render(xmlStream, model);
      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      switch (node.name) {
        case this.tag:
          this.reset();
          break;

        default:
          this.parser = this.map[node.name];

          if (this.parser) {
            this.parser.parseOpen(node);
          }

          break;
      }

      return true;
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      if (this.parser) {
        if (!this.parser.parseClose(name)) {
          this.mergeModel(this.parser.model);
          this.parser = undefined;
        }

        return true;
      }

      switch (name) {
        case this.tag:
          return false;

        default:
          // not quite sure how we get here!
          return true;
      }
    }
  }, {
    key: "tag",
    get: function get() {
      return 'xdr:pic';
    }
  }]);

  return PicXform;
}(BaseXform);

module.exports = PicXform;


},{"../base-xform":30,"../static-xform":89,"./blip-fill-xform":49,"./nv-pic-pr-xform":54,"./sp-pr":57}],57:[function(require,module,exports){
"use strict";

module.exports = {
  tag: 'xdr:spPr',
  c: [{
    tag: 'a:xfrm',
    c: [{
      tag: 'a:off',
      $: {
        x: '0',
        y: '0'
      }
    }, {
      tag: 'a:ext',
      $: {
        cx: '0',
        cy: '0'
      }
    }]
  }, {
    tag: 'a:prstGeom',
    $: {
      prst: 'rect'
    },
    c: [{
      tag: 'a:avLst'
    }]
  }]
};


},{}],58:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var BaseCellAnchorXform = require('./base-cell-anchor-xform');

var StaticXform = require('../static-xform');

var CellPositionXform = require('./cell-position-xform');

var PicXform = require('./pic-xform');

var TwoCellAnchorXform =
/*#__PURE__*/
function (_BaseCellAnchorXform) {
  _inherits(TwoCellAnchorXform, _BaseCellAnchorXform);

  function TwoCellAnchorXform() {
    var _this;

    _classCallCheck(this, TwoCellAnchorXform);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(TwoCellAnchorXform).call(this));
    _this.map = {
      'xdr:from': new CellPositionXform({
        tag: 'xdr:from'
      }),
      'xdr:to': new CellPositionXform({
        tag: 'xdr:to'
      }),
      'xdr:pic': new PicXform(),
      'xdr:clientData': new StaticXform({
        tag: 'xdr:clientData'
      })
    };
    return _this;
  }

  _createClass(TwoCellAnchorXform, [{
    key: "prepare",
    value: function prepare(model, options) {
      this.map['xdr:pic'].prepare(model.picture, options);
    }
  }, {
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.openNode(this.tag, {
        editAs: model.range.editAs || 'oneCell'
      });
      this.map['xdr:from'].render(xmlStream, model.range.tl);
      this.map['xdr:to'].render(xmlStream, model.range.br);
      this.map['xdr:pic'].render(xmlStream, model.picture);
      this.map['xdr:clientData'].render(xmlStream, {});
      xmlStream.closeNode();
    }
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      if (this.parser) {
        if (!this.parser.parseClose(name)) {
          this.parser = undefined;
        }

        return true;
      }

      switch (name) {
        case this.tag:
          this.model.range.tl = this.map['xdr:from'].model;
          this.model.range.br = this.map['xdr:to'].model;
          this.model.picture = this.map['xdr:pic'].model;
          return false;

        default:
          // could be some unrecognised tags
          return true;
      }
    }
  }, {
    key: "reconcile",
    value: function reconcile(model, options) {
      model.medium = this.reconcilePicture(model.picture, options);
    }
  }, {
    key: "tag",
    get: function get() {
      return 'xdr:twoCellAnchor';
    }
  }]);

  return TwoCellAnchorXform;
}(BaseCellAnchorXform);

module.exports = TwoCellAnchorXform;


},{"../static-xform":89,"./base-cell-anchor-xform":48,"./cell-position-xform":51,"./pic-xform":56}],59:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var BaseXform = require('./base-xform');

var ListXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(ListXform, _BaseXform);

  function ListXform(options) {
    var _this;

    _classCallCheck(this, ListXform);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(ListXform).call(this));
    _this.tag = options.tag;
    _this.always = !!options.always;
    _this.count = options.count;
    _this.empty = options.empty;
    _this.$count = options.$count || 'count';
    _this.$ = options.$;
    _this.childXform = options.childXform;
    _this.maxItems = options.maxItems;
    return _this;
  }

  _createClass(ListXform, [{
    key: "prepare",
    value: function prepare(model, options) {
      var childXform = this.childXform;

      if (model) {
        model.forEach(function (childModel, index) {
          options.index = index;
          childXform.prepare(childModel, options);
        });
      }
    }
  }, {
    key: "render",
    value: function render(xmlStream, model) {
      if (this.always || model && model.length) {
        xmlStream.openNode(this.tag, this.$);

        if (this.count) {
          xmlStream.addAttribute(this.$count, model && model.length || 0);
        }

        var childXform = this.childXform;
        (model || []).forEach(function (childModel, index) {
          childXform.render(xmlStream, childModel, index);
        });
        xmlStream.closeNode();
      } else if (this.empty) {
        xmlStream.leafNode(this.tag);
      }
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      switch (node.name) {
        case this.tag:
          this.model = [];
          return true;

        default:
          if (this.childXform.parseOpen(node)) {
            this.parser = this.childXform;
            return true;
          }

          return false;
      }
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      if (this.parser) {
        this.parser.parseText(text);
      }
    }
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      if (this.parser) {
        if (!this.parser.parseClose(name)) {
          this.model.push(this.parser.model);
          this.parser = undefined;

          if (this.maxItems && this.model.length > this.maxItems) {
            throw new Error("Max ".concat(this.childXform.tag, " count exceeded"));
          }
        }

        return true;
      }

      return false;
    }
  }, {
    key: "reconcile",
    value: function reconcile(model, options) {
      if (model) {
        var childXform = this.childXform;
        model.forEach(function (childModel) {
          childXform.reconcile(childModel, options);
        });
      }
    }
  }]);

  return ListXform;
}(BaseXform);

module.exports = ListXform;


},{"./base-xform":30}],60:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var colCache = require('../../../utils/col-cache');

var BaseXform = require('../base-xform');

var AutoFilterXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(AutoFilterXform, _BaseXform);

  function AutoFilterXform() {
    _classCallCheck(this, AutoFilterXform);

    return _possibleConstructorReturn(this, _getPrototypeOf(AutoFilterXform).apply(this, arguments));
  }

  _createClass(AutoFilterXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      if (model) {
        if (typeof model === 'string') {
          // assume range
          xmlStream.leafNode('autoFilter', {
            ref: model
          });
        } else {
          var getAddress = function getAddress(addr) {
            if (typeof addr === 'string') {
              return addr;
            }

            return colCache.getAddress(addr.row, addr.column).address;
          };

          var firstAddress = getAddress(model.from);
          var secondAddress = getAddress(model.to);

          if (firstAddress && secondAddress) {
            xmlStream.leafNode('autoFilter', {
              ref: "".concat(firstAddress, ":").concat(secondAddress)
            });
          }
        }
      }
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (node.name === 'autoFilter') {
        this.model = node.attributes.ref;
      }
    }
  }, {
    key: "tag",
    get: function get() {
      return 'autoFilter';
    }
  }]);

  return AutoFilterXform;
}(BaseXform);

module.exports = AutoFilterXform;


},{"../../../utils/col-cache":18,"../base-xform":30}],61:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var utils = require('../../../utils/utils');

var BaseXform = require('../base-xform');

var Enums = require('../../../doc/enums');

var Range = require('../../../doc/range');

var RichTextXform = require('../strings/rich-text-xform');

function getValueType(v) {
  if (v === null || v === undefined) {
    return Enums.ValueType.Null;
  }

  if (v instanceof String || typeof v === 'string') {
    return Enums.ValueType.String;
  }

  if (typeof v === 'number') {
    return Enums.ValueType.Number;
  }

  if (typeof v === 'boolean') {
    return Enums.ValueType.Boolean;
  }

  if (v instanceof Date) {
    return Enums.ValueType.Date;
  }

  if (v.text && v.hyperlink) {
    return Enums.ValueType.Hyperlink;
  }

  if (v.formula) {
    return Enums.ValueType.Formula;
  }

  if (v.error) {
    return Enums.ValueType.Error;
  }

  throw new Error('I could not understand type of value');
}

function getEffectiveCellType(cell) {
  switch (cell.type) {
    case Enums.ValueType.Formula:
      return getValueType(cell.result);

    default:
      return cell.type;
  }
}

var CellXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(CellXform, _BaseXform);

  function CellXform() {
    var _this;

    _classCallCheck(this, CellXform);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(CellXform).call(this));
    _this.richTextXForm = new RichTextXform();
    return _this;
  }

  _createClass(CellXform, [{
    key: "prepare",
    value: function prepare(model, options) {
      var styleId = options.styles.addStyleModel(model.style || {}, getEffectiveCellType(model));

      if (styleId) {
        model.styleId = styleId;
      }

      if (model.comment) {
        options.comments.push(_objectSpread({}, model.comment, {
          ref: model.address
        }));
      }

      switch (model.type) {
        case Enums.ValueType.String:
          if (options.sharedStrings) {
            model.ssId = options.sharedStrings.add(model.value);
          }

          break;

        case Enums.ValueType.Date:
          if (options.date1904) {
            model.date1904 = true;
          }

          break;

        case Enums.ValueType.Hyperlink:
          if (options.sharedStrings && model.text !== undefined && model.text !== null) {
            model.ssId = options.sharedStrings.add(model.text);
          }

          options.hyperlinks.push(Object.assign({
            address: model.address,
            target: model.hyperlink
          }, model.tooltip ? {
            tooltip: model.tooltip
          } : {}));
          break;

        case Enums.ValueType.Merge:
          options.merges.add(model);
          break;

        case Enums.ValueType.Formula:
          if (options.date1904) {
            // in case valueType is date
            model.date1904 = true;
          }

          if (model.formula) {
            options.formulae[model.address] = model;
          } else if (model.sharedFormula) {
            var master = options.formulae[model.sharedFormula];

            if (!master) {
              throw new Error('Shared Formula master must exist above and or left of clone');
            }

            if (master.si !== undefined) {
              model.si = master.si;
              master.ref.expandToAddress(model.address);
            } else {
              model.si = master.si = options.siFormulae++;
              master.ref = new Range(master.address, model.address);
            }
          }

          break;

        default:
          break;
      }
    }
  }, {
    key: "renderFormula",
    value: function renderFormula(xmlStream, model) {
      var attrs = null;

      if (model.ref) {
        attrs = {
          t: 'shared',
          ref: model.ref.range,
          si: model.si
        };
      } else if (model.si !== undefined) {
        attrs = {
          t: 'shared',
          si: model.si
        };
      }

      switch (getValueType(model.result)) {
        case Enums.ValueType.Null:
          // ?
          xmlStream.leafNode('f', attrs, model.formula);
          break;

        case Enums.ValueType.String:
          // oddly, formula results don't ever use shared strings
          xmlStream.addAttribute('t', 'str');
          xmlStream.leafNode('f', attrs, model.formula);
          xmlStream.leafNode('v', null, model.result);
          break;

        case Enums.ValueType.Number:
          xmlStream.leafNode('f', attrs, model.formula);
          xmlStream.leafNode('v', null, model.result);
          break;

        case Enums.ValueType.Boolean:
          xmlStream.addAttribute('t', 'b');
          xmlStream.leafNode('f', attrs, model.formula);
          xmlStream.leafNode('v', null, model.result ? 1 : 0);
          break;

        case Enums.ValueType.Error:
          xmlStream.addAttribute('t', 'e');
          xmlStream.leafNode('f', attrs, model.formula);
          xmlStream.leafNode('v', null, model.result.error);
          break;

        case Enums.ValueType.Date:
          xmlStream.leafNode('f', attrs, model.formula);
          xmlStream.leafNode('v', null, utils.dateToExcel(model.result, model.date1904));
          break;
        // case Enums.ValueType.Hyperlink: // ??
        // case Enums.ValueType.Formula:

        default:
          throw new Error('I could not understand type of value');
      }
    }
  }, {
    key: "render",
    value: function render(xmlStream, model) {
      if (model.type === Enums.ValueType.Null && !model.styleId) {
        // if null and no style, exit
        return;
      }

      xmlStream.openNode('c');
      xmlStream.addAttribute('r', model.address);

      if (model.styleId) {
        xmlStream.addAttribute('s', model.styleId);
      }

      switch (model.type) {
        case Enums.ValueType.Null:
          break;

        case Enums.ValueType.Number:
          xmlStream.leafNode('v', null, model.value);
          break;

        case Enums.ValueType.Boolean:
          xmlStream.addAttribute('t', 'b');
          xmlStream.leafNode('v', null, model.value ? '1' : '0');
          break;

        case Enums.ValueType.Error:
          xmlStream.addAttribute('t', 'e');
          xmlStream.leafNode('v', null, model.value.error);
          break;

        case Enums.ValueType.String:
          if (model.ssId !== undefined) {
            xmlStream.addAttribute('t', 's');
            xmlStream.leafNode('v', null, model.ssId);
          } else if (model.value && model.value.richText) {
            xmlStream.addAttribute('t', 'inlineStr');
            xmlStream.openNode('is');
            var self = this;
            model.value.richText.forEach(function (text) {
              self.richTextXForm.render(xmlStream, text);
            });
            xmlStream.closeNode('is');
          } else {
            xmlStream.addAttribute('t', 'str');
            xmlStream.leafNode('v', null, model.value);
          }

          break;

        case Enums.ValueType.Date:
          xmlStream.leafNode('v', null, utils.dateToExcel(model.value, model.date1904));
          break;

        case Enums.ValueType.Hyperlink:
          if (model.ssId !== undefined) {
            xmlStream.addAttribute('t', 's');
            xmlStream.leafNode('v', null, model.ssId);
          } else {
            xmlStream.addAttribute('t', 'str');
            xmlStream.leafNode('v', null, model.text);
          }

          break;

        case Enums.ValueType.Formula:
          this.renderFormula(xmlStream, model);
          break;

        case Enums.ValueType.Merge:
          // nothing to add
          break;

        default:
          break;
      }

      xmlStream.closeNode(); // </c>
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      switch (node.name) {
        case 'c':
          // const address = colCache.decodeAddress(node.attributes.r);
          this.model = {
            address: node.attributes.r
          };
          this.t = node.attributes.t;

          if (node.attributes.s) {
            this.model.styleId = parseInt(node.attributes.s, 10);
          }

          return true;

        case 'f':
          this.currentNode = 'f';
          this.model.si = node.attributes.si;

          if (node.attributes.t === 'shared') {
            this.model.sharedFormula = true;
          }

          this.model.ref = node.attributes.ref;
          return true;

        case 'v':
          this.currentNode = 'v';
          return true;

        case 't':
          this.currentNode = 't';
          return true;

        case 'r':
          this.parser = this.richTextXForm;
          this.parser.parseOpen(node);
          return true;

        default:
          return false;
      }
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      if (this.parser) {
        this.parser.parseText(text);
        return;
      }

      switch (this.currentNode) {
        case 'f':
          this.model.formula = this.model.formula ? this.model.formula + text : text;
          break;

        case 'v':
        case 't':
          if (this.model.value && this.model.value.richText) {
            this.model.value.richText.text = this.model.value.richText.text ? this.model.value.richText.text + text : text;
          } else {
            this.model.value = this.model.value ? this.model.value + text : text;
          }

          break;

        default:
          break;
      }
    }
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      switch (name) {
        case 'c':
          {
            var model = this.model; // first guess on cell type

            if (model.formula || model.sharedFormula) {
              model.type = Enums.ValueType.Formula;

              if (model.value) {
                if (this.t === 'str') {
                  model.result = utils.xmlDecode(model.value);
                } else if (this.t === 'b') {
                  model.result = parseInt(model.value, 10) !== 0;
                } else if (this.t === 'e') {
                  model.result = {
                    error: model.value
                  };
                } else {
                  model.result = parseFloat(model.value);
                }

                model.value = undefined;
              }
            } else if (model.value !== undefined) {
              switch (this.t) {
                case 's':
                  model.type = Enums.ValueType.String;
                  model.value = parseInt(model.value, 10);
                  break;

                case 'str':
                  model.type = Enums.ValueType.String;
                  model.value = utils.xmlDecode(model.value);
                  break;

                case 'inlineStr':
                  model.type = Enums.ValueType.String;
                  break;

                case 'b':
                  model.type = Enums.ValueType.Boolean;
                  model.value = parseInt(model.value, 10) !== 0;
                  break;

                case 'e':
                  model.type = Enums.ValueType.Error;
                  model.value = {
                    error: model.value
                  };
                  break;

                default:
                  model.type = Enums.ValueType.Number;
                  model.value = parseFloat(model.value);
                  break;
              }
            } else if (model.styleId) {
              model.type = Enums.ValueType.Null;
            } else {
              model.type = Enums.ValueType.Merge;
            }

            return false;
          }

        case 'f':
        case 'v':
        case 'is':
          this.currentNode = undefined;
          return true;

        case 't':
          if (this.parser) {
            this.parser.parseClose(name);
            return true;
          }

          this.currentNode = undefined;
          return true;

        case 'r':
          this.model.value = this.model.value || {};
          this.model.value.richText = this.model.value.richText || [];
          this.model.value.richText.push(this.parser.model);
          this.parser = undefined;
          this.currentNode = undefined;
          return true;

        default:
          if (this.parser) {
            this.parser.parseClose(name);
            return true;
          }

          return false;
      }
    }
  }, {
    key: "reconcile",
    value: function reconcile(model, options) {
      var style = model.styleId && options.styles && options.styles.getStyleModel(model.styleId);

      if (style) {
        model.style = style;
      }

      if (model.styleId !== undefined) {
        model.styleId = undefined;
      }

      switch (model.type) {
        case Enums.ValueType.String:
          if (typeof model.value === 'number') {
            if (options.sharedStrings) {
              model.value = options.sharedStrings.getString(model.value);
            }
          }

          if (model.value.richText) {
            model.type = Enums.ValueType.RichText;
          }

          break;

        case Enums.ValueType.Number:
          if (style && utils.isDateFmt(style.numFmt)) {
            model.type = Enums.ValueType.Date;
            model.value = utils.excelToDate(model.value, options.date1904);
          }

          break;

        case Enums.ValueType.Formula:
          if (model.result !== undefined && style && utils.isDateFmt(style.numFmt)) {
            model.result = utils.excelToDate(model.result, options.date1904);
          }

          if (model.sharedFormula) {
            if (model.formula) {
              options.formulae[model.si] = model;
              delete model.sharedFormula;
            } else {
              model.sharedFormula = options.formulae[model.si].address;
            }

            delete model.si;
          }

          break;

        default:
          break;
      } // look for hyperlink


      var hyperlink = options.hyperlinkMap[model.address];

      if (hyperlink) {
        if (model.type === Enums.ValueType.Formula) {
          model.text = model.result;
          model.result = undefined;
        } else {
          model.text = model.value;
          model.value = undefined;
        }

        model.type = Enums.ValueType.Hyperlink;
        model.hyperlink = hyperlink;
      }

      var comment = options.commentsMap && options.commentsMap[model.address];

      if (comment) {
        model.comment = comment;
      }
    }
  }, {
    key: "tag",
    get: function get() {
      return 'c';
    }
  }]);

  return CellXform;
}(BaseXform);

module.exports = CellXform;


},{"../../../doc/enums":8,"../../../doc/range":11,"../../../utils/utils":25,"../base-xform":30,"../strings/rich-text-xform":91}],62:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var BaseXform = require('../base-xform');

var ColXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(ColXform, _BaseXform);

  function ColXform() {
    _classCallCheck(this, ColXform);

    return _possibleConstructorReturn(this, _getPrototypeOf(ColXform).apply(this, arguments));
  }

  _createClass(ColXform, [{
    key: "prepare",
    value: function prepare(model, options) {
      var styleId = options.styles.addStyleModel(model.style || {});

      if (styleId) {
        model.styleId = styleId;
      }
    }
  }, {
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.openNode('col');
      xmlStream.addAttribute('min', model.min);
      xmlStream.addAttribute('max', model.max);

      if (model.width) {
        xmlStream.addAttribute('width', model.width);
      }

      if (model.styleId) {
        xmlStream.addAttribute('style', model.styleId);
      }

      if (model.hidden) {
        xmlStream.addAttribute('hidden', '1');
      }

      if (model.bestFit) {
        xmlStream.addAttribute('bestFit', '1');
      }

      if (model.outlineLevel) {
        xmlStream.addAttribute('outlineLevel', model.outlineLevel);
      }

      if (model.collapsed) {
        xmlStream.addAttribute('collapsed', '1');
      }

      xmlStream.addAttribute('customWidth', '1');
      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (node.name === 'col') {
        var model = this.model = {
          min: parseInt(node.attributes.min || '0', 10),
          max: parseInt(node.attributes.max || '0', 10),
          width: node.attributes.width === undefined ? undefined : parseFloat(node.attributes.width || '0')
        };

        if (node.attributes.style) {
          model.styleId = parseInt(node.attributes.style, 10);
        }

        if (node.attributes.hidden) {
          model.hidden = true;
        }

        if (node.attributes.bestFit) {
          model.bestFit = true;
        }

        if (node.attributes.outlineLevel) {
          model.outlineLevel = parseInt(node.attributes.outlineLevel, 10);
        }

        if (node.attributes.collapsed) {
          model.collapsed = true;
        }

        return true;
      }

      return false;
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose() {
      return false;
    }
  }, {
    key: "reconcile",
    value: function reconcile(model, options) {
      // reconcile column styles
      if (model.styleId) {
        model.style = options.styles.getStyleModel(model.styleId);
      }
    }
  }, {
    key: "tag",
    get: function get() {
      return 'col';
    }
  }]);

  return ColXform;
}(BaseXform);

module.exports = ColXform;


},{"../base-xform":30}],63:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var _ = require('../../../utils/under-dash');

var utils = require('../../../utils/utils');

var BaseXform = require('../base-xform');

function assign(definedName, attributes, name, defaultValue) {
  var value = attributes[name];

  if (value !== undefined) {
    definedName[name] = value;
  } else if (defaultValue !== undefined) {
    definedName[name] = defaultValue;
  }
}

function parseBool(value) {
  switch (value) {
    case '1':
    case 'true':
      return true;

    default:
      return false;
  }
}

function assignBool(definedName, attributes, name, defaultValue) {
  var value = attributes[name];

  if (value !== undefined) {
    definedName[name] = parseBool(value);
  } else if (defaultValue !== undefined) {
    definedName[name] = defaultValue;
  }
}

var DataValidationsXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(DataValidationsXform, _BaseXform);

  function DataValidationsXform() {
    _classCallCheck(this, DataValidationsXform);

    return _possibleConstructorReturn(this, _getPrototypeOf(DataValidationsXform).apply(this, arguments));
  }

  _createClass(DataValidationsXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      var count = model && Object.keys(model).length;

      if (count) {
        xmlStream.openNode('dataValidations', {
          count: count
        });

        _.each(model, function (value, address) {
          xmlStream.openNode('dataValidation');

          if (value.type !== 'any') {
            xmlStream.addAttribute('type', value.type);

            if (value.operator && value.type !== 'list' && value.operator !== 'between') {
              xmlStream.addAttribute('operator', value.operator);
            }

            if (value.allowBlank) {
              xmlStream.addAttribute('allowBlank', '1');
            }
          }

          if (value.showInputMessage) {
            xmlStream.addAttribute('showInputMessage', '1');
          }

          if (value.promptTitle) {
            xmlStream.addAttribute('promptTitle', value.promptTitle);
          }

          if (value.prompt) {
            xmlStream.addAttribute('prompt', value.prompt);
          }

          if (value.showErrorMessage) {
            xmlStream.addAttribute('showErrorMessage', '1');
          }

          if (value.errorStyle) {
            xmlStream.addAttribute('errorStyle', value.errorStyle);
          }

          if (value.errorTitle) {
            xmlStream.addAttribute('errorTitle', value.errorTitle);
          }

          if (value.error) {
            xmlStream.addAttribute('error', value.error);
          }

          xmlStream.addAttribute('sqref', address);
          (value.formulae || []).forEach(function (formula, index) {
            xmlStream.openNode("formula".concat(index + 1));

            if (value.type === 'date') {
              xmlStream.writeText(utils.dateToExcel(formula));
            } else {
              xmlStream.writeText(formula);
            }

            xmlStream.closeNode();
          });
          xmlStream.closeNode();
        });

        xmlStream.closeNode();
      }
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      switch (node.name) {
        case 'dataValidations':
          this.model = {};
          return true;

        case 'dataValidation':
          {
            this._address = node.attributes.sqref;
            var definedName = node.attributes.type ? {
              type: node.attributes.type,
              formulae: []
            } : {
              type: 'any'
            };

            if (node.attributes.type) {
              assignBool(definedName, node.attributes, 'allowBlank');
            }

            assignBool(definedName, node.attributes, 'showInputMessage');
            assignBool(definedName, node.attributes, 'showErrorMessage');

            switch (definedName.type) {
              case 'any':
              case 'list':
              case 'custom':
                break;

              default:
                assign(definedName, node.attributes, 'operator', 'between');
                break;
            }

            assign(definedName, node.attributes, 'promptTitle');
            assign(definedName, node.attributes, 'prompt');
            assign(definedName, node.attributes, 'errorStyle');
            assign(definedName, node.attributes, 'errorTitle');
            assign(definedName, node.attributes, 'error');
            this._definedName = definedName;
            return true;
          }

        case 'formula1':
        case 'formula2':
          this._formula = [];
          return true;

        default:
          return false;
      }
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      this._formula.push(text);
    }
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      switch (name) {
        case 'dataValidations':
          return false;

        case 'dataValidation':
          if (!this._definedName.formulae || !this._definedName.formulae.length) {
            delete this._definedName.formulae;
            delete this._definedName.operator;
          }

          this.model[this._address] = this._definedName;
          return true;

        case 'formula1':
        case 'formula2':
          {
            var formula = this._formula.join('');

            switch (this._definedName.type) {
              case 'whole':
              case 'textLength':
                formula = parseInt(formula, 10);
                break;

              case 'decimal':
                formula = parseFloat(formula);
                break;

              case 'date':
                formula = utils.excelToDate(parseFloat(formula));
                break;

              default:
                break;
            }

            this._definedName.formulae.push(formula);

            return true;
          }

        default:
          return true;
      }
    }
  }, {
    key: "tag",
    get: function get() {
      return 'dataValidations';
    }
  }]);

  return DataValidationsXform;
}(BaseXform);

module.exports = DataValidationsXform;


},{"../../../utils/under-dash":24,"../../../utils/utils":25,"../base-xform":30}],64:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var BaseXform = require('../base-xform');

var DimensionXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(DimensionXform, _BaseXform);

  function DimensionXform() {
    _classCallCheck(this, DimensionXform);

    return _possibleConstructorReturn(this, _getPrototypeOf(DimensionXform).apply(this, arguments));
  }

  _createClass(DimensionXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      if (model) {
        xmlStream.leafNode('dimension', {
          ref: model
        });
      }
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (node.name === 'dimension') {
        this.model = node.attributes.ref;
        return true;
      }

      return false;
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose() {
      return false;
    }
  }, {
    key: "tag",
    get: function get() {
      return 'dimension';
    }
  }]);

  return DimensionXform;
}(BaseXform);

module.exports = DimensionXform;


},{"../base-xform":30}],65:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var BaseXform = require('../base-xform');

var DrawingXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(DrawingXform, _BaseXform);

  function DrawingXform() {
    _classCallCheck(this, DrawingXform);

    return _possibleConstructorReturn(this, _getPrototypeOf(DrawingXform).apply(this, arguments));
  }

  _createClass(DrawingXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      if (model) {
        xmlStream.leafNode(this.tag, {
          'r:id': model.rId
        });
      }
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      switch (node.name) {
        case this.tag:
          this.model = {
            rId: node.attributes['r:id']
          };
          return true;

        default:
          return false;
      }
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose() {
      return false;
    }
  }, {
    key: "tag",
    get: function get() {
      return 'drawing';
    }
  }]);

  return DrawingXform;
}(BaseXform);

module.exports = DrawingXform;


},{"../base-xform":30}],66:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var BaseXform = require('../base-xform');

var HeaderFooterXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(HeaderFooterXform, _BaseXform);

  function HeaderFooterXform() {
    _classCallCheck(this, HeaderFooterXform);

    return _possibleConstructorReturn(this, _getPrototypeOf(HeaderFooterXform).apply(this, arguments));
  }

  _createClass(HeaderFooterXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      if (model) {
        xmlStream.addRollback();
        var createTag = false;
        xmlStream.openNode('headerFooter');

        if (model.differentFirst) {
          xmlStream.addAttribute('differentFirst', '1');
          createTag = true;
        }

        if (model.differentOddEven) {
          xmlStream.addAttribute('differentOddEven', '1');
          createTag = true;
        }

        if (model.oddHeader && typeof model.oddHeader === 'string') {
          xmlStream.leafNode('oddHeader', null, model.oddHeader);
          createTag = true;
        }

        if (model.oddFooter && typeof model.oddFooter === 'string') {
          xmlStream.leafNode('oddFooter', null, model.oddFooter);
          createTag = true;
        }

        if (model.evenHeader && typeof model.evenHeader === 'string') {
          xmlStream.leafNode('evenHeader', null, model.evenHeader);
          createTag = true;
        }

        if (model.evenFooter && typeof model.evenFooter === 'string') {
          xmlStream.leafNode('evenFooter', null, model.evenFooter);
          createTag = true;
        }

        if (model.firstHeader && typeof model.firstHeader === 'string') {
          xmlStream.leafNode('firstHeader', null, model.firstHeader);
          createTag = true;
        }

        if (model.firstFooter && typeof model.firstFooter === 'string') {
          xmlStream.leafNode('firstFooter', null, model.firstFooter);
          createTag = true;
        }

        if (createTag) {
          xmlStream.closeNode();
          xmlStream.commit();
        } else {
          xmlStream.rollback();
        }
      }
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      switch (node.name) {
        case 'headerFooter':
          this.model = {};

          if (node.attributes.differentFirst) {
            this.model.differentFirst = parseInt(node.attributes.differentFirst, 0) === 1;
          }

          if (node.attributes.differentOddEven) {
            this.model.differentOddEven = parseInt(node.attributes.differentOddEven, 0) === 1;
          }

          return true;

        case 'oddHeader':
          this.currentNode = 'oddHeader';
          return true;

        case 'oddFooter':
          this.currentNode = 'oddFooter';
          return true;

        case 'evenHeader':
          this.currentNode = 'evenHeader';
          return true;

        case 'evenFooter':
          this.currentNode = 'evenFooter';
          return true;

        case 'firstHeader':
          this.currentNode = 'firstHeader';
          return true;

        case 'firstFooter':
          this.currentNode = 'firstFooter';
          return true;

        default:
          return false;
      }
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      switch (this.currentNode) {
        case 'oddHeader':
          this.model.oddHeader = text;
          break;

        case 'oddFooter':
          this.model.oddFooter = text;
          break;

        case 'evenHeader':
          this.model.evenHeader = text;
          break;

        case 'evenFooter':
          this.model.evenFooter = text;
          break;

        case 'firstHeader':
          this.model.firstHeader = text;
          break;

        case 'firstFooter':
          this.model.firstFooter = text;
          break;

        default:
          break;
      }
    }
  }, {
    key: "parseClose",
    value: function parseClose() {
      switch (this.currentNode) {
        case 'oddHeader':
        case 'oddFooter':
        case 'evenHeader':
        case 'evenFooter':
        case 'firstHeader':
        case 'firstFooter':
          this.currentNode = undefined;
          return true;

        default:
          return false;
      }
    }
  }, {
    key: "tag",
    get: function get() {
      return 'headerFooter';
    }
  }]);

  return HeaderFooterXform;
}(BaseXform);

module.exports = HeaderFooterXform;


},{"../base-xform":30}],67:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var BaseXform = require('../base-xform');

var HyperlinkXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(HyperlinkXform, _BaseXform);

  function HyperlinkXform() {
    _classCallCheck(this, HyperlinkXform);

    return _possibleConstructorReturn(this, _getPrototypeOf(HyperlinkXform).apply(this, arguments));
  }

  _createClass(HyperlinkXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.leafNode('hyperlink', Object.assign({
        ref: model.address,
        'r:id': model.rId
      }, model.tooltip ? {
        tooltip: model.tooltip
      } : {}));
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (node.name === 'hyperlink') {
        this.model = Object.assign({
          address: node.attributes.ref,
          rId: node.attributes['r:id']
        }, node.attributes.tooltip ? {
          tooltip: node.attributes.tooltip
        } : {});
        return true;
      }

      return false;
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose() {
      return false;
    }
  }, {
    key: "tag",
    get: function get() {
      return 'hyperlink';
    }
  }]);

  return HyperlinkXform;
}(BaseXform);

module.exports = HyperlinkXform;


},{"../base-xform":30}],68:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var BaseXform = require('../base-xform');

var MergeCellXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(MergeCellXform, _BaseXform);

  function MergeCellXform() {
    _classCallCheck(this, MergeCellXform);

    return _possibleConstructorReturn(this, _getPrototypeOf(MergeCellXform).apply(this, arguments));
  }

  _createClass(MergeCellXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.leafNode('mergeCell', {
        ref: model
      });
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (node.name === 'mergeCell') {
        this.model = node.attributes.ref;
        return true;
      }

      return false;
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose() {
      return false;
    }
  }, {
    key: "tag",
    get: function get() {
      return 'mergeCell';
    }
  }]);

  return MergeCellXform;
}(BaseXform);

module.exports = MergeCellXform;


},{"../base-xform":30}],69:[function(require,module,exports){
"use strict";

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var _ = require('../../../utils/under-dash');

var Range = require('../../../doc/range');

var colCache = require('../../../utils/col-cache');

var Enums = require('../../../doc/enums');

var Merges =
/*#__PURE__*/
function () {
  function Merges() {
    _classCallCheck(this, Merges);

    // optional mergeCells is array of ranges (like the xml)
    this.merges = {};
  }

  _createClass(Merges, [{
    key: "add",
    value: function add(merge) {
      // merge is {address, master}
      if (this.merges[merge.master]) {
        this.merges[merge.master].expandToAddress(merge.address);
      } else {
        var range = "".concat(merge.master, ":").concat(merge.address);
        this.merges[merge.master] = new Range(range);
      }
    }
  }, {
    key: "reconcile",
    value: function reconcile(mergeCells, rows) {
      // reconcile merge list with merge cells
      _.each(mergeCells, function (merge) {
        var dimensions = colCache.decode(merge);

        for (var i = dimensions.top; i <= dimensions.bottom; i++) {
          var row = rows[i - 1];

          for (var j = dimensions.left; j <= dimensions.right; j++) {
            var cell = row.cells[j - 1];

            if (!cell) {
              // nulls are not included in document - so if master cell has no value - add a null one here
              row.cells[j] = {
                type: Enums.ValueType.Null,
                address: colCache.encodeAddress(i, j)
              };
            } else if (cell.type === Enums.ValueType.Merge) {
              cell.master = dimensions.tl;
            }
          }
        }
      });
    }
  }, {
    key: "getMasterAddress",
    value: function getMasterAddress(address) {
      // if address has been merged, return its master's address. Assumes reconcile has been called
      var range = this.hash[address];
      return range && range.tl;
    }
  }, {
    key: "mergeCells",
    get: function get() {
      return _.map(this.merges, function (merge) {
        return merge.range;
      });
    }
  }]);

  return Merges;
}();

module.exports = Merges;


},{"../../../doc/enums":8,"../../../doc/range":11,"../../../utils/col-cache":18,"../../../utils/under-dash":24}],70:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var BaseXform = require('../base-xform');

var isDefined = function isDefined(attr) {
  return typeof attr !== 'undefined';
};

var OutlinePropertiesXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(OutlinePropertiesXform, _BaseXform);

  function OutlinePropertiesXform() {
    _classCallCheck(this, OutlinePropertiesXform);

    return _possibleConstructorReturn(this, _getPrototypeOf(OutlinePropertiesXform).apply(this, arguments));
  }

  _createClass(OutlinePropertiesXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      if (model && (isDefined(model.summaryBelow) || isDefined(model.summaryRight))) {
        xmlStream.leafNode(this.tag, {
          summaryBelow: isDefined(model.summaryBelow) ? Number(model.summaryBelow) : undefined,
          summaryRight: isDefined(model.summaryRight) ? Number(model.summaryRight) : undefined
        });
        return true;
      }

      return false;
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (node.name === this.tag) {
        this.model = {
          summaryBelow: isDefined(node.attributes.summaryBelow) ? Boolean(Number(node.attributes.summaryBelow)) : undefined,
          summaryRight: isDefined(node.attributes.summaryRight) ? Boolean(Number(node.attributes.summaryRight)) : undefined
        };
        return true;
      }

      return false;
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose() {
      return false;
    }
  }, {
    key: "tag",
    get: function get() {
      return 'outlinePr';
    }
  }]);

  return OutlinePropertiesXform;
}(BaseXform);

module.exports = OutlinePropertiesXform;


},{"../base-xform":30}],71:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var BaseXform = require('../base-xform');

var PageBreaksXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(PageBreaksXform, _BaseXform);

  function PageBreaksXform() {
    _classCallCheck(this, PageBreaksXform);

    return _possibleConstructorReturn(this, _getPrototypeOf(PageBreaksXform).apply(this, arguments));
  }

  _createClass(PageBreaksXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.leafNode('brk', model);
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (node.name === 'brk') {
        this.model = node.attributes.ref;
        return true;
      }

      return false;
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose() {
      return false;
    }
  }, {
    key: "tag",
    get: function get() {
      return 'brk';
    }
  }]);

  return PageBreaksXform;
}(BaseXform);

module.exports = PageBreaksXform;


},{"../base-xform":30}],72:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var _ = require('../../../utils/under-dash');

var BaseXform = require('../base-xform');

var PageMarginsXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(PageMarginsXform, _BaseXform);

  function PageMarginsXform() {
    _classCallCheck(this, PageMarginsXform);

    return _possibleConstructorReturn(this, _getPrototypeOf(PageMarginsXform).apply(this, arguments));
  }

  _createClass(PageMarginsXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      if (model) {
        var attributes = {
          left: model.left,
          right: model.right,
          top: model.top,
          bottom: model.bottom,
          header: model.header,
          footer: model.footer
        };

        if (_.some(attributes, function (value) {
          return value !== undefined;
        })) {
          xmlStream.leafNode(this.tag, attributes);
        }
      }
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      switch (node.name) {
        case this.tag:
          this.model = {
            left: parseFloat(node.attributes.left || 0.7),
            right: parseFloat(node.attributes.right || 0.7),
            top: parseFloat(node.attributes.top || 0.75),
            bottom: parseFloat(node.attributes.bottom || 0.75),
            header: parseFloat(node.attributes.header || 0.3),
            footer: parseFloat(node.attributes.footer || 0.3)
          };
          return true;

        default:
          return false;
      }
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose() {
      return false;
    }
  }, {
    key: "tag",
    get: function get() {
      return 'pageMargins';
    }
  }]);

  return PageMarginsXform;
}(BaseXform);

module.exports = PageMarginsXform;


},{"../../../utils/under-dash":24,"../base-xform":30}],73:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var BaseXform = require('../base-xform');

var PageSetupPropertiesXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(PageSetupPropertiesXform, _BaseXform);

  function PageSetupPropertiesXform() {
    _classCallCheck(this, PageSetupPropertiesXform);

    return _possibleConstructorReturn(this, _getPrototypeOf(PageSetupPropertiesXform).apply(this, arguments));
  }

  _createClass(PageSetupPropertiesXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      if (model && model.fitToPage) {
        xmlStream.leafNode(this.tag, {
          fitToPage: model.fitToPage ? '1' : undefined
        });
        return true;
      }

      return false;
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (node.name === this.tag) {
        this.model = {
          fitToPage: node.attributes.fitToPage === '1'
        };
        return true;
      }

      return false;
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose() {
      return false;
    }
  }, {
    key: "tag",
    get: function get() {
      return 'pageSetUpPr';
    }
  }]);

  return PageSetupPropertiesXform;
}(BaseXform);

module.exports = PageSetupPropertiesXform;


},{"../base-xform":30}],74:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var _ = require('../../../utils/under-dash');

var BaseXform = require('../base-xform');

function booleanToXml(model) {
  return model ? '1' : undefined;
}

function pageOrderToXml(model) {
  switch (model) {
    case 'overThenDown':
      return model;

    default:
      return undefined;
  }
}

function cellCommentsToXml(model) {
  switch (model) {
    case 'atEnd':
    case 'asDisplyed':
      return model;

    default:
      return undefined;
  }
}

function errorsToXml(model) {
  switch (model) {
    case 'dash':
    case 'blank':
    case 'NA':
      return model;

    default:
      return undefined;
  }
}

function pageSizeToModel(value) {
  return value !== undefined ? parseInt(value, 10) : undefined;
}

var PageSetupXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(PageSetupXform, _BaseXform);

  function PageSetupXform() {
    _classCallCheck(this, PageSetupXform);

    return _possibleConstructorReturn(this, _getPrototypeOf(PageSetupXform).apply(this, arguments));
  }

  _createClass(PageSetupXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      if (model) {
        var attributes = {
          paperSize: model.paperSize,
          orientation: model.orientation,
          horizontalDpi: model.horizontalDpi,
          verticalDpi: model.verticalDpi,
          pageOrder: pageOrderToXml(model.pageOrder),
          blackAndWhite: booleanToXml(model.blackAndWhite),
          draft: booleanToXml(model.draft),
          cellComments: cellCommentsToXml(model.cellComments),
          errors: errorsToXml(model.errors),
          scale: model.scale,
          fitToWidth: model.fitToWidth,
          fitToHeight: model.fitToHeight,
          firstPageNumber: model.firstPageNumber,
          useFirstPageNumber: booleanToXml(model.firstPageNumber),
          usePrinterDefaults: booleanToXml(model.usePrinterDefaults),
          copies: model.copies
        };

        if (_.some(attributes, function (value) {
          return value !== undefined;
        })) {
          xmlStream.leafNode(this.tag, attributes);
        }
      }
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      switch (node.name) {
        case this.tag:
          this.model = {
            paperSize: pageSizeToModel(node.attributes.paperSize),
            orientation: node.attributes.orientation || 'portrait',
            horizontalDpi: parseInt(node.attributes.horizontalDpi || '4294967295', 10),
            verticalDpi: parseInt(node.attributes.verticalDpi || '4294967295', 10),
            pageOrder: node.attributes.pageOrder || 'downThenOver',
            blackAndWhite: node.attributes.blackAndWhite === '1',
            draft: node.attributes.draft === '1',
            cellComments: node.attributes.cellComments || 'None',
            errors: node.attributes.errors || 'displayed',
            scale: parseInt(node.attributes.scale || '100', 10),
            fitToWidth: parseInt(node.attributes.fitToWidth || '1', 10),
            fitToHeight: parseInt(node.attributes.fitToHeight || '1', 10),
            firstPageNumber: parseInt(node.attributes.firstPageNumber || '1', 10),
            useFirstPageNumber: node.attributes.useFirstPageNumber === '1',
            usePrinterDefaults: node.attributes.usePrinterDefaults === '1',
            copies: parseInt(node.attributes.copies || '1', 10)
          };
          return true;

        default:
          return false;
      }
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose() {
      return false;
    }
  }, {
    key: "tag",
    get: function get() {
      return 'pageSetup';
    }
  }]);

  return PageSetupXform;
}(BaseXform);

module.exports = PageSetupXform;


},{"../../../utils/under-dash":24,"../base-xform":30}],75:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var BaseXform = require('../base-xform');

var PictureXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(PictureXform, _BaseXform);

  function PictureXform() {
    _classCallCheck(this, PictureXform);

    return _possibleConstructorReturn(this, _getPrototypeOf(PictureXform).apply(this, arguments));
  }

  _createClass(PictureXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      if (model) {
        xmlStream.leafNode(this.tag, {
          'r:id': model.rId
        });
      }
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      switch (node.name) {
        case this.tag:
          this.model = {
            rId: node.attributes['r:id']
          };
          return true;

        default:
          return false;
      }
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose() {
      return false;
    }
  }, {
    key: "tag",
    get: function get() {
      return 'picture';
    }
  }]);

  return PictureXform;
}(BaseXform);

module.exports = PictureXform;


},{"../base-xform":30}],76:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var _ = require('../../../utils/under-dash');

var BaseXform = require('../base-xform');

function booleanToXml(model) {
  return model ? '1' : undefined;
}

var PrintOptionsXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(PrintOptionsXform, _BaseXform);

  function PrintOptionsXform() {
    _classCallCheck(this, PrintOptionsXform);

    return _possibleConstructorReturn(this, _getPrototypeOf(PrintOptionsXform).apply(this, arguments));
  }

  _createClass(PrintOptionsXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      if (model) {
        var attributes = {
          headings: booleanToXml(model.showRowColHeaders),
          gridLines: booleanToXml(model.showGridLines),
          horizontalCentered: booleanToXml(model.horizontalCentered),
          verticalCentered: booleanToXml(model.verticalCentered)
        };

        if (_.some(attributes, function (value) {
          return value !== undefined;
        })) {
          xmlStream.leafNode(this.tag, attributes);
        }
      }
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      switch (node.name) {
        case this.tag:
          this.model = {
            showRowColHeaders: node.attributes.headings === '1',
            showGridLines: node.attributes.gridLines === '1',
            horizontalCentered: node.attributes.horizontalCentered === '1',
            verticalCentered: node.attributes.verticalCentered === '1'
          };
          return true;

        default:
          return false;
      }
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose() {
      return false;
    }
  }, {
    key: "tag",
    get: function get() {
      return 'printOptions';
    }
  }]);

  return PrintOptionsXform;
}(BaseXform);

module.exports = PrintOptionsXform;


},{"../../../utils/under-dash":24,"../base-xform":30}],77:[function(require,module,exports){
'use strict';

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var PageBreaksXform = require('./page-breaks-xform');

var ListXform = require('../list-xform');

var RowBreaksXform =
/*#__PURE__*/
function (_ListXform) {
  _inherits(RowBreaksXform, _ListXform);

  function RowBreaksXform() {
    _classCallCheck(this, RowBreaksXform);

    var options = {
      tag: 'rowBreaks',
      count: true,
      childXform: new PageBreaksXform()
    };
    return _possibleConstructorReturn(this, _getPrototypeOf(RowBreaksXform).call(this, options));
  } // get tag() { return 'rowBreaks'; }


  _createClass(RowBreaksXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      if (model && model.length) {
        xmlStream.openNode(this.tag, this.$);

        if (this.count) {
          xmlStream.addAttribute(this.$count, model.length);
          xmlStream.addAttribute('manualBreakCount', model.length);
        }

        var childXform = this.childXform;
        model.forEach(function (childModel) {
          childXform.render(xmlStream, childModel);
        });
        xmlStream.closeNode();
      } else if (this.empty) {
        xmlStream.leafNode(this.tag);
      }
    }
  }]);

  return RowBreaksXform;
}(ListXform);

module.exports = RowBreaksXform;


},{"../list-xform":59,"./page-breaks-xform":71}],78:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var BaseXform = require('../base-xform');

var CellXform = require('./cell-xform');

var RowXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(RowXform, _BaseXform);

  function RowXform(options) {
    var _this;

    _classCallCheck(this, RowXform);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(RowXform).call(this));
    _this.maxItems = options && options.maxItems;
    _this.map = {
      c: new CellXform()
    };
    return _this;
  }

  _createClass(RowXform, [{
    key: "prepare",
    value: function prepare(model, options) {
      var styleId = options.styles.addStyleModel(model.style);

      if (styleId) {
        model.styleId = styleId;
      }

      var cellXform = this.map.c;
      model.cells.forEach(function (cellModel) {
        cellXform.prepare(cellModel, options);
      });
    }
  }, {
    key: "render",
    value: function render(xmlStream, model, options) {
      xmlStream.openNode('row');
      xmlStream.addAttribute('r', model.number);

      if (model.height) {
        xmlStream.addAttribute('ht', model.height);
        xmlStream.addAttribute('customHeight', '1');
      }

      if (model.hidden) {
        xmlStream.addAttribute('hidden', '1');
      }

      if (model.min > 0 && model.max > 0 && model.min <= model.max) {
        xmlStream.addAttribute('spans', "".concat(model.min, ":").concat(model.max));
      }

      if (model.styleId) {
        xmlStream.addAttribute('s', model.styleId);
        xmlStream.addAttribute('customFormat', '1');
      }

      xmlStream.addAttribute('x14ac:dyDescent', '0.25');

      if (model.outlineLevel) {
        xmlStream.addAttribute('outlineLevel', model.outlineLevel);
      }

      if (model.collapsed) {
        xmlStream.addAttribute('collapsed', '1');
      }

      var cellXform = this.map.c;
      model.cells.forEach(function (cellModel) {
        cellXform.render(xmlStream, cellModel, options);
      });
      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      if (node.name === 'row') {
        this.numRowsSeen += 1;
        var spans = node.attributes.spans ? node.attributes.spans.split(':').map(function (span) {
          return parseInt(span, 10);
        }) : [undefined, undefined];
        var model = this.model = {
          number: parseInt(node.attributes.r, 10),
          min: spans[0],
          max: spans[1],
          cells: []
        };

        if (node.attributes.s) {
          model.styleId = parseInt(node.attributes.s, 10);
        }

        if (node.attributes.hidden) {
          model.hidden = true;
        }

        if (node.attributes.bestFit) {
          model.bestFit = true;
        }

        if (node.attributes.ht) {
          model.height = parseFloat(node.attributes.ht);
        }

        if (node.attributes.outlineLevel) {
          model.outlineLevel = parseInt(node.attributes.outlineLevel, 10);
        }

        if (node.attributes.collapsed) {
          model.collapsed = true;
        }

        return true;
      }

      this.parser = this.map[node.name];

      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      return false;
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      if (this.parser) {
        this.parser.parseText(text);
      }
    }
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      if (this.parser) {
        if (!this.parser.parseClose(name)) {
          this.model.cells.push(this.parser.model);

          if (this.maxItems && this.model.cells.length > this.maxItems) {
            throw new Error('Max column count exceeded');
          }

          this.parser = undefined;
        }

        return true;
      }

      return false;
    }
  }, {
    key: "reconcile",
    value: function reconcile(model, options) {
      model.style = model.styleId ? options.styles.getStyleModel(model.styleId) : {};

      if (model.styleId !== undefined) {
        model.styleId = undefined;
      }

      var cellXform = this.map.c;
      model.cells.forEach(function (cellModel) {
        cellXform.reconcile(cellModel, options);
      });
    }
  }, {
    key: "tag",
    get: function get() {
      return 'row';
    }
  }]);

  return RowXform;
}(BaseXform);

module.exports = RowXform;


},{"../base-xform":30,"./cell-xform":61}],79:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var _ = require('../../../utils/under-dash');

var BaseXform = require('../base-xform');

var SheetFormatPropertiesXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(SheetFormatPropertiesXform, _BaseXform);

  function SheetFormatPropertiesXform() {
    _classCallCheck(this, SheetFormatPropertiesXform);

    return _possibleConstructorReturn(this, _getPrototypeOf(SheetFormatPropertiesXform).apply(this, arguments));
  }

  _createClass(SheetFormatPropertiesXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      if (model) {
        var attributes = {
          defaultRowHeight: model.defaultRowHeight,
          outlineLevelRow: model.outlineLevelRow,
          outlineLevelCol: model.outlineLevelCol,
          'x14ac:dyDescent': model.dyDescent
        }; // default value for 'defaultRowHeight' is 15, this should not be 'custom'

        if (!model.defaultRowHeight || model.defaultRowHeight !== 15) {
          attributes.customHeight = '1';
        }

        if (_.some(attributes, function (value) {
          return value !== undefined;
        })) {
          xmlStream.leafNode('sheetFormatPr', attributes);
        }
      }
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (node.name === 'sheetFormatPr') {
        this.model = {
          defaultRowHeight: parseFloat(node.attributes.defaultRowHeight || '0'),
          dyDescent: parseFloat(node.attributes['x14ac:dyDescent'] || '0'),
          outlineLevelRow: parseInt(node.attributes.outlineLevelRow || '0', 10),
          outlineLevelCol: parseInt(node.attributes.outlineLevelCol || '0', 10)
        };
        return true;
      }

      return false;
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose() {
      return false;
    }
  }, {
    key: "tag",
    get: function get() {
      return 'sheetFormatPr';
    }
  }]);

  return SheetFormatPropertiesXform;
}(BaseXform);

module.exports = SheetFormatPropertiesXform;


},{"../../../utils/under-dash":24,"../base-xform":30}],80:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var BaseXform = require('../base-xform');

var ColorXform = require('../style/color-xform');

var PageSetupPropertiesXform = require('./page-setup-properties-xform');

var OutlinePropertiesXform = require('./outline-properties-xform');

var SheetPropertiesXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(SheetPropertiesXform, _BaseXform);

  function SheetPropertiesXform() {
    var _this;

    _classCallCheck(this, SheetPropertiesXform);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(SheetPropertiesXform).call(this));
    _this.map = {
      tabColor: new ColorXform('tabColor'),
      pageSetUpPr: new PageSetupPropertiesXform(),
      outlinePr: new OutlinePropertiesXform()
    };
    return _this;
  }

  _createClass(SheetPropertiesXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      if (model) {
        xmlStream.addRollback();
        xmlStream.openNode('sheetPr');
        var inner = false;
        inner = this.map.tabColor.render(xmlStream, model.tabColor) || inner;
        inner = this.map.pageSetUpPr.render(xmlStream, model.pageSetup) || inner;
        inner = this.map.outlinePr.render(xmlStream, model.outlineProperties) || inner;

        if (inner) {
          xmlStream.closeNode();
          xmlStream.commit();
        } else {
          xmlStream.rollback();
        }
      }
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      if (node.name === this.tag) {
        this.reset();
        return true;
      }

      if (this.map[node.name]) {
        this.parser = this.map[node.name];
        this.parser.parseOpen(node);
        return true;
      }

      return false;
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      if (this.parser) {
        this.parser.parseText(text);
        return true;
      }

      return false;
    }
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      if (this.parser) {
        if (!this.parser.parseClose(name)) {
          this.parser = undefined;
        }

        return true;
      }

      if (this.map.tabColor.model || this.map.pageSetUpPr.model || this.map.outlinePr.model) {
        this.model = {};

        if (this.map.tabColor.model) {
          this.model.tabColor = this.map.tabColor.model;
        }

        if (this.map.pageSetUpPr.model) {
          this.model.pageSetup = this.map.pageSetUpPr.model;
        }

        if (this.map.outlinePr.model) {
          this.model.outlineProperties = this.map.outlinePr.model;
        }
      } else {
        this.model = null;
      }

      return false;
    }
  }, {
    key: "tag",
    get: function get() {
      return 'sheetPr';
    }
  }]);

  return SheetPropertiesXform;
}(BaseXform);

module.exports = SheetPropertiesXform;


},{"../base-xform":30,"../style/color-xform":97,"./outline-properties-xform":70,"./page-setup-properties-xform":73}],81:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var _ = require('../../../utils/under-dash');

var BaseXform = require('../base-xform');

function booleanToXml(model, value) {
  return model ? value : undefined;
}

function xmlToBoolean(value, equals) {
  return value === equals ? true : undefined;
}

var SheetProtectionXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(SheetProtectionXform, _BaseXform);

  function SheetProtectionXform() {
    _classCallCheck(this, SheetProtectionXform);

    return _possibleConstructorReturn(this, _getPrototypeOf(SheetProtectionXform).apply(this, arguments));
  }

  _createClass(SheetProtectionXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      if (model) {
        var attributes = {
          sheet: booleanToXml(model.sheet, '1'),
          selectLockedCells: model.selectLockedCells === false ? '1' : undefined,
          selectUnlockedCells: model.selectUnlockedCells === false ? '1' : undefined,
          formatCells: booleanToXml(model.formatCells, '0'),
          formatColumns: booleanToXml(model.formatColumns, '0'),
          formatRows: booleanToXml(model.formatRows, '0'),
          insertColumns: booleanToXml(model.insertColumns, '0'),
          insertRows: booleanToXml(model.insertRows, '0'),
          insertHyperlinks: booleanToXml(model.insertHyperlinks, '0'),
          deleteColumns: booleanToXml(model.deleteColumns, '0'),
          deleteRows: booleanToXml(model.deleteRows, '0'),
          sort: booleanToXml(model.sort, '0'),
          autoFilter: booleanToXml(model.autoFilter, '0'),
          pivotTables: booleanToXml(model.pivotTables, '0')
        };

        if (model.sheet) {
          attributes.algorithmName = model.algorithmName;
          attributes.hashValue = model.hashValue;
          attributes.saltValue = model.saltValue;
          attributes.spinCount = model.spinCount;
          attributes.objects = booleanToXml(model.objects === false, '1');
          attributes.scenarios = booleanToXml(model.scenarios === false, '1');
        }

        if (_.some(attributes, function (value) {
          return value !== undefined;
        })) {
          xmlStream.leafNode(this.tag, attributes);
        }
      }
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      switch (node.name) {
        case this.tag:
          this.model = {
            sheet: xmlToBoolean(node.attributes.sheet, '1'),
            objects: node.attributes.objects === '1' ? false : undefined,
            scenarios: node.attributes.scenarios === '1' ? false : undefined,
            selectLockedCells: node.attributes.selectLockedCells === '1' ? false : undefined,
            selectUnlockedCells: node.attributes.selectUnlockedCells === '1' ? false : undefined,
            formatCells: xmlToBoolean(node.attributes.formatCells, '0'),
            formatColumns: xmlToBoolean(node.attributes.formatColumns, '0'),
            formatRows: xmlToBoolean(node.attributes.formatRows, '0'),
            insertColumns: xmlToBoolean(node.attributes.insertColumns, '0'),
            insertRows: xmlToBoolean(node.attributes.insertRows, '0'),
            insertHyperlinks: xmlToBoolean(node.attributes.insertHyperlinks, '0'),
            deleteColumns: xmlToBoolean(node.attributes.deleteColumns, '0'),
            deleteRows: xmlToBoolean(node.attributes.deleteRows, '0'),
            sort: xmlToBoolean(node.attributes.sort, '0'),
            autoFilter: xmlToBoolean(node.attributes.autoFilter, '0'),
            pivotTables: xmlToBoolean(node.attributes.pivotTables, '0')
          };

          if (node.attributes.algorithmName) {
            this.model.algorithmName = node.attributes.algorithmName;
            this.model.hashValue = node.attributes.hashValue;
            this.model.saltValue = node.attributes.saltValue;
            this.model.spinCount = parseInt(node.attributes.spinCount, 10);
          }

          return true;

        default:
          return false;
      }
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose() {
      return false;
    }
  }, {
    key: "tag",
    get: function get() {
      return 'sheetProtection';
    }
  }]);

  return SheetProtectionXform;
}(BaseXform);

module.exports = SheetProtectionXform;


},{"../../../utils/under-dash":24,"../base-xform":30}],82:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var colCache = require('../../../utils/col-cache');

var BaseXform = require('../base-xform');

var VIEW_STATES = {
  frozen: 'frozen',
  frozenSplit: 'frozen',
  split: 'split'
};

var SheetViewXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(SheetViewXform, _BaseXform);

  function SheetViewXform() {
    _classCallCheck(this, SheetViewXform);

    return _possibleConstructorReturn(this, _getPrototypeOf(SheetViewXform).apply(this, arguments));
  }

  _createClass(SheetViewXform, [{
    key: "prepare",
    value: function prepare(model) {
      switch (model.state) {
        case 'frozen':
        case 'split':
          break;

        default:
          model.state = 'normal';
          break;
      }
    }
  }, {
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.openNode('sheetView', {
        workbookViewId: model.workbookViewId || 0
      });

      var add = function add(name, value, included) {
        if (included) {
          xmlStream.addAttribute(name, value);
        }
      };

      add('rightToLeft', '1', model.rightToLeft === true);
      add('tabSelected', '1', model.tabSelected);
      add('showRuler', '0', model.showRuler === false);
      add('showRowColHeaders', '0', model.showRowColHeaders === false);
      add('showGridLines', '0', model.showGridLines === false);
      add('zoomScale', model.zoomScale, model.zoomScale);
      add('zoomScaleNormal', model.zoomScaleNormal, model.zoomScaleNormal);
      add('view', model.style, model.style);
      var topLeftCell;
      var xSplit;
      var ySplit;
      var activePane;

      switch (model.state) {
        case 'frozen':
          xSplit = model.xSplit || 0;
          ySplit = model.ySplit || 0;
          topLeftCell = model.topLeftCell || colCache.getAddress(ySplit + 1, xSplit + 1).address;
          activePane = model.xSplit && model.ySplit && 'bottomRight' || model.xSplit && 'topRight' || 'bottomLeft';
          xmlStream.leafNode('pane', {
            xSplit: model.xSplit || undefined,
            ySplit: model.ySplit || undefined,
            topLeftCell: topLeftCell,
            activePane: activePane,
            state: 'frozen'
          });
          xmlStream.leafNode('selection', {
            pane: activePane,
            activeCell: model.activeCell,
            sqref: model.activeCell
          });
          break;

        case 'split':
          if (model.activePane === 'topLeft') {
            model.activePane = undefined;
          }

          xmlStream.leafNode('pane', {
            xSplit: model.xSplit || undefined,
            ySplit: model.ySplit || undefined,
            topLeftCell: model.topLeftCell,
            activePane: model.activePane
          });
          xmlStream.leafNode('selection', {
            pane: model.activePane,
            activeCell: model.activeCell,
            sqref: model.activeCell
          });
          break;

        case 'normal':
          if (model.activeCell) {
            xmlStream.leafNode('selection', {
              activeCell: model.activeCell,
              sqref: model.activeCell
            });
          }

          break;

        default:
          break;
      }

      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      switch (node.name) {
        case 'sheetView':
          this.sheetView = {
            workbookViewId: parseInt(node.attributes.workbookViewId, 10),
            rightToLeft: node.attributes.rightToLeft === '1',
            tabSelected: node.attributes.tabSelected === '1',
            showRuler: !(node.attributes.showRuler === '0'),
            showRowColHeaders: !(node.attributes.showRowColHeaders === '0'),
            showGridLines: !(node.attributes.showGridLines === '0'),
            zoomScale: parseInt(node.attributes.zoomScale || '100', 10),
            zoomScaleNormal: parseInt(node.attributes.zoomScaleNormal || '100', 10),
            style: node.attributes.view
          };
          this.pane = undefined;
          this.selections = {};
          return true;

        case 'pane':
          this.pane = {
            xSplit: parseInt(node.attributes.xSplit || '0', 10),
            ySplit: parseInt(node.attributes.ySplit || '0', 10),
            topLeftCell: node.attributes.topLeftCell,
            activePane: node.attributes.activePane || 'topLeft',
            state: node.attributes.state
          };
          return true;

        case 'selection':
          {
            var name = node.attributes.pane || 'topLeft';
            this.selections[name] = {
              pane: name,
              activeCell: node.attributes.activeCell
            };
            return true;
          }

        default:
          return false;
      }
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      var model;
      var selection;

      switch (name) {
        case 'sheetView':
          if (this.sheetView && this.pane) {
            model = this.model = {
              workbookViewId: this.sheetView.workbookViewId,
              rightToLeft: this.sheetView.rightToLeft,
              state: VIEW_STATES[this.pane.state] || 'split',
              // split is default
              xSplit: this.pane.xSplit,
              ySplit: this.pane.ySplit,
              topLeftCell: this.pane.topLeftCell,
              showRuler: this.sheetView.showRuler,
              showRowColHeaders: this.sheetView.showRowColHeaders,
              showGridLines: this.sheetView.showGridLines,
              zoomScale: this.sheetView.zoomScale,
              zoomScaleNormal: this.sheetView.zoomScaleNormal
            };

            if (this.model.state === 'split') {
              model.activePane = this.pane.activePane;
            }

            selection = this.selections[this.pane.activePane];

            if (selection && selection.activeCell) {
              model.activeCell = selection.activeCell;
            }

            if (this.sheetView.style) {
              model.style = this.sheetView.style;
            }
          } else {
            model = this.model = {
              workbookViewId: this.sheetView.workbookViewId,
              rightToLeft: this.sheetView.rightToLeft,
              state: 'normal',
              showRuler: this.sheetView.showRuler,
              showRowColHeaders: this.sheetView.showRowColHeaders,
              showGridLines: this.sheetView.showGridLines,
              zoomScale: this.sheetView.zoomScale,
              zoomScaleNormal: this.sheetView.zoomScaleNormal
            };
            selection = this.selections.topLeft;

            if (selection && selection.activeCell) {
              model.activeCell = selection.activeCell;
            }

            if (this.sheetView.style) {
              model.style = this.sheetView.style;
            }
          }

          return false;

        default:
          return true;
      }
    }
  }, {
    key: "reconcile",
    value: function reconcile() {}
  }, {
    key: "tag",
    get: function get() {
      return 'sheetView';
    }
  }]);

  return SheetViewXform;
}(BaseXform);

module.exports = SheetViewXform;


},{"../../../utils/col-cache":18,"../base-xform":30}],83:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var BaseXform = require('../base-xform');

var TablePartXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(TablePartXform, _BaseXform);

  function TablePartXform() {
    _classCallCheck(this, TablePartXform);

    return _possibleConstructorReturn(this, _getPrototypeOf(TablePartXform).apply(this, arguments));
  }

  _createClass(TablePartXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      if (model) {
        xmlStream.leafNode(this.tag, {
          'r:id': model.rId
        });
      }
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      switch (node.name) {
        case this.tag:
          this.model = {
            rId: node.attributes['r:id']
          };
          return true;

        default:
          return false;
      }
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose() {
      return false;
    }
  }, {
    key: "tag",
    get: function get() {
      return 'tablePart';
    }
  }]);

  return TablePartXform;
}(BaseXform);

module.exports = TablePartXform;


},{"../base-xform":30}],84:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var _ = require('../../../utils/under-dash');

var colCache = require('../../../utils/col-cache');

var XmlStream = require('../../../utils/xml-stream');

var RelType = require('../../rel-type');

var Merges = require('./merges');

var BaseXform = require('../base-xform');

var ListXform = require('../list-xform');

var RowXform = require('./row-xform');

var ColXform = require('./col-xform');

var DimensionXform = require('./dimension-xform');

var HyperlinkXform = require('./hyperlink-xform');

var MergeCellXform = require('./merge-cell-xform');

var DataValidationsXform = require('./data-validations-xform');

var SheetPropertiesXform = require('./sheet-properties-xform');

var SheetFormatPropertiesXform = require('./sheet-format-properties-xform');

var SheetViewXform = require('./sheet-view-xform');

var SheetProtectionXform = require('./sheet-protection-xform');

var PageMarginsXform = require('./page-margins-xform');

var PageSetupXform = require('./page-setup-xform');

var PrintOptionsXform = require('./print-options-xform');

var AutoFilterXform = require('./auto-filter-xform');

var PictureXform = require('./picture-xform');

var DrawingXform = require('./drawing-xform');

var TablePartXform = require('./table-part-xform');

var RowBreaksXform = require('./row-breaks-xform');

var HeaderFooterXform = require('./header-footer-xform');

var WorkSheetXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(WorkSheetXform, _BaseXform);

  function WorkSheetXform(options) {
    var _this;

    _classCallCheck(this, WorkSheetXform);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(WorkSheetXform).call(this));

    var _ref = options || {},
        maxRows = _ref.maxRows,
        maxCols = _ref.maxCols;

    _this.map = {
      sheetPr: new SheetPropertiesXform(),
      dimension: new DimensionXform(),
      sheetViews: new ListXform({
        tag: 'sheetViews',
        count: false,
        childXform: new SheetViewXform()
      }),
      sheetFormatPr: new SheetFormatPropertiesXform(),
      cols: new ListXform({
        tag: 'cols',
        count: false,
        childXform: new ColXform()
      }),
      sheetData: new ListXform({
        tag: 'sheetData',
        count: false,
        empty: true,
        childXform: new RowXform({
          maxItems: maxCols
        }),
        maxItems: maxRows
      }),
      autoFilter: new AutoFilterXform(),
      mergeCells: new ListXform({
        tag: 'mergeCells',
        count: true,
        childXform: new MergeCellXform()
      }),
      rowBreaks: new RowBreaksXform(),
      hyperlinks: new ListXform({
        tag: 'hyperlinks',
        count: false,
        childXform: new HyperlinkXform()
      }),
      pageMargins: new PageMarginsXform(),
      dataValidations: new DataValidationsXform(),
      pageSetup: new PageSetupXform(),
      headerFooter: new HeaderFooterXform(),
      printOptions: new PrintOptionsXform(),
      picture: new PictureXform(),
      drawing: new DrawingXform(),
      sheetProtection: new SheetProtectionXform(),
      tableParts: new ListXform({
        tag: 'tableParts',
        count: true,
        childXform: new TablePartXform()
      })
    };
    return _this;
  }

  _createClass(WorkSheetXform, [{
    key: "prepare",
    value: function prepare(model, options) {
      options.merges = new Merges();
      model.hyperlinks = options.hyperlinks = [];
      model.comments = options.comments = [];
      options.formulae = {};
      options.siFormulae = 0;
      this.map.cols.prepare(model.cols, options);
      this.map.sheetData.prepare(model.rows, options);
      model.mergeCells = options.merges.mergeCells; // prepare relationships

      var rels = model.rels = [];

      function nextRid(r) {
        return "rId".concat(r.length + 1);
      }

      model.hyperlinks.forEach(function (hyperlink) {
        var rId = nextRid(rels);
        hyperlink.rId = rId;
        rels.push({
          Id: rId,
          Type: RelType.Hyperlink,
          Target: hyperlink.target,
          TargetMode: 'External'
        });
      }); // prepare comment relationships

      if (model.comments.length > 0) {
        var comment = {
          Id: nextRid(rels),
          Type: RelType.Comments,
          Target: "../comments".concat(model.id, ".xml")
        };
        rels.push(comment);
        var vmlDrawing = {
          Id: nextRid(rels),
          Type: RelType.VmlDrawing,
          Target: "../drawings/vmlDrawing".concat(model.id, ".vml")
        };
        rels.push(vmlDrawing);
        model.comments.forEach(function (item) {
          item.refAddress = colCache.decodeAddress(item.ref);
        });
        options.commentRefs.push({
          commentName: "comments".concat(model.id),
          vmlDrawing: "vmlDrawing".concat(model.id)
        });
      }

      var drawingRelsHash = [];
      var bookImage;
      model.media.forEach(function (medium) {
        if (medium.type === 'background') {
          var rId = nextRid(rels);
          bookImage = options.media[medium.imageId];
          rels.push({
            Id: rId,
            Type: RelType.Image,
            Target: "../media/".concat(bookImage.name, ".").concat(bookImage.extension)
          });
          model.background = {
            rId: rId
          };
          model.image = options.media[medium.imageId];
        } else if (medium.type === 'image') {
          var drawing = model.drawing;
          bookImage = options.media[medium.imageId];

          if (!drawing) {
            drawing = model.drawing = {
              rId: nextRid(rels),
              name: "drawing".concat(++options.drawingsCount),
              anchors: [],
              rels: []
            };
            options.drawings.push(drawing);
            rels.push({
              Id: drawing.rId,
              Type: 'http://schemas.openxmlformats.org/officeDocument/2006/relationships/drawing',
              Target: "../drawings/".concat(drawing.name, ".xml")
            });
          }

          var rIdImage = drawingRelsHash[medium.imageId];

          if (!rIdImage) {
            rIdImage = nextRid(drawing.rels);
            drawingRelsHash[medium.imageId] = rIdImage;
            drawing.rels.push({
              Id: rIdImage,
              Type: 'http://schemas.openxmlformats.org/officeDocument/2006/relationships/image',
              Target: "../media/".concat(bookImage.name, ".").concat(bookImage.extension)
            });
          }

          drawing.anchors.push({
            picture: {
              rId: rIdImage
            },
            range: medium.range
          });
        }
      }); // prepare tables

      model.tables.forEach(function (table) {
        // relationships
        var rId = nextRid(rels);
        table.rId = rId;
        rels.push({
          Id: rId,
          Type: RelType.Table,
          Target: "../tables/".concat(table.target)
        }); // dynamic styles

        table.columns.forEach(function (column) {
          var style = column.style;

          if (style) {
            column.dxfId = options.styles.addDxfStyle(style);
          }
        });
      });
    }
  }, {
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.openXml(XmlStream.StdDocAttributes);
      xmlStream.openNode('worksheet', WorkSheetXform.WORKSHEET_ATTRIBUTES);
      var sheetFormatPropertiesModel = model.properties ? {
        defaultRowHeight: model.properties.defaultRowHeight,
        dyDescent: model.properties.dyDescent,
        outlineLevelCol: model.properties.outlineLevelCol,
        outlineLevelRow: model.properties.outlineLevelRow
      } : undefined;
      var sheetPropertiesModel = {
        outlineProperties: model.properties && model.properties.outlineProperties,
        tabColor: model.properties && model.properties.tabColor,
        pageSetup: model.pageSetup && model.pageSetup.fitToPage ? {
          fitToPage: model.pageSetup.fitToPage
        } : undefined
      };
      var pageMarginsModel = model.pageSetup && model.pageSetup.margins;
      var printOptionsModel = {
        showRowColHeaders: model.showRowColHeaders,
        showGridLines: model.showGridLines,
        horizontalCentered: model.horizontalCentered,
        verticalCentered: model.verticalCentered
      };
      var sheetProtectionModel = model.sheetProtection;
      this.map.sheetPr.render(xmlStream, sheetPropertiesModel);
      this.map.dimension.render(xmlStream, model.dimensions);
      this.map.sheetViews.render(xmlStream, model.views);
      this.map.sheetFormatPr.render(xmlStream, sheetFormatPropertiesModel);
      this.map.cols.render(xmlStream, model.cols);
      this.map.sheetData.render(xmlStream, model.rows);
      this.map.sheetProtection.render(xmlStream, sheetProtectionModel); // Note: must be after sheetData and before autoFilter

      this.map.autoFilter.render(xmlStream, model.autoFilter);
      this.map.mergeCells.render(xmlStream, model.mergeCells);
      this.map.dataValidations.render(xmlStream, model.dataValidations); // For some reason hyperlinks have to be after the data validations

      this.map.hyperlinks.render(xmlStream, model.hyperlinks);
      this.map.pageMargins.render(xmlStream, pageMarginsModel);
      this.map.printOptions.render(xmlStream, printOptionsModel);
      this.map.pageSetup.render(xmlStream, model.pageSetup);
      this.map.headerFooter.render(xmlStream, model.headerFooter);
      this.map.rowBreaks.render(xmlStream, model.rowBreaks);
      this.map.drawing.render(xmlStream, model.drawing); // Note: must be after rowBreaks

      this.map.picture.render(xmlStream, model.background); // Note: must be after drawing

      this.map.tableParts.render(xmlStream, model.tables);

      if (model.rels) {
        // add a <legacyDrawing /> node for each comment
        model.rels.forEach(function (rel) {
          if (rel.Type === RelType.VmlDrawing) {
            xmlStream.leafNode('legacyDrawing', {
              'r:id': rel.Id
            });
          }
        });
      }

      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      if (node.name === 'worksheet') {
        _.each(this.map, function (xform) {
          xform.reset();
        });

        return true;
      }

      this.parser = this.map[node.name];

      if (this.parser) {
        this.parser.parseOpen(node);
      }

      return true;
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      if (this.parser) {
        this.parser.parseText(text);
      }
    }
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      if (this.parser) {
        if (!this.parser.parseClose(name)) {
          this.parser = undefined;
        }

        return true;
      }

      switch (name) {
        case 'worksheet':
          {
            var properties = this.map.sheetFormatPr.model;

            if (this.map.sheetPr.model && this.map.sheetPr.model.tabColor) {
              properties.tabColor = this.map.sheetPr.model.tabColor;
            }

            if (this.map.sheetPr.model && this.map.sheetPr.model.outlineProperties) {
              properties.outlineProperties = this.map.sheetPr.model.outlinePropertiesx;
            }

            var sheetProperties = {
              fitToPage: this.map.sheetPr.model && this.map.sheetPr.model.pageSetup && this.map.sheetPr.model.pageSetup.fitToPage || false,
              margins: this.map.pageMargins.model
            };
            var pageSetup = Object.assign(sheetProperties, this.map.pageSetup.model, this.map.printOptions.model);
            this.model = {
              dimensions: this.map.dimension.model,
              cols: this.map.cols.model,
              rows: this.map.sheetData.model,
              mergeCells: this.map.mergeCells.model,
              hyperlinks: this.map.hyperlinks.model,
              dataValidations: this.map.dataValidations.model,
              properties: properties,
              views: this.map.sheetViews.model,
              pageSetup: pageSetup,
              background: this.map.picture.model,
              drawing: this.map.drawing.model,
              tables: this.map.tableParts.model
            };

            if (this.map.autoFilter.model) {
              this.model.autoFilter = this.map.autoFilter.model;
            }

            if (this.map.sheetProtection.model) {
              this.model.sheetProtection = this.map.sheetProtection.model;
            }

            return false;
          }

        default:
          // not quite sure how we get here!
          return true;
      }
    }
  }, {
    key: "reconcile",
    value: function reconcile(model, options) {
      // options.merges = new Merges();
      // options.merges.reconcile(model.mergeCells, model.rows);
      var rels = (model.relationships || []).reduce(function (h, rel) {
        h[rel.Id] = rel;

        if (rel.Type === RelType.Comments) {
          model.comments = options.comments[rel.Target].comments;
        }

        return h;
      }, {});
      options.commentsMap = (model.comments || []).reduce(function (h, comment) {
        if (comment.ref) {
          h[comment.ref] = comment;
        }

        return h;
      }, {});
      options.hyperlinkMap = (model.hyperlinks || []).reduce(function (h, hyperlink) {
        if (hyperlink.rId) {
          h[hyperlink.address] = rels[hyperlink.rId].Target;
        }

        return h;
      }, {});
      options.formulae = {}; // compact the rows and cells

      model.rows = model.rows && model.rows.filter(Boolean) || [];
      model.rows.forEach(function (row) {
        row.cells = row.cells && row.cells.filter(Boolean) || [];
      });
      this.map.cols.reconcile(model.cols, options);
      this.map.sheetData.reconcile(model.rows, options);
      model.media = [];

      if (model.drawing) {
        var drawingRel = rels[model.drawing.rId];
        var match = drawingRel.Target.match(/\/drawings\/([a-zA-Z0-9]+)[.][a-zA-Z]{3,4}$/);

        if (match) {
          var drawingName = match[1];
          var drawing = options.drawings[drawingName];
          drawing.anchors.forEach(function (anchor) {
            if (anchor.medium) {
              var image = {
                type: 'image',
                imageId: anchor.medium.index,
                range: anchor.range
              };
              model.media.push(image);
            }
          });
        }
      }

      var backgroundRel = model.background && rels[model.background.rId];

      if (backgroundRel) {
        var target = backgroundRel.Target.split('/media/')[1];
        var imageId = options.mediaIndex && options.mediaIndex[target];

        if (imageId !== undefined) {
          model.media.push({
            type: 'background',
            imageId: imageId
          });
        }
      }

      model.tables = (model.tables || []).map(function (tablePart) {
        var rel = rels[tablePart.rId];
        return options.tables[rel.Target];
      });
      delete model.relationships;
      delete model.hyperlinks;
      delete model.comments;
    }
  }]);

  return WorkSheetXform;
}(BaseXform);

WorkSheetXform.WORKSHEET_ATTRIBUTES = {
  xmlns: 'http://schemas.openxmlformats.org/spreadsheetml/2006/main',
  'xmlns:r': 'http://schemas.openxmlformats.org/officeDocument/2006/relationships',
  'xmlns:mc': 'http://schemas.openxmlformats.org/markup-compatibility/2006',
  'mc:Ignorable': 'x14ac',
  'xmlns:x14ac': 'http://schemas.microsoft.com/office/spreadsheetml/2009/9/ac'
};
module.exports = WorkSheetXform;


},{"../../../utils/col-cache":18,"../../../utils/under-dash":24,"../../../utils/xml-stream":26,"../../rel-type":29,"../base-xform":30,"../list-xform":59,"./auto-filter-xform":60,"./col-xform":62,"./data-validations-xform":63,"./dimension-xform":64,"./drawing-xform":65,"./header-footer-xform":66,"./hyperlink-xform":67,"./merge-cell-xform":68,"./merges":69,"./page-margins-xform":72,"./page-setup-xform":74,"./picture-xform":75,"./print-options-xform":76,"./row-breaks-xform":77,"./row-xform":78,"./sheet-format-properties-xform":79,"./sheet-properties-xform":80,"./sheet-protection-xform":81,"./sheet-view-xform":82,"./table-part-xform":83}],85:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var BaseXform = require('../base-xform');

var BooleanXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(BooleanXform, _BaseXform);

  function BooleanXform(options) {
    var _this;

    _classCallCheck(this, BooleanXform);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(BooleanXform).call(this));
    _this.tag = options.tag;
    _this.attr = options.attr;
    return _this;
  }

  _createClass(BooleanXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      if (model) {
        xmlStream.openNode(this.tag);
        xmlStream.closeNode();
      }
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (node.name === this.tag) {
        this.model = true;
      }
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose() {
      return false;
    }
  }]);

  return BooleanXform;
}(BaseXform);

module.exports = BooleanXform;


},{"../base-xform":30}],86:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var BaseXform = require('../base-xform');

var DateXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(DateXform, _BaseXform);

  function DateXform(options) {
    var _this;

    _classCallCheck(this, DateXform);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(DateXform).call(this));
    _this.tag = options.tag;
    _this.attr = options.attr;
    _this.attrs = options.attrs;

    _this._format = options.format || function (dt) {
      try {
        if (Number.isNaN(dt.getTime())) return '';
        return dt.toISOString();
      } catch (e) {
        return '';
      }
    };

    _this._parse = options.parse || function (str) {
      return new Date(str);
    };

    return _this;
  }

  _createClass(DateXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      if (model) {
        xmlStream.openNode(this.tag);

        if (this.attrs) {
          xmlStream.addAttributes(this.attrs);
        }

        if (this.attr) {
          xmlStream.addAttribute(this.attr, this._format(model));
        } else {
          xmlStream.writeText(this._format(model));
        }

        xmlStream.closeNode();
      }
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (node.name === this.tag) {
        if (this.attr) {
          this.model = this._parse(node.attributes[this.attr]);
        } else {
          this.text = [];
        }
      }
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      if (!this.attr) {
        this.text.push(text);
      }
    }
  }, {
    key: "parseClose",
    value: function parseClose() {
      if (!this.attr) {
        this.model = this._parse(this.text.join(''));
      }

      return false;
    }
  }]);

  return DateXform;
}(BaseXform);

module.exports = DateXform;


},{"../base-xform":30}],87:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var BaseXform = require('../base-xform');

var IntegerXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(IntegerXform, _BaseXform);

  function IntegerXform(options) {
    var _this;

    _classCallCheck(this, IntegerXform);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(IntegerXform).call(this));
    _this.tag = options.tag;
    _this.attr = options.attr;
    _this.attrs = options.attrs; // option to render zero

    _this.zero = options.zero;
    return _this;
  }

  _createClass(IntegerXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      // int is different to float in that zero is not rendered
      if (model || this.zero) {
        xmlStream.openNode(this.tag);

        if (this.attrs) {
          xmlStream.addAttributes(this.attrs);
        }

        if (this.attr) {
          xmlStream.addAttribute(this.attr, model);
        } else {
          xmlStream.writeText(model);
        }

        xmlStream.closeNode();
      }
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (node.name === this.tag) {
        if (this.attr) {
          this.model = parseInt(node.attributes[this.attr], 10);
        } else {
          this.text = [];
        }

        return true;
      }

      return false;
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      if (!this.attr) {
        this.text.push(text);
      }
    }
  }, {
    key: "parseClose",
    value: function parseClose() {
      if (!this.attr) {
        this.model = parseInt(this.text.join('') || 0, 10);
      }

      return false;
    }
  }]);

  return IntegerXform;
}(BaseXform);

module.exports = IntegerXform;


},{"../base-xform":30}],88:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var BaseXform = require('../base-xform');

var StringXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(StringXform, _BaseXform);

  function StringXform(options) {
    var _this;

    _classCallCheck(this, StringXform);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(StringXform).call(this));
    _this.tag = options.tag;
    _this.attr = options.attr;
    _this.attrs = options.attrs;
    return _this;
  }

  _createClass(StringXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      if (model !== undefined) {
        xmlStream.openNode(this.tag);

        if (this.attrs) {
          xmlStream.addAttributes(this.attrs);
        }

        if (this.attr) {
          xmlStream.addAttribute(this.attr, model);
        } else {
          xmlStream.writeText(model);
        }

        xmlStream.closeNode();
      }
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (node.name === this.tag) {
        if (this.attr) {
          this.model = node.attributes[this.attr];
        } else {
          this.text = [];
        }
      }
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      if (!this.attr) {
        this.text.push(text);
      }
    }
  }, {
    key: "parseClose",
    value: function parseClose() {
      if (!this.attr) {
        this.model = this.text.join('');
      }

      return false;
    }
  }]);

  return StringXform;
}(BaseXform);

module.exports = StringXform;


},{"../base-xform":30}],89:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var BaseXform = require('./base-xform');

var XmlStream = require('../../utils/xml-stream'); // const model = {
//   tag: 'name',
//   $: {attr: 'value'},
//   c: [
//     { tag: 'child' }
//   ],
//   t: 'some text'
// };


function build(xmlStream, model) {
  xmlStream.openNode(model.tag, model.$);

  if (model.c) {
    model.c.forEach(function (child) {
      build(xmlStream, child);
    });
  }

  if (model.t) {
    xmlStream.writeText(model.t);
  }

  xmlStream.closeNode();
}

var StaticXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(StaticXform, _BaseXform);

  function StaticXform(model) {
    var _this;

    _classCallCheck(this, StaticXform);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(StaticXform).call(this)); // This class is an optimisation for static (unimportant and unchanging) xml
    // It is stateless - apart from its static model and so can be used as a singleton
    // Being stateless - it will only track entry to and exit from it's root xml tag during parsing and nothing else
    // Known issues:
    //    since stateless - parseOpen always returns true. Parent xform must know when to start using this xform
    //    if the root tag is recursive, the parsing will behave unpredictably

    _this._model = model;
    return _this;
  }

  _createClass(StaticXform, [{
    key: "render",
    value: function render(xmlStream) {
      if (!this._xml) {
        var stream = new XmlStream();
        build(stream, this._model);
        this._xml = stream.xml;
      }

      xmlStream.writeXml(this._xml);
    }
  }, {
    key: "parseOpen",
    value: function parseOpen() {
      return true;
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      switch (name) {
        case this._model.tag:
          return false;

        default:
          return true;
      }
    }
  }]);

  return StaticXform;
}(BaseXform);

module.exports = StaticXform;


},{"../../utils/xml-stream":26,"./base-xform":30}],90:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var TextXform = require('./text-xform');

var RichTextXform = require('./rich-text-xform');

var BaseXform = require('../base-xform'); // <rPh sb="0" eb="1">
//   <t>(its pronounciation in KATAKANA)</t>
// </rPh>


var PhoneticTextXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(PhoneticTextXform, _BaseXform);

  function PhoneticTextXform() {
    var _this;

    _classCallCheck(this, PhoneticTextXform);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(PhoneticTextXform).call(this));
    _this.map = {
      r: new RichTextXform(),
      t: new TextXform()
    };
    return _this;
  }

  _createClass(PhoneticTextXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.openNode(this.tag, {
        sb: model.sb || 0,
        eb: model.eb || 0
      });

      if (model && model.hasOwnProperty('richText') && model.richText) {
        var r = this.map.r;
        model.richText.forEach(function (text) {
          r.render(xmlStream, text);
        });
      } else if (model) {
        this.map.t.render(xmlStream, model.text);
      }

      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      var name = node.name;

      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      if (name === this.tag) {
        this.model = {
          sb: parseInt(node.attributes.sb, 10),
          eb: parseInt(node.attributes.eb, 10)
        };
        return true;
      }

      this.parser = this.map[name];

      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      return false;
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      if (this.parser) {
        this.parser.parseText(text);
      }
    }
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      if (this.parser) {
        if (!this.parser.parseClose(name)) {
          switch (name) {
            case 'r':
              {
                var rt = this.model.richText;

                if (!rt) {
                  rt = this.model.richText = [];
                }

                rt.push(this.parser.model);
                break;
              }

            case 't':
              this.model.text = this.parser.model;
              break;

            default:
              break;
          }

          this.parser = undefined;
        }

        return true;
      }

      switch (name) {
        case this.tag:
          return false;

        default:
          return true;
      }
    }
  }, {
    key: "tag",
    get: function get() {
      return 'rPh';
    }
  }]);

  return PhoneticTextXform;
}(BaseXform);

module.exports = PhoneticTextXform;


},{"../base-xform":30,"./rich-text-xform":91,"./text-xform":94}],91:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var TextXform = require('./text-xform');

var FontXform = require('../style/font-xform');

var BaseXform = require('../base-xform'); // <r>
//   <rPr>
//     <sz val="11"/>
//     <color theme="1" tint="5"/>
//     <rFont val="Calibri"/>
//     <family val="2"/>
//     <scheme val="minor"/>
//   </rPr>
//   <t xml:space="preserve"> is </t>
// </r>


var RichTextXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(RichTextXform, _BaseXform);

  function RichTextXform(model) {
    var _this;

    _classCallCheck(this, RichTextXform);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(RichTextXform).call(this));
    _this.model = model;
    return _this;
  }

  _createClass(RichTextXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      model = model || this.model;
      xmlStream.openNode('r');

      if (model.font) {
        this.fontXform.render(xmlStream, model.font);
      }

      this.textXform.render(xmlStream, model.text);
      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      switch (node.name) {
        case 'r':
          this.model = {};
          return true;

        case 't':
          this.parser = this.textXform;
          this.parser.parseOpen(node);
          return true;

        case 'rPr':
          this.parser = this.fontXform;
          this.parser.parseOpen(node);
          return true;

        default:
          return false;
      }
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      if (this.parser) {
        this.parser.parseText(text);
      }
    }
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      switch (name) {
        case 'r':
          return false;

        case 't':
          this.model.text = this.parser.model;
          this.parser = undefined;
          return true;

        case 'rPr':
          this.model.font = this.parser.model;
          this.parser = undefined;
          return true;

        default:
          if (this.parser) {
            this.parser.parseClose(name);
          }

          return true;
      }
    }
  }, {
    key: "tag",
    get: function get() {
      return 'r';
    }
  }, {
    key: "textXform",
    get: function get() {
      return this._textXform || (this._textXform = new TextXform());
    }
  }, {
    key: "fontXform",
    get: function get() {
      return this._fontXform || (this._fontXform = new FontXform(RichTextXform.FONT_OPTIONS));
    }
  }]);

  return RichTextXform;
}(BaseXform);

RichTextXform.FONT_OPTIONS = {
  tagName: 'rPr',
  fontNameTag: 'rFont'
};
module.exports = RichTextXform;


},{"../base-xform":30,"../style/font-xform":100,"./text-xform":94}],92:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var TextXform = require('./text-xform');

var RichTextXform = require('./rich-text-xform');

var PhoneticTextXform = require('./phonetic-text-xform');

var BaseXform = require('../base-xform'); // <si>
//   <r></r><r></r>...
// </si>
// <si>
//   <t></t>
// </si>


var SharedStringXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(SharedStringXform, _BaseXform);

  function SharedStringXform(model) {
    var _this;

    _classCallCheck(this, SharedStringXform);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(SharedStringXform).call(this));
    _this.model = model;
    _this.map = {
      r: new RichTextXform(),
      t: new TextXform(),
      rPh: new PhoneticTextXform()
    };
    return _this;
  }

  _createClass(SharedStringXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.openNode(this.tag);

      if (model && model.hasOwnProperty('richText') && model.richText) {
        var r = this.map.r;
        model.richText.forEach(function (text) {
          r.render(xmlStream, text);
        });
      } else if (model !== undefined && model !== null) {
        this.map.t.render(xmlStream, model);
      }

      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      var name = node.name;

      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      if (name === this.tag) {
        this.model = {};
        return true;
      }

      this.parser = this.map[name];

      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      return false;
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      if (this.parser) {
        this.parser.parseText(text);
      }
    }
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      if (this.parser) {
        if (!this.parser.parseClose(name)) {
          switch (name) {
            case 'r':
              {
                var rt = this.model.richText;

                if (!rt) {
                  rt = this.model.richText = [];
                }

                rt.push(this.parser.model);
                break;
              }

            case 't':
              this.model = this.parser.model;
              break;

            default:
              break;
          }

          this.parser = undefined;
        }

        return true;
      }

      switch (name) {
        case this.tag:
          return false;

        default:
          return true;
      }
    }
  }, {
    key: "tag",
    get: function get() {
      return 'si';
    }
  }]);

  return SharedStringXform;
}(BaseXform);

module.exports = SharedStringXform;


},{"../base-xform":30,"./phonetic-text-xform":90,"./rich-text-xform":91,"./text-xform":94}],93:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var XmlStream = require('../../../utils/xml-stream');

var BaseXform = require('../base-xform');

var SharedStringXform = require('./shared-string-xform');

var SharedStringsXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(SharedStringsXform, _BaseXform);

  function SharedStringsXform(model) {
    var _this;

    _classCallCheck(this, SharedStringsXform);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(SharedStringsXform).call(this));
    _this.model = model || {
      values: [],
      count: 0
    };
    _this.hash = {};
    _this.rich = {};
    return _this;
  }

  _createClass(SharedStringsXform, [{
    key: "getString",
    value: function getString(index) {
      return this.model.values[index];
    }
  }, {
    key: "add",
    value: function add(value) {
      return value.richText ? this.addRichText(value) : this.addText(value);
    }
  }, {
    key: "addText",
    value: function addText(value) {
      var index = this.hash[value];

      if (index === undefined) {
        index = this.hash[value] = this.model.values.length;
        this.model.values.push(value);
      }

      this.model.count++;
      return index;
    }
  }, {
    key: "addRichText",
    value: function addRichText(value) {
      // TODO: add WeakMap here
      var xml = this.sharedStringXform.toXml(value);
      var index = this.rich[xml];

      if (index === undefined) {
        index = this.rich[xml] = this.model.values.length;
        this.model.values.push(value);
      }

      this.model.count++;
      return index;
    } // <?xml version="1.0" encoding="UTF-8" standalone="yes"?>
    // <sst xmlns="http://schemas.openxmlformats.org/spreadsheetml/2006/main" count="<%=totalRefs%>" uniqueCount="<%=count%>">
    //   <si><t><%=text%></t></si>
    //   <si><r><rPr></rPr><t></t></r></si>
    // </sst>

  }, {
    key: "render",
    value: function render(xmlStream, model) {
      model = model || this._values;
      xmlStream.openXml(XmlStream.StdDocAttributes);
      xmlStream.openNode('sst', {
        xmlns: 'http://schemas.openxmlformats.org/spreadsheetml/2006/main',
        count: model.count,
        uniqueCount: model.values.length
      });
      var sx = this.sharedStringXform;
      model.values.forEach(function (sharedString) {
        sx.render(xmlStream, sharedString);
      });
      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      switch (node.name) {
        case 'sst':
          return true;

        case 'si':
          this.parser = this.sharedStringXform;
          this.parser.parseOpen(node);
          return true;

        default:
          throw new Error("Unexpected xml node in parseOpen: ".concat(JSON.stringify(node)));
      }
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      if (this.parser) {
        this.parser.parseText(text);
      }
    }
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      if (this.parser) {
        if (!this.parser.parseClose(name)) {
          this.model.values.push(this.parser.model);
          this.model.count++;
          this.parser = undefined;
        }

        return true;
      }

      switch (name) {
        case 'sst':
          return false;

        default:
          throw new Error("Unexpected xml node in parseClose: ".concat(name));
      }
    }
  }, {
    key: "sharedStringXform",
    get: function get() {
      return this._sharedStringXform || (this._sharedStringXform = new SharedStringXform());
    }
  }, {
    key: "values",
    get: function get() {
      return this.model.values;
    }
  }, {
    key: "uniqueCount",
    get: function get() {
      return this.model.values.length;
    }
  }, {
    key: "count",
    get: function get() {
      return this.model.count;
    }
  }]);

  return SharedStringsXform;
}(BaseXform);

module.exports = SharedStringsXform;


},{"../../../utils/xml-stream":26,"../base-xform":30,"./shared-string-xform":92}],94:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var BaseXform = require('../base-xform'); //   <t xml:space="preserve"> is </t>


var TextXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(TextXform, _BaseXform);

  function TextXform() {
    _classCallCheck(this, TextXform);

    return _possibleConstructorReturn(this, _getPrototypeOf(TextXform).apply(this, arguments));
  }

  _createClass(TextXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.openNode('t');

      if (model[0] === ' ' || model[model.length - 1] === ' ') {
        xmlStream.addAttribute('xml:space', 'preserve');
      }

      xmlStream.writeText(model);
      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      switch (node.name) {
        case 't':
          this._text = [];
          return true;

        default:
          return false;
      }
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      this._text.push(text);
    }
  }, {
    key: "parseClose",
    value: function parseClose() {
      return false;
    }
  }, {
    key: "tag",
    get: function get() {
      return 't';
    }
  }, {
    key: "model",
    get: function get() {
      return this._text.join('').replace(/_x([0-9A-F]{4})_/g, function ($0, $1) {
        return String.fromCharCode(parseInt($1, 16));
      });
    }
  }]);

  return TextXform;
}(BaseXform);

module.exports = TextXform;


},{"../base-xform":30}],95:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var Enums = require('../../../doc/enums');

var utils = require('../../../utils/utils');

var BaseXform = require('../base-xform');

var validation = {
  horizontalValues: ['left', 'center', 'right', 'fill', 'centerContinuous', 'distributed', 'justify'].reduce(function (p, v) {
    p[v] = true;
    return p;
  }, {}),
  horizontal: function horizontal(value) {
    return this.horizontalValues[value] ? value : undefined;
  },
  verticalValues: ['top', 'middle', 'bottom', 'distributed', 'justify'].reduce(function (p, v) {
    p[v] = true;
    return p;
  }, {}),
  vertical: function vertical(value) {
    if (value === 'middle') return 'center';
    return this.verticalValues[value] ? value : undefined;
  },
  wrapText: function wrapText(value) {
    return value ? true : undefined;
  },
  shrinkToFit: function shrinkToFit(value) {
    return value ? true : undefined;
  },
  textRotation: function textRotation(value) {
    switch (value) {
      case 'vertical':
        return value;

      default:
        value = utils.validInt(value);
        return value >= -90 && value <= 90 ? value : undefined;
    }
  },
  indent: function indent(value) {
    value = utils.validInt(value);
    return Math.max(0, value);
  },
  readingOrder: function readingOrder(value) {
    switch (value) {
      case 'ltr':
        return Enums.ReadingOrder.LeftToRight;

      case 'rtl':
        return Enums.ReadingOrder.RightToLeft;

      default:
        return undefined;
    }
  }
};
var textRotationXform = {
  toXml: function toXml(textRotation) {
    textRotation = validation.textRotation(textRotation);

    if (textRotation) {
      if (textRotation === 'vertical') {
        return 255;
      }

      var tr = Math.round(textRotation);

      if (tr >= 0 && tr <= 90) {
        return tr;
      }

      if (tr < 0 && tr >= -90) {
        return 90 - tr;
      }
    }

    return undefined;
  },
  toModel: function toModel(textRotation) {
    var tr = utils.validInt(textRotation);

    if (tr !== undefined) {
      if (tr === 255) {
        return 'vertical';
      }

      if (tr >= 0 && tr <= 90) {
        return tr;
      }

      if (tr > 90 && tr <= 180) {
        return 90 - tr;
      }
    }

    return undefined;
  }
}; // Alignment encapsulates translation from style.alignment model to/from xlsx

var AlignmentXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(AlignmentXform, _BaseXform);

  function AlignmentXform() {
    _classCallCheck(this, AlignmentXform);

    return _possibleConstructorReturn(this, _getPrototypeOf(AlignmentXform).apply(this, arguments));
  }

  _createClass(AlignmentXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.addRollback();
      xmlStream.openNode('alignment');
      var isValid = false;

      function add(name, value) {
        if (value) {
          xmlStream.addAttribute(name, value);
          isValid = true;
        }
      }

      add('horizontal', validation.horizontal(model.horizontal));
      add('vertical', validation.vertical(model.vertical));
      add('wrapText', validation.wrapText(model.wrapText) ? '1' : false);
      add('shrinkToFit', validation.shrinkToFit(model.shrinkToFit) ? '1' : false);
      add('indent', validation.indent(model.indent));
      add('textRotation', textRotationXform.toXml(model.textRotation));
      add('readingOrder', validation.readingOrder(model.readingOrder));
      xmlStream.closeNode();

      if (isValid) {
        xmlStream.commit();
      } else {
        xmlStream.rollback();
      }
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      var model = {};
      var valid = false;

      function add(truthy, name, value) {
        if (truthy) {
          model[name] = value;
          valid = true;
        }
      }

      add(node.attributes.horizontal, 'horizontal', node.attributes.horizontal);
      add(node.attributes.vertical, 'vertical', node.attributes.vertical === 'center' ? 'middle' : node.attributes.vertical);
      add(node.attributes.wrapText, 'wrapText', !!node.attributes.wrapText);
      add(node.attributes.shrinkToFit, 'shrinkToFit', !!node.attributes.shrinkToFit);
      add(node.attributes.indent, 'indent', parseInt(node.attributes.indent, 10));
      add(node.attributes.textRotation, 'textRotation', textRotationXform.toModel(node.attributes.textRotation));
      add(node.attributes.readingOrder, 'readingOrder', node.attributes.readingOrder === '2' ? 'rtl' : 'ltr');
      this.model = valid ? model : null;
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose() {
      return false;
    }
  }, {
    key: "tag",
    get: function get() {
      return 'alignment';
    }
  }]);

  return AlignmentXform;
}(BaseXform);

module.exports = AlignmentXform;


},{"../../../doc/enums":8,"../../../utils/utils":25,"../base-xform":30}],96:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var BaseXform = require('../base-xform');

var ColorXform = require('./color-xform');

var EdgeXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(EdgeXform, _BaseXform);

  function EdgeXform(name) {
    var _this;

    _classCallCheck(this, EdgeXform);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(EdgeXform).call(this));
    _this.name = name;
    _this.map = {
      color: new ColorXform()
    };
    return _this;
  }

  _createClass(EdgeXform, [{
    key: "render",
    value: function render(xmlStream, model, defaultColor) {
      var color = model && model.color || defaultColor || this.defaultColor;
      xmlStream.openNode(this.name);

      if (model && model.style) {
        xmlStream.addAttribute('style', model.style);

        if (color) {
          this.map.color.render(xmlStream, color);
        }
      }

      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      switch (node.name) {
        case this.name:
          {
            var style = node.attributes.style;

            if (style) {
              this.model = {
                style: style
              };
            } else {
              this.model = undefined;
            }

            return true;
          }

        case 'color':
          this.parser = this.map.color;
          this.parser.parseOpen(node);
          return true;

        default:
          return false;
      }
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      if (this.parser) {
        this.parser.parseText(text);
      }
    }
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      if (this.parser) {
        if (!this.parser.parseClose(name)) {
          this.parser = undefined;
        }

        return true;
      }

      if (name === this.name) {
        if (this.map.color.model) {
          if (!this.model) {
            this.model = {};
          }

          this.model.color = this.map.color.model;
        }
      }

      return false;
    }
  }, {
    key: "validStyle",
    value: function validStyle(value) {
      return EdgeXform.validStyleValues[value];
    }
  }, {
    key: "tag",
    get: function get() {
      return this.name;
    }
  }]);

  return EdgeXform;
}(BaseXform);

EdgeXform.validStyleValues = ['thin', 'dotted', 'dashDot', 'hair', 'dashDotDot', 'slantDashDot', 'mediumDashed', 'mediumDashDotDot', 'mediumDashDot', 'medium', 'double', 'thick'].reduce(function (p, v) {
  p[v] = true;
  return p;
}, {}); // Border encapsulates translation from border model to/from xlsx

var BorderXform =
/*#__PURE__*/
function (_BaseXform2) {
  _inherits(BorderXform, _BaseXform2);

  function BorderXform() {
    var _this2;

    _classCallCheck(this, BorderXform);

    _this2 = _possibleConstructorReturn(this, _getPrototypeOf(BorderXform).call(this));
    _this2.map = {
      top: new EdgeXform('top'),
      left: new EdgeXform('left'),
      bottom: new EdgeXform('bottom'),
      right: new EdgeXform('right'),
      diagonal: new EdgeXform('diagonal')
    };
    return _this2;
  }

  _createClass(BorderXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      var color = model.color;
      xmlStream.openNode('border');

      if (model.diagonal && model.diagonal.style) {
        if (model.diagonal.up) {
          xmlStream.addAttribute('diagonalUp', '1');
        }

        if (model.diagonal.down) {
          xmlStream.addAttribute('diagonalDown', '1');
        }
      }

      function add(edgeModel, edgeXform) {
        if (edgeModel && !edgeModel.color && model.color) {
          // don't mess with incoming models
          edgeModel = Object.assign({}, edgeModel, {
            color: model.color
          });
        }

        edgeXform.render(xmlStream, edgeModel, color);
      }

      add(model.left, this.map.left);
      add(model.right, this.map.right);
      add(model.top, this.map.top);
      add(model.bottom, this.map.bottom);
      add(model.diagonal, this.map.diagonal);
      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      switch (node.name) {
        case 'border':
          this.reset();
          this.diagonalUp = !!node.attributes.diagonalUp;
          this.diagonalDown = !!node.attributes.diagonalDown;
          return true;

        default:
          this.parser = this.map[node.name];

          if (this.parser) {
            this.parser.parseOpen(node);
            return true;
          }

          return false;
      }
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      if (this.parser) {
        this.parser.parseText(text);
      }
    }
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      if (this.parser) {
        if (!this.parser.parseClose(name)) {
          this.parser = undefined;
        }

        return true;
      }

      if (name === 'border') {
        var model = this.model = {};

        var add = function add(key, edgeModel, extensions) {
          if (edgeModel) {
            if (extensions) {
              Object.assign(edgeModel, extensions);
            }

            model[key] = edgeModel;
          }
        };

        add('left', this.map.left.model);
        add('right', this.map.right.model);
        add('top', this.map.top.model);
        add('bottom', this.map.bottom.model);
        add('diagonal', this.map.diagonal.model, {
          up: this.diagonalUp,
          down: this.diagonalDown
        });
      }

      return false;
    }
  }]);

  return BorderXform;
}(BaseXform);

module.exports = BorderXform;


},{"../base-xform":30,"./color-xform":97}],97:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var BaseXform = require('../base-xform'); // Color encapsulates translation from color model to/from xlsx


var ColorXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(ColorXform, _BaseXform);

  function ColorXform(name) {
    var _this;

    _classCallCheck(this, ColorXform);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(ColorXform).call(this)); // this.name controls the xm node name

    _this.name = name || 'color';
    return _this;
  }

  _createClass(ColorXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      if (model) {
        xmlStream.openNode(this.name);

        if (model.argb) {
          xmlStream.addAttribute('rgb', model.argb);
        } else if (model.theme !== undefined) {
          xmlStream.addAttribute('theme', model.theme);

          if (model.tint !== undefined) {
            xmlStream.addAttribute('tint', model.tint);
          }
        } else if (model.indexed !== undefined) {
          xmlStream.addAttribute('indexed', model.indexed);
        } else {
          xmlStream.addAttribute('auto', '1');
        }

        xmlStream.closeNode();
        return true;
      }

      return false;
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (node.name === this.name) {
        if (node.attributes.rgb) {
          this.model = {
            argb: node.attributes.rgb
          };
        } else if (node.attributes.theme) {
          this.model = {
            theme: parseInt(node.attributes.theme, 10)
          };

          if (node.attributes.tint) {
            this.model.tint = parseFloat(node.attributes.tint);
          }
        } else if (node.attributes.indexed) {
          this.model = {
            indexed: parseInt(node.attributes.indexed, 10)
          };
        } else {
          this.model = undefined;
        }

        return true;
      }

      return false;
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose() {
      return false;
    }
  }, {
    key: "tag",
    get: function get() {
      return this.name;
    }
  }]);

  return ColorXform;
}(BaseXform);

module.exports = ColorXform;


},{"../base-xform":30}],98:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var BaseXform = require('../base-xform');

var AlignmentXform = require('./alignment-xform');

var BorderXform = require('./border-xform');

var FillXform = require('./fill-xform');

var FontXform = require('./font-xform');

var NumFmtXform = require('./numfmt-xform');

var ProtectionXform = require('./protection-xform'); // <xf numFmtId="[numFmtId]" fontId="[fontId]" fillId="[fillId]" borderId="[xf.borderId]" xfId="[xfId]">
//   Optional <alignment>
//   Optional <protection>
// </xf>
// Style assists translation from style model to/from xlsx


var DxfXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(DxfXform, _BaseXform);

  function DxfXform() {
    var _this;

    _classCallCheck(this, DxfXform);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(DxfXform).call(this));
    _this.map = {
      alignment: new AlignmentXform(),
      border: new BorderXform(),
      fill: new FillXform(),
      font: new FontXform(),
      numFmt: new NumFmtXform(),
      protection: new ProtectionXform()
    };
    return _this;
  }

  _createClass(DxfXform, [{
    key: "render",
    // how do we generate dxfid?
    value: function render(xmlStream, model) {
      xmlStream.openNode(this.tag);

      if (model.alignment) {
        this.map.alignment.render(xmlStream, model.alignment);
      }

      if (model.border) {
        this.map.border.render(xmlStream, model.border);
      }

      if (model.fill) {
        this.map.fill.render(xmlStream, model.fill);
      }

      if (model.font) {
        this.map.font.render(xmlStream, model.font);
      }

      if (model.numFmt) {
        this.map.numFmt.render(xmlStream, model.numFmt);
      }

      if (model.protection) {
        this.map.protection.render(xmlStream, model.protection);
      }

      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      switch (node.name) {
        case this.tag:
          return true;

        default:
          this.parser = this.map[node.name];

          if (this.parser) {
            this.parser.parseOpen(node);
          }

          return true;
      }
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      if (this.parser) {
        this.parser.parseText(text);
      }
    }
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      if (this.parser) {
        if (!this.parser.parseClose(name)) {
          this.parser = undefined;
        }

        return true;
      }

      if (name === this.tag) {
        this.model = {
          alignment: this.map.alignment.model,
          border: this.map.border.model,
          fill: this.map.fill.model,
          font: this.map.font.model,
          numFmt: this.map.numFmt.model,
          protection: this.map.protection.model
        };
        return false;
      }

      return true;
    }
  }, {
    key: "tag",
    get: function get() {
      return 'dxf';
    }
  }]);

  return DxfXform;
}(BaseXform);

module.exports = DxfXform;


},{"../base-xform":30,"./alignment-xform":95,"./border-xform":96,"./fill-xform":99,"./font-xform":100,"./numfmt-xform":101,"./protection-xform":102}],99:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var BaseXform = require('../base-xform');

var ColorXform = require('./color-xform');

var StopXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(StopXform, _BaseXform);

  function StopXform() {
    var _this;

    _classCallCheck(this, StopXform);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(StopXform).call(this));
    _this.map = {
      color: new ColorXform()
    };
    return _this;
  }

  _createClass(StopXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.openNode('stop');
      xmlStream.addAttribute('position', model.position);
      this.map.color.render(xmlStream, model.color);
      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      switch (node.name) {
        case 'stop':
          this.model = {
            position: parseFloat(node.attributes.position)
          };
          return true;

        case 'color':
          this.parser = this.map.color;
          this.parser.parseOpen(node);
          return true;

        default:
          return false;
      }
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      if (this.parser) {
        if (!this.parser.parseClose(name)) {
          this.model.color = this.parser.model;
          this.parser = undefined;
        }

        return true;
      }

      return false;
    }
  }, {
    key: "tag",
    get: function get() {
      return 'stop';
    }
  }]);

  return StopXform;
}(BaseXform);

var PatternFillXform =
/*#__PURE__*/
function (_BaseXform2) {
  _inherits(PatternFillXform, _BaseXform2);

  function PatternFillXform() {
    var _this2;

    _classCallCheck(this, PatternFillXform);

    _this2 = _possibleConstructorReturn(this, _getPrototypeOf(PatternFillXform).call(this));
    _this2.map = {
      fgColor: new ColorXform('fgColor'),
      bgColor: new ColorXform('bgColor')
    };
    return _this2;
  }

  _createClass(PatternFillXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.openNode('patternFill');
      xmlStream.addAttribute('patternType', model.pattern);

      if (model.fgColor) {
        this.map.fgColor.render(xmlStream, model.fgColor);
      }

      if (model.bgColor) {
        this.map.bgColor.render(xmlStream, model.bgColor);
      }

      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      switch (node.name) {
        case 'patternFill':
          this.model = {
            type: 'pattern',
            pattern: node.attributes.patternType
          };
          return true;

        default:
          this.parser = this.map[node.name];

          if (this.parser) {
            this.parser.parseOpen(node);
            return true;
          }

          return false;
      }
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      if (this.parser) {
        this.parser.parseText(text);
      }
    }
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      if (this.parser) {
        if (!this.parser.parseClose(name)) {
          if (this.parser.model) {
            this.model[name] = this.parser.model;
          }

          this.parser = undefined;
        }

        return true;
      }

      return false;
    }
  }, {
    key: "name",
    get: function get() {
      return 'pattern';
    }
  }, {
    key: "tag",
    get: function get() {
      return 'patternFill';
    }
  }]);

  return PatternFillXform;
}(BaseXform);

var GradientFillXform =
/*#__PURE__*/
function (_BaseXform3) {
  _inherits(GradientFillXform, _BaseXform3);

  function GradientFillXform() {
    var _this3;

    _classCallCheck(this, GradientFillXform);

    _this3 = _possibleConstructorReturn(this, _getPrototypeOf(GradientFillXform).call(this));
    _this3.map = {
      stop: new StopXform()
    }; // if (model) {
    //   this.gradient = model.gradient;
    //   if (model.center) {
    //     this.center = model.center;
    //   }
    //   if (model.degree !== undefined) {
    //     this.degree = model.degree;
    //   }
    //   this.stops = model.stops.map(function(stop) { return new StopXform(stop); });
    // } else {
    //   this.stops = [];
    // }

    return _this3;
  }

  _createClass(GradientFillXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.openNode('gradientFill');

      switch (model.gradient) {
        case 'angle':
          xmlStream.addAttribute('degree', model.degree);
          break;

        case 'path':
          xmlStream.addAttribute('type', 'path');

          if (model.center.left) {
            xmlStream.addAttribute('left', model.center.left);

            if (model.center.right === undefined) {
              xmlStream.addAttribute('right', model.center.left);
            }
          }

          if (model.center.right) {
            xmlStream.addAttribute('right', model.center.right);
          }

          if (model.center.top) {
            xmlStream.addAttribute('top', model.center.top);

            if (model.center.bottom === undefined) {
              xmlStream.addAttribute('bottom', model.center.top);
            }
          }

          if (model.center.bottom) {
            xmlStream.addAttribute('bottom', model.center.bottom);
          }

          break;

        default:
          break;
      }

      var stopXform = this.map.stop;
      model.stops.forEach(function (stopModel) {
        stopXform.render(xmlStream, stopModel);
      });
      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      switch (node.name) {
        case 'gradientFill':
          {
            var model = this.model = {
              stops: []
            };

            if (node.attributes.degree) {
              model.gradient = 'angle';
              model.degree = parseInt(node.attributes.degree, 10);
            } else if (node.attributes.type === 'path') {
              model.gradient = 'path';
              model.center = {
                left: node.attributes.left ? parseFloat(node.attributes.left) : 0,
                top: node.attributes.top ? parseFloat(node.attributes.top) : 0
              };

              if (node.attributes.right !== node.attributes.left) {
                model.center.right = node.attributes.right ? parseFloat(node.attributes.right) : 0;
              }

              if (node.attributes.bottom !== node.attributes.top) {
                model.center.bottom = node.attributes.bottom ? parseFloat(node.attributes.bottom) : 0;
              }
            }

            return true;
          }

        case 'stop':
          this.parser = this.map.stop;
          this.parser.parseOpen(node);
          return true;

        default:
          return false;
      }
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      if (this.parser) {
        this.parser.parseText(text);
      }
    }
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      if (this.parser) {
        if (!this.parser.parseClose(name)) {
          this.model.stops.push(this.parser.model);
          this.parser = undefined;
        }

        return true;
      }

      return false;
    }
  }, {
    key: "name",
    get: function get() {
      return 'gradient';
    }
  }, {
    key: "tag",
    get: function get() {
      return 'gradientFill';
    }
  }]);

  return GradientFillXform;
}(BaseXform); // Fill encapsulates translation from fill model to/from xlsx


var FillXform =
/*#__PURE__*/
function (_BaseXform4) {
  _inherits(FillXform, _BaseXform4);

  function FillXform() {
    var _this4;

    _classCallCheck(this, FillXform);

    _this4 = _possibleConstructorReturn(this, _getPrototypeOf(FillXform).call(this));
    _this4.map = {
      patternFill: new PatternFillXform(),
      gradientFill: new GradientFillXform()
    };
    return _this4;
  }

  _createClass(FillXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.addRollback();
      xmlStream.openNode('fill');

      switch (model.type) {
        case 'pattern':
          this.map.patternFill.render(xmlStream, model);
          break;

        case 'gradient':
          this.map.gradientFill.render(xmlStream, model);
          break;

        default:
          xmlStream.rollback();
          return;
      }

      xmlStream.closeNode();
      xmlStream.commit();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      switch (node.name) {
        case 'fill':
          this.model = {};
          return true;

        default:
          this.parser = this.map[node.name];

          if (this.parser) {
            this.parser.parseOpen(node);
            return true;
          }

          return false;
      }
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      if (this.parser) {
        this.parser.parseText(text);
      }
    }
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      if (this.parser) {
        if (!this.parser.parseClose(name)) {
          this.model = this.parser.model;
          this.model.type = this.parser.name;
          this.parser = undefined;
        }

        return true;
      }

      return false;
    }
  }, {
    key: "validStyle",
    value: function validStyle(value) {
      return FillXform.validPatternValues[value];
    }
  }, {
    key: "tag",
    get: function get() {
      return 'fill';
    }
  }]);

  return FillXform;
}(BaseXform);

FillXform.validPatternValues = ['none', 'solid', 'darkVertical', 'darkGray', 'mediumGray', 'lightGray', 'gray125', 'gray0625', 'darkHorizontal', 'darkVertical', 'darkDown', 'darkUp', 'darkGrid', 'darkTrellis', 'lightHorizontal', 'lightVertical', 'lightDown', 'lightUp', 'lightGrid', 'lightTrellis', 'lightGrid'].reduce(function (p, v) {
  p[v] = true;
  return p;
}, {});
FillXform.StopXform = StopXform;
FillXform.PatternFillXform = PatternFillXform;
FillXform.GradientFillXform = GradientFillXform;
module.exports = FillXform;


},{"../base-xform":30,"./color-xform":97}],100:[function(require,module,exports){
'use strict';

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var ColorXform = require('./color-xform');

var BooleanXform = require('../simple/boolean-xform');

var IntegerXform = require('../simple/integer-xform');

var StringXform = require('../simple/string-xform');

var UnderlineXform = require('./underline-xform');

var _ = require('../../../utils/under-dash');

var BaseXform = require('../base-xform'); // Font encapsulates translation from font model to xlsx


var FontXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(FontXform, _BaseXform);

  function FontXform(options) {
    var _this;

    _classCallCheck(this, FontXform);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(FontXform).call(this));
    _this.options = options || FontXform.OPTIONS;
    _this.map = {
      b: {
        prop: 'bold',
        xform: new BooleanXform({
          tag: 'b',
          attr: 'val'
        })
      },
      i: {
        prop: 'italic',
        xform: new BooleanXform({
          tag: 'i',
          attr: 'val'
        })
      },
      u: {
        prop: 'underline',
        xform: new UnderlineXform()
      },
      charset: {
        prop: 'charset',
        xform: new IntegerXform({
          tag: 'charset',
          attr: 'val'
        })
      },
      color: {
        prop: 'color',
        xform: new ColorXform()
      },
      condense: {
        prop: 'condense',
        xform: new BooleanXform({
          tag: 'condense',
          attr: 'val'
        })
      },
      extend: {
        prop: 'extend',
        xform: new BooleanXform({
          tag: 'extend',
          attr: 'val'
        })
      },
      family: {
        prop: 'family',
        xform: new IntegerXform({
          tag: 'family',
          attr: 'val'
        })
      },
      outline: {
        prop: 'outline',
        xform: new BooleanXform({
          tag: 'outline',
          attr: 'val'
        })
      },
      vertAlign: {
        prop: 'vertAlign',
        xform: new StringXform({
          tag: 'vertAlign',
          attr: 'val'
        })
      },
      scheme: {
        prop: 'scheme',
        xform: new StringXform({
          tag: 'scheme',
          attr: 'val'
        })
      },
      shadow: {
        prop: 'shadow',
        xform: new BooleanXform({
          tag: 'shadow',
          attr: 'val'
        })
      },
      strike: {
        prop: 'strike',
        xform: new BooleanXform({
          tag: 'strike',
          attr: 'val'
        })
      },
      sz: {
        prop: 'size',
        xform: new IntegerXform({
          tag: 'sz',
          attr: 'val'
        })
      }
    };
    _this.map[_this.options.fontNameTag] = {
      prop: 'name',
      xform: new StringXform({
        tag: _this.options.fontNameTag,
        attr: 'val'
      })
    };
    return _this;
  }

  _createClass(FontXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      var map = this.map;
      xmlStream.openNode(this.options.tagName);

      _.each(this.map, function (defn, tag) {
        map[tag].xform.render(xmlStream, model[defn.prop]);
      });

      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      if (this.map[node.name]) {
        this.parser = this.map[node.name].xform;
        return this.parser.parseOpen(node);
      }

      switch (node.name) {
        case this.options.tagName:
          this.model = {};
          return true;

        default:
          return false;
      }
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      if (this.parser) {
        this.parser.parseText(text);
      }
    }
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      if (this.parser && !this.parser.parseClose(name)) {
        var item = this.map[name];

        if (this.parser.model) {
          this.model[item.prop] = this.parser.model;
        }

        this.parser = undefined;
        return true;
      }

      switch (name) {
        case this.options.tagName:
          return false;

        default:
          return true;
      }
    }
  }, {
    key: "tag",
    get: function get() {
      return this.options.tagName;
    }
  }]);

  return FontXform;
}(BaseXform);

FontXform.OPTIONS = {
  tagName: 'font',
  fontNameTag: 'name'
};
module.exports = FontXform;


},{"../../../utils/under-dash":24,"../base-xform":30,"../simple/boolean-xform":85,"../simple/integer-xform":87,"../simple/string-xform":88,"./color-xform":97,"./underline-xform":105}],101:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var _ = require('../../../utils/under-dash');

var defaultNumFormats = require('../../defaultnumformats');

var BaseXform = require('../base-xform');

function hashDefaultFormats() {
  var hash = {};

  _.each(defaultNumFormats, function (dnf, id) {
    if (dnf.f) {
      hash[dnf.f] = parseInt(id, 10);
    } // at some point, add the other cultures here...

  });

  return hash;
}

var defaultFmtHash = hashDefaultFormats(); // NumFmt encapsulates translation between number format and xlsx

var NumFmtXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(NumFmtXform, _BaseXform);

  function NumFmtXform(id, formatCode) {
    var _this;

    _classCallCheck(this, NumFmtXform);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(NumFmtXform).call(this));
    _this.id = id;
    _this.formatCode = formatCode;
    return _this;
  }

  _createClass(NumFmtXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.leafNode('numFmt', {
        numFmtId: model.id,
        formatCode: model.formatCode
      });
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      switch (node.name) {
        case 'numFmt':
          this.model = {
            id: parseInt(node.attributes.numFmtId, 10),
            formatCode: node.attributes.formatCode.replace(/[\\](.)/g, '$1')
          };
          return true;

        default:
          return false;
      }
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose() {
      return false;
    }
  }, {
    key: "tag",
    get: function get() {
      return 'numFmt';
    }
  }]);

  return NumFmtXform;
}(BaseXform);

NumFmtXform.getDefaultFmtId = function getDefaultFmtId(formatCode) {
  return defaultFmtHash[formatCode];
};

NumFmtXform.getDefaultFmtCode = function getDefaultFmtCode(numFmtId) {
  return defaultNumFormats[numFmtId] && defaultNumFormats[numFmtId].f;
};

module.exports = NumFmtXform;


},{"../../../utils/under-dash":24,"../../defaultnumformats":28,"../base-xform":30}],102:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var BaseXform = require('../base-xform');

var validation = {
  "boolean": function boolean(value, dflt) {
    if (value === undefined) {
      return dflt;
    }

    return value;
  }
}; // Protection encapsulates translation from style.protection model to/from xlsx

var ProtectionXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(ProtectionXform, _BaseXform);

  function ProtectionXform() {
    _classCallCheck(this, ProtectionXform);

    return _possibleConstructorReturn(this, _getPrototypeOf(ProtectionXform).apply(this, arguments));
  }

  _createClass(ProtectionXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.addRollback();
      xmlStream.openNode('protection');
      var isValid = false;

      function add(name, value) {
        if (value !== undefined) {
          xmlStream.addAttribute(name, value);
          isValid = true;
        }
      }

      add('locked', validation["boolean"](model.locked, true) ? undefined : '0');
      add('hidden', validation["boolean"](model.hidden, false) ? '1' : undefined);
      xmlStream.closeNode();

      if (isValid) {
        xmlStream.commit();
      } else {
        xmlStream.rollback();
      }
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      var model = {
        locked: !(node.attributes.locked === '0'),
        hidden: node.attributes.hidden === '1'
      }; // only want to record models that differ from defaults

      var isSignificant = !model.locked || model.hidden;
      this.model = isSignificant ? model : null;
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose() {
      return false;
    }
  }, {
    key: "tag",
    get: function get() {
      return 'protection';
    }
  }]);

  return ProtectionXform;
}(BaseXform);

module.exports = ProtectionXform;


},{"../base-xform":30}],103:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var BaseXform = require('../base-xform');

var AlignmentXform = require('./alignment-xform');

var ProtectionXform = require('./protection-xform'); // <xf numFmtId="[numFmtId]" fontId="[fontId]" fillId="[fillId]" borderId="[xf.borderId]" xfId="[xfId]">
//   Optional <alignment>
//   Optional <protection>
// </xf>
// Style assists translation from style model to/from xlsx


var StyleXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(StyleXform, _BaseXform);

  function StyleXform(options) {
    var _this;

    _classCallCheck(this, StyleXform);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(StyleXform).call(this));
    _this.xfId = !!(options && options.xfId);
    _this.map = {
      alignment: new AlignmentXform(),
      protection: new ProtectionXform()
    };
    return _this;
  }

  _createClass(StyleXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.openNode('xf', {
        numFmtId: model.numFmtId || 0,
        fontId: model.fontId || 0,
        fillId: model.fillId || 0,
        borderId: model.borderId || 0
      });

      if (this.xfId) {
        xmlStream.addAttribute('xfId', model.xfId || 0);
      }

      if (model.numFmtId) {
        xmlStream.addAttribute('applyNumberFormat', '1');
      }

      if (model.fontId) {
        xmlStream.addAttribute('applyFont', '1');
      }

      if (model.fillId) {
        xmlStream.addAttribute('applyFill', '1');
      }

      if (model.borderId) {
        xmlStream.addAttribute('applyBorder', '1');
      }

      if (model.alignment) {
        xmlStream.addAttribute('applyAlignment', '1');
      }

      if (model.protection) {
        xmlStream.addAttribute('applyProtection', '1');
      }
      /**
       * Rendering tags causes close of XML stream.
       * Therefore adding attributes must be done before rendering tags.
       */


      if (model.alignment) {
        this.map.alignment.render(xmlStream, model.alignment);
      }

      if (model.protection) {
        this.map.protection.render(xmlStream, model.protection);
      }

      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      } // used during sax parsing of xml to build font object


      switch (node.name) {
        case 'xf':
          this.model = {
            numFmtId: parseInt(node.attributes.numFmtId, 10),
            fontId: parseInt(node.attributes.fontId, 10),
            fillId: parseInt(node.attributes.fillId, 10),
            borderId: parseInt(node.attributes.borderId, 10)
          };

          if (this.xfId) {
            this.model.xfId = parseInt(node.attributes.xfId, 10);
          }

          return true;

        case 'alignment':
          this.parser = this.map.alignment;
          this.parser.parseOpen(node);
          return true;

        case 'protection':
          this.parser = this.map.protection;
          this.parser.parseOpen(node);
          return true;

        default:
          return false;
      }
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      if (this.parser) {
        this.parser.parseText(text);
      }
    }
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      if (this.parser) {
        if (!this.parser.parseClose(name)) {
          this.model.alignment = this.parser.model;
          this.parser = undefined;
        }

        return true;
      }

      return name !== 'xf';
    }
  }, {
    key: "tag",
    get: function get() {
      return 'xf';
    }
  }]);

  return StyleXform;
}(BaseXform);

module.exports = StyleXform;


},{"../base-xform":30,"./alignment-xform":95,"./protection-xform":102}],104:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var PromiseLib = require('../../../utils/promise');

var Enums = require('../../../doc/enums');

var XmlStream = require('../../../utils/xml-stream');

var BaseXform = require('../base-xform');

var StaticXform = require('../static-xform');

var ListXform = require('../list-xform');

var FontXform = require('./font-xform');

var FillXform = require('./fill-xform');

var BorderXform = require('./border-xform');

var NumFmtXform = require('./numfmt-xform');

var StyleXform = require('./style-xform');

var DxfXform = require('./dxf-xform'); // custom numfmt ids start here


var NUMFMT_BASE = 164; // =============================================================================
// StylesXform is used to generate and parse the styles.xml file
// it manages the collections of fonts, number formats, alignments, etc

var StylesXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(StylesXform, _BaseXform);

  function StylesXform(initialise) {
    var _this;

    _classCallCheck(this, StylesXform);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(StylesXform).call(this));
    _this.map = {
      numFmts: new ListXform({
        tag: 'numFmts',
        count: true,
        childXform: new NumFmtXform()
      }),
      fonts: new ListXform({
        tag: 'fonts',
        count: true,
        childXform: new FontXform(),
        $: {
          'x14ac:knownFonts': 1
        }
      }),
      fills: new ListXform({
        tag: 'fills',
        count: true,
        childXform: new FillXform()
      }),
      borders: new ListXform({
        tag: 'borders',
        count: true,
        childXform: new BorderXform()
      }),
      cellStyleXfs: new ListXform({
        tag: 'cellStyleXfs',
        count: true,
        childXform: new StyleXform()
      }),
      cellXfs: new ListXform({
        tag: 'cellXfs',
        count: true,
        childXform: new StyleXform({
          xfId: true
        })
      }),
      dxfs: new ListXform({
        tag: 'dxfs',
        always: true,
        count: true,
        childXform: new DxfXform()
      }),
      // for style manager
      numFmt: new NumFmtXform(),
      font: new FontXform(),
      fill: new FillXform(),
      border: new BorderXform(),
      style: new StyleXform({
        xfId: true
      }),
      cellStyles: StylesXform.STATIC_XFORMS.cellStyles,
      tableStyles: StylesXform.STATIC_XFORMS.tableStyles,
      extLst: StylesXform.STATIC_XFORMS.extLst
    };

    if (initialise) {
      // StylesXform also acts as style manager and is used to build up styles-model during worksheet processing
      _this.init();
    }

    return _this;
  }

  _createClass(StylesXform, [{
    key: "initIndex",
    value: function initIndex() {
      this.index = {
        style: {},
        numFmt: {},
        numFmtNextId: 164,
        // start custom format ids here
        font: {},
        border: {},
        fill: {}
      };
    }
  }, {
    key: "init",
    value: function init() {
      // Prepare for Style Manager role
      this.model = {
        styles: [],
        numFmts: [],
        fonts: [],
        borders: [],
        fills: [],
        dxfs: []
      };
      this.initIndex(); // default (zero) border

      this._addBorder({}); // add default (all zero) style


      this._addStyle({
        numFmtId: 0,
        fontId: 0,
        fillId: 0,
        borderId: 0,
        xfId: 0
      }); // add default fills


      this._addFill({
        type: 'pattern',
        pattern: 'none'
      });

      this._addFill({
        type: 'pattern',
        pattern: 'gray125'
      });
    }
  }, {
    key: "render",
    value: function render(xmlStream, model) {
      model = model || this.model; //
      //   <fonts count="2" x14ac:knownFonts="1">

      xmlStream.openXml(XmlStream.StdDocAttributes);
      xmlStream.openNode('styleSheet', StylesXform.STYLESHEET_ATTRIBUTES);

      if (this.index) {
        // model has been built by style manager role (contains xml)
        if (model.numFmts && model.numFmts.length) {
          xmlStream.openNode('numFmts', {
            count: model.numFmts.length
          });
          model.numFmts.forEach(function (numFmtXml) {
            xmlStream.writeXml(numFmtXml);
          });
          xmlStream.closeNode();
        }

        if (!model.fonts.length) {
          // default (zero) font
          this._addFont({
            size: 11,
            color: {
              theme: 1
            },
            name: 'Calibri',
            family: 2,
            scheme: 'minor'
          });
        }

        xmlStream.openNode('fonts', {
          count: model.fonts.length,
          'x14ac:knownFonts': 1
        });
        model.fonts.forEach(function (fontXml) {
          xmlStream.writeXml(fontXml);
        });
        xmlStream.closeNode();
        xmlStream.openNode('fills', {
          count: model.fills.length
        });
        model.fills.forEach(function (fillXml) {
          xmlStream.writeXml(fillXml);
        });
        xmlStream.closeNode();
        xmlStream.openNode('borders', {
          count: model.borders.length
        });
        model.borders.forEach(function (borderXml) {
          xmlStream.writeXml(borderXml);
        });
        xmlStream.closeNode();
        this.map.cellStyleXfs.render(xmlStream, [{
          numFmtId: 0,
          fontId: 0,
          fillId: 0,
          borderId: 0,
          xfId: 0
        }]);
        xmlStream.openNode('cellXfs', {
          count: model.styles.length
        });
        model.styles.forEach(function (styleXml) {
          xmlStream.writeXml(styleXml);
        });
        xmlStream.closeNode();
      } else {
        // model is plain JSON and needs to be xformed
        this.map.numFmts.render(xmlStream, model.numFmts);
        this.map.fonts.render(xmlStream, model.fonts);
        this.map.fills.render(xmlStream, model.fills);
        this.map.borders.render(xmlStream, model.borders);
        this.map.cellStyleXfs.render(xmlStream, [{
          numFmtId: 0,
          fontId: 0,
          fillId: 0,
          borderId: 0,
          xfId: 0
        }]);
        this.map.cellXfs.render(xmlStream, model.styles);
      }

      StylesXform.STATIC_XFORMS.cellStyles.render(xmlStream);
      this.map.dxfs.render(xmlStream, model.dxfs);
      StylesXform.STATIC_XFORMS.tableStyles.render(xmlStream);
      StylesXform.STATIC_XFORMS.extLst.render(xmlStream);
      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      switch (node.name) {
        case 'styleSheet':
          this.initIndex();
          return true;

        default:
          this.parser = this.map[node.name];

          if (this.parser) {
            this.parser.parseOpen(node);
          }

          return true;
      }
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      if (this.parser) {
        this.parser.parseText(text);
      }
    }
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      var _this2 = this;

      if (this.parser) {
        if (!this.parser.parseClose(name)) {
          this.parser = undefined;
        }

        return true;
      }

      switch (name) {
        case 'styleSheet':
          {
            this.model = {};

            var add = function add(propName, xform) {
              if (xform.model && xform.model.length) {
                _this2.model[propName] = xform.model;
              }
            };

            add('numFmts', this.map.numFmts);
            add('fonts', this.map.fonts);
            add('fills', this.map.fills);
            add('borders', this.map.borders);
            add('styles', this.map.cellXfs);
            add('dxfs', this.map.dxfs); // index numFmts

            this.index = {
              model: [],
              numFmt: []
            };

            if (this.model.numFmts) {
              var numFmtIndex = this.index.numFmt;
              this.model.numFmts.forEach(function (numFmt) {
                numFmtIndex[numFmt.id] = numFmt.formatCode;
              });
            }

            return false;
          }

        default:
          // not quite sure how we get here!
          return true;
      }
    } // add a cell's style model to the collection
    // each style property is processed and cross-referenced, etc.
    // the styleId is returned. Note: cellType is used when numFmt not defined

  }, {
    key: "addStyleModel",
    value: function addStyleModel(model, cellType) {
      if (!model) {
        return 0;
      } // if we have no default font, add it here now


      if (!this.model.fonts.length) {
        // default (zero) font
        this._addFont({
          size: 11,
          color: {
            theme: 1
          },
          name: 'Calibri',
          family: 2,
          scheme: 'minor'
        });
      } // if we have seen this style object before, assume it has the same styleId


      if (this.weakMap && this.weakMap.has(model)) {
        return this.weakMap.get(model);
      }

      var style = {};
      cellType = cellType || Enums.ValueType.Number;

      if (model.numFmt) {
        style.numFmtId = this._addNumFmtStr(model.numFmt);
      } else {
        switch (cellType) {
          case Enums.ValueType.Number:
            style.numFmtId = this._addNumFmtStr('General');
            break;

          case Enums.ValueType.Date:
            style.numFmtId = this._addNumFmtStr('mm-dd-yy');
            break;

          default:
            break;
        }
      }

      if (model.font) {
        style.fontId = this._addFont(model.font);
      }

      if (model.border) {
        style.borderId = this._addBorder(model.border);
      }

      if (model.fill) {
        style.fillId = this._addFill(model.fill);
      }

      if (model.alignment) {
        style.alignment = model.alignment;
      }

      if (model.protection) {
        style.protection = model.protection;
      }

      var styleId = this._addStyle(style);

      if (this.weakMap) {
        this.weakMap.set(model, styleId);
      }

      return styleId;
    } // given a styleId (i.e. s="n"), get the cell's style model
    // objects are shared where possible.

  }, {
    key: "getStyleModel",
    value: function getStyleModel(id) {
      // if the style doesn't exist return null
      var style = this.model.styles[id];
      if (!style) return null; // have we built this model before?

      var model = this.index.model[id];
      if (model) return model; // build a new model

      model = this.index.model[id] = {}; // -------------------------------------------------------
      // number format

      if (style.numFmtId) {
        var numFmt = this.index.numFmt[style.numFmtId] || NumFmtXform.getDefaultFmtCode(style.numFmtId);

        if (numFmt) {
          model.numFmt = numFmt;
        }
      }

      function addStyle(name, group, styleId) {
        if (styleId || styleId === 0) {
          var part = group[styleId];

          if (part) {
            model[name] = part;
          }
        }
      }

      addStyle('font', this.model.fonts, style.fontId);
      addStyle('border', this.model.borders, style.borderId);
      addStyle('fill', this.model.fills, style.fillId); // -------------------------------------------------------
      // alignment

      if (style.alignment) {
        model.alignment = style.alignment;
      } // -------------------------------------------------------
      // protection


      if (style.protection) {
        model.protection = style.protection;
      }

      return model;
    }
  }, {
    key: "addDxfStyle",
    value: function addDxfStyle(style) {
      this.model.dxfs.push(style);
      return this.model.dxfs.length - 1;
    }
  }, {
    key: "getDxfStyle",
    value: function getDxfStyle(id) {
      return this.model.dxfs[id];
    } // =========================================================================
    // Private Interface

  }, {
    key: "_addStyle",
    value: function _addStyle(style) {
      var xml = this.map.style.toXml(style);
      var index = this.index.style[xml];

      if (index === undefined) {
        index = this.index.style[xml] = this.model.styles.length;
        this.model.styles.push(xml);
      }

      return index;
    } // =========================================================================
    // Number Formats

  }, {
    key: "_addNumFmtStr",
    value: function _addNumFmtStr(formatCode) {
      // check if default format
      var index = NumFmtXform.getDefaultFmtId(formatCode);
      if (index !== undefined) return index; // check if already in

      index = this.index.numFmt[formatCode];
      if (index !== undefined) return index;
      index = this.index.numFmt[formatCode] = NUMFMT_BASE + this.model.numFmts.length;
      var xml = this.map.numFmt.toXml({
        id: index,
        formatCode: formatCode
      });
      this.model.numFmts.push(xml);
      return index;
    } // =========================================================================
    // Fonts

  }, {
    key: "_addFont",
    value: function _addFont(font) {
      var xml = this.map.font.toXml(font);
      var index = this.index.font[xml];

      if (index === undefined) {
        index = this.index.font[xml] = this.model.fonts.length;
        this.model.fonts.push(xml);
      }

      return index;
    } // =========================================================================
    // Borders

  }, {
    key: "_addBorder",
    value: function _addBorder(border) {
      var xml = this.map.border.toXml(border);
      var index = this.index.border[xml];

      if (index === undefined) {
        index = this.index.border[xml] = this.model.borders.length;
        this.model.borders.push(xml);
      }

      return index;
    } // =========================================================================
    // Fills

  }, {
    key: "_addFill",
    value: function _addFill(fill) {
      var xml = this.map.fill.toXml(fill);
      var index = this.index.fill[xml];

      if (index === undefined) {
        index = this.index.fill[xml] = this.model.fills.length;
        this.model.fills.push(xml);
      }

      return index;
    } // =========================================================================

  }]);

  return StylesXform;
}(BaseXform);

StylesXform.STYLESHEET_ATTRIBUTES = {
  xmlns: 'http://schemas.openxmlformats.org/spreadsheetml/2006/main',
  'xmlns:mc': 'http://schemas.openxmlformats.org/markup-compatibility/2006',
  'mc:Ignorable': 'x14ac x16r2',
  'xmlns:x14ac': 'http://schemas.microsoft.com/office/spreadsheetml/2009/9/ac',
  'xmlns:x16r2': 'http://schemas.microsoft.com/office/spreadsheetml/2015/02/main'
};
StylesXform.STATIC_XFORMS = {
  cellStyles: new StaticXform({
    tag: 'cellStyles',
    $: {
      count: 1
    },
    c: [{
      tag: 'cellStyle',
      $: {
        name: 'Normal',
        xfId: 0,
        builtinId: 0
      }
    }]
  }),
  dxfs: new StaticXform({
    tag: 'dxfs',
    $: {
      count: 0
    }
  }),
  tableStyles: new StaticXform({
    tag: 'tableStyles',
    $: {
      count: 0,
      defaultTableStyle: 'TableStyleMedium2',
      defaultPivotStyle: 'PivotStyleLight16'
    }
  }),
  extLst: new StaticXform({
    tag: 'extLst',
    c: [{
      tag: 'ext',
      $: {
        uri: '{EB79DEF2-80B8-43e5-95BD-54CBDDF9020C}',
        'xmlns:x14': 'http://schemas.microsoft.com/office/spreadsheetml/2009/9/main'
      },
      c: [{
        tag: 'x14:slicerStyles',
        $: {
          defaultSlicerStyle: 'SlicerStyleLight1'
        }
      }]
    }, {
      tag: 'ext',
      $: {
        uri: '{9260A510-F301-46a8-8635-F512D64BE5F5}',
        'xmlns:x15': 'http://schemas.microsoft.com/office/spreadsheetml/2010/11/main'
      },
      c: [{
        tag: 'x15:timelineStyles',
        $: {
          defaultTimelineStyle: 'TimeSlicerStyleLight1'
        }
      }]
    }]
  })
}; // the stylemanager mock acts like StyleManager except that it always returns 0 or {}

var StylesXformMock =
/*#__PURE__*/
function (_StylesXform) {
  _inherits(StylesXformMock, _StylesXform);

  function StylesXformMock() {
    var _this3;

    _classCallCheck(this, StylesXformMock);

    _this3 = _possibleConstructorReturn(this, _getPrototypeOf(StylesXformMock).call(this));
    _this3.model = {
      styles: [{
        numFmtId: 0,
        fontId: 0,
        fillId: 0,
        borderId: 0,
        xfId: 0
      }],
      numFmts: [],
      fonts: [{
        size: 11,
        color: {
          theme: 1
        },
        name: 'Calibri',
        family: 2,
        scheme: 'minor'
      }],
      borders: [{}],
      fills: [{
        type: 'pattern',
        pattern: 'none'
      }, {
        type: 'pattern',
        pattern: 'gray125'
      }]
    };
    return _this3;
  } // =========================================================================
  // Style Manager Interface
  // override normal behaviour - consume and dispose


  _createClass(StylesXformMock, [{
    key: "parseStream",
    value: function parseStream(stream) {
      stream.autodrain();
      return PromiseLib.Promise.resolve();
    } // add a cell's style model to the collection
    // each style property is processed and cross-referenced, etc.
    // the styleId is returned. Note: cellType is used when numFmt not defined

  }, {
    key: "addStyleModel",
    value: function addStyleModel(model, cellType) {
      switch (cellType) {
        case Enums.ValueType.Date:
          return this.dateStyleId;

        default:
          return 0;
      }
    }
  }, {
    key: "getStyleModel",
    // given a styleId (i.e. s="n"), get the cell's style model
    // objects are shared where possible.
    value: function getStyleModel()
    /* id */
    {
      return {};
    }
  }, {
    key: "dateStyleId",
    get: function get() {
      if (!this._dateStyleId) {
        var dateStyle = {
          numFmtId: NumFmtXform.getDefaultFmtId('mm-dd-yy')
        };
        this._dateStyleId = this.model.styles.length;
        this.model.styles.push(dateStyle);
      }

      return this._dateStyleId;
    }
  }]);

  return StylesXformMock;
}(StylesXform);

StylesXform.Mock = StylesXformMock;
module.exports = StylesXform;


},{"../../../doc/enums":8,"../../../utils/promise":20,"../../../utils/xml-stream":26,"../base-xform":30,"../list-xform":59,"../static-xform":89,"./border-xform":96,"./dxf-xform":98,"./fill-xform":99,"./font-xform":100,"./numfmt-xform":101,"./style-xform":103}],105:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var BaseXform = require('../base-xform');

var UnderlineXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(UnderlineXform, _BaseXform);

  function UnderlineXform(model) {
    var _this;

    _classCallCheck(this, UnderlineXform);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(UnderlineXform).call(this));
    _this.model = model;
    return _this;
  }

  _createClass(UnderlineXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      model = model || this.model;

      if (model === true) {
        xmlStream.leafNode('u');
      } else {
        var attr = UnderlineXform.Attributes[model];

        if (attr) {
          xmlStream.leafNode('u', attr);
        }
      }
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (node.name === 'u') {
        this.model = node.attributes.val || true;
      }
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose() {
      return false;
    }
  }, {
    key: "tag",
    get: function get() {
      return 'u';
    }
  }]);

  return UnderlineXform;
}(BaseXform);

UnderlineXform.Attributes = {
  single: {},
  "double": {
    val: 'double'
  },
  singleAccounting: {
    val: 'singleAccounting'
  },
  doubleAccounting: {
    val: 'doubleAccounting'
  }
};
module.exports = UnderlineXform;


},{"../base-xform":30}],106:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var BaseXform = require('../base-xform');

var FilterColumnXform = require('./filter-column-xform');

var AutoFilterXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(AutoFilterXform, _BaseXform);

  function AutoFilterXform() {
    var _this;

    _classCallCheck(this, AutoFilterXform);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(AutoFilterXform).call(this));
    _this.map = {
      filterColumn: new FilterColumnXform()
    };
    return _this;
  }

  _createClass(AutoFilterXform, [{
    key: "prepare",
    value: function prepare(model) {
      var _this2 = this;

      model.columns.forEach(function (column, index) {
        _this2.map.filterColumn.prepare(column, {
          index: index
        });
      });
    }
  }, {
    key: "render",
    value: function render(xmlStream, model) {
      var _this3 = this;

      xmlStream.openNode(this.tag, {
        ref: model.autoFilterRef
      });
      model.columns.forEach(function (column) {
        _this3.map.filterColumn.render(xmlStream, column);
      });
      xmlStream.closeNode();
      return true;
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      switch (node.name) {
        case this.tag:
          this.model = {
            autoFilterRef: node.attributes.ref,
            columns: []
          };
          return true;

        default:
          this.parser = this.map[node.name];

          if (this.parser) {
            this.parseOpen(node);
            return true;
          }

          throw new Error("Unexpected xml node in parseOpen: ".concat(JSON.stringify(node)));
      }
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      if (this.parser) {
        this.parser.parseText(text);
      }
    }
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      if (this.parser) {
        if (!this.parser.parseClose(name)) {
          this.model.columns.push(this.parser.model);
          this.parser = undefined;
        }

        return true;
      }

      switch (name) {
        case this.tag:
          return false;

        default:
          throw new Error("Unexpected xml node in parseClose: ".concat(name));
      }
    }
  }, {
    key: "tag",
    get: function get() {
      return 'autoFilter';
    }
  }]);

  return AutoFilterXform;
}(BaseXform);

module.exports = AutoFilterXform;


},{"../base-xform":30,"./filter-column-xform":107}],107:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var BaseXform = require('../base-xform');

var FilterColumnXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(FilterColumnXform, _BaseXform);

  function FilterColumnXform() {
    _classCallCheck(this, FilterColumnXform);

    return _possibleConstructorReturn(this, _getPrototypeOf(FilterColumnXform).apply(this, arguments));
  }

  _createClass(FilterColumnXform, [{
    key: "prepare",
    value: function prepare(model, options) {
      model.colId = options.index.toString();
    }
  }, {
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.leafNode(this.tag, {
        colId: model.colId,
        hiddenButton: model.filterButton ? '0' : '1'
      });
      return true;
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (node.name === this.tag) {
        var attributes = node.attributes;
        this.model = {
          filterButton: attributes.hiddenButton === '0'
        };
        return true;
      }

      return false;
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose() {
      return false;
    }
  }, {
    key: "tag",
    get: function get() {
      return 'filterColumn';
    }
  }]);

  return FilterColumnXform;
}(BaseXform);

module.exports = FilterColumnXform;


},{"../base-xform":30}],108:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var BaseXform = require('../base-xform');

var TableColumnXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(TableColumnXform, _BaseXform);

  function TableColumnXform() {
    _classCallCheck(this, TableColumnXform);

    return _possibleConstructorReturn(this, _getPrototypeOf(TableColumnXform).apply(this, arguments));
  }

  _createClass(TableColumnXform, [{
    key: "prepare",
    value: function prepare(model, options) {
      model.id = options.index + 1;
    }
  }, {
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.leafNode(this.tag, {
        id: model.id.toString(),
        name: model.name,
        totalsRowLabel: model.totalsRowLabel,
        totalsRowFunction: model.totalsRowFunction,
        dxfId: model.dxfId
      });
      return true;
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (node.name === this.tag) {
        var attributes = node.attributes;
        this.model = {
          name: attributes.name,
          totalsRowLabel: attributes.totalsRowLabel,
          totalsRowFunction: attributes.totalsRowFunction,
          dxfId: attributes.dxfId
        };
        return true;
      }

      return false;
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose() {
      return false;
    }
  }, {
    key: "tag",
    get: function get() {
      return 'tableColumn';
    }
  }]);

  return TableColumnXform;
}(BaseXform);

module.exports = TableColumnXform;


},{"../base-xform":30}],109:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var BaseXform = require('../base-xform');

var TableStyleInfoXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(TableStyleInfoXform, _BaseXform);

  function TableStyleInfoXform() {
    _classCallCheck(this, TableStyleInfoXform);

    return _possibleConstructorReturn(this, _getPrototypeOf(TableStyleInfoXform).apply(this, arguments));
  }

  _createClass(TableStyleInfoXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.leafNode(this.tag, {
        name: model.theme ? model.theme : undefined,
        showFirstColumn: model.showFirstColumn ? '1' : '0',
        showLastColumn: model.showLastColumn ? '1' : '0',
        showRowStripes: model.showRowStripes ? '1' : '0',
        showColumnStripes: model.showColumnStripes ? '1' : '0'
      });
      return true;
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (node.name === this.tag) {
        var attributes = node.attributes;
        this.model = {
          theme: attributes.name ? attributes.name : null,
          showFirstColumn: attributes.showFirstColumn === '1',
          showLastColumn: attributes.showLastColumn === '1',
          showRowStripes: attributes.showRowStripes === '1',
          showColumnStripes: attributes.showColumnStripes === '1'
        };
        return true;
      }

      return false;
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose() {
      return false;
    }
  }, {
    key: "tag",
    get: function get() {
      return 'tableStyleInfo';
    }
  }]);

  return TableStyleInfoXform;
}(BaseXform);

module.exports = TableStyleInfoXform;


},{"../base-xform":30}],110:[function(require,module,exports){
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var XmlStream = require('../../../utils/xml-stream');

var BaseXform = require('../base-xform');

var ListXform = require('../list-xform');

var AutoFilterXform = require('./auto-filter-xform');

var TableColumnXform = require('./table-column-xform');

var TableStyleInfoXform = require('./table-style-info-xform');

var TableXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(TableXform, _BaseXform);

  function TableXform() {
    var _this;

    _classCallCheck(this, TableXform);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(TableXform).call(this));
    _this.map = {
      autoFilter: new AutoFilterXform(),
      tableColumns: new ListXform({
        tag: 'tableColumns',
        count: true,
        empty: true,
        childXform: new TableColumnXform()
      }),
      tableStyleInfo: new TableStyleInfoXform()
    };
    return _this;
  }

  _createClass(TableXform, [{
    key: "prepare",
    value: function prepare(model, options) {
      this.map.autoFilter.prepare(model);
      this.map.tableColumns.prepare(model.columns, options);
    }
  }, {
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.openXml(XmlStream.StdDocAttributes);
      xmlStream.openNode(this.tag, _objectSpread({}, TableXform.TABLE_ATTRIBUTES, {
        id: model.id,
        name: model.name,
        displayName: model.displayName || model.name,
        ref: model.tableRef,
        totalsRowCount: model.totalsRow ? '1' : undefined,
        totalsRowShown: model.totalsRow ? undefined : '1',
        headerRowCount: model.headerRow ? '1' : '0'
      }));
      this.map.autoFilter.render(xmlStream, model);
      this.map.tableColumns.render(xmlStream, model.columns);
      this.map.tableStyleInfo.render(xmlStream, model.style);
      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      var name = node.name,
          attributes = node.attributes;

      switch (name) {
        case this.tag:
          this.reset();
          this.model = {
            name: attributes.name,
            displayName: attributes.displayName || attributes.name,
            tableRef: attributes.ref,
            totalsRow: attributes.totalsRowCount === '1',
            headerRow: attributes.headerRowCount === '1'
          };
          break;

        default:
          this.parser = this.map[node.name];

          if (this.parser) {
            this.parser.parseOpen(node);
          }

          break;
      }

      return true;
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      if (this.parser) {
        this.parser.parseText(text);
      }
    }
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      var _this2 = this;

      if (this.parser) {
        if (!this.parser.parseClose(name)) {
          this.parser = undefined;
        }

        return true;
      }

      switch (name) {
        case this.tag:
          this.model.autoFilterRef = this.map.autoFilter.model.autoFilterRef;
          this.model.columns = this.map.tableColumns.model;
          this.map.autoFilter.model.columns.forEach(function (column, index) {
            _this2.model.columns[index].filterButton = column.filterButton;
          });
          this.model.style = this.map.tableStyleInfo.model;
          return false;

        default:
          // could be some unrecognised tags
          return true;
      }
    }
  }, {
    key: "reconcile",
    value: function reconcile(model, options) {
      // fetch the dfxs from styles
      model.columns.forEach(function (column) {
        if (column.dxfId !== undefined) {
          column.style = options.styles.getDxfStyle(column.dxfId);
        }
      });
    }
  }, {
    key: "tag",
    get: function get() {
      return 'table';
    }
  }]);

  return TableXform;
}(BaseXform);

TableXform.TABLE_ATTRIBUTES = {
  'xmlns': 'http://schemas.openxmlformats.org/spreadsheetml/2006/main',
  'xmlns:mc': 'http://schemas.openxmlformats.org/markup-compatibility/2006',
  'mc:Ignorable': 'xr xr3',
  'xmlns:xr': 'http://schemas.microsoft.com/office/spreadsheetml/2014/revision',
  'xmlns:xr3': 'http://schemas.microsoft.com/office/spreadsheetml/2016/revision3' // 'xr:uid': '{00000000-000C-0000-FFFF-FFFF00000000}',

};
module.exports = TableXform;


},{"../../../utils/xml-stream":26,"../base-xform":30,"../list-xform":59,"./auto-filter-xform":106,"./table-column-xform":108,"./table-style-info-xform":109}],111:[function(require,module,exports){
(function (Buffer){
"use strict";

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var fs = require('fs');

var ZipStream = require('../utils/zip-stream');

var StreamBuf = require('../utils/stream-buf');

var PromiseLib = require('../utils/promise');

var utils = require('../utils/utils');

var XmlStream = require('../utils/xml-stream');

var StylesXform = require('./xform/style/styles-xform');

var CoreXform = require('./xform/core/core-xform');

var SharedStringsXform = require('./xform/strings/shared-strings-xform');

var RelationshipsXform = require('./xform/core/relationships-xform');

var ContentTypesXform = require('./xform/core/content-types-xform');

var AppXform = require('./xform/core/app-xform');

var WorkbookXform = require('./xform/book/workbook-xform');

var WorksheetXform = require('./xform/sheet/worksheet-xform');

var DrawingXform = require('./xform/drawing/drawing-xform');

var TableXform = require('./xform/table/table-xform');

var CommentsXform = require('./xform/comment/comments-xform');

var VmlNotesXform = require('./xform/comment/vml-notes-xform');

var theme1Xml = require('./xml/theme1.js');

function fsReadFileAsync(filename, options) {
  return new PromiseLib.Promise(function (resolve, reject) {
    fs.readFile(filename, options, function (error, data) {
      if (error) {
        reject(error);
      } else {
        resolve(data);
      }
    });
  });
}

var XLSX =
/*#__PURE__*/
function () {
  function XLSX(workbook) {
    _classCallCheck(this, XLSX);

    this.workbook = workbook;
  } // ===============================================================================
  // Workbook
  // =========================================================================
  // Read


  _createClass(XLSX, [{
    key: "readFile",
    value: function readFile(filename, options) {
      var _this = this;

      var stream;
      return utils.fs.exists(filename).then(function (exists) {
        if (!exists) {
          throw new Error("File not found: ".concat(filename));
        }

        stream = fs.createReadStream(filename);
        return _this.read(stream, options)["catch"](function (error) {
          stream.close();
          throw error;
        });
      }).then(function (workbook) {
        stream.close();
        return workbook;
      });
    }
  }, {
    key: "parseRels",
    value: function parseRels(stream) {
      var xform = new RelationshipsXform();
      return xform.parseStream(stream);
    }
  }, {
    key: "parseWorkbook",
    value: function parseWorkbook(stream) {
      var xform = new WorkbookXform();
      return xform.parseStream(stream);
    }
  }, {
    key: "parseSharedStrings",
    value: function parseSharedStrings(stream) {
      var xform = new SharedStringsXform();
      return xform.parseStream(stream);
    }
  }, {
    key: "reconcile",
    value: function reconcile(model, options) {
      var workbookXform = new WorkbookXform();
      var worksheetXform = new WorksheetXform(options);
      var drawingXform = new DrawingXform();
      var tableXform = new TableXform();
      workbookXform.reconcile(model); // reconcile drawings with their rels

      var drawingOptions = {
        media: model.media,
        mediaIndex: model.mediaIndex
      };
      Object.keys(model.drawings).forEach(function (name) {
        var drawing = model.drawings[name];
        var drawingRel = model.drawingRels[name];

        if (drawingRel) {
          drawingOptions.rels = drawingRel.reduce(function (o, rel) {
            o[rel.Id] = rel;
            return o;
          }, {});
          drawingXform.reconcile(drawing, drawingOptions);
        }
      }); // reconcile tables with the default styles

      var tableOptions = {
        styles: model.styles
      };
      Object.values(model.tables).forEach(function (table) {
        tableXform.reconcile(table, tableOptions);
      });
      var sheetOptions = {
        styles: model.styles,
        sharedStrings: model.sharedStrings,
        media: model.media,
        mediaIndex: model.mediaIndex,
        date1904: model.properties && model.properties.date1904,
        drawings: model.drawings,
        comments: model.comments,
        tables: model.tables
      };
      model.worksheets.forEach(function (worksheet) {
        worksheet.relationships = model.worksheetRels[worksheet.sheetNo];
        worksheetXform.reconcile(worksheet, sheetOptions);
      }); // delete unnecessary parts

      delete model.worksheetHash;
      delete model.worksheetRels;
      delete model.globalRels;
      delete model.sharedStrings;
      delete model.workbookRels;
      delete model.sheetDefs;
      delete model.styles;
      delete model.mediaIndex;
      delete model.drawings;
      delete model.drawingRels;
    }
  }, {
    key: "processWorksheetEntry",
    value: function processWorksheetEntry(entry, model, options) {
      var match = entry.path.match(/xl\/worksheets\/sheet(\d+)[.]xml/);

      if (match) {
        var sheetNo = match[1];
        var xform = new WorksheetXform(options);
        return xform.parseStream(entry).then(function (worksheet) {
          worksheet.sheetNo = sheetNo;
          model.worksheetHash[entry.path] = worksheet;
          model.worksheets.push(worksheet);
        });
      }

      return undefined;
    }
  }, {
    key: "processCommentEntry",
    value: function processCommentEntry(entry, model) {
      var match = entry.path.match(/xl\/(comments\d+)[.]xml/);

      if (match) {
        var name = match[1];
        var xform = new CommentsXform();
        return xform.parseStream(entry).then(function (comments) {
          model.comments["../".concat(name, ".xml")] = comments;
        });
      }

      return undefined;
    }
  }, {
    key: "processTableEntry",
    value: function processTableEntry(entry, model) {
      var match = entry.path.match(/xl\/tables\/(table\d+)[.]xml/);

      if (match) {
        var name = match[1];
        var xform = new TableXform();
        return xform.parseStream(entry).then(function (table) {
          model.tables["../tables/".concat(name, ".xml")] = table;
        });
      }

      return undefined;
    }
  }, {
    key: "processWorksheetRelsEntry",
    value: function processWorksheetRelsEntry(entry, model) {
      var match = entry.path.match(/xl\/worksheets\/_rels\/sheet(\d+)[.]xml.rels/);

      if (match) {
        var sheetNo = match[1];
        var xform = new RelationshipsXform();
        return xform.parseStream(entry).then(function (relationships) {
          model.worksheetRels[sheetNo] = relationships;
        });
      }

      return undefined;
    }
  }, {
    key: "processMediaEntry",
    value: function processMediaEntry(entry, model) {
      var match = entry.path.match(/xl\/media\/([a-zA-Z0-9]+[.][a-zA-Z0-9]{3,4})$/);

      if (match) {
        var filename = match[1];
        var lastDot = filename.lastIndexOf('.');

        if (lastDot === -1) {
          // if we can't determine extension, ignore it
          return undefined;
        }

        var extension = filename.substr(lastDot + 1);
        var name = filename.substr(0, lastDot);
        return new PromiseLib.Promise(function (resolve, reject) {
          var streamBuf = new StreamBuf();
          streamBuf.on('finish', function () {
            model.mediaIndex[filename] = model.media.length;
            model.mediaIndex[name] = model.media.length;
            var medium = {
              type: 'image',
              name: name,
              extension: extension,
              buffer: streamBuf.toBuffer()
            };
            model.media.push(medium);
            resolve();
          });
          entry.on('error', function (error) {
            reject(error);
          });
          entry.pipe(streamBuf);
        });
      }

      return undefined;
    }
  }, {
    key: "processDrawingEntry",
    value: function processDrawingEntry(entry, model) {
      var match = entry.path.match(/xl\/drawings\/([a-zA-Z0-9]+)[.]xml/);

      if (match) {
        var name = match[1];
        var xform = new DrawingXform();
        return xform.parseStream(entry).then(function (drawing) {
          model.drawings[name] = drawing;
        });
      }

      return undefined;
    }
  }, {
    key: "processDrawingRelsEntry",
    value: function processDrawingRelsEntry(entry, model) {
      var match = entry.path.match(/xl\/drawings\/_rels\/([a-zA-Z0-9]+)[.]xml[.]rels/);

      if (match) {
        var name = match[1];
        var xform = new RelationshipsXform();
        return xform.parseStream(entry).then(function (relationships) {
          model.drawingRels[name] = relationships;
        });
      }

      return undefined;
    }
  }, {
    key: "processThemeEntry",
    value: function processThemeEntry(entry, model) {
      var match = entry.path.match(/xl\/theme\/([a-zA-Z0-9]+)[.]xml/);

      if (match) {
        return new PromiseLib.Promise(function (resolve, reject) {
          var name = match[1]; // TODO: stream entry into buffer and store the xml in the model.themes[]

          var stream = new StreamBuf();
          entry.on('error', reject);
          stream.on('error', reject);
          stream.on('finish', function () {
            model.themes[name] = stream.read().toString();
            resolve();
          });
          entry.pipe(stream);
        });
      }

      return undefined;
    }
  }, {
    key: "processIgnoreEntry",
    value: function processIgnoreEntry(entry) {
      entry.autodrain();
    }
  }, {
    key: "createInputStream",
    value: function createInputStream(options) {
      var _this2 = this;

      var model = {
        worksheets: [],
        worksheetHash: {},
        worksheetRels: [],
        themes: {},
        media: [],
        mediaIndex: {},
        drawings: {},
        drawingRels: {},
        comments: {},
        tables: {}
      }; // we have to be prepared to read the zip entries in whatever order they arrive

      var promises = [];
      var stream = new ZipStream.ZipReader({
        getEntryType: function getEntryType(path) {
          return path.match(/xl\/media\//) ? 'nodebuffer' : 'string';
        }
      });
      stream.on('entry', function (entry) {
        var promise = null;
        var entryPath = entry.path;

        if (entryPath[0] === '/') {
          entryPath = entryPath.substr(1);
        }

        switch (entryPath) {
          case '_rels/.rels':
            promise = _this2.parseRels(entry).then(function (relationships) {
              model.globalRels = relationships;
            });
            break;

          case 'xl/workbook.xml':
            promise = _this2.parseWorkbook(entry).then(function (workbook) {
              model.sheets = workbook.sheets;
              model.definedNames = workbook.definedNames;
              model.views = workbook.views;
              model.properties = workbook.properties;
            });
            break;

          case 'xl/_rels/workbook.xml.rels':
            promise = _this2.parseRels(entry).then(function (relationships) {
              model.workbookRels = relationships;
            });
            break;

          case 'xl/sharedStrings.xml':
            model.sharedStrings = new SharedStringsXform();
            promise = model.sharedStrings.parseStream(entry);
            break;

          case 'xl/styles.xml':
            model.styles = new StylesXform();
            promise = model.styles.parseStream(entry);
            break;

          case 'docProps/app.xml':
            {
              var appXform = new AppXform();
              promise = appXform.parseStream(entry).then(function (appProperties) {
                Object.assign(model, {
                  company: appProperties.company,
                  manager: appProperties.manager
                });
              });
              break;
            }

          case 'docProps/core.xml':
            {
              var coreXform = new CoreXform();
              promise = coreXform.parseStream(entry).then(function (coreProperties) {
                Object.assign(model, coreProperties);
              });
              break;
            }

          default:
            promise = _this2.processWorksheetEntry(entry, model, options) || _this2.processWorksheetRelsEntry(entry, model) || _this2.processThemeEntry(entry, model) || _this2.processMediaEntry(entry, model) || _this2.processDrawingEntry(entry, model) || _this2.processCommentEntry(entry, model) || _this2.processTableEntry(entry, model) || _this2.processDrawingRelsEntry(entry, model) || _this2.processIgnoreEntry(entry);
            break;
        }

        if (promise) {
          promise = promise["catch"](function (error) {
            stream.destroy(error);
            throw error;
          });
          promises.push(promise);
          promise = null;
        }
      });
      stream.on('finished', function () {
        PromiseLib.Promise.all(promises).then(function () {
          _this2.reconcile(model, options); // apply model


          _this2.workbook.model = model;
        }).then(function () {
          stream.emit('done');
        })["catch"](function (error) {
          stream.emit('error', error);
        });
      });
      return stream;
    }
  }, {
    key: "read",
    value: function read(stream, options) {
      var _this3 = this;

      options = options || {};
      var zipStream = this.createInputStream(options);
      return new PromiseLib.Promise(function (resolve, reject) {
        zipStream.on('done', function () {
          resolve(_this3.workbook);
        }).on('error', function (error) {
          reject(error);
        });
        stream.pipe(zipStream);
      });
    }
  }, {
    key: "load",
    value: function load(data, options) {
      var _this4 = this;

      if (options === undefined) {
        options = {};
      }

      var zipStream = this.createInputStream();
      return new PromiseLib.Promise(function (resolve, reject) {
        zipStream.on('done', function () {
          resolve(_this4.workbook);
        }).on('error', function (error) {
          reject(error);
        });

        if (options.base64) {
          var buffer = Buffer.from(data.toString(), 'base64');
          zipStream.write(buffer);
        } else {
          zipStream.write(data);
        }

        zipStream.end();
      });
    } // =========================================================================
    // Write

  }, {
    key: "addMedia",
    value: function addMedia(zip, model) {
      return PromiseLib.Promise.all(model.media.map(function (medium) {
        if (medium.type === 'image') {
          var filename = "xl/media/".concat(medium.name, ".").concat(medium.extension);

          if (medium.filename) {
            return fsReadFileAsync(medium.filename).then(function (data) {
              zip.append(data, {
                name: filename
              });
            });
          }

          if (medium.buffer) {
            return new PromiseLib.Promise(function (resolve) {
              zip.append(medium.buffer, {
                name: filename
              });
              resolve();
            });
          }

          if (medium.base64) {
            return new PromiseLib.Promise(function (resolve) {
              var dataimg64 = medium.base64;
              var content = dataimg64.substring(dataimg64.indexOf(',') + 1);
              zip.append(content, {
                name: filename,
                base64: true
              });
              resolve();
            });
          }
        }

        return PromiseLib.Promise.reject(new Error('Unsupported media'));
      }));
    }
  }, {
    key: "addDrawings",
    value: function addDrawings(zip, model) {
      var drawingXform = new DrawingXform();
      var relsXform = new RelationshipsXform();
      model.worksheets.forEach(function (worksheet) {
        var drawing = worksheet.drawing;

        if (drawing) {
          drawingXform.prepare(drawing, {});
          var xml = drawingXform.toXml(drawing);
          zip.append(xml, {
            name: "xl/drawings/".concat(drawing.name, ".xml")
          });
          xml = relsXform.toXml(drawing.rels);
          zip.append(xml, {
            name: "xl/drawings/_rels/".concat(drawing.name, ".xml.rels")
          });
        }
      });
    }
  }, {
    key: "addTables",
    value: function addTables(zip, model) {
      var tableXform = new TableXform();
      model.worksheets.forEach(function (worksheet) {
        var tables = worksheet.tables;
        tables.forEach(function (table) {
          tableXform.prepare(table, {});
          var tableXml = tableXform.toXml(table);
          zip.append(tableXml, {
            name: "xl/tables/".concat(table.target)
          });
        });
      });
    }
  }, {
    key: "addContentTypes",
    value: function addContentTypes(zip, model) {
      return new PromiseLib.Promise(function (resolve) {
        var xform = new ContentTypesXform();
        var xml = xform.toXml(model);
        zip.append(xml, {
          name: '[Content_Types].xml'
        });
        resolve();
      });
    }
  }, {
    key: "addApp",
    value: function addApp(zip, model) {
      return new PromiseLib.Promise(function (resolve) {
        var xform = new AppXform();
        var xml = xform.toXml(model);
        zip.append(xml, {
          name: 'docProps/app.xml'
        });
        resolve();
      });
    }
  }, {
    key: "addCore",
    value: function addCore(zip, model) {
      return new PromiseLib.Promise(function (resolve) {
        var coreXform = new CoreXform();
        zip.append(coreXform.toXml(model), {
          name: 'docProps/core.xml'
        });
        resolve();
      });
    }
  }, {
    key: "addThemes",
    value: function addThemes(zip, model) {
      return new PromiseLib.Promise(function (resolve) {
        var themes = model.themes || {
          theme1: theme1Xml
        };
        Object.keys(themes).forEach(function (name) {
          var xml = themes[name];
          var path = "xl/theme/".concat(name, ".xml");
          zip.append(xml, {
            name: path
          });
        });
        resolve();
      });
    }
  }, {
    key: "addOfficeRels",
    value: function addOfficeRels(zip) {
      return new PromiseLib.Promise(function (resolve) {
        var xform = new RelationshipsXform();
        var xml = xform.toXml([{
          Id: 'rId1',
          Type: XLSX.RelType.OfficeDocument,
          Target: 'xl/workbook.xml'
        }, {
          Id: 'rId2',
          Type: XLSX.RelType.CoreProperties,
          Target: 'docProps/core.xml'
        }, {
          Id: 'rId3',
          Type: XLSX.RelType.ExtenderProperties,
          Target: 'docProps/app.xml'
        }]);
        zip.append(xml, {
          name: '_rels/.rels'
        });
        resolve();
      });
    }
  }, {
    key: "addWorkbookRels",
    value: function addWorkbookRels(zip, model) {
      var count = 1;
      var relationships = [{
        Id: "rId".concat(count++),
        Type: XLSX.RelType.Styles,
        Target: 'styles.xml'
      }, {
        Id: "rId".concat(count++),
        Type: XLSX.RelType.Theme,
        Target: 'theme/theme1.xml'
      }];

      if (model.sharedStrings.count) {
        relationships.push({
          Id: "rId".concat(count++),
          Type: XLSX.RelType.SharedStrings,
          Target: 'sharedStrings.xml'
        });
      }

      model.worksheets.forEach(function (worksheet) {
        worksheet.rId = "rId".concat(count++);
        relationships.push({
          Id: worksheet.rId,
          Type: XLSX.RelType.Worksheet,
          Target: "worksheets/sheet".concat(worksheet.id, ".xml")
        });
      });
      return new PromiseLib.Promise(function (resolve) {
        var xform = new RelationshipsXform();
        var xml = xform.toXml(relationships);
        zip.append(xml, {
          name: 'xl/_rels/workbook.xml.rels'
        });
        resolve();
      });
    }
  }, {
    key: "addSharedStrings",
    value: function addSharedStrings(zip, model) {
      if (!model.sharedStrings || !model.sharedStrings.count) {
        return PromiseLib.Promise.resolve();
      }

      return new PromiseLib.Promise(function (resolve) {
        zip.append(model.sharedStrings.xml, {
          name: 'xl/sharedStrings.xml'
        });
        resolve();
      });
    }
  }, {
    key: "addStyles",
    value: function addStyles(zip, model) {
      return new PromiseLib.Promise(function (resolve) {
        var xml = model.styles.xml;

        if (xml) {
          zip.append(xml, {
            name: 'xl/styles.xml'
          });
        }

        resolve();
      });
    }
  }, {
    key: "addWorkbook",
    value: function addWorkbook(zip, model) {
      return new PromiseLib.Promise(function (resolve) {
        var xform = new WorkbookXform();
        zip.append(xform.toXml(model), {
          name: 'xl/workbook.xml'
        });
        resolve();
      });
    }
  }, {
    key: "addWorksheets",
    value: function addWorksheets(zip, model) {
      return new PromiseLib.Promise(function (resolve) {
        // preparation phase
        var worksheetXform = new WorksheetXform();
        var relationshipsXform = new RelationshipsXform();
        var commentsXform = new CommentsXform();
        var vmlNotesXform = new VmlNotesXform(); // write sheets

        model.worksheets.forEach(function (worksheet) {
          var xmlStream = new XmlStream();
          worksheetXform.render(xmlStream, worksheet);
          zip.append(xmlStream.xml, {
            name: "xl/worksheets/sheet".concat(worksheet.id, ".xml")
          });

          if (worksheet.rels && worksheet.rels.length) {
            xmlStream = new XmlStream();
            relationshipsXform.render(xmlStream, worksheet.rels);
            zip.append(xmlStream.xml, {
              name: "xl/worksheets/_rels/sheet".concat(worksheet.id, ".xml.rels")
            });
          }

          if (worksheet.comments.length > 0) {
            xmlStream = new XmlStream();
            commentsXform.render(xmlStream, worksheet);
            zip.append(xmlStream.xml, {
              name: "xl/comments".concat(worksheet.id, ".xml")
            });
            xmlStream = new XmlStream();
            vmlNotesXform.render(xmlStream, worksheet);
            zip.append(xmlStream.xml, {
              name: "xl/drawings/vmlDrawing".concat(worksheet.id, ".vml")
            });
          }
        });
        resolve();
      });
    }
  }, {
    key: "_finalize",
    value: function _finalize(zip) {
      var _this5 = this;

      return new PromiseLib.Promise(function (resolve, reject) {
        zip.on('finish', function () {
          resolve(_this5);
        });
        zip.on('error', reject);
        zip.finalize();
      });
    }
  }, {
    key: "prepareModel",
    value: function prepareModel(model, options) {
      // ensure following properties have sane values
      model.creator = model.creator || 'ExcelJS';
      model.lastModifiedBy = model.lastModifiedBy || 'ExcelJS';
      model.created = model.created || new Date();
      model.modified = model.modified || new Date();
      model.useSharedStrings = options.useSharedStrings !== undefined ? options.useSharedStrings : true;
      model.useStyles = options.useStyles !== undefined ? options.useStyles : true; // Manage the shared strings

      model.sharedStrings = new SharedStringsXform(); // add a style manager to handle cell formats, fonts, etc.

      model.styles = model.useStyles ? new StylesXform(true) : new StylesXform.Mock(); // prepare all of the things before the render

      var workbookXform = new WorkbookXform();
      var worksheetXform = new WorksheetXform();
      workbookXform.prepare(model);
      var worksheetOptions = {
        sharedStrings: model.sharedStrings,
        styles: model.styles,
        date1904: model.properties.date1904,
        drawingsCount: 0,
        media: model.media
      };
      worksheetOptions.drawings = model.drawings = [];
      worksheetOptions.commentRefs = model.commentRefs = [];
      var tableCount = 0;
      model.tables = [];
      model.worksheets.forEach(function (worksheet) {
        // assign unique filenames to tables
        worksheet.tables.forEach(function (table) {
          tableCount++;
          table.target = "table".concat(tableCount, ".xml");
          table.id = tableCount;
          model.tables.push(table);
        });
        worksheetXform.prepare(worksheet, worksheetOptions);
      }); // TODO: workbook drawing list
    }
  }, {
    key: "write",
    value: function write(stream, options) {
      var _this6 = this;

      options = options || {};
      var model = this.workbook.model;
      var zip = new ZipStream.ZipWriter(options.zip);
      zip.pipe(stream);
      this.prepareModel(model, options); // render

      return PromiseLib.Promise.resolve().then(function () {
        return _this6.addContentTypes(zip, model);
      }).then(function () {
        return _this6.addOfficeRels(zip, model);
      }).then(function () {
        return _this6.addWorkbookRels(zip, model);
      }).then(function () {
        return _this6.addWorksheets(zip, model);
      }).then(function () {
        return _this6.addSharedStrings(zip, model);
      }) // always after worksheets
      .then(function () {
        return _this6.addDrawings(zip, model);
      }).then(function () {
        return _this6.addTables(zip, model);
      }).then(function () {
        var promises = [_this6.addThemes(zip, model), _this6.addStyles(zip, model)];
        return PromiseLib.Promise.all(promises);
      }).then(function () {
        return _this6.addMedia(zip, model);
      }).then(function () {
        var afters = [_this6.addApp(zip, model), _this6.addCore(zip, model)];
        return PromiseLib.Promise.all(afters);
      }).then(function () {
        return _this6.addWorkbook(zip, model);
      }).then(function () {
        return _this6._finalize(zip);
      });
    }
  }, {
    key: "writeFile",
    value: function writeFile(filename, options) {
      var _this7 = this;

      var stream = fs.createWriteStream(filename);
      return new PromiseLib.Promise(function (resolve, reject) {
        stream.on('finish', function () {
          resolve();
        });
        stream.on('error', function (error) {
          reject(error);
        });

        _this7.write(stream, options).then(function () {
          stream.end();
        })["catch"](function (error) {
          reject(error);
        });
      });
    }
  }, {
    key: "writeBuffer",
    value: function writeBuffer(options) {
      var stream = new StreamBuf();
      return this.write(stream, options).then(function () {
        return stream.read();
      });
    }
  }]);

  return XLSX;
}();

XLSX.RelType = require('./rel-type');
module.exports = XLSX;


}).call(this,require("buffer").Buffer)
},{"../utils/promise":20,"../utils/stream-buf":22,"../utils/utils":25,"../utils/xml-stream":26,"../utils/zip-stream":27,"./rel-type":29,"./xform/book/workbook-xform":35,"./xform/comment/comments-xform":37,"./xform/comment/vml-notes-xform":40,"./xform/core/app-xform":43,"./xform/core/content-types-xform":44,"./xform/core/core-xform":45,"./xform/core/relationships-xform":47,"./xform/drawing/drawing-xform":52,"./xform/sheet/worksheet-xform":84,"./xform/strings/shared-strings-xform":93,"./xform/style/styles-xform":104,"./xform/table/table-xform":110,"./xml/theme1.js":112,"buffer":162,"fs":160}],112:[function(require,module,exports){
"use strict";

/* eslint-disable */
module.exports = '<?xml version="1.0" encoding="UTF-8" standalone="yes"?>\n<a:theme xmlns:a="http://schemas.openxmlformats.org/drawingml/2006/main" name="Office Theme"> <a:themeElements> <a:clrScheme name="Office"> <a:dk1> <a:sysClr val="windowText" lastClr="000000"/> </a:dk1> <a:lt1> <a:sysClr val="window" lastClr="FFFFFF"/> </a:lt1> <a:dk2> <a:srgbClr val="1F497D"/> </a:dk2> <a:lt2> <a:srgbClr val="EEECE1"/> </a:lt2> <a:accent1> <a:srgbClr val="4F81BD"/> </a:accent1> <a:accent2> <a:srgbClr val="C0504D"/> </a:accent2> <a:accent3> <a:srgbClr val="9BBB59"/> </a:accent3> <a:accent4> <a:srgbClr val="8064A2"/> </a:accent4> <a:accent5> <a:srgbClr val="4BACC6"/> </a:accent5> <a:accent6> <a:srgbClr val="F79646"/> </a:accent6> <a:hlink> <a:srgbClr val="0000FF"/> </a:hlink> <a:folHlink> <a:srgbClr val="800080"/> </a:folHlink> </a:clrScheme> <a:fontScheme name="Office"> <a:majorFont> <a:latin typeface="Cambria"/> <a:ea typeface=""/> <a:cs typeface=""/> <a:font script="Jpan" typeface="ＭＳ Ｐゴシック"/> <a:font script="Hang" typeface="맑은 고딕"/> <a:font script="Hans" typeface="宋体"/> <a:font script="Hant" typeface="新細明體"/> <a:font script="Arab" typeface="Times New Roman"/> <a:font script="Hebr" typeface="Times New Roman"/> <a:font script="Thai" typeface="Tahoma"/> <a:font script="Ethi" typeface="Nyala"/> <a:font script="Beng" typeface="Vrinda"/> <a:font script="Gujr" typeface="Shruti"/> <a:font script="Khmr" typeface="MoolBoran"/> <a:font script="Knda" typeface="Tunga"/> <a:font script="Guru" typeface="Raavi"/> <a:font script="Cans" typeface="Euphemia"/> <a:font script="Cher" typeface="Plantagenet Cherokee"/> <a:font script="Yiii" typeface="Microsoft Yi Baiti"/> <a:font script="Tibt" typeface="Microsoft Himalaya"/> <a:font script="Thaa" typeface="MV Boli"/> <a:font script="Deva" typeface="Mangal"/> <a:font script="Telu" typeface="Gautami"/> <a:font script="Taml" typeface="Latha"/> <a:font script="Syrc" typeface="Estrangelo Edessa"/> <a:font script="Orya" typeface="Kalinga"/> <a:font script="Mlym" typeface="Kartika"/> <a:font script="Laoo" typeface="DokChampa"/> <a:font script="Sinh" typeface="Iskoola Pota"/> <a:font script="Mong" typeface="Mongolian Baiti"/> <a:font script="Viet" typeface="Times New Roman"/> <a:font script="Uigh" typeface="Microsoft Uighur"/> <a:font script="Geor" typeface="Sylfaen"/> </a:majorFont> <a:minorFont> <a:latin typeface="Calibri"/> <a:ea typeface=""/> <a:cs typeface=""/> <a:font script="Jpan" typeface="ＭＳ Ｐゴシック"/> <a:font script="Hang" typeface="맑은 고딕"/> <a:font script="Hans" typeface="宋体"/> <a:font script="Hant" typeface="新細明體"/> <a:font script="Arab" typeface="Arial"/> <a:font script="Hebr" typeface="Arial"/> <a:font script="Thai" typeface="Tahoma"/> <a:font script="Ethi" typeface="Nyala"/> <a:font script="Beng" typeface="Vrinda"/> <a:font script="Gujr" typeface="Shruti"/> <a:font script="Khmr" typeface="DaunPenh"/> <a:font script="Knda" typeface="Tunga"/> <a:font script="Guru" typeface="Raavi"/> <a:font script="Cans" typeface="Euphemia"/> <a:font script="Cher" typeface="Plantagenet Cherokee"/> <a:font script="Yiii" typeface="Microsoft Yi Baiti"/> <a:font script="Tibt" typeface="Microsoft Himalaya"/> <a:font script="Thaa" typeface="MV Boli"/> <a:font script="Deva" typeface="Mangal"/> <a:font script="Telu" typeface="Gautami"/> <a:font script="Taml" typeface="Latha"/> <a:font script="Syrc" typeface="Estrangelo Edessa"/> <a:font script="Orya" typeface="Kalinga"/> <a:font script="Mlym" typeface="Kartika"/> <a:font script="Laoo" typeface="DokChampa"/> <a:font script="Sinh" typeface="Iskoola Pota"/> <a:font script="Mong" typeface="Mongolian Baiti"/> <a:font script="Viet" typeface="Arial"/> <a:font script="Uigh" typeface="Microsoft Uighur"/> <a:font script="Geor" typeface="Sylfaen"/> </a:minorFont> </a:fontScheme> <a:fmtScheme name="Office"> <a:fillStyleLst> <a:solidFill> <a:schemeClr val="phClr"/> </a:solidFill> <a:gradFill rotWithShape="1"> <a:gsLst> <a:gs pos="0"> <a:schemeClr val="phClr"> <a:tint val="50000"/> <a:satMod val="300000"/> </a:schemeClr> </a:gs> <a:gs pos="35000"> <a:schemeClr val="phClr"> <a:tint val="37000"/> <a:satMod val="300000"/> </a:schemeClr> </a:gs> <a:gs pos="100000"> <a:schemeClr val="phClr"> <a:tint val="15000"/> <a:satMod val="350000"/> </a:schemeClr> </a:gs> </a:gsLst> <a:lin ang="16200000" scaled="1"/> </a:gradFill> <a:gradFill rotWithShape="1"> <a:gsLst> <a:gs pos="0"> <a:schemeClr val="phClr"> <a:tint val="100000"/> <a:shade val="100000"/> <a:satMod val="130000"/> </a:schemeClr> </a:gs> <a:gs pos="100000"> <a:schemeClr val="phClr"> <a:tint val="50000"/> <a:shade val="100000"/> <a:satMod val="350000"/> </a:schemeClr> </a:gs> </a:gsLst> <a:lin ang="16200000" scaled="0"/> </a:gradFill> </a:fillStyleLst> <a:lnStyleLst> <a:ln w="9525" cap="flat" cmpd="sng" algn="ctr"> <a:solidFill> <a:schemeClr val="phClr"> <a:shade val="95000"/> <a:satMod val="105000"/> </a:schemeClr> </a:solidFill> <a:prstDash val="solid"/> </a:ln> <a:ln w="25400" cap="flat" cmpd="sng" algn="ctr"> <a:solidFill> <a:schemeClr val="phClr"/> </a:solidFill> <a:prstDash val="solid"/> </a:ln> <a:ln w="38100" cap="flat" cmpd="sng" algn="ctr"> <a:solidFill> <a:schemeClr val="phClr"/> </a:solidFill> <a:prstDash val="solid"/> </a:ln> </a:lnStyleLst> <a:effectStyleLst> <a:effectStyle> <a:effectLst> <a:outerShdw blurRad="40000" dist="20000" dir="5400000" rotWithShape="0"> <a:srgbClr val="000000"> <a:alpha val="38000"/> </a:srgbClr> </a:outerShdw> </a:effectLst> </a:effectStyle> <a:effectStyle> <a:effectLst> <a:outerShdw blurRad="40000" dist="23000" dir="5400000" rotWithShape="0"> <a:srgbClr val="000000"> <a:alpha val="35000"/> </a:srgbClr> </a:outerShdw> </a:effectLst> </a:effectStyle> <a:effectStyle> <a:effectLst> <a:outerShdw blurRad="40000" dist="23000" dir="5400000" rotWithShape="0"> <a:srgbClr val="000000"> <a:alpha val="35000"/> </a:srgbClr> </a:outerShdw> </a:effectLst> <a:scene3d> <a:camera prst="orthographicFront"> <a:rot lat="0" lon="0" rev="0"/> </a:camera> <a:lightRig rig="threePt" dir="t"> <a:rot lat="0" lon="0" rev="1200000"/> </a:lightRig> </a:scene3d> <a:sp3d> <a:bevelT w="63500" h="25400"/> </a:sp3d> </a:effectStyle> </a:effectStyleLst> <a:bgFillStyleLst> <a:solidFill> <a:schemeClr val="phClr"/> </a:solidFill> <a:gradFill rotWithShape="1"> <a:gsLst> <a:gs pos="0"> <a:schemeClr val="phClr"> <a:tint val="40000"/> <a:satMod val="350000"/> </a:schemeClr> </a:gs> <a:gs pos="40000"> <a:schemeClr val="phClr"> <a:tint val="45000"/> <a:shade val="99000"/> <a:satMod val="350000"/> </a:schemeClr> </a:gs> <a:gs pos="100000"> <a:schemeClr val="phClr"> <a:shade val="20000"/> <a:satMod val="255000"/> </a:schemeClr> </a:gs> </a:gsLst> <a:path path="circle"> <a:fillToRect l="50000" t="-80000" r="50000" b="180000"/> </a:path> </a:gradFill> <a:gradFill rotWithShape="1"> <a:gsLst> <a:gs pos="0"> <a:schemeClr val="phClr"> <a:tint val="80000"/> <a:satMod val="300000"/> </a:schemeClr> </a:gs> <a:gs pos="100000"> <a:schemeClr val="phClr"> <a:shade val="30000"/> <a:satMod val="200000"/> </a:schemeClr> </a:gs> </a:gsLst> <a:path path="circle"> <a:fillToRect l="50000" t="50000" r="50000" b="50000"/> </a:path> </a:gradFill> </a:bgFillStyleLst> </a:fmtScheme> </a:themeElements> <a:objectDefaults> <a:spDef> <a:spPr/> <a:bodyPr/> <a:lstStyle/> <a:style> <a:lnRef idx="1"> <a:schemeClr val="accent1"/> </a:lnRef> <a:fillRef idx="3"> <a:schemeClr val="accent1"/> </a:fillRef> <a:effectRef idx="2"> <a:schemeClr val="accent1"/> </a:effectRef> <a:fontRef idx="minor"> <a:schemeClr val="lt1"/> </a:fontRef> </a:style> </a:spDef> <a:lnDef> <a:spPr/> <a:bodyPr/> <a:lstStyle/> <a:style> <a:lnRef idx="2"> <a:schemeClr val="accent1"/> </a:lnRef> <a:fillRef idx="0"> <a:schemeClr val="accent1"/> </a:fillRef> <a:effectRef idx="1"> <a:schemeClr val="accent1"/> </a:effectRef> <a:fontRef idx="minor"> <a:schemeClr val="tx1"/> </a:fontRef> </a:style> </a:lnDef> </a:objectDefaults> <a:extraClrSchemeLst/> </a:theme>';


},{}],113:[function(require,module,exports){
(function () {
    "use strict";

    function defineArgumentsExtended(extended, is) {

        var pSlice = Array.prototype.slice,
            isArguments = is.isArguments;

        function argsToArray(args, slice) {
            var i = -1, j = 0, l = args.length, ret = [];
            slice = slice || 0;
            i += slice;
            while (++i < l) {
                ret[j++] = args[i];
            }
            return ret;
        }


        return extended
            .define(isArguments, {
                toArray: argsToArray
            })
            .expose({
                argsToArray: argsToArray
            });
    }

    if ("undefined" !== typeof exports) {
        if ("undefined" !== typeof module && module.exports) {
            module.exports = defineArgumentsExtended(require("extended"), require("is-extended"));

        }
    } else if ("function" === typeof define && define.amd) {
        define(["extended", "is-extended"], function (extended, is) {
            return defineArgumentsExtended(extended, is);
        });
    } else {
        this.argumentsExtended = defineArgumentsExtended(this.extended, this.isExtended);
    }

}).call(this);


},{"extended":203,"is-extended":233}],114:[function(require,module,exports){
(function () {
    "use strict";
    /*global define*/

    function defineArray(extended, is, args) {

        var isString = is.isString,
            isArray = Array.isArray || is.isArray,
            isDate = is.isDate,
            floor = Math.floor,
            abs = Math.abs,
            mathMax = Math.max,
            mathMin = Math.min,
            arrayProto = Array.prototype,
            arrayIndexOf = arrayProto.indexOf,
            arrayForEach = arrayProto.forEach,
            arrayMap = arrayProto.map,
            arrayReduce = arrayProto.reduce,
            arrayReduceRight = arrayProto.reduceRight,
            arrayFilter = arrayProto.filter,
            arrayEvery = arrayProto.every,
            arraySome = arrayProto.some,
            argsToArray = args.argsToArray;


        function cross(num, cros) {
            return reduceRight(cros, function (a, b) {
                if (!isArray(b)) {
                    b = [b];
                }
                b.unshift(num);
                a.unshift(b);
                return a;
            }, []);
        }

        function permute(num, cross, length) {
            var ret = [];
            for (var i = 0; i < cross.length; i++) {
                ret.push([num].concat(rotate(cross, i)).slice(0, length));
            }
            return ret;
        }


        function intersection(a, b) {
            var ret = [], aOne, i = -1, l;
            l = a.length;
            while (++i < l) {
                aOne = a[i];
                if (indexOf(b, aOne) !== -1) {
                    ret.push(aOne);
                }
            }
            return ret;
        }


        var _sort = (function () {

            var isAll = function (arr, test) {
                return every(arr, test);
            };

            var defaultCmp = function (a, b) {
                return a - b;
            };

            var dateSort = function (a, b) {
                return a.getTime() - b.getTime();
            };

            return function _sort(arr, property) {
                var ret = [];
                if (isArray(arr)) {
                    ret = arr.slice();
                    if (property) {
                        if (typeof property === "function") {
                            ret.sort(property);
                        } else {
                            ret.sort(function (a, b) {
                                var aProp = a[property], bProp = b[property];
                                if (isString(aProp) && isString(bProp)) {
                                    return aProp > bProp ? 1 : aProp < bProp ? -1 : 0;
                                } else if (isDate(aProp) && isDate(bProp)) {
                                    return aProp.getTime() - bProp.getTime();
                                } else {
                                    return aProp - bProp;
                                }
                            });
                        }
                    } else {
                        if (isAll(ret, isString)) {
                            ret.sort();
                        } else if (isAll(ret, isDate)) {
                            ret.sort(dateSort);
                        } else {
                            ret.sort(defaultCmp);
                        }
                    }
                }
                return ret;
            };

        })();

        function indexOf(arr, searchElement, from) {
            var index = (from || 0) - 1,
                length = arr.length;
            while (++index < length) {
                if (arr[index] === searchElement) {
                    return index;
                }
            }
            return -1;
        }

        function lastIndexOf(arr, searchElement, from) {
            if (!isArray(arr)) {
                throw new TypeError();
            }

            var t = Object(arr);
            var len = t.length >>> 0;
            if (len === 0) {
                return -1;
            }

            var n = len;
            if (arguments.length > 2) {
                n = Number(arguments[2]);
                if (n !== n) {
                    n = 0;
                } else if (n !== 0 && n !== (1 / 0) && n !== -(1 / 0)) {
                    n = (n > 0 || -1) * floor(abs(n));
                }
            }

            var k = n >= 0 ? mathMin(n, len - 1) : len - abs(n);

            for (; k >= 0; k--) {
                if (k in t && t[k] === searchElement) {
                    return k;
                }
            }
            return -1;
        }

        function filter(arr, iterator, scope) {
            if (arr && arrayFilter && arrayFilter === arr.filter) {
                return arr.filter(iterator, scope);
            }
            if (!isArray(arr) || typeof iterator !== "function") {
                throw new TypeError();
            }

            var t = Object(arr);
            var len = t.length >>> 0;
            var res = [];
            for (var i = 0; i < len; i++) {
                if (i in t) {
                    var val = t[i]; // in case fun mutates this
                    if (iterator.call(scope, val, i, t)) {
                        res.push(val);
                    }
                }
            }
            return res;
        }

        function forEach(arr, iterator, scope) {
            if (!isArray(arr) || typeof iterator !== "function") {
                throw new TypeError();
            }
            if (arr && arrayForEach && arrayForEach === arr.forEach) {
                arr.forEach(iterator, scope);
                return arr;
            }
            for (var i = 0, len = arr.length; i < len; ++i) {
                iterator.call(scope || arr, arr[i], i, arr);
            }

            return arr;
        }

        function every(arr, iterator, scope) {
            if (arr && arrayEvery && arrayEvery === arr.every) {
                return arr.every(iterator, scope);
            }
            if (!isArray(arr) || typeof iterator !== "function") {
                throw new TypeError();
            }
            var t = Object(arr);
            var len = t.length >>> 0;
            for (var i = 0; i < len; i++) {
                if (i in t && !iterator.call(scope, t[i], i, t)) {
                    return false;
                }
            }
            return true;
        }

        function some(arr, iterator, scope) {
            if (arr && arraySome && arraySome === arr.some) {
                return arr.some(iterator, scope);
            }
            if (!isArray(arr) || typeof iterator !== "function") {
                throw new TypeError();
            }
            var t = Object(arr);
            var len = t.length >>> 0;
            for (var i = 0; i < len; i++) {
                if (i in t && iterator.call(scope, t[i], i, t)) {
                    return true;
                }
            }
            return false;
        }

        function map(arr, iterator, scope) {
            if (arr && arrayMap && arrayMap === arr.map) {
                return arr.map(iterator, scope);
            }
            if (!isArray(arr) || typeof iterator !== "function") {
                throw new TypeError();
            }

            var t = Object(arr);
            var len = t.length >>> 0;
            var res = [];
            for (var i = 0; i < len; i++) {
                if (i in t) {
                    res.push(iterator.call(scope, t[i], i, t));
                }
            }
            return res;
        }

        function reduce(arr, accumulator, curr) {
            var initial = arguments.length > 2;
            if (arr && arrayReduce && arrayReduce === arr.reduce) {
                return initial ? arr.reduce(accumulator, curr) : arr.reduce(accumulator);
            }
            if (!isArray(arr) || typeof accumulator !== "function") {
                throw new TypeError();
            }
            var i = 0, l = arr.length >> 0;
            if (arguments.length < 3) {
                if (l === 0) {
                    throw new TypeError("Array length is 0 and no second argument");
                }
                curr = arr[0];
                i = 1; // start accumulating at the second element
            } else {
                curr = arguments[2];
            }
            while (i < l) {
                if (i in arr) {
                    curr = accumulator.call(undefined, curr, arr[i], i, arr);
                }
                ++i;
            }
            return curr;
        }

        function reduceRight(arr, accumulator, curr) {
            var initial = arguments.length > 2;
            if (arr && arrayReduceRight && arrayReduceRight === arr.reduceRight) {
                return initial ? arr.reduceRight(accumulator, curr) : arr.reduceRight(accumulator);
            }
            if (!isArray(arr) || typeof accumulator !== "function") {
                throw new TypeError();
            }

            var t = Object(arr);
            var len = t.length >>> 0;

            // no value to return if no initial value, empty array
            if (len === 0 && arguments.length === 2) {
                throw new TypeError();
            }

            var k = len - 1;
            if (arguments.length >= 3) {
                curr = arguments[2];
            } else {
                do {
                    if (k in arr) {
                        curr = arr[k--];
                        break;
                    }
                }
                while (true);
            }
            while (k >= 0) {
                if (k in t) {
                    curr = accumulator.call(undefined, curr, t[k], k, t);
                }
                k--;
            }
            return curr;
        }


        function toArray(o) {
            var ret = [];
            if (o !== null) {
                var args = argsToArray(arguments);
                if (args.length === 1) {
                    if (isArray(o)) {
                        ret = o;
                    } else if (is.isHash(o)) {
                        for (var i in o) {
                            if (o.hasOwnProperty(i)) {
                                ret.push([i, o[i]]);
                            }
                        }
                    } else {
                        ret.push(o);
                    }
                } else {
                    forEach(args, function (a) {
                        ret = ret.concat(toArray(a));
                    });
                }
            }
            return ret;
        }

        function sum(array) {
            array = array || [];
            if (array.length) {
                return reduce(array, function (a, b) {
                    return a + b;
                });
            } else {
                return 0;
            }
        }

        function avg(arr) {
            arr = arr || [];
            if (arr.length) {
                var total = sum(arr);
                if (is.isNumber(total)) {
                    return  total / arr.length;
                } else {
                    throw new Error("Cannot average an array of non numbers.");
                }
            } else {
                return 0;
            }
        }

        function sort(arr, cmp) {
            return _sort(arr, cmp);
        }

        function min(arr, cmp) {
            return _sort(arr, cmp)[0];
        }

        function max(arr, cmp) {
            return _sort(arr, cmp)[arr.length - 1];
        }

        function difference(arr1) {
            var ret = arr1, args = flatten(argsToArray(arguments, 1));
            if (isArray(arr1)) {
                ret = filter(arr1, function (a) {
                    return indexOf(args, a) === -1;
                });
            }
            return ret;
        }

        function removeDuplicates(arr) {
            var ret = [], i = -1, l, retLength = 0;
            if (arr) {
                l = arr.length;
                while (++i < l) {
                    var item = arr[i];
                    if (indexOf(ret, item) === -1) {
                        ret[retLength++] = item;
                    }
                }
            }
            return ret;
        }


        function unique(arr) {
            return removeDuplicates(arr);
        }


        function rotate(arr, numberOfTimes) {
            var ret = arr.slice();
            if (typeof numberOfTimes !== "number") {
                numberOfTimes = 1;
            }
            if (numberOfTimes && isArray(arr)) {
                if (numberOfTimes > 0) {
                    ret.push(ret.shift());
                    numberOfTimes--;
                } else {
                    ret.unshift(ret.pop());
                    numberOfTimes++;
                }
                return rotate(ret, numberOfTimes);
            } else {
                return ret;
            }
        }

        function permutations(arr, length) {
            var ret = [];
            if (isArray(arr)) {
                var copy = arr.slice(0);
                if (typeof length !== "number") {
                    length = arr.length;
                }
                if (!length) {
                    ret = [
                        []
                    ];
                } else if (length <= arr.length) {
                    ret = reduce(arr, function (a, b, i) {
                        var ret;
                        if (length > 1) {
                            ret = permute(b, rotate(copy, i).slice(1), length);
                        } else {
                            ret = [
                                [b]
                            ];
                        }
                        return a.concat(ret);
                    }, []);
                }
            }
            return ret;
        }

        function zip() {
            var ret = [];
            var arrs = argsToArray(arguments);
            if (arrs.length > 1) {
                var arr1 = arrs.shift();
                if (isArray(arr1)) {
                    ret = reduce(arr1, function (a, b, i) {
                        var curr = [b];
                        for (var j = 0; j < arrs.length; j++) {
                            var currArr = arrs[j];
                            if (isArray(currArr) && !is.isUndefined(currArr[i])) {
                                curr.push(currArr[i]);
                            } else {
                                curr.push(null);
                            }
                        }
                        a.push(curr);
                        return a;
                    }, []);
                }
            }
            return ret;
        }

        function transpose(arr) {
            var ret = [];
            if (isArray(arr) && arr.length) {
                var last;
                forEach(arr, function (a) {
                    if (isArray(a) && (!last || a.length === last.length)) {
                        forEach(a, function (b, i) {
                            if (!ret[i]) {
                                ret[i] = [];
                            }
                            ret[i].push(b);
                        });
                        last = a;
                    }
                });
            }
            return ret;
        }

        function valuesAt(arr, indexes) {
            var ret = [];
            indexes = argsToArray(arguments);
            arr = indexes.shift();
            if (isArray(arr) && indexes.length) {
                for (var i = 0, l = indexes.length; i < l; i++) {
                    ret.push(arr[indexes[i]] || null);
                }
            }
            return ret;
        }

        function union() {
            var ret = [];
            var arrs = argsToArray(arguments);
            if (arrs.length > 1) {
                for (var i = 0, l = arrs.length; i < l; i++) {
                    ret = ret.concat(arrs[i]);
                }
                ret = removeDuplicates(ret);
            }
            return ret;
        }

        function intersect() {
            var collect = [], sets, i = -1 , l;
            if (arguments.length > 1) {
                //assume we are intersections all the lists in the array
                sets = argsToArray(arguments);
            } else {
                sets = arguments[0];
            }
            if (isArray(sets)) {
                collect = sets[0];
                i = 0;
                l = sets.length;
                while (++i < l) {
                    collect = intersection(collect, sets[i]);
                }
            }
            return removeDuplicates(collect);
        }

        function powerSet(arr) {
            var ret = [];
            if (isArray(arr) && arr.length) {
                ret = reduce(arr, function (a, b) {
                    var ret = map(a, function (c) {
                        return c.concat(b);
                    });
                    return a.concat(ret);
                }, [
                    []
                ]);
            }
            return ret;
        }

        function cartesian(a, b) {
            var ret = [];
            if (isArray(a) && isArray(b) && a.length && b.length) {
                ret = cross(a[0], b).concat(cartesian(a.slice(1), b));
            }
            return ret;
        }

        function compact(arr) {
            var ret = [];
            if (isArray(arr) && arr.length) {
                ret = filter(arr, function (item) {
                    return !is.isUndefinedOrNull(item);
                });
            }
            return ret;
        }

        function multiply(arr, times) {
            times = is.isNumber(times) ? times : 1;
            if (!times) {
                //make sure times is greater than zero if it is zero then dont multiply it
                times = 1;
            }
            arr = toArray(arr || []);
            var ret = [], i = 0;
            while (++i <= times) {
                ret = ret.concat(arr);
            }
            return ret;
        }

        function flatten(arr) {
            var set;
            var args = argsToArray(arguments);
            if (args.length > 1) {
                //assume we are intersections all the lists in the array
                set = args;
            } else {
                set = toArray(arr);
            }
            return reduce(set, function (a, b) {
                return a.concat(b);
            }, []);
        }

        function pluck(arr, prop) {
            prop = prop.split(".");
            var result = arr.slice(0);
            forEach(prop, function (prop) {
                var exec = prop.match(/(\w+)\(\)$/);
                result = map(result, function (item) {
                    return exec ? item[exec[1]]() : item[prop];
                });
            });
            return result;
        }

        function invoke(arr, func, args) {
            args = argsToArray(arguments, 2);
            return map(arr, function (item) {
                var exec = isString(func) ? item[func] : func;
                return exec.apply(item, args);
            });
        }


        var array = {
            toArray: toArray,
            sum: sum,
            avg: avg,
            sort: sort,
            min: min,
            max: max,
            difference: difference,
            removeDuplicates: removeDuplicates,
            unique: unique,
            rotate: rotate,
            permutations: permutations,
            zip: zip,
            transpose: transpose,
            valuesAt: valuesAt,
            union: union,
            intersect: intersect,
            powerSet: powerSet,
            cartesian: cartesian,
            compact: compact,
            multiply: multiply,
            flatten: flatten,
            pluck: pluck,
            invoke: invoke,
            forEach: forEach,
            map: map,
            filter: filter,
            reduce: reduce,
            reduceRight: reduceRight,
            some: some,
            every: every,
            indexOf: indexOf,
            lastIndexOf: lastIndexOf
        };

        return extended.define(isArray, array).expose(array);
    }

    if ("undefined" !== typeof exports) {
        if ("undefined" !== typeof module && module.exports) {
            module.exports = defineArray(require("extended"), require("is-extended"), require("arguments-extended"));
        }
    } else if ("function" === typeof define && define.amd) {
        define(["extended", "is-extended", "arguments-extended"], function (extended, is, args) {
            return defineArray(extended, is, args);
        });
    } else {
        this.arrayExtended = defineArray(this.extended, this.isExtended, this.argumentsExtended);
    }

}).call(this);







},{"arguments-extended":113,"extended":203,"is-extended":233}],115:[function(require,module,exports){
var asn1 = exports;

asn1.bignum = require('bn.js');

asn1.define = require('./asn1/api').define;
asn1.base = require('./asn1/base');
asn1.constants = require('./asn1/constants');
asn1.decoders = require('./asn1/decoders');
asn1.encoders = require('./asn1/encoders');

},{"./asn1/api":116,"./asn1/base":118,"./asn1/constants":122,"./asn1/decoders":124,"./asn1/encoders":127,"bn.js":130}],116:[function(require,module,exports){
var asn1 = require('../asn1');
var inherits = require('inherits');

var api = exports;

api.define = function define(name, body) {
  return new Entity(name, body);
};

function Entity(name, body) {
  this.name = name;
  this.body = body;

  this.decoders = {};
  this.encoders = {};
};

Entity.prototype._createNamed = function createNamed(base) {
  var named;
  try {
    named = require('vm').runInThisContext(
      '(function ' + this.name + '(entity) {\n' +
      '  this._initNamed(entity);\n' +
      '})'
    );
  } catch (e) {
    named = function (entity) {
      this._initNamed(entity);
    };
  }
  inherits(named, base);
  named.prototype._initNamed = function initnamed(entity) {
    base.call(this, entity);
  };

  return new named(this);
};

Entity.prototype._getDecoder = function _getDecoder(enc) {
  enc = enc || 'der';
  // Lazily create decoder
  if (!this.decoders.hasOwnProperty(enc))
    this.decoders[enc] = this._createNamed(asn1.decoders[enc]);
  return this.decoders[enc];
};

Entity.prototype.decode = function decode(data, enc, options) {
  return this._getDecoder(enc).decode(data, options);
};

Entity.prototype._getEncoder = function _getEncoder(enc) {
  enc = enc || 'der';
  // Lazily create encoder
  if (!this.encoders.hasOwnProperty(enc))
    this.encoders[enc] = this._createNamed(asn1.encoders[enc]);
  return this.encoders[enc];
};

Entity.prototype.encode = function encode(data, enc, /* internal */ reporter) {
  return this._getEncoder(enc).encode(data, reporter);
};

},{"../asn1":115,"inherits":231,"vm":349}],117:[function(require,module,exports){
var inherits = require('inherits');
var Reporter = require('../base').Reporter;
var Buffer = require('buffer').Buffer;

function DecoderBuffer(base, options) {
  Reporter.call(this, options);
  if (!Buffer.isBuffer(base)) {
    this.error('Input not Buffer');
    return;
  }

  this.base = base;
  this.offset = 0;
  this.length = base.length;
}
inherits(DecoderBuffer, Reporter);
exports.DecoderBuffer = DecoderBuffer;

DecoderBuffer.prototype.save = function save() {
  return { offset: this.offset, reporter: Reporter.prototype.save.call(this) };
};

DecoderBuffer.prototype.restore = function restore(save) {
  // Return skipped data
  var res = new DecoderBuffer(this.base);
  res.offset = save.offset;
  res.length = this.offset;

  this.offset = save.offset;
  Reporter.prototype.restore.call(this, save.reporter);

  return res;
};

DecoderBuffer.prototype.isEmpty = function isEmpty() {
  return this.offset === this.length;
};

DecoderBuffer.prototype.readUInt8 = function readUInt8(fail) {
  if (this.offset + 1 <= this.length)
    return this.base.readUInt8(this.offset++, true);
  else
    return this.error(fail || 'DecoderBuffer overrun');
}

DecoderBuffer.prototype.skip = function skip(bytes, fail) {
  if (!(this.offset + bytes <= this.length))
    return this.error(fail || 'DecoderBuffer overrun');

  var res = new DecoderBuffer(this.base);

  // Share reporter state
  res._reporterState = this._reporterState;

  res.offset = this.offset;
  res.length = this.offset + bytes;
  this.offset += bytes;
  return res;
}

DecoderBuffer.prototype.raw = function raw(save) {
  return this.base.slice(save ? save.offset : this.offset, this.length);
}

function EncoderBuffer(value, reporter) {
  if (Array.isArray(value)) {
    this.length = 0;
    this.value = value.map(function(item) {
      if (!(item instanceof EncoderBuffer))
        item = new EncoderBuffer(item, reporter);
      this.length += item.length;
      return item;
    }, this);
  } else if (typeof value === 'number') {
    if (!(0 <= value && value <= 0xff))
      return reporter.error('non-byte EncoderBuffer value');
    this.value = value;
    this.length = 1;
  } else if (typeof value === 'string') {
    this.value = value;
    this.length = Buffer.byteLength(value);
  } else if (Buffer.isBuffer(value)) {
    this.value = value;
    this.length = value.length;
  } else {
    return reporter.error('Unsupported type: ' + typeof value);
  }
}
exports.EncoderBuffer = EncoderBuffer;

EncoderBuffer.prototype.join = function join(out, offset) {
  if (!out)
    out = new Buffer(this.length);
  if (!offset)
    offset = 0;

  if (this.length === 0)
    return out;

  if (Array.isArray(this.value)) {
    this.value.forEach(function(item) {
      item.join(out, offset);
      offset += item.length;
    });
  } else {
    if (typeof this.value === 'number')
      out[offset] = this.value;
    else if (typeof this.value === 'string')
      out.write(this.value, offset);
    else if (Buffer.isBuffer(this.value))
      this.value.copy(out, offset);
    offset += this.length;
  }

  return out;
};

},{"../base":118,"buffer":162,"inherits":231}],118:[function(require,module,exports){
var base = exports;

base.Reporter = require('./reporter').Reporter;
base.DecoderBuffer = require('./buffer').DecoderBuffer;
base.EncoderBuffer = require('./buffer').EncoderBuffer;
base.Node = require('./node');

},{"./buffer":117,"./node":119,"./reporter":120}],119:[function(require,module,exports){
var Reporter = require('../base').Reporter;
var EncoderBuffer = require('../base').EncoderBuffer;
var DecoderBuffer = require('../base').DecoderBuffer;
var assert = require('minimalistic-assert');

// Supported tags
var tags = [
  'seq', 'seqof', 'set', 'setof', 'objid', 'bool',
  'gentime', 'utctime', 'null_', 'enum', 'int', 'objDesc',
  'bitstr', 'bmpstr', 'charstr', 'genstr', 'graphstr', 'ia5str', 'iso646str',
  'numstr', 'octstr', 'printstr', 't61str', 'unistr', 'utf8str', 'videostr'
];

// Public methods list
var methods = [
  'key', 'obj', 'use', 'optional', 'explicit', 'implicit', 'def', 'choice',
  'any', 'contains'
].concat(tags);

// Overrided methods list
var overrided = [
  '_peekTag', '_decodeTag', '_use',
  '_decodeStr', '_decodeObjid', '_decodeTime',
  '_decodeNull', '_decodeInt', '_decodeBool', '_decodeList',

  '_encodeComposite', '_encodeStr', '_encodeObjid', '_encodeTime',
  '_encodeNull', '_encodeInt', '_encodeBool'
];

function Node(enc, parent) {
  var state = {};
  this._baseState = state;

  state.enc = enc;

  state.parent = parent || null;
  state.children = null;

  // State
  state.tag = null;
  state.args = null;
  state.reverseArgs = null;
  state.choice = null;
  state.optional = false;
  state.any = false;
  state.obj = false;
  state.use = null;
  state.useDecoder = null;
  state.key = null;
  state['default'] = null;
  state.explicit = null;
  state.implicit = null;
  state.contains = null;

  // Should create new instance on each method
  if (!state.parent) {
    state.children = [];
    this._wrap();
  }
}
module.exports = Node;

var stateProps = [
  'enc', 'parent', 'children', 'tag', 'args', 'reverseArgs', 'choice',
  'optional', 'any', 'obj', 'use', 'alteredUse', 'key', 'default', 'explicit',
  'implicit', 'contains'
];

Node.prototype.clone = function clone() {
  var state = this._baseState;
  var cstate = {};
  stateProps.forEach(function(prop) {
    cstate[prop] = state[prop];
  });
  var res = new this.constructor(cstate.parent);
  res._baseState = cstate;
  return res;
};

Node.prototype._wrap = function wrap() {
  var state = this._baseState;
  methods.forEach(function(method) {
    this[method] = function _wrappedMethod() {
      var clone = new this.constructor(this);
      state.children.push(clone);
      return clone[method].apply(clone, arguments);
    };
  }, this);
};

Node.prototype._init = function init(body) {
  var state = this._baseState;

  assert(state.parent === null);
  body.call(this);

  // Filter children
  state.children = state.children.filter(function(child) {
    return child._baseState.parent === this;
  }, this);
  assert.equal(state.children.length, 1, 'Root node can have only one child');
};

Node.prototype._useArgs = function useArgs(args) {
  var state = this._baseState;

  // Filter children and args
  var children = args.filter(function(arg) {
    return arg instanceof this.constructor;
  }, this);
  args = args.filter(function(arg) {
    return !(arg instanceof this.constructor);
  }, this);

  if (children.length !== 0) {
    assert(state.children === null);
    state.children = children;

    // Replace parent to maintain backward link
    children.forEach(function(child) {
      child._baseState.parent = this;
    }, this);
  }
  if (args.length !== 0) {
    assert(state.args === null);
    state.args = args;
    state.reverseArgs = args.map(function(arg) {
      if (typeof arg !== 'object' || arg.constructor !== Object)
        return arg;

      var res = {};
      Object.keys(arg).forEach(function(key) {
        if (key == (key | 0))
          key |= 0;
        var value = arg[key];
        res[value] = key;
      });
      return res;
    });
  }
};

//
// Overrided methods
//

overrided.forEach(function(method) {
  Node.prototype[method] = function _overrided() {
    var state = this._baseState;
    throw new Error(method + ' not implemented for encoding: ' + state.enc);
  };
});

//
// Public methods
//

tags.forEach(function(tag) {
  Node.prototype[tag] = function _tagMethod() {
    var state = this._baseState;
    var args = Array.prototype.slice.call(arguments);

    assert(state.tag === null);
    state.tag = tag;

    this._useArgs(args);

    return this;
  };
});

Node.prototype.use = function use(item) {
  assert(item);
  var state = this._baseState;

  assert(state.use === null);
  state.use = item;

  return this;
};

Node.prototype.optional = function optional() {
  var state = this._baseState;

  state.optional = true;

  return this;
};

Node.prototype.def = function def(val) {
  var state = this._baseState;

  assert(state['default'] === null);
  state['default'] = val;
  state.optional = true;

  return this;
};

Node.prototype.explicit = function explicit(num) {
  var state = this._baseState;

  assert(state.explicit === null && state.implicit === null);
  state.explicit = num;

  return this;
};

Node.prototype.implicit = function implicit(num) {
  var state = this._baseState;

  assert(state.explicit === null && state.implicit === null);
  state.implicit = num;

  return this;
};

Node.prototype.obj = function obj() {
  var state = this._baseState;
  var args = Array.prototype.slice.call(arguments);

  state.obj = true;

  if (args.length !== 0)
    this._useArgs(args);

  return this;
};

Node.prototype.key = function key(newKey) {
  var state = this._baseState;

  assert(state.key === null);
  state.key = newKey;

  return this;
};

Node.prototype.any = function any() {
  var state = this._baseState;

  state.any = true;

  return this;
};

Node.prototype.choice = function choice(obj) {
  var state = this._baseState;

  assert(state.choice === null);
  state.choice = obj;
  this._useArgs(Object.keys(obj).map(function(key) {
    return obj[key];
  }));

  return this;
};

Node.prototype.contains = function contains(item) {
  var state = this._baseState;

  assert(state.use === null);
  state.contains = item;

  return this;
};

//
// Decoding
//

Node.prototype._decode = function decode(input, options) {
  var state = this._baseState;

  // Decode root node
  if (state.parent === null)
    return input.wrapResult(state.children[0]._decode(input, options));

  var result = state['default'];
  var present = true;

  var prevKey = null;
  if (state.key !== null)
    prevKey = input.enterKey(state.key);

  // Check if tag is there
  if (state.optional) {
    var tag = null;
    if (state.explicit !== null)
      tag = state.explicit;
    else if (state.implicit !== null)
      tag = state.implicit;
    else if (state.tag !== null)
      tag = state.tag;

    if (tag === null && !state.any) {
      // Trial and Error
      var save = input.save();
      try {
        if (state.choice === null)
          this._decodeGeneric(state.tag, input, options);
        else
          this._decodeChoice(input, options);
        present = true;
      } catch (e) {
        present = false;
      }
      input.restore(save);
    } else {
      present = this._peekTag(input, tag, state.any);

      if (input.isError(present))
        return present;
    }
  }

  // Push object on stack
  var prevObj;
  if (state.obj && present)
    prevObj = input.enterObject();

  if (present) {
    // Unwrap explicit values
    if (state.explicit !== null) {
      var explicit = this._decodeTag(input, state.explicit);
      if (input.isError(explicit))
        return explicit;
      input = explicit;
    }

    var start = input.offset;

    // Unwrap implicit and normal values
    if (state.use === null && state.choice === null) {
      if (state.any)
        var save = input.save();
      var body = this._decodeTag(
        input,
        state.implicit !== null ? state.implicit : state.tag,
        state.any
      );
      if (input.isError(body))
        return body;

      if (state.any)
        result = input.raw(save);
      else
        input = body;
    }

    if (options && options.track && state.tag !== null)
      options.track(input.path(), start, input.length, 'tagged');

    if (options && options.track && state.tag !== null)
      options.track(input.path(), input.offset, input.length, 'content');

    // Select proper method for tag
    if (state.any)
      result = result;
    else if (state.choice === null)
      result = this._decodeGeneric(state.tag, input, options);
    else
      result = this._decodeChoice(input, options);

    if (input.isError(result))
      return result;

    // Decode children
    if (!state.any && state.choice === null && state.children !== null) {
      state.children.forEach(function decodeChildren(child) {
        // NOTE: We are ignoring errors here, to let parser continue with other
        // parts of encoded data
        child._decode(input, options);
      });
    }

    // Decode contained/encoded by schema, only in bit or octet strings
    if (state.contains && (state.tag === 'octstr' || state.tag === 'bitstr')) {
      var data = new DecoderBuffer(result);
      result = this._getUse(state.contains, input._reporterState.obj)
          ._decode(data, options);
    }
  }

  // Pop object
  if (state.obj && present)
    result = input.leaveObject(prevObj);

  // Set key
  if (state.key !== null && (result !== null || present === true))
    input.leaveKey(prevKey, state.key, result);
  else if (prevKey !== null)
    input.exitKey(prevKey);

  return result;
};

Node.prototype._decodeGeneric = function decodeGeneric(tag, input, options) {
  var state = this._baseState;

  if (tag === 'seq' || tag === 'set')
    return null;
  if (tag === 'seqof' || tag === 'setof')
    return this._decodeList(input, tag, state.args[0], options);
  else if (/str$/.test(tag))
    return this._decodeStr(input, tag, options);
  else if (tag === 'objid' && state.args)
    return this._decodeObjid(input, state.args[0], state.args[1], options);
  else if (tag === 'objid')
    return this._decodeObjid(input, null, null, options);
  else if (tag === 'gentime' || tag === 'utctime')
    return this._decodeTime(input, tag, options);
  else if (tag === 'null_')
    return this._decodeNull(input, options);
  else if (tag === 'bool')
    return this._decodeBool(input, options);
  else if (tag === 'objDesc')
    return this._decodeStr(input, tag, options);
  else if (tag === 'int' || tag === 'enum')
    return this._decodeInt(input, state.args && state.args[0], options);

  if (state.use !== null) {
    return this._getUse(state.use, input._reporterState.obj)
        ._decode(input, options);
  } else {
    return input.error('unknown tag: ' + tag);
  }
};

Node.prototype._getUse = function _getUse(entity, obj) {

  var state = this._baseState;
  // Create altered use decoder if implicit is set
  state.useDecoder = this._use(entity, obj);
  assert(state.useDecoder._baseState.parent === null);
  state.useDecoder = state.useDecoder._baseState.children[0];
  if (state.implicit !== state.useDecoder._baseState.implicit) {
    state.useDecoder = state.useDecoder.clone();
    state.useDecoder._baseState.implicit = state.implicit;
  }
  return state.useDecoder;
};

Node.prototype._decodeChoice = function decodeChoice(input, options) {
  var state = this._baseState;
  var result = null;
  var match = false;

  Object.keys(state.choice).some(function(key) {
    var save = input.save();
    var node = state.choice[key];
    try {
      var value = node._decode(input, options);
      if (input.isError(value))
        return false;

      result = { type: key, value: value };
      match = true;
    } catch (e) {
      input.restore(save);
      return false;
    }
    return true;
  }, this);

  if (!match)
    return input.error('Choice not matched');

  return result;
};

//
// Encoding
//

Node.prototype._createEncoderBuffer = function createEncoderBuffer(data) {
  return new EncoderBuffer(data, this.reporter);
};

Node.prototype._encode = function encode(data, reporter, parent) {
  var state = this._baseState;
  if (state['default'] !== null && state['default'] === data)
    return;

  var result = this._encodeValue(data, reporter, parent);
  if (result === undefined)
    return;

  if (this._skipDefault(result, reporter, parent))
    return;

  return result;
};

Node.prototype._encodeValue = function encode(data, reporter, parent) {
  var state = this._baseState;

  // Decode root node
  if (state.parent === null)
    return state.children[0]._encode(data, reporter || new Reporter());

  var result = null;

  // Set reporter to share it with a child class
  this.reporter = reporter;

  // Check if data is there
  if (state.optional && data === undefined) {
    if (state['default'] !== null)
      data = state['default']
    else
      return;
  }

  // Encode children first
  var content = null;
  var primitive = false;
  if (state.any) {
    // Anything that was given is translated to buffer
    result = this._createEncoderBuffer(data);
  } else if (state.choice) {
    result = this._encodeChoice(data, reporter);
  } else if (state.contains) {
    content = this._getUse(state.contains, parent)._encode(data, reporter);
    primitive = true;
  } else if (state.children) {
    content = state.children.map(function(child) {
      if (child._baseState.tag === 'null_')
        return child._encode(null, reporter, data);

      if (child._baseState.key === null)
        return reporter.error('Child should have a key');
      var prevKey = reporter.enterKey(child._baseState.key);

      if (typeof data !== 'object')
        return reporter.error('Child expected, but input is not object');

      var res = child._encode(data[child._baseState.key], reporter, data);
      reporter.leaveKey(prevKey);

      return res;
    }, this).filter(function(child) {
      return child;
    });
    content = this._createEncoderBuffer(content);
  } else {
    if (state.tag === 'seqof' || state.tag === 'setof') {
      // TODO(indutny): this should be thrown on DSL level
      if (!(state.args && state.args.length === 1))
        return reporter.error('Too many args for : ' + state.tag);

      if (!Array.isArray(data))
        return reporter.error('seqof/setof, but data is not Array');

      var child = this.clone();
      child._baseState.implicit = null;
      content = this._createEncoderBuffer(data.map(function(item) {
        var state = this._baseState;

        return this._getUse(state.args[0], data)._encode(item, reporter);
      }, child));
    } else if (state.use !== null) {
      result = this._getUse(state.use, parent)._encode(data, reporter);
    } else {
      content = this._encodePrimitive(state.tag, data);
      primitive = true;
    }
  }

  // Encode data itself
  var result;
  if (!state.any && state.choice === null) {
    var tag = state.implicit !== null ? state.implicit : state.tag;
    var cls = state.implicit === null ? 'universal' : 'context';

    if (tag === null) {
      if (state.use === null)
        reporter.error('Tag could be omitted only for .use()');
    } else {
      if (state.use === null)
        result = this._encodeComposite(tag, primitive, cls, content);
    }
  }

  // Wrap in explicit
  if (state.explicit !== null)
    result = this._encodeComposite(state.explicit, false, 'context', result);

  return result;
};

Node.prototype._encodeChoice = function encodeChoice(data, reporter) {
  var state = this._baseState;

  var node = state.choice[data.type];
  if (!node) {
    assert(
        false,
        data.type + ' not found in ' +
            JSON.stringify(Object.keys(state.choice)));
  }
  return node._encode(data.value, reporter);
};

Node.prototype._encodePrimitive = function encodePrimitive(tag, data) {
  var state = this._baseState;

  if (/str$/.test(tag))
    return this._encodeStr(data, tag);
  else if (tag === 'objid' && state.args)
    return this._encodeObjid(data, state.reverseArgs[0], state.args[1]);
  else if (tag === 'objid')
    return this._encodeObjid(data, null, null);
  else if (tag === 'gentime' || tag === 'utctime')
    return this._encodeTime(data, tag);
  else if (tag === 'null_')
    return this._encodeNull();
  else if (tag === 'int' || tag === 'enum')
    return this._encodeInt(data, state.args && state.reverseArgs[0]);
  else if (tag === 'bool')
    return this._encodeBool(data);
  else if (tag === 'objDesc')
    return this._encodeStr(data, tag);
  else
    throw new Error('Unsupported tag: ' + tag);
};

Node.prototype._isNumstr = function isNumstr(str) {
  return /^[0-9 ]*$/.test(str);
};

Node.prototype._isPrintstr = function isPrintstr(str) {
  return /^[A-Za-z0-9 '\(\)\+,\-\.\/:=\?]*$/.test(str);
};

},{"../base":118,"minimalistic-assert":273}],120:[function(require,module,exports){
var inherits = require('inherits');

function Reporter(options) {
  this._reporterState = {
    obj: null,
    path: [],
    options: options || {},
    errors: []
  };
}
exports.Reporter = Reporter;

Reporter.prototype.isError = function isError(obj) {
  return obj instanceof ReporterError;
};

Reporter.prototype.save = function save() {
  var state = this._reporterState;

  return { obj: state.obj, pathLen: state.path.length };
};

Reporter.prototype.restore = function restore(data) {
  var state = this._reporterState;

  state.obj = data.obj;
  state.path = state.path.slice(0, data.pathLen);
};

Reporter.prototype.enterKey = function enterKey(key) {
  return this._reporterState.path.push(key);
};

Reporter.prototype.exitKey = function exitKey(index) {
  var state = this._reporterState;

  state.path = state.path.slice(0, index - 1);
};

Reporter.prototype.leaveKey = function leaveKey(index, key, value) {
  var state = this._reporterState;

  this.exitKey(index);
  if (state.obj !== null)
    state.obj[key] = value;
};

Reporter.prototype.path = function path() {
  return this._reporterState.path.join('/');
};

Reporter.prototype.enterObject = function enterObject() {
  var state = this._reporterState;

  var prev = state.obj;
  state.obj = {};
  return prev;
};

Reporter.prototype.leaveObject = function leaveObject(prev) {
  var state = this._reporterState;

  var now = state.obj;
  state.obj = prev;
  return now;
};

Reporter.prototype.error = function error(msg) {
  var err;
  var state = this._reporterState;

  var inherited = msg instanceof ReporterError;
  if (inherited) {
    err = msg;
  } else {
    err = new ReporterError(state.path.map(function(elem) {
      return '[' + JSON.stringify(elem) + ']';
    }).join(''), msg.message || msg, msg.stack);
  }

  if (!state.options.partial)
    throw err;

  if (!inherited)
    state.errors.push(err);

  return err;
};

Reporter.prototype.wrapResult = function wrapResult(result) {
  var state = this._reporterState;
  if (!state.options.partial)
    return result;

  return {
    result: this.isError(result) ? null : result,
    errors: state.errors
  };
};

function ReporterError(path, msg) {
  this.path = path;
  this.rethrow(msg);
};
inherits(ReporterError, Error);

ReporterError.prototype.rethrow = function rethrow(msg) {
  this.message = msg + ' at: ' + (this.path || '(shallow)');
  if (Error.captureStackTrace)
    Error.captureStackTrace(this, ReporterError);

  if (!this.stack) {
    try {
      // IE only adds stack when thrown
      throw new Error(this.message);
    } catch (e) {
      this.stack = e.stack;
    }
  }
  return this;
};

},{"inherits":231}],121:[function(require,module,exports){
var constants = require('../constants');

exports.tagClass = {
  0: 'universal',
  1: 'application',
  2: 'context',
  3: 'private'
};
exports.tagClassByName = constants._reverse(exports.tagClass);

exports.tag = {
  0x00: 'end',
  0x01: 'bool',
  0x02: 'int',
  0x03: 'bitstr',
  0x04: 'octstr',
  0x05: 'null_',
  0x06: 'objid',
  0x07: 'objDesc',
  0x08: 'external',
  0x09: 'real',
  0x0a: 'enum',
  0x0b: 'embed',
  0x0c: 'utf8str',
  0x0d: 'relativeOid',
  0x10: 'seq',
  0x11: 'set',
  0x12: 'numstr',
  0x13: 'printstr',
  0x14: 't61str',
  0x15: 'videostr',
  0x16: 'ia5str',
  0x17: 'utctime',
  0x18: 'gentime',
  0x19: 'graphstr',
  0x1a: 'iso646str',
  0x1b: 'genstr',
  0x1c: 'unistr',
  0x1d: 'charstr',
  0x1e: 'bmpstr'
};
exports.tagByName = constants._reverse(exports.tag);

},{"../constants":122}],122:[function(require,module,exports){
var constants = exports;

// Helper
constants._reverse = function reverse(map) {
  var res = {};

  Object.keys(map).forEach(function(key) {
    // Convert key to integer if it is stringified
    if ((key | 0) == key)
      key = key | 0;

    var value = map[key];
    res[value] = key;
  });

  return res;
};

constants.der = require('./der');

},{"./der":121}],123:[function(require,module,exports){
var inherits = require('inherits');

var asn1 = require('../../asn1');
var base = asn1.base;
var bignum = asn1.bignum;

// Import DER constants
var der = asn1.constants.der;

function DERDecoder(entity) {
  this.enc = 'der';
  this.name = entity.name;
  this.entity = entity;

  // Construct base tree
  this.tree = new DERNode();
  this.tree._init(entity.body);
};
module.exports = DERDecoder;

DERDecoder.prototype.decode = function decode(data, options) {
  if (!(data instanceof base.DecoderBuffer))
    data = new base.DecoderBuffer(data, options);

  return this.tree._decode(data, options);
};

// Tree methods

function DERNode(parent) {
  base.Node.call(this, 'der', parent);
}
inherits(DERNode, base.Node);

DERNode.prototype._peekTag = function peekTag(buffer, tag, any) {
  if (buffer.isEmpty())
    return false;

  var state = buffer.save();
  var decodedTag = derDecodeTag(buffer, 'Failed to peek tag: "' + tag + '"');
  if (buffer.isError(decodedTag))
    return decodedTag;

  buffer.restore(state);

  return decodedTag.tag === tag || decodedTag.tagStr === tag ||
    (decodedTag.tagStr + 'of') === tag || any;
};

DERNode.prototype._decodeTag = function decodeTag(buffer, tag, any) {
  var decodedTag = derDecodeTag(buffer,
                                'Failed to decode tag of "' + tag + '"');
  if (buffer.isError(decodedTag))
    return decodedTag;

  var len = derDecodeLen(buffer,
                         decodedTag.primitive,
                         'Failed to get length of "' + tag + '"');

  // Failure
  if (buffer.isError(len))
    return len;

  if (!any &&
      decodedTag.tag !== tag &&
      decodedTag.tagStr !== tag &&
      decodedTag.tagStr + 'of' !== tag) {
    return buffer.error('Failed to match tag: "' + tag + '"');
  }

  if (decodedTag.primitive || len !== null)
    return buffer.skip(len, 'Failed to match body of: "' + tag + '"');

  // Indefinite length... find END tag
  var state = buffer.save();
  var res = this._skipUntilEnd(
      buffer,
      'Failed to skip indefinite length body: "' + this.tag + '"');
  if (buffer.isError(res))
    return res;

  len = buffer.offset - state.offset;
  buffer.restore(state);
  return buffer.skip(len, 'Failed to match body of: "' + tag + '"');
};

DERNode.prototype._skipUntilEnd = function skipUntilEnd(buffer, fail) {
  while (true) {
    var tag = derDecodeTag(buffer, fail);
    if (buffer.isError(tag))
      return tag;
    var len = derDecodeLen(buffer, tag.primitive, fail);
    if (buffer.isError(len))
      return len;

    var res;
    if (tag.primitive || len !== null)
      res = buffer.skip(len)
    else
      res = this._skipUntilEnd(buffer, fail);

    // Failure
    if (buffer.isError(res))
      return res;

    if (tag.tagStr === 'end')
      break;
  }
};

DERNode.prototype._decodeList = function decodeList(buffer, tag, decoder,
                                                    options) {
  var result = [];
  while (!buffer.isEmpty()) {
    var possibleEnd = this._peekTag(buffer, 'end');
    if (buffer.isError(possibleEnd))
      return possibleEnd;

    var res = decoder.decode(buffer, 'der', options);
    if (buffer.isError(res) && possibleEnd)
      break;
    result.push(res);
  }
  return result;
};

DERNode.prototype._decodeStr = function decodeStr(buffer, tag) {
  if (tag === 'bitstr') {
    var unused = buffer.readUInt8();
    if (buffer.isError(unused))
      return unused;
    return { unused: unused, data: buffer.raw() };
  } else if (tag === 'bmpstr') {
    var raw = buffer.raw();
    if (raw.length % 2 === 1)
      return buffer.error('Decoding of string type: bmpstr length mismatch');

    var str = '';
    for (var i = 0; i < raw.length / 2; i++) {
      str += String.fromCharCode(raw.readUInt16BE(i * 2));
    }
    return str;
  } else if (tag === 'numstr') {
    var numstr = buffer.raw().toString('ascii');
    if (!this._isNumstr(numstr)) {
      return buffer.error('Decoding of string type: ' +
                          'numstr unsupported characters');
    }
    return numstr;
  } else if (tag === 'octstr') {
    return buffer.raw();
  } else if (tag === 'objDesc') {
    return buffer.raw();
  } else if (tag === 'printstr') {
    var printstr = buffer.raw().toString('ascii');
    if (!this._isPrintstr(printstr)) {
      return buffer.error('Decoding of string type: ' +
                          'printstr unsupported characters');
    }
    return printstr;
  } else if (/str$/.test(tag)) {
    return buffer.raw().toString();
  } else {
    return buffer.error('Decoding of string type: ' + tag + ' unsupported');
  }
};

DERNode.prototype._decodeObjid = function decodeObjid(buffer, values, relative) {
  var result;
  var identifiers = [];
  var ident = 0;
  while (!buffer.isEmpty()) {
    var subident = buffer.readUInt8();
    ident <<= 7;
    ident |= subident & 0x7f;
    if ((subident & 0x80) === 0) {
      identifiers.push(ident);
      ident = 0;
    }
  }
  if (subident & 0x80)
    identifiers.push(ident);

  var first = (identifiers[0] / 40) | 0;
  var second = identifiers[0] % 40;

  if (relative)
    result = identifiers;
  else
    result = [first, second].concat(identifiers.slice(1));

  if (values) {
    var tmp = values[result.join(' ')];
    if (tmp === undefined)
      tmp = values[result.join('.')];
    if (tmp !== undefined)
      result = tmp;
  }

  return result;
};

DERNode.prototype._decodeTime = function decodeTime(buffer, tag) {
  var str = buffer.raw().toString();
  if (tag === 'gentime') {
    var year = str.slice(0, 4) | 0;
    var mon = str.slice(4, 6) | 0;
    var day = str.slice(6, 8) | 0;
    var hour = str.slice(8, 10) | 0;
    var min = str.slice(10, 12) | 0;
    var sec = str.slice(12, 14) | 0;
  } else if (tag === 'utctime') {
    var year = str.slice(0, 2) | 0;
    var mon = str.slice(2, 4) | 0;
    var day = str.slice(4, 6) | 0;
    var hour = str.slice(6, 8) | 0;
    var min = str.slice(8, 10) | 0;
    var sec = str.slice(10, 12) | 0;
    if (year < 70)
      year = 2000 + year;
    else
      year = 1900 + year;
  } else {
    return buffer.error('Decoding ' + tag + ' time is not supported yet');
  }

  return Date.UTC(year, mon - 1, day, hour, min, sec, 0);
};

DERNode.prototype._decodeNull = function decodeNull(buffer) {
  return null;
};

DERNode.prototype._decodeBool = function decodeBool(buffer) {
  var res = buffer.readUInt8();
  if (buffer.isError(res))
    return res;
  else
    return res !== 0;
};

DERNode.prototype._decodeInt = function decodeInt(buffer, values) {
  // Bigint, return as it is (assume big endian)
  var raw = buffer.raw();
  var res = new bignum(raw);

  if (values)
    res = values[res.toString(10)] || res;

  return res;
};

DERNode.prototype._use = function use(entity, obj) {
  if (typeof entity === 'function')
    entity = entity(obj);
  return entity._getDecoder('der').tree;
};

// Utility methods

function derDecodeTag(buf, fail) {
  var tag = buf.readUInt8(fail);
  if (buf.isError(tag))
    return tag;

  var cls = der.tagClass[tag >> 6];
  var primitive = (tag & 0x20) === 0;

  // Multi-octet tag - load
  if ((tag & 0x1f) === 0x1f) {
    var oct = tag;
    tag = 0;
    while ((oct & 0x80) === 0x80) {
      oct = buf.readUInt8(fail);
      if (buf.isError(oct))
        return oct;

      tag <<= 7;
      tag |= oct & 0x7f;
    }
  } else {
    tag &= 0x1f;
  }
  var tagStr = der.tag[tag];

  return {
    cls: cls,
    primitive: primitive,
    tag: tag,
    tagStr: tagStr
  };
}

function derDecodeLen(buf, primitive, fail) {
  var len = buf.readUInt8(fail);
  if (buf.isError(len))
    return len;

  // Indefinite form
  if (!primitive && len === 0x80)
    return null;

  // Definite form
  if ((len & 0x80) === 0) {
    // Short form
    return len;
  }

  // Long form
  var num = len & 0x7f;
  if (num > 4)
    return buf.error('length octect is too long');

  len = 0;
  for (var i = 0; i < num; i++) {
    len <<= 8;
    var j = buf.readUInt8(fail);
    if (buf.isError(j))
      return j;
    len |= j;
  }

  return len;
}

},{"../../asn1":115,"inherits":231}],124:[function(require,module,exports){
var decoders = exports;

decoders.der = require('./der');
decoders.pem = require('./pem');

},{"./der":123,"./pem":125}],125:[function(require,module,exports){
var inherits = require('inherits');
var Buffer = require('buffer').Buffer;

var DERDecoder = require('./der');

function PEMDecoder(entity) {
  DERDecoder.call(this, entity);
  this.enc = 'pem';
};
inherits(PEMDecoder, DERDecoder);
module.exports = PEMDecoder;

PEMDecoder.prototype.decode = function decode(data, options) {
  var lines = data.toString().split(/[\r\n]+/g);

  var label = options.label.toUpperCase();

  var re = /^-----(BEGIN|END) ([^-]+)-----$/;
  var start = -1;
  var end = -1;
  for (var i = 0; i < lines.length; i++) {
    var match = lines[i].match(re);
    if (match === null)
      continue;

    if (match[2] !== label)
      continue;

    if (start === -1) {
      if (match[1] !== 'BEGIN')
        break;
      start = i;
    } else {
      if (match[1] !== 'END')
        break;
      end = i;
      break;
    }
  }
  if (start === -1 || end === -1)
    throw new Error('PEM section not found for: ' + label);

  var base64 = lines.slice(start + 1, end).join('');
  // Remove excessive symbols
  base64.replace(/[^a-z0-9\+\/=]+/gi, '');

  var input = new Buffer(base64, 'base64');
  return DERDecoder.prototype.decode.call(this, input, options);
};

},{"./der":123,"buffer":162,"inherits":231}],126:[function(require,module,exports){
var inherits = require('inherits');
var Buffer = require('buffer').Buffer;

var asn1 = require('../../asn1');
var base = asn1.base;

// Import DER constants
var der = asn1.constants.der;

function DEREncoder(entity) {
  this.enc = 'der';
  this.name = entity.name;
  this.entity = entity;

  // Construct base tree
  this.tree = new DERNode();
  this.tree._init(entity.body);
};
module.exports = DEREncoder;

DEREncoder.prototype.encode = function encode(data, reporter) {
  return this.tree._encode(data, reporter).join();
};

// Tree methods

function DERNode(parent) {
  base.Node.call(this, 'der', parent);
}
inherits(DERNode, base.Node);

DERNode.prototype._encodeComposite = function encodeComposite(tag,
                                                              primitive,
                                                              cls,
                                                              content) {
  var encodedTag = encodeTag(tag, primitive, cls, this.reporter);

  // Short form
  if (content.length < 0x80) {
    var header = new Buffer(2);
    header[0] = encodedTag;
    header[1] = content.length;
    return this._createEncoderBuffer([ header, content ]);
  }

  // Long form
  // Count octets required to store length
  var lenOctets = 1;
  for (var i = content.length; i >= 0x100; i >>= 8)
    lenOctets++;

  var header = new Buffer(1 + 1 + lenOctets);
  header[0] = encodedTag;
  header[1] = 0x80 | lenOctets;

  for (var i = 1 + lenOctets, j = content.length; j > 0; i--, j >>= 8)
    header[i] = j & 0xff;

  return this._createEncoderBuffer([ header, content ]);
};

DERNode.prototype._encodeStr = function encodeStr(str, tag) {
  if (tag === 'bitstr') {
    return this._createEncoderBuffer([ str.unused | 0, str.data ]);
  } else if (tag === 'bmpstr') {
    var buf = new Buffer(str.length * 2);
    for (var i = 0; i < str.length; i++) {
      buf.writeUInt16BE(str.charCodeAt(i), i * 2);
    }
    return this._createEncoderBuffer(buf);
  } else if (tag === 'numstr') {
    if (!this._isNumstr(str)) {
      return this.reporter.error('Encoding of string type: numstr supports ' +
                                 'only digits and space');
    }
    return this._createEncoderBuffer(str);
  } else if (tag === 'printstr') {
    if (!this._isPrintstr(str)) {
      return this.reporter.error('Encoding of string type: printstr supports ' +
                                 'only latin upper and lower case letters, ' +
                                 'digits, space, apostrophe, left and rigth ' +
                                 'parenthesis, plus sign, comma, hyphen, ' +
                                 'dot, slash, colon, equal sign, ' +
                                 'question mark');
    }
    return this._createEncoderBuffer(str);
  } else if (/str$/.test(tag)) {
    return this._createEncoderBuffer(str);
  } else if (tag === 'objDesc') {
    return this._createEncoderBuffer(str);
  } else {
    return this.reporter.error('Encoding of string type: ' + tag +
                               ' unsupported');
  }
};

DERNode.prototype._encodeObjid = function encodeObjid(id, values, relative) {
  if (typeof id === 'string') {
    if (!values)
      return this.reporter.error('string objid given, but no values map found');
    if (!values.hasOwnProperty(id))
      return this.reporter.error('objid not found in values map');
    id = values[id].split(/[\s\.]+/g);
    for (var i = 0; i < id.length; i++)
      id[i] |= 0;
  } else if (Array.isArray(id)) {
    id = id.slice();
    for (var i = 0; i < id.length; i++)
      id[i] |= 0;
  }

  if (!Array.isArray(id)) {
    return this.reporter.error('objid() should be either array or string, ' +
                               'got: ' + JSON.stringify(id));
  }

  if (!relative) {
    if (id[1] >= 40)
      return this.reporter.error('Second objid identifier OOB');
    id.splice(0, 2, id[0] * 40 + id[1]);
  }

  // Count number of octets
  var size = 0;
  for (var i = 0; i < id.length; i++) {
    var ident = id[i];
    for (size++; ident >= 0x80; ident >>= 7)
      size++;
  }

  var objid = new Buffer(size);
  var offset = objid.length - 1;
  for (var i = id.length - 1; i >= 0; i--) {
    var ident = id[i];
    objid[offset--] = ident & 0x7f;
    while ((ident >>= 7) > 0)
      objid[offset--] = 0x80 | (ident & 0x7f);
  }

  return this._createEncoderBuffer(objid);
};

function two(num) {
  if (num < 10)
    return '0' + num;
  else
    return num;
}

DERNode.prototype._encodeTime = function encodeTime(time, tag) {
  var str;
  var date = new Date(time);

  if (tag === 'gentime') {
    str = [
      two(date.getFullYear()),
      two(date.getUTCMonth() + 1),
      two(date.getUTCDate()),
      two(date.getUTCHours()),
      two(date.getUTCMinutes()),
      two(date.getUTCSeconds()),
      'Z'
    ].join('');
  } else if (tag === 'utctime') {
    str = [
      two(date.getFullYear() % 100),
      two(date.getUTCMonth() + 1),
      two(date.getUTCDate()),
      two(date.getUTCHours()),
      two(date.getUTCMinutes()),
      two(date.getUTCSeconds()),
      'Z'
    ].join('');
  } else {
    this.reporter.error('Encoding ' + tag + ' time is not supported yet');
  }

  return this._encodeStr(str, 'octstr');
};

DERNode.prototype._encodeNull = function encodeNull() {
  return this._createEncoderBuffer('');
};

DERNode.prototype._encodeInt = function encodeInt(num, values) {
  if (typeof num === 'string') {
    if (!values)
      return this.reporter.error('String int or enum given, but no values map');
    if (!values.hasOwnProperty(num)) {
      return this.reporter.error('Values map doesn\'t contain: ' +
                                 JSON.stringify(num));
    }
    num = values[num];
  }

  // Bignum, assume big endian
  if (typeof num !== 'number' && !Buffer.isBuffer(num)) {
    var numArray = num.toArray();
    if (!num.sign && numArray[0] & 0x80) {
      numArray.unshift(0);
    }
    num = new Buffer(numArray);
  }

  if (Buffer.isBuffer(num)) {
    var size = num.length;
    if (num.length === 0)
      size++;

    var out = new Buffer(size);
    num.copy(out);
    if (num.length === 0)
      out[0] = 0
    return this._createEncoderBuffer(out);
  }

  if (num < 0x80)
    return this._createEncoderBuffer(num);

  if (num < 0x100)
    return this._createEncoderBuffer([0, num]);

  var size = 1;
  for (var i = num; i >= 0x100; i >>= 8)
    size++;

  var out = new Array(size);
  for (var i = out.length - 1; i >= 0; i--) {
    out[i] = num & 0xff;
    num >>= 8;
  }
  if(out[0] & 0x80) {
    out.unshift(0);
  }

  return this._createEncoderBuffer(new Buffer(out));
};

DERNode.prototype._encodeBool = function encodeBool(value) {
  return this._createEncoderBuffer(value ? 0xff : 0);
};

DERNode.prototype._use = function use(entity, obj) {
  if (typeof entity === 'function')
    entity = entity(obj);
  return entity._getEncoder('der').tree;
};

DERNode.prototype._skipDefault = function skipDefault(dataBuffer, reporter, parent) {
  var state = this._baseState;
  var i;
  if (state['default'] === null)
    return false;

  var data = dataBuffer.join();
  if (state.defaultBuffer === undefined)
    state.defaultBuffer = this._encodeValue(state['default'], reporter, parent).join();

  if (data.length !== state.defaultBuffer.length)
    return false;

  for (i=0; i < data.length; i++)
    if (data[i] !== state.defaultBuffer[i])
      return false;

  return true;
};

// Utility methods

function encodeTag(tag, primitive, cls, reporter) {
  var res;

  if (tag === 'seqof')
    tag = 'seq';
  else if (tag === 'setof')
    tag = 'set';

  if (der.tagByName.hasOwnProperty(tag))
    res = der.tagByName[tag];
  else if (typeof tag === 'number' && (tag | 0) === tag)
    res = tag;
  else
    return reporter.error('Unknown tag: ' + tag);

  if (res >= 0x1f)
    return reporter.error('Multi-octet tag encoding unsupported');

  if (!primitive)
    res |= 0x20;

  res |= (der.tagClassByName[cls || 'universal'] << 6);

  return res;
}

},{"../../asn1":115,"buffer":162,"inherits":231}],127:[function(require,module,exports){
var encoders = exports;

encoders.der = require('./der');
encoders.pem = require('./pem');

},{"./der":126,"./pem":128}],128:[function(require,module,exports){
var inherits = require('inherits');

var DEREncoder = require('./der');

function PEMEncoder(entity) {
  DEREncoder.call(this, entity);
  this.enc = 'pem';
};
inherits(PEMEncoder, DEREncoder);
module.exports = PEMEncoder;

PEMEncoder.prototype.encode = function encode(data, options) {
  var buf = DEREncoder.prototype.encode.call(this, data);

  var p = buf.toString('base64');
  var out = [ '-----BEGIN ' + options.label + '-----' ];
  for (var i = 0; i < p.length; i += 64)
    out.push(p.slice(i, i + 64));
  out.push('-----END ' + options.label + '-----');
  return out.join('\n');
};

},{"./der":126,"inherits":231}],129:[function(require,module,exports){
'use strict'

exports.byteLength = byteLength
exports.toByteArray = toByteArray
exports.fromByteArray = fromByteArray

var lookup = []
var revLookup = []
var Arr = typeof Uint8Array !== 'undefined' ? Uint8Array : Array

var code = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/'
for (var i = 0, len = code.length; i < len; ++i) {
  lookup[i] = code[i]
  revLookup[code.charCodeAt(i)] = i
}

// Support decoding URL-safe base64 strings, as Node.js does.
// See: https://en.wikipedia.org/wiki/Base64#URL_applications
revLookup['-'.charCodeAt(0)] = 62
revLookup['_'.charCodeAt(0)] = 63

function getLens (b64) {
  var len = b64.length

  if (len % 4 > 0) {
    throw new Error('Invalid string. Length must be a multiple of 4')
  }

  // Trim off extra bytes after placeholder bytes are found
  // See: https://github.com/beatgammit/base64-js/issues/42
  var validLen = b64.indexOf('=')
  if (validLen === -1) validLen = len

  var placeHoldersLen = validLen === len
    ? 0
    : 4 - (validLen % 4)

  return [validLen, placeHoldersLen]
}

// base64 is 4/3 + up to two characters of the original data
function byteLength (b64) {
  var lens = getLens(b64)
  var validLen = lens[0]
  var placeHoldersLen = lens[1]
  return ((validLen + placeHoldersLen) * 3 / 4) - placeHoldersLen
}

function _byteLength (b64, validLen, placeHoldersLen) {
  return ((validLen + placeHoldersLen) * 3 / 4) - placeHoldersLen
}

function toByteArray (b64) {
  var tmp
  var lens = getLens(b64)
  var validLen = lens[0]
  var placeHoldersLen = lens[1]

  var arr = new Arr(_byteLength(b64, validLen, placeHoldersLen))

  var curByte = 0

  // if there are placeholders, only get up to the last complete 4 chars
  var len = placeHoldersLen > 0
    ? validLen - 4
    : validLen

  for (var i = 0; i < len; i += 4) {
    tmp =
      (revLookup[b64.charCodeAt(i)] << 18) |
      (revLookup[b64.charCodeAt(i + 1)] << 12) |
      (revLookup[b64.charCodeAt(i + 2)] << 6) |
      revLookup[b64.charCodeAt(i + 3)]
    arr[curByte++] = (tmp >> 16) & 0xFF
    arr[curByte++] = (tmp >> 8) & 0xFF
    arr[curByte++] = tmp & 0xFF
  }

  if (placeHoldersLen === 2) {
    tmp =
      (revLookup[b64.charCodeAt(i)] << 2) |
      (revLookup[b64.charCodeAt(i + 1)] >> 4)
    arr[curByte++] = tmp & 0xFF
  }

  if (placeHoldersLen === 1) {
    tmp =
      (revLookup[b64.charCodeAt(i)] << 10) |
      (revLookup[b64.charCodeAt(i + 1)] << 4) |
      (revLookup[b64.charCodeAt(i + 2)] >> 2)
    arr[curByte++] = (tmp >> 8) & 0xFF
    arr[curByte++] = tmp & 0xFF
  }

  return arr
}

function tripletToBase64 (num) {
  return lookup[num >> 18 & 0x3F] +
    lookup[num >> 12 & 0x3F] +
    lookup[num >> 6 & 0x3F] +
    lookup[num & 0x3F]
}

function encodeChunk (uint8, start, end) {
  var tmp
  var output = []
  for (var i = start; i < end; i += 3) {
    tmp =
      ((uint8[i] << 16) & 0xFF0000) +
      ((uint8[i + 1] << 8) & 0xFF00) +
      (uint8[i + 2] & 0xFF)
    output.push(tripletToBase64(tmp))
  }
  return output.join('')
}

function fromByteArray (uint8) {
  var tmp
  var len = uint8.length
  var extraBytes = len % 3 // if we have 1 byte left, pad 2 bytes
  var parts = []
  var maxChunkLength = 16383 // must be multiple of 3

  // go through the array every three bytes, we'll deal with trailing stuff later
  for (var i = 0, len2 = len - extraBytes; i < len2; i += maxChunkLength) {
    parts.push(encodeChunk(
      uint8, i, (i + maxChunkLength) > len2 ? len2 : (i + maxChunkLength)
    ))
  }

  // pad the end with zeros, but make sure to not forget the extra bytes
  if (extraBytes === 1) {
    tmp = uint8[len - 1]
    parts.push(
      lookup[tmp >> 2] +
      lookup[(tmp << 4) & 0x3F] +
      '=='
    )
  } else if (extraBytes === 2) {
    tmp = (uint8[len - 2] << 8) + uint8[len - 1]
    parts.push(
      lookup[tmp >> 10] +
      lookup[(tmp >> 4) & 0x3F] +
      lookup[(tmp << 2) & 0x3F] +
      '='
    )
  }

  return parts.join('')
}

},{}],130:[function(require,module,exports){
(function (module, exports) {
  'use strict';

  // Utils
  function assert (val, msg) {
    if (!val) throw new Error(msg || 'Assertion failed');
  }

  // Could use `inherits` module, but don't want to move from single file
  // architecture yet.
  function inherits (ctor, superCtor) {
    ctor.super_ = superCtor;
    var TempCtor = function () {};
    TempCtor.prototype = superCtor.prototype;
    ctor.prototype = new TempCtor();
    ctor.prototype.constructor = ctor;
  }

  // BN

  function BN (number, base, endian) {
    if (BN.isBN(number)) {
      return number;
    }

    this.negative = 0;
    this.words = null;
    this.length = 0;

    // Reduction context
    this.red = null;

    if (number !== null) {
      if (base === 'le' || base === 'be') {
        endian = base;
        base = 10;
      }

      this._init(number || 0, base || 10, endian || 'be');
    }
  }
  if (typeof module === 'object') {
    module.exports = BN;
  } else {
    exports.BN = BN;
  }

  BN.BN = BN;
  BN.wordSize = 26;

  var Buffer;
  try {
    Buffer = require('buffer').Buffer;
  } catch (e) {
  }

  BN.isBN = function isBN (num) {
    if (num instanceof BN) {
      return true;
    }

    return num !== null && typeof num === 'object' &&
      num.constructor.wordSize === BN.wordSize && Array.isArray(num.words);
  };

  BN.max = function max (left, right) {
    if (left.cmp(right) > 0) return left;
    return right;
  };

  BN.min = function min (left, right) {
    if (left.cmp(right) < 0) return left;
    return right;
  };

  BN.prototype._init = function init (number, base, endian) {
    if (typeof number === 'number') {
      return this._initNumber(number, base, endian);
    }

    if (typeof number === 'object') {
      return this._initArray(number, base, endian);
    }

    if (base === 'hex') {
      base = 16;
    }
    assert(base === (base | 0) && base >= 2 && base <= 36);

    number = number.toString().replace(/\s+/g, '');
    var start = 0;
    if (number[0] === '-') {
      start++;
    }

    if (base === 16) {
      this._parseHex(number, start);
    } else {
      this._parseBase(number, base, start);
    }

    if (number[0] === '-') {
      this.negative = 1;
    }

    this.strip();

    if (endian !== 'le') return;

    this._initArray(this.toArray(), base, endian);
  };

  BN.prototype._initNumber = function _initNumber (number, base, endian) {
    if (number < 0) {
      this.negative = 1;
      number = -number;
    }
    if (number < 0x4000000) {
      this.words = [ number & 0x3ffffff ];
      this.length = 1;
    } else if (number < 0x10000000000000) {
      this.words = [
        number & 0x3ffffff,
        (number / 0x4000000) & 0x3ffffff
      ];
      this.length = 2;
    } else {
      assert(number < 0x20000000000000); // 2 ^ 53 (unsafe)
      this.words = [
        number & 0x3ffffff,
        (number / 0x4000000) & 0x3ffffff,
        1
      ];
      this.length = 3;
    }

    if (endian !== 'le') return;

    // Reverse the bytes
    this._initArray(this.toArray(), base, endian);
  };

  BN.prototype._initArray = function _initArray (number, base, endian) {
    // Perhaps a Uint8Array
    assert(typeof number.length === 'number');
    if (number.length <= 0) {
      this.words = [ 0 ];
      this.length = 1;
      return this;
    }

    this.length = Math.ceil(number.length / 3);
    this.words = new Array(this.length);
    for (var i = 0; i < this.length; i++) {
      this.words[i] = 0;
    }

    var j, w;
    var off = 0;
    if (endian === 'be') {
      for (i = number.length - 1, j = 0; i >= 0; i -= 3) {
        w = number[i] | (number[i - 1] << 8) | (number[i - 2] << 16);
        this.words[j] |= (w << off) & 0x3ffffff;
        this.words[j + 1] = (w >>> (26 - off)) & 0x3ffffff;
        off += 24;
        if (off >= 26) {
          off -= 26;
          j++;
        }
      }
    } else if (endian === 'le') {
      for (i = 0, j = 0; i < number.length; i += 3) {
        w = number[i] | (number[i + 1] << 8) | (number[i + 2] << 16);
        this.words[j] |= (w << off) & 0x3ffffff;
        this.words[j + 1] = (w >>> (26 - off)) & 0x3ffffff;
        off += 24;
        if (off >= 26) {
          off -= 26;
          j++;
        }
      }
    }
    return this.strip();
  };

  function parseHex (str, start, end) {
    var r = 0;
    var len = Math.min(str.length, end);
    for (var i = start; i < len; i++) {
      var c = str.charCodeAt(i) - 48;

      r <<= 4;

      // 'a' - 'f'
      if (c >= 49 && c <= 54) {
        r |= c - 49 + 0xa;

      // 'A' - 'F'
      } else if (c >= 17 && c <= 22) {
        r |= c - 17 + 0xa;

      // '0' - '9'
      } else {
        r |= c & 0xf;
      }
    }
    return r;
  }

  BN.prototype._parseHex = function _parseHex (number, start) {
    // Create possibly bigger array to ensure that it fits the number
    this.length = Math.ceil((number.length - start) / 6);
    this.words = new Array(this.length);
    for (var i = 0; i < this.length; i++) {
      this.words[i] = 0;
    }

    var j, w;
    // Scan 24-bit chunks and add them to the number
    var off = 0;
    for (i = number.length - 6, j = 0; i >= start; i -= 6) {
      w = parseHex(number, i, i + 6);
      this.words[j] |= (w << off) & 0x3ffffff;
      // NOTE: `0x3fffff` is intentional here, 26bits max shift + 24bit hex limb
      this.words[j + 1] |= w >>> (26 - off) & 0x3fffff;
      off += 24;
      if (off >= 26) {
        off -= 26;
        j++;
      }
    }
    if (i + 6 !== start) {
      w = parseHex(number, start, i + 6);
      this.words[j] |= (w << off) & 0x3ffffff;
      this.words[j + 1] |= w >>> (26 - off) & 0x3fffff;
    }
    this.strip();
  };

  function parseBase (str, start, end, mul) {
    var r = 0;
    var len = Math.min(str.length, end);
    for (var i = start; i < len; i++) {
      var c = str.charCodeAt(i) - 48;

      r *= mul;

      // 'a'
      if (c >= 49) {
        r += c - 49 + 0xa;

      // 'A'
      } else if (c >= 17) {
        r += c - 17 + 0xa;

      // '0' - '9'
      } else {
        r += c;
      }
    }
    return r;
  }

  BN.prototype._parseBase = function _parseBase (number, base, start) {
    // Initialize as zero
    this.words = [ 0 ];
    this.length = 1;

    // Find length of limb in base
    for (var limbLen = 0, limbPow = 1; limbPow <= 0x3ffffff; limbPow *= base) {
      limbLen++;
    }
    limbLen--;
    limbPow = (limbPow / base) | 0;

    var total = number.length - start;
    var mod = total % limbLen;
    var end = Math.min(total, total - mod) + start;

    var word = 0;
    for (var i = start; i < end; i += limbLen) {
      word = parseBase(number, i, i + limbLen, base);

      this.imuln(limbPow);
      if (this.words[0] + word < 0x4000000) {
        this.words[0] += word;
      } else {
        this._iaddn(word);
      }
    }

    if (mod !== 0) {
      var pow = 1;
      word = parseBase(number, i, number.length, base);

      for (i = 0; i < mod; i++) {
        pow *= base;
      }

      this.imuln(pow);
      if (this.words[0] + word < 0x4000000) {
        this.words[0] += word;
      } else {
        this._iaddn(word);
      }
    }
  };

  BN.prototype.copy = function copy (dest) {
    dest.words = new Array(this.length);
    for (var i = 0; i < this.length; i++) {
      dest.words[i] = this.words[i];
    }
    dest.length = this.length;
    dest.negative = this.negative;
    dest.red = this.red;
  };

  BN.prototype.clone = function clone () {
    var r = new BN(null);
    this.copy(r);
    return r;
  };

  BN.prototype._expand = function _expand (size) {
    while (this.length < size) {
      this.words[this.length++] = 0;
    }
    return this;
  };

  // Remove leading `0` from `this`
  BN.prototype.strip = function strip () {
    while (this.length > 1 && this.words[this.length - 1] === 0) {
      this.length--;
    }
    return this._normSign();
  };

  BN.prototype._normSign = function _normSign () {
    // -0 = 0
    if (this.length === 1 && this.words[0] === 0) {
      this.negative = 0;
    }
    return this;
  };

  BN.prototype.inspect = function inspect () {
    return (this.red ? '<BN-R: ' : '<BN: ') + this.toString(16) + '>';
  };

  /*

  var zeros = [];
  var groupSizes = [];
  var groupBases = [];

  var s = '';
  var i = -1;
  while (++i < BN.wordSize) {
    zeros[i] = s;
    s += '0';
  }
  groupSizes[0] = 0;
  groupSizes[1] = 0;
  groupBases[0] = 0;
  groupBases[1] = 0;
  var base = 2 - 1;
  while (++base < 36 + 1) {
    var groupSize = 0;
    var groupBase = 1;
    while (groupBase < (1 << BN.wordSize) / base) {
      groupBase *= base;
      groupSize += 1;
    }
    groupSizes[base] = groupSize;
    groupBases[base] = groupBase;
  }

  */

  var zeros = [
    '',
    '0',
    '00',
    '000',
    '0000',
    '00000',
    '000000',
    '0000000',
    '00000000',
    '000000000',
    '0000000000',
    '00000000000',
    '000000000000',
    '0000000000000',
    '00000000000000',
    '000000000000000',
    '0000000000000000',
    '00000000000000000',
    '000000000000000000',
    '0000000000000000000',
    '00000000000000000000',
    '000000000000000000000',
    '0000000000000000000000',
    '00000000000000000000000',
    '000000000000000000000000',
    '0000000000000000000000000'
  ];

  var groupSizes = [
    0, 0,
    25, 16, 12, 11, 10, 9, 8,
    8, 7, 7, 7, 7, 6, 6,
    6, 6, 6, 6, 6, 5, 5,
    5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5
  ];

  var groupBases = [
    0, 0,
    33554432, 43046721, 16777216, 48828125, 60466176, 40353607, 16777216,
    43046721, 10000000, 19487171, 35831808, 62748517, 7529536, 11390625,
    16777216, 24137569, 34012224, 47045881, 64000000, 4084101, 5153632,
    6436343, 7962624, 9765625, 11881376, 14348907, 17210368, 20511149,
    24300000, 28629151, 33554432, 39135393, 45435424, 52521875, 60466176
  ];

  BN.prototype.toString = function toString (base, padding) {
    base = base || 10;
    padding = padding | 0 || 1;

    var out;
    if (base === 16 || base === 'hex') {
      out = '';
      var off = 0;
      var carry = 0;
      for (var i = 0; i < this.length; i++) {
        var w = this.words[i];
        var word = (((w << off) | carry) & 0xffffff).toString(16);
        carry = (w >>> (24 - off)) & 0xffffff;
        if (carry !== 0 || i !== this.length - 1) {
          out = zeros[6 - word.length] + word + out;
        } else {
          out = word + out;
        }
        off += 2;
        if (off >= 26) {
          off -= 26;
          i--;
        }
      }
      if (carry !== 0) {
        out = carry.toString(16) + out;
      }
      while (out.length % padding !== 0) {
        out = '0' + out;
      }
      if (this.negative !== 0) {
        out = '-' + out;
      }
      return out;
    }

    if (base === (base | 0) && base >= 2 && base <= 36) {
      // var groupSize = Math.floor(BN.wordSize * Math.LN2 / Math.log(base));
      var groupSize = groupSizes[base];
      // var groupBase = Math.pow(base, groupSize);
      var groupBase = groupBases[base];
      out = '';
      var c = this.clone();
      c.negative = 0;
      while (!c.isZero()) {
        var r = c.modn(groupBase).toString(base);
        c = c.idivn(groupBase);

        if (!c.isZero()) {
          out = zeros[groupSize - r.length] + r + out;
        } else {
          out = r + out;
        }
      }
      if (this.isZero()) {
        out = '0' + out;
      }
      while (out.length % padding !== 0) {
        out = '0' + out;
      }
      if (this.negative !== 0) {
        out = '-' + out;
      }
      return out;
    }

    assert(false, 'Base should be between 2 and 36');
  };

  BN.prototype.toNumber = function toNumber () {
    var ret = this.words[0];
    if (this.length === 2) {
      ret += this.words[1] * 0x4000000;
    } else if (this.length === 3 && this.words[2] === 0x01) {
      // NOTE: at this stage it is known that the top bit is set
      ret += 0x10000000000000 + (this.words[1] * 0x4000000);
    } else if (this.length > 2) {
      assert(false, 'Number can only safely store up to 53 bits');
    }
    return (this.negative !== 0) ? -ret : ret;
  };

  BN.prototype.toJSON = function toJSON () {
    return this.toString(16);
  };

  BN.prototype.toBuffer = function toBuffer (endian, length) {
    assert(typeof Buffer !== 'undefined');
    return this.toArrayLike(Buffer, endian, length);
  };

  BN.prototype.toArray = function toArray (endian, length) {
    return this.toArrayLike(Array, endian, length);
  };

  BN.prototype.toArrayLike = function toArrayLike (ArrayType, endian, length) {
    var byteLength = this.byteLength();
    var reqLength = length || Math.max(1, byteLength);
    assert(byteLength <= reqLength, 'byte array longer than desired length');
    assert(reqLength > 0, 'Requested array length <= 0');

    this.strip();
    var littleEndian = endian === 'le';
    var res = new ArrayType(reqLength);

    var b, i;
    var q = this.clone();
    if (!littleEndian) {
      // Assume big-endian
      for (i = 0; i < reqLength - byteLength; i++) {
        res[i] = 0;
      }

      for (i = 0; !q.isZero(); i++) {
        b = q.andln(0xff);
        q.iushrn(8);

        res[reqLength - i - 1] = b;
      }
    } else {
      for (i = 0; !q.isZero(); i++) {
        b = q.andln(0xff);
        q.iushrn(8);

        res[i] = b;
      }

      for (; i < reqLength; i++) {
        res[i] = 0;
      }
    }

    return res;
  };

  if (Math.clz32) {
    BN.prototype._countBits = function _countBits (w) {
      return 32 - Math.clz32(w);
    };
  } else {
    BN.prototype._countBits = function _countBits (w) {
      var t = w;
      var r = 0;
      if (t >= 0x1000) {
        r += 13;
        t >>>= 13;
      }
      if (t >= 0x40) {
        r += 7;
        t >>>= 7;
      }
      if (t >= 0x8) {
        r += 4;
        t >>>= 4;
      }
      if (t >= 0x02) {
        r += 2;
        t >>>= 2;
      }
      return r + t;
    };
  }

  BN.prototype._zeroBits = function _zeroBits (w) {
    // Short-cut
    if (w === 0) return 26;

    var t = w;
    var r = 0;
    if ((t & 0x1fff) === 0) {
      r += 13;
      t >>>= 13;
    }
    if ((t & 0x7f) === 0) {
      r += 7;
      t >>>= 7;
    }
    if ((t & 0xf) === 0) {
      r += 4;
      t >>>= 4;
    }
    if ((t & 0x3) === 0) {
      r += 2;
      t >>>= 2;
    }
    if ((t & 0x1) === 0) {
      r++;
    }
    return r;
  };

  // Return number of used bits in a BN
  BN.prototype.bitLength = function bitLength () {
    var w = this.words[this.length - 1];
    var hi = this._countBits(w);
    return (this.length - 1) * 26 + hi;
  };

  function toBitArray (num) {
    var w = new Array(num.bitLength());

    for (var bit = 0; bit < w.length; bit++) {
      var off = (bit / 26) | 0;
      var wbit = bit % 26;

      w[bit] = (num.words[off] & (1 << wbit)) >>> wbit;
    }

    return w;
  }

  // Number of trailing zero bits
  BN.prototype.zeroBits = function zeroBits () {
    if (this.isZero()) return 0;

    var r = 0;
    for (var i = 0; i < this.length; i++) {
      var b = this._zeroBits(this.words[i]);
      r += b;
      if (b !== 26) break;
    }
    return r;
  };

  BN.prototype.byteLength = function byteLength () {
    return Math.ceil(this.bitLength() / 8);
  };

  BN.prototype.toTwos = function toTwos (width) {
    if (this.negative !== 0) {
      return this.abs().inotn(width).iaddn(1);
    }
    return this.clone();
  };

  BN.prototype.fromTwos = function fromTwos (width) {
    if (this.testn(width - 1)) {
      return this.notn(width).iaddn(1).ineg();
    }
    return this.clone();
  };

  BN.prototype.isNeg = function isNeg () {
    return this.negative !== 0;
  };

  // Return negative clone of `this`
  BN.prototype.neg = function neg () {
    return this.clone().ineg();
  };

  BN.prototype.ineg = function ineg () {
    if (!this.isZero()) {
      this.negative ^= 1;
    }

    return this;
  };

  // Or `num` with `this` in-place
  BN.prototype.iuor = function iuor (num) {
    while (this.length < num.length) {
      this.words[this.length++] = 0;
    }

    for (var i = 0; i < num.length; i++) {
      this.words[i] = this.words[i] | num.words[i];
    }

    return this.strip();
  };

  BN.prototype.ior = function ior (num) {
    assert((this.negative | num.negative) === 0);
    return this.iuor(num);
  };

  // Or `num` with `this`
  BN.prototype.or = function or (num) {
    if (this.length > num.length) return this.clone().ior(num);
    return num.clone().ior(this);
  };

  BN.prototype.uor = function uor (num) {
    if (this.length > num.length) return this.clone().iuor(num);
    return num.clone().iuor(this);
  };

  // And `num` with `this` in-place
  BN.prototype.iuand = function iuand (num) {
    // b = min-length(num, this)
    var b;
    if (this.length > num.length) {
      b = num;
    } else {
      b = this;
    }

    for (var i = 0; i < b.length; i++) {
      this.words[i] = this.words[i] & num.words[i];
    }

    this.length = b.length;

    return this.strip();
  };

  BN.prototype.iand = function iand (num) {
    assert((this.negative | num.negative) === 0);
    return this.iuand(num);
  };

  // And `num` with `this`
  BN.prototype.and = function and (num) {
    if (this.length > num.length) return this.clone().iand(num);
    return num.clone().iand(this);
  };

  BN.prototype.uand = function uand (num) {
    if (this.length > num.length) return this.clone().iuand(num);
    return num.clone().iuand(this);
  };

  // Xor `num` with `this` in-place
  BN.prototype.iuxor = function iuxor (num) {
    // a.length > b.length
    var a;
    var b;
    if (this.length > num.length) {
      a = this;
      b = num;
    } else {
      a = num;
      b = this;
    }

    for (var i = 0; i < b.length; i++) {
      this.words[i] = a.words[i] ^ b.words[i];
    }

    if (this !== a) {
      for (; i < a.length; i++) {
        this.words[i] = a.words[i];
      }
    }

    this.length = a.length;

    return this.strip();
  };

  BN.prototype.ixor = function ixor (num) {
    assert((this.negative | num.negative) === 0);
    return this.iuxor(num);
  };

  // Xor `num` with `this`
  BN.prototype.xor = function xor (num) {
    if (this.length > num.length) return this.clone().ixor(num);
    return num.clone().ixor(this);
  };

  BN.prototype.uxor = function uxor (num) {
    if (this.length > num.length) return this.clone().iuxor(num);
    return num.clone().iuxor(this);
  };

  // Not ``this`` with ``width`` bitwidth
  BN.prototype.inotn = function inotn (width) {
    assert(typeof width === 'number' && width >= 0);

    var bytesNeeded = Math.ceil(width / 26) | 0;
    var bitsLeft = width % 26;

    // Extend the buffer with leading zeroes
    this._expand(bytesNeeded);

    if (bitsLeft > 0) {
      bytesNeeded--;
    }

    // Handle complete words
    for (var i = 0; i < bytesNeeded; i++) {
      this.words[i] = ~this.words[i] & 0x3ffffff;
    }

    // Handle the residue
    if (bitsLeft > 0) {
      this.words[i] = ~this.words[i] & (0x3ffffff >> (26 - bitsLeft));
    }

    // And remove leading zeroes
    return this.strip();
  };

  BN.prototype.notn = function notn (width) {
    return this.clone().inotn(width);
  };

  // Set `bit` of `this`
  BN.prototype.setn = function setn (bit, val) {
    assert(typeof bit === 'number' && bit >= 0);

    var off = (bit / 26) | 0;
    var wbit = bit % 26;

    this._expand(off + 1);

    if (val) {
      this.words[off] = this.words[off] | (1 << wbit);
    } else {
      this.words[off] = this.words[off] & ~(1 << wbit);
    }

    return this.strip();
  };

  // Add `num` to `this` in-place
  BN.prototype.iadd = function iadd (num) {
    var r;

    // negative + positive
    if (this.negative !== 0 && num.negative === 0) {
      this.negative = 0;
      r = this.isub(num);
      this.negative ^= 1;
      return this._normSign();

    // positive + negative
    } else if (this.negative === 0 && num.negative !== 0) {
      num.negative = 0;
      r = this.isub(num);
      num.negative = 1;
      return r._normSign();
    }

    // a.length > b.length
    var a, b;
    if (this.length > num.length) {
      a = this;
      b = num;
    } else {
      a = num;
      b = this;
    }

    var carry = 0;
    for (var i = 0; i < b.length; i++) {
      r = (a.words[i] | 0) + (b.words[i] | 0) + carry;
      this.words[i] = r & 0x3ffffff;
      carry = r >>> 26;
    }
    for (; carry !== 0 && i < a.length; i++) {
      r = (a.words[i] | 0) + carry;
      this.words[i] = r & 0x3ffffff;
      carry = r >>> 26;
    }

    this.length = a.length;
    if (carry !== 0) {
      this.words[this.length] = carry;
      this.length++;
    // Copy the rest of the words
    } else if (a !== this) {
      for (; i < a.length; i++) {
        this.words[i] = a.words[i];
      }
    }

    return this;
  };

  // Add `num` to `this`
  BN.prototype.add = function add (num) {
    var res;
    if (num.negative !== 0 && this.negative === 0) {
      num.negative = 0;
      res = this.sub(num);
      num.negative ^= 1;
      return res;
    } else if (num.negative === 0 && this.negative !== 0) {
      this.negative = 0;
      res = num.sub(this);
      this.negative = 1;
      return res;
    }

    if (this.length > num.length) return this.clone().iadd(num);

    return num.clone().iadd(this);
  };

  // Subtract `num` from `this` in-place
  BN.prototype.isub = function isub (num) {
    // this - (-num) = this + num
    if (num.negative !== 0) {
      num.negative = 0;
      var r = this.iadd(num);
      num.negative = 1;
      return r._normSign();

    // -this - num = -(this + num)
    } else if (this.negative !== 0) {
      this.negative = 0;
      this.iadd(num);
      this.negative = 1;
      return this._normSign();
    }

    // At this point both numbers are positive
    var cmp = this.cmp(num);

    // Optimization - zeroify
    if (cmp === 0) {
      this.negative = 0;
      this.length = 1;
      this.words[0] = 0;
      return this;
    }

    // a > b
    var a, b;
    if (cmp > 0) {
      a = this;
      b = num;
    } else {
      a = num;
      b = this;
    }

    var carry = 0;
    for (var i = 0; i < b.length; i++) {
      r = (a.words[i] | 0) - (b.words[i] | 0) + carry;
      carry = r >> 26;
      this.words[i] = r & 0x3ffffff;
    }
    for (; carry !== 0 && i < a.length; i++) {
      r = (a.words[i] | 0) + carry;
      carry = r >> 26;
      this.words[i] = r & 0x3ffffff;
    }

    // Copy rest of the words
    if (carry === 0 && i < a.length && a !== this) {
      for (; i < a.length; i++) {
        this.words[i] = a.words[i];
      }
    }

    this.length = Math.max(this.length, i);

    if (a !== this) {
      this.negative = 1;
    }

    return this.strip();
  };

  // Subtract `num` from `this`
  BN.prototype.sub = function sub (num) {
    return this.clone().isub(num);
  };

  function smallMulTo (self, num, out) {
    out.negative = num.negative ^ self.negative;
    var len = (self.length + num.length) | 0;
    out.length = len;
    len = (len - 1) | 0;

    // Peel one iteration (compiler can't do it, because of code complexity)
    var a = self.words[0] | 0;
    var b = num.words[0] | 0;
    var r = a * b;

    var lo = r & 0x3ffffff;
    var carry = (r / 0x4000000) | 0;
    out.words[0] = lo;

    for (var k = 1; k < len; k++) {
      // Sum all words with the same `i + j = k` and accumulate `ncarry`,
      // note that ncarry could be >= 0x3ffffff
      var ncarry = carry >>> 26;
      var rword = carry & 0x3ffffff;
      var maxJ = Math.min(k, num.length - 1);
      for (var j = Math.max(0, k - self.length + 1); j <= maxJ; j++) {
        var i = (k - j) | 0;
        a = self.words[i] | 0;
        b = num.words[j] | 0;
        r = a * b + rword;
        ncarry += (r / 0x4000000) | 0;
        rword = r & 0x3ffffff;
      }
      out.words[k] = rword | 0;
      carry = ncarry | 0;
    }
    if (carry !== 0) {
      out.words[k] = carry | 0;
    } else {
      out.length--;
    }

    return out.strip();
  }

  // TODO(indutny): it may be reasonable to omit it for users who don't need
  // to work with 256-bit numbers, otherwise it gives 20% improvement for 256-bit
  // multiplication (like elliptic secp256k1).
  var comb10MulTo = function comb10MulTo (self, num, out) {
    var a = self.words;
    var b = num.words;
    var o = out.words;
    var c = 0;
    var lo;
    var mid;
    var hi;
    var a0 = a[0] | 0;
    var al0 = a0 & 0x1fff;
    var ah0 = a0 >>> 13;
    var a1 = a[1] | 0;
    var al1 = a1 & 0x1fff;
    var ah1 = a1 >>> 13;
    var a2 = a[2] | 0;
    var al2 = a2 & 0x1fff;
    var ah2 = a2 >>> 13;
    var a3 = a[3] | 0;
    var al3 = a3 & 0x1fff;
    var ah3 = a3 >>> 13;
    var a4 = a[4] | 0;
    var al4 = a4 & 0x1fff;
    var ah4 = a4 >>> 13;
    var a5 = a[5] | 0;
    var al5 = a5 & 0x1fff;
    var ah5 = a5 >>> 13;
    var a6 = a[6] | 0;
    var al6 = a6 & 0x1fff;
    var ah6 = a6 >>> 13;
    var a7 = a[7] | 0;
    var al7 = a7 & 0x1fff;
    var ah7 = a7 >>> 13;
    var a8 = a[8] | 0;
    var al8 = a8 & 0x1fff;
    var ah8 = a8 >>> 13;
    var a9 = a[9] | 0;
    var al9 = a9 & 0x1fff;
    var ah9 = a9 >>> 13;
    var b0 = b[0] | 0;
    var bl0 = b0 & 0x1fff;
    var bh0 = b0 >>> 13;
    var b1 = b[1] | 0;
    var bl1 = b1 & 0x1fff;
    var bh1 = b1 >>> 13;
    var b2 = b[2] | 0;
    var bl2 = b2 & 0x1fff;
    var bh2 = b2 >>> 13;
    var b3 = b[3] | 0;
    var bl3 = b3 & 0x1fff;
    var bh3 = b3 >>> 13;
    var b4 = b[4] | 0;
    var bl4 = b4 & 0x1fff;
    var bh4 = b4 >>> 13;
    var b5 = b[5] | 0;
    var bl5 = b5 & 0x1fff;
    var bh5 = b5 >>> 13;
    var b6 = b[6] | 0;
    var bl6 = b6 & 0x1fff;
    var bh6 = b6 >>> 13;
    var b7 = b[7] | 0;
    var bl7 = b7 & 0x1fff;
    var bh7 = b7 >>> 13;
    var b8 = b[8] | 0;
    var bl8 = b8 & 0x1fff;
    var bh8 = b8 >>> 13;
    var b9 = b[9] | 0;
    var bl9 = b9 & 0x1fff;
    var bh9 = b9 >>> 13;

    out.negative = self.negative ^ num.negative;
    out.length = 19;
    /* k = 0 */
    lo = Math.imul(al0, bl0);
    mid = Math.imul(al0, bh0);
    mid = (mid + Math.imul(ah0, bl0)) | 0;
    hi = Math.imul(ah0, bh0);
    var w0 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;
    c = (((hi + (mid >>> 13)) | 0) + (w0 >>> 26)) | 0;
    w0 &= 0x3ffffff;
    /* k = 1 */
    lo = Math.imul(al1, bl0);
    mid = Math.imul(al1, bh0);
    mid = (mid + Math.imul(ah1, bl0)) | 0;
    hi = Math.imul(ah1, bh0);
    lo = (lo + Math.imul(al0, bl1)) | 0;
    mid = (mid + Math.imul(al0, bh1)) | 0;
    mid = (mid + Math.imul(ah0, bl1)) | 0;
    hi = (hi + Math.imul(ah0, bh1)) | 0;
    var w1 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;
    c = (((hi + (mid >>> 13)) | 0) + (w1 >>> 26)) | 0;
    w1 &= 0x3ffffff;
    /* k = 2 */
    lo = Math.imul(al2, bl0);
    mid = Math.imul(al2, bh0);
    mid = (mid + Math.imul(ah2, bl0)) | 0;
    hi = Math.imul(ah2, bh0);
    lo = (lo + Math.imul(al1, bl1)) | 0;
    mid = (mid + Math.imul(al1, bh1)) | 0;
    mid = (mid + Math.imul(ah1, bl1)) | 0;
    hi = (hi + Math.imul(ah1, bh1)) | 0;
    lo = (lo + Math.imul(al0, bl2)) | 0;
    mid = (mid + Math.imul(al0, bh2)) | 0;
    mid = (mid + Math.imul(ah0, bl2)) | 0;
    hi = (hi + Math.imul(ah0, bh2)) | 0;
    var w2 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;
    c = (((hi + (mid >>> 13)) | 0) + (w2 >>> 26)) | 0;
    w2 &= 0x3ffffff;
    /* k = 3 */
    lo = Math.imul(al3, bl0);
    mid = Math.imul(al3, bh0);
    mid = (mid + Math.imul(ah3, bl0)) | 0;
    hi = Math.imul(ah3, bh0);
    lo = (lo + Math.imul(al2, bl1)) | 0;
    mid = (mid + Math.imul(al2, bh1)) | 0;
    mid = (mid + Math.imul(ah2, bl1)) | 0;
    hi = (hi + Math.imul(ah2, bh1)) | 0;
    lo = (lo + Math.imul(al1, bl2)) | 0;
    mid = (mid + Math.imul(al1, bh2)) | 0;
    mid = (mid + Math.imul(ah1, bl2)) | 0;
    hi = (hi + Math.imul(ah1, bh2)) | 0;
    lo = (lo + Math.imul(al0, bl3)) | 0;
    mid = (mid + Math.imul(al0, bh3)) | 0;
    mid = (mid + Math.imul(ah0, bl3)) | 0;
    hi = (hi + Math.imul(ah0, bh3)) | 0;
    var w3 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;
    c = (((hi + (mid >>> 13)) | 0) + (w3 >>> 26)) | 0;
    w3 &= 0x3ffffff;
    /* k = 4 */
    lo = Math.imul(al4, bl0);
    mid = Math.imul(al4, bh0);
    mid = (mid + Math.imul(ah4, bl0)) | 0;
    hi = Math.imul(ah4, bh0);
    lo = (lo + Math.imul(al3, bl1)) | 0;
    mid = (mid + Math.imul(al3, bh1)) | 0;
    mid = (mid + Math.imul(ah3, bl1)) | 0;
    hi = (hi + Math.imul(ah3, bh1)) | 0;
    lo = (lo + Math.imul(al2, bl2)) | 0;
    mid = (mid + Math.imul(al2, bh2)) | 0;
    mid = (mid + Math.imul(ah2, bl2)) | 0;
    hi = (hi + Math.imul(ah2, bh2)) | 0;
    lo = (lo + Math.imul(al1, bl3)) | 0;
    mid = (mid + Math.imul(al1, bh3)) | 0;
    mid = (mid + Math.imul(ah1, bl3)) | 0;
    hi = (hi + Math.imul(ah1, bh3)) | 0;
    lo = (lo + Math.imul(al0, bl4)) | 0;
    mid = (mid + Math.imul(al0, bh4)) | 0;
    mid = (mid + Math.imul(ah0, bl4)) | 0;
    hi = (hi + Math.imul(ah0, bh4)) | 0;
    var w4 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;
    c = (((hi + (mid >>> 13)) | 0) + (w4 >>> 26)) | 0;
    w4 &= 0x3ffffff;
    /* k = 5 */
    lo = Math.imul(al5, bl0);
    mid = Math.imul(al5, bh0);
    mid = (mid + Math.imul(ah5, bl0)) | 0;
    hi = Math.imul(ah5, bh0);
    lo = (lo + Math.imul(al4, bl1)) | 0;
    mid = (mid + Math.imul(al4, bh1)) | 0;
    mid = (mid + Math.imul(ah4, bl1)) | 0;
    hi = (hi + Math.imul(ah4, bh1)) | 0;
    lo = (lo + Math.imul(al3, bl2)) | 0;
    mid = (mid + Math.imul(al3, bh2)) | 0;
    mid = (mid + Math.imul(ah3, bl2)) | 0;
    hi = (hi + Math.imul(ah3, bh2)) | 0;
    lo = (lo + Math.imul(al2, bl3)) | 0;
    mid = (mid + Math.imul(al2, bh3)) | 0;
    mid = (mid + Math.imul(ah2, bl3)) | 0;
    hi = (hi + Math.imul(ah2, bh3)) | 0;
    lo = (lo + Math.imul(al1, bl4)) | 0;
    mid = (mid + Math.imul(al1, bh4)) | 0;
    mid = (mid + Math.imul(ah1, bl4)) | 0;
    hi = (hi + Math.imul(ah1, bh4)) | 0;
    lo = (lo + Math.imul(al0, bl5)) | 0;
    mid = (mid + Math.imul(al0, bh5)) | 0;
    mid = (mid + Math.imul(ah0, bl5)) | 0;
    hi = (hi + Math.imul(ah0, bh5)) | 0;
    var w5 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;
    c = (((hi + (mid >>> 13)) | 0) + (w5 >>> 26)) | 0;
    w5 &= 0x3ffffff;
    /* k = 6 */
    lo = Math.imul(al6, bl0);
    mid = Math.imul(al6, bh0);
    mid = (mid + Math.imul(ah6, bl0)) | 0;
    hi = Math.imul(ah6, bh0);
    lo = (lo + Math.imul(al5, bl1)) | 0;
    mid = (mid + Math.imul(al5, bh1)) | 0;
    mid = (mid + Math.imul(ah5, bl1)) | 0;
    hi = (hi + Math.imul(ah5, bh1)) | 0;
    lo = (lo + Math.imul(al4, bl2)) | 0;
    mid = (mid + Math.imul(al4, bh2)) | 0;
    mid = (mid + Math.imul(ah4, bl2)) | 0;
    hi = (hi + Math.imul(ah4, bh2)) | 0;
    lo = (lo + Math.imul(al3, bl3)) | 0;
    mid = (mid + Math.imul(al3, bh3)) | 0;
    mid = (mid + Math.imul(ah3, bl3)) | 0;
    hi = (hi + Math.imul(ah3, bh3)) | 0;
    lo = (lo + Math.imul(al2, bl4)) | 0;
    mid = (mid + Math.imul(al2, bh4)) | 0;
    mid = (mid + Math.imul(ah2, bl4)) | 0;
    hi = (hi + Math.imul(ah2, bh4)) | 0;
    lo = (lo + Math.imul(al1, bl5)) | 0;
    mid = (mid + Math.imul(al1, bh5)) | 0;
    mid = (mid + Math.imul(ah1, bl5)) | 0;
    hi = (hi + Math.imul(ah1, bh5)) | 0;
    lo = (lo + Math.imul(al0, bl6)) | 0;
    mid = (mid + Math.imul(al0, bh6)) | 0;
    mid = (mid + Math.imul(ah0, bl6)) | 0;
    hi = (hi + Math.imul(ah0, bh6)) | 0;
    var w6 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;
    c = (((hi + (mid >>> 13)) | 0) + (w6 >>> 26)) | 0;
    w6 &= 0x3ffffff;
    /* k = 7 */
    lo = Math.imul(al7, bl0);
    mid = Math.imul(al7, bh0);
    mid = (mid + Math.imul(ah7, bl0)) | 0;
    hi = Math.imul(ah7, bh0);
    lo = (lo + Math.imul(al6, bl1)) | 0;
    mid = (mid + Math.imul(al6, bh1)) | 0;
    mid = (mid + Math.imul(ah6, bl1)) | 0;
    hi = (hi + Math.imul(ah6, bh1)) | 0;
    lo = (lo + Math.imul(al5, bl2)) | 0;
    mid = (mid + Math.imul(al5, bh2)) | 0;
    mid = (mid + Math.imul(ah5, bl2)) | 0;
    hi = (hi + Math.imul(ah5, bh2)) | 0;
    lo = (lo + Math.imul(al4, bl3)) | 0;
    mid = (mid + Math.imul(al4, bh3)) | 0;
    mid = (mid + Math.imul(ah4, bl3)) | 0;
    hi = (hi + Math.imul(ah4, bh3)) | 0;
    lo = (lo + Math.imul(al3, bl4)) | 0;
    mid = (mid + Math.imul(al3, bh4)) | 0;
    mid = (mid + Math.imul(ah3, bl4)) | 0;
    hi = (hi + Math.imul(ah3, bh4)) | 0;
    lo = (lo + Math.imul(al2, bl5)) | 0;
    mid = (mid + Math.imul(al2, bh5)) | 0;
    mid = (mid + Math.imul(ah2, bl5)) | 0;
    hi = (hi + Math.imul(ah2, bh5)) | 0;
    lo = (lo + Math.imul(al1, bl6)) | 0;
    mid = (mid + Math.imul(al1, bh6)) | 0;
    mid = (mid + Math.imul(ah1, bl6)) | 0;
    hi = (hi + Math.imul(ah1, bh6)) | 0;
    lo = (lo + Math.imul(al0, bl7)) | 0;
    mid = (mid + Math.imul(al0, bh7)) | 0;
    mid = (mid + Math.imul(ah0, bl7)) | 0;
    hi = (hi + Math.imul(ah0, bh7)) | 0;
    var w7 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;
    c = (((hi + (mid >>> 13)) | 0) + (w7 >>> 26)) | 0;
    w7 &= 0x3ffffff;
    /* k = 8 */
    lo = Math.imul(al8, bl0);
    mid = Math.imul(al8, bh0);
    mid = (mid + Math.imul(ah8, bl0)) | 0;
    hi = Math.imul(ah8, bh0);
    lo = (lo + Math.imul(al7, bl1)) | 0;
    mid = (mid + Math.imul(al7, bh1)) | 0;
    mid = (mid + Math.imul(ah7, bl1)) | 0;
    hi = (hi + Math.imul(ah7, bh1)) | 0;
    lo = (lo + Math.imul(al6, bl2)) | 0;
    mid = (mid + Math.imul(al6, bh2)) | 0;
    mid = (mid + Math.imul(ah6, bl2)) | 0;
    hi = (hi + Math.imul(ah6, bh2)) | 0;
    lo = (lo + Math.imul(al5, bl3)) | 0;
    mid = (mid + Math.imul(al5, bh3)) | 0;
    mid = (mid + Math.imul(ah5, bl3)) | 0;
    hi = (hi + Math.imul(ah5, bh3)) | 0;
    lo = (lo + Math.imul(al4, bl4)) | 0;
    mid = (mid + Math.imul(al4, bh4)) | 0;
    mid = (mid + Math.imul(ah4, bl4)) | 0;
    hi = (hi + Math.imul(ah4, bh4)) | 0;
    lo = (lo + Math.imul(al3, bl5)) | 0;
    mid = (mid + Math.imul(al3, bh5)) | 0;
    mid = (mid + Math.imul(ah3, bl5)) | 0;
    hi = (hi + Math.imul(ah3, bh5)) | 0;
    lo = (lo + Math.imul(al2, bl6)) | 0;
    mid = (mid + Math.imul(al2, bh6)) | 0;
    mid = (mid + Math.imul(ah2, bl6)) | 0;
    hi = (hi + Math.imul(ah2, bh6)) | 0;
    lo = (lo + Math.imul(al1, bl7)) | 0;
    mid = (mid + Math.imul(al1, bh7)) | 0;
    mid = (mid + Math.imul(ah1, bl7)) | 0;
    hi = (hi + Math.imul(ah1, bh7)) | 0;
    lo = (lo + Math.imul(al0, bl8)) | 0;
    mid = (mid + Math.imul(al0, bh8)) | 0;
    mid = (mid + Math.imul(ah0, bl8)) | 0;
    hi = (hi + Math.imul(ah0, bh8)) | 0;
    var w8 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;
    c = (((hi + (mid >>> 13)) | 0) + (w8 >>> 26)) | 0;
    w8 &= 0x3ffffff;
    /* k = 9 */
    lo = Math.imul(al9, bl0);
    mid = Math.imul(al9, bh0);
    mid = (mid + Math.imul(ah9, bl0)) | 0;
    hi = Math.imul(ah9, bh0);
    lo = (lo + Math.imul(al8, bl1)) | 0;
    mid = (mid + Math.imul(al8, bh1)) | 0;
    mid = (mid + Math.imul(ah8, bl1)) | 0;
    hi = (hi + Math.imul(ah8, bh1)) | 0;
    lo = (lo + Math.imul(al7, bl2)) | 0;
    mid = (mid + Math.imul(al7, bh2)) | 0;
    mid = (mid + Math.imul(ah7, bl2)) | 0;
    hi = (hi + Math.imul(ah7, bh2)) | 0;
    lo = (lo + Math.imul(al6, bl3)) | 0;
    mid = (mid + Math.imul(al6, bh3)) | 0;
    mid = (mid + Math.imul(ah6, bl3)) | 0;
    hi = (hi + Math.imul(ah6, bh3)) | 0;
    lo = (lo + Math.imul(al5, bl4)) | 0;
    mid = (mid + Math.imul(al5, bh4)) | 0;
    mid = (mid + Math.imul(ah5, bl4)) | 0;
    hi = (hi + Math.imul(ah5, bh4)) | 0;
    lo = (lo + Math.imul(al4, bl5)) | 0;
    mid = (mid + Math.imul(al4, bh5)) | 0;
    mid = (mid + Math.imul(ah4, bl5)) | 0;
    hi = (hi + Math.imul(ah4, bh5)) | 0;
    lo = (lo + Math.imul(al3, bl6)) | 0;
    mid = (mid + Math.imul(al3, bh6)) | 0;
    mid = (mid + Math.imul(ah3, bl6)) | 0;
    hi = (hi + Math.imul(ah3, bh6)) | 0;
    lo = (lo + Math.imul(al2, bl7)) | 0;
    mid = (mid + Math.imul(al2, bh7)) | 0;
    mid = (mid + Math.imul(ah2, bl7)) | 0;
    hi = (hi + Math.imul(ah2, bh7)) | 0;
    lo = (lo + Math.imul(al1, bl8)) | 0;
    mid = (mid + Math.imul(al1, bh8)) | 0;
    mid = (mid + Math.imul(ah1, bl8)) | 0;
    hi = (hi + Math.imul(ah1, bh8)) | 0;
    lo = (lo + Math.imul(al0, bl9)) | 0;
    mid = (mid + Math.imul(al0, bh9)) | 0;
    mid = (mid + Math.imul(ah0, bl9)) | 0;
    hi = (hi + Math.imul(ah0, bh9)) | 0;
    var w9 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;
    c = (((hi + (mid >>> 13)) | 0) + (w9 >>> 26)) | 0;
    w9 &= 0x3ffffff;
    /* k = 10 */
    lo = Math.imul(al9, bl1);
    mid = Math.imul(al9, bh1);
    mid = (mid + Math.imul(ah9, bl1)) | 0;
    hi = Math.imul(ah9, bh1);
    lo = (lo + Math.imul(al8, bl2)) | 0;
    mid = (mid + Math.imul(al8, bh2)) | 0;
    mid = (mid + Math.imul(ah8, bl2)) | 0;
    hi = (hi + Math.imul(ah8, bh2)) | 0;
    lo = (lo + Math.imul(al7, bl3)) | 0;
    mid = (mid + Math.imul(al7, bh3)) | 0;
    mid = (mid + Math.imul(ah7, bl3)) | 0;
    hi = (hi + Math.imul(ah7, bh3)) | 0;
    lo = (lo + Math.imul(al6, bl4)) | 0;
    mid = (mid + Math.imul(al6, bh4)) | 0;
    mid = (mid + Math.imul(ah6, bl4)) | 0;
    hi = (hi + Math.imul(ah6, bh4)) | 0;
    lo = (lo + Math.imul(al5, bl5)) | 0;
    mid = (mid + Math.imul(al5, bh5)) | 0;
    mid = (mid + Math.imul(ah5, bl5)) | 0;
    hi = (hi + Math.imul(ah5, bh5)) | 0;
    lo = (lo + Math.imul(al4, bl6)) | 0;
    mid = (mid + Math.imul(al4, bh6)) | 0;
    mid = (mid + Math.imul(ah4, bl6)) | 0;
    hi = (hi + Math.imul(ah4, bh6)) | 0;
    lo = (lo + Math.imul(al3, bl7)) | 0;
    mid = (mid + Math.imul(al3, bh7)) | 0;
    mid = (mid + Math.imul(ah3, bl7)) | 0;
    hi = (hi + Math.imul(ah3, bh7)) | 0;
    lo = (lo + Math.imul(al2, bl8)) | 0;
    mid = (mid + Math.imul(al2, bh8)) | 0;
    mid = (mid + Math.imul(ah2, bl8)) | 0;
    hi = (hi + Math.imul(ah2, bh8)) | 0;
    lo = (lo + Math.imul(al1, bl9)) | 0;
    mid = (mid + Math.imul(al1, bh9)) | 0;
    mid = (mid + Math.imul(ah1, bl9)) | 0;
    hi = (hi + Math.imul(ah1, bh9)) | 0;
    var w10 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;
    c = (((hi + (mid >>> 13)) | 0) + (w10 >>> 26)) | 0;
    w10 &= 0x3ffffff;
    /* k = 11 */
    lo = Math.imul(al9, bl2);
    mid = Math.imul(al9, bh2);
    mid = (mid + Math.imul(ah9, bl2)) | 0;
    hi = Math.imul(ah9, bh2);
    lo = (lo + Math.imul(al8, bl3)) | 0;
    mid = (mid + Math.imul(al8, bh3)) | 0;
    mid = (mid + Math.imul(ah8, bl3)) | 0;
    hi = (hi + Math.imul(ah8, bh3)) | 0;
    lo = (lo + Math.imul(al7, bl4)) | 0;
    mid = (mid + Math.imul(al7, bh4)) | 0;
    mid = (mid + Math.imul(ah7, bl4)) | 0;
    hi = (hi + Math.imul(ah7, bh4)) | 0;
    lo = (lo + Math.imul(al6, bl5)) | 0;
    mid = (mid + Math.imul(al6, bh5)) | 0;
    mid = (mid + Math.imul(ah6, bl5)) | 0;
    hi = (hi + Math.imul(ah6, bh5)) | 0;
    lo = (lo + Math.imul(al5, bl6)) | 0;
    mid = (mid + Math.imul(al5, bh6)) | 0;
    mid = (mid + Math.imul(ah5, bl6)) | 0;
    hi = (hi + Math.imul(ah5, bh6)) | 0;
    lo = (lo + Math.imul(al4, bl7)) | 0;
    mid = (mid + Math.imul(al4, bh7)) | 0;
    mid = (mid + Math.imul(ah4, bl7)) | 0;
    hi = (hi + Math.imul(ah4, bh7)) | 0;
    lo = (lo + Math.imul(al3, bl8)) | 0;
    mid = (mid + Math.imul(al3, bh8)) | 0;
    mid = (mid + Math.imul(ah3, bl8)) | 0;
    hi = (hi + Math.imul(ah3, bh8)) | 0;
    lo = (lo + Math.imul(al2, bl9)) | 0;
    mid = (mid + Math.imul(al2, bh9)) | 0;
    mid = (mid + Math.imul(ah2, bl9)) | 0;
    hi = (hi + Math.imul(ah2, bh9)) | 0;
    var w11 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;
    c = (((hi + (mid >>> 13)) | 0) + (w11 >>> 26)) | 0;
    w11 &= 0x3ffffff;
    /* k = 12 */
    lo = Math.imul(al9, bl3);
    mid = Math.imul(al9, bh3);
    mid = (mid + Math.imul(ah9, bl3)) | 0;
    hi = Math.imul(ah9, bh3);
    lo = (lo + Math.imul(al8, bl4)) | 0;
    mid = (mid + Math.imul(al8, bh4)) | 0;
    mid = (mid + Math.imul(ah8, bl4)) | 0;
    hi = (hi + Math.imul(ah8, bh4)) | 0;
    lo = (lo + Math.imul(al7, bl5)) | 0;
    mid = (mid + Math.imul(al7, bh5)) | 0;
    mid = (mid + Math.imul(ah7, bl5)) | 0;
    hi = (hi + Math.imul(ah7, bh5)) | 0;
    lo = (lo + Math.imul(al6, bl6)) | 0;
    mid = (mid + Math.imul(al6, bh6)) | 0;
    mid = (mid + Math.imul(ah6, bl6)) | 0;
    hi = (hi + Math.imul(ah6, bh6)) | 0;
    lo = (lo + Math.imul(al5, bl7)) | 0;
    mid = (mid + Math.imul(al5, bh7)) | 0;
    mid = (mid + Math.imul(ah5, bl7)) | 0;
    hi = (hi + Math.imul(ah5, bh7)) | 0;
    lo = (lo + Math.imul(al4, bl8)) | 0;
    mid = (mid + Math.imul(al4, bh8)) | 0;
    mid = (mid + Math.imul(ah4, bl8)) | 0;
    hi = (hi + Math.imul(ah4, bh8)) | 0;
    lo = (lo + Math.imul(al3, bl9)) | 0;
    mid = (mid + Math.imul(al3, bh9)) | 0;
    mid = (mid + Math.imul(ah3, bl9)) | 0;
    hi = (hi + Math.imul(ah3, bh9)) | 0;
    var w12 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;
    c = (((hi + (mid >>> 13)) | 0) + (w12 >>> 26)) | 0;
    w12 &= 0x3ffffff;
    /* k = 13 */
    lo = Math.imul(al9, bl4);
    mid = Math.imul(al9, bh4);
    mid = (mid + Math.imul(ah9, bl4)) | 0;
    hi = Math.imul(ah9, bh4);
    lo = (lo + Math.imul(al8, bl5)) | 0;
    mid = (mid + Math.imul(al8, bh5)) | 0;
    mid = (mid + Math.imul(ah8, bl5)) | 0;
    hi = (hi + Math.imul(ah8, bh5)) | 0;
    lo = (lo + Math.imul(al7, bl6)) | 0;
    mid = (mid + Math.imul(al7, bh6)) | 0;
    mid = (mid + Math.imul(ah7, bl6)) | 0;
    hi = (hi + Math.imul(ah7, bh6)) | 0;
    lo = (lo + Math.imul(al6, bl7)) | 0;
    mid = (mid + Math.imul(al6, bh7)) | 0;
    mid = (mid + Math.imul(ah6, bl7)) | 0;
    hi = (hi + Math.imul(ah6, bh7)) | 0;
    lo = (lo + Math.imul(al5, bl8)) | 0;
    mid = (mid + Math.imul(al5, bh8)) | 0;
    mid = (mid + Math.imul(ah5, bl8)) | 0;
    hi = (hi + Math.imul(ah5, bh8)) | 0;
    lo = (lo + Math.imul(al4, bl9)) | 0;
    mid = (mid + Math.imul(al4, bh9)) | 0;
    mid = (mid + Math.imul(ah4, bl9)) | 0;
    hi = (hi + Math.imul(ah4, bh9)) | 0;
    var w13 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;
    c = (((hi + (mid >>> 13)) | 0) + (w13 >>> 26)) | 0;
    w13 &= 0x3ffffff;
    /* k = 14 */
    lo = Math.imul(al9, bl5);
    mid = Math.imul(al9, bh5);
    mid = (mid + Math.imul(ah9, bl5)) | 0;
    hi = Math.imul(ah9, bh5);
    lo = (lo + Math.imul(al8, bl6)) | 0;
    mid = (mid + Math.imul(al8, bh6)) | 0;
    mid = (mid + Math.imul(ah8, bl6)) | 0;
    hi = (hi + Math.imul(ah8, bh6)) | 0;
    lo = (lo + Math.imul(al7, bl7)) | 0;
    mid = (mid + Math.imul(al7, bh7)) | 0;
    mid = (mid + Math.imul(ah7, bl7)) | 0;
    hi = (hi + Math.imul(ah7, bh7)) | 0;
    lo = (lo + Math.imul(al6, bl8)) | 0;
    mid = (mid + Math.imul(al6, bh8)) | 0;
    mid = (mid + Math.imul(ah6, bl8)) | 0;
    hi = (hi + Math.imul(ah6, bh8)) | 0;
    lo = (lo + Math.imul(al5, bl9)) | 0;
    mid = (mid + Math.imul(al5, bh9)) | 0;
    mid = (mid + Math.imul(ah5, bl9)) | 0;
    hi = (hi + Math.imul(ah5, bh9)) | 0;
    var w14 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;
    c = (((hi + (mid >>> 13)) | 0) + (w14 >>> 26)) | 0;
    w14 &= 0x3ffffff;
    /* k = 15 */
    lo = Math.imul(al9, bl6);
    mid = Math.imul(al9, bh6);
    mid = (mid + Math.imul(ah9, bl6)) | 0;
    hi = Math.imul(ah9, bh6);
    lo = (lo + Math.imul(al8, bl7)) | 0;
    mid = (mid + Math.imul(al8, bh7)) | 0;
    mid = (mid + Math.imul(ah8, bl7)) | 0;
    hi = (hi + Math.imul(ah8, bh7)) | 0;
    lo = (lo + Math.imul(al7, bl8)) | 0;
    mid = (mid + Math.imul(al7, bh8)) | 0;
    mid = (mid + Math.imul(ah7, bl8)) | 0;
    hi = (hi + Math.imul(ah7, bh8)) | 0;
    lo = (lo + Math.imul(al6, bl9)) | 0;
    mid = (mid + Math.imul(al6, bh9)) | 0;
    mid = (mid + Math.imul(ah6, bl9)) | 0;
    hi = (hi + Math.imul(ah6, bh9)) | 0;
    var w15 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;
    c = (((hi + (mid >>> 13)) | 0) + (w15 >>> 26)) | 0;
    w15 &= 0x3ffffff;
    /* k = 16 */
    lo = Math.imul(al9, bl7);
    mid = Math.imul(al9, bh7);
    mid = (mid + Math.imul(ah9, bl7)) | 0;
    hi = Math.imul(ah9, bh7);
    lo = (lo + Math.imul(al8, bl8)) | 0;
    mid = (mid + Math.imul(al8, bh8)) | 0;
    mid = (mid + Math.imul(ah8, bl8)) | 0;
    hi = (hi + Math.imul(ah8, bh8)) | 0;
    lo = (lo + Math.imul(al7, bl9)) | 0;
    mid = (mid + Math.imul(al7, bh9)) | 0;
    mid = (mid + Math.imul(ah7, bl9)) | 0;
    hi = (hi + Math.imul(ah7, bh9)) | 0;
    var w16 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;
    c = (((hi + (mid >>> 13)) | 0) + (w16 >>> 26)) | 0;
    w16 &= 0x3ffffff;
    /* k = 17 */
    lo = Math.imul(al9, bl8);
    mid = Math.imul(al9, bh8);
    mid = (mid + Math.imul(ah9, bl8)) | 0;
    hi = Math.imul(ah9, bh8);
    lo = (lo + Math.imul(al8, bl9)) | 0;
    mid = (mid + Math.imul(al8, bh9)) | 0;
    mid = (mid + Math.imul(ah8, bl9)) | 0;
    hi = (hi + Math.imul(ah8, bh9)) | 0;
    var w17 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;
    c = (((hi + (mid >>> 13)) | 0) + (w17 >>> 26)) | 0;
    w17 &= 0x3ffffff;
    /* k = 18 */
    lo = Math.imul(al9, bl9);
    mid = Math.imul(al9, bh9);
    mid = (mid + Math.imul(ah9, bl9)) | 0;
    hi = Math.imul(ah9, bh9);
    var w18 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;
    c = (((hi + (mid >>> 13)) | 0) + (w18 >>> 26)) | 0;
    w18 &= 0x3ffffff;
    o[0] = w0;
    o[1] = w1;
    o[2] = w2;
    o[3] = w3;
    o[4] = w4;
    o[5] = w5;
    o[6] = w6;
    o[7] = w7;
    o[8] = w8;
    o[9] = w9;
    o[10] = w10;
    o[11] = w11;
    o[12] = w12;
    o[13] = w13;
    o[14] = w14;
    o[15] = w15;
    o[16] = w16;
    o[17] = w17;
    o[18] = w18;
    if (c !== 0) {
      o[19] = c;
      out.length++;
    }
    return out;
  };

  // Polyfill comb
  if (!Math.imul) {
    comb10MulTo = smallMulTo;
  }

  function bigMulTo (self, num, out) {
    out.negative = num.negative ^ self.negative;
    out.length = self.length + num.length;

    var carry = 0;
    var hncarry = 0;
    for (var k = 0; k < out.length - 1; k++) {
      // Sum all words with the same `i + j = k` and accumulate `ncarry`,
      // note that ncarry could be >= 0x3ffffff
      var ncarry = hncarry;
      hncarry = 0;
      var rword = carry & 0x3ffffff;
      var maxJ = Math.min(k, num.length - 1);
      for (var j = Math.max(0, k - self.length + 1); j <= maxJ; j++) {
        var i = k - j;
        var a = self.words[i] | 0;
        var b = num.words[j] | 0;
        var r = a * b;

        var lo = r & 0x3ffffff;
        ncarry = (ncarry + ((r / 0x4000000) | 0)) | 0;
        lo = (lo + rword) | 0;
        rword = lo & 0x3ffffff;
        ncarry = (ncarry + (lo >>> 26)) | 0;

        hncarry += ncarry >>> 26;
        ncarry &= 0x3ffffff;
      }
      out.words[k] = rword;
      carry = ncarry;
      ncarry = hncarry;
    }
    if (carry !== 0) {
      out.words[k] = carry;
    } else {
      out.length--;
    }

    return out.strip();
  }

  function jumboMulTo (self, num, out) {
    var fftm = new FFTM();
    return fftm.mulp(self, num, out);
  }

  BN.prototype.mulTo = function mulTo (num, out) {
    var res;
    var len = this.length + num.length;
    if (this.length === 10 && num.length === 10) {
      res = comb10MulTo(this, num, out);
    } else if (len < 63) {
      res = smallMulTo(this, num, out);
    } else if (len < 1024) {
      res = bigMulTo(this, num, out);
    } else {
      res = jumboMulTo(this, num, out);
    }

    return res;
  };

  // Cooley-Tukey algorithm for FFT
  // slightly revisited to rely on looping instead of recursion

  function FFTM (x, y) {
    this.x = x;
    this.y = y;
  }

  FFTM.prototype.makeRBT = function makeRBT (N) {
    var t = new Array(N);
    var l = BN.prototype._countBits(N) - 1;
    for (var i = 0; i < N; i++) {
      t[i] = this.revBin(i, l, N);
    }

    return t;
  };

  // Returns binary-reversed representation of `x`
  FFTM.prototype.revBin = function revBin (x, l, N) {
    if (x === 0 || x === N - 1) return x;

    var rb = 0;
    for (var i = 0; i < l; i++) {
      rb |= (x & 1) << (l - i - 1);
      x >>= 1;
    }

    return rb;
  };

  // Performs "tweedling" phase, therefore 'emulating'
  // behaviour of the recursive algorithm
  FFTM.prototype.permute = function permute (rbt, rws, iws, rtws, itws, N) {
    for (var i = 0; i < N; i++) {
      rtws[i] = rws[rbt[i]];
      itws[i] = iws[rbt[i]];
    }
  };

  FFTM.prototype.transform = function transform (rws, iws, rtws, itws, N, rbt) {
    this.permute(rbt, rws, iws, rtws, itws, N);

    for (var s = 1; s < N; s <<= 1) {
      var l = s << 1;

      var rtwdf = Math.cos(2 * Math.PI / l);
      var itwdf = Math.sin(2 * Math.PI / l);

      for (var p = 0; p < N; p += l) {
        var rtwdf_ = rtwdf;
        var itwdf_ = itwdf;

        for (var j = 0; j < s; j++) {
          var re = rtws[p + j];
          var ie = itws[p + j];

          var ro = rtws[p + j + s];
          var io = itws[p + j + s];

          var rx = rtwdf_ * ro - itwdf_ * io;

          io = rtwdf_ * io + itwdf_ * ro;
          ro = rx;

          rtws[p + j] = re + ro;
          itws[p + j] = ie + io;

          rtws[p + j + s] = re - ro;
          itws[p + j + s] = ie - io;

          /* jshint maxdepth : false */
          if (j !== l) {
            rx = rtwdf * rtwdf_ - itwdf * itwdf_;

            itwdf_ = rtwdf * itwdf_ + itwdf * rtwdf_;
            rtwdf_ = rx;
          }
        }
      }
    }
  };

  FFTM.prototype.guessLen13b = function guessLen13b (n, m) {
    var N = Math.max(m, n) | 1;
    var odd = N & 1;
    var i = 0;
    for (N = N / 2 | 0; N; N = N >>> 1) {
      i++;
    }

    return 1 << i + 1 + odd;
  };

  FFTM.prototype.conjugate = function conjugate (rws, iws, N) {
    if (N <= 1) return;

    for (var i = 0; i < N / 2; i++) {
      var t = rws[i];

      rws[i] = rws[N - i - 1];
      rws[N - i - 1] = t;

      t = iws[i];

      iws[i] = -iws[N - i - 1];
      iws[N - i - 1] = -t;
    }
  };

  FFTM.prototype.normalize13b = function normalize13b (ws, N) {
    var carry = 0;
    for (var i = 0; i < N / 2; i++) {
      var w = Math.round(ws[2 * i + 1] / N) * 0x2000 +
        Math.round(ws[2 * i] / N) +
        carry;

      ws[i] = w & 0x3ffffff;

      if (w < 0x4000000) {
        carry = 0;
      } else {
        carry = w / 0x4000000 | 0;
      }
    }

    return ws;
  };

  FFTM.prototype.convert13b = function convert13b (ws, len, rws, N) {
    var carry = 0;
    for (var i = 0; i < len; i++) {
      carry = carry + (ws[i] | 0);

      rws[2 * i] = carry & 0x1fff; carry = carry >>> 13;
      rws[2 * i + 1] = carry & 0x1fff; carry = carry >>> 13;
    }

    // Pad with zeroes
    for (i = 2 * len; i < N; ++i) {
      rws[i] = 0;
    }

    assert(carry === 0);
    assert((carry & ~0x1fff) === 0);
  };

  FFTM.prototype.stub = function stub (N) {
    var ph = new Array(N);
    for (var i = 0; i < N; i++) {
      ph[i] = 0;
    }

    return ph;
  };

  FFTM.prototype.mulp = function mulp (x, y, out) {
    var N = 2 * this.guessLen13b(x.length, y.length);

    var rbt = this.makeRBT(N);

    var _ = this.stub(N);

    var rws = new Array(N);
    var rwst = new Array(N);
    var iwst = new Array(N);

    var nrws = new Array(N);
    var nrwst = new Array(N);
    var niwst = new Array(N);

    var rmws = out.words;
    rmws.length = N;

    this.convert13b(x.words, x.length, rws, N);
    this.convert13b(y.words, y.length, nrws, N);

    this.transform(rws, _, rwst, iwst, N, rbt);
    this.transform(nrws, _, nrwst, niwst, N, rbt);

    for (var i = 0; i < N; i++) {
      var rx = rwst[i] * nrwst[i] - iwst[i] * niwst[i];
      iwst[i] = rwst[i] * niwst[i] + iwst[i] * nrwst[i];
      rwst[i] = rx;
    }

    this.conjugate(rwst, iwst, N);
    this.transform(rwst, iwst, rmws, _, N, rbt);
    this.conjugate(rmws, _, N);
    this.normalize13b(rmws, N);

    out.negative = x.negative ^ y.negative;
    out.length = x.length + y.length;
    return out.strip();
  };

  // Multiply `this` by `num`
  BN.prototype.mul = function mul (num) {
    var out = new BN(null);
    out.words = new Array(this.length + num.length);
    return this.mulTo(num, out);
  };

  // Multiply employing FFT
  BN.prototype.mulf = function mulf (num) {
    var out = new BN(null);
    out.words = new Array(this.length + num.length);
    return jumboMulTo(this, num, out);
  };

  // In-place Multiplication
  BN.prototype.imul = function imul (num) {
    return this.clone().mulTo(num, this);
  };

  BN.prototype.imuln = function imuln (num) {
    assert(typeof num === 'number');
    assert(num < 0x4000000);

    // Carry
    var carry = 0;
    for (var i = 0; i < this.length; i++) {
      var w = (this.words[i] | 0) * num;
      var lo = (w & 0x3ffffff) + (carry & 0x3ffffff);
      carry >>= 26;
      carry += (w / 0x4000000) | 0;
      // NOTE: lo is 27bit maximum
      carry += lo >>> 26;
      this.words[i] = lo & 0x3ffffff;
    }

    if (carry !== 0) {
      this.words[i] = carry;
      this.length++;
    }

    return this;
  };

  BN.prototype.muln = function muln (num) {
    return this.clone().imuln(num);
  };

  // `this` * `this`
  BN.prototype.sqr = function sqr () {
    return this.mul(this);
  };

  // `this` * `this` in-place
  BN.prototype.isqr = function isqr () {
    return this.imul(this.clone());
  };

  // Math.pow(`this`, `num`)
  BN.prototype.pow = function pow (num) {
    var w = toBitArray(num);
    if (w.length === 0) return new BN(1);

    // Skip leading zeroes
    var res = this;
    for (var i = 0; i < w.length; i++, res = res.sqr()) {
      if (w[i] !== 0) break;
    }

    if (++i < w.length) {
      for (var q = res.sqr(); i < w.length; i++, q = q.sqr()) {
        if (w[i] === 0) continue;

        res = res.mul(q);
      }
    }

    return res;
  };

  // Shift-left in-place
  BN.prototype.iushln = function iushln (bits) {
    assert(typeof bits === 'number' && bits >= 0);
    var r = bits % 26;
    var s = (bits - r) / 26;
    var carryMask = (0x3ffffff >>> (26 - r)) << (26 - r);
    var i;

    if (r !== 0) {
      var carry = 0;

      for (i = 0; i < this.length; i++) {
        var newCarry = this.words[i] & carryMask;
        var c = ((this.words[i] | 0) - newCarry) << r;
        this.words[i] = c | carry;
        carry = newCarry >>> (26 - r);
      }

      if (carry) {
        this.words[i] = carry;
        this.length++;
      }
    }

    if (s !== 0) {
      for (i = this.length - 1; i >= 0; i--) {
        this.words[i + s] = this.words[i];
      }

      for (i = 0; i < s; i++) {
        this.words[i] = 0;
      }

      this.length += s;
    }

    return this.strip();
  };

  BN.prototype.ishln = function ishln (bits) {
    // TODO(indutny): implement me
    assert(this.negative === 0);
    return this.iushln(bits);
  };

  // Shift-right in-place
  // NOTE: `hint` is a lowest bit before trailing zeroes
  // NOTE: if `extended` is present - it will be filled with destroyed bits
  BN.prototype.iushrn = function iushrn (bits, hint, extended) {
    assert(typeof bits === 'number' && bits >= 0);
    var h;
    if (hint) {
      h = (hint - (hint % 26)) / 26;
    } else {
      h = 0;
    }

    var r = bits % 26;
    var s = Math.min((bits - r) / 26, this.length);
    var mask = 0x3ffffff ^ ((0x3ffffff >>> r) << r);
    var maskedWords = extended;

    h -= s;
    h = Math.max(0, h);

    // Extended mode, copy masked part
    if (maskedWords) {
      for (var i = 0; i < s; i++) {
        maskedWords.words[i] = this.words[i];
      }
      maskedWords.length = s;
    }

    if (s === 0) {
      // No-op, we should not move anything at all
    } else if (this.length > s) {
      this.length -= s;
      for (i = 0; i < this.length; i++) {
        this.words[i] = this.words[i + s];
      }
    } else {
      this.words[0] = 0;
      this.length = 1;
    }

    var carry = 0;
    for (i = this.length - 1; i >= 0 && (carry !== 0 || i >= h); i--) {
      var word = this.words[i] | 0;
      this.words[i] = (carry << (26 - r)) | (word >>> r);
      carry = word & mask;
    }

    // Push carried bits as a mask
    if (maskedWords && carry !== 0) {
      maskedWords.words[maskedWords.length++] = carry;
    }

    if (this.length === 0) {
      this.words[0] = 0;
      this.length = 1;
    }

    return this.strip();
  };

  BN.prototype.ishrn = function ishrn (bits, hint, extended) {
    // TODO(indutny): implement me
    assert(this.negative === 0);
    return this.iushrn(bits, hint, extended);
  };

  // Shift-left
  BN.prototype.shln = function shln (bits) {
    return this.clone().ishln(bits);
  };

  BN.prototype.ushln = function ushln (bits) {
    return this.clone().iushln(bits);
  };

  // Shift-right
  BN.prototype.shrn = function shrn (bits) {
    return this.clone().ishrn(bits);
  };

  BN.prototype.ushrn = function ushrn (bits) {
    return this.clone().iushrn(bits);
  };

  // Test if n bit is set
  BN.prototype.testn = function testn (bit) {
    assert(typeof bit === 'number' && bit >= 0);
    var r = bit % 26;
    var s = (bit - r) / 26;
    var q = 1 << r;

    // Fast case: bit is much higher than all existing words
    if (this.length <= s) return false;

    // Check bit and return
    var w = this.words[s];

    return !!(w & q);
  };

  // Return only lowers bits of number (in-place)
  BN.prototype.imaskn = function imaskn (bits) {
    assert(typeof bits === 'number' && bits >= 0);
    var r = bits % 26;
    var s = (bits - r) / 26;

    assert(this.negative === 0, 'imaskn works only with positive numbers');

    if (this.length <= s) {
      return this;
    }

    if (r !== 0) {
      s++;
    }
    this.length = Math.min(s, this.length);

    if (r !== 0) {
      var mask = 0x3ffffff ^ ((0x3ffffff >>> r) << r);
      this.words[this.length - 1] &= mask;
    }

    return this.strip();
  };

  // Return only lowers bits of number
  BN.prototype.maskn = function maskn (bits) {
    return this.clone().imaskn(bits);
  };

  // Add plain number `num` to `this`
  BN.prototype.iaddn = function iaddn (num) {
    assert(typeof num === 'number');
    assert(num < 0x4000000);
    if (num < 0) return this.isubn(-num);

    // Possible sign change
    if (this.negative !== 0) {
      if (this.length === 1 && (this.words[0] | 0) < num) {
        this.words[0] = num - (this.words[0] | 0);
        this.negative = 0;
        return this;
      }

      this.negative = 0;
      this.isubn(num);
      this.negative = 1;
      return this;
    }

    // Add without checks
    return this._iaddn(num);
  };

  BN.prototype._iaddn = function _iaddn (num) {
    this.words[0] += num;

    // Carry
    for (var i = 0; i < this.length && this.words[i] >= 0x4000000; i++) {
      this.words[i] -= 0x4000000;
      if (i === this.length - 1) {
        this.words[i + 1] = 1;
      } else {
        this.words[i + 1]++;
      }
    }
    this.length = Math.max(this.length, i + 1);

    return this;
  };

  // Subtract plain number `num` from `this`
  BN.prototype.isubn = function isubn (num) {
    assert(typeof num === 'number');
    assert(num < 0x4000000);
    if (num < 0) return this.iaddn(-num);

    if (this.negative !== 0) {
      this.negative = 0;
      this.iaddn(num);
      this.negative = 1;
      return this;
    }

    this.words[0] -= num;

    if (this.length === 1 && this.words[0] < 0) {
      this.words[0] = -this.words[0];
      this.negative = 1;
    } else {
      // Carry
      for (var i = 0; i < this.length && this.words[i] < 0; i++) {
        this.words[i] += 0x4000000;
        this.words[i + 1] -= 1;
      }
    }

    return this.strip();
  };

  BN.prototype.addn = function addn (num) {
    return this.clone().iaddn(num);
  };

  BN.prototype.subn = function subn (num) {
    return this.clone().isubn(num);
  };

  BN.prototype.iabs = function iabs () {
    this.negative = 0;

    return this;
  };

  BN.prototype.abs = function abs () {
    return this.clone().iabs();
  };

  BN.prototype._ishlnsubmul = function _ishlnsubmul (num, mul, shift) {
    var len = num.length + shift;
    var i;

    this._expand(len);

    var w;
    var carry = 0;
    for (i = 0; i < num.length; i++) {
      w = (this.words[i + shift] | 0) + carry;
      var right = (num.words[i] | 0) * mul;
      w -= right & 0x3ffffff;
      carry = (w >> 26) - ((right / 0x4000000) | 0);
      this.words[i + shift] = w & 0x3ffffff;
    }
    for (; i < this.length - shift; i++) {
      w = (this.words[i + shift] | 0) + carry;
      carry = w >> 26;
      this.words[i + shift] = w & 0x3ffffff;
    }

    if (carry === 0) return this.strip();

    // Subtraction overflow
    assert(carry === -1);
    carry = 0;
    for (i = 0; i < this.length; i++) {
      w = -(this.words[i] | 0) + carry;
      carry = w >> 26;
      this.words[i] = w & 0x3ffffff;
    }
    this.negative = 1;

    return this.strip();
  };

  BN.prototype._wordDiv = function _wordDiv (num, mode) {
    var shift = this.length - num.length;

    var a = this.clone();
    var b = num;

    // Normalize
    var bhi = b.words[b.length - 1] | 0;
    var bhiBits = this._countBits(bhi);
    shift = 26 - bhiBits;
    if (shift !== 0) {
      b = b.ushln(shift);
      a.iushln(shift);
      bhi = b.words[b.length - 1] | 0;
    }

    // Initialize quotient
    var m = a.length - b.length;
    var q;

    if (mode !== 'mod') {
      q = new BN(null);
      q.length = m + 1;
      q.words = new Array(q.length);
      for (var i = 0; i < q.length; i++) {
        q.words[i] = 0;
      }
    }

    var diff = a.clone()._ishlnsubmul(b, 1, m);
    if (diff.negative === 0) {
      a = diff;
      if (q) {
        q.words[m] = 1;
      }
    }

    for (var j = m - 1; j >= 0; j--) {
      var qj = (a.words[b.length + j] | 0) * 0x4000000 +
        (a.words[b.length + j - 1] | 0);

      // NOTE: (qj / bhi) is (0x3ffffff * 0x4000000 + 0x3ffffff) / 0x2000000 max
      // (0x7ffffff)
      qj = Math.min((qj / bhi) | 0, 0x3ffffff);

      a._ishlnsubmul(b, qj, j);
      while (a.negative !== 0) {
        qj--;
        a.negative = 0;
        a._ishlnsubmul(b, 1, j);
        if (!a.isZero()) {
          a.negative ^= 1;
        }
      }
      if (q) {
        q.words[j] = qj;
      }
    }
    if (q) {
      q.strip();
    }
    a.strip();

    // Denormalize
    if (mode !== 'div' && shift !== 0) {
      a.iushrn(shift);
    }

    return {
      div: q || null,
      mod: a
    };
  };

  // NOTE: 1) `mode` can be set to `mod` to request mod only,
  //       to `div` to request div only, or be absent to
  //       request both div & mod
  //       2) `positive` is true if unsigned mod is requested
  BN.prototype.divmod = function divmod (num, mode, positive) {
    assert(!num.isZero());

    if (this.isZero()) {
      return {
        div: new BN(0),
        mod: new BN(0)
      };
    }

    var div, mod, res;
    if (this.negative !== 0 && num.negative === 0) {
      res = this.neg().divmod(num, mode);

      if (mode !== 'mod') {
        div = res.div.neg();
      }

      if (mode !== 'div') {
        mod = res.mod.neg();
        if (positive && mod.negative !== 0) {
          mod.iadd(num);
        }
      }

      return {
        div: div,
        mod: mod
      };
    }

    if (this.negative === 0 && num.negative !== 0) {
      res = this.divmod(num.neg(), mode);

      if (mode !== 'mod') {
        div = res.div.neg();
      }

      return {
        div: div,
        mod: res.mod
      };
    }

    if ((this.negative & num.negative) !== 0) {
      res = this.neg().divmod(num.neg(), mode);

      if (mode !== 'div') {
        mod = res.mod.neg();
        if (positive && mod.negative !== 0) {
          mod.isub(num);
        }
      }

      return {
        div: res.div,
        mod: mod
      };
    }

    // Both numbers are positive at this point

    // Strip both numbers to approximate shift value
    if (num.length > this.length || this.cmp(num) < 0) {
      return {
        div: new BN(0),
        mod: this
      };
    }

    // Very short reduction
    if (num.length === 1) {
      if (mode === 'div') {
        return {
          div: this.divn(num.words[0]),
          mod: null
        };
      }

      if (mode === 'mod') {
        return {
          div: null,
          mod: new BN(this.modn(num.words[0]))
        };
      }

      return {
        div: this.divn(num.words[0]),
        mod: new BN(this.modn(num.words[0]))
      };
    }

    return this._wordDiv(num, mode);
  };

  // Find `this` / `num`
  BN.prototype.div = function div (num) {
    return this.divmod(num, 'div', false).div;
  };

  // Find `this` % `num`
  BN.prototype.mod = function mod (num) {
    return this.divmod(num, 'mod', false).mod;
  };

  BN.prototype.umod = function umod (num) {
    return this.divmod(num, 'mod', true).mod;
  };

  // Find Round(`this` / `num`)
  BN.prototype.divRound = function divRound (num) {
    var dm = this.divmod(num);

    // Fast case - exact division
    if (dm.mod.isZero()) return dm.div;

    var mod = dm.div.negative !== 0 ? dm.mod.isub(num) : dm.mod;

    var half = num.ushrn(1);
    var r2 = num.andln(1);
    var cmp = mod.cmp(half);

    // Round down
    if (cmp < 0 || r2 === 1 && cmp === 0) return dm.div;

    // Round up
    return dm.div.negative !== 0 ? dm.div.isubn(1) : dm.div.iaddn(1);
  };

  BN.prototype.modn = function modn (num) {
    assert(num <= 0x3ffffff);
    var p = (1 << 26) % num;

    var acc = 0;
    for (var i = this.length - 1; i >= 0; i--) {
      acc = (p * acc + (this.words[i] | 0)) % num;
    }

    return acc;
  };

  // In-place division by number
  BN.prototype.idivn = function idivn (num) {
    assert(num <= 0x3ffffff);

    var carry = 0;
    for (var i = this.length - 1; i >= 0; i--) {
      var w = (this.words[i] | 0) + carry * 0x4000000;
      this.words[i] = (w / num) | 0;
      carry = w % num;
    }

    return this.strip();
  };

  BN.prototype.divn = function divn (num) {
    return this.clone().idivn(num);
  };

  BN.prototype.egcd = function egcd (p) {
    assert(p.negative === 0);
    assert(!p.isZero());

    var x = this;
    var y = p.clone();

    if (x.negative !== 0) {
      x = x.umod(p);
    } else {
      x = x.clone();
    }

    // A * x + B * y = x
    var A = new BN(1);
    var B = new BN(0);

    // C * x + D * y = y
    var C = new BN(0);
    var D = new BN(1);

    var g = 0;

    while (x.isEven() && y.isEven()) {
      x.iushrn(1);
      y.iushrn(1);
      ++g;
    }

    var yp = y.clone();
    var xp = x.clone();

    while (!x.isZero()) {
      for (var i = 0, im = 1; (x.words[0] & im) === 0 && i < 26; ++i, im <<= 1);
      if (i > 0) {
        x.iushrn(i);
        while (i-- > 0) {
          if (A.isOdd() || B.isOdd()) {
            A.iadd(yp);
            B.isub(xp);
          }

          A.iushrn(1);
          B.iushrn(1);
        }
      }

      for (var j = 0, jm = 1; (y.words[0] & jm) === 0 && j < 26; ++j, jm <<= 1);
      if (j > 0) {
        y.iushrn(j);
        while (j-- > 0) {
          if (C.isOdd() || D.isOdd()) {
            C.iadd(yp);
            D.isub(xp);
          }

          C.iushrn(1);
          D.iushrn(1);
        }
      }

      if (x.cmp(y) >= 0) {
        x.isub(y);
        A.isub(C);
        B.isub(D);
      } else {
        y.isub(x);
        C.isub(A);
        D.isub(B);
      }
    }

    return {
      a: C,
      b: D,
      gcd: y.iushln(g)
    };
  };

  // This is reduced incarnation of the binary EEA
  // above, designated to invert members of the
  // _prime_ fields F(p) at a maximal speed
  BN.prototype._invmp = function _invmp (p) {
    assert(p.negative === 0);
    assert(!p.isZero());

    var a = this;
    var b = p.clone();

    if (a.negative !== 0) {
      a = a.umod(p);
    } else {
      a = a.clone();
    }

    var x1 = new BN(1);
    var x2 = new BN(0);

    var delta = b.clone();

    while (a.cmpn(1) > 0 && b.cmpn(1) > 0) {
      for (var i = 0, im = 1; (a.words[0] & im) === 0 && i < 26; ++i, im <<= 1);
      if (i > 0) {
        a.iushrn(i);
        while (i-- > 0) {
          if (x1.isOdd()) {
            x1.iadd(delta);
          }

          x1.iushrn(1);
        }
      }

      for (var j = 0, jm = 1; (b.words[0] & jm) === 0 && j < 26; ++j, jm <<= 1);
      if (j > 0) {
        b.iushrn(j);
        while (j-- > 0) {
          if (x2.isOdd()) {
            x2.iadd(delta);
          }

          x2.iushrn(1);
        }
      }

      if (a.cmp(b) >= 0) {
        a.isub(b);
        x1.isub(x2);
      } else {
        b.isub(a);
        x2.isub(x1);
      }
    }

    var res;
    if (a.cmpn(1) === 0) {
      res = x1;
    } else {
      res = x2;
    }

    if (res.cmpn(0) < 0) {
      res.iadd(p);
    }

    return res;
  };

  BN.prototype.gcd = function gcd (num) {
    if (this.isZero()) return num.abs();
    if (num.isZero()) return this.abs();

    var a = this.clone();
    var b = num.clone();
    a.negative = 0;
    b.negative = 0;

    // Remove common factor of two
    for (var shift = 0; a.isEven() && b.isEven(); shift++) {
      a.iushrn(1);
      b.iushrn(1);
    }

    do {
      while (a.isEven()) {
        a.iushrn(1);
      }
      while (b.isEven()) {
        b.iushrn(1);
      }

      var r = a.cmp(b);
      if (r < 0) {
        // Swap `a` and `b` to make `a` always bigger than `b`
        var t = a;
        a = b;
        b = t;
      } else if (r === 0 || b.cmpn(1) === 0) {
        break;
      }

      a.isub(b);
    } while (true);

    return b.iushln(shift);
  };

  // Invert number in the field F(num)
  BN.prototype.invm = function invm (num) {
    return this.egcd(num).a.umod(num);
  };

  BN.prototype.isEven = function isEven () {
    return (this.words[0] & 1) === 0;
  };

  BN.prototype.isOdd = function isOdd () {
    return (this.words[0] & 1) === 1;
  };

  // And first word and num
  BN.prototype.andln = function andln (num) {
    return this.words[0] & num;
  };

  // Increment at the bit position in-line
  BN.prototype.bincn = function bincn (bit) {
    assert(typeof bit === 'number');
    var r = bit % 26;
    var s = (bit - r) / 26;
    var q = 1 << r;

    // Fast case: bit is much higher than all existing words
    if (this.length <= s) {
      this._expand(s + 1);
      this.words[s] |= q;
      return this;
    }

    // Add bit and propagate, if needed
    var carry = q;
    for (var i = s; carry !== 0 && i < this.length; i++) {
      var w = this.words[i] | 0;
      w += carry;
      carry = w >>> 26;
      w &= 0x3ffffff;
      this.words[i] = w;
    }
    if (carry !== 0) {
      this.words[i] = carry;
      this.length++;
    }
    return this;
  };

  BN.prototype.isZero = function isZero () {
    return this.length === 1 && this.words[0] === 0;
  };

  BN.prototype.cmpn = function cmpn (num) {
    var negative = num < 0;

    if (this.negative !== 0 && !negative) return -1;
    if (this.negative === 0 && negative) return 1;

    this.strip();

    var res;
    if (this.length > 1) {
      res = 1;
    } else {
      if (negative) {
        num = -num;
      }

      assert(num <= 0x3ffffff, 'Number is too big');

      var w = this.words[0] | 0;
      res = w === num ? 0 : w < num ? -1 : 1;
    }
    if (this.negative !== 0) return -res | 0;
    return res;
  };

  // Compare two numbers and return:
  // 1 - if `this` > `num`
  // 0 - if `this` == `num`
  // -1 - if `this` < `num`
  BN.prototype.cmp = function cmp (num) {
    if (this.negative !== 0 && num.negative === 0) return -1;
    if (this.negative === 0 && num.negative !== 0) return 1;

    var res = this.ucmp(num);
    if (this.negative !== 0) return -res | 0;
    return res;
  };

  // Unsigned comparison
  BN.prototype.ucmp = function ucmp (num) {
    // At this point both numbers have the same sign
    if (this.length > num.length) return 1;
    if (this.length < num.length) return -1;

    var res = 0;
    for (var i = this.length - 1; i >= 0; i--) {
      var a = this.words[i] | 0;
      var b = num.words[i] | 0;

      if (a === b) continue;
      if (a < b) {
        res = -1;
      } else if (a > b) {
        res = 1;
      }
      break;
    }
    return res;
  };

  BN.prototype.gtn = function gtn (num) {
    return this.cmpn(num) === 1;
  };

  BN.prototype.gt = function gt (num) {
    return this.cmp(num) === 1;
  };

  BN.prototype.gten = function gten (num) {
    return this.cmpn(num) >= 0;
  };

  BN.prototype.gte = function gte (num) {
    return this.cmp(num) >= 0;
  };

  BN.prototype.ltn = function ltn (num) {
    return this.cmpn(num) === -1;
  };

  BN.prototype.lt = function lt (num) {
    return this.cmp(num) === -1;
  };

  BN.prototype.lten = function lten (num) {
    return this.cmpn(num) <= 0;
  };

  BN.prototype.lte = function lte (num) {
    return this.cmp(num) <= 0;
  };

  BN.prototype.eqn = function eqn (num) {
    return this.cmpn(num) === 0;
  };

  BN.prototype.eq = function eq (num) {
    return this.cmp(num) === 0;
  };

  //
  // A reduce context, could be using montgomery or something better, depending
  // on the `m` itself.
  //
  BN.red = function red (num) {
    return new Red(num);
  };

  BN.prototype.toRed = function toRed (ctx) {
    assert(!this.red, 'Already a number in reduction context');
    assert(this.negative === 0, 'red works only with positives');
    return ctx.convertTo(this)._forceRed(ctx);
  };

  BN.prototype.fromRed = function fromRed () {
    assert(this.red, 'fromRed works only with numbers in reduction context');
    return this.red.convertFrom(this);
  };

  BN.prototype._forceRed = function _forceRed (ctx) {
    this.red = ctx;
    return this;
  };

  BN.prototype.forceRed = function forceRed (ctx) {
    assert(!this.red, 'Already a number in reduction context');
    return this._forceRed(ctx);
  };

  BN.prototype.redAdd = function redAdd (num) {
    assert(this.red, 'redAdd works only with red numbers');
    return this.red.add(this, num);
  };

  BN.prototype.redIAdd = function redIAdd (num) {
    assert(this.red, 'redIAdd works only with red numbers');
    return this.red.iadd(this, num);
  };

  BN.prototype.redSub = function redSub (num) {
    assert(this.red, 'redSub works only with red numbers');
    return this.red.sub(this, num);
  };

  BN.prototype.redISub = function redISub (num) {
    assert(this.red, 'redISub works only with red numbers');
    return this.red.isub(this, num);
  };

  BN.prototype.redShl = function redShl (num) {
    assert(this.red, 'redShl works only with red numbers');
    return this.red.shl(this, num);
  };

  BN.prototype.redMul = function redMul (num) {
    assert(this.red, 'redMul works only with red numbers');
    this.red._verify2(this, num);
    return this.red.mul(this, num);
  };

  BN.prototype.redIMul = function redIMul (num) {
    assert(this.red, 'redMul works only with red numbers');
    this.red._verify2(this, num);
    return this.red.imul(this, num);
  };

  BN.prototype.redSqr = function redSqr () {
    assert(this.red, 'redSqr works only with red numbers');
    this.red._verify1(this);
    return this.red.sqr(this);
  };

  BN.prototype.redISqr = function redISqr () {
    assert(this.red, 'redISqr works only with red numbers');
    this.red._verify1(this);
    return this.red.isqr(this);
  };

  // Square root over p
  BN.prototype.redSqrt = function redSqrt () {
    assert(this.red, 'redSqrt works only with red numbers');
    this.red._verify1(this);
    return this.red.sqrt(this);
  };

  BN.prototype.redInvm = function redInvm () {
    assert(this.red, 'redInvm works only with red numbers');
    this.red._verify1(this);
    return this.red.invm(this);
  };

  // Return negative clone of `this` % `red modulo`
  BN.prototype.redNeg = function redNeg () {
    assert(this.red, 'redNeg works only with red numbers');
    this.red._verify1(this);
    return this.red.neg(this);
  };

  BN.prototype.redPow = function redPow (num) {
    assert(this.red && !num.red, 'redPow(normalNum)');
    this.red._verify1(this);
    return this.red.pow(this, num);
  };

  // Prime numbers with efficient reduction
  var primes = {
    k256: null,
    p224: null,
    p192: null,
    p25519: null
  };

  // Pseudo-Mersenne prime
  function MPrime (name, p) {
    // P = 2 ^ N - K
    this.name = name;
    this.p = new BN(p, 16);
    this.n = this.p.bitLength();
    this.k = new BN(1).iushln(this.n).isub(this.p);

    this.tmp = this._tmp();
  }

  MPrime.prototype._tmp = function _tmp () {
    var tmp = new BN(null);
    tmp.words = new Array(Math.ceil(this.n / 13));
    return tmp;
  };

  MPrime.prototype.ireduce = function ireduce (num) {
    // Assumes that `num` is less than `P^2`
    // num = HI * (2 ^ N - K) + HI * K + LO = HI * K + LO (mod P)
    var r = num;
    var rlen;

    do {
      this.split(r, this.tmp);
      r = this.imulK(r);
      r = r.iadd(this.tmp);
      rlen = r.bitLength();
    } while (rlen > this.n);

    var cmp = rlen < this.n ? -1 : r.ucmp(this.p);
    if (cmp === 0) {
      r.words[0] = 0;
      r.length = 1;
    } else if (cmp > 0) {
      r.isub(this.p);
    } else {
      r.strip();
    }

    return r;
  };

  MPrime.prototype.split = function split (input, out) {
    input.iushrn(this.n, 0, out);
  };

  MPrime.prototype.imulK = function imulK (num) {
    return num.imul(this.k);
  };

  function K256 () {
    MPrime.call(
      this,
      'k256',
      'ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff fffffffe fffffc2f');
  }
  inherits(K256, MPrime);

  K256.prototype.split = function split (input, output) {
    // 256 = 9 * 26 + 22
    var mask = 0x3fffff;

    var outLen = Math.min(input.length, 9);
    for (var i = 0; i < outLen; i++) {
      output.words[i] = input.words[i];
    }
    output.length = outLen;

    if (input.length <= 9) {
      input.words[0] = 0;
      input.length = 1;
      return;
    }

    // Shift by 9 limbs
    var prev = input.words[9];
    output.words[output.length++] = prev & mask;

    for (i = 10; i < input.length; i++) {
      var next = input.words[i] | 0;
      input.words[i - 10] = ((next & mask) << 4) | (prev >>> 22);
      prev = next;
    }
    prev >>>= 22;
    input.words[i - 10] = prev;
    if (prev === 0 && input.length > 10) {
      input.length -= 10;
    } else {
      input.length -= 9;
    }
  };

  K256.prototype.imulK = function imulK (num) {
    // K = 0x1000003d1 = [ 0x40, 0x3d1 ]
    num.words[num.length] = 0;
    num.words[num.length + 1] = 0;
    num.length += 2;

    // bounded at: 0x40 * 0x3ffffff + 0x3d0 = 0x100000390
    var lo = 0;
    for (var i = 0; i < num.length; i++) {
      var w = num.words[i] | 0;
      lo += w * 0x3d1;
      num.words[i] = lo & 0x3ffffff;
      lo = w * 0x40 + ((lo / 0x4000000) | 0);
    }

    // Fast length reduction
    if (num.words[num.length - 1] === 0) {
      num.length--;
      if (num.words[num.length - 1] === 0) {
        num.length--;
      }
    }
    return num;
  };

  function P224 () {
    MPrime.call(
      this,
      'p224',
      'ffffffff ffffffff ffffffff ffffffff 00000000 00000000 00000001');
  }
  inherits(P224, MPrime);

  function P192 () {
    MPrime.call(
      this,
      'p192',
      'ffffffff ffffffff ffffffff fffffffe ffffffff ffffffff');
  }
  inherits(P192, MPrime);

  function P25519 () {
    // 2 ^ 255 - 19
    MPrime.call(
      this,
      '25519',
      '7fffffffffffffff ffffffffffffffff ffffffffffffffff ffffffffffffffed');
  }
  inherits(P25519, MPrime);

  P25519.prototype.imulK = function imulK (num) {
    // K = 0x13
    var carry = 0;
    for (var i = 0; i < num.length; i++) {
      var hi = (num.words[i] | 0) * 0x13 + carry;
      var lo = hi & 0x3ffffff;
      hi >>>= 26;

      num.words[i] = lo;
      carry = hi;
    }
    if (carry !== 0) {
      num.words[num.length++] = carry;
    }
    return num;
  };

  // Exported mostly for testing purposes, use plain name instead
  BN._prime = function prime (name) {
    // Cached version of prime
    if (primes[name]) return primes[name];

    var prime;
    if (name === 'k256') {
      prime = new K256();
    } else if (name === 'p224') {
      prime = new P224();
    } else if (name === 'p192') {
      prime = new P192();
    } else if (name === 'p25519') {
      prime = new P25519();
    } else {
      throw new Error('Unknown prime ' + name);
    }
    primes[name] = prime;

    return prime;
  };

  //
  // Base reduction engine
  //
  function Red (m) {
    if (typeof m === 'string') {
      var prime = BN._prime(m);
      this.m = prime.p;
      this.prime = prime;
    } else {
      assert(m.gtn(1), 'modulus must be greater than 1');
      this.m = m;
      this.prime = null;
    }
  }

  Red.prototype._verify1 = function _verify1 (a) {
    assert(a.negative === 0, 'red works only with positives');
    assert(a.red, 'red works only with red numbers');
  };

  Red.prototype._verify2 = function _verify2 (a, b) {
    assert((a.negative | b.negative) === 0, 'red works only with positives');
    assert(a.red && a.red === b.red,
      'red works only with red numbers');
  };

  Red.prototype.imod = function imod (a) {
    if (this.prime) return this.prime.ireduce(a)._forceRed(this);
    return a.umod(this.m)._forceRed(this);
  };

  Red.prototype.neg = function neg (a) {
    if (a.isZero()) {
      return a.clone();
    }

    return this.m.sub(a)._forceRed(this);
  };

  Red.prototype.add = function add (a, b) {
    this._verify2(a, b);

    var res = a.add(b);
    if (res.cmp(this.m) >= 0) {
      res.isub(this.m);
    }
    return res._forceRed(this);
  };

  Red.prototype.iadd = function iadd (a, b) {
    this._verify2(a, b);

    var res = a.iadd(b);
    if (res.cmp(this.m) >= 0) {
      res.isub(this.m);
    }
    return res;
  };

  Red.prototype.sub = function sub (a, b) {
    this._verify2(a, b);

    var res = a.sub(b);
    if (res.cmpn(0) < 0) {
      res.iadd(this.m);
    }
    return res._forceRed(this);
  };

  Red.prototype.isub = function isub (a, b) {
    this._verify2(a, b);

    var res = a.isub(b);
    if (res.cmpn(0) < 0) {
      res.iadd(this.m);
    }
    return res;
  };

  Red.prototype.shl = function shl (a, num) {
    this._verify1(a);
    return this.imod(a.ushln(num));
  };

  Red.prototype.imul = function imul (a, b) {
    this._verify2(a, b);
    return this.imod(a.imul(b));
  };

  Red.prototype.mul = function mul (a, b) {
    this._verify2(a, b);
    return this.imod(a.mul(b));
  };

  Red.prototype.isqr = function isqr (a) {
    return this.imul(a, a.clone());
  };

  Red.prototype.sqr = function sqr (a) {
    return this.mul(a, a);
  };

  Red.prototype.sqrt = function sqrt (a) {
    if (a.isZero()) return a.clone();

    var mod3 = this.m.andln(3);
    assert(mod3 % 2 === 1);

    // Fast case
    if (mod3 === 3) {
      var pow = this.m.add(new BN(1)).iushrn(2);
      return this.pow(a, pow);
    }

    // Tonelli-Shanks algorithm (Totally unoptimized and slow)
    //
    // Find Q and S, that Q * 2 ^ S = (P - 1)
    var q = this.m.subn(1);
    var s = 0;
    while (!q.isZero() && q.andln(1) === 0) {
      s++;
      q.iushrn(1);
    }
    assert(!q.isZero());

    var one = new BN(1).toRed(this);
    var nOne = one.redNeg();

    // Find quadratic non-residue
    // NOTE: Max is such because of generalized Riemann hypothesis.
    var lpow = this.m.subn(1).iushrn(1);
    var z = this.m.bitLength();
    z = new BN(2 * z * z).toRed(this);

    while (this.pow(z, lpow).cmp(nOne) !== 0) {
      z.redIAdd(nOne);
    }

    var c = this.pow(z, q);
    var r = this.pow(a, q.addn(1).iushrn(1));
    var t = this.pow(a, q);
    var m = s;
    while (t.cmp(one) !== 0) {
      var tmp = t;
      for (var i = 0; tmp.cmp(one) !== 0; i++) {
        tmp = tmp.redSqr();
      }
      assert(i < m);
      var b = this.pow(c, new BN(1).iushln(m - i - 1));

      r = r.redMul(b);
      c = b.redSqr();
      t = t.redMul(c);
      m = i;
    }

    return r;
  };

  Red.prototype.invm = function invm (a) {
    var inv = a._invmp(this.m);
    if (inv.negative !== 0) {
      inv.negative = 0;
      return this.imod(inv).redNeg();
    } else {
      return this.imod(inv);
    }
  };

  Red.prototype.pow = function pow (a, num) {
    if (num.isZero()) return new BN(1).toRed(this);
    if (num.cmpn(1) === 0) return a.clone();

    var windowSize = 4;
    var wnd = new Array(1 << windowSize);
    wnd[0] = new BN(1).toRed(this);
    wnd[1] = a;
    for (var i = 2; i < wnd.length; i++) {
      wnd[i] = this.mul(wnd[i - 1], a);
    }

    var res = wnd[0];
    var current = 0;
    var currentLen = 0;
    var start = num.bitLength() % 26;
    if (start === 0) {
      start = 26;
    }

    for (i = num.length - 1; i >= 0; i--) {
      var word = num.words[i];
      for (var j = start - 1; j >= 0; j--) {
        var bit = (word >> j) & 1;
        if (res !== wnd[0]) {
          res = this.sqr(res);
        }

        if (bit === 0 && current === 0) {
          currentLen = 0;
          continue;
        }

        current <<= 1;
        current |= bit;
        currentLen++;
        if (currentLen !== windowSize && (i !== 0 || j !== 0)) continue;

        res = this.mul(res, wnd[current]);
        currentLen = 0;
        current = 0;
      }
      start = 26;
    }

    return res;
  };

  Red.prototype.convertTo = function convertTo (num) {
    var r = num.umod(this.m);

    return r === num ? r.clone() : r;
  };

  Red.prototype.convertFrom = function convertFrom (num) {
    var res = num.clone();
    res.red = null;
    return res;
  };

  //
  // Montgomery method engine
  //

  BN.mont = function mont (num) {
    return new Mont(num);
  };

  function Mont (m) {
    Red.call(this, m);

    this.shift = this.m.bitLength();
    if (this.shift % 26 !== 0) {
      this.shift += 26 - (this.shift % 26);
    }

    this.r = new BN(1).iushln(this.shift);
    this.r2 = this.imod(this.r.sqr());
    this.rinv = this.r._invmp(this.m);

    this.minv = this.rinv.mul(this.r).isubn(1).div(this.m);
    this.minv = this.minv.umod(this.r);
    this.minv = this.r.sub(this.minv);
  }
  inherits(Mont, Red);

  Mont.prototype.convertTo = function convertTo (num) {
    return this.imod(num.ushln(this.shift));
  };

  Mont.prototype.convertFrom = function convertFrom (num) {
    var r = this.imod(num.mul(this.rinv));
    r.red = null;
    return r;
  };

  Mont.prototype.imul = function imul (a, b) {
    if (a.isZero() || b.isZero()) {
      a.words[0] = 0;
      a.length = 1;
      return a;
    }

    var t = a.imul(b);
    var c = t.maskn(this.shift).mul(this.minv).imaskn(this.shift).mul(this.m);
    var u = t.isub(c).iushrn(this.shift);
    var res = u;

    if (u.cmp(this.m) >= 0) {
      res = u.isub(this.m);
    } else if (u.cmpn(0) < 0) {
      res = u.iadd(this.m);
    }

    return res._forceRed(this);
  };

  Mont.prototype.mul = function mul (a, b) {
    if (a.isZero() || b.isZero()) return new BN(0)._forceRed(this);

    var t = a.mul(b);
    var c = t.maskn(this.shift).mul(this.minv).imaskn(this.shift).mul(this.m);
    var u = t.isub(c).iushrn(this.shift);
    var res = u;
    if (u.cmp(this.m) >= 0) {
      res = u.isub(this.m);
    } else if (u.cmpn(0) < 0) {
      res = u.iadd(this.m);
    }

    return res._forceRed(this);
  };

  Mont.prototype.invm = function invm (a) {
    // (AR)^-1 * R^2 = (A^-1 * R^-1) * R^2 = A^-1 * R
    var res = this.imod(a._invmp(this.m).mul(this.r2));
    return res._forceRed(this);
  };
})(typeof module === 'undefined' || module, this);

},{"buffer":132}],131:[function(require,module,exports){
var r;

module.exports = function rand(len) {
  if (!r)
    r = new Rand(null);

  return r.generate(len);
};

function Rand(rand) {
  this.rand = rand;
}
module.exports.Rand = Rand;

Rand.prototype.generate = function generate(len) {
  return this._rand(len);
};

// Emulate crypto API using randy
Rand.prototype._rand = function _rand(n) {
  if (this.rand.getBytes)
    return this.rand.getBytes(n);

  var res = new Uint8Array(n);
  for (var i = 0; i < res.length; i++)
    res[i] = this.rand.getByte();
  return res;
};

if (typeof self === 'object') {
  if (self.crypto && self.crypto.getRandomValues) {
    // Modern browsers
    Rand.prototype._rand = function _rand(n) {
      var arr = new Uint8Array(n);
      self.crypto.getRandomValues(arr);
      return arr;
    };
  } else if (self.msCrypto && self.msCrypto.getRandomValues) {
    // IE
    Rand.prototype._rand = function _rand(n) {
      var arr = new Uint8Array(n);
      self.msCrypto.getRandomValues(arr);
      return arr;
    };

  // Safari's WebWorkers do not have `crypto`
  } else if (typeof window === 'object') {
    // Old junk
    Rand.prototype._rand = function() {
      throw new Error('Not implemented yet');
    };
  }
} else {
  // Node.js or Web worker with no crypto support
  try {
    var crypto = require('crypto');
    if (typeof crypto.randomBytes !== 'function')
      throw new Error('Not supported');

    Rand.prototype._rand = function _rand(n) {
      return crypto.randomBytes(n);
    };
  } catch (e) {
  }
}

},{"crypto":132}],132:[function(require,module,exports){

},{}],133:[function(require,module,exports){
// based on the aes implimentation in triple sec
// https://github.com/keybase/triplesec
// which is in turn based on the one from crypto-js
// https://code.google.com/p/crypto-js/

var Buffer = require('safe-buffer').Buffer

function asUInt32Array (buf) {
  if (!Buffer.isBuffer(buf)) buf = Buffer.from(buf)

  var len = (buf.length / 4) | 0
  var out = new Array(len)

  for (var i = 0; i < len; i++) {
    out[i] = buf.readUInt32BE(i * 4)
  }

  return out
}

function scrubVec (v) {
  for (var i = 0; i < v.length; v++) {
    v[i] = 0
  }
}

function cryptBlock (M, keySchedule, SUB_MIX, SBOX, nRounds) {
  var SUB_MIX0 = SUB_MIX[0]
  var SUB_MIX1 = SUB_MIX[1]
  var SUB_MIX2 = SUB_MIX[2]
  var SUB_MIX3 = SUB_MIX[3]

  var s0 = M[0] ^ keySchedule[0]
  var s1 = M[1] ^ keySchedule[1]
  var s2 = M[2] ^ keySchedule[2]
  var s3 = M[3] ^ keySchedule[3]
  var t0, t1, t2, t3
  var ksRow = 4

  for (var round = 1; round < nRounds; round++) {
    t0 = SUB_MIX0[s0 >>> 24] ^ SUB_MIX1[(s1 >>> 16) & 0xff] ^ SUB_MIX2[(s2 >>> 8) & 0xff] ^ SUB_MIX3[s3 & 0xff] ^ keySchedule[ksRow++]
    t1 = SUB_MIX0[s1 >>> 24] ^ SUB_MIX1[(s2 >>> 16) & 0xff] ^ SUB_MIX2[(s3 >>> 8) & 0xff] ^ SUB_MIX3[s0 & 0xff] ^ keySchedule[ksRow++]
    t2 = SUB_MIX0[s2 >>> 24] ^ SUB_MIX1[(s3 >>> 16) & 0xff] ^ SUB_MIX2[(s0 >>> 8) & 0xff] ^ SUB_MIX3[s1 & 0xff] ^ keySchedule[ksRow++]
    t3 = SUB_MIX0[s3 >>> 24] ^ SUB_MIX1[(s0 >>> 16) & 0xff] ^ SUB_MIX2[(s1 >>> 8) & 0xff] ^ SUB_MIX3[s2 & 0xff] ^ keySchedule[ksRow++]
    s0 = t0
    s1 = t1
    s2 = t2
    s3 = t3
  }

  t0 = ((SBOX[s0 >>> 24] << 24) | (SBOX[(s1 >>> 16) & 0xff] << 16) | (SBOX[(s2 >>> 8) & 0xff] << 8) | SBOX[s3 & 0xff]) ^ keySchedule[ksRow++]
  t1 = ((SBOX[s1 >>> 24] << 24) | (SBOX[(s2 >>> 16) & 0xff] << 16) | (SBOX[(s3 >>> 8) & 0xff] << 8) | SBOX[s0 & 0xff]) ^ keySchedule[ksRow++]
  t2 = ((SBOX[s2 >>> 24] << 24) | (SBOX[(s3 >>> 16) & 0xff] << 16) | (SBOX[(s0 >>> 8) & 0xff] << 8) | SBOX[s1 & 0xff]) ^ keySchedule[ksRow++]
  t3 = ((SBOX[s3 >>> 24] << 24) | (SBOX[(s0 >>> 16) & 0xff] << 16) | (SBOX[(s1 >>> 8) & 0xff] << 8) | SBOX[s2 & 0xff]) ^ keySchedule[ksRow++]
  t0 = t0 >>> 0
  t1 = t1 >>> 0
  t2 = t2 >>> 0
  t3 = t3 >>> 0

  return [t0, t1, t2, t3]
}

// AES constants
var RCON = [0x00, 0x01, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80, 0x1b, 0x36]
var G = (function () {
  // Compute double table
  var d = new Array(256)
  for (var j = 0; j < 256; j++) {
    if (j < 128) {
      d[j] = j << 1
    } else {
      d[j] = (j << 1) ^ 0x11b
    }
  }

  var SBOX = []
  var INV_SBOX = []
  var SUB_MIX = [[], [], [], []]
  var INV_SUB_MIX = [[], [], [], []]

  // Walk GF(2^8)
  var x = 0
  var xi = 0
  for (var i = 0; i < 256; ++i) {
    // Compute sbox
    var sx = xi ^ (xi << 1) ^ (xi << 2) ^ (xi << 3) ^ (xi << 4)
    sx = (sx >>> 8) ^ (sx & 0xff) ^ 0x63
    SBOX[x] = sx
    INV_SBOX[sx] = x

    // Compute multiplication
    var x2 = d[x]
    var x4 = d[x2]
    var x8 = d[x4]

    // Compute sub bytes, mix columns tables
    var t = (d[sx] * 0x101) ^ (sx * 0x1010100)
    SUB_MIX[0][x] = (t << 24) | (t >>> 8)
    SUB_MIX[1][x] = (t << 16) | (t >>> 16)
    SUB_MIX[2][x] = (t << 8) | (t >>> 24)
    SUB_MIX[3][x] = t

    // Compute inv sub bytes, inv mix columns tables
    t = (x8 * 0x1010101) ^ (x4 * 0x10001) ^ (x2 * 0x101) ^ (x * 0x1010100)
    INV_SUB_MIX[0][sx] = (t << 24) | (t >>> 8)
    INV_SUB_MIX[1][sx] = (t << 16) | (t >>> 16)
    INV_SUB_MIX[2][sx] = (t << 8) | (t >>> 24)
    INV_SUB_MIX[3][sx] = t

    if (x === 0) {
      x = xi = 1
    } else {
      x = x2 ^ d[d[d[x8 ^ x2]]]
      xi ^= d[d[xi]]
    }
  }

  return {
    SBOX: SBOX,
    INV_SBOX: INV_SBOX,
    SUB_MIX: SUB_MIX,
    INV_SUB_MIX: INV_SUB_MIX
  }
})()

function AES (key) {
  this._key = asUInt32Array(key)
  this._reset()
}

AES.blockSize = 4 * 4
AES.keySize = 256 / 8
AES.prototype.blockSize = AES.blockSize
AES.prototype.keySize = AES.keySize
AES.prototype._reset = function () {
  var keyWords = this._key
  var keySize = keyWords.length
  var nRounds = keySize + 6
  var ksRows = (nRounds + 1) * 4

  var keySchedule = []
  for (var k = 0; k < keySize; k++) {
    keySchedule[k] = keyWords[k]
  }

  for (k = keySize; k < ksRows; k++) {
    var t = keySchedule[k - 1]

    if (k % keySize === 0) {
      t = (t << 8) | (t >>> 24)
      t =
        (G.SBOX[t >>> 24] << 24) |
        (G.SBOX[(t >>> 16) & 0xff] << 16) |
        (G.SBOX[(t >>> 8) & 0xff] << 8) |
        (G.SBOX[t & 0xff])

      t ^= RCON[(k / keySize) | 0] << 24
    } else if (keySize > 6 && k % keySize === 4) {
      t =
        (G.SBOX[t >>> 24] << 24) |
        (G.SBOX[(t >>> 16) & 0xff] << 16) |
        (G.SBOX[(t >>> 8) & 0xff] << 8) |
        (G.SBOX[t & 0xff])
    }

    keySchedule[k] = keySchedule[k - keySize] ^ t
  }

  var invKeySchedule = []
  for (var ik = 0; ik < ksRows; ik++) {
    var ksR = ksRows - ik
    var tt = keySchedule[ksR - (ik % 4 ? 0 : 4)]

    if (ik < 4 || ksR <= 4) {
      invKeySchedule[ik] = tt
    } else {
      invKeySchedule[ik] =
        G.INV_SUB_MIX[0][G.SBOX[tt >>> 24]] ^
        G.INV_SUB_MIX[1][G.SBOX[(tt >>> 16) & 0xff]] ^
        G.INV_SUB_MIX[2][G.SBOX[(tt >>> 8) & 0xff]] ^
        G.INV_SUB_MIX[3][G.SBOX[tt & 0xff]]
    }
  }

  this._nRounds = nRounds
  this._keySchedule = keySchedule
  this._invKeySchedule = invKeySchedule
}

AES.prototype.encryptBlockRaw = function (M) {
  M = asUInt32Array(M)
  return cryptBlock(M, this._keySchedule, G.SUB_MIX, G.SBOX, this._nRounds)
}

AES.prototype.encryptBlock = function (M) {
  var out = this.encryptBlockRaw(M)
  var buf = Buffer.allocUnsafe(16)
  buf.writeUInt32BE(out[0], 0)
  buf.writeUInt32BE(out[1], 4)
  buf.writeUInt32BE(out[2], 8)
  buf.writeUInt32BE(out[3], 12)
  return buf
}

AES.prototype.decryptBlock = function (M) {
  M = asUInt32Array(M)

  // swap
  var m1 = M[1]
  M[1] = M[3]
  M[3] = m1

  var out = cryptBlock(M, this._invKeySchedule, G.INV_SUB_MIX, G.INV_SBOX, this._nRounds)
  var buf = Buffer.allocUnsafe(16)
  buf.writeUInt32BE(out[0], 0)
  buf.writeUInt32BE(out[3], 4)
  buf.writeUInt32BE(out[2], 8)
  buf.writeUInt32BE(out[1], 12)
  return buf
}

AES.prototype.scrub = function () {
  scrubVec(this._keySchedule)
  scrubVec(this._invKeySchedule)
  scrubVec(this._key)
}

module.exports.AES = AES

},{"safe-buffer":330}],134:[function(require,module,exports){
var aes = require('./aes')
var Buffer = require('safe-buffer').Buffer
var Transform = require('cipher-base')
var inherits = require('inherits')
var GHASH = require('./ghash')
var xor = require('buffer-xor')
var incr32 = require('./incr32')

function xorTest (a, b) {
  var out = 0
  if (a.length !== b.length) out++

  var len = Math.min(a.length, b.length)
  for (var i = 0; i < len; ++i) {
    out += (a[i] ^ b[i])
  }

  return out
}

function calcIv (self, iv, ck) {
  if (iv.length === 12) {
    self._finID = Buffer.concat([iv, Buffer.from([0, 0, 0, 1])])
    return Buffer.concat([iv, Buffer.from([0, 0, 0, 2])])
  }
  var ghash = new GHASH(ck)
  var len = iv.length
  var toPad = len % 16
  ghash.update(iv)
  if (toPad) {
    toPad = 16 - toPad
    ghash.update(Buffer.alloc(toPad, 0))
  }
  ghash.update(Buffer.alloc(8, 0))
  var ivBits = len * 8
  var tail = Buffer.alloc(8)
  tail.writeUIntBE(ivBits, 0, 8)
  ghash.update(tail)
  self._finID = ghash.state
  var out = Buffer.from(self._finID)
  incr32(out)
  return out
}
function StreamCipher (mode, key, iv, decrypt) {
  Transform.call(this)

  var h = Buffer.alloc(4, 0)

  this._cipher = new aes.AES(key)
  var ck = this._cipher.encryptBlock(h)
  this._ghash = new GHASH(ck)
  iv = calcIv(this, iv, ck)

  this._prev = Buffer.from(iv)
  this._cache = Buffer.allocUnsafe(0)
  this._secCache = Buffer.allocUnsafe(0)
  this._decrypt = decrypt
  this._alen = 0
  this._len = 0
  this._mode = mode

  this._authTag = null
  this._called = false
}

inherits(StreamCipher, Transform)

StreamCipher.prototype._update = function (chunk) {
  if (!this._called && this._alen) {
    var rump = 16 - (this._alen % 16)
    if (rump < 16) {
      rump = Buffer.alloc(rump, 0)
      this._ghash.update(rump)
    }
  }

  this._called = true
  var out = this._mode.encrypt(this, chunk)
  if (this._decrypt) {
    this._ghash.update(chunk)
  } else {
    this._ghash.update(out)
  }
  this._len += chunk.length
  return out
}

StreamCipher.prototype._final = function () {
  if (this._decrypt && !this._authTag) throw new Error('Unsupported state or unable to authenticate data')

  var tag = xor(this._ghash.final(this._alen * 8, this._len * 8), this._cipher.encryptBlock(this._finID))
  if (this._decrypt && xorTest(tag, this._authTag)) throw new Error('Unsupported state or unable to authenticate data')

  this._authTag = tag
  this._cipher.scrub()
}

StreamCipher.prototype.getAuthTag = function getAuthTag () {
  if (this._decrypt || !Buffer.isBuffer(this._authTag)) throw new Error('Attempting to get auth tag in unsupported state')

  return this._authTag
}

StreamCipher.prototype.setAuthTag = function setAuthTag (tag) {
  if (!this._decrypt) throw new Error('Attempting to set auth tag in unsupported state')

  this._authTag = tag
}

StreamCipher.prototype.setAAD = function setAAD (buf) {
  if (this._called) throw new Error('Attempting to set AAD in unsupported state')

  this._ghash.update(buf)
  this._alen += buf.length
}

module.exports = StreamCipher

},{"./aes":133,"./ghash":138,"./incr32":139,"buffer-xor":161,"cipher-base":163,"inherits":231,"safe-buffer":330}],135:[function(require,module,exports){
var ciphers = require('./encrypter')
var deciphers = require('./decrypter')
var modes = require('./modes/list.json')

function getCiphers () {
  return Object.keys(modes)
}

exports.createCipher = exports.Cipher = ciphers.createCipher
exports.createCipheriv = exports.Cipheriv = ciphers.createCipheriv
exports.createDecipher = exports.Decipher = deciphers.createDecipher
exports.createDecipheriv = exports.Decipheriv = deciphers.createDecipheriv
exports.listCiphers = exports.getCiphers = getCiphers

},{"./decrypter":136,"./encrypter":137,"./modes/list.json":147}],136:[function(require,module,exports){
var AuthCipher = require('./authCipher')
var Buffer = require('safe-buffer').Buffer
var MODES = require('./modes')
var StreamCipher = require('./streamCipher')
var Transform = require('cipher-base')
var aes = require('./aes')
var ebtk = require('evp_bytestokey')
var inherits = require('inherits')

function Decipher (mode, key, iv) {
  Transform.call(this)

  this._cache = new Splitter()
  this._last = void 0
  this._cipher = new aes.AES(key)
  this._prev = Buffer.from(iv)
  this._mode = mode
  this._autopadding = true
}

inherits(Decipher, Transform)

Decipher.prototype._update = function (data) {
  this._cache.add(data)
  var chunk
  var thing
  var out = []
  while ((chunk = this._cache.get(this._autopadding))) {
    thing = this._mode.decrypt(this, chunk)
    out.push(thing)
  }
  return Buffer.concat(out)
}

Decipher.prototype._final = function () {
  var chunk = this._cache.flush()
  if (this._autopadding) {
    return unpad(this._mode.decrypt(this, chunk))
  } else if (chunk) {
    throw new Error('data not multiple of block length')
  }
}

Decipher.prototype.setAutoPadding = function (setTo) {
  this._autopadding = !!setTo
  return this
}

function Splitter () {
  this.cache = Buffer.allocUnsafe(0)
}

Splitter.prototype.add = function (data) {
  this.cache = Buffer.concat([this.cache, data])
}

Splitter.prototype.get = function (autoPadding) {
  var out
  if (autoPadding) {
    if (this.cache.length > 16) {
      out = this.cache.slice(0, 16)
      this.cache = this.cache.slice(16)
      return out
    }
  } else {
    if (this.cache.length >= 16) {
      out = this.cache.slice(0, 16)
      this.cache = this.cache.slice(16)
      return out
    }
  }

  return null
}

Splitter.prototype.flush = function () {
  if (this.cache.length) return this.cache
}

function unpad (last) {
  var padded = last[15]
  if (padded < 1 || padded > 16) {
    throw new Error('unable to decrypt data')
  }
  var i = -1
  while (++i < padded) {
    if (last[(i + (16 - padded))] !== padded) {
      throw new Error('unable to decrypt data')
    }
  }
  if (padded === 16) return

  return last.slice(0, 16 - padded)
}

function createDecipheriv (suite, password, iv) {
  var config = MODES[suite.toLowerCase()]
  if (!config) throw new TypeError('invalid suite type')

  if (typeof iv === 'string') iv = Buffer.from(iv)
  if (config.mode !== 'GCM' && iv.length !== config.iv) throw new TypeError('invalid iv length ' + iv.length)

  if (typeof password === 'string') password = Buffer.from(password)
  if (password.length !== config.key / 8) throw new TypeError('invalid key length ' + password.length)

  if (config.type === 'stream') {
    return new StreamCipher(config.module, password, iv, true)
  } else if (config.type === 'auth') {
    return new AuthCipher(config.module, password, iv, true)
  }

  return new Decipher(config.module, password, iv)
}

function createDecipher (suite, password) {
  var config = MODES[suite.toLowerCase()]
  if (!config) throw new TypeError('invalid suite type')

  var keys = ebtk(password, false, config.key, config.iv)
  return createDecipheriv(suite, keys.key, keys.iv)
}

exports.createDecipher = createDecipher
exports.createDecipheriv = createDecipheriv

},{"./aes":133,"./authCipher":134,"./modes":146,"./streamCipher":149,"cipher-base":163,"evp_bytestokey":202,"inherits":231,"safe-buffer":330}],137:[function(require,module,exports){
var MODES = require('./modes')
var AuthCipher = require('./authCipher')
var Buffer = require('safe-buffer').Buffer
var StreamCipher = require('./streamCipher')
var Transform = require('cipher-base')
var aes = require('./aes')
var ebtk = require('evp_bytestokey')
var inherits = require('inherits')

function Cipher (mode, key, iv) {
  Transform.call(this)

  this._cache = new Splitter()
  this._cipher = new aes.AES(key)
  this._prev = Buffer.from(iv)
  this._mode = mode
  this._autopadding = true
}

inherits(Cipher, Transform)

Cipher.prototype._update = function (data) {
  this._cache.add(data)
  var chunk
  var thing
  var out = []

  while ((chunk = this._cache.get())) {
    thing = this._mode.encrypt(this, chunk)
    out.push(thing)
  }

  return Buffer.concat(out)
}

var PADDING = Buffer.alloc(16, 0x10)

Cipher.prototype._final = function () {
  var chunk = this._cache.flush()
  if (this._autopadding) {
    chunk = this._mode.encrypt(this, chunk)
    this._cipher.scrub()
    return chunk
  }

  if (!chunk.equals(PADDING)) {
    this._cipher.scrub()
    throw new Error('data not multiple of block length')
  }
}

Cipher.prototype.setAutoPadding = function (setTo) {
  this._autopadding = !!setTo
  return this
}

function Splitter () {
  this.cache = Buffer.allocUnsafe(0)
}

Splitter.prototype.add = function (data) {
  this.cache = Buffer.concat([this.cache, data])
}

Splitter.prototype.get = function () {
  if (this.cache.length > 15) {
    var out = this.cache.slice(0, 16)
    this.cache = this.cache.slice(16)
    return out
  }
  return null
}

Splitter.prototype.flush = function () {
  var len = 16 - this.cache.length
  var padBuff = Buffer.allocUnsafe(len)

  var i = -1
  while (++i < len) {
    padBuff.writeUInt8(len, i)
  }

  return Buffer.concat([this.cache, padBuff])
}

function createCipheriv (suite, password, iv) {
  var config = MODES[suite.toLowerCase()]
  if (!config) throw new TypeError('invalid suite type')

  if (typeof password === 'string') password = Buffer.from(password)
  if (password.length !== config.key / 8) throw new TypeError('invalid key length ' + password.length)

  if (typeof iv === 'string') iv = Buffer.from(iv)
  if (config.mode !== 'GCM' && iv.length !== config.iv) throw new TypeError('invalid iv length ' + iv.length)

  if (config.type === 'stream') {
    return new StreamCipher(config.module, password, iv)
  } else if (config.type === 'auth') {
    return new AuthCipher(config.module, password, iv)
  }

  return new Cipher(config.module, password, iv)
}

function createCipher (suite, password) {
  var config = MODES[suite.toLowerCase()]
  if (!config) throw new TypeError('invalid suite type')

  var keys = ebtk(password, false, config.key, config.iv)
  return createCipheriv(suite, keys.key, keys.iv)
}

exports.createCipheriv = createCipheriv
exports.createCipher = createCipher

},{"./aes":133,"./authCipher":134,"./modes":146,"./streamCipher":149,"cipher-base":163,"evp_bytestokey":202,"inherits":231,"safe-buffer":330}],138:[function(require,module,exports){
var Buffer = require('safe-buffer').Buffer
var ZEROES = Buffer.alloc(16, 0)

function toArray (buf) {
  return [
    buf.readUInt32BE(0),
    buf.readUInt32BE(4),
    buf.readUInt32BE(8),
    buf.readUInt32BE(12)
  ]
}

function fromArray (out) {
  var buf = Buffer.allocUnsafe(16)
  buf.writeUInt32BE(out[0] >>> 0, 0)
  buf.writeUInt32BE(out[1] >>> 0, 4)
  buf.writeUInt32BE(out[2] >>> 0, 8)
  buf.writeUInt32BE(out[3] >>> 0, 12)
  return buf
}

function GHASH (key) {
  this.h = key
  this.state = Buffer.alloc(16, 0)
  this.cache = Buffer.allocUnsafe(0)
}

// from http://bitwiseshiftleft.github.io/sjcl/doc/symbols/src/core_gcm.js.html
// by Juho Vähä-Herttua
GHASH.prototype.ghash = function (block) {
  var i = -1
  while (++i < block.length) {
    this.state[i] ^= block[i]
  }
  this._multiply()
}

GHASH.prototype._multiply = function () {
  var Vi = toArray(this.h)
  var Zi = [0, 0, 0, 0]
  var j, xi, lsbVi
  var i = -1
  while (++i < 128) {
    xi = (this.state[~~(i / 8)] & (1 << (7 - (i % 8)))) !== 0
    if (xi) {
      // Z_i+1 = Z_i ^ V_i
      Zi[0] ^= Vi[0]
      Zi[1] ^= Vi[1]
      Zi[2] ^= Vi[2]
      Zi[3] ^= Vi[3]
    }

    // Store the value of LSB(V_i)
    lsbVi = (Vi[3] & 1) !== 0

    // V_i+1 = V_i >> 1
    for (j = 3; j > 0; j--) {
      Vi[j] = (Vi[j] >>> 1) | ((Vi[j - 1] & 1) << 31)
    }
    Vi[0] = Vi[0] >>> 1

    // If LSB(V_i) is 1, V_i+1 = (V_i >> 1) ^ R
    if (lsbVi) {
      Vi[0] = Vi[0] ^ (0xe1 << 24)
    }
  }
  this.state = fromArray(Zi)
}

GHASH.prototype.update = function (buf) {
  this.cache = Buffer.concat([this.cache, buf])
  var chunk
  while (this.cache.length >= 16) {
    chunk = this.cache.slice(0, 16)
    this.cache = this.cache.slice(16)
    this.ghash(chunk)
  }
}

GHASH.prototype.final = function (abl, bl) {
  if (this.cache.length) {
    this.ghash(Buffer.concat([this.cache, ZEROES], 16))
  }

  this.ghash(fromArray([0, abl, 0, bl]))
  return this.state
}

module.exports = GHASH

},{"safe-buffer":330}],139:[function(require,module,exports){
function incr32 (iv) {
  var len = iv.length
  var item
  while (len--) {
    item = iv.readUInt8(len)
    if (item === 255) {
      iv.writeUInt8(0, len)
    } else {
      item++
      iv.writeUInt8(item, len)
      break
    }
  }
}
module.exports = incr32

},{}],140:[function(require,module,exports){
var xor = require('buffer-xor')

exports.encrypt = function (self, block) {
  var data = xor(block, self._prev)

  self._prev = self._cipher.encryptBlock(data)
  return self._prev
}

exports.decrypt = function (self, block) {
  var pad = self._prev

  self._prev = block
  var out = self._cipher.decryptBlock(block)

  return xor(out, pad)
}

},{"buffer-xor":161}],141:[function(require,module,exports){
var Buffer = require('safe-buffer').Buffer
var xor = require('buffer-xor')

function encryptStart (self, data, decrypt) {
  var len = data.length
  var out = xor(data, self._cache)
  self._cache = self._cache.slice(len)
  self._prev = Buffer.concat([self._prev, decrypt ? data : out])
  return out
}

exports.encrypt = function (self, data, decrypt) {
  var out = Buffer.allocUnsafe(0)
  var len

  while (data.length) {
    if (self._cache.length === 0) {
      self._cache = self._cipher.encryptBlock(self._prev)
      self._prev = Buffer.allocUnsafe(0)
    }

    if (self._cache.length <= data.length) {
      len = self._cache.length
      out = Buffer.concat([out, encryptStart(self, data.slice(0, len), decrypt)])
      data = data.slice(len)
    } else {
      out = Buffer.concat([out, encryptStart(self, data, decrypt)])
      break
    }
  }

  return out
}

},{"buffer-xor":161,"safe-buffer":330}],142:[function(require,module,exports){
var Buffer = require('safe-buffer').Buffer

function encryptByte (self, byteParam, decrypt) {
  var pad
  var i = -1
  var len = 8
  var out = 0
  var bit, value
  while (++i < len) {
    pad = self._cipher.encryptBlock(self._prev)
    bit = (byteParam & (1 << (7 - i))) ? 0x80 : 0
    value = pad[0] ^ bit
    out += ((value & 0x80) >> (i % 8))
    self._prev = shiftIn(self._prev, decrypt ? bit : value)
  }
  return out
}

function shiftIn (buffer, value) {
  var len = buffer.length
  var i = -1
  var out = Buffer.allocUnsafe(buffer.length)
  buffer = Buffer.concat([buffer, Buffer.from([value])])

  while (++i < len) {
    out[i] = buffer[i] << 1 | buffer[i + 1] >> (7)
  }

  return out
}

exports.encrypt = function (self, chunk, decrypt) {
  var len = chunk.length
  var out = Buffer.allocUnsafe(len)
  var i = -1

  while (++i < len) {
    out[i] = encryptByte(self, chunk[i], decrypt)
  }

  return out
}

},{"safe-buffer":330}],143:[function(require,module,exports){
var Buffer = require('safe-buffer').Buffer

function encryptByte (self, byteParam, decrypt) {
  var pad = self._cipher.encryptBlock(self._prev)
  var out = pad[0] ^ byteParam

  self._prev = Buffer.concat([
    self._prev.slice(1),
    Buffer.from([decrypt ? byteParam : out])
  ])

  return out
}

exports.encrypt = function (self, chunk, decrypt) {
  var len = chunk.length
  var out = Buffer.allocUnsafe(len)
  var i = -1

  while (++i < len) {
    out[i] = encryptByte(self, chunk[i], decrypt)
  }

  return out
}

},{"safe-buffer":330}],144:[function(require,module,exports){
var xor = require('buffer-xor')
var Buffer = require('safe-buffer').Buffer
var incr32 = require('../incr32')

function getBlock (self) {
  var out = self._cipher.encryptBlockRaw(self._prev)
  incr32(self._prev)
  return out
}

var blockSize = 16
exports.encrypt = function (self, chunk) {
  var chunkNum = Math.ceil(chunk.length / blockSize)
  var start = self._cache.length
  self._cache = Buffer.concat([
    self._cache,
    Buffer.allocUnsafe(chunkNum * blockSize)
  ])
  for (var i = 0; i < chunkNum; i++) {
    var out = getBlock(self)
    var offset = start + i * blockSize
    self._cache.writeUInt32BE(out[0], offset + 0)
    self._cache.writeUInt32BE(out[1], offset + 4)
    self._cache.writeUInt32BE(out[2], offset + 8)
    self._cache.writeUInt32BE(out[3], offset + 12)
  }
  var pad = self._cache.slice(0, chunk.length)
  self._cache = self._cache.slice(chunk.length)
  return xor(chunk, pad)
}

},{"../incr32":139,"buffer-xor":161,"safe-buffer":330}],145:[function(require,module,exports){
exports.encrypt = function (self, block) {
  return self._cipher.encryptBlock(block)
}

exports.decrypt = function (self, block) {
  return self._cipher.decryptBlock(block)
}

},{}],146:[function(require,module,exports){
var modeModules = {
  ECB: require('./ecb'),
  CBC: require('./cbc'),
  CFB: require('./cfb'),
  CFB8: require('./cfb8'),
  CFB1: require('./cfb1'),
  OFB: require('./ofb'),
  CTR: require('./ctr'),
  GCM: require('./ctr')
}

var modes = require('./list.json')

for (var key in modes) {
  modes[key].module = modeModules[modes[key].mode]
}

module.exports = modes

},{"./cbc":140,"./cfb":141,"./cfb1":142,"./cfb8":143,"./ctr":144,"./ecb":145,"./list.json":147,"./ofb":148}],147:[function(require,module,exports){
module.exports={
  "aes-128-ecb": {
    "cipher": "AES",
    "key": 128,
    "iv": 0,
    "mode": "ECB",
    "type": "block"
  },
  "aes-192-ecb": {
    "cipher": "AES",
    "key": 192,
    "iv": 0,
    "mode": "ECB",
    "type": "block"
  },
  "aes-256-ecb": {
    "cipher": "AES",
    "key": 256,
    "iv": 0,
    "mode": "ECB",
    "type": "block"
  },
  "aes-128-cbc": {
    "cipher": "AES",
    "key": 128,
    "iv": 16,
    "mode": "CBC",
    "type": "block"
  },
  "aes-192-cbc": {
    "cipher": "AES",
    "key": 192,
    "iv": 16,
    "mode": "CBC",
    "type": "block"
  },
  "aes-256-cbc": {
    "cipher": "AES",
    "key": 256,
    "iv": 16,
    "mode": "CBC",
    "type": "block"
  },
  "aes128": {
    "cipher": "AES",
    "key": 128,
    "iv": 16,
    "mode": "CBC",
    "type": "block"
  },
  "aes192": {
    "cipher": "AES",
    "key": 192,
    "iv": 16,
    "mode": "CBC",
    "type": "block"
  },
  "aes256": {
    "cipher": "AES",
    "key": 256,
    "iv": 16,
    "mode": "CBC",
    "type": "block"
  },
  "aes-128-cfb": {
    "cipher": "AES",
    "key": 128,
    "iv": 16,
    "mode": "CFB",
    "type": "stream"
  },
  "aes-192-cfb": {
    "cipher": "AES",
    "key": 192,
    "iv": 16,
    "mode": "CFB",
    "type": "stream"
  },
  "aes-256-cfb": {
    "cipher": "AES",
    "key": 256,
    "iv": 16,
    "mode": "CFB",
    "type": "stream"
  },
  "aes-128-cfb8": {
    "cipher": "AES",
    "key": 128,
    "iv": 16,
    "mode": "CFB8",
    "type": "stream"
  },
  "aes-192-cfb8": {
    "cipher": "AES",
    "key": 192,
    "iv": 16,
    "mode": "CFB8",
    "type": "stream"
  },
  "aes-256-cfb8": {
    "cipher": "AES",
    "key": 256,
    "iv": 16,
    "mode": "CFB8",
    "type": "stream"
  },
  "aes-128-cfb1": {
    "cipher": "AES",
    "key": 128,
    "iv": 16,
    "mode": "CFB1",
    "type": "stream"
  },
  "aes-192-cfb1": {
    "cipher": "AES",
    "key": 192,
    "iv": 16,
    "mode": "CFB1",
    "type": "stream"
  },
  "aes-256-cfb1": {
    "cipher": "AES",
    "key": 256,
    "iv": 16,
    "mode": "CFB1",
    "type": "stream"
  },
  "aes-128-ofb": {
    "cipher": "AES",
    "key": 128,
    "iv": 16,
    "mode": "OFB",
    "type": "stream"
  },
  "aes-192-ofb": {
    "cipher": "AES",
    "key": 192,
    "iv": 16,
    "mode": "OFB",
    "type": "stream"
  },
  "aes-256-ofb": {
    "cipher": "AES",
    "key": 256,
    "iv": 16,
    "mode": "OFB",
    "type": "stream"
  },
  "aes-128-ctr": {
    "cipher": "AES",
    "key": 128,
    "iv": 16,
    "mode": "CTR",
    "type": "stream"
  },
  "aes-192-ctr": {
    "cipher": "AES",
    "key": 192,
    "iv": 16,
    "mode": "CTR",
    "type": "stream"
  },
  "aes-256-ctr": {
    "cipher": "AES",
    "key": 256,
    "iv": 16,
    "mode": "CTR",
    "type": "stream"
  },
  "aes-128-gcm": {
    "cipher": "AES",
    "key": 128,
    "iv": 12,
    "mode": "GCM",
    "type": "auth"
  },
  "aes-192-gcm": {
    "cipher": "AES",
    "key": 192,
    "iv": 12,
    "mode": "GCM",
    "type": "auth"
  },
  "aes-256-gcm": {
    "cipher": "AES",
    "key": 256,
    "iv": 12,
    "mode": "GCM",
    "type": "auth"
  }
}

},{}],148:[function(require,module,exports){
(function (Buffer){
var xor = require('buffer-xor')

function getBlock (self) {
  self._prev = self._cipher.encryptBlock(self._prev)
  return self._prev
}

exports.encrypt = function (self, chunk) {
  while (self._cache.length < chunk.length) {
    self._cache = Buffer.concat([self._cache, getBlock(self)])
  }

  var pad = self._cache.slice(0, chunk.length)
  self._cache = self._cache.slice(chunk.length)
  return xor(chunk, pad)
}

}).call(this,require("buffer").Buffer)
},{"buffer":162,"buffer-xor":161}],149:[function(require,module,exports){
var aes = require('./aes')
var Buffer = require('safe-buffer').Buffer
var Transform = require('cipher-base')
var inherits = require('inherits')

function StreamCipher (mode, key, iv, decrypt) {
  Transform.call(this)

  this._cipher = new aes.AES(key)
  this._prev = Buffer.from(iv)
  this._cache = Buffer.allocUnsafe(0)
  this._secCache = Buffer.allocUnsafe(0)
  this._decrypt = decrypt
  this._mode = mode
}

inherits(StreamCipher, Transform)

StreamCipher.prototype._update = function (chunk) {
  return this._mode.encrypt(this, chunk, this._decrypt)
}

StreamCipher.prototype._final = function () {
  this._cipher.scrub()
}

module.exports = StreamCipher

},{"./aes":133,"cipher-base":163,"inherits":231,"safe-buffer":330}],150:[function(require,module,exports){
var DES = require('browserify-des')
var aes = require('browserify-aes/browser')
var aesModes = require('browserify-aes/modes')
var desModes = require('browserify-des/modes')
var ebtk = require('evp_bytestokey')

function createCipher (suite, password) {
  suite = suite.toLowerCase()

  var keyLen, ivLen
  if (aesModes[suite]) {
    keyLen = aesModes[suite].key
    ivLen = aesModes[suite].iv
  } else if (desModes[suite]) {
    keyLen = desModes[suite].key * 8
    ivLen = desModes[suite].iv
  } else {
    throw new TypeError('invalid suite type')
  }

  var keys = ebtk(password, false, keyLen, ivLen)
  return createCipheriv(suite, keys.key, keys.iv)
}

function createDecipher (suite, password) {
  suite = suite.toLowerCase()

  var keyLen, ivLen
  if (aesModes[suite]) {
    keyLen = aesModes[suite].key
    ivLen = aesModes[suite].iv
  } else if (desModes[suite]) {
    keyLen = desModes[suite].key * 8
    ivLen = desModes[suite].iv
  } else {
    throw new TypeError('invalid suite type')
  }

  var keys = ebtk(password, false, keyLen, ivLen)
  return createDecipheriv(suite, keys.key, keys.iv)
}

function createCipheriv (suite, key, iv) {
  suite = suite.toLowerCase()
  if (aesModes[suite]) return aes.createCipheriv(suite, key, iv)
  if (desModes[suite]) return new DES({ key: key, iv: iv, mode: suite })

  throw new TypeError('invalid suite type')
}

function createDecipheriv (suite, key, iv) {
  suite = suite.toLowerCase()
  if (aesModes[suite]) return aes.createDecipheriv(suite, key, iv)
  if (desModes[suite]) return new DES({ key: key, iv: iv, mode: suite, decrypt: true })

  throw new TypeError('invalid suite type')
}

function getCiphers () {
  return Object.keys(desModes).concat(aes.getCiphers())
}

exports.createCipher = exports.Cipher = createCipher
exports.createCipheriv = exports.Cipheriv = createCipheriv
exports.createDecipher = exports.Decipher = createDecipher
exports.createDecipheriv = exports.Decipheriv = createDecipheriv
exports.listCiphers = exports.getCiphers = getCiphers

},{"browserify-aes/browser":135,"browserify-aes/modes":146,"browserify-des":151,"browserify-des/modes":152,"evp_bytestokey":202}],151:[function(require,module,exports){
var CipherBase = require('cipher-base')
var des = require('des.js')
var inherits = require('inherits')
var Buffer = require('safe-buffer').Buffer

var modes = {
  'des-ede3-cbc': des.CBC.instantiate(des.EDE),
  'des-ede3': des.EDE,
  'des-ede-cbc': des.CBC.instantiate(des.EDE),
  'des-ede': des.EDE,
  'des-cbc': des.CBC.instantiate(des.DES),
  'des-ecb': des.DES
}
modes.des = modes['des-cbc']
modes.des3 = modes['des-ede3-cbc']
module.exports = DES
inherits(DES, CipherBase)
function DES (opts) {
  CipherBase.call(this)
  var modeName = opts.mode.toLowerCase()
  var mode = modes[modeName]
  var type
  if (opts.decrypt) {
    type = 'decrypt'
  } else {
    type = 'encrypt'
  }
  var key = opts.key
  if (!Buffer.isBuffer(key)) {
    key = Buffer.from(key)
  }
  if (modeName === 'des-ede' || modeName === 'des-ede-cbc') {
    key = Buffer.concat([key, key.slice(0, 8)])
  }
  var iv = opts.iv
  if (!Buffer.isBuffer(iv)) {
    iv = Buffer.from(iv)
  }
  this._des = mode.create({
    key: key,
    iv: iv,
    type: type
  })
}
DES.prototype._update = function (data) {
  return Buffer.from(this._des.update(data))
}
DES.prototype._final = function () {
  return Buffer.from(this._des.final())
}

},{"cipher-base":163,"des.js":174,"inherits":231,"safe-buffer":330}],152:[function(require,module,exports){
exports['des-ecb'] = {
  key: 8,
  iv: 0
}
exports['des-cbc'] = exports.des = {
  key: 8,
  iv: 8
}
exports['des-ede3-cbc'] = exports.des3 = {
  key: 24,
  iv: 8
}
exports['des-ede3'] = {
  key: 24,
  iv: 0
}
exports['des-ede-cbc'] = {
  key: 16,
  iv: 8
}
exports['des-ede'] = {
  key: 16,
  iv: 0
}

},{}],153:[function(require,module,exports){
(function (Buffer){
var bn = require('bn.js');
var randomBytes = require('randombytes');
module.exports = crt;
function blind(priv) {
  var r = getr(priv);
  var blinder = r.toRed(bn.mont(priv.modulus))
  .redPow(new bn(priv.publicExponent)).fromRed();
  return {
    blinder: blinder,
    unblinder:r.invm(priv.modulus)
  };
}
function crt(msg, priv) {
  var blinds = blind(priv);
  var len = priv.modulus.byteLength();
  var mod = bn.mont(priv.modulus);
  var blinded = new bn(msg).mul(blinds.blinder).umod(priv.modulus);
  var c1 = blinded.toRed(bn.mont(priv.prime1));
  var c2 = blinded.toRed(bn.mont(priv.prime2));
  var qinv = priv.coefficient;
  var p = priv.prime1;
  var q = priv.prime2;
  var m1 = c1.redPow(priv.exponent1);
  var m2 = c2.redPow(priv.exponent2);
  m1 = m1.fromRed();
  m2 = m2.fromRed();
  var h = m1.isub(m2).imul(qinv).umod(p);
  h.imul(q);
  m2.iadd(h);
  return new Buffer(m2.imul(blinds.unblinder).umod(priv.modulus).toArray(false, len));
}
crt.getr = getr;
function getr(priv) {
  var len = priv.modulus.byteLength();
  var r = new bn(randomBytes(len));
  while (r.cmp(priv.modulus) >=  0 || !r.umod(priv.prime1) || !r.umod(priv.prime2)) {
    r = new bn(randomBytes(len));
  }
  return r;
}

}).call(this,require("buffer").Buffer)
},{"bn.js":130,"buffer":162,"randombytes":314}],154:[function(require,module,exports){
module.exports = require('./browser/algorithms.json')

},{"./browser/algorithms.json":155}],155:[function(require,module,exports){
module.exports={
  "sha224WithRSAEncryption": {
    "sign": "rsa",
    "hash": "sha224",
    "id": "302d300d06096086480165030402040500041c"
  },
  "RSA-SHA224": {
    "sign": "ecdsa/rsa",
    "hash": "sha224",
    "id": "302d300d06096086480165030402040500041c"
  },
  "sha256WithRSAEncryption": {
    "sign": "rsa",
    "hash": "sha256",
    "id": "3031300d060960864801650304020105000420"
  },
  "RSA-SHA256": {
    "sign": "ecdsa/rsa",
    "hash": "sha256",
    "id": "3031300d060960864801650304020105000420"
  },
  "sha384WithRSAEncryption": {
    "sign": "rsa",
    "hash": "sha384",
    "id": "3041300d060960864801650304020205000430"
  },
  "RSA-SHA384": {
    "sign": "ecdsa/rsa",
    "hash": "sha384",
    "id": "3041300d060960864801650304020205000430"
  },
  "sha512WithRSAEncryption": {
    "sign": "rsa",
    "hash": "sha512",
    "id": "3051300d060960864801650304020305000440"
  },
  "RSA-SHA512": {
    "sign": "ecdsa/rsa",
    "hash": "sha512",
    "id": "3051300d060960864801650304020305000440"
  },
  "RSA-SHA1": {
    "sign": "rsa",
    "hash": "sha1",
    "id": "3021300906052b0e03021a05000414"
  },
  "ecdsa-with-SHA1": {
    "sign": "ecdsa",
    "hash": "sha1",
    "id": ""
  },
  "sha256": {
    "sign": "ecdsa",
    "hash": "sha256",
    "id": ""
  },
  "sha224": {
    "sign": "ecdsa",
    "hash": "sha224",
    "id": ""
  },
  "sha384": {
    "sign": "ecdsa",
    "hash": "sha384",
    "id": ""
  },
  "sha512": {
    "sign": "ecdsa",
    "hash": "sha512",
    "id": ""
  },
  "DSA-SHA": {
    "sign": "dsa",
    "hash": "sha1",
    "id": ""
  },
  "DSA-SHA1": {
    "sign": "dsa",
    "hash": "sha1",
    "id": ""
  },
  "DSA": {
    "sign": "dsa",
    "hash": "sha1",
    "id": ""
  },
  "DSA-WITH-SHA224": {
    "sign": "dsa",
    "hash": "sha224",
    "id": ""
  },
  "DSA-SHA224": {
    "sign": "dsa",
    "hash": "sha224",
    "id": ""
  },
  "DSA-WITH-SHA256": {
    "sign": "dsa",
    "hash": "sha256",
    "id": ""
  },
  "DSA-SHA256": {
    "sign": "dsa",
    "hash": "sha256",
    "id": ""
  },
  "DSA-WITH-SHA384": {
    "sign": "dsa",
    "hash": "sha384",
    "id": ""
  },
  "DSA-SHA384": {
    "sign": "dsa",
    "hash": "sha384",
    "id": ""
  },
  "DSA-WITH-SHA512": {
    "sign": "dsa",
    "hash": "sha512",
    "id": ""
  },
  "DSA-SHA512": {
    "sign": "dsa",
    "hash": "sha512",
    "id": ""
  },
  "DSA-RIPEMD160": {
    "sign": "dsa",
    "hash": "rmd160",
    "id": ""
  },
  "ripemd160WithRSA": {
    "sign": "rsa",
    "hash": "rmd160",
    "id": "3021300906052b2403020105000414"
  },
  "RSA-RIPEMD160": {
    "sign": "rsa",
    "hash": "rmd160",
    "id": "3021300906052b2403020105000414"
  },
  "md5WithRSAEncryption": {
    "sign": "rsa",
    "hash": "md5",
    "id": "3020300c06082a864886f70d020505000410"
  },
  "RSA-MD5": {
    "sign": "rsa",
    "hash": "md5",
    "id": "3020300c06082a864886f70d020505000410"
  }
}

},{}],156:[function(require,module,exports){
module.exports={
  "1.3.132.0.10": "secp256k1",
  "1.3.132.0.33": "p224",
  "1.2.840.10045.3.1.1": "p192",
  "1.2.840.10045.3.1.7": "p256",
  "1.3.132.0.34": "p384",
  "1.3.132.0.35": "p521"
}

},{}],157:[function(require,module,exports){
(function (Buffer){
var createHash = require('create-hash')
var stream = require('stream')
var inherits = require('inherits')
var sign = require('./sign')
var verify = require('./verify')

var algorithms = require('./algorithms.json')
Object.keys(algorithms).forEach(function (key) {
  algorithms[key].id = new Buffer(algorithms[key].id, 'hex')
  algorithms[key.toLowerCase()] = algorithms[key]
})

function Sign (algorithm) {
  stream.Writable.call(this)

  var data = algorithms[algorithm]
  if (!data) throw new Error('Unknown message digest')

  this._hashType = data.hash
  this._hash = createHash(data.hash)
  this._tag = data.id
  this._signType = data.sign
}
inherits(Sign, stream.Writable)

Sign.prototype._write = function _write (data, _, done) {
  this._hash.update(data)
  done()
}

Sign.prototype.update = function update (data, enc) {
  if (typeof data === 'string') data = new Buffer(data, enc)

  this._hash.update(data)
  return this
}

Sign.prototype.sign = function signMethod (key, enc) {
  this.end()
  var hash = this._hash.digest()
  var sig = sign(hash, key, this._hashType, this._signType, this._tag)

  return enc ? sig.toString(enc) : sig
}

function Verify (algorithm) {
  stream.Writable.call(this)

  var data = algorithms[algorithm]
  if (!data) throw new Error('Unknown message digest')

  this._hash = createHash(data.hash)
  this._tag = data.id
  this._signType = data.sign
}
inherits(Verify, stream.Writable)

Verify.prototype._write = function _write (data, _, done) {
  this._hash.update(data)
  done()
}

Verify.prototype.update = function update (data, enc) {
  if (typeof data === 'string') data = new Buffer(data, enc)

  this._hash.update(data)
  return this
}

Verify.prototype.verify = function verifyMethod (key, sig, enc) {
  if (typeof sig === 'string') sig = new Buffer(sig, enc)

  this.end()
  var hash = this._hash.digest()
  return verify(sig, hash, key, this._signType, this._tag)
}

function createSign (algorithm) {
  return new Sign(algorithm)
}

function createVerify (algorithm) {
  return new Verify(algorithm)
}

module.exports = {
  Sign: createSign,
  Verify: createVerify,
  createSign: createSign,
  createVerify: createVerify
}

}).call(this,require("buffer").Buffer)
},{"./algorithms.json":155,"./sign":158,"./verify":159,"buffer":162,"create-hash":166,"inherits":231,"stream":342}],158:[function(require,module,exports){
(function (Buffer){
// much of this based on https://github.com/indutny/self-signed/blob/gh-pages/lib/rsa.js
var createHmac = require('create-hmac')
var crt = require('browserify-rsa')
var EC = require('elliptic').ec
var BN = require('bn.js')
var parseKeys = require('parse-asn1')
var curves = require('./curves.json')

function sign (hash, key, hashType, signType, tag) {
  var priv = parseKeys(key)
  if (priv.curve) {
    // rsa keys can be interpreted as ecdsa ones in openssl
    if (signType !== 'ecdsa' && signType !== 'ecdsa/rsa') throw new Error('wrong private key type')
    return ecSign(hash, priv)
  } else if (priv.type === 'dsa') {
    if (signType !== 'dsa') throw new Error('wrong private key type')
    return dsaSign(hash, priv, hashType)
  } else {
    if (signType !== 'rsa' && signType !== 'ecdsa/rsa') throw new Error('wrong private key type')
  }
  hash = Buffer.concat([tag, hash])
  var len = priv.modulus.byteLength()
  var pad = [ 0, 1 ]
  while (hash.length + pad.length + 1 < len) pad.push(0xff)
  pad.push(0x00)
  var i = -1
  while (++i < hash.length) pad.push(hash[i])

  var out = crt(pad, priv)
  return out
}

function ecSign (hash, priv) {
  var curveId = curves[priv.curve.join('.')]
  if (!curveId) throw new Error('unknown curve ' + priv.curve.join('.'))

  var curve = new EC(curveId)
  var key = curve.keyFromPrivate(priv.privateKey)
  var out = key.sign(hash)

  return new Buffer(out.toDER())
}

function dsaSign (hash, priv, algo) {
  var x = priv.params.priv_key
  var p = priv.params.p
  var q = priv.params.q
  var g = priv.params.g
  var r = new BN(0)
  var k
  var H = bits2int(hash, q).mod(q)
  var s = false
  var kv = getKey(x, q, hash, algo)
  while (s === false) {
    k = makeKey(q, kv, algo)
    r = makeR(g, k, p, q)
    s = k.invm(q).imul(H.add(x.mul(r))).mod(q)
    if (s.cmpn(0) === 0) {
      s = false
      r = new BN(0)
    }
  }
  return toDER(r, s)
}

function toDER (r, s) {
  r = r.toArray()
  s = s.toArray()

  // Pad values
  if (r[0] & 0x80) r = [ 0 ].concat(r)
  if (s[0] & 0x80) s = [ 0 ].concat(s)

  var total = r.length + s.length + 4
  var res = [ 0x30, total, 0x02, r.length ]
  res = res.concat(r, [ 0x02, s.length ], s)
  return new Buffer(res)
}

function getKey (x, q, hash, algo) {
  x = new Buffer(x.toArray())
  if (x.length < q.byteLength()) {
    var zeros = new Buffer(q.byteLength() - x.length)
    zeros.fill(0)
    x = Buffer.concat([ zeros, x ])
  }
  var hlen = hash.length
  var hbits = bits2octets(hash, q)
  var v = new Buffer(hlen)
  v.fill(1)
  var k = new Buffer(hlen)
  k.fill(0)
  k = createHmac(algo, k).update(v).update(new Buffer([ 0 ])).update(x).update(hbits).digest()
  v = createHmac(algo, k).update(v).digest()
  k = createHmac(algo, k).update(v).update(new Buffer([ 1 ])).update(x).update(hbits).digest()
  v = createHmac(algo, k).update(v).digest()
  return { k: k, v: v }
}

function bits2int (obits, q) {
  var bits = new BN(obits)
  var shift = (obits.length << 3) - q.bitLength()
  if (shift > 0) bits.ishrn(shift)
  return bits
}

function bits2octets (bits, q) {
  bits = bits2int(bits, q)
  bits = bits.mod(q)
  var out = new Buffer(bits.toArray())
  if (out.length < q.byteLength()) {
    var zeros = new Buffer(q.byteLength() - out.length)
    zeros.fill(0)
    out = Buffer.concat([ zeros, out ])
  }
  return out
}

function makeKey (q, kv, algo) {
  var t
  var k

  do {
    t = new Buffer(0)

    while (t.length * 8 < q.bitLength()) {
      kv.v = createHmac(algo, kv.k).update(kv.v).digest()
      t = Buffer.concat([ t, kv.v ])
    }

    k = bits2int(t, q)
    kv.k = createHmac(algo, kv.k).update(kv.v).update(new Buffer([ 0 ])).digest()
    kv.v = createHmac(algo, kv.k).update(kv.v).digest()
  } while (k.cmp(q) !== -1)

  return k
}

function makeR (g, k, p, q) {
  return g.toRed(BN.mont(p)).redPow(k).fromRed().mod(q)
}

module.exports = sign
module.exports.getKey = getKey
module.exports.makeKey = makeKey

}).call(this,require("buffer").Buffer)
},{"./curves.json":156,"bn.js":130,"browserify-rsa":153,"buffer":162,"create-hmac":168,"elliptic":184,"parse-asn1":298}],159:[function(require,module,exports){
(function (Buffer){
// much of this based on https://github.com/indutny/self-signed/blob/gh-pages/lib/rsa.js
var BN = require('bn.js')
var EC = require('elliptic').ec
var parseKeys = require('parse-asn1')
var curves = require('./curves.json')

function verify (sig, hash, key, signType, tag) {
  var pub = parseKeys(key)
  if (pub.type === 'ec') {
    // rsa keys can be interpreted as ecdsa ones in openssl
    if (signType !== 'ecdsa' && signType !== 'ecdsa/rsa') throw new Error('wrong public key type')
    return ecVerify(sig, hash, pub)
  } else if (pub.type === 'dsa') {
    if (signType !== 'dsa') throw new Error('wrong public key type')
    return dsaVerify(sig, hash, pub)
  } else {
    if (signType !== 'rsa' && signType !== 'ecdsa/rsa') throw new Error('wrong public key type')
  }
  hash = Buffer.concat([tag, hash])
  var len = pub.modulus.byteLength()
  var pad = [ 1 ]
  var padNum = 0
  while (hash.length + pad.length + 2 < len) {
    pad.push(0xff)
    padNum++
  }
  pad.push(0x00)
  var i = -1
  while (++i < hash.length) {
    pad.push(hash[i])
  }
  pad = new Buffer(pad)
  var red = BN.mont(pub.modulus)
  sig = new BN(sig).toRed(red)

  sig = sig.redPow(new BN(pub.publicExponent))
  sig = new Buffer(sig.fromRed().toArray())
  var out = padNum < 8 ? 1 : 0
  len = Math.min(sig.length, pad.length)
  if (sig.length !== pad.length) out = 1

  i = -1
  while (++i < len) out |= sig[i] ^ pad[i]
  return out === 0
}

function ecVerify (sig, hash, pub) {
  var curveId = curves[pub.data.algorithm.curve.join('.')]
  if (!curveId) throw new Error('unknown curve ' + pub.data.algorithm.curve.join('.'))

  var curve = new EC(curveId)
  var pubkey = pub.data.subjectPrivateKey.data

  return curve.verify(hash, sig, pubkey)
}

function dsaVerify (sig, hash, pub) {
  var p = pub.data.p
  var q = pub.data.q
  var g = pub.data.g
  var y = pub.data.pub_key
  var unpacked = parseKeys.signature.decode(sig, 'der')
  var s = unpacked.s
  var r = unpacked.r
  checkValue(s, q)
  checkValue(r, q)
  var montp = BN.mont(p)
  var w = s.invm(q)
  var v = g.toRed(montp)
    .redPow(new BN(hash).mul(w).mod(q))
    .fromRed()
    .mul(y.toRed(montp).redPow(r.mul(w).mod(q)).fromRed())
    .mod(p)
    .mod(q)
  return v.cmp(r) === 0
}

function checkValue (b, q) {
  if (b.cmpn(0) <= 0) throw new Error('invalid sig')
  if (b.cmp(q) >= q) throw new Error('invalid sig')
}

module.exports = verify

}).call(this,require("buffer").Buffer)
},{"./curves.json":156,"bn.js":130,"buffer":162,"elliptic":184,"parse-asn1":298}],160:[function(require,module,exports){
arguments[4][132][0].apply(exports,arguments)
},{"dup":132}],161:[function(require,module,exports){
(function (Buffer){
module.exports = function xor (a, b) {
  var length = Math.min(a.length, b.length)
  var buffer = new Buffer(length)

  for (var i = 0; i < length; ++i) {
    buffer[i] = a[i] ^ b[i]
  }

  return buffer
}

}).call(this,require("buffer").Buffer)
},{"buffer":162}],162:[function(require,module,exports){
(function (Buffer){
/*!
 * The buffer module from node.js, for the browser.
 *
 * @author   Feross Aboukhadijeh <https://feross.org>
 * @license  MIT
 */
/* eslint-disable no-proto */

'use strict'

var base64 = require('base64-js')
var ieee754 = require('ieee754')

exports.Buffer = Buffer
exports.SlowBuffer = SlowBuffer
exports.INSPECT_MAX_BYTES = 50

var K_MAX_LENGTH = 0x7fffffff
exports.kMaxLength = K_MAX_LENGTH

/**
 * If `Buffer.TYPED_ARRAY_SUPPORT`:
 *   === true    Use Uint8Array implementation (fastest)
 *   === false   Print warning and recommend using `buffer` v4.x which has an Object
 *               implementation (most compatible, even IE6)
 *
 * Browsers that support typed arrays are IE 10+, Firefox 4+, Chrome 7+, Safari 5.1+,
 * Opera 11.6+, iOS 4.2+.
 *
 * We report that the browser does not support typed arrays if the are not subclassable
 * using __proto__. Firefox 4-29 lacks support for adding new properties to `Uint8Array`
 * (See: https://bugzilla.mozilla.org/show_bug.cgi?id=695438). IE 10 lacks support
 * for __proto__ and has a buggy typed array implementation.
 */
Buffer.TYPED_ARRAY_SUPPORT = typedArraySupport()

if (!Buffer.TYPED_ARRAY_SUPPORT && typeof console !== 'undefined' &&
    typeof console.error === 'function') {
  console.error(
    'This browser lacks typed array (Uint8Array) support which is required by ' +
    '`buffer` v5.x. Use `buffer` v4.x if you require old browser support.'
  )
}

function typedArraySupport () {
  // Can typed array instances can be augmented?
  try {
    var arr = new Uint8Array(1)
    arr.__proto__ = { __proto__: Uint8Array.prototype, foo: function () { return 42 } }
    return arr.foo() === 42
  } catch (e) {
    return false
  }
}

Object.defineProperty(Buffer.prototype, 'parent', {
  enumerable: true,
  get: function () {
    if (!Buffer.isBuffer(this)) return undefined
    return this.buffer
  }
})

Object.defineProperty(Buffer.prototype, 'offset', {
  enumerable: true,
  get: function () {
    if (!Buffer.isBuffer(this)) return undefined
    return this.byteOffset
  }
})

function createBuffer (length) {
  if (length > K_MAX_LENGTH) {
    throw new RangeError('The value "' + length + '" is invalid for option "size"')
  }
  // Return an augmented `Uint8Array` instance
  var buf = new Uint8Array(length)
  buf.__proto__ = Buffer.prototype
  return buf
}

/**
 * The Buffer constructor returns instances of `Uint8Array` that have their
 * prototype changed to `Buffer.prototype`. Furthermore, `Buffer` is a subclass of
 * `Uint8Array`, so the returned instances will have all the node `Buffer` methods
 * and the `Uint8Array` methods. Square bracket notation works as expected -- it
 * returns a single octet.
 *
 * The `Uint8Array` prototype remains unmodified.
 */

function Buffer (arg, encodingOrOffset, length) {
  // Common case.
  if (typeof arg === 'number') {
    if (typeof encodingOrOffset === 'string') {
      throw new TypeError(
        'The "string" argument must be of type string. Received type number'
      )
    }
    return allocUnsafe(arg)
  }
  return from(arg, encodingOrOffset, length)
}

// Fix subarray() in ES2016. See: https://github.com/feross/buffer/pull/97
if (typeof Symbol !== 'undefined' && Symbol.species != null &&
    Buffer[Symbol.species] === Buffer) {
  Object.defineProperty(Buffer, Symbol.species, {
    value: null,
    configurable: true,
    enumerable: false,
    writable: false
  })
}

Buffer.poolSize = 8192 // not used by this implementation

function from (value, encodingOrOffset, length) {
  if (typeof value === 'string') {
    return fromString(value, encodingOrOffset)
  }

  if (ArrayBuffer.isView(value)) {
    return fromArrayLike(value)
  }

  if (value == null) {
    throw TypeError(
      'The first argument must be one of type string, Buffer, ArrayBuffer, Array, ' +
      'or Array-like Object. Received type ' + (typeof value)
    )
  }

  if (isInstance(value, ArrayBuffer) ||
      (value && isInstance(value.buffer, ArrayBuffer))) {
    return fromArrayBuffer(value, encodingOrOffset, length)
  }

  if (typeof value === 'number') {
    throw new TypeError(
      'The "value" argument must not be of type number. Received type number'
    )
  }

  var valueOf = value.valueOf && value.valueOf()
  if (valueOf != null && valueOf !== value) {
    return Buffer.from(valueOf, encodingOrOffset, length)
  }

  var b = fromObject(value)
  if (b) return b

  if (typeof Symbol !== 'undefined' && Symbol.toPrimitive != null &&
      typeof value[Symbol.toPrimitive] === 'function') {
    return Buffer.from(
      value[Symbol.toPrimitive]('string'), encodingOrOffset, length
    )
  }

  throw new TypeError(
    'The first argument must be one of type string, Buffer, ArrayBuffer, Array, ' +
    'or Array-like Object. Received type ' + (typeof value)
  )
}

/**
 * Functionally equivalent to Buffer(arg, encoding) but throws a TypeError
 * if value is a number.
 * Buffer.from(str[, encoding])
 * Buffer.from(array)
 * Buffer.from(buffer)
 * Buffer.from(arrayBuffer[, byteOffset[, length]])
 **/
Buffer.from = function (value, encodingOrOffset, length) {
  return from(value, encodingOrOffset, length)
}

// Note: Change prototype *after* Buffer.from is defined to workaround Chrome bug:
// https://github.com/feross/buffer/pull/148
Buffer.prototype.__proto__ = Uint8Array.prototype
Buffer.__proto__ = Uint8Array

function assertSize (size) {
  if (typeof size !== 'number') {
    throw new TypeError('"size" argument must be of type number')
  } else if (size < 0) {
    throw new RangeError('The value "' + size + '" is invalid for option "size"')
  }
}

function alloc (size, fill, encoding) {
  assertSize(size)
  if (size <= 0) {
    return createBuffer(size)
  }
  if (fill !== undefined) {
    // Only pay attention to encoding if it's a string. This
    // prevents accidentally sending in a number that would
    // be interpretted as a start offset.
    return typeof encoding === 'string'
      ? createBuffer(size).fill(fill, encoding)
      : createBuffer(size).fill(fill)
  }
  return createBuffer(size)
}

/**
 * Creates a new filled Buffer instance.
 * alloc(size[, fill[, encoding]])
 **/
Buffer.alloc = function (size, fill, encoding) {
  return alloc(size, fill, encoding)
}

function allocUnsafe (size) {
  assertSize(size)
  return createBuffer(size < 0 ? 0 : checked(size) | 0)
}

/**
 * Equivalent to Buffer(num), by default creates a non-zero-filled Buffer instance.
 * */
Buffer.allocUnsafe = function (size) {
  return allocUnsafe(size)
}
/**
 * Equivalent to SlowBuffer(num), by default creates a non-zero-filled Buffer instance.
 */
Buffer.allocUnsafeSlow = function (size) {
  return allocUnsafe(size)
}

function fromString (string, encoding) {
  if (typeof encoding !== 'string' || encoding === '') {
    encoding = 'utf8'
  }

  if (!Buffer.isEncoding(encoding)) {
    throw new TypeError('Unknown encoding: ' + encoding)
  }

  var length = byteLength(string, encoding) | 0
  var buf = createBuffer(length)

  var actual = buf.write(string, encoding)

  if (actual !== length) {
    // Writing a hex string, for example, that contains invalid characters will
    // cause everything after the first invalid character to be ignored. (e.g.
    // 'abxxcd' will be treated as 'ab')
    buf = buf.slice(0, actual)
  }

  return buf
}

function fromArrayLike (array) {
  var length = array.length < 0 ? 0 : checked(array.length) | 0
  var buf = createBuffer(length)
  for (var i = 0; i < length; i += 1) {
    buf[i] = array[i] & 255
  }
  return buf
}

function fromArrayBuffer (array, byteOffset, length) {
  if (byteOffset < 0 || array.byteLength < byteOffset) {
    throw new RangeError('"offset" is outside of buffer bounds')
  }

  if (array.byteLength < byteOffset + (length || 0)) {
    throw new RangeError('"length" is outside of buffer bounds')
  }

  var buf
  if (byteOffset === undefined && length === undefined) {
    buf = new Uint8Array(array)
  } else if (length === undefined) {
    buf = new Uint8Array(array, byteOffset)
  } else {
    buf = new Uint8Array(array, byteOffset, length)
  }

  // Return an augmented `Uint8Array` instance
  buf.__proto__ = Buffer.prototype
  return buf
}

function fromObject (obj) {
  if (Buffer.isBuffer(obj)) {
    var len = checked(obj.length) | 0
    var buf = createBuffer(len)

    if (buf.length === 0) {
      return buf
    }

    obj.copy(buf, 0, 0, len)
    return buf
  }

  if (obj.length !== undefined) {
    if (typeof obj.length !== 'number' || numberIsNaN(obj.length)) {
      return createBuffer(0)
    }
    return fromArrayLike(obj)
  }

  if (obj.type === 'Buffer' && Array.isArray(obj.data)) {
    return fromArrayLike(obj.data)
  }
}

function checked (length) {
  // Note: cannot use `length < K_MAX_LENGTH` here because that fails when
  // length is NaN (which is otherwise coerced to zero.)
  if (length >= K_MAX_LENGTH) {
    throw new RangeError('Attempt to allocate Buffer larger than maximum ' +
                         'size: 0x' + K_MAX_LENGTH.toString(16) + ' bytes')
  }
  return length | 0
}

function SlowBuffer (length) {
  if (+length != length) { // eslint-disable-line eqeqeq
    length = 0
  }
  return Buffer.alloc(+length)
}

Buffer.isBuffer = function isBuffer (b) {
  return b != null && b._isBuffer === true &&
    b !== Buffer.prototype // so Buffer.isBuffer(Buffer.prototype) will be false
}

Buffer.compare = function compare (a, b) {
  if (isInstance(a, Uint8Array)) a = Buffer.from(a, a.offset, a.byteLength)
  if (isInstance(b, Uint8Array)) b = Buffer.from(b, b.offset, b.byteLength)
  if (!Buffer.isBuffer(a) || !Buffer.isBuffer(b)) {
    throw new TypeError(
      'The "buf1", "buf2" arguments must be one of type Buffer or Uint8Array'
    )
  }

  if (a === b) return 0

  var x = a.length
  var y = b.length

  for (var i = 0, len = Math.min(x, y); i < len; ++i) {
    if (a[i] !== b[i]) {
      x = a[i]
      y = b[i]
      break
    }
  }

  if (x < y) return -1
  if (y < x) return 1
  return 0
}

Buffer.isEncoding = function isEncoding (encoding) {
  switch (String(encoding).toLowerCase()) {
    case 'hex':
    case 'utf8':
    case 'utf-8':
    case 'ascii':
    case 'latin1':
    case 'binary':
    case 'base64':
    case 'ucs2':
    case 'ucs-2':
    case 'utf16le':
    case 'utf-16le':
      return true
    default:
      return false
  }
}

Buffer.concat = function concat (list, length) {
  if (!Array.isArray(list)) {
    throw new TypeError('"list" argument must be an Array of Buffers')
  }

  if (list.length === 0) {
    return Buffer.alloc(0)
  }

  var i
  if (length === undefined) {
    length = 0
    for (i = 0; i < list.length; ++i) {
      length += list[i].length
    }
  }

  var buffer = Buffer.allocUnsafe(length)
  var pos = 0
  for (i = 0; i < list.length; ++i) {
    var buf = list[i]
    if (isInstance(buf, Uint8Array)) {
      buf = Buffer.from(buf)
    }
    if (!Buffer.isBuffer(buf)) {
      throw new TypeError('"list" argument must be an Array of Buffers')
    }
    buf.copy(buffer, pos)
    pos += buf.length
  }
  return buffer
}

function byteLength (string, encoding) {
  if (Buffer.isBuffer(string)) {
    return string.length
  }
  if (ArrayBuffer.isView(string) || isInstance(string, ArrayBuffer)) {
    return string.byteLength
  }
  if (typeof string !== 'string') {
    throw new TypeError(
      'The "string" argument must be one of type string, Buffer, or ArrayBuffer. ' +
      'Received type ' + typeof string
    )
  }

  var len = string.length
  var mustMatch = (arguments.length > 2 && arguments[2] === true)
  if (!mustMatch && len === 0) return 0

  // Use a for loop to avoid recursion
  var loweredCase = false
  for (;;) {
    switch (encoding) {
      case 'ascii':
      case 'latin1':
      case 'binary':
        return len
      case 'utf8':
      case 'utf-8':
        return utf8ToBytes(string).length
      case 'ucs2':
      case 'ucs-2':
      case 'utf16le':
      case 'utf-16le':
        return len * 2
      case 'hex':
        return len >>> 1
      case 'base64':
        return base64ToBytes(string).length
      default:
        if (loweredCase) {
          return mustMatch ? -1 : utf8ToBytes(string).length // assume utf8
        }
        encoding = ('' + encoding).toLowerCase()
        loweredCase = true
    }
  }
}
Buffer.byteLength = byteLength

function slowToString (encoding, start, end) {
  var loweredCase = false

  // No need to verify that "this.length <= MAX_UINT32" since it's a read-only
  // property of a typed array.

  // This behaves neither like String nor Uint8Array in that we set start/end
  // to their upper/lower bounds if the value passed is out of range.
  // undefined is handled specially as per ECMA-262 6th Edition,
  // Section 13.3.3.7 Runtime Semantics: KeyedBindingInitialization.
  if (start === undefined || start < 0) {
    start = 0
  }
  // Return early if start > this.length. Done here to prevent potential uint32
  // coercion fail below.
  if (start > this.length) {
    return ''
  }

  if (end === undefined || end > this.length) {
    end = this.length
  }

  if (end <= 0) {
    return ''
  }

  // Force coersion to uint32. This will also coerce falsey/NaN values to 0.
  end >>>= 0
  start >>>= 0

  if (end <= start) {
    return ''
  }

  if (!encoding) encoding = 'utf8'

  while (true) {
    switch (encoding) {
      case 'hex':
        return hexSlice(this, start, end)

      case 'utf8':
      case 'utf-8':
        return utf8Slice(this, start, end)

      case 'ascii':
        return asciiSlice(this, start, end)

      case 'latin1':
      case 'binary':
        return latin1Slice(this, start, end)

      case 'base64':
        return base64Slice(this, start, end)

      case 'ucs2':
      case 'ucs-2':
      case 'utf16le':
      case 'utf-16le':
        return utf16leSlice(this, start, end)

      default:
        if (loweredCase) throw new TypeError('Unknown encoding: ' + encoding)
        encoding = (encoding + '').toLowerCase()
        loweredCase = true
    }
  }
}

// This property is used by `Buffer.isBuffer` (and the `is-buffer` npm package)
// to detect a Buffer instance. It's not possible to use `instanceof Buffer`
// reliably in a browserify context because there could be multiple different
// copies of the 'buffer' package in use. This method works even for Buffer
// instances that were created from another copy of the `buffer` package.
// See: https://github.com/feross/buffer/issues/154
Buffer.prototype._isBuffer = true

function swap (b, n, m) {
  var i = b[n]
  b[n] = b[m]
  b[m] = i
}

Buffer.prototype.swap16 = function swap16 () {
  var len = this.length
  if (len % 2 !== 0) {
    throw new RangeError('Buffer size must be a multiple of 16-bits')
  }
  for (var i = 0; i < len; i += 2) {
    swap(this, i, i + 1)
  }
  return this
}

Buffer.prototype.swap32 = function swap32 () {
  var len = this.length
  if (len % 4 !== 0) {
    throw new RangeError('Buffer size must be a multiple of 32-bits')
  }
  for (var i = 0; i < len; i += 4) {
    swap(this, i, i + 3)
    swap(this, i + 1, i + 2)
  }
  return this
}

Buffer.prototype.swap64 = function swap64 () {
  var len = this.length
  if (len % 8 !== 0) {
    throw new RangeError('Buffer size must be a multiple of 64-bits')
  }
  for (var i = 0; i < len; i += 8) {
    swap(this, i, i + 7)
    swap(this, i + 1, i + 6)
    swap(this, i + 2, i + 5)
    swap(this, i + 3, i + 4)
  }
  return this
}

Buffer.prototype.toString = function toString () {
  var length = this.length
  if (length === 0) return ''
  if (arguments.length === 0) return utf8Slice(this, 0, length)
  return slowToString.apply(this, arguments)
}

Buffer.prototype.toLocaleString = Buffer.prototype.toString

Buffer.prototype.equals = function equals (b) {
  if (!Buffer.isBuffer(b)) throw new TypeError('Argument must be a Buffer')
  if (this === b) return true
  return Buffer.compare(this, b) === 0
}

Buffer.prototype.inspect = function inspect () {
  var str = ''
  var max = exports.INSPECT_MAX_BYTES
  str = this.toString('hex', 0, max).replace(/(.{2})/g, '$1 ').trim()
  if (this.length > max) str += ' ... '
  return '<Buffer ' + str + '>'
}

Buffer.prototype.compare = function compare (target, start, end, thisStart, thisEnd) {
  if (isInstance(target, Uint8Array)) {
    target = Buffer.from(target, target.offset, target.byteLength)
  }
  if (!Buffer.isBuffer(target)) {
    throw new TypeError(
      'The "target" argument must be one of type Buffer or Uint8Array. ' +
      'Received type ' + (typeof target)
    )
  }

  if (start === undefined) {
    start = 0
  }
  if (end === undefined) {
    end = target ? target.length : 0
  }
  if (thisStart === undefined) {
    thisStart = 0
  }
  if (thisEnd === undefined) {
    thisEnd = this.length
  }

  if (start < 0 || end > target.length || thisStart < 0 || thisEnd > this.length) {
    throw new RangeError('out of range index')
  }

  if (thisStart >= thisEnd && start >= end) {
    return 0
  }
  if (thisStart >= thisEnd) {
    return -1
  }
  if (start >= end) {
    return 1
  }

  start >>>= 0
  end >>>= 0
  thisStart >>>= 0
  thisEnd >>>= 0

  if (this === target) return 0

  var x = thisEnd - thisStart
  var y = end - start
  var len = Math.min(x, y)

  var thisCopy = this.slice(thisStart, thisEnd)
  var targetCopy = target.slice(start, end)

  for (var i = 0; i < len; ++i) {
    if (thisCopy[i] !== targetCopy[i]) {
      x = thisCopy[i]
      y = targetCopy[i]
      break
    }
  }

  if (x < y) return -1
  if (y < x) return 1
  return 0
}

// Finds either the first index of `val` in `buffer` at offset >= `byteOffset`,
// OR the last index of `val` in `buffer` at offset <= `byteOffset`.
//
// Arguments:
// - buffer - a Buffer to search
// - val - a string, Buffer, or number
// - byteOffset - an index into `buffer`; will be clamped to an int32
// - encoding - an optional encoding, relevant is val is a string
// - dir - true for indexOf, false for lastIndexOf
function bidirectionalIndexOf (buffer, val, byteOffset, encoding, dir) {
  // Empty buffer means no match
  if (buffer.length === 0) return -1

  // Normalize byteOffset
  if (typeof byteOffset === 'string') {
    encoding = byteOffset
    byteOffset = 0
  } else if (byteOffset > 0x7fffffff) {
    byteOffset = 0x7fffffff
  } else if (byteOffset < -0x80000000) {
    byteOffset = -0x80000000
  }
  byteOffset = +byteOffset // Coerce to Number.
  if (numberIsNaN(byteOffset)) {
    // byteOffset: it it's undefined, null, NaN, "foo", etc, search whole buffer
    byteOffset = dir ? 0 : (buffer.length - 1)
  }

  // Normalize byteOffset: negative offsets start from the end of the buffer
  if (byteOffset < 0) byteOffset = buffer.length + byteOffset
  if (byteOffset >= buffer.length) {
    if (dir) return -1
    else byteOffset = buffer.length - 1
  } else if (byteOffset < 0) {
    if (dir) byteOffset = 0
    else return -1
  }

  // Normalize val
  if (typeof val === 'string') {
    val = Buffer.from(val, encoding)
  }

  // Finally, search either indexOf (if dir is true) or lastIndexOf
  if (Buffer.isBuffer(val)) {
    // Special case: looking for empty string/buffer always fails
    if (val.length === 0) {
      return -1
    }
    return arrayIndexOf(buffer, val, byteOffset, encoding, dir)
  } else if (typeof val === 'number') {
    val = val & 0xFF // Search for a byte value [0-255]
    if (typeof Uint8Array.prototype.indexOf === 'function') {
      if (dir) {
        return Uint8Array.prototype.indexOf.call(buffer, val, byteOffset)
      } else {
        return Uint8Array.prototype.lastIndexOf.call(buffer, val, byteOffset)
      }
    }
    return arrayIndexOf(buffer, [ val ], byteOffset, encoding, dir)
  }

  throw new TypeError('val must be string, number or Buffer')
}

function arrayIndexOf (arr, val, byteOffset, encoding, dir) {
  var indexSize = 1
  var arrLength = arr.length
  var valLength = val.length

  if (encoding !== undefined) {
    encoding = String(encoding).toLowerCase()
    if (encoding === 'ucs2' || encoding === 'ucs-2' ||
        encoding === 'utf16le' || encoding === 'utf-16le') {
      if (arr.length < 2 || val.length < 2) {
        return -1
      }
      indexSize = 2
      arrLength /= 2
      valLength /= 2
      byteOffset /= 2
    }
  }

  function read (buf, i) {
    if (indexSize === 1) {
      return buf[i]
    } else {
      return buf.readUInt16BE(i * indexSize)
    }
  }

  var i
  if (dir) {
    var foundIndex = -1
    for (i = byteOffset; i < arrLength; i++) {
      if (read(arr, i) === read(val, foundIndex === -1 ? 0 : i - foundIndex)) {
        if (foundIndex === -1) foundIndex = i
        if (i - foundIndex + 1 === valLength) return foundIndex * indexSize
      } else {
        if (foundIndex !== -1) i -= i - foundIndex
        foundIndex = -1
      }
    }
  } else {
    if (byteOffset + valLength > arrLength) byteOffset = arrLength - valLength
    for (i = byteOffset; i >= 0; i--) {
      var found = true
      for (var j = 0; j < valLength; j++) {
        if (read(arr, i + j) !== read(val, j)) {
          found = false
          break
        }
      }
      if (found) return i
    }
  }

  return -1
}

Buffer.prototype.includes = function includes (val, byteOffset, encoding) {
  return this.indexOf(val, byteOffset, encoding) !== -1
}

Buffer.prototype.indexOf = function indexOf (val, byteOffset, encoding) {
  return bidirectionalIndexOf(this, val, byteOffset, encoding, true)
}

Buffer.prototype.lastIndexOf = function lastIndexOf (val, byteOffset, encoding) {
  return bidirectionalIndexOf(this, val, byteOffset, encoding, false)
}

function hexWrite (buf, string, offset, length) {
  offset = Number(offset) || 0
  var remaining = buf.length - offset
  if (!length) {
    length = remaining
  } else {
    length = Number(length)
    if (length > remaining) {
      length = remaining
    }
  }

  var strLen = string.length

  if (length > strLen / 2) {
    length = strLen / 2
  }
  for (var i = 0; i < length; ++i) {
    var parsed = parseInt(string.substr(i * 2, 2), 16)
    if (numberIsNaN(parsed)) return i
    buf[offset + i] = parsed
  }
  return i
}

function utf8Write (buf, string, offset, length) {
  return blitBuffer(utf8ToBytes(string, buf.length - offset), buf, offset, length)
}

function asciiWrite (buf, string, offset, length) {
  return blitBuffer(asciiToBytes(string), buf, offset, length)
}

function latin1Write (buf, string, offset, length) {
  return asciiWrite(buf, string, offset, length)
}

function base64Write (buf, string, offset, length) {
  return blitBuffer(base64ToBytes(string), buf, offset, length)
}

function ucs2Write (buf, string, offset, length) {
  return blitBuffer(utf16leToBytes(string, buf.length - offset), buf, offset, length)
}

Buffer.prototype.write = function write (string, offset, length, encoding) {
  // Buffer#write(string)
  if (offset === undefined) {
    encoding = 'utf8'
    length = this.length
    offset = 0
  // Buffer#write(string, encoding)
  } else if (length === undefined && typeof offset === 'string') {
    encoding = offset
    length = this.length
    offset = 0
  // Buffer#write(string, offset[, length][, encoding])
  } else if (isFinite(offset)) {
    offset = offset >>> 0
    if (isFinite(length)) {
      length = length >>> 0
      if (encoding === undefined) encoding = 'utf8'
    } else {
      encoding = length
      length = undefined
    }
  } else {
    throw new Error(
      'Buffer.write(string, encoding, offset[, length]) is no longer supported'
    )
  }

  var remaining = this.length - offset
  if (length === undefined || length > remaining) length = remaining

  if ((string.length > 0 && (length < 0 || offset < 0)) || offset > this.length) {
    throw new RangeError('Attempt to write outside buffer bounds')
  }

  if (!encoding) encoding = 'utf8'

  var loweredCase = false
  for (;;) {
    switch (encoding) {
      case 'hex':
        return hexWrite(this, string, offset, length)

      case 'utf8':
      case 'utf-8':
        return utf8Write(this, string, offset, length)

      case 'ascii':
        return asciiWrite(this, string, offset, length)

      case 'latin1':
      case 'binary':
        return latin1Write(this, string, offset, length)

      case 'base64':
        // Warning: maxLength not taken into account in base64Write
        return base64Write(this, string, offset, length)

      case 'ucs2':
      case 'ucs-2':
      case 'utf16le':
      case 'utf-16le':
        return ucs2Write(this, string, offset, length)

      default:
        if (loweredCase) throw new TypeError('Unknown encoding: ' + encoding)
        encoding = ('' + encoding).toLowerCase()
        loweredCase = true
    }
  }
}

Buffer.prototype.toJSON = function toJSON () {
  return {
    type: 'Buffer',
    data: Array.prototype.slice.call(this._arr || this, 0)
  }
}

function base64Slice (buf, start, end) {
  if (start === 0 && end === buf.length) {
    return base64.fromByteArray(buf)
  } else {
    return base64.fromByteArray(buf.slice(start, end))
  }
}

function utf8Slice (buf, start, end) {
  end = Math.min(buf.length, end)
  var res = []

  var i = start
  while (i < end) {
    var firstByte = buf[i]
    var codePoint = null
    var bytesPerSequence = (firstByte > 0xEF) ? 4
      : (firstByte > 0xDF) ? 3
        : (firstByte > 0xBF) ? 2
          : 1

    if (i + bytesPerSequence <= end) {
      var secondByte, thirdByte, fourthByte, tempCodePoint

      switch (bytesPerSequence) {
        case 1:
          if (firstByte < 0x80) {
            codePoint = firstByte
          }
          break
        case 2:
          secondByte = buf[i + 1]
          if ((secondByte & 0xC0) === 0x80) {
            tempCodePoint = (firstByte & 0x1F) << 0x6 | (secondByte & 0x3F)
            if (tempCodePoint > 0x7F) {
              codePoint = tempCodePoint
            }
          }
          break
        case 3:
          secondByte = buf[i + 1]
          thirdByte = buf[i + 2]
          if ((secondByte & 0xC0) === 0x80 && (thirdByte & 0xC0) === 0x80) {
            tempCodePoint = (firstByte & 0xF) << 0xC | (secondByte & 0x3F) << 0x6 | (thirdByte & 0x3F)
            if (tempCodePoint > 0x7FF && (tempCodePoint < 0xD800 || tempCodePoint > 0xDFFF)) {
              codePoint = tempCodePoint
            }
          }
          break
        case 4:
          secondByte = buf[i + 1]
          thirdByte = buf[i + 2]
          fourthByte = buf[i + 3]
          if ((secondByte & 0xC0) === 0x80 && (thirdByte & 0xC0) === 0x80 && (fourthByte & 0xC0) === 0x80) {
            tempCodePoint = (firstByte & 0xF) << 0x12 | (secondByte & 0x3F) << 0xC | (thirdByte & 0x3F) << 0x6 | (fourthByte & 0x3F)
            if (tempCodePoint > 0xFFFF && tempCodePoint < 0x110000) {
              codePoint = tempCodePoint
            }
          }
      }
    }

    if (codePoint === null) {
      // we did not generate a valid codePoint so insert a
      // replacement char (U+FFFD) and advance only 1 byte
      codePoint = 0xFFFD
      bytesPerSequence = 1
    } else if (codePoint > 0xFFFF) {
      // encode to utf16 (surrogate pair dance)
      codePoint -= 0x10000
      res.push(codePoint >>> 10 & 0x3FF | 0xD800)
      codePoint = 0xDC00 | codePoint & 0x3FF
    }

    res.push(codePoint)
    i += bytesPerSequence
  }

  return decodeCodePointsArray(res)
}

// Based on http://stackoverflow.com/a/22747272/680742, the browser with
// the lowest limit is Chrome, with 0x10000 args.
// We go 1 magnitude less, for safety
var MAX_ARGUMENTS_LENGTH = 0x1000

function decodeCodePointsArray (codePoints) {
  var len = codePoints.length
  if (len <= MAX_ARGUMENTS_LENGTH) {
    return String.fromCharCode.apply(String, codePoints) // avoid extra slice()
  }

  // Decode in chunks to avoid "call stack size exceeded".
  var res = ''
  var i = 0
  while (i < len) {
    res += String.fromCharCode.apply(
      String,
      codePoints.slice(i, i += MAX_ARGUMENTS_LENGTH)
    )
  }
  return res
}

function asciiSlice (buf, start, end) {
  var ret = ''
  end = Math.min(buf.length, end)

  for (var i = start; i < end; ++i) {
    ret += String.fromCharCode(buf[i] & 0x7F)
  }
  return ret
}

function latin1Slice (buf, start, end) {
  var ret = ''
  end = Math.min(buf.length, end)

  for (var i = start; i < end; ++i) {
    ret += String.fromCharCode(buf[i])
  }
  return ret
}

function hexSlice (buf, start, end) {
  var len = buf.length

  if (!start || start < 0) start = 0
  if (!end || end < 0 || end > len) end = len

  var out = ''
  for (var i = start; i < end; ++i) {
    out += toHex(buf[i])
  }
  return out
}

function utf16leSlice (buf, start, end) {
  var bytes = buf.slice(start, end)
  var res = ''
  for (var i = 0; i < bytes.length; i += 2) {
    res += String.fromCharCode(bytes[i] + (bytes[i + 1] * 256))
  }
  return res
}

Buffer.prototype.slice = function slice (start, end) {
  var len = this.length
  start = ~~start
  end = end === undefined ? len : ~~end

  if (start < 0) {
    start += len
    if (start < 0) start = 0
  } else if (start > len) {
    start = len
  }

  if (end < 0) {
    end += len
    if (end < 0) end = 0
  } else if (end > len) {
    end = len
  }

  if (end < start) end = start

  var newBuf = this.subarray(start, end)
  // Return an augmented `Uint8Array` instance
  newBuf.__proto__ = Buffer.prototype
  return newBuf
}

/*
 * Need to make sure that buffer isn't trying to write out of bounds.
 */
function checkOffset (offset, ext, length) {
  if ((offset % 1) !== 0 || offset < 0) throw new RangeError('offset is not uint')
  if (offset + ext > length) throw new RangeError('Trying to access beyond buffer length')
}

Buffer.prototype.readUIntLE = function readUIntLE (offset, byteLength, noAssert) {
  offset = offset >>> 0
  byteLength = byteLength >>> 0
  if (!noAssert) checkOffset(offset, byteLength, this.length)

  var val = this[offset]
  var mul = 1
  var i = 0
  while (++i < byteLength && (mul *= 0x100)) {
    val += this[offset + i] * mul
  }

  return val
}

Buffer.prototype.readUIntBE = function readUIntBE (offset, byteLength, noAssert) {
  offset = offset >>> 0
  byteLength = byteLength >>> 0
  if (!noAssert) {
    checkOffset(offset, byteLength, this.length)
  }

  var val = this[offset + --byteLength]
  var mul = 1
  while (byteLength > 0 && (mul *= 0x100)) {
    val += this[offset + --byteLength] * mul
  }

  return val
}

Buffer.prototype.readUInt8 = function readUInt8 (offset, noAssert) {
  offset = offset >>> 0
  if (!noAssert) checkOffset(offset, 1, this.length)
  return this[offset]
}

Buffer.prototype.readUInt16LE = function readUInt16LE (offset, noAssert) {
  offset = offset >>> 0
  if (!noAssert) checkOffset(offset, 2, this.length)
  return this[offset] | (this[offset + 1] << 8)
}

Buffer.prototype.readUInt16BE = function readUInt16BE (offset, noAssert) {
  offset = offset >>> 0
  if (!noAssert) checkOffset(offset, 2, this.length)
  return (this[offset] << 8) | this[offset + 1]
}

Buffer.prototype.readUInt32LE = function readUInt32LE (offset, noAssert) {
  offset = offset >>> 0
  if (!noAssert) checkOffset(offset, 4, this.length)

  return ((this[offset]) |
      (this[offset + 1] << 8) |
      (this[offset + 2] << 16)) +
      (this[offset + 3] * 0x1000000)
}

Buffer.prototype.readUInt32BE = function readUInt32BE (offset, noAssert) {
  offset = offset >>> 0
  if (!noAssert) checkOffset(offset, 4, this.length)

  return (this[offset] * 0x1000000) +
    ((this[offset + 1] << 16) |
    (this[offset + 2] << 8) |
    this[offset + 3])
}

Buffer.prototype.readIntLE = function readIntLE (offset, byteLength, noAssert) {
  offset = offset >>> 0
  byteLength = byteLength >>> 0
  if (!noAssert) checkOffset(offset, byteLength, this.length)

  var val = this[offset]
  var mul = 1
  var i = 0
  while (++i < byteLength && (mul *= 0x100)) {
    val += this[offset + i] * mul
  }
  mul *= 0x80

  if (val >= mul) val -= Math.pow(2, 8 * byteLength)

  return val
}

Buffer.prototype.readIntBE = function readIntBE (offset, byteLength, noAssert) {
  offset = offset >>> 0
  byteLength = byteLength >>> 0
  if (!noAssert) checkOffset(offset, byteLength, this.length)

  var i = byteLength
  var mul = 1
  var val = this[offset + --i]
  while (i > 0 && (mul *= 0x100)) {
    val += this[offset + --i] * mul
  }
  mul *= 0x80

  if (val >= mul) val -= Math.pow(2, 8 * byteLength)

  return val
}

Buffer.prototype.readInt8 = function readInt8 (offset, noAssert) {
  offset = offset >>> 0
  if (!noAssert) checkOffset(offset, 1, this.length)
  if (!(this[offset] & 0x80)) return (this[offset])
  return ((0xff - this[offset] + 1) * -1)
}

Buffer.prototype.readInt16LE = function readInt16LE (offset, noAssert) {
  offset = offset >>> 0
  if (!noAssert) checkOffset(offset, 2, this.length)
  var val = this[offset] | (this[offset + 1] << 8)
  return (val & 0x8000) ? val | 0xFFFF0000 : val
}

Buffer.prototype.readInt16BE = function readInt16BE (offset, noAssert) {
  offset = offset >>> 0
  if (!noAssert) checkOffset(offset, 2, this.length)
  var val = this[offset + 1] | (this[offset] << 8)
  return (val & 0x8000) ? val | 0xFFFF0000 : val
}

Buffer.prototype.readInt32LE = function readInt32LE (offset, noAssert) {
  offset = offset >>> 0
  if (!noAssert) checkOffset(offset, 4, this.length)

  return (this[offset]) |
    (this[offset + 1] << 8) |
    (this[offset + 2] << 16) |
    (this[offset + 3] << 24)
}

Buffer.prototype.readInt32BE = function readInt32BE (offset, noAssert) {
  offset = offset >>> 0
  if (!noAssert) checkOffset(offset, 4, this.length)

  return (this[offset] << 24) |
    (this[offset + 1] << 16) |
    (this[offset + 2] << 8) |
    (this[offset + 3])
}

Buffer.prototype.readFloatLE = function readFloatLE (offset, noAssert) {
  offset = offset >>> 0
  if (!noAssert) checkOffset(offset, 4, this.length)
  return ieee754.read(this, offset, true, 23, 4)
}

Buffer.prototype.readFloatBE = function readFloatBE (offset, noAssert) {
  offset = offset >>> 0
  if (!noAssert) checkOffset(offset, 4, this.length)
  return ieee754.read(this, offset, false, 23, 4)
}

Buffer.prototype.readDoubleLE = function readDoubleLE (offset, noAssert) {
  offset = offset >>> 0
  if (!noAssert) checkOffset(offset, 8, this.length)
  return ieee754.read(this, offset, true, 52, 8)
}

Buffer.prototype.readDoubleBE = function readDoubleBE (offset, noAssert) {
  offset = offset >>> 0
  if (!noAssert) checkOffset(offset, 8, this.length)
  return ieee754.read(this, offset, false, 52, 8)
}

function checkInt (buf, value, offset, ext, max, min) {
  if (!Buffer.isBuffer(buf)) throw new TypeError('"buffer" argument must be a Buffer instance')
  if (value > max || value < min) throw new RangeError('"value" argument is out of bounds')
  if (offset + ext > buf.length) throw new RangeError('Index out of range')
}

Buffer.prototype.writeUIntLE = function writeUIntLE (value, offset, byteLength, noAssert) {
  value = +value
  offset = offset >>> 0
  byteLength = byteLength >>> 0
  if (!noAssert) {
    var maxBytes = Math.pow(2, 8 * byteLength) - 1
    checkInt(this, value, offset, byteLength, maxBytes, 0)
  }

  var mul = 1
  var i = 0
  this[offset] = value & 0xFF
  while (++i < byteLength && (mul *= 0x100)) {
    this[offset + i] = (value / mul) & 0xFF
  }

  return offset + byteLength
}

Buffer.prototype.writeUIntBE = function writeUIntBE (value, offset, byteLength, noAssert) {
  value = +value
  offset = offset >>> 0
  byteLength = byteLength >>> 0
  if (!noAssert) {
    var maxBytes = Math.pow(2, 8 * byteLength) - 1
    checkInt(this, value, offset, byteLength, maxBytes, 0)
  }

  var i = byteLength - 1
  var mul = 1
  this[offset + i] = value & 0xFF
  while (--i >= 0 && (mul *= 0x100)) {
    this[offset + i] = (value / mul) & 0xFF
  }

  return offset + byteLength
}

Buffer.prototype.writeUInt8 = function writeUInt8 (value, offset, noAssert) {
  value = +value
  offset = offset >>> 0
  if (!noAssert) checkInt(this, value, offset, 1, 0xff, 0)
  this[offset] = (value & 0xff)
  return offset + 1
}

Buffer.prototype.writeUInt16LE = function writeUInt16LE (value, offset, noAssert) {
  value = +value
  offset = offset >>> 0
  if (!noAssert) checkInt(this, value, offset, 2, 0xffff, 0)
  this[offset] = (value & 0xff)
  this[offset + 1] = (value >>> 8)
  return offset + 2
}

Buffer.prototype.writeUInt16BE = function writeUInt16BE (value, offset, noAssert) {
  value = +value
  offset = offset >>> 0
  if (!noAssert) checkInt(this, value, offset, 2, 0xffff, 0)
  this[offset] = (value >>> 8)
  this[offset + 1] = (value & 0xff)
  return offset + 2
}

Buffer.prototype.writeUInt32LE = function writeUInt32LE (value, offset, noAssert) {
  value = +value
  offset = offset >>> 0
  if (!noAssert) checkInt(this, value, offset, 4, 0xffffffff, 0)
  this[offset + 3] = (value >>> 24)
  this[offset + 2] = (value >>> 16)
  this[offset + 1] = (value >>> 8)
  this[offset] = (value & 0xff)
  return offset + 4
}

Buffer.prototype.writeUInt32BE = function writeUInt32BE (value, offset, noAssert) {
  value = +value
  offset = offset >>> 0
  if (!noAssert) checkInt(this, value, offset, 4, 0xffffffff, 0)
  this[offset] = (value >>> 24)
  this[offset + 1] = (value >>> 16)
  this[offset + 2] = (value >>> 8)
  this[offset + 3] = (value & 0xff)
  return offset + 4
}

Buffer.prototype.writeIntLE = function writeIntLE (value, offset, byteLength, noAssert) {
  value = +value
  offset = offset >>> 0
  if (!noAssert) {
    var limit = Math.pow(2, (8 * byteLength) - 1)

    checkInt(this, value, offset, byteLength, limit - 1, -limit)
  }

  var i = 0
  var mul = 1
  var sub = 0
  this[offset] = value & 0xFF
  while (++i < byteLength && (mul *= 0x100)) {
    if (value < 0 && sub === 0 && this[offset + i - 1] !== 0) {
      sub = 1
    }
    this[offset + i] = ((value / mul) >> 0) - sub & 0xFF
  }

  return offset + byteLength
}

Buffer.prototype.writeIntBE = function writeIntBE (value, offset, byteLength, noAssert) {
  value = +value
  offset = offset >>> 0
  if (!noAssert) {
    var limit = Math.pow(2, (8 * byteLength) - 1)

    checkInt(this, value, offset, byteLength, limit - 1, -limit)
  }

  var i = byteLength - 1
  var mul = 1
  var sub = 0
  this[offset + i] = value & 0xFF
  while (--i >= 0 && (mul *= 0x100)) {
    if (value < 0 && sub === 0 && this[offset + i + 1] !== 0) {
      sub = 1
    }
    this[offset + i] = ((value / mul) >> 0) - sub & 0xFF
  }

  return offset + byteLength
}

Buffer.prototype.writeInt8 = function writeInt8 (value, offset, noAssert) {
  value = +value
  offset = offset >>> 0
  if (!noAssert) checkInt(this, value, offset, 1, 0x7f, -0x80)
  if (value < 0) value = 0xff + value + 1
  this[offset] = (value & 0xff)
  return offset + 1
}

Buffer.prototype.writeInt16LE = function writeInt16LE (value, offset, noAssert) {
  value = +value
  offset = offset >>> 0
  if (!noAssert) checkInt(this, value, offset, 2, 0x7fff, -0x8000)
  this[offset] = (value & 0xff)
  this[offset + 1] = (value >>> 8)
  return offset + 2
}

Buffer.prototype.writeInt16BE = function writeInt16BE (value, offset, noAssert) {
  value = +value
  offset = offset >>> 0
  if (!noAssert) checkInt(this, value, offset, 2, 0x7fff, -0x8000)
  this[offset] = (value >>> 8)
  this[offset + 1] = (value & 0xff)
  return offset + 2
}

Buffer.prototype.writeInt32LE = function writeInt32LE (value, offset, noAssert) {
  value = +value
  offset = offset >>> 0
  if (!noAssert) checkInt(this, value, offset, 4, 0x7fffffff, -0x80000000)
  this[offset] = (value & 0xff)
  this[offset + 1] = (value >>> 8)
  this[offset + 2] = (value >>> 16)
  this[offset + 3] = (value >>> 24)
  return offset + 4
}

Buffer.prototype.writeInt32BE = function writeInt32BE (value, offset, noAssert) {
  value = +value
  offset = offset >>> 0
  if (!noAssert) checkInt(this, value, offset, 4, 0x7fffffff, -0x80000000)
  if (value < 0) value = 0xffffffff + value + 1
  this[offset] = (value >>> 24)
  this[offset + 1] = (value >>> 16)
  this[offset + 2] = (value >>> 8)
  this[offset + 3] = (value & 0xff)
  return offset + 4
}

function checkIEEE754 (buf, value, offset, ext, max, min) {
  if (offset + ext > buf.length) throw new RangeError('Index out of range')
  if (offset < 0) throw new RangeError('Index out of range')
}

function writeFloat (buf, value, offset, littleEndian, noAssert) {
  value = +value
  offset = offset >>> 0
  if (!noAssert) {
    checkIEEE754(buf, value, offset, 4, 3.4028234663852886e+38, -3.4028234663852886e+38)
  }
  ieee754.write(buf, value, offset, littleEndian, 23, 4)
  return offset + 4
}

Buffer.prototype.writeFloatLE = function writeFloatLE (value, offset, noAssert) {
  return writeFloat(this, value, offset, true, noAssert)
}

Buffer.prototype.writeFloatBE = function writeFloatBE (value, offset, noAssert) {
  return writeFloat(this, value, offset, false, noAssert)
}

function writeDouble (buf, value, offset, littleEndian, noAssert) {
  value = +value
  offset = offset >>> 0
  if (!noAssert) {
    checkIEEE754(buf, value, offset, 8, 1.7976931348623157E+308, -1.7976931348623157E+308)
  }
  ieee754.write(buf, value, offset, littleEndian, 52, 8)
  return offset + 8
}

Buffer.prototype.writeDoubleLE = function writeDoubleLE (value, offset, noAssert) {
  return writeDouble(this, value, offset, true, noAssert)
}

Buffer.prototype.writeDoubleBE = function writeDoubleBE (value, offset, noAssert) {
  return writeDouble(this, value, offset, false, noAssert)
}

// copy(targetBuffer, targetStart=0, sourceStart=0, sourceEnd=buffer.length)
Buffer.prototype.copy = function copy (target, targetStart, start, end) {
  if (!Buffer.isBuffer(target)) throw new TypeError('argument should be a Buffer')
  if (!start) start = 0
  if (!end && end !== 0) end = this.length
  if (targetStart >= target.length) targetStart = target.length
  if (!targetStart) targetStart = 0
  if (end > 0 && end < start) end = start

  // Copy 0 bytes; we're done
  if (end === start) return 0
  if (target.length === 0 || this.length === 0) return 0

  // Fatal error conditions
  if (targetStart < 0) {
    throw new RangeError('targetStart out of bounds')
  }
  if (start < 0 || start >= this.length) throw new RangeError('Index out of range')
  if (end < 0) throw new RangeError('sourceEnd out of bounds')

  // Are we oob?
  if (end > this.length) end = this.length
  if (target.length - targetStart < end - start) {
    end = target.length - targetStart + start
  }

  var len = end - start

  if (this === target && typeof Uint8Array.prototype.copyWithin === 'function') {
    // Use built-in when available, missing from IE11
    this.copyWithin(targetStart, start, end)
  } else if (this === target && start < targetStart && targetStart < end) {
    // descending copy from end
    for (var i = len - 1; i >= 0; --i) {
      target[i + targetStart] = this[i + start]
    }
  } else {
    Uint8Array.prototype.set.call(
      target,
      this.subarray(start, end),
      targetStart
    )
  }

  return len
}

// Usage:
//    buffer.fill(number[, offset[, end]])
//    buffer.fill(buffer[, offset[, end]])
//    buffer.fill(string[, offset[, end]][, encoding])
Buffer.prototype.fill = function fill (val, start, end, encoding) {
  // Handle string cases:
  if (typeof val === 'string') {
    if (typeof start === 'string') {
      encoding = start
      start = 0
      end = this.length
    } else if (typeof end === 'string') {
      encoding = end
      end = this.length
    }
    if (encoding !== undefined && typeof encoding !== 'string') {
      throw new TypeError('encoding must be a string')
    }
    if (typeof encoding === 'string' && !Buffer.isEncoding(encoding)) {
      throw new TypeError('Unknown encoding: ' + encoding)
    }
    if (val.length === 1) {
      var code = val.charCodeAt(0)
      if ((encoding === 'utf8' && code < 128) ||
          encoding === 'latin1') {
        // Fast path: If `val` fits into a single byte, use that numeric value.
        val = code
      }
    }
  } else if (typeof val === 'number') {
    val = val & 255
  }

  // Invalid ranges are not set to a default, so can range check early.
  if (start < 0 || this.length < start || this.length < end) {
    throw new RangeError('Out of range index')
  }

  if (end <= start) {
    return this
  }

  start = start >>> 0
  end = end === undefined ? this.length : end >>> 0

  if (!val) val = 0

  var i
  if (typeof val === 'number') {
    for (i = start; i < end; ++i) {
      this[i] = val
    }
  } else {
    var bytes = Buffer.isBuffer(val)
      ? val
      : Buffer.from(val, encoding)
    var len = bytes.length
    if (len === 0) {
      throw new TypeError('The value "' + val +
        '" is invalid for argument "value"')
    }
    for (i = 0; i < end - start; ++i) {
      this[i + start] = bytes[i % len]
    }
  }

  return this
}

// HELPER FUNCTIONS
// ================

var INVALID_BASE64_RE = /[^+/0-9A-Za-z-_]/g

function base64clean (str) {
  // Node takes equal signs as end of the Base64 encoding
  str = str.split('=')[0]
  // Node strips out invalid characters like \n and \t from the string, base64-js does not
  str = str.trim().replace(INVALID_BASE64_RE, '')
  // Node converts strings with length < 2 to ''
  if (str.length < 2) return ''
  // Node allows for non-padded base64 strings (missing trailing ===), base64-js does not
  while (str.length % 4 !== 0) {
    str = str + '='
  }
  return str
}

function toHex (n) {
  if (n < 16) return '0' + n.toString(16)
  return n.toString(16)
}

function utf8ToBytes (string, units) {
  units = units || Infinity
  var codePoint
  var length = string.length
  var leadSurrogate = null
  var bytes = []

  for (var i = 0; i < length; ++i) {
    codePoint = string.charCodeAt(i)

    // is surrogate component
    if (codePoint > 0xD7FF && codePoint < 0xE000) {
      // last char was a lead
      if (!leadSurrogate) {
        // no lead yet
        if (codePoint > 0xDBFF) {
          // unexpected trail
          if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)
          continue
        } else if (i + 1 === length) {
          // unpaired lead
          if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)
          continue
        }

        // valid lead
        leadSurrogate = codePoint

        continue
      }

      // 2 leads in a row
      if (codePoint < 0xDC00) {
        if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)
        leadSurrogate = codePoint
        continue
      }

      // valid surrogate pair
      codePoint = (leadSurrogate - 0xD800 << 10 | codePoint - 0xDC00) + 0x10000
    } else if (leadSurrogate) {
      // valid bmp char, but last char was a lead
      if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)
    }

    leadSurrogate = null

    // encode utf8
    if (codePoint < 0x80) {
      if ((units -= 1) < 0) break
      bytes.push(codePoint)
    } else if (codePoint < 0x800) {
      if ((units -= 2) < 0) break
      bytes.push(
        codePoint >> 0x6 | 0xC0,
        codePoint & 0x3F | 0x80
      )
    } else if (codePoint < 0x10000) {
      if ((units -= 3) < 0) break
      bytes.push(
        codePoint >> 0xC | 0xE0,
        codePoint >> 0x6 & 0x3F | 0x80,
        codePoint & 0x3F | 0x80
      )
    } else if (codePoint < 0x110000) {
      if ((units -= 4) < 0) break
      bytes.push(
        codePoint >> 0x12 | 0xF0,
        codePoint >> 0xC & 0x3F | 0x80,
        codePoint >> 0x6 & 0x3F | 0x80,
        codePoint & 0x3F | 0x80
      )
    } else {
      throw new Error('Invalid code point')
    }
  }

  return bytes
}

function asciiToBytes (str) {
  var byteArray = []
  for (var i = 0; i < str.length; ++i) {
    // Node's code seems to be doing this and not & 0x7F..
    byteArray.push(str.charCodeAt(i) & 0xFF)
  }
  return byteArray
}

function utf16leToBytes (str, units) {
  var c, hi, lo
  var byteArray = []
  for (var i = 0; i < str.length; ++i) {
    if ((units -= 2) < 0) break

    c = str.charCodeAt(i)
    hi = c >> 8
    lo = c % 256
    byteArray.push(lo)
    byteArray.push(hi)
  }

  return byteArray
}

function base64ToBytes (str) {
  return base64.toByteArray(base64clean(str))
}

function blitBuffer (src, dst, offset, length) {
  for (var i = 0; i < length; ++i) {
    if ((i + offset >= dst.length) || (i >= src.length)) break
    dst[i + offset] = src[i]
  }
  return i
}

// ArrayBuffer or Uint8Array objects from other contexts (i.e. iframes) do not pass
// the `instanceof` check but they should be treated as of that type.
// See: https://github.com/feross/buffer/issues/166
function isInstance (obj, type) {
  return obj instanceof type ||
    (obj != null && obj.constructor != null && obj.constructor.name != null &&
      obj.constructor.name === type.name)
}
function numberIsNaN (obj) {
  // For IE11 support
  return obj !== obj // eslint-disable-line no-self-compare
}

}).call(this,require("buffer").Buffer)
},{"base64-js":129,"buffer":162,"ieee754":229}],163:[function(require,module,exports){
var Buffer = require('safe-buffer').Buffer
var Transform = require('stream').Transform
var StringDecoder = require('string_decoder').StringDecoder
var inherits = require('inherits')

function CipherBase (hashMode) {
  Transform.call(this)
  this.hashMode = typeof hashMode === 'string'
  if (this.hashMode) {
    this[hashMode] = this._finalOrDigest
  } else {
    this.final = this._finalOrDigest
  }
  if (this._final) {
    this.__final = this._final
    this._final = null
  }
  this._decoder = null
  this._encoding = null
}
inherits(CipherBase, Transform)

CipherBase.prototype.update = function (data, inputEnc, outputEnc) {
  if (typeof data === 'string') {
    data = Buffer.from(data, inputEnc)
  }

  var outData = this._update(data)
  if (this.hashMode) return this

  if (outputEnc) {
    outData = this._toString(outData, outputEnc)
  }

  return outData
}

CipherBase.prototype.setAutoPadding = function () {}
CipherBase.prototype.getAuthTag = function () {
  throw new Error('trying to get auth tag in unsupported state')
}

CipherBase.prototype.setAuthTag = function () {
  throw new Error('trying to set auth tag in unsupported state')
}

CipherBase.prototype.setAAD = function () {
  throw new Error('trying to set aad in unsupported state')
}

CipherBase.prototype._transform = function (data, _, next) {
  var err
  try {
    if (this.hashMode) {
      this._update(data)
    } else {
      this.push(this._update(data))
    }
  } catch (e) {
    err = e
  } finally {
    next(err)
  }
}
CipherBase.prototype._flush = function (done) {
  var err
  try {
    this.push(this.__final())
  } catch (e) {
    err = e
  }

  done(err)
}
CipherBase.prototype._finalOrDigest = function (outputEnc) {
  var outData = this.__final() || Buffer.alloc(0)
  if (outputEnc) {
    outData = this._toString(outData, outputEnc, true)
  }
  return outData
}

CipherBase.prototype._toString = function (value, enc, fin) {
  if (!this._decoder) {
    this._decoder = new StringDecoder(enc)
    this._encoding = enc
  }

  if (this._encoding !== enc) throw new Error('can\'t switch encodings')

  var out = this._decoder.write(value)
  if (fin) {
    out += this._decoder.end()
  }

  return out
}

module.exports = CipherBase

},{"inherits":231,"safe-buffer":330,"stream":342,"string_decoder":344}],164:[function(require,module,exports){
(function (Buffer){
// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.

// NOTE: These type checking functions intentionally don't use `instanceof`
// because it is fragile and can be easily faked with `Object.create()`.

function isArray(arg) {
  if (Array.isArray) {
    return Array.isArray(arg);
  }
  return objectToString(arg) === '[object Array]';
}
exports.isArray = isArray;

function isBoolean(arg) {
  return typeof arg === 'boolean';
}
exports.isBoolean = isBoolean;

function isNull(arg) {
  return arg === null;
}
exports.isNull = isNull;

function isNullOrUndefined(arg) {
  return arg == null;
}
exports.isNullOrUndefined = isNullOrUndefined;

function isNumber(arg) {
  return typeof arg === 'number';
}
exports.isNumber = isNumber;

function isString(arg) {
  return typeof arg === 'string';
}
exports.isString = isString;

function isSymbol(arg) {
  return typeof arg === 'symbol';
}
exports.isSymbol = isSymbol;

function isUndefined(arg) {
  return arg === void 0;
}
exports.isUndefined = isUndefined;

function isRegExp(re) {
  return objectToString(re) === '[object RegExp]';
}
exports.isRegExp = isRegExp;

function isObject(arg) {
  return typeof arg === 'object' && arg !== null;
}
exports.isObject = isObject;

function isDate(d) {
  return objectToString(d) === '[object Date]';
}
exports.isDate = isDate;

function isError(e) {
  return (objectToString(e) === '[object Error]' || e instanceof Error);
}
exports.isError = isError;

function isFunction(arg) {
  return typeof arg === 'function';
}
exports.isFunction = isFunction;

function isPrimitive(arg) {
  return arg === null ||
         typeof arg === 'boolean' ||
         typeof arg === 'number' ||
         typeof arg === 'string' ||
         typeof arg === 'symbol' ||  // ES6 symbol
         typeof arg === 'undefined';
}
exports.isPrimitive = isPrimitive;

exports.isBuffer = Buffer.isBuffer;

function objectToString(o) {
  return Object.prototype.toString.call(o);
}

}).call(this,{"isBuffer":require("../../is-buffer/index.js")})
},{"../../is-buffer/index.js":232}],165:[function(require,module,exports){
(function (Buffer){
var elliptic = require('elliptic')
var BN = require('bn.js')

module.exports = function createECDH (curve) {
  return new ECDH(curve)
}

var aliases = {
  secp256k1: {
    name: 'secp256k1',
    byteLength: 32
  },
  secp224r1: {
    name: 'p224',
    byteLength: 28
  },
  prime256v1: {
    name: 'p256',
    byteLength: 32
  },
  prime192v1: {
    name: 'p192',
    byteLength: 24
  },
  ed25519: {
    name: 'ed25519',
    byteLength: 32
  },
  secp384r1: {
    name: 'p384',
    byteLength: 48
  },
  secp521r1: {
    name: 'p521',
    byteLength: 66
  }
}

aliases.p224 = aliases.secp224r1
aliases.p256 = aliases.secp256r1 = aliases.prime256v1
aliases.p192 = aliases.secp192r1 = aliases.prime192v1
aliases.p384 = aliases.secp384r1
aliases.p521 = aliases.secp521r1

function ECDH (curve) {
  this.curveType = aliases[curve]
  if (!this.curveType) {
    this.curveType = {
      name: curve
    }
  }
  this.curve = new elliptic.ec(this.curveType.name) // eslint-disable-line new-cap
  this.keys = void 0
}

ECDH.prototype.generateKeys = function (enc, format) {
  this.keys = this.curve.genKeyPair()
  return this.getPublicKey(enc, format)
}

ECDH.prototype.computeSecret = function (other, inenc, enc) {
  inenc = inenc || 'utf8'
  if (!Buffer.isBuffer(other)) {
    other = new Buffer(other, inenc)
  }
  var otherPub = this.curve.keyFromPublic(other).getPublic()
  var out = otherPub.mul(this.keys.getPrivate()).getX()
  return formatReturnValue(out, enc, this.curveType.byteLength)
}

ECDH.prototype.getPublicKey = function (enc, format) {
  var key = this.keys.getPublic(format === 'compressed', true)
  if (format === 'hybrid') {
    if (key[key.length - 1] % 2) {
      key[0] = 7
    } else {
      key[0] = 6
    }
  }
  return formatReturnValue(key, enc)
}

ECDH.prototype.getPrivateKey = function (enc) {
  return formatReturnValue(this.keys.getPrivate(), enc)
}

ECDH.prototype.setPublicKey = function (pub, enc) {
  enc = enc || 'utf8'
  if (!Buffer.isBuffer(pub)) {
    pub = new Buffer(pub, enc)
  }
  this.keys._importPublic(pub)
  return this
}

ECDH.prototype.setPrivateKey = function (priv, enc) {
  enc = enc || 'utf8'
  if (!Buffer.isBuffer(priv)) {
    priv = new Buffer(priv, enc)
  }

  var _priv = new BN(priv)
  _priv = _priv.toString(16)
  this.keys = this.curve.genKeyPair()
  this.keys._importPrivate(_priv)
  return this
}

function formatReturnValue (bn, enc, len) {
  if (!Array.isArray(bn)) {
    bn = bn.toArray()
  }
  var buf = new Buffer(bn)
  if (len && buf.length < len) {
    var zeros = new Buffer(len - buf.length)
    zeros.fill(0)
    buf = Buffer.concat([zeros, buf])
  }
  if (!enc) {
    return buf
  } else {
    return buf.toString(enc)
  }
}

}).call(this,require("buffer").Buffer)
},{"bn.js":130,"buffer":162,"elliptic":184}],166:[function(require,module,exports){
'use strict'
var inherits = require('inherits')
var MD5 = require('md5.js')
var RIPEMD160 = require('ripemd160')
var sha = require('sha.js')
var Base = require('cipher-base')

function Hash (hash) {
  Base.call(this, 'digest')

  this._hash = hash
}

inherits(Hash, Base)

Hash.prototype._update = function (data) {
  this._hash.update(data)
}

Hash.prototype._final = function () {
  return this._hash.digest()
}

module.exports = function createHash (alg) {
  alg = alg.toLowerCase()
  if (alg === 'md5') return new MD5()
  if (alg === 'rmd160' || alg === 'ripemd160') return new RIPEMD160()

  return new Hash(sha(alg))
}

},{"cipher-base":163,"inherits":231,"md5.js":271,"ripemd160":329,"sha.js":335}],167:[function(require,module,exports){
var MD5 = require('md5.js')

module.exports = function (buffer) {
  return new MD5().update(buffer).digest()
}

},{"md5.js":271}],168:[function(require,module,exports){
'use strict'
var inherits = require('inherits')
var Legacy = require('./legacy')
var Base = require('cipher-base')
var Buffer = require('safe-buffer').Buffer
var md5 = require('create-hash/md5')
var RIPEMD160 = require('ripemd160')

var sha = require('sha.js')

var ZEROS = Buffer.alloc(128)

function Hmac (alg, key) {
  Base.call(this, 'digest')
  if (typeof key === 'string') {
    key = Buffer.from(key)
  }

  var blocksize = (alg === 'sha512' || alg === 'sha384') ? 128 : 64

  this._alg = alg
  this._key = key
  if (key.length > blocksize) {
    var hash = alg === 'rmd160' ? new RIPEMD160() : sha(alg)
    key = hash.update(key).digest()
  } else if (key.length < blocksize) {
    key = Buffer.concat([key, ZEROS], blocksize)
  }

  var ipad = this._ipad = Buffer.allocUnsafe(blocksize)
  var opad = this._opad = Buffer.allocUnsafe(blocksize)

  for (var i = 0; i < blocksize; i++) {
    ipad[i] = key[i] ^ 0x36
    opad[i] = key[i] ^ 0x5C
  }
  this._hash = alg === 'rmd160' ? new RIPEMD160() : sha(alg)
  this._hash.update(ipad)
}

inherits(Hmac, Base)

Hmac.prototype._update = function (data) {
  this._hash.update(data)
}

Hmac.prototype._final = function () {
  var h = this._hash.digest()
  var hash = this._alg === 'rmd160' ? new RIPEMD160() : sha(this._alg)
  return hash.update(this._opad).update(h).digest()
}

module.exports = function createHmac (alg, key) {
  alg = alg.toLowerCase()
  if (alg === 'rmd160' || alg === 'ripemd160') {
    return new Hmac('rmd160', key)
  }
  if (alg === 'md5') {
    return new Legacy(md5, key)
  }
  return new Hmac(alg, key)
}

},{"./legacy":169,"cipher-base":163,"create-hash/md5":167,"inherits":231,"ripemd160":329,"safe-buffer":330,"sha.js":335}],169:[function(require,module,exports){
'use strict'
var inherits = require('inherits')
var Buffer = require('safe-buffer').Buffer

var Base = require('cipher-base')

var ZEROS = Buffer.alloc(128)
var blocksize = 64

function Hmac (alg, key) {
  Base.call(this, 'digest')
  if (typeof key === 'string') {
    key = Buffer.from(key)
  }

  this._alg = alg
  this._key = key

  if (key.length > blocksize) {
    key = alg(key)
  } else if (key.length < blocksize) {
    key = Buffer.concat([key, ZEROS], blocksize)
  }

  var ipad = this._ipad = Buffer.allocUnsafe(blocksize)
  var opad = this._opad = Buffer.allocUnsafe(blocksize)

  for (var i = 0; i < blocksize; i++) {
    ipad[i] = key[i] ^ 0x36
    opad[i] = key[i] ^ 0x5C
  }

  this._hash = [ipad]
}

inherits(Hmac, Base)

Hmac.prototype._update = function (data) {
  this._hash.push(data)
}

Hmac.prototype._final = function () {
  var h = this._alg(Buffer.concat(this._hash))
  return this._alg(Buffer.concat([this._opad, h]))
}
module.exports = Hmac

},{"cipher-base":163,"inherits":231,"safe-buffer":330}],170:[function(require,module,exports){
'use strict'

exports.randomBytes = exports.rng = exports.pseudoRandomBytes = exports.prng = require('randombytes')
exports.createHash = exports.Hash = require('create-hash')
exports.createHmac = exports.Hmac = require('create-hmac')

var algos = require('browserify-sign/algos')
var algoKeys = Object.keys(algos)
var hashes = ['sha1', 'sha224', 'sha256', 'sha384', 'sha512', 'md5', 'rmd160'].concat(algoKeys)
exports.getHashes = function () {
  return hashes
}

var p = require('pbkdf2')
exports.pbkdf2 = p.pbkdf2
exports.pbkdf2Sync = p.pbkdf2Sync

var aes = require('browserify-cipher')

exports.Cipher = aes.Cipher
exports.createCipher = aes.createCipher
exports.Cipheriv = aes.Cipheriv
exports.createCipheriv = aes.createCipheriv
exports.Decipher = aes.Decipher
exports.createDecipher = aes.createDecipher
exports.Decipheriv = aes.Decipheriv
exports.createDecipheriv = aes.createDecipheriv
exports.getCiphers = aes.getCiphers
exports.listCiphers = aes.listCiphers

var dh = require('diffie-hellman')

exports.DiffieHellmanGroup = dh.DiffieHellmanGroup
exports.createDiffieHellmanGroup = dh.createDiffieHellmanGroup
exports.getDiffieHellman = dh.getDiffieHellman
exports.createDiffieHellman = dh.createDiffieHellman
exports.DiffieHellman = dh.DiffieHellman

var sign = require('browserify-sign')

exports.createSign = sign.createSign
exports.Sign = sign.Sign
exports.createVerify = sign.createVerify
exports.Verify = sign.Verify

exports.createECDH = require('create-ecdh')

var publicEncrypt = require('public-encrypt')

exports.publicEncrypt = publicEncrypt.publicEncrypt
exports.privateEncrypt = publicEncrypt.privateEncrypt
exports.publicDecrypt = publicEncrypt.publicDecrypt
exports.privateDecrypt = publicEncrypt.privateDecrypt

// the least I can do is make error messages for the rest of the node.js/crypto api.
// ;[
//   'createCredentials'
// ].forEach(function (name) {
//   exports[name] = function () {
//     throw new Error([
//       'sorry, ' + name + ' is not implemented yet',
//       'we accept pull requests',
//       'https://github.com/crypto-browserify/crypto-browserify'
//     ].join('\n'))
//   }
// })

var rf = require('randomfill')

exports.randomFill = rf.randomFill
exports.randomFillSync = rf.randomFillSync

exports.createCredentials = function () {
  throw new Error([
    'sorry, createCredentials is not implemented yet',
    'we accept pull requests',
    'https://github.com/crypto-browserify/crypto-browserify'
  ].join('\n'))
}

exports.constants = {
  'DH_CHECK_P_NOT_SAFE_PRIME': 2,
  'DH_CHECK_P_NOT_PRIME': 1,
  'DH_UNABLE_TO_CHECK_GENERATOR': 4,
  'DH_NOT_SUITABLE_GENERATOR': 8,
  'NPN_ENABLED': 1,
  'ALPN_ENABLED': 1,
  'RSA_PKCS1_PADDING': 1,
  'RSA_SSLV23_PADDING': 2,
  'RSA_NO_PADDING': 3,
  'RSA_PKCS1_OAEP_PADDING': 4,
  'RSA_X931_PADDING': 5,
  'RSA_PKCS1_PSS_PADDING': 6,
  'POINT_CONVERSION_COMPRESSED': 2,
  'POINT_CONVERSION_UNCOMPRESSED': 4,
  'POINT_CONVERSION_HYBRID': 6
}

},{"browserify-cipher":150,"browserify-sign":157,"browserify-sign/algos":154,"create-ecdh":165,"create-hash":166,"create-hmac":168,"diffie-hellman":180,"pbkdf2":299,"public-encrypt":308,"randombytes":314,"randomfill":315}],171:[function(require,module,exports){
(function () {
    "use strict";

    function defineDate(extended, is, array) {

        function _pad(string, length, ch, end) {
            string = "" + string; //check for numbers
            ch = ch || " ";
            var strLen = string.length;
            while (strLen < length) {
                if (end) {
                    string += ch;
                } else {
                    string = ch + string;
                }
                strLen++;
            }
            return string;
        }

        function _truncate(string, length, end) {
            var ret = string;
            if (is.isString(ret)) {
                if (string.length > length) {
                    if (end) {
                        var l = string.length;
                        ret = string.substring(l - length, l);
                    } else {
                        ret = string.substring(0, length);
                    }
                }
            } else {
                ret = _truncate("" + ret, length);
            }
            return ret;
        }

        function every(arr, iterator, scope) {
            if (!is.isArray(arr) || typeof iterator !== "function") {
                throw new TypeError();
            }
            var t = Object(arr);
            var len = t.length >>> 0;
            for (var i = 0; i < len; i++) {
                if (i in t && !iterator.call(scope, t[i], i, t)) {
                    return false;
                }
            }
            return true;
        }


        var transforms = (function () {
                var floor = Math.floor, round = Math.round;

                var addMap = {
                    day: function addDay(date, amount) {
                        return [amount, "Date", false];
                    },
                    weekday: function addWeekday(date, amount) {
                        // Divide the increment time span into weekspans plus leftover days
                        // e.g., 8 days is one 5-day weekspan / and two leftover days
                        // Can't have zero leftover days, so numbers divisible by 5 get
                        // a days value of 5, and the remaining days make up the number of weeks
                        var days, weeks, mod = amount % 5, strt = date.getDay(), adj = 0;
                        if (!mod) {
                            days = (amount > 0) ? 5 : -5;
                            weeks = (amount > 0) ? ((amount - 5) / 5) : ((amount + 5) / 5);
                        } else {
                            days = mod;
                            weeks = parseInt(amount / 5, 10);
                        }
                        if (strt === 6 && amount > 0) {
                            adj = 1;
                        } else if (strt === 0 && amount < 0) {
                            // Orig date is Sun / negative increment
                            // Jump back over Sat
                            adj = -1;
                        }
                        // Get weekday val for the new date
                        var trgt = strt + days;
                        // New date is on Sat or Sun
                        if (trgt === 0 || trgt === 6) {
                            adj = (amount > 0) ? 2 : -2;
                        }
                        // Increment by number of weeks plus leftover days plus
                        // weekend adjustments
                        return [(7 * weeks) + days + adj, "Date", false];
                    },
                    year: function addYear(date, amount) {
                        return [amount, "FullYear", true];
                    },
                    week: function addWeek(date, amount) {
                        return [amount * 7, "Date", false];
                    },
                    quarter: function addYear(date, amount) {
                        return [amount * 3, "Month", true];
                    },
                    month: function addYear(date, amount) {
                        return [amount, "Month", true];
                    }
                };

                function addTransform(interval, date, amount) {
                    interval = interval.replace(/s$/, "");
                    if (addMap.hasOwnProperty(interval)) {
                        return addMap[interval](date, amount);
                    }
                    return [amount, "UTC" + interval.charAt(0).toUpperCase() + interval.substring(1) + "s", false];
                }


                var differenceMap = {
                    "quarter": function quarterDifference(date1, date2, utc) {
                        var yearDiff = date2.getFullYear() - date1.getFullYear();
                        var m1 = date1[utc ? "getUTCMonth" : "getMonth"]();
                        var m2 = date2[utc ? "getUTCMonth" : "getMonth"]();
                        // Figure out which quarter the months are in
                        var q1 = floor(m1 / 3) + 1;
                        var q2 = floor(m2 / 3) + 1;
                        // Add quarters for any year difference between the dates
                        q2 += (yearDiff * 4);
                        return q2 - q1;
                    },

                    "weekday": function weekdayDifference(date1, date2, utc) {
                        var days = differenceTransform("day", date1, date2, utc), weeks;
                        var mod = days % 7;
                        // Even number of weeks
                        if (mod === 0) {
                            days = differenceTransform("week", date1, date2, utc) * 5;
                        } else {
                            // Weeks plus spare change (< 7 days)
                            var adj = 0, aDay = date1[utc ? "getUTCDay" : "getDay"](), bDay = date2[utc ? "getUTCDay" : "getDay"]();
                            weeks = parseInt(days / 7, 10);
                            // Mark the date advanced by the number of
                            // round weeks (may be zero)
                            var dtMark = new Date(+date1);
                            dtMark.setDate(dtMark[utc ? "getUTCDate" : "getDate"]() + (weeks * 7));
                            var dayMark = dtMark[utc ? "getUTCDay" : "getDay"]();

                            // Spare change days -- 6 or less
                            if (days > 0) {
                                if (aDay === 6 || bDay === 6) {
                                    adj = -1;
                                } else if (aDay === 0) {
                                    adj = 0;
                                } else if (bDay === 0 || (dayMark + mod) > 5) {
                                    adj = -2;
                                }
                            } else if (days < 0) {
                                if (aDay === 6) {
                                    adj = 0;
                                } else if (aDay === 0 || bDay === 0) {
                                    adj = 1;
                                } else if (bDay === 6 || (dayMark + mod) < 0) {
                                    adj = 2;
                                }
                            }
                            days += adj;
                            days -= (weeks * 2);
                        }
                        return days;
                    },
                    year: function (date1, date2) {
                        return date2.getFullYear() - date1.getFullYear();
                    },
                    month: function (date1, date2, utc) {
                        var m1 = date1[utc ? "getUTCMonth" : "getMonth"]();
                        var m2 = date2[utc ? "getUTCMonth" : "getMonth"]();
                        return (m2 - m1) + ((date2.getFullYear() - date1.getFullYear()) * 12);
                    },
                    week: function (date1, date2, utc) {
                        return round(differenceTransform("day", date1, date2, utc) / 7);
                    },
                    day: function (date1, date2) {
                        return 1.1574074074074074e-8 * (date2.getTime() - date1.getTime());
                    },
                    hour: function (date1, date2) {
                        return 2.7777777777777776e-7 * (date2.getTime() - date1.getTime());
                    },
                    minute: function (date1, date2) {
                        return 0.000016666666666666667 * (date2.getTime() - date1.getTime());
                    },
                    second: function (date1, date2) {
                        return 0.001 * (date2.getTime() - date1.getTime());
                    },
                    millisecond: function (date1, date2) {
                        return date2.getTime() - date1.getTime();
                    }
                };


                function differenceTransform(interval, date1, date2, utc) {
                    interval = interval.replace(/s$/, "");
                    return round(differenceMap[interval](date1, date2, utc));
                }


                return {
                    addTransform: addTransform,
                    differenceTransform: differenceTransform
                };
            }()),
            addTransform = transforms.addTransform,
            differenceTransform = transforms.differenceTransform;


        /**
         * @ignore
         * Based on DOJO Date Implementation
         *
         * Dojo is available under *either* the terms of the modified BSD license *or* the
         * Academic Free License version 2.1. As a recipient of Dojo, you may choose which
         * license to receive this code under (except as noted in per-module LICENSE
         * files). Some modules may not be the copyright of the Dojo Foundation. These
         * modules contain explicit declarations of copyright in both the LICENSE files in
         * the directories in which they reside and in the code itself. No external
         * contributions are allowed under licenses which are fundamentally incompatible
         * with the AFL or BSD licenses that Dojo is distributed under.
         *
         */

        var floor = Math.floor, round = Math.round, min = Math.min, pow = Math.pow, ceil = Math.ceil, abs = Math.abs;
        var monthNames = ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
        var monthAbbr = ["Jan.", "Feb.", "Mar.", "Apr.", "May.", "Jun.", "Jul.", "Aug.", "Sep.", "Oct.", "Nov.", "Dec."];
        var dayNames = ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"];
        var dayAbbr = ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];
        var eraNames = ["Before Christ", "Anno Domini"];
        var eraAbbr = ["BC", "AD"];


        function getDayOfYear(/*Date*/dateObject, utc) {
            // summary: gets the day of the year as represented by dateObject
            return date.difference(new Date(dateObject.getFullYear(), 0, 1, dateObject.getHours()), dateObject, null, utc) + 1; // Number
        }

        function getWeekOfYear(/*Date*/dateObject, /*Number*/firstDayOfWeek, utc) {
            firstDayOfWeek = firstDayOfWeek || 0;
            var fullYear = dateObject[utc ? "getUTCFullYear" : "getFullYear"]();
            var firstDayOfYear = new Date(fullYear, 0, 1).getDay(),
                adj = (firstDayOfYear - firstDayOfWeek + 7) % 7,
                week = floor((getDayOfYear(dateObject) + adj - 1) / 7);

            // if year starts on the specified day, start counting weeks at 1
            if (firstDayOfYear === firstDayOfWeek) {
                week++;
            }

            return week; // Number
        }

        function getTimezoneName(/*Date*/dateObject) {
            var str = dateObject.toString();
            var tz = '';
            var pos = str.indexOf('(');
            if (pos > -1) {
                tz = str.substring(++pos, str.indexOf(')'));
            }
            return tz; // String
        }


        function buildDateEXP(pattern, tokens) {
            return pattern.replace(/([a-z])\1*/ig,function (match) {
                // Build a simple regexp.  Avoid captures, which would ruin the tokens list
                var s,
                    c = match.charAt(0),
                    l = match.length,
                    p2 = '0?',
                    p3 = '0{0,2}';
                if (c === 'y') {
                    s = '\\d{2,4}';
                } else if (c === "M") {
                    s = (l > 2) ? '\\S+?' : '1[0-2]|' + p2 + '[1-9]';
                } else if (c === "D") {
                    s = '[12][0-9][0-9]|3[0-5][0-9]|36[0-6]|' + p3 + '[1-9][0-9]|' + p2 + '[1-9]';
                } else if (c === "d") {
                    s = '3[01]|[12]\\d|' + p2 + '[1-9]';
                } else if (c === "w") {
                    s = '[1-4][0-9]|5[0-3]|' + p2 + '[1-9]';
                } else if (c === "E") {
                    s = '\\S+';
                } else if (c === "h") {
                    s = '1[0-2]|' + p2 + '[1-9]';
                } else if (c === "K") {
                    s = '1[01]|' + p2 + '\\d';
                } else if (c === "H") {
                    s = '1\\d|2[0-3]|' + p2 + '\\d';
                } else if (c === "k") {
                    s = '1\\d|2[0-4]|' + p2 + '[1-9]';
                } else if (c === "m" || c === "s") {
                    s = '[0-5]\\d';
                } else if (c === "S") {
                    s = '\\d{' + l + '}';
                } else if (c === "a") {
                    var am = 'AM', pm = 'PM';
                    s = am + '|' + pm;
                    if (am !== am.toLowerCase()) {
                        s += '|' + am.toLowerCase();
                    }
                    if (pm !== pm.toLowerCase()) {
                        s += '|' + pm.toLowerCase();
                    }
                    s = s.replace(/\./g, "\\.");
                } else if (c === 'v' || c === 'z' || c === 'Z' || c === 'G' || c === 'q' || c === 'Q') {
                    s = ".*";
                } else {
                    s = c === " " ? "\\s*" : c + "*";
                }
                if (tokens) {
                    tokens.push(match);
                }

                return "(" + s + ")"; // add capture
            }).replace(/[\xa0 ]/g, "[\\s\\xa0]"); // normalize whitespace.  Need explicit handling of \xa0 for IE.
        }


        /**
         * @namespace Utilities for Dates
         */
        var date = {

            /**@lends date*/

            /**
             * Returns the number of days in the month of a date
             *
             * @example
             *
             *  dateExtender.getDaysInMonth(new Date(2006, 1, 1)); //28
             *  dateExtender.getDaysInMonth(new Date(2004, 1, 1)); //29
             *  dateExtender.getDaysInMonth(new Date(2006, 2, 1)); //31
             *  dateExtender.getDaysInMonth(new Date(2006, 3, 1)); //30
             *  dateExtender.getDaysInMonth(new Date(2006, 4, 1)); //31
             *  dateExtender.getDaysInMonth(new Date(2006, 5, 1)); //30
             *  dateExtender.getDaysInMonth(new Date(2006, 6, 1)); //31
             * @param {Date} dateObject the date containing the month
             * @return {Number} the number of days in the month
             */
            getDaysInMonth: function (/*Date*/dateObject) {
                //	summary:
                //		Returns the number of days in the month used by dateObject
                var month = dateObject.getMonth();
                var days = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
                if (month === 1 && date.isLeapYear(dateObject)) {
                    return 29;
                } // Number
                return days[month]; // Number
            },

            /**
             * Determines if a date is a leap year
             *
             * @example
             *
             *  dateExtender.isLeapYear(new Date(1600, 0, 1)); //true
             *  dateExtender.isLeapYear(new Date(2004, 0, 1)); //true
             *  dateExtender.isLeapYear(new Date(2000, 0, 1)); //true
             *  dateExtender.isLeapYear(new Date(2006, 0, 1)); //false
             *  dateExtender.isLeapYear(new Date(1900, 0, 1)); //false
             *  dateExtender.isLeapYear(new Date(1800, 0, 1)); //false
             *  dateExtender.isLeapYear(new Date(1700, 0, 1)); //false
             *
             * @param {Date} dateObject
             * @returns {Boolean} true if it is a leap year false otherwise
             */
            isLeapYear: function (/*Date*/dateObject, utc) {
                var year = dateObject[utc ? "getUTCFullYear" : "getFullYear"]();
                return (year % 400 === 0) || (year % 4 === 0 && year % 100 !== 0);

            },

            /**
             * Determines if a date is on a weekend
             *
             * @example
             *
             * var thursday = new Date(2006, 8, 21);
             * var saturday = new Date(2006, 8, 23);
             * var sunday = new Date(2006, 8, 24);
             * var monday = new Date(2006, 8, 25);
             * dateExtender.isWeekend(thursday)); //false
             * dateExtender.isWeekend(saturday); //true
             * dateExtender.isWeekend(sunday); //true
             * dateExtender.isWeekend(monday)); //false
             *
             * @param {Date} dateObject the date to test
             *
             * @returns {Boolean} true if the date is a weekend
             */
            isWeekend: function (/*Date?*/dateObject, utc) {
                // summary:
                //	Determines if the date falls on a weekend, according to local custom.
                var day = (dateObject || new Date())[utc ? "getUTCDay" : "getDay"]();
                return day === 0 || day === 6;
            },

            /**
             * Get the timezone of a date
             *
             * @example
             *  //just setting the strLocal to simulate the toString() of a date
             *  dt.str = 'Sun Sep 17 2006 22:25:51 GMT-0500 (CDT)';
             *  //just setting the strLocal to simulate the locale
             *  dt.strLocale = 'Sun 17 Sep 2006 10:25:51 PM CDT';
             *  dateExtender.getTimezoneName(dt); //'CDT'
             *  dt.str = 'Sun Sep 17 2006 22:57:18 GMT-0500 (CDT)';
             *  dt.strLocale = 'Sun Sep 17 22:57:18 2006';
             *  dateExtender.getTimezoneName(dt); //'CDT'
             * @param dateObject the date to get the timezone from
             *
             * @returns {String} the timezone of the date
             */
            getTimezoneName: getTimezoneName,

            /**
             * Compares two dates
             *
             * @example
             *
             * var d1 = new Date();
             * d1.setHours(0);
             * dateExtender.compare(d1, d1); // 0
             *
             *  var d1 = new Date();
             *  d1.setHours(0);
             *  var d2 = new Date();
             *  d2.setFullYear(2005);
             *  d2.setHours(12);
             *  dateExtender.compare(d1, d2, "date"); // 1
             *  dateExtender.compare(d1, d2, "datetime"); // 1
             *
             *  var d1 = new Date();
             *  d1.setHours(0);
             *  var d2 = new Date();
             *  d2.setFullYear(2005);
             *  d2.setHours(12);
             *  dateExtender.compare(d2, d1, "date"); // -1
             *  dateExtender.compare(d1, d2, "time"); //-1
             *
             * @param {Date|String} date1 the date to comapare
             * @param {Date|String} [date2=new Date()] the date to compare date1 againse
             * @param {"date"|"time"|"datetime"} portion compares the portion specified
             *
             * @returns -1 if date1 is < date2 0 if date1 === date2  1 if date1 > date2
             */
            compare: function (/*Date*/date1, /*Date*/date2, /*String*/portion) {
                date1 = new Date(+date1);
                date2 = new Date(+(date2 || new Date()));

                if (portion === "date") {
                    // Ignore times and compare dates.
                    date1.setHours(0, 0, 0, 0);
                    date2.setHours(0, 0, 0, 0);
                } else if (portion === "time") {
                    // Ignore dates and compare times.
                    date1.setFullYear(0, 0, 0);
                    date2.setFullYear(0, 0, 0);
                }
                return date1 > date2 ? 1 : date1 < date2 ? -1 : 0;
            },


            /**
             * Adds a specified interval and amount to a date
             *
             * @example
             *  var dtA = new Date(2005, 11, 27);
             *  dateExtender.add(dtA, "year", 1); //new Date(2006, 11, 27);
             *  dateExtender.add(dtA, "years", 1); //new Date(2006, 11, 27);
             *
             *  dtA = new Date(2000, 0, 1);
             *  dateExtender.add(dtA, "quarter", 1); //new Date(2000, 3, 1);
             *  dateExtender.add(dtA, "quarters", 1); //new Date(2000, 3, 1);
             *
             *  dtA = new Date(2000, 0, 1);
             *  dateExtender.add(dtA, "month", 1); //new Date(2000, 1, 1);
             *  dateExtender.add(dtA, "months", 1); //new Date(2000, 1, 1);
             *
             *  dtA = new Date(2000, 0, 31);
             *  dateExtender.add(dtA, "month", 1); //new Date(2000, 1, 29);
             *  dateExtender.add(dtA, "months", 1); //new Date(2000, 1, 29);
             *
             *  dtA = new Date(2000, 0, 1);
             *  dateExtender.add(dtA, "week", 1); //new Date(2000, 0, 8);
             *  dateExtender.add(dtA, "weeks", 1); //new Date(2000, 0, 8);
             *
             *  dtA = new Date(2000, 0, 1);
             *  dateExtender.add(dtA, "day", 1); //new Date(2000, 0, 2);
             *
             *  dtA = new Date(2000, 0, 1);
             *  dateExtender.add(dtA, "weekday", 1); //new Date(2000, 0, 3);
             *
             *  dtA = new Date(2000, 0, 1, 11);
             *  dateExtender.add(dtA, "hour", 1); //new Date(2000, 0, 1, 12);
             *
             *  dtA = new Date(2000, 11, 31, 23, 59);
             *  dateExtender.add(dtA, "minute", 1); //new Date(2001, 0, 1, 0, 0);
             *
             *  dtA = new Date(2000, 11, 31, 23, 59, 59);
             *  dateExtender.add(dtA, "second", 1); //new Date(2001, 0, 1, 0, 0, 0);
             *
             *  dtA = new Date(2000, 11, 31, 23, 59, 59, 999);
             *  dateExtender.add(dtA, "millisecond", 1); //new Date(2001, 0, 1, 0, 0, 0, 0);
             *
             * @param {Date} date
             * @param {String} interval the interval to add
             *  <ul>
             *      <li>day | days</li>
             *      <li>weekday | weekdays</li>
             *      <li>year | years</li>
             *      <li>week | weeks</li>
             *      <li>quarter | quarters</li>
             *      <li>months | months</li>
             *      <li>hour | hours</li>
             *      <li>minute | minutes</li>
             *      <li>second | seconds</li>
             *      <li>millisecond | milliseconds</li>
             *  </ul>
             * @param {Number} [amount=0] the amount to add
             */
            add: function (/*Date*/date, /*String*/interval, /*int*/amount) {
                var res = addTransform(interval, date, amount || 0);
                amount = res[0];
                var property = res[1];
                var sum = new Date(+date);
                var fixOvershoot = res[2];
                if (property) {
                    sum["set" + property](sum["get" + property]() + amount);
                }

                if (fixOvershoot && (sum.getDate() < date.getDate())) {
                    sum.setDate(0);
                }

                return sum; // Date
            },

            /**
             * Finds the difference between two dates based on the specified interval
             *
             * @example
             *
             * var dtA, dtB;
             *
             * dtA = new Date(2005, 11, 27);
             * dtB = new Date(2006, 11, 27);
             * dateExtender.difference(dtA, dtB, "year"); //1
             *
             * dtA = new Date(2000, 1, 29);
             * dtB = new Date(2001, 2, 1);
             * dateExtender.difference(dtA, dtB, "quarter"); //4
             * dateExtender.difference(dtA, dtB, "month"); //13
             *
             * dtA = new Date(2000, 1, 1);
             * dtB = new Date(2000, 1, 8);
             * dateExtender.difference(dtA, dtB, "week"); //1
             *
             * dtA = new Date(2000, 1, 29);
             * dtB = new Date(2000, 2, 1);
             * dateExtender.difference(dtA, dtB, "day"); //1
             *
             * dtA = new Date(2006, 7, 3);
             * dtB = new Date(2006, 7, 11);
             * dateExtender.difference(dtA, dtB, "weekday"); //6
             *
             * dtA = new Date(2000, 11, 31, 23);
             * dtB = new Date(2001, 0, 1, 0);
             * dateExtender.difference(dtA, dtB, "hour"); //1
             *
             * dtA = new Date(2000, 11, 31, 23, 59);
             * dtB = new Date(2001, 0, 1, 0, 0);
             * dateExtender.difference(dtA, dtB, "minute"); //1
             *
             * dtA = new Date(2000, 11, 31, 23, 59, 59);
             * dtB = new Date(2001, 0, 1, 0, 0, 0);
             * dateExtender.difference(dtA, dtB, "second"); //1
             *
             * dtA = new Date(2000, 11, 31, 23, 59, 59, 999);
             * dtB = new Date(2001, 0, 1, 0, 0, 0, 0);
             * dateExtender.difference(dtA, dtB, "millisecond"); //1
             *
             *
             * @param {Date} date1
             * @param {Date} [date2 = new Date()]
             * @param {String} [interval = "day"] the intercal to find the difference of.
             *   <ul>
             *      <li>day | days</li>
             *      <li>weekday | weekdays</li>
             *      <li>year | years</li>
             *      <li>week | weeks</li>
             *      <li>quarter | quarters</li>
             *      <li>months | months</li>
             *      <li>hour | hours</li>
             *      <li>minute | minutes</li>
             *      <li>second | seconds</li>
             *      <li>millisecond | milliseconds</li>
             *  </ul>
             */
            difference: function (/*Date*/date1, /*Date?*/date2, /*String*/interval, utc) {
                date2 = date2 || new Date();
                interval = interval || "day";
                return differenceTransform(interval, date1, date2, utc);
            },

            /**
             * Formats a date to the specidifed format string
             *
             * @example
             *
             * var date = new Date(2006, 7, 11, 0, 55, 12, 345);
             * dateExtender.format(date, "EEEE, MMMM dd, yyyy"); //"Friday, August 11, 2006"
             * dateExtender.format(date, "M/dd/yy"); //"8/11/06"
             * dateExtender.format(date, "E"); //"6"
             * dateExtender.format(date, "h:m a"); //"12:55 AM"
             * dateExtender.format(date, 'h:m:s'); //"12:55:12"
             * dateExtender.format(date, 'h:m:s.SS'); //"12:55:12.35"
             * dateExtender.format(date, 'k:m:s.SS'); //"24:55:12.35"
             * dateExtender.format(date, 'H:m:s.SS'); //"0:55:12.35"
             * dateExtender.format(date, "ddMMyyyy"); //"11082006"
             *
             * @param date the date to format
             * @param {String} format the format of the date composed of the following options
             * <ul>
             *                  <li> G    Era designator    Text    AD</li>
             *                  <li> y    Year    Year    1996; 96</li>
             *                  <li> M    Month in year    Month    July; Jul; 07</li>
             *                  <li> w    Week in year    Number    27</li>
             *                  <li> W    Week in month    Number    2</li>
             *                  <li> D    Day in year    Number    189</li>
             *                  <li> d    Day in month    Number    10</li>
             *                  <li> E    Day in week    Text    Tuesday; Tue</li>
             *                  <li> a    Am/pm marker    Text    PM</li>
             *                  <li> H    Hour in day (0-23)    Number    0</li>
             *                  <li> k    Hour in day (1-24)    Number    24</li>
             *                  <li> K    Hour in am/pm (0-11)    Number    0</li>
             *                  <li> h    Hour in am/pm (1-12)    Number    12</li>
             *                  <li> m    Minute in hour    Number    30</li>
             *                  <li> s    Second in minute    Number    55</li>
             *                  <li> S    Millisecond    Number    978</li>
             *                  <li> z    Time zone    General time zone    Pacific Standard Time; PST; GMT-08:00</li>
             *                  <li> Z    Time zone    RFC 822 time zone    -0800 </li>
             * </ul>
             */
            format: function (date, format, utc) {
                utc = utc || false;
                var fullYear, month, day, d, hour, minute, second, millisecond;
                if (utc) {
                    fullYear = date.getUTCFullYear();
                    month = date.getUTCMonth();
                    day = date.getUTCDay();
                    d = date.getUTCDate();
                    hour = date.getUTCHours();
                    minute = date.getUTCMinutes();
                    second = date.getUTCSeconds();
                    millisecond = date.getUTCMilliseconds();
                } else {
                    fullYear = date.getFullYear();
                    month = date.getMonth();
                    d = date.getDate();
                    day = date.getDay();
                    hour = date.getHours();
                    minute = date.getMinutes();
                    second = date.getSeconds();
                    millisecond = date.getMilliseconds();
                }
                return format.replace(/([A-Za-z])\1*/g, function (match) {
                    var s, pad,
                        c = match.charAt(0),
                        l = match.length;
                    if (c === 'd') {
                        s = "" + d;
                        pad = true;
                    } else if (c === "H" && !s) {
                        s = "" + hour;
                        pad = true;
                    } else if (c === 'm' && !s) {
                        s = "" + minute;
                        pad = true;
                    } else if (c === 's') {
                        if (!s) {
                            s = "" + second;
                        }
                        pad = true;
                    } else if (c === "G") {
                        s = ((l < 4) ? eraAbbr : eraNames)[fullYear < 0 ? 0 : 1];
                    } else if (c === "y") {
                        s = fullYear;
                        if (l > 1) {
                            if (l === 2) {
                                s = _truncate("" + s, 2, true);
                            } else {
                                pad = true;
                            }
                        }
                    } else if (c.toUpperCase() === "Q") {
                        s = ceil((month + 1) / 3);
                        pad = true;
                    } else if (c === "M") {
                        if (l < 3) {
                            s = month + 1;
                            pad = true;
                        } else {
                            s = (l === 3 ? monthAbbr : monthNames)[month];
                        }
                    } else if (c === "w") {
                        s = getWeekOfYear(date, 0, utc);
                        pad = true;
                    } else if (c === "D") {
                        s = getDayOfYear(date, utc);
                        pad = true;
                    } else if (c === "E") {
                        if (l < 3) {
                            s = day + 1;
                            pad = true;
                        } else {
                            s = (l === -3 ? dayAbbr : dayNames)[day];
                        }
                    } else if (c === 'a') {
                        s = (hour < 12) ? 'AM' : 'PM';
                    } else if (c === "h") {
                        s = (hour % 12) || 12;
                        pad = true;
                    } else if (c === "K") {
                        s = (hour % 12);
                        pad = true;
                    } else if (c === "k") {
                        s = hour || 24;
                        pad = true;
                    } else if (c === "S") {
                        s = round(millisecond * pow(10, l - 3));
                        pad = true;
                    } else if (c === "z" || c === "v" || c === "Z") {
                        s = getTimezoneName(date);
                        if ((c === "z" || c === "v") && !s) {
                            l = 4;
                        }
                        if (!s || c === "Z") {
                            var offset = date.getTimezoneOffset();
                            var tz = [
                                (offset >= 0 ? "-" : "+"),
                                _pad(floor(abs(offset) / 60), 2, "0"),
                                _pad(abs(offset) % 60, 2, "0")
                            ];
                            if (l === 4) {
                                tz.splice(0, 0, "GMT");
                                tz.splice(3, 0, ":");
                            }
                            s = tz.join("");
                        }
                    } else {
                        s = match;
                    }
                    if (pad) {
                        s = _pad(s, l, '0');
                    }
                    return s;
                });
            }

        };

        var numberDate = {};

        function addInterval(interval) {
            numberDate[interval + "sFromNow"] = function (val) {
                return date.add(new Date(), interval, val);
            };
            numberDate[interval + "sAgo"] = function (val) {
                return date.add(new Date(), interval, -val);
            };
        }

        var intervals = ["year", "month", "day", "hour", "minute", "second"];
        for (var i = 0, l = intervals.length; i < l; i++) {
            addInterval(intervals[i]);
        }

        var stringDate = {

            parseDate: function (dateStr, format) {
                if (!format) {
                    throw new Error('format required when calling dateExtender.parse');
                }
                var tokens = [], regexp = buildDateEXP(format, tokens),
                    re = new RegExp("^" + regexp + "$", "i"),
                    match = re.exec(dateStr);
                if (!match) {
                    return null;
                } // null
                var result = [1970, 0, 1, 0, 0, 0, 0], // will get converted to a Date at the end
                    amPm = "",
                    valid = every(match, function (v, i) {
                        if (i) {
                            var token = tokens[i - 1];
                            var l = token.length, type = token.charAt(0);
                            if (type === 'y') {
                                if (v < 100) {
                                    v = parseInt(v, 10);
                                    //choose century to apply, according to a sliding window
                                    //of 80 years before and 20 years after present year
                                    var year = '' + new Date().getFullYear(),
                                        century = year.substring(0, 2) * 100,
                                        cutoff = min(year.substring(2, 4) + 20, 99);
                                    result[0] = (v < cutoff) ? century + v : century - 100 + v;
                                } else {
                                    result[0] = v;
                                }
                            } else if (type === "M") {
                                if (l > 2) {
                                    var months = monthNames, j, k;
                                    if (l === 3) {
                                        months = monthAbbr;
                                    }
                                    //Tolerate abbreviating period in month part
                                    //Case-insensitive comparison
                                    v = v.replace(".", "").toLowerCase();
                                    var contains = false;
                                    for (j = 0, k = months.length; j < k && !contains; j++) {
                                        var s = months[j].replace(".", "").toLocaleLowerCase();
                                        if (s === v) {
                                            v = j;
                                            contains = true;
                                        }
                                    }
                                    if (!contains) {
                                        return false;
                                    }
                                } else {
                                    v--;
                                }
                                result[1] = v;
                            } else if (type === "E" || type === "e") {
                                var days = dayNames;
                                if (l === 3) {
                                    days = dayAbbr;
                                }
                                //Case-insensitive comparison
                                v = v.toLowerCase();
                                days = array.map(days, function (d) {
                                    return d.toLowerCase();
                                });
                                var d = array.indexOf(days, v);
                                if (d === -1) {
                                    v = parseInt(v, 10);
                                    if (isNaN(v) || v > days.length) {
                                        return false;
                                    }
                                } else {
                                    v = d;
                                }
                            } else if (type === 'D' || type === "d") {
                                if (type === "D") {
                                    result[1] = 0;
                                }
                                result[2] = v;
                            } else if (type === "a") {
                                var am = "am";
                                var pm = "pm";
                                var period = /\./g;
                                v = v.replace(period, '').toLowerCase();
                                // we might not have seen the hours field yet, so store the state and apply hour change later
                                amPm = (v === pm) ? 'p' : (v === am) ? 'a' : '';
                            } else if (type === "k" || type === "h" || type === "H" || type === "K") {
                                if (type === "k" && (+v) === 24) {
                                    v = 0;
                                }
                                result[3] = v;
                            } else if (type === "m") {
                                result[4] = v;
                            } else if (type === "s") {
                                result[5] = v;
                            } else if (type === "S") {
                                result[6] = v;
                            }
                        }
                        return true;
                    });
                if (valid) {
                    var hours = +result[3];
                    //account for am/pm
                    if (amPm === 'p' && hours < 12) {
                        result[3] = hours + 12; //e.g., 3pm -> 15
                    } else if (amPm === 'a' && hours === 12) {
                        result[3] = 0; //12am -> 0
                    }
                    var dateObject = new Date(result[0], result[1], result[2], result[3], result[4], result[5], result[6]); // Date
                    var dateToken = (array.indexOf(tokens, 'd') !== -1),
                        monthToken = (array.indexOf(tokens, 'M') !== -1),
                        month = result[1],
                        day = result[2],
                        dateMonth = dateObject.getMonth(),
                        dateDay = dateObject.getDate();
                    if ((monthToken && dateMonth > month) || (dateToken && dateDay > day)) {
                        return null;
                    }
                    return dateObject; // Date
                } else {
                    return null;
                }
            }
        };


        var ret = extended.define(is.isDate, date).define(is.isString, stringDate).define(is.isNumber, numberDate);
        for (i in date) {
            if (date.hasOwnProperty(i)) {
                ret[i] = date[i];
            }
        }

        for (i in stringDate) {
            if (stringDate.hasOwnProperty(i)) {
                ret[i] = stringDate[i];
            }
        }
        for (i in numberDate) {
            if (numberDate.hasOwnProperty(i)) {
                ret[i] = numberDate[i];
            }
        }
        return ret;
    }

    if ("undefined" !== typeof exports) {
        if ("undefined" !== typeof module && module.exports) {
            module.exports = defineDate(require("extended"), require("is-extended"), require("array-extended"));

        }
    } else if ("function" === typeof define && define.amd) {
        define(["extended", "is-extended", "array-extended"], function (extended, is, arr) {
            return defineDate(extended, is, arr);
        });
    } else {
        this.dateExtended = defineDate(this.extended, this.isExtended, this.arrayExtended);
    }

}).call(this);







},{"array-extended":114,"extended":203,"is-extended":233}],172:[function(require,module,exports){
(function () {

    /**
     * @projectName declare
     * @github http://github.com/doug-martin/declare.js
     * @header
     *
     * Declare is a library designed to allow writing object oriented code the same way in both the browser and node.js.
     *
     * ##Installation
     *
     * `npm install declare.js`
     *
     * Or [download the source](https://raw.github.com/doug-martin/declare.js/master/declare.js) ([minified](https://raw.github.com/doug-martin/declare.js/master/declare-min.js))
     *
     * ###Requirejs
     *
     * To use with requirejs place the `declare` source in the root scripts directory
     *
     * ```
     *
     * define(["declare"], function(declare){
     *      return declare({
     *          instance : {
     *              hello : function(){
     *                  return "world";
     *              }
     *          }
     *      });
     * });
     *
     * ```
     *
     *
     * ##Usage
     *
     * declare.js provides
     *
     * Class methods
     *
     * * `as(module | object, name)` : exports the object to module or the object with the name
     * * `mixin(mixin)` : mixes in an object but does not inherit directly from the object. **Note** this does not return a new class but changes the original class.
     * * `extend(proto)` : extend a class with the given properties. A shortcut to `declare(Super, {})`;
     *
     * Instance methods
     *
     * * `_super(arguments)`: calls the super of the current method, you can pass in either the argments object or an array with arguments you want passed to super
     * * `_getSuper()`: returns a this methods direct super.
     * * `_static` : use to reference class properties and methods.
     * * `get(prop)` : gets a property invoking the getter if it exists otherwise it just returns the named property on the object.
     * * `set(prop, val)` : sets a property invoking the setter if it exists otherwise it just sets the named property on the object.
     *
     *
     * ###Declaring a new Class
     *
     * Creating a new class with declare is easy!
     *
     * ```
     *
     * var Mammal = declare({
     *      //define your instance methods and properties
     *      instance : {
     *
     *          //will be called whenever a new instance is created
     *          constructor: function(options) {
     *              options = options || {};
     *              this._super(arguments);
     *              this._type = options.type || "mammal";
     *          },
     *
     *          speak : function() {
     *              return  "A mammal of type " + this._type + " sounds like";
     *          },
     *
     *          //Define your getters
     *          getters : {
     *
     *              //can be accessed by using the get method. (mammal.get("type"))
     *              type : function() {
     *                  return this._type;
     *              }
     *          },
     *
     *           //Define your setters
     *          setters : {
     *
     *                //can be accessed by using the set method. (mammal.set("type", "mammalType"))
     *              type : function(t) {
     *                  this._type = t;
     *              }
     *          }
     *      },
     *
     *      //Define your static methods
     *      static : {
     *
     *          //Mammal.soundOff(); //"Im a mammal!!"
     *          soundOff : function() {
     *              return "Im a mammal!!";
     *          }
     *      }
     * });
     *
     *
     * ```
     *
     * You can use Mammal just like you would any other class.
     *
     * ```
     * Mammal.soundOff("Im a mammal!!");
     *
     * var myMammal = new Mammal({type : "mymammal"});
     * myMammal.speak(); // "A mammal of type mymammal sounds like"
     * myMammal.get("type"); //"mymammal"
     * myMammal.set("type", "mammal");
     * myMammal.get("type"); //"mammal"
     *
     *
     * ```
     *
     * ###Extending a class
     *
     * If you want to just extend a single class use the .extend method.
     *
     * ```
     *
     * var Wolf = Mammal.extend({
     *
     *   //define your instance method
     *   instance: {
     *
     *        //You can override super constructors just be sure to call `_super`
     *       constructor: function(options) {
     *          options = options || {};
     *          this._super(arguments); //call our super constructor.
     *          this._sound = "growl";
     *          this._color = options.color || "grey";
     *      },
     *
     *      //override Mammals `speak` method by appending our own data to it.
     *      speak : function() {
     *          return this._super(arguments) + " a " + this._sound;
     *      },
     *
     *      //add new getters for sound and color
     *      getters : {
     *
     *           //new Wolf().get("type")
     *           //notice color is read only as we did not define a setter
     *          color : function() {
     *              return this._color;
     *          },
     *
     *          //new Wolf().get("sound")
     *          sound : function() {
     *              return this._sound;
     *          }
     *      },
     *
     *      setters : {
     *
     *          //new Wolf().set("sound", "howl")
     *          sound : function(s) {
     *              this._sound = s;
     *          }
     *      }
     *
     *  },
     *
     *  static : {
     *
     *      //You can override super static methods also! And you can still use _super
     *      soundOff : function() {
     *          //You can even call super in your statics!!!
     *          //should return "I'm a mammal!! that growls"
     *          return this._super(arguments) + " that growls";
     *      }
     *  }
     * });
     *
     * Wolf.soundOff(); //Im a mammal!! that growls
     *
     * var myWolf = new Wolf();
     * myWolf instanceof Mammal //true
     * myWolf instanceof Wolf //true
     *
     * ```
     *
     * You can also extend a class by using the declare method and just pass in the super class.
     *
     * ```
     * //Typical hierarchical inheritance
     * // Mammal->Wolf->Dog
     * var Dog = declare(Wolf, {
     *    instance: {
     *        constructor: function(options) {
     *            options = options || {};
     *            this._super(arguments);
     *            //override Wolfs initialization of sound to woof.
     *            this._sound = "woof";
     *
     *        },
     *
     *        speak : function() {
     *            //Should return "A mammal of type mammal sounds like a growl thats domesticated"
     *            return this._super(arguments) + " thats domesticated";
     *        }
     *    },
     *
     *    static : {
     *        soundOff : function() {
     *            //should return "I'm a mammal!! that growls but now barks"
     *            return this._super(arguments) + " but now barks";
     *        }
     *    }
     * });
     *
     * Dog.soundOff(); //Im a mammal!! that growls but now barks
     *
     * var myDog = new Dog();
     * myDog instanceof Mammal //true
     * myDog instanceof Wolf //true
     * myDog instanceof Dog //true
     *
     *
     * //Notice you still get the extend method.
     *
     * // Mammal->Wolf->Dog->Breed
     * var Breed = Dog.extend({
     *    instance: {
     *
     *        //initialize outside of constructor
     *        _pitch : "high",
     *
     *        constructor: function(options) {
     *            options = options || {};
     *            this._super(arguments);
     *            this.breed = options.breed || "lab";
     *        },
     *
     *        speak : function() {
     *            //Should return "A mammal of type mammal sounds like a
     *            //growl thats domesticated with a high pitch!"
     *            return this._super(arguments) + " with a " + this._pitch + " pitch!";
     *        },
     *
     *        getters : {
     *            pitch : function() {
     *                return this._pitch;
     *            }
     *        }
     *    },
     *
     *    static : {
     *        soundOff : function() {
     *            //should return "I'M A MAMMAL!! THAT GROWLS BUT NOW BARKS!"
     *            return this._super(arguments).toUpperCase() + "!";
     *        }
     *    }
     * });
     *
     *
     * Breed.soundOff()//"IM A MAMMAL!! THAT GROWLS BUT NOW BARKS!"
     *
     * var myBreed = new Breed({color : "gold", type : "lab"}),
     * myBreed instanceof Dog //true
     * myBreed instanceof Wolf //true
     * myBreed instanceof Mammal //true
     * myBreed.speak() //"A mammal of type lab sounds like a woof thats domesticated with a high pitch!"
     * myBreed.get("type") //"lab"
     * myBreed.get("color") //"gold"
     * myBreed.get("sound")" //"woof"
     * ```
     *
     * ###Multiple Inheritance / Mixins
     *
     * declare also allows the use of multiple super classes.
     * This is useful if you have generic classes that provide functionality but shouldnt be used on their own.
     *
     * Lets declare a mixin that allows us to watch for property changes.
     *
     * ```
     * //Notice that we set up the functions outside of declare because we can reuse them
     *
     * function _set(prop, val) {
     *     //get the old value
     *     var oldVal = this.get(prop);
     *     //call super to actually set the property
     *     var ret = this._super(arguments);
     *     //call our handlers
     *     this.__callHandlers(prop, oldVal, val);
     *     return ret;
     * }
     *
     * function _callHandlers(prop, oldVal, newVal) {
     *    //get our handlers for the property
     *     var handlers = this.__watchers[prop], l;
     *     //if the handlers exist and their length does not equal 0 then we call loop through them
     *     if (handlers && (l = handlers.length) !== 0) {
     *         for (var i = 0; i < l; i++) {
     *             //call the handler
     *             handlers[i].call(null, prop, oldVal, newVal);
     *         }
     *     }
     * }
     *
     *
     * //the watch function
     * function _watch(prop, handler) {
     *     if ("function" !== typeof handler) {
     *         //if its not a function then its an invalid handler
     *         throw new TypeError("Invalid handler.");
     *     }
     *     if (!this.__watchers[prop]) {
     *         //create the watchers if it doesnt exist
     *         this.__watchers[prop] = [handler];
     *     } else {
     *         //otherwise just add it to the handlers array
     *         this.__watchers[prop].push(handler);
     *     }
     * }
     *
     * function _unwatch(prop, handler) {
     *     if ("function" !== typeof handler) {
     *         throw new TypeError("Invalid handler.");
     *     }
     *     var handlers = this.__watchers[prop], index;
     *     if (handlers && (index = handlers.indexOf(handler)) !== -1) {
     *        //remove the handler if it is found
     *         handlers.splice(index, 1);
     *     }
     * }
     *
     * declare({
     *     instance:{
     *         constructor:function () {
     *             this._super(arguments);
     *             //set up our watchers
     *             this.__watchers = {};
     *         },
     *
     *         //override the default set function so we can watch values
     *         "set":_set,
     *         //set up our callhandlers function
     *         __callHandlers:_callHandlers,
     *         //add the watch function
     *         watch:_watch,
     *         //add the unwatch function
     *         unwatch:_unwatch
     *     },
     *
     *     "static":{
     *
     *         init:function () {
     *             this._super(arguments);
     *             this.__watchers = {};
     *         },
     *         //override the default set function so we can watch values
     *         "set":_set,
     *         //set our callHandlers function
     *         __callHandlers:_callHandlers,
     *         //add the watch
     *         watch:_watch,
     *         //add the unwatch function
     *         unwatch:_unwatch
     *     }
     * })
     *
     * ```
     *
     * Now lets use the mixin
     *
     * ```
     * var WatchDog = declare([Dog, WatchMixin]);
     *
     * var watchDog = new WatchDog();
     * //create our handler
     * function watch(id, oldVal, newVal) {
     *     console.log("watchdog's %s was %s, now %s", id, oldVal, newVal);
     * }
     *
     * //watch for property changes
     * watchDog.watch("type", watch);
     * watchDog.watch("color", watch);
     * watchDog.watch("sound", watch);
     *
     * //now set the properties each handler will be called
     * watchDog.set("type", "newDog");
     * watchDog.set("color", "newColor");
     * watchDog.set("sound", "newSound");
     *
     *
     * //unwatch the property changes
     * watchDog.unwatch("type", watch);
     * watchDog.unwatch("color", watch);
     * watchDog.unwatch("sound", watch);
     *
     * //no handlers will be called this time
     * watchDog.set("type", "newDog");
     * watchDog.set("color", "newColor");
     * watchDog.set("sound", "newSound");
     *
     *
     * ```
     *
     * ###Accessing static methods and properties witin an instance.
     *
     * To access static properties on an instance use the `_static` property which is a reference to your constructor.
     *
     * For example if your in your constructor and you want to have configurable default values.
     *
     * ```
     * consturctor : function constructor(opts){
     *     this.opts = opts || {};
     *     this._type = opts.type || this._static.DEFAULT_TYPE;
     * }
     * ```
     *
     *
     *
     * ###Creating a new instance of within an instance.
     *
     * Often times you want to create a new instance of an object within an instance. If your subclassed however you cannot return a new instance of the parent class as it will not be the right sub class. `declare` provides a way around this by setting the `_static` property on each isntance of the class.
     *
     * Lets add a reproduce method `Mammal`
     *
     * ```
     * reproduce : function(options){
     *     return new this._static(options);
     * }
     * ```
     *
     * Now in each subclass you can call reproduce and get the proper type.
     *
     * ```
     * var myDog = new Dog();
     * var myDogsChild = myDog.reproduce();
     *
     * myDogsChild instanceof Dog; //true
     * ```
     *
     * ###Using the `as`
     *
     * `declare` also provides an `as` method which allows you to add your class to an object or if your using node.js you can pass in `module` and the class will be exported as the module.
     *
     * ```
     * var animals = {};
     *
     * Mammal.as(animals, "Dog");
     * Wolf.as(animals, "Wolf");
     * Dog.as(animals, "Dog");
     * Breed.as(animals, "Breed");
     *
     * var myDog = new animals.Dog();
     *
     * ```
     *
     * Or in node
     *
     * ```
     * Mammal.as(exports, "Dog");
     * Wolf.as(exports, "Wolf");
     * Dog.as(exports, "Dog");
     * Breed.as(exports, "Breed");
     *
     * ```
     *
     * To export a class as the `module` in node
     *
     * ```
     * Mammal.as(module);
     * ```
     *
     *
     */
    function createDeclared() {
        var arraySlice = Array.prototype.slice, classCounter = 0, Base, forceNew = new Function();

        var SUPER_REGEXP = /(super)/g;

        function argsToArray(args, slice) {
            slice = slice || 0;
            return arraySlice.call(args, slice);
        }

        function isArray(obj) {
            return Object.prototype.toString.call(obj) === "[object Array]";
        }

        function isObject(obj) {
            var undef;
            return obj !== null && obj !== undef && typeof obj === "object";
        }

        function isHash(obj) {
            var ret = isObject(obj);
            return ret && obj.constructor === Object;
        }

        var isArguments = function _isArguments(object) {
            return Object.prototype.toString.call(object) === '[object Arguments]';
        };

        if (!isArguments(arguments)) {
            isArguments = function _isArguments(obj) {
                return !!(obj && obj.hasOwnProperty("callee"));
            };
        }

        function indexOf(arr, item) {
            if (arr && arr.length) {
                for (var i = 0, l = arr.length; i < l; i++) {
                    if (arr[i] === item) {
                        return i;
                    }
                }
            }
            return -1;
        }

        function merge(target, source, exclude) {
            var name, s;
            for (name in source) {
                if (source.hasOwnProperty(name) && indexOf(exclude, name) === -1) {
                    s = source[name];
                    if (!(name in target) || (target[name] !== s)) {
                        target[name] = s;
                    }
                }
            }
            return target;
        }

        function callSuper(args, a) {
            var meta = this.__meta,
                supers = meta.supers,
                l = supers.length, superMeta = meta.superMeta, pos = superMeta.pos;
            if (l > pos) {
                args = !args ? [] : (!isArguments(args) && !isArray(args)) ? [args] : args;
                var name = superMeta.name, f = superMeta.f, m;
                do {
                    m = supers[pos][name];
                    if ("function" === typeof m && (m = m._f || m) !== f) {
                        superMeta.pos = 1 + pos;
                        return m.apply(this, args);
                    }
                } while (l > ++pos);
            }

            return null;
        }

        function getSuper() {
            var meta = this.__meta,
                supers = meta.supers,
                l = supers.length, superMeta = meta.superMeta, pos = superMeta.pos;
            if (l > pos) {
                var name = superMeta.name, f = superMeta.f, m;
                do {
                    m = supers[pos][name];
                    if ("function" === typeof m && (m = m._f || m) !== f) {
                        superMeta.pos = 1 + pos;
                        return m.bind(this);
                    }
                } while (l > ++pos);
            }
            return null;
        }

        function getter(name) {
            var getters = this.__getters__;
            if (getters.hasOwnProperty(name)) {
                return getters[name].apply(this);
            } else {
                return this[name];
            }
        }

        function setter(name, val) {
            var setters = this.__setters__;
            if (isHash(name)) {
                for (var i in name) {
                    var prop = name[i];
                    if (setters.hasOwnProperty(i)) {
                        setters[name].call(this, prop);
                    } else {
                        this[i] = prop;
                    }
                }
            } else {
                if (setters.hasOwnProperty(name)) {
                    return setters[name].apply(this, argsToArray(arguments, 1));
                } else {
                    return this[name] = val;
                }
            }
        }


        function defaultFunction() {
            var meta = this.__meta || {},
                supers = meta.supers,
                l = supers.length, superMeta = meta.superMeta, pos = superMeta.pos;
            if (l > pos) {
                var name = superMeta.name, f = superMeta.f, m;
                do {
                    m = supers[pos][name];
                    if ("function" === typeof m && (m = m._f || m) !== f) {
                        superMeta.pos = 1 + pos;
                        return m.apply(this, arguments);
                    }
                } while (l > ++pos);
            }
            return null;
        }


        function functionWrapper(f, name) {
            if (f.toString().match(SUPER_REGEXP)) {
                var wrapper = function wrapper() {
                    var ret, meta = this.__meta || {};
                    var orig = meta.superMeta;
                    meta.superMeta = {f: f, pos: 0, name: name};
                    switch (arguments.length) {
                    case 0:
                        ret = f.call(this);
                        break;
                    case 1:
                        ret = f.call(this, arguments[0]);
                        break;
                    case 2:
                        ret = f.call(this, arguments[0], arguments[1]);
                        break;

                    case 3:
                        ret = f.call(this, arguments[0], arguments[1], arguments[2]);
                        break;
                    default:
                        ret = f.apply(this, arguments);
                    }
                    meta.superMeta = orig;
                    return ret;
                };
                wrapper._f = f;
                return wrapper;
            } else {
                f._f = f;
                return f;
            }
        }

        function defineMixinProps(child, proto) {

            var operations = proto.setters || {}, __setters = child.__setters__, __getters = child.__getters__;
            for (var i in operations) {
                if (!__setters.hasOwnProperty(i)) {  //make sure that the setter isnt already there
                    __setters[i] = operations[i];
                }
            }
            operations = proto.getters || {};
            for (i in operations) {
                if (!__getters.hasOwnProperty(i)) {  //make sure that the setter isnt already there
                    __getters[i] = operations[i];
                }
            }
            for (var j in proto) {
                if (j !== "getters" && j !== "setters") {
                    var p = proto[j];
                    if ("function" === typeof p) {
                        if (!child.hasOwnProperty(j)) {
                            child[j] = functionWrapper(defaultFunction, j);
                        }
                    } else {
                        child[j] = p;
                    }
                }
            }
        }

        function mixin() {
            var args = argsToArray(arguments), l = args.length;
            var child = this.prototype;
            var childMeta = child.__meta, thisMeta = this.__meta, bases = child.__meta.bases, staticBases = bases.slice(),
                staticSupers = thisMeta.supers || [], supers = childMeta.supers || [];
            for (var i = 0; i < l; i++) {
                var m = args[i], mProto = m.prototype;
                var protoMeta = mProto.__meta, meta = m.__meta;
                !protoMeta && (protoMeta = (mProto.__meta = {proto: mProto || {}}));
                !meta && (meta = (m.__meta = {proto: m.__proto__ || {}}));
                defineMixinProps(child, protoMeta.proto || {});
                defineMixinProps(this, meta.proto || {});
                //copy the bases for static,

                mixinSupers(m.prototype, supers, bases);
                mixinSupers(m, staticSupers, staticBases);
            }
            return this;
        }

        function mixinSupers(sup, arr, bases) {
            var meta = sup.__meta;
            !meta && (meta = (sup.__meta = {}));
            var unique = sup.__meta.unique;
            !unique && (meta.unique = "declare" + ++classCounter);
            //check it we already have this super mixed into our prototype chain
            //if true then we have already looped their supers!
            if (indexOf(bases, unique) === -1) {
                //add their id to our bases
                bases.push(unique);
                var supers = sup.__meta.supers || [], i = supers.length - 1 || 0;
                while (i >= 0) {
                    mixinSupers(supers[i--], arr, bases);
                }
                arr.unshift(sup);
            }
        }

        function defineProps(child, proto) {
            var operations = proto.setters,
                __setters = child.__setters__,
                __getters = child.__getters__;
            if (operations) {
                for (var i in operations) {
                    __setters[i] = operations[i];
                }
            }
            operations = proto.getters || {};
            if (operations) {
                for (i in operations) {
                    __getters[i] = operations[i];
                }
            }
            for (i in proto) {
                if (i != "getters" && i != "setters") {
                    var f = proto[i];
                    if ("function" === typeof f) {
                        var meta = f.__meta || {};
                        if (!meta.isConstructor) {
                            child[i] = functionWrapper(f, i);
                        } else {
                            child[i] = f;
                        }
                    } else {
                        child[i] = f;
                    }
                }
            }

        }

        function _export(obj, name) {
            if (obj && name) {
                obj[name] = this;
            } else {
                obj.exports = obj = this;
            }
            return this;
        }

        function extend(proto) {
            return declare(this, proto);
        }

        function getNew(ctor) {
            // create object with correct prototype using a do-nothing
            // constructor
            forceNew.prototype = ctor.prototype;
            var t = new forceNew();
            forceNew.prototype = null;	// clean up
            return t;
        }


        function __declare(child, sup, proto) {
            var childProto = {}, supers = [];
            var unique = "declare" + ++classCounter, bases = [], staticBases = [];
            var instanceSupers = [], staticSupers = [];
            var meta = {
                supers: instanceSupers,
                unique: unique,
                bases: bases,
                superMeta: {
                    f: null,
                    pos: 0,
                    name: null
                }
            };
            var childMeta = {
                supers: staticSupers,
                unique: unique,
                bases: staticBases,
                isConstructor: true,
                superMeta: {
                    f: null,
                    pos: 0,
                    name: null
                }
            };

            if (isHash(sup) && !proto) {
                proto = sup;
                sup = Base;
            }

            if ("function" === typeof sup || isArray(sup)) {
                supers = isArray(sup) ? sup : [sup];
                sup = supers.shift();
                child.__meta = childMeta;
                childProto = getNew(sup);
                childProto.__meta = meta;
                childProto.__getters__ = merge({}, childProto.__getters__ || {});
                childProto.__setters__ = merge({}, childProto.__setters__ || {});
                child.__getters__ = merge({}, child.__getters__ || {});
                child.__setters__ = merge({}, child.__setters__ || {});
                mixinSupers(sup.prototype, instanceSupers, bases);
                mixinSupers(sup, staticSupers, staticBases);
            } else {
                child.__meta = childMeta;
                childProto.__meta = meta;
                childProto.__getters__ = childProto.__getters__ || {};
                childProto.__setters__ = childProto.__setters__ || {};
                child.__getters__ = child.__getters__ || {};
                child.__setters__ = child.__setters__ || {};
            }
            child.prototype = childProto;
            if (proto) {
                var instance = meta.proto = proto.instance || {};
                var stat = childMeta.proto = proto.static || {};
                stat.init = stat.init || defaultFunction;
                defineProps(childProto, instance);
                defineProps(child, stat);
                if (!instance.hasOwnProperty("constructor")) {
                    childProto.constructor = instance.constructor = functionWrapper(defaultFunction, "constructor");
                } else {
                    childProto.constructor = functionWrapper(instance.constructor, "constructor");
                }
            } else {
                meta.proto = {};
                childMeta.proto = {};
                child.init = functionWrapper(defaultFunction, "init");
                childProto.constructor = functionWrapper(defaultFunction, "constructor");
            }
            if (supers.length) {
                mixin.apply(child, supers);
            }
            if (sup) {
                //do this so we mixin our super methods directly but do not ov
                merge(child, merge(merge({}, sup), child));
            }
            childProto._super = child._super = callSuper;
            childProto._getSuper = child._getSuper = getSuper;
            childProto._static = child;
        }

        function declare(sup, proto) {
            function declared() {
                switch (arguments.length) {
                case 0:
                    this.constructor.call(this);
                    break;
                case 1:
                    this.constructor.call(this, arguments[0]);
                    break;
                case 2:
                    this.constructor.call(this, arguments[0], arguments[1]);
                    break;
                case 3:
                    this.constructor.call(this, arguments[0], arguments[1], arguments[2]);
                    break;
                default:
                    this.constructor.apply(this, arguments);
                }
            }

            __declare(declared, sup, proto);
            return declared.init() || declared;
        }

        function singleton(sup, proto) {
            var retInstance;

            function declaredSingleton() {
                if (!retInstance) {
                    this.constructor.apply(this, arguments);
                    retInstance = this;
                }
                return retInstance;
            }

            __declare(declaredSingleton, sup, proto);
            return  declaredSingleton.init() || declaredSingleton;
        }

        Base = declare({
            instance: {
                "get": getter,
                "set": setter
            },

            "static": {
                "get": getter,
                "set": setter,
                mixin: mixin,
                extend: extend,
                as: _export
            }
        });

        declare.singleton = singleton;
        return declare;
    }

    if ("undefined" !== typeof exports) {
        if ("undefined" !== typeof module && module.exports) {
            mo