# Pdfcrowd API - Node.js client library

The Pdfcrowd API lets you easily convert between HTML, PDF and various image
formats in your Node.js applications.

To use the API, you need an account on
[http://pdfcrowd.com](https://pdfcrowd.com). If you don't have one, you
can sign up [here](https://pdfcrowd.com/pricing/api/).

## Installation

To install via npm:

    $ npm install pdfcrowd

Or clone from GitHub and create a symlink in `~/.node_libraries`:

    $ git clone git@github.com:pdfcrowd/pdfcrowd-nodejs.git
    $ ln -s /path/to/pdfcrowd-nodejs ~/.node_libraries/pdfcrowd

Dependencies

* http *native module*
* querystring *native module*
* fs *native module*


## Learn more

* API Home:  <https://pdfcrowd.com/doc/api/>
* API Reference:  <https://pdfcrowd.com/doc/api/html-to-pdf/nodejs/>
* Interactive API Playground:
  * Node.js: <https://pdfcrowd.com/playground/html-to-pdf/?lang=nodejs>
  * Express.js: <https://pdfcrowd.com/playground/html-to-pdf/?lang=wf-express>

## License

This client library is licensed under the MIT License.
