const CacheBase = require("../cache.base");
const system = require("../../system");
const settings = require("../../../config/settings");
// const authUtils = require("../../utils/businessManager/authUtils");
const uuidv4 = require('uuid/v4');
//缓存首次登录的赠送的宝币数量
class UIRemoteConfigCache extends CacheBase {
  constructor() {
    super();
    
  }
  desc() {
    return "非平台应用UI配置缓存";
  }
  prefix() {
    return "g_uiremoteconfig_";
  }
  getUUID() {
    var uuid = uuidv4();
    var u = uuid.replace(/\-/g, "");
    return u;
  }
  async buildCacheVal(cachekey, inputkey, val, ex, ...items) {
    var url = items[0];
    const cacheManager = await system.getObject("db.common.cacheManager");
    var authUtils = system.getObject("util.businessManager.authUtils");
    var appData = await authUtils.getTokenInfo(settings.appKey, settings.secret);
    if (appData.status != 0) {
      return null;
    }
    //按照访问token
    var rtnKey=appData.data.accessKey;
    const restS = await system.getObject("util.restClient");
    var restResult = await restS.execPostWithAK({}, url, rtnKey);
    if (restResult) {
      if (restResult.status == 0) {
        var resultRtn = restResult.data;
        return JSON.stringify(resultRtn);
      }
    }
    return null;
  }
}
module.exports = UIRemoteConfigCache;
