{
  template: '${tmpl}',
    data: function() {
      return {
        appdoc: {},
        appdoctree: [],
        appinfo: null,
        filterText: '',
      }
    },
  mounted: function() {
    var q = this.$router.history.current.query;
    var appobj = JSON.parse(decodeURIComponent(q.app));
    this.appinfo = appobj;

    this.fetchdoc(appobj.id);

  },
  created: function() {
  },
  watch: {
    filterText(val) {
      this.$refs.tree.filter(val);
    }
  },
  methods: {
    rtnclick(){
      this.$router.go(-1);
    },
    nclick(data, node, nodecom){
      console.log(data);
      location.href = "#" + data.label;
    },
    filterNode(value, data) {
      if (!value) return true;
      return data.label.indexOf(value) !== -1;
    },
    async fetchdoc(appid){
      var d = await this.$root.postReq("/web/common/metaCtl/getApiDoc", { appid: appid, doc: this.appinfo.docUrl });
      if (d.status == 0) {
        var rtnData = d.data;
        console.log(rtnData, "rtnData");


        var newList = {};
        for (let keyPag of Object.keys(rtnData)) {
          var keyPagList = keyPag.split('|');
          if (keyPagList.length > 0 && keyPagList[0]) {
            console.log(rtnData[keyPag], "rtnData[keyPag]...........");
            console.log(keyPag, "keyPag...........");
            newList[keyPag] = rtnData[keyPag];
            this.appdoctree.push({
              label: keyPag,
              children: rtnData[keyPag].map(function (r) {
                return {
                  label: r.name,
                  children: r.methods.map((m) => {
                    return {
                      label: m.name
                    }
                  })
                };
              }),
            });
          }
        }
        this.appdoc = newList;
      }

    },

  },
  vname: "gsb_docquery"
}
