var APIBase = require("../../api.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
class icName extends APIBase {
    constructor() {
        super();
        this.utilsIcNameSve = system.getObject("service.utilsSve.utilsIcNameSve");
    }
    /**
      * 接口跳转-POST请求
      * action_process  执行的流程
      * action_type     执行的类型
      * action_body     执行的参数
      */
    async springBoard(pobj, qobj, req) {
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        var result = await this.opActionProcess(pobj, pobj.actionType, req);
        return result;
    }
    async opActionProcess(pobj, action_type, req) {
        var opResult = null;
        switch (action_type) {
            case "test"://测试
                opResult = system.getResultSuccess("测试接口");
                break;
            case "checkBusinessNameList"://工商核名
                opResult = await this.utilsIcNameSve.checkBusinessNameList(pobj.actionBody);
                break;
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }

}
module.exports = icName;
