var APIBase = require("../../api.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
class Need extends APIBase {
    constructor() {
        super();
        this.needsolutionSve = system.getObject("service.need.needSolutionSve");
        this.needinfoSve = system.getObject("service.need.needInfoSve");
        this.utilsMsgSendSve = system.getObject("service.utilsSve.utilsMsgSendSve");
    }
    /**
      * 接口跳转-POST请求
      * action_process  执行的流程
      * action_type     执行的类型
      * action_body     执行的参数
      */
    async springBoard(pobj, qobj, req) {
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        var result = await this.opActionProcess(pobj, pobj.actionType, req);
        return result;
    }
    async opActionProcess(pobj, action_type, req) {
        var opResult = null;
        var verificationCodeList = [
              "needSubmit"
        ];
        var self = this;
        if (verificationCodeList.indexOf(action_type) > -1) {
            if (!pobj.actionBody.ContactsMobile) {
                opResult = system.getResult(null, "ContactsMobile参数错误");
                return opResult;
            }
            if (!pobj.actionBody.VerificationCode) {
                opResult = system.getResult(null, "verificationCode参数错误");
                return opResult;
            }
            var v = await self.utilsMsgSendSve.getVerificationCode(pobj.actionBody.ContactsMobile);
            if (v != pobj.actionBody.VerificationCode) {
                opResult = system.getResult(null, "验证码错误");
                return opResult;
            }
        }
        switch (action_type) {
            case "test"://测试
                opResult = system.getResultSuccess("测试接口");
                break;
            case "needSubmit"://需求提交
                opResult = await this.needinfoSve.needSubmit(pobj.actionBody);
                break;
            case "needList"://需求列表
                opResult = await this.needinfoSve.needList(pobj.actionBody);
                break;
            case "needDetail"://需求详情
                opResult = await this.needinfoSve.needDetail(pobj.actionBody);
                break;
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }

}
module.exports = Need;

