const system = require("../../../system");
const Dao = require("../../dao.base");
class NeedInfoDao extends Dao {
  constructor() {
    super(Dao.getModelName(NeedInfoDao));
  }

  //根据产品区域获取服务商详情
  async findServiceByProductType(obj) {
    var sql = "select  xsi.servicer_code,xsi.servicer_name,xsi.push_domain_addr from x_product xp join x_service_info xsi on xp.servicer_code=xsi.servicer_code "
    sql += "where xp.path_code=:path_code and xp.region_id=:region_id";
    try {
      var list = await this.customQuery(sql, obj);
      var rtn = {};
      if (list && list.length > 0) {
        rtn.servicer_code = list[0].servicer_code;
        rtn.servicer_name = list[0].servicer_name;
        rtn.push_domain_addr = list[0].push_domain_addr;
        return system.getResultSuccess(rtn);
      } else {
        return system.getResultFail(-203, "servicer is empty");
      }
    } catch (error) {
      return system.getResultFail(-203, errorF);
    }
  }

  //获取分配服务商商机规则 通过地区编号和地区名字
  async getXBossServiceAllotByIdName(region_id, region_name) {
    var whereSql = "";
    var params = {};
    if (region_id) {
      whereSql = " region_id=:region_id"
      params.region_id = region_id;
    }
    if (region_name) {
      if (whereSql) {
        whereSql = whereSql + " and region_name=:region_name"
      }
      else {
        whereSql = " region_name=:region_name"
      }
      params.region_name = region_name;
    }
    var sql = "select * from v_service_allot_business" + (whereSql ? " where " + whereSql : "");
    var result = await this.customQuery(sql, params);
    return result
  }
  //插入新的需求,Xboss_need_info
  async xbossAddNeedInfo(pobj) {
    var insertobj = {
      created_at: new Date(),
      servicer_code: pobj.servicer_code,
      need_num: pobj.need_num
    }
    var sql = "insert into x_need_info (servicer_code,need_num,created_at) values (:servicer_code,:need_num,:created_at)";
    var result = await this.customInsert(sql, insertobj);
    return result;
  }

}
module.exports = NeedInfoDao;
