const system=require("../../../system");
const Dao=require("../../dao.base");
class OrderDeliveryDao extends Dao{
  constructor(){
    super(Dao.getModelName(OrderDeliveryDao));
  }
  /**
   * 概览数据统计（用户控制台概览数据，订单统计）
   * @param {*} deliveryStatus 
   * @param {*} userId 
   * @param {*} productTypeOne 
   */
  async findOverviewCount(deliveryStatus,userId,productTypeOne){
    var params = {
      deliveryStatus:deliveryStatus,
      userId:userId,
      productTypeOne:"%/"+productTypeOne+"/%"
    };
    var sql = "select count(1) as dataCount from v_order_oproduct_odelivery where deleted_at is null and delivery_status = "+deliveryStatus+" "+
    " and user_id = :userId and product_type like :productTypeOne ";
    var tmpResultCount = await this.customQuery(sql, params);
    return tmpResultCount && tmpResultCount.length > 0 ? tmpResultCount[0].dataCount : 0;
  }
  /**
   * 根据交付状态获取订单列表数据
   * @param {*} userId 用户id
   * @param {*} status 交付状态
   */
  async getOrderListByStatus(userId,status){
    var params = {
      userId:userId,
      status:status
    };
    var sql = "select `order_num`,`tx_orders_num` as main_orders_num,`need_num`,`user_name`,`user_id`,"+
    "`updated_at`,`total_sum`,`refund_sum`,`pay_time`,`order_status`,`order_status_name`,`servicer_code`,"+
    "`servicer_name`,`product_type`,`product_type_name`,`order_snapshot`,`end_time`,`time_span`,`time_unit`,"+
    "`region_id`,`region_name`,`delivery_status`,`delivery_status_name`,`deliver_content` from v_order_oproduct_odelivery where deleted_at is null and delivery_status = :status "+
    " and user_id = :userId ";
    var list = await this.customQuery(sql, params);
    return list;
  }
  /**
   * 根据资质证书编号获取用户资质订单交付信息
   * @param {*} certificateNo 资质证书编号
   * @param {*} userId 用户id
   */
  async findByCertificateNoAndUser(certificateNo,userId){
    var params = {
      userId:userId,
      certificateNo:certificateNo
    };
    var sql = "select tx_orders_num, json_extract(deliver_content,  '$.proposerInfo.businessLicense' ) as businessLicense from v_order_oproduct_odelivery "+
    "where deleted_at is null and deliver_content is not null and user_id = :userId  "+
    " and deliver_content->'$.qualification' is not null and deliver_content->'$.proposerInfo' is not null "+
    "and deliver_content->'$.qualification.certificateNumber' = :certificateNo order by updated_at desc limit 1 ";
    var list = await this.customQuery(sql, params);
    return list;
  }
  /**
   * 获取资质证照年报列表
   * @param {*} orderNum 
   */
  async getAnnualReportByTxOrderNum(tx_orders_num){
    var params = {
      tx_orders_num: tx_orders_num
    };
    var sql = "select json_extract(deliver_content,  '$.annualReport' ) as annualReportList from v_order_oproduct_odelivery where tx_orders_num = :tx_orders_num "+
    "and deliver_content->'$.annualReport' is not null and (product_type='/qcfw/icpannals/' or product_type='/qcfw/ediannals/' ) order by updated_at desc limit 1";
    var list = await this.customQuery(sql, params);
    return list;
  }
  /**
   * 根据订单号获取订单详情
   * @param {*} orderNum 订单号
   */
  async getOrderDetailByOrderNum(orderNum){
    var params = {
      orderNum: orderNum
    };
    var sql = "select * from v_order_oproduct_odelivery where order_num = :orderNum order by updated_at desc limit 1 ";
    var list = await this.customQuery(sql, params);
    return list;
  }
  /**
   * 通过订单号获取资质证照信息
   */
  async getQcInfoByOrderNum(orderNum){
    var params = {
      orderNum: orderNum
    };
    var sql = "select deliver_content,product_type,user_id,user_name,servicer_code,servicer_name from v_order_oproduct_odelivery where order_num = :orderNum and delivery_status = 170 "+
    "and deliver_content is not null and (product_type='/qcfw/icp/' or product_type='/qcfw/edi/' ) order by updated_at desc limit 1";
    var list = await this.customQuery(sql, params);
    return list;
  }
    /**
   * 获取订单交付信息
   */
  async getOrderInfoByOrderNum(orderNum){
    var params = {
      orderNum:orderNum
    };
    var sql = "select * from v_order_oproduct_odelivery where deleted_at is null and order_num = :orderNum order by updated_at desc limit 1";
    var list = await this.customQuery(sql, params);
    return list;
  }
}
module.exports=OrderDeliveryDao;
