const system = require("../../../system");
const Dao = require("../../dao.base");
class OrderProductDao extends Dao {
  constructor() {
    super(Dao.getModelName(OrderProductDao));
  }
  /**
   * 根据申请主体名称以及用户获取订单产品列表
   */
  async findByCompanyAndUser(creditCode, userId) {
    var params = {
      user_id: userId,
      creditCode: creditCode,
      creditCode2:creditCode
    };
    var sql = "SELECT order_num,total_sum,product_type_name,product_type,delivery_status,delivery_status_name,"+
    "updated_at,order_snapshot FROM `v_order_oproduct_odelivery` where user_id=:user_id and "+
    "(deliver_content->'$.companyInfo' is not null and deliver_content->'$.companyInfo.creditCode'=:creditCode) "+
    // " or "+
    // "( deliver_content -> '$.proposerInfo' IS NOT NULL "+
    // "AND deliver_content -> '$.proposerInfo.businessLicense' IS NOT NULL "+
    // "AND deliver_content -> '$.proposerInfo.businessLicense.enterpriseCode' = :creditCode2 ))"+
    "order by updated_at desc";
    var list = await this.customQuery(sql, params);
    return list;
  }

  async entTimeCreate(obj, t) {
    if (obj.created_at && obj.time_span && obj.time_unit) {
      if (obj.time_unit == "y") {
        obj.end_time = obj.created_at.setFullYear(obj.created_at.getFullYear() + Number(obj.time_span))
      }
      if (obj.time_unit == "m") {
        obj.end_time = obj.created_at.setMonth(obj.created_at.getMonth() + Number(obj.time_span))
      }
      if (obj.time_unit == "d") {
        obj.end_time = obj.created_at.setDate(obj.created_at.getDate() + Number(obj.time_span))
      }
    }
    return await this.create(obj, t);
  }
}
module.exports = OrderProductDao;
