const system = require("../../../system");
const { PDICT } = require("../../../../config/platform");
module.exports = (db, DataTypes) => {
  return db.define("needInfo", {
    need_num: DataTypes.STRING(100),
    user_id: DataTypes.STRING(100),
    user_name: DataTypes.STRING(100),	//user_name	用户名称
    contacts_name: DataTypes.STRING(20),	//contacts_name	联系人姓名
    contacts_mobile: DataTypes.STRING(20),	//contacts_mobile	联系人电话
    region_id: DataTypes.STRING(100),	//region_id	地区id
    region_name: DataTypes.STRING(100),	//region_name	地区名称
    consult_type: DataTypes.STRING(100),	//consult_type	需求类型（产品二类id）
    wechat_no: DataTypes.STRING(100),//微信号
    email: DataTypes.STRING(100),//邮箱
    consult_type_name: DataTypes.STRING(255),	//consult_type_name	需求类型名称（产品二类名称）
    status:	//status	需求状态：1.已提交、2.待顾问反馈、3.待用户确认、4.已完成、5.已关闭
    {
      type: DataTypes.INTEGER,
      set: function (val) {
        this.setDataValue("status", val);
        this.setDataValue("status_name", PDICT.need_status[val]);
      }
    },
    status_name: DataTypes.STRING(100),	//
    notes: DataTypes.STRING(255),	//notes	备注
    close_reason: DataTypes.STRING(255),	//关闭原因
    need_info: DataTypes.JSON,	//need_info	需求信息（往服务商那边推送的信息）
    servicer_code: DataTypes.STRING(100),   //服务商
    servicer_name: DataTypes.STRING(100),
  }, {
    paranoid: true,//假的删除
    underscored: true,
    version: true,
    freezeTableName: true,
    timestamps: true,
    // updatedAt: false,
    //freezeTableName: true,
    // define the table's name
    tableName: 'b_need_info',
    validate: {

    },
    indexes: [
      // Create a unique index on email
      //  {
      //    unique: true,
      //    fields: ['email']
      //  },
      //
      //  // Creates a gin index on data with the jsonb_path_ops operator
      //  {
      //    fields: ['data'],
      //    using: 'gin',
      //    operator: 'jsonb_path_ops'
      //  },
      //
      //  // By default index name will be [table]_[fields]
      //  // Creates a multi column partial index
      //  {
      //    name: 'public_by_author',
      //    fields: ['author', 'status'],
      //    where: {
      //      status: 'public'
      //    }
      //  },
      //
      //  // A BTREE index with a ordered field
      //  {
      //    name: 'title_index',
      //    method: 'BTREE',
      //    fields: ['author', {attribute: 'title', collate: 'en_US', order: 'DESC', length: 5}]
      //  }
    ]
  });
}
