const system = require("../../../system");
const { PDICT } = require("../../../../config/platform");
module.exports = (db, DataTypes) => {
  return db.define("orderDelivery", {
    order_num: DataTypes.STRING,
    tx_orders_num: DataTypes.STRING,
    user_id: DataTypes.STRING,
    user_name: DataTypes.STRING,
    wechat_no: DataTypes.STRING(100),//微信号
    email: DataTypes.STRING(100),//邮箱
    deliver_content: DataTypes.JSON,    //交付内容
    delivery_status://交付状态 order_delivery_status:{"1":"已接单","10":"收集工商注册材料","11":"工商审核环节","12":"刻章环节","13":"证件邮寄环节","14":"您已签收"},
    {
      type: DataTypes.INTEGER,
      set: function (val) {
        this.setDataValue("delivery_status", val);
        this.setDataValue("delivery_status_name", PDICT.order_delivery_status[val]);
      }
    },
    delivery_status_name: DataTypes.STRING,//交付状态名称			utf8mb4	utf8mb4_german2_ci	0	0	0	0	0	0	0

  }, {
    paranoid: true,//假的删除
    underscored: true,
    version: true,
    freezeTableName: true,
    timestamps: true,
    // updatedAt: true,
    // createdAt: true,
    tableName: 'b_order_delivery',

  });
}
