const system = require("../../../system");
module.exports = (db, DataTypes) => {
  return db.define("orderProduct", {
    order_num: DataTypes.STRING,  //订单号
    tx_orders_num: DataTypes.STRING,   //腾讯主订单号
    user_id: DataTypes.STRING,   //用户id
    user_name: DataTypes.STRING,   //用户名称
    region_id: DataTypes.STRING,    //地区id
    region_name: DataTypes.STRING,   //地区名称
    product_icon: DataTypes.STRING,    //产品图标
    product_type: DataTypes.STRING,    //需求类型（产品二类id）
    product_type_name: DataTypes.STRING,    //需求类型名称（产品二类名称）
    order_snapshot: DataTypes.JSON,     //订单快照
    tx_order_snapshot: DataTypes.JSON,     //腾讯订单快照
    product_snapshot: DataTypes.STRING,    //产品快照
    time_span: DataTypes.STRING,    //计费数量
    time_unit: DataTypes.STRING,   //计费周期 年：y，月：m，日：d，时：h，分：M，秒：s，一次性购买：p       
    end_time: DataTypes.DATE,    //到期时间
    start_time: DataTypes.DATE,    //开始时间
    status: DataTypes.STRING,  //1正常，2隔离，3销毁
    isolated_time: DataTypes.DATE,    //隔离时间
    servicer_code: DataTypes.STRING,   //服务商
    servicer_name: DataTypes.STRING
  }, {
    paranoid: false,//假的删除
    underscored: true,
    version: true,
    freezeTableName: true,
    timestamps: true,
    // updatedAt: true,
    // createdAt: true,
    //freezeTableName: true,
    // define the table's name
    tableName: 'b_order_product',
    validate: {

    },
    indexes: [
      // Create a unique index on email
      //  {
      //    unique: true,
      //    fields: ['email']
      //  },
      //
      //  // Creates a gin index on data with the jsonb_path_ops operator
      //  {
      //    fields: ['data'],
      //    using: 'gin',
      //    operator: 'jsonb_path_ops'
      //  },
      //
      //  // By default index name will be [table]_[fields]
      //  // Creates a multi column partial index
      //  {
      //    name: 'public_by_author',
      //    fields: ['author', 'status'],
      //    where: {
      //      status: 'public'
      //    }
      //  },
      //
      //  // A BTREE index with a ordered field
      //  {
      //    name: 'title_index',
      //    method: 'BTREE',
      //    fields: ['author', {attribute: 'title', collate: 'en_US', order: 'DESC', length: 5}]
      //  }
    ]
  });
}
