const system = require("../../../system");
const { PDICT } = require("../../../../config/platform");
const ServiceBase = require("../../sve.base");
var settings = require("../../../../config/settings");
class ApplyInfoService extends ServiceBase {
  constructor() {
    super("order", ServiceBase.getDaoName(ApplyInfoService));
    this.orderProductDao = system.getObject("db.order.orderProductDao");
    this.needInfoDao = system.getObject("db.need.needInfoDao");
    this.orderInfoDao = system.getObject("db.order.orderInfoDao");
    this.orderDeliveryDao = system.getObject("db.order.orderDeliveryDao");
  }
  /**
   * 用户获取业务申请实体列表
   * @param {*} pobj 
   */
  async getApplyListByUserAndType(pobj) {
    if (!pobj || !pobj.actionBody) {
      return system.getResultFail(-100, "参数错误");
    }
    var ab = pobj.actionBody;
    if (!ab.UserId) {
      return system.getResultFail(-102, "用户id不能为空");
    }
    if (!ab.ApplyType) {
      return system.getResultFail(-103, "申请主体类型不能为空");
    }
    var limit = ab.PageSize ? Number(ab.PageSize) : 10;
    var offset = ab.CurrentPage ? (Number(ab.CurrentPage) - 1) * limit : 0
    var countObj = { apply_type: ab.ApplyType, user_id: ab.UserId };
    var whereObj = { apply_type: ab.ApplyType, user_id: ab.UserId };
    if (ab.ApplyName) {
      whereObj["apply_name"] = { [this.db.Op.like]: "%" + ab.ApplyName + "%" };
      countObj["apply_name"] = { [this.db.Op.like]: "%" + ab.ApplyName + "%" };
    }
    if (ab.Domicile) {
      whereObj["domicile"] = { [this.db.Op.like]: "%" + ab.Domicile + "%" };
      countObj["domicile"] = { [this.db.Op.like]: "%" + ab.Domicile + "%" };
    }
    var count = await this.dao.findCount({ where: countObj });
    var list = await this.dao.model.findAll({
      where: whereObj,
      limit: limit,
      offset: offset,
      raw: true,
      attributes: [
        "apply_name",
        "credit_code",
        "apply_type",
        "operator",
        "regist_capital",
        "business_term",
        "establish_time",
        "domicile"
      ],
      order: [["created_at", 'desc']]
    });
    var result =system.getResultSuccess(list);
    result.dataCount = count;
    return result;

  }
  /**
   * 用户根据业务申请实体获取实体信息以及业务信息
   */
  async getApplyAndSolutionInfo(pobj) {
    if (!pobj || !pobj.actionBody) {
      return system.getResultFail(-100, "参数错误");
    }
    var ab = pobj.actionBody;
    if (!ab.UserId) {
      return system.getResultFail(-102, "用户id不能为空");
    }
    if (!ab.CreditCode) {
      return system.getResultFail(-103, "社会统一信用代码不能为空");
    }
    var applyinfo = await this.dao.model.findOne({
      where: { user_id: ab.UserId, credit_code: ab.CreditCode },
      attributes: [
        "user_id",
        "apply_name",
        "credit_code",
        "apply_type",
        "operator",
        "regist_capital",
        "business_term",
        "establish_time",
        "domicile",
        "ent_type",
        "business_scope"
      ],
      raw: true
    });
    if (!applyinfo || !applyinfo.credit_code) {
      return system.getResultFail(-300, "未知申请实体信息");
    }
    var list = await this.orderProductDao.findByCompanyAndUser(applyinfo.credit_code, ab.UserId);
    // var list = await this.dao.getPaidSolutionByApplyInfo(applyinfo);
    var result = { applyInfo: applyinfo, productList: list };
    return system.getResultSuccess(result);
  }
  /**
   * 获取用户概览信息
   */
  async getOverviewInfoByUser(pobj) {
    if (!pobj || !pobj.actionBody) {
      return system.getResultFail(-100, "参数错误");
    }
    var ab = pobj.actionBody;
    if (!ab.UserId) {
      return system.getResultFail(-102, "用户id不能为空");
    }
    if (!ab.ProductTypeOne) {//产品大类
      return system.getResultFail(-103, "产品大类编码不能为空");
    }
    var productTypeOne = "/" + ab.ProductTypeOne + "/"
    // { [this.db.Op.like]: productTypeOne }
    var companyCount = await this.dao.findCount({ where: { apply_type: 1, user_id: ab.UserId } });//公司数量
    var selfEmployedPersonCount = await this.dao.findCount({ where: { apply_type: 2, user_id: ab.UserId } });//个体户数量
    var waitConfirmCount = await this.needInfoDao.findCount({ where: { status: 3, user_id: ab.UserId, consult_type: { [this.db.Op.like]: productTypeOne } } });//待确认方案数量
    var waitReceiveFileOrderCount = await this.orderDeliveryDao.findOverviewCount(150, ab.UserId, ab.ProductTypeOne);//待收文件数量
    // var unpaidCount = await this.orderInfoDao.findCount({where:{order_status:0}});//待支付订单数量
    if(ab.ProductTypeOne == "qcfw"){//资质证照
      var internetContentProviderCount = await this.orderInfoDao.findOrderCountByProductPathCode("/qcfw/icp/",ab.UserId);//icp数量
      var electronicDataInterchangeCount = await this.orderInfoDao.findOrderCountByProductPathCode("/qcfw/edi/",ab.UserId);//edi数量
      var resultObj = {
        internetContentProviderCount: internetContentProviderCount, waitConfirmCount: waitConfirmCount, electronicDataInterchangeCount: electronicDataInterchangeCount,
        waitReceiveFileOrderCount: waitReceiveFileOrderCount
      };
      return system.getResult(resultObj);
    }
    var resultObj = {
      companyCount: companyCount, waitConfirmCount: waitConfirmCount, selfEmployedPersonCount: selfEmployedPersonCount,
      waitReceiveFileOrderCount: waitReceiveFileOrderCount
    };
    return system.getResult(resultObj);
  }
}
module.exports = ApplyInfoService;
