const system = require("../../../system");
const ServiceBase = require("../../sve.base");
var settings = require("../../../../config/settings");
const {PDICT,MsgTemplate} = require("../../../../config/platform");
var moment = require('moment');
class OrderDeliveryService extends ServiceBase {
  constructor() {
    super("order", ServiceBase.getDaoName(OrderDeliveryService));
    this.orderInfoDao = system.getObject("db.order.orderInfoDao");
    this.orderProductDao = system.getObject("db.order.orderProductDao");
    this.qualificationCertificateDao = system.getObject("db.order.qualificationCertificateDao");
    this.applyInfoDao = system.getObject("db.order.applyInfoDao");
    this.execClient = system.getObject("util.execClient");
    this.utilsMsgSendSve = system.getObject("service.utilsSve.utilsMsgSendSve");
  }
  //服务商提交交付信息
  async submitDeliveryInfo(pobj){
    if(!pobj || ! pobj.actionBody){
      return system.getResultFail(-100,"参数错误");
    }
    var ab = pobj.actionBody;
    if(!ab.orderNum){
      return system.getResultFail(-101,"订单号不能为空");
    }
    if(!ab.deliveryContent){
      return system.getResultFail(-102,"交付内容不能为空");
    }
    var orderinfo = await this.orderInfoDao.model.findOne({
      where:{order_num:ab.orderNum},
      attributes:[`id`, `order_num`, `tx_orders_num`, `need_num`, `user_id`, `user_name`, `quantity`, `total_sum`, `discount_amount`, `pay_total_sum`, `refund_sum`, `order_status`],
      raw:true
    });
    if(!orderinfo || !orderinfo.id){
      return system.getResultFail(-300,"未知订单信息");
    }
    //订单状态1: 已接单, 310: 部分已退款, 320: 已退款,330: 已作废
    if(orderinfo.order_status!=1){
      return system.getResultFail(-301,"操作失败，订单状态有误");
    }
    var orderdelivery = await this.dao.model.findOne({
      where:{ order_num:orderinfo.order_num},raw:true
    });
    if(orderdelivery && orderdelivery.id){
      if(orderdelivery.delivery_status!=1){
        return system.getResultFail(-302,"交付状态错误，只能提交待接单状态交付信息");
      }
      var updateObj = {
        id:orderdelivery.id,
        delivery_status:"2",
        deliver_content:ab.deliveryContent
      };
      await this.dao.update(updateObj);
      return system.getResultSuccess();
    }else{
      var createObj={
        delivery_status:"2",
        order_num:orderinfo.order_num,
        tx_orders_num:orderinfo.tx_orders_num,
        user_id:orderinfo.user_id,
        user_name:orderinfo.user_name,
        deliver_content:ab.deliveryContent
      };
      await this.dao.create(createObj);
      return system.getResultSuccess();
    }
  }

  //根据交付状态获取订单列表（概览数据待收文件->待收文件订单列表）
  async getOrderListByStatus(pobj){
    if(!pobj || ! pobj.actionBody){
      return system.getResultFail(-100,"参数错误");
    }
    var ab = pobj.actionBody;
    if(!ab.UserId){
      return system.getResultFail(-101,"用户id不能为空");
    }
    if(!ab.Status){
      return system.getResultFail(-102,"订单状态不能为空");
    }
    var list = await this.dao.getOrderListByStatus(ab.UserId,ab.Status);
    return system.getResultSuccess(list);
  }

  //修改订单交付状态
  async updateOrderStatus(pobj) {
    if (!pobj || !pobj.actionBody) {
      return system.getResultFail(-100, "参数错误");
    }
    var ab = pobj.actionBody;
    if (!ab.orderNum) {
      return system.getResultFail(-101, "订单号不能为空");
    }
    if (!ab.status) {
      return system.getResultFail(-103, "订单交付状态不能为空");
    }
    var deliveryStausObj = PDICT.order_delivery_status;
    if (!deliveryStausObj.hasOwnProperty(ab.status)) {
      return system.getResultFail(-104, "未知订单状态");
    }
    var queryParam = {
      where: { order_num: ab.orderNum },
      attributes: ["id",
        "order_num",
        "tx_orders_num",   //腾讯主订单号
        "need_num",   //需求号
        "user_name",   //用户名称
        "quantity",   //订单数量
        "total_sum",   //订单总额
        "discount_amount",  //折扣金额
        "pay_total_sum",  //付订单总额
        "refund_sum",   //退款总额
        "order_status",  //订单状态1: 已付款, 2: 部分已退款, 3: 已退款,4: 已作废
        "notes"   //备注
        , "created_at", "updated_at"
      ],
      raw: true
    };
    //获取订单信息
    var orderinfo = await this.orderInfoDao.model.findOne(queryParam);
    if (!orderinfo || !orderinfo.id) {
      return system.getResultFail(-300, "未知订单信息");
    }
    if (orderinfo.order_status == 310 || orderinfo.order_status == 320 || orderinfo.order_status == 330) {
      return system.getResultFail(-301, "订单状态错误");
    }
    var orderproduct = await this.orderProductDao.model.findOne({
      where:{order_num:ab.orderNum },raw:true
    });
    //获取交付信息
    var orderdeliveryinfo = await this.dao.model.findOne({
      where: { order_num: ab.orderNum }, raw: true
    });
    if (!orderdeliveryinfo || !orderdeliveryinfo.id) {
      return system.getResultFail(-302, "未知订单交付信息");
    }
    if (orderdeliveryinfo.delivery_status > ab.status && orderproduct && orderproduct.product_type!="/qcfw/ediannals/" && orderproduct.product_type!="/qcfw/icpannals/") {
      return system.getResultFail(-303, "订单交付状态不能退回");
    }
    var deliver_content = orderdeliveryinfo.deliver_content || {};
    var updateObj = { id: orderdeliveryinfo.id, delivery_status: ab.status };
    if (ab.deliverContent && Object.keys(ab.deliverContent).length > 0) {//判断传参交付内容不为空
      // for (var item in ab.deliverContent) {
      //   deliver_content[item] = ab.deliverContent[item];
      // }
      Object.assign(deliver_content, ab.deliverContent);
      updateObj["deliver_content"] = deliver_content;
    }
    await this.dao.update(updateObj);
    if(ab.status==170 || ab.status==30 || ab.status==160 || ab.status==150 ){//交付状态：已完成,已交付，已签收
      this.createQualificationCertificateInfo(ab.orderNum);//创建资质证照信息
      this.createApplyInfo(ab.orderNum);//创建申请主体信息
    }
    //发送短信通知
    this.sendSmsNotification(ab.orderNum,ab.status);
    return system.getResultSuccess();
  }
  /**
   * 发送短信通知
   * @param {*} orderNum 订单号
   * @param {*} status 订单交付状态
   */
  async sendSmsNotification(orderNum,status){
    try {
      var smsParams = {phoneNumber:null,messageBody:null};//短信通知参数
      var webinfoParams = {"title":null,"subAccount":null,"messageBody":null};//站内信通知参数
      //获取订单详情
      var orderDetailRes = await this.dao.getOrderDetailByOrderNum(orderNum);
      if(orderDetailRes && orderDetailRes.length>0){
        var orderdetail = orderDetailRes[0];//订单详情信息
        
        var productType=orderdetail.product_type;//产品类型
        var product_type_name = orderdetail.product_type_name;//产品类型名称
        var productArr = product_type_name.split("/");
        if(productArr && productArr.length==4){
          product_type_name = productArr[2];
        }
        //联系人电话
        smsParams.phoneNumber=orderdetail.order_snapshot && orderdetail.order_snapshot.contactsPhone?orderdetail.order_snapshot.contactsPhone:"";//联系人手机号
        //用户id
        webinfoParams.subAccount=orderdetail.user_id || "";//用户id
        //判断联系人手机号、用户id、产品类型
        if(smsParams.phoneNumber && webinfoParams.subAccount && orderdetail.product_type){
          if(productType=="/ic/cpreg/" && status==130){//云上公司注册工商审核环节不通知
            return;
          }
          var smsMessageBody= null;//短信模板
          var webinfoMessageBody = null;//站内信模板
          if(productType.indexOf("/ic/")>=0){//工商产品
            smsMessageBody=MsgTemplate.ic.order[status] && MsgTemplate.ic.order[status].sms?MsgTemplate.ic.order[status].sms:"";
            webinfoMessageBody=MsgTemplate.ic.order[status] && MsgTemplate.ic.order[status].webinfo?MsgTemplate.ic.order[status].webinfo:"";
            webinfoParams.title  = MsgTemplate.ic.order[status] && MsgTemplate.ic.order[status].webinfotitle?MsgTemplate.ic.order[status].webinfotitle:"";
            
            if(smsMessageBody && webinfoMessageBody){//判断短信模板、站内信模板都有值
              smsMessageBody = smsMessageBody.replace(/{productName}/g,product_type_name)
              .replace(/{orderNum}/g,orderdetail.order_num);
              webinfoMessageBody = webinfoMessageBody.replace(/{productName}/g,product_type_name)
              .replace(/{orderNum}/g,orderdetail.order_num);
              if(orderdetail.end_time){//过期时间
                smsMessageBody = smsMessageBody.replace(/{expirationDate}/g,orderdetail.end_time);
                webinfoMessageBody = webinfoMessageBody.replace(/{expirationDate}/g,orderdetail.end_time);
                var m1 = moment(new Date());
                var m2 = moment(new Date(orderdetail.end_time));
                var days = m2.diff(m1,'day');
                if(days && days>=0){//剩余天数
                  smsMessageBody = smsMessageBody.replace(/{timeRemaining}/g,days);
                  webinfoMessageBody = webinfoMessageBody.replace(/{timeRemaining}/g,days);
                }
              }
              var deliverContent = orderdetail.deliver_content;
              if(deliverContent){
                //注册园区
                if(productType=="/ic/cpreg/" && deliverContent.companyInfo && deliverContent.companyInfo.registeredPark){
                  smsMessageBody = smsMessageBody.replace(/{parkName}/g,deliverContent.companyInfo.registeredPark);
                  webinfoMessageBody = webinfoMessageBody.replace(/{parkName}/g,deliverContent.companyInfo.registeredPark);
                }
                //邮寄信息
                if(deliverContent.expressInfo && deliverContent.expressInfo.logisticsCompany && deliverContent.expressInfo.trackingNumber ){
                  smsMessageBody = smsMessageBody.replace(/{logisticsCompany}/g,deliverContent.expressInfo.logisticsCompany)
                  .replace(/{waybillNo}/g,deliverContent.expressInfo.trackingNumber);
                  webinfoMessageBody = webinfoMessageBody.replace(/{logisticsCompany}/g,deliverContent.expressInfo.logisticsCompany)
                  .replace(/{waybillNo}/g,deliverContent.expressInfo.trackingNumber);
                }
              }
            }
          }
          if(productType.indexOf("/qcfw/")>=0){//资质证照
            webinfoParams.title  = MsgTemplate.qcfw.order[status] && MsgTemplate.qcfw.order[status].webinfotitle?MsgTemplate.qcfw.order[status].webinfotitle:"";
            
            if(status==170 && (productType=="/qcfw/icpannals/" || productType=="/qcfw/ediannals/" )){//年报已完成
              smsMessageBody=MsgTemplate.qcfw.order[status] && MsgTemplate.qcfw.order[status].qcsms?MsgTemplate.qcfw.order[status].qcsms:"";
              webinfoMessageBody=MsgTemplate.qcfw.order[status] && MsgTemplate.qcfw.order[status].qcwebinfo?MsgTemplate.qcfw.order[status].qcwebinfo:"";
            }else{
              smsMessageBody=MsgTemplate.qcfw.order[status] && MsgTemplate.qcfw.order[status].sms?MsgTemplate.qcfw.order[status].sms:"";
              webinfoMessageBody=MsgTemplate.qcfw.order[status] && MsgTemplate.qcfw.order[status].webinfo?MsgTemplate.qcfw.order[status].webinfo:"";
            
            }
            if(smsMessageBody){
              smsMessageBody = smsMessageBody.replace(/{productName}/g,product_type_name);
              webinfoMessageBody = webinfoMessageBody.replace(/{productName}/g,product_type_name);
              if(orderdetail.user_id){//用户账号
                smsMessageBody = smsMessageBody.replace(/{userId}/g,orderdetail.user_id);
                webinfoMessageBody = webinfoMessageBody.replace(/{userId}/g,orderdetail.user_id);
              }
              if(orderdetail.user_name){//用户昵称
                smsMessageBody = smsMessageBody.replace(/{userName}/g,orderdetail.user_name);
                webinfoMessageBody = webinfoMessageBody.replace(/{userName}/g,orderdetail.user_name);
              }
              if(productArr && productArr[1]){//产品一类名称
                smsMessageBody = smsMessageBody.replace(/{productType}/g,productArr[1]);
                webinfoMessageBody = webinfoMessageBody.replace(/{productType}/g,productArr[1]);
              }
              var deliverContent = orderdetail.deliver_content;
              if(deliverContent){
                //邮寄信息
                if(deliverContent.expressInfo && deliverContent.expressInfo.logisticsCompany && deliverContent.expressInfo.trackingNumber ){
                  smsMessageBody = smsMessageBody.replace(/{logisticsCompany}/g,deliverContent.expressInfo.logisticsCompany)
                  .replace(/{waybillNo}/g,deliverContent.expressInfo.trackingNumber);
                  webinfoMessageBody = webinfoMessageBody.replace(/{logisticsCompany}/g,deliverContent.expressInfo.logisticsCompany)
                  .replace(/{waybillNo}/g,deliverContent.expressInfo.trackingNumber);
                }
                //资质证号
                if(deliverContent.qualification && deliverContent.qualification.certificateNumber){
                  smsMessageBody = smsMessageBody.replace(/{qcNo}/g,deliverContent.qualification.certificateNumber);
                  webinfoMessageBody = webinfoMessageBody.replace(/{qcNo}/g,deliverContent.qualification.certificateNumber);
                }
                
              }
              var orderSnapshot = orderdetail.order_snapshot;//订单快照
              if(orderSnapshot && orderSnapshot.serviceArea){//服务地址
                smsMessageBody = smsMessageBody.replace(/{area}/g,orderSnapshot.serviceArea);
                webinfoMessageBody = webinfoMessageBody.replace(/{area}/g,orderSnapshot.serviceArea);
              }
            }
          }
          //判断模板是否有值，模板中是否存在未赋值变量
          if(!smsMessageBody || smsMessageBody.indexOf("{")>=0 || !webinfoMessageBody || webinfoMessageBody.indexOf("{")>=0){
            return;
          }
          smsParams.messageBody = smsMessageBody;
          webinfoParams.messageBody = webinfoMessageBody;
          // smsParams.phoneNumber = "13075556693";//测试电话号码
          await this.utilsMsgSendSve.sendMessageVerify({phoneList:[smsParams],subAccountList:[webinfoParams]});//发送短信
        }
        return;
     } 
    } catch (e) {
      console.log(e.stack)
      this.execClient.execLogs("orderDeliverySve.js/sendSmsNotification(发送短信通知)方法出现异常", {orderNum:orderNum,status:status}, "", null, e.stack);
      return;
    }
    
    
  }
  /**
   * 创建资质信息
   * @param {*} orderNum 订单号
   */
  async createQualificationCertificateInfo(orderNum){
    try {
      var qcInfoRes = await this.dao.getQcInfoByOrderNum(orderNum);
      if(qcInfoRes && qcInfoRes.length>0){
        var data = qcInfoRes[0];
        var deliveryContent = data.deliver_content || null;//订单交付信息
        var productType = data.product_type || null;//产品类型
        var userId = data.user_id || null;//用户id
        var qualification = deliveryContent.qualification || null;//资质信息
       if(deliveryContent && qualification && qualification.certificateNumber && productType && userId){
          //营业执照信息
          var businessLicense = deliveryContent.proposerInfo && deliveryContent.proposerInfo.businessLicense?deliveryContent.proposerInfo.businessLicense:{};
          var createObj = {
            user_id: userId,   //用户id
            user_name: data.user_name || "",   //用户名称
            servicer_code: data.servicer_code,   //服务商code			utf8mb4	utf8mb4_german2_ci	0	0	0	0	0	0	0
            servicer_name: data.servicer_name,   //服务商名称			utf8mb4	utf8mb4_german2_ci	0	0	0	0	0	0	0
            certificate_no: qualification.certificateNumber,   //证书编号			utf8mb4	utf8mb4_german2_ci	0	0	0	0	0	0	0
            company_name: businessLicense.name ,   //公司名称			utf8mb4	utf8mb4_german2_ci	0	0	0	0	0	0	0
            business_coverage: qualification.businessScope,   //业务覆盖范围			utf8mb4	utf8mb4_german2_ci	0	0	0	0	0	0	0
            issue_date : qualification.startAt,   //发证日期					0	0	0	0	0	0	0
            expiration_date: qualification.endAt,   //截止期至					0	0	0	0	0	0	0
            business_type: qualification.businessTypes,   //业务种类			utf8mb4	utf8mb4_german2_ci	0	0	0	0	0	0	0
            service_item: qualification.serviceProject,   //服务项目			utf8mb4	utf8mb4_german2_ci	0	0	0	0	0	0	0
            certificate_file: qualification.file && qualification.file.url?qualification.file.url:"" ,   //证书文件			utf8mb4	utf8mb4_german2_ci	0	0	0	0	0	0	0
            license_type: 1
          };
          if(productType=="/qcfw/icp/"){
            createObj.license_type=1;
          }
          if(productType=="/qcfw/edi/"){
            createObj.license_type=2;
          }
          var beforeData = await this.qualificationCertificateDao.model.findOne({
            where:{user_id:data.user_id,certificate_no:qualification.certificateNumber},
            raw:true
          });
          if(beforeData && beforeData.id){//更新数据
            createObj["id"] =  beforeData.id;
            await this.qualificationCertificateDao.update(createObj);
          }else{//新增数据
            await this.qualificationCertificateDao.create(createObj);
          }
        }
      }
    } catch (e) {
      console.log(e);
      this.execClient.execLogs("orderDeliverySve.js/createQualificationCertificateInfo方法出现异常", {params:orderNum}, "", null, e.stack);
       
    }
    
  }

    //创建申请实体
  async createApplyInfo(orderNum) {
    try {
      var orderdelivery=null;
      var orderlist = await this.dao.getOrderInfoByOrderNum(orderNum);
      if(orderlist && orderlist.length>0){
        orderdelivery = orderlist[0];
      }
      if (orderdelivery && orderdelivery.deliver_content && orderdelivery.user_id) {
        var deliver_content = orderdelivery.deliver_content;
        if(orderdelivery.product_type.indexOf("/ic/")>=0){
          if (deliver_content && deliver_content.companyInfo && deliver_content.companyInfo.creditCode) {
            var companyInfo = deliver_content.companyInfo;
            var applyinfo = await this.applyInfoDao.model.findOne({
              where: { credit_code:deliver_content.companyInfo.creditCode, user_id: orderdelivery.user_id },
              raw: true
            });
            if (!applyinfo || !applyinfo.id) {//创建申请实体
              var newObj = {
                servicer_code: orderdelivery.servicer_code,
                servicer_name: orderdelivery.servicer_name,
                user_id: orderdelivery.user_id,
                user_name: orderdelivery.user_name,
                apply_name: companyInfo.companyName,
                credit_code: companyInfo.creditCode,
                apply_type:companyInfo.companyType=="个体工商户" ? 2 : 1,
                operator: companyInfo.shareholderName||"",
                regist_capital: companyInfo.registeredCapital,
                business_term: companyInfo.businessTerm,
                establish_time: companyInfo.establishedTime,
                domicile: companyInfo.residenceAddress,
                ent_type: companyInfo.companyType,
                business_scope: companyInfo.businessScope
              };
              applyinfo = await this.applyInfoDao.create(newObj);
            } else {//更新实体信息
              var updateObj = {
                apply_name: companyInfo.companyName,
                credit_code: companyInfo.creditCode,
                apply_type:companyInfo.companyType=="个体工商户" ? 2 : 1,
                operator:companyInfo.shareholderName||"",
                regist_capital: companyInfo.registeredCapital,
                business_term: companyInfo.businessTerm,
                establish_time: companyInfo.establishedTime,
                domicile: companyInfo.residenceAddress,
                ent_type: companyInfo.companyType,
                business_scope: companyInfo.businessScope
              };
              await this.applyInfoDao.model.update(updateObj, { where: { id: applyinfo.id } });//更新主体信息
            }
          }
        }
        // else if(orderdelivery.product_type.indexOf("/qcfw/")>=0){
        //   if (deliver_content && deliver_content.proposerInfo && deliver_content.proposerInfo.businessLicense && deliver_content.proposerInfo.businessLicense.enterpriseCode) {
        //     var companyInfo = deliver_content.proposerInfo.businessLicense;
        //     var applyinfo = await this.applyInfoDao.model.findOne({
        //       where: { credit_code:companyInfo.enterpriseCode, user_id: orderdelivery.user_id },
        //       raw: true
        //     });
        //     if (!applyinfo || !applyinfo.id) {//创建申请实体
        //       var newObj = {
        //         servicer_code: orderdelivery.servicer_code,
        //         servicer_name: orderdelivery.servicer_name,
        //         user_id: orderdelivery.user_id,
        //         user_name: orderdelivery.user_name,
        //         apply_name: companyInfo.name,
        //         credit_code: companyInfo.enterpriseCode,
        //         apply_type:companyInfo.type=="个体工商户" ? 2 : 1,
        //         operator: companyInfo.legalRepresentative || "",
        //         regist_capital: companyInfo.registeredCapital,
        //         business_term: companyInfo.businessTerm,
        //         establish_time: companyInfo.createdAt,
        //         domicile: companyInfo.address,
        //         ent_type: companyInfo.type,
        //         business_scope: companyInfo.scopeBusiness
        //       };
        //       applyinfo = await this.applyInfoDao.create(newObj);
        //     } else {//更新实体信息
        //       var updateObj = {
        //         servicer_code: orderdelivery.servicer_code || applyinfo.servicer_code,
        //         servicer_name: orderdelivery.servicer_name || applyinfo.servicer_name,
        //         user_id: orderdelivery.user_id || applyinfo.user_id,
        //         user_name: orderdelivery.user_name || applyinfo.user_name,
        //         apply_name: companyInfo.name || applyinfo.apply_name,
        //         credit_code: companyInfo.enterpriseCode || applyinfo.credit_code,
        //         apply_type:companyInfo.type=="个体工商户" ? 2 : 1,
        //         operator: companyInfo.legalRepresentative || applyinfo.operator,
        //         regist_capital: companyInfo.registeredCapital || applyinfo.regist_capital,
        //         business_term: companyInfo.businessTerm || applyinfo.business_term,
        //         establish_time: companyInfo.createdAt || applyinfo.establish_time,
        //         domicile: companyInfo.address || applyinfo.domicile,
        //         ent_type: companyInfo.type || applyinfo.ent_type,
        //         business_scope: companyInfo.scopeBusiness || applyinfo.business_scope
        //       };
        //       await this.applyInfoDao.model.update(updateObj, { where: { id: applyinfo.id } });//更新主体信息
        //     }
        //   }
        // }
        
      }
      return system.getResultSuccess();
    } catch (e) {
      console.log(e,"创建申请实体异常");
      this.execClient.execLogs("orderDeliverySve.js/createApplyInfo方法出现异常", {params:orderNum}, "", null, e.stack);
      return system.getResultSuccess();
            
    }
    
  }
}
module.exports = OrderDeliveryService;

// var d = new Date("2020-05-05");
// var a = new Date();
