const system = require("../../../system");
const { PDICT } = require("../../../../config/platform");
const ServiceBase = require("../../sve.base");
var settings = require("../../../../config/settings");
class OrderInfoService extends ServiceBase {
  constructor() {
    super("order", ServiceBase.getDaoName(OrderInfoService));
    this.orderDeliveryDao = system.getObject("db.order.orderDeliveryDao");
    this.applyInfoDao = system.getObject("db.order.applyInfoDao");
    this.orderStatementDao = system.getObject("db.order.orderStatementDao");
    this.orderProductDao = system.getObject("db.order.orderProductDao");
    this.txPushLogDao = system.getObject("db.common.txPushLogDao");
    this.needInfoDao = system.getObject("db.need.needInfoDao");
    this.orderRefundDao = system.getObject("db.order.orderRefundDao");

  }
  //订单详情（客户查看订单进度）
  async getOrderDetail(pobj) {
    if (!pobj || !pobj.actionBody) {
      return system.getResultFail(-100, "参数错误");
    }
    var ab = pobj.actionBody;
    if (!ab.OrderNum) {
      return system.getResultFail(-101, "订单号不能为空");
    }
    if (!ab.UserId) {
      return system.getResultFail(-102, "用户id不能为空");
    }
    var queryParam = {
      where: { order_num: ab.OrderNum, user_id: ab.UserId },
      attributes: [
        "pay_time",
        "order_num",
        ["tx_orders_num","main_orders_num"],   //腾讯主订单号
        "need_num",   //需求号
        "user_name",   //用户名称
        "quantity",   //订单数量
        "total_sum",   //订单总额
        "discount_amount",  //折扣金额
        "pay_total_sum",  //付订单总额
        "refund_sum",   //退款总额
        "order_status",  //订单状态1: 已付款, 2: 部分已退款, 3: 已退款,4: 已作废
        "notes"   //备注
        , "created_at", "updated_at"
      ],
      raw: true
    };
    var orderinfo = await this.dao.model.findOne(queryParam);
    if (!orderinfo || !orderinfo.order_num) {
      return system.getResultFail(-300, "未知订单信息");
    }
    var relatedProductsList = [];
    if (orderinfo.main_orders_num) {
      relatedProductsList = await this.getRelatedProductsList(orderinfo.main_orders_num, ab.UserId, ab.OrderNum);
    }
    orderinfo["relatedProductsList"] = relatedProductsList;
    var deliveryParams = {
      where: { order_num: ab.OrderNum },
      attributes: ["deliver_content", "created_at", "updated_at", "delivery_status", "delivery_status_name"],
      raw: true
    };
    var orderdelivery = await this.orderDeliveryDao.model.findOne(deliveryParams);
    orderinfo["orderDeliveryInfo"] = orderdelivery;
    var productParams = {
      where: { order_num: ab.OrderNum },
      attributes: ["time_span", "time_unit", "end_time", "product_type", "product_type_name", "order_snapshot"],
      raw: true
    };
    var orderproduct = await this.orderProductDao.model.findOne(productParams);
    orderinfo["orderProductInfo"] = orderproduct;
    return system.getResultSuccess(orderinfo);
  }
  //获取关联产品列表
  async getRelatedProductsList(TxOrdersNum, UserId, OrderNum) {
    var whereObj = {
      tx_orders_num: TxOrdersNum, user_id: UserId
    };
    if (OrderNum) {
      whereObj["order_num"] = { [this.db.Op.ne]: OrderNum };
    }
    // orderdetail.tx_orders_num,orderdetail.order_num
    var relatedProductsList = await this.orderProductDao.model.findAll({
      attributes: ["product_type", "product_type_name"],
      where: whereObj,
      raw: true
    });
    return relatedProductsList;
  }
  //获取订单列表
  async getOrderList(pobj) {
    if (!pobj || !pobj.actionBody) {
      return system.getResultFail(-100, "参数错误");
    }
    var ab = pobj.actionBody;
    if (!ab.UserId) {
      return system.getResultFail(-102, "用户id不能为空");
    }
    if (!ab.ProductType) {
      return system.getResultFail(-103, "产品类型不能为空");
    }
    var result = await this.dao.getOrderList(ab);
    return result;
  }

  //获取资质证照订单列表
  async getQcOrderList(pobj) {
    if (!pobj || !pobj.actionBody) {
      return system.getResultFail(-100, "参数错误");
    }
    var ab = pobj.actionBody;
    if (!ab.UserId) {
      return system.getResultFail(-102, "用户id不能为空");
    }
    var result = await this.dao.getQcOrderList(ab);
    return result;
  }

  //发货回调
  async orderPayNotify(pobj) {
    if (!pobj.actionBody.interface || !pobj.actionBody.interface.para) {
      return system.getResultFail(-101, "参数错误");
    }
    if (!pobj.actionBody.logId) {
      return system.getResultFail(-101, "参数错误");
    }
    if (!pobj.actionBody.interface.para.dealName || !pobj.actionBody.interface.para.bigDealId) {

      return system.getResultFail(-101, "参数异常");
    }
    var selobj = {
      "version": 1,
      "componentName": "qcbuy",
      "eventId": 143371,
      "timestamp": Date.now(),
      "user": "auto",
      "interface": {
        "interfaceName": "qcloud.Deal.getDealsByNameOrBigId",
        "para": {
          "cond": {
            "name": pobj.actionBody.interface.para.dealName,
            "ownerUin": pobj.actionBody.interface.para.uin,
          }
        }
      },
      "seqId": "647ea242-f654-965d-a62a-eabe0289d954",
      "spanId": "https://buy.qcloud.com;61911"
    }
    var txorderinfo = await this.execPostByTimeOut(selobj, "http://trade.sandbox.com/interfaces/interface.php");

    if (txorderinfo.status < 0) {
      return system.getResultFail(-101, "post is error");
    }

    txorder = txorderinfo.data;
    console.log(txorder);
    if (txorder.status < 0) {
      return system.getResultFail(-101, "post is error");
    }
    if (txorder.data.returnValue < 0) {
      return system.getResultFail(-101, "txorder is error");
    }
    var txorderdetail = txorder.data.deals[0];
    console.log(txorderdetail.goodsDetail, "....txorderdetail.goodsDetail.....1");
    var self = this;
    var isoldsolutionorder = false;
    var ispush = true;
    var corder = await this.db.transaction(async function (t) {
      var oldorder = await self.findOne({ order_num: pobj.actionBody.interface.para.dealName, tx_orders_num: pobj.actionBody.interface.para.bigDealId }, t)
      if (oldorder) {
        ispush = false;
        return system.getResultSuccess();
      }
      if (txorderdetail.goodsDetail.formInfo.solutionNum) {
        var snobj = {
          solutionNum: txorderdetail.goodsDetail.formInfo.solutionNum
        }
        var sql = "SELECT * FROM `b_order_product` where tx_order_snapshot->'$.goodsDetail.formInfo.solutionNum'=:solutionNum;"
        var orderproductinfo = await self.customQuery(sql, snobj, t);
        if (orderproductinfo && orderproductinfo.length > 0) {
          if (orderproductinfo[0].tx_orders_num != pobj.actionBody.interface.para.bigDealId) {
            ispush = false;
            isoldsolutionorder = true;
          }
        } else {
          await self.needInfoDao.updateByWhere({ status: 4 }, { where: { need_num: txorderdetail.goodsDetail.formInfo.needNum } }, t)
        }
      }

      //创建订单
      console.log(txorderdetail.goodsDetail, "....txorderdetail.goodsDetail...2");
      var orderobj = {
        tx_orders_num: pobj.actionBody.interface.para.bigDealId,
        order_num: pobj.actionBody.interface.para.dealName,
        need_num: txorderdetail.goodsDetail.formInfo.needNum || "",
        user_id: pobj.actionBody.interface.para.uin,
        user_name: "",
        quantity: txorderdetail.goodsNum || 1,
        total_sum: txorderdetail.goodsPrice.totalCost || 0,
        discount_amount: Number(txorderdetail.goodsPrice.totalCost) - Number(txorderdetail.goodsPrice.realTotalCost),
        pay_total_sum: txorderdetail.goodsPrice.realTotalCost || 0,
        order_status: 1,
        order_status_name: "已付款",
        user_name: txorderdetail.goodsDetail.formInfo.userName,
        pay_time: new Date(txorderdetail.payEndTime)
      }
      if (isoldsolutionorder) {
        orderobj.order_status = 320;
        orderobj.order_status_name = "已退款";
      }
      var orderinfo = await self.create(orderobj, t);
      if (isoldsolutionorder) {
        return system.getResultSuccess();
      }
      //创建订单产品
      var orderProductobj = {
        tx_orders_num: pobj.actionBody.interface.para.bigDealId,
        order_num: pobj.actionBody.interface.para.dealName,
        user_id: pobj.actionBody.interface.para.uin,
        region_id: txorderdetail.goodsDetail.formInfo.serviceCode || 0,
        region_name: txorderdetail.goodsDetail.formInfo.serviceArea || "",
        product_icon: txorderdetail.goodsDetail.product.productIcon || 0,
        product_type: txorderdetail.goodsDetail.product.productType || 0,
        product_type_name: txorderdetail.goodsDetail.product.productTypeName || "",
        order_snapshot: txorderdetail.goodsDetail.formInfo || {},
        servicer_code: txorderdetail.goodsDetail.product.servicerCode || "",
        servicer_name: txorderdetail.goodsDetail.product.servicerName || "",
        tx_order_snapshot: txorderdetail,
        created_at: new Date(txorderdetail.payEndTime),
        user_name: txorderdetail.goodsDetail.formInfo.userName,
        start_time: new Date(txorderdetail.payEndTime)
      }
      var orderProductinfo = await self.orderProductDao.entTimeCreate(orderProductobj, t);
      //创建订单交付单
      var orderDeliveryobj = {
        tx_orders_num: pobj.actionBody.interface.para.bigDealId,
        order_num: pobj.actionBody.interface.para.dealName,
        user_id: pobj.actionBody.interface.para.uin,
        delivery_status: 1,
        user_name: txorderdetail.goodsDetail.formInfo.userName,
        email: txorderdetail.goodsDetail.formInfo.email || "",
        wechat_no: txorderdetail.goodsDetail.formInfo.wechatNo || ""
      }
      var orderDeliveryinfo = await self.orderDeliveryDao.create(orderDeliveryobj, t);
      var orderPayobj = {
        tx_orders_num: pobj.actionBody.interface.para.bigDealId,
        order_num: pobj.actionBody.interface.para.dealName,
        user_id: pobj.actionBody.interface.para.uin,
        op_type: 1,
        op_type_name: "收",
        pay_total_sum: txorderdetail.goodsPrice.realTotalCost,
        created_at: new Date(txorderdetail.payEndTime),
        user_name: txorderdetail.goodsDetail.formInfo.userName
      }
      await self.orderStatementDao.create(orderPayobj, t);
      var txPushLoginfo = await self.txPushLogDao.findOne({ deal_name: pobj.actionBody.interface.para.dealName });
      if (!txPushLoginfo) {
        return system.getResultFail(-101, "txPushLoginfo is error");
      }
      txPushLoginfo.dataValues.push_status = 0;
      await self.txPushLogDao.update(txPushLoginfo.dataValues, t);
      return system.getResultSuccess();
    });
    if (corder.status > 0) {
      await self.txPushLogDao.update({ id: pobj.actionBody.logId, push_status: 0 });
    }
    if (!ispush) {
      return system.getResultSuccess();
    }
    //生产者------订单推送
    var pushobj = {
      "actionType": "produceData",// Y 功能名称
      "actionBody": {
        notifyUrl: "",
        actionType: "orderSubmit",
        pushUrl: txorderdetail.goodsDetail.product.pushDomainAddr + "/entService/order/springBoard",
        messageBody: {
          "txOrderNum": pobj.actionBody.interface.para.bigDealId,
          "orderNum": pobj.actionBody.interface.para.dealName,
          "userId": pobj.actionBody.interface.para.uin,
          "servicerCode": txorderdetail.goodsDetail.product.servicerCode,
          "servicerName": txorderdetail.goodsDetail.product.servicerName,
          "regionId": txorderdetail.goodsDetail.formInfo.serviceCode,
          "regionName": txorderdetail.goodsDetail.formInfo.serviceArea,
          "contactsName": txorderdetail.goodsDetail.formInfo.contactsName,
          "contactsMobile": txorderdetail.goodsDetail.formInfo.contactsMobile,
          "productType": txorderdetail.goodsDetail.product.productType,
          "productTypeName": txorderdetail.goodsDetail.product.productTypeName,
          "txPriceCode": txorderdetail.goodsDetail.product.txPriceCode,
          "realTotalCost": txorderdetail.goodsPrice.realTotalCost,
          "orderSnapshot": txorderdetail.goodsDetail.formInfo
        },
        identifyCode: "orderSubmit"
      }
    };
    var r = await this.execPostByTimeOut(pushobj, settings.opPushUrl());
    if (r.status < 1) {
      return system.getResultFail(-102, "Post error");
    }
    return corder;
  }

  async orderPayNotifydev(pobj) {
    if (!pobj.actionBody.interface || !pobj.actionBody.interface.para) {
      return system.getResultFail(-101, "参数错误");
    }
    if (!pobj.actionBody.logId) {
      return system.getResultFail(-101, "参数错误");
    }
    if (!pobj.actionBody.interface.para.dealName || !pobj.actionBody.interface.para.bigDealId) {

      return system.getResultFail(-101, "参数异常");
    }
    var selobj = {
      "version": 1,
      "componentName": "qcbuy",
      "eventId": 143371,
      "timestamp": Date.now(),
      "user": "auto",
      "interface": {
        "interfaceName": "qcloud.Deal.getDealsByNameOrBigId",
        "para": {
          "cond": {
            "name": pobj.actionBody.interface.para.dealName,
            "ownerUin": pobj.actionBody.interface.para.uin,
          }
        }
      },
      "seqId": "647ea242-f654-965d-a62a-eabe0289d954",
      "spanId": "https://buy.qcloud.com;61911"
    }
    // var txorderinfo = await this.execPostByTimeOut(selobj, "http://trade.sandbox.com/interfaces/interface.php");

    // if (txorderinfo.status < 0) {
    //   return system.getResultFail(-101, "post is error");
    // }

    // txorder = txorderinfo.data;
    // console.log(txorder)
    var txorder = {
      "version": 1,
      "componentName": "trade",
      "timestamp": 1506343680,
      "eventId": 642681313,
      "returnValue": 0,
      "returnCode": 0,
      "returnMessage": "ok",
      "data": {
        "totalNum": "1",
        "deals": [
          {
            "dealId": "6138696",
            "dealName": "20190919188291",
            "bigDealId": "20190919188291",
            "goodsCategoryId": "101630",
            "goodsDetail": pobj.actionBody.interface.para.goodsDetail,
            "ownerUin": "100000013569",
            "platform": "1",
            "regionId": "1",
            "appId": "1254105646",
            "goodsNum": "1",
            "goodsPrice": {
              "activitySpecifiedPrice": 1,
              "price": 13800,
              "totalCost": 13800,
              "policy": 7,
              "realTotalCost": 1000,
              "policyDetail": {
                "total": 7,
                "user": 100,
                "common": 7
              },
              "timeSpan": 1,
              "timeUnit": "y",
              "goodsNum": 1,
              "unitPrice": 13800,
              "formula": "新配置价格10.8 - 老配置单价5.4"
            },
            "creater": "100001050256",
            "creatTime": "2017-08-29 20:59:14",
            "overdueTime": "2017-09-13 20:59:14",
            "payer": "100001050256",
            "billId": "20170829030000071201512598909616",
            "endTime": "2017-08-29 21:01:29",
            "cartRecId": "0",
            "payStartTime": "2017-08-29 20:59:15",
            "payEndTime": "2017-08-29 20:59:15",
            "taskStartTime": "2017-08-29 21:01:04",
            "taskEndTime": "2017-08-29 21:01:29",
            "taskDetail": {
              "flowId": 345420,
              "resourceIds": [
                374594
              ]
            },
            "status": "4",
            "reserved": "0",
            "retry": "0",
            "reportFlag": "0",
            "payMode": "1",
            "voucherDecline": null,
            "voucherId": null,
            "projectId": "0",
            "payerMode": "0",
            "agentPayer": null,
            "dealType": "0",
            "activityId": "1986",
            "phone": "",
            "ticket": "",
            "goodsExpiredTime": null,
            "updateTime": "2017-08-29 21:01:29",
            "zoneId": "0",
            "providerOwnerUin": ""
          }
        ]
      }
    }
    if (txorder.status < 0) {
      return system.getResultFail(-101, "post is error");
    }
    if (txorder.data.returnValue < 0) {
      return system.getResultFail(-101, "txorder is error");
    }
    var txorderdetail = txorder.data.deals[0];
    console.log(txorderdetail.goodsDetail, "....txorderdetail.goodsDetail.....1");
    var self = this;
    var isoldsolutionorder = false;
    var ispush = true;
    var corder = await this.db.transaction(async function (t) {
      var oldorder = await self.findOne({ order_num: pobj.actionBody.interface.para.dealName, tx_orders_num: pobj.actionBody.interface.para.bigDealId }, t)
      if (oldorder) {
        ispush = false;
        return system.getResultSuccess();
      }
      if (txorderdetail.goodsDetail.formInfo.solutionNum) {
        var snobj = {
          solutionNum: txorderdetail.goodsDetail.formInfo.solutionNum
        }
        var sql = "SELECT * FROM `b_order_product` where tx_order_snapshot->'$.goodsDetail.formInfo.solutionNum'=:solutionNum;"
        var orderproductinfo = await self.customQuery(sql, snobj, t);
        if (orderproductinfo && orderproductinfo.length > 0) {
          if (orderproductinfo[0].tx_orders_num != pobj.actionBody.interface.para.bigDealId) {
            ispush = false;
            isoldsolutionorder = true;
          }
        } else {
          await self.needInfoDao.updateByWhere({ status: 4 }, { where: { need_num: txorderdetail.goodsDetail.formInfo.needNum } }, t)
        }
      }

      //创建订单
      console.log(txorderdetail.goodsDetail, "....txorderdetail.goodsDetail...2");
      var orderobj = {
        tx_orders_num: pobj.actionBody.interface.para.bigDealId,
        order_num: pobj.actionBody.interface.para.dealName,
        need_num: txorderdetail.goodsDetail.formInfo.needNum || "",
        user_id: pobj.actionBody.interface.para.uin,
        user_name: "",
        quantity: txorderdetail.goodsNum || 1,
        total_sum: txorderdetail.goodsPrice.totalCost || 0,
        discount_amount: Number(txorderdetail.goodsPrice.totalCost) - Number(txorderdetail.goodsPrice.realTotalCost),
        pay_total_sum: txorderdetail.goodsPrice.realTotalCost || 0,
        order_status: 1,
        order_status_name: "已付款",
        user_name: txorderdetail.goodsDetail.formInfo.userName,
        pay_time: new Date(txorderdetail.payEndTime)
      }
      if (isoldsolutionorder) {
        orderobj.order_status = 320;
        orderobj.order_status_name = "已退款";
      }
      var orderinfo = await self.create(orderobj, t);
      if (isoldsolutionorder) {
        return system.getResultSuccess();
      }
      //创建订单产品
      var orderProductobj = {
        tx_orders_num: pobj.actionBody.interface.para.bigDealId,
        order_num: pobj.actionBody.interface.para.dealName,
        user_id: pobj.actionBody.interface.para.uin,
        region_id: txorderdetail.goodsDetail.formInfo.serviceCode || 0,
        region_name: txorderdetail.goodsDetail.formInfo.serviceArea || "",
        product_icon: txorderdetail.goodsDetail.product.productIcon || 0,
        product_type: txorderdetail.goodsDetail.product.productType || 0,
        product_type_name: txorderdetail.goodsDetail.product.productTypeName || "",
        order_snapshot: txorderdetail.goodsDetail.formInfo || {},
        servicer_code: txorderdetail.goodsDetail.product.servicerCode || "",
        servicer_name: txorderdetail.goodsDetail.product.servicerName || "",
        tx_order_snapshot: txorderdetail,
        created_at: new Date(txorderdetail.payEndTime),
        user_name: txorderdetail.goodsDetail.formInfo.userName,
        start_time: new Date(txorderdetail.payEndTime)
      }
      var orderProductinfo = await self.orderProductDao.entTimeCreate(orderProductobj, t);
      //创建订单交付单
      var orderDeliveryobj = {
        tx_orders_num: pobj.actionBody.interface.para.bigDealId,
        order_num: pobj.actionBody.interface.para.dealName,
        user_id: pobj.actionBody.interface.para.uin,
        delivery_status: 1,
        user_name: txorderdetail.goodsDetail.formInfo.userName,
        email: txorderdetail.goodsDetail.formInfo.email || "",
        wechat_no: txorderdetail.goodsDetail.formInfo.wechatNo || ""
      }
      var orderDeliveryinfo = await self.orderDeliveryDao.create(orderDeliveryobj, t);
      var orderPayobj = {
        tx_orders_num: pobj.actionBody.interface.para.bigDealId,
        order_num: pobj.actionBody.interface.para.dealName,
        user_id: pobj.actionBody.interface.para.uin,
        op_type: 1,
        op_type_name: "收",
        pay_total_sum: txorderdetail.goodsPrice.realTotalCost,
        created_at: new Date(txorderdetail.payEndTime),
        user_name: txorderdetail.goodsDetail.formInfo.userName
      }
      await self.orderStatementDao.create(orderPayobj, t);
      var txPushLoginfo = await self.txPushLogDao.findOne({ deal_name: pobj.actionBody.interface.para.dealName });
      if (!txPushLoginfo) {
        return system.getResultFail(-101, "txPushLoginfo is error");
      }
      txPushLoginfo.dataValues.push_status = 0;
      await self.txPushLogDao.update(txPushLoginfo.dataValues, t);
      return system.getResultSuccess();
    });
    if (corder.status > 0) {
      await self.txPushLogDao.update({ id: pobj.actionBody.logId, push_status: 0 });
    }
    if (!ispush) {
      return system.getResultSuccess();
    }
    //生产者------订单推送
    var pushobj = {
      "actionType": "produceData",// Y 功能名称
      "actionBody": {
        notifyUrl: "",
        actionType: "orderSubmit",
        pushUrl: txorderdetail.goodsDetail.product.pushDomainAddr + "/entService/order/springBoard",
        messageBody: {
          "txOrderNum": pobj.actionBody.interface.para.bigDealId,
          "orderNum": pobj.actionBody.interface.para.dealName,
          "userId": pobj.actionBody.interface.para.uin,
          "servicerCode": txorderdetail.goodsDetail.product.servicerCode,
          "servicerName": txorderdetail.goodsDetail.product.servicerName,
          "regionId": txorderdetail.goodsDetail.formInfo.serviceCode,
          "regionName": txorderdetail.goodsDetail.formInfo.serviceArea,
          "contactsName": txorderdetail.goodsDetail.formInfo.contactsName,
          "contactsMobile": txorderdetail.goodsDetail.formInfo.contactsMobile,
          "productType": txorderdetail.goodsDetail.product.productType,
          "productTypeName": txorderdetail.goodsDetail.product.productTypeName,
          "txPriceCode": txorderdetail.goodsDetail.product.txPriceCode,
          "realTotalCost": txorderdetail.goodsPrice.realTotalCost,
          "orderSnapshot": txorderdetail.goodsDetail.formInfo
        },
        identifyCode: "orderSubmit"
      }
    };
    var r = await this.execPostByTimeOut(pushobj, settings.opPushUrl());
    if (r.status < 1) {
      return system.getResultFail(-102, "Post error");
    }
    return corder;
  }

  //询价----调取腾讯接口
  async selPrice2TX(pobj) {
    var pid = 1003949;
    var goodsCategoryId = "101630";
    var goodsSubType = "";
    var billingcode = "";

    if (!pobj.actionBody.RegionId) {
      return system.getResultFail(-101, "regionId is empty");
    }
    if (!pobj.actionBody.PathCode) {
      return system.getResultFail(-101, "PathCode is empty");
    }
    if (!pobj.actionBody.RegionName) {
      return system.getResultFail(-101, "regionName is empty");
    }
    var priceName = null;
    //公司注册
    if (pobj.actionBody.PathCode == "/ic/gsreg/") {
      if (!pobj.actionBody.CompanyProperties) {
        return system.getResultFail(-101, "CompanyProperties is empty");
      }
      priceName = pobj.actionBody.CompanyProperties;
    }
    //云上园区注册 
    if (pobj.actionBody.PathCode == "/ic/cpreg/") {
      if (!pobj.actionBody.RegisteredType) {
        return system.getResultFail(-101, "RegisteredType is empty");
      }
      priceName = pobj.actionBody.RegisteredType;
    }
    //刻章服务
    if (pobj.actionBody.PathCode == "/ic/kzfw/") {
      if (!pobj.actionBody.WhetherType) {
        return system.getResultFail(-101, "WhetherType is empty");
      }
      priceName = pobj.actionBody.WhetherType;
    }
    //
    var productstr = "p_business_registration";
    if (pobj.actionBody.PathCode.indexOf("/qcfw/") > -1) {
      productstr = "p_vat";
      if (pobj.actionBody.Period) {
        priceName = pobj.actionBody.Period;
      }

    }

    // if (pobj.actionBody.PathCode == "/ic/dljz/") {
    //   if (!pobj.actionBody.subjectType) {
    //     return system.getResultFail(-101, "subjectType is empty");
    //   }
    //   if (!pobj.actionBody.taxpayerType) {
    //     return system.getResultFail(-101, "taxpayerType is empty");
    //   }
    //   if()
    //   priceName = pobj.actionBody.subjectType + pobj.actionBody.taxpayerType;
    // }
    var p = '%' + priceName + '%';
    var sqlobj = {
      pathCode: pobj.actionBody.PathCode,
      priceName: p
    }

    var sql = "select product_code goodsSubType,pid,price_code billingcode from tx_product_price where product_name=:pathCode";
    if (priceName) {
      sql += " and price_name like :priceName;";
    }
    var txprice = await this.customQuery(sql, sqlobj);
    console.log(txprice,".....txprice...........");
    if (txprice && txprice.length > 0) {
      goodsSubType = txprice[0].goodsSubType;
      pid = txprice[0].pid;
      billingcode = txprice[0].billingcode;
    } else {
      return system.getResultFail(-203, "txprice is empty");
    }
    var productobj = {
      region_id: pobj.actionBody.RegionId,
      path_code: pobj.actionBody.PathCode
    }
    var txproductinfo = await this.dao.selPrice2TX(productobj);
    if (txproductinfo.status < 0) {
      return system.getResultFail(-203, "txproduct is empty");
    }
    var txobj = {
      "version": "1.0",
      "componentName": "Market",
      "eventId": 4962132,
      "timestamp": Date.now(),
      "seqId": "1212344513",
      "interface": {
        "interfaceName": "qcloud.price.getPrice",
        "para": {
          "uin": pobj.actionBody.UserId,
          "ownerUin": pobj.actionBody.UserId,
          "resInfo": [
            {
              "goodsCategoryId": goodsCategoryId,
              "currency": "CNY",
              "regionId": "1",
              "zoneId": "100001",
              "type": goodsSubType,
              "action": "purchase",
              "activityId": "0",
              "goodsNum": "1",
              "payMode": "1",
              "goodsDetail": {
                "timeSpan": "1",
                "timeUnit": "p",
                "pid": pid,
                "productCode": productstr,
                "goodsSubType": goodsSubType,
                "subProductCode": goodsSubType,
                "qifuzidingyi": pobj.actionBody.RegionName
              }
            }
          ]
        }
      }
    }
    if (pobj.actionBody.UserId) {
      txobj.interface.para.uin = pobj.actionBody.UserId;
      txobj.interface.para.ownerUin = pobj.actionBody.UserId;
    }
    if (billingcode) {
      txobj.interface.para.resInfo[0].goodsDetail[billingcode] = "1";
    }
    if (pobj.actionBody.RegionName) {
      txobj.interface.para.resInfo[0].goodsDetail.qifuzidingyi = pobj.actionBody.RegionName;
    }
    if (pobj.actionBody.TimeSpan) {
      txobj.interface.para.resInfo[0].goodsDetail.timeSpan = pobj.actionBody.TimeSpan;
      txobj.interface.para.resInfo[0].goodsDetail.timeUnit = pobj.actionBody.TimeUnit;
    }
    var rtn = await this.execPostByTimeOut(txobj, "http://trade.sandbox.com/interfaces/interface.php");
    if (rtn.status < 0) {
      return system.getResultFail(-101, "post is error");
    }
    if (rtn.data.returnValue < 0) {
      return system.getResultFail(-101, "txinterface is error");
    }
    var data = {
      totalCost: rtn.data.data[0].totalCost,
      realTotalCost: rtn.data.data[0].realTotalCost,
      product: {
        productIcon: txproductinfo.data.product_icon,
        productType: pobj.actionBody.PathCode,
        productTypeName: txproductinfo.data.product_type_name,
        servicerCode: txproductinfo.data.servicer_code,
        servicerName: txproductinfo.data.servicer_name,
        pushDomainAddr: txproductinfo.data.push_domain_addr,
        txPriceCode: billingcode
      },
      productSnapshot: txobj.interface.para.resInfo[0].goodsDetail
    }
    return system.getResultSuccess(data);
  }

  async submitGoodsinfo(pobj) {
    // if (!pobj.actionBody.Info) {
    //   return system.getResultFail(-101, "Info is empty");
    // }
    // pobj.actionBody.Info = JSON.parse(pobj.actionBody.Info);
    if (pobj.actionBody.Info.length < 1) {
      return system.getResultFail(-101, "info is empty");
    }
    if (!pobj.actionBody.Info[0].productSnapshot) {
      return system.getResultFail(-101, "productSnapshot is empty");
    }
    if (!pobj.actionBody.Info[0].product) {
      return system.getResultFail(-101, "product is empty");
    }
    if (!pobj.actionBody.Info[0].showInfo) {
      return system.getResultFail(-101, "showInfo is empty");
    }
    var goodsCategoryId = 101630;
    // if (pobj.actionBody.Info[0].product.productType.indexOf("/ic/") < 0) {
    //   goodsCategoryId = 100114;
    // }
    var so = {
      itemDetails: {
        raw_goodsData: [  //raw_goodsData为数组，支持同时购买多个商品
        ]
      }
    }
    var goodsinfo = {
      goodsCategoryId: goodsCategoryId, //商品ID
      regionId: 1, //地域ID
      projectId: 0, //项目ID
      zoneId: 100001, //可用区ID
      goodsNum: 1, //购买数量
      payMode: 1, //计费模式，1表示包年包月（预付费）
      // goodsDetail内容详见下方文档链接
      goodsDetail: {
        timeUnit: "p",
        timeSpan: 1,
        pid: "11546",//购买商品的pid
        productInfo: []   //产品详情，用于展示商品配置详情

      }
    };
    goodsinfo.goodsDetail = pobj.actionBody.Info[0].productSnapshot;
    goodsinfo.goodsDetail.product = pobj.actionBody.Info[0].product;
    goodsinfo.goodsDetail.productInfo = pobj.actionBody.Info[0].showInfo;
    goodsinfo.goodsDetail.formInfo = pobj.actionBody.Info[0].formInfo;
    so.itemDetails.raw_goodsData.push(goodsinfo);
    if (pobj.actionBody.Info.length >= 2) {
      var newgoodsinfo = JSON.parse(JSON.stringify(goodsinfo));
      newgoodsinfo.goodsDetail = pobj.actionBody.Info[1].productSnapshot;
      newgoodsinfo.goodsDetail.product = pobj.actionBody.Info[1].product;
      newgoodsinfo.goodsDetail.productInfo = pobj.actionBody.Info[1].showInfo;
      newgoodsinfo.goodsDetail.formInfo = pobj.actionBody.Info[1].formInfo;
      so.itemDetails.raw_goodsData.push(newgoodsinfo);
    }
    if (pobj.actionBody.Info.length == 3) {
      var newgoodsinfo1 = JSON.parse(JSON.stringify(goodsinfo));
      newgoodsinfo1.goodsDetail = pobj.actionBody.Info[2].productSnapshot;
      newgoodsinfo1.goodsDetail.product = pobj.actionBody.Info[2].product;
      newgoodsinfo1.goodsDetail.productInfo = pobj.actionBody.Info[2].showInfo;
      newgoodsinfo1.goodsDetail.formInfo = pobj.actionBody.Info[2].formInfo;
      so.itemDetails.raw_goodsData.push(newgoodsinfo1);
    }
    var robj = {
      "url": "https://buy.cloud.tencent.com/order/check",
      "param": so
    }
    // await this.test(so);
    return system.getResultSuccess(robj);
  }

  async test(pobj) {
    var p = {
      "eventId": 697271589,
      "componentName": "BillingRoute",
      "seqId": "unknown",
      "spanId": "http://trade.tencentyun.com;1",
      "interface": {
        "interfaceName": "qcloud.cbs.CreateCbsInstance",
        "para": {
          "appId": 123,
          "tranId": "20190919188290",
          "dealName": Date.now(),
          "bigDealId": Date.now(),
          "uin": "100000013569",
          "type": "cbs",
          "region": 6,
          "operateUin": "100000013569",
          "payMode": 1,
          "projectId": 1019190,
          "zoneId": 400001,
          "goodsDetail": pobj.itemDetails.raw_goodsData[0].goodsDetail
        }
      }
    }
    var a = await this.execPostByTimeOut(p, "http://192.168.1.113:4011/api/action/txapi/springBoard");
    if (pobj.itemDetails.raw_goodsData.length == 2) {
      p.interface.para.dealName = Date.now();
      p.interface.para.goodsDetail = pobj.itemDetails.raw_goodsData[1].goodsDetail;
      var b = await this.execPostByTimeOut(p, "http://192.168.1.113:4011/api/action/txapi/springBoard");
    }
    if (pobj.itemDetails.raw_goodsData.length == 3) {
      p.interface.para.dealName = Date.now();
      p.interface.para.goodsDetail = pobj.itemDetails.raw_goodsData[2].goodsDetail;
      await this.execPostByTimeOut(p, "http://192.168.1.113:4011/api/action/txapi/springBoard");
    }
    return system.getResultSuccess();
  }

  //退款
  async refundOrder(pobj) {
    if (!pobj.orderNum) {
      return system.getResultFail(-101, "orderNum is empty");
    }
    var orderinfo = await this.findOne({ order_num: pobj.orderNum });
    if (!orderinfo) {
      return system.getResultFail(-101, "orderinfo is empty");
    }
    var orderProduct = await this.orderProductDao.findOne({ order_num: pobj.orderNum });
    if (!orderProduct) {
      return system.getResultFail(-101, "orderProduct is empty");
    }
    var productType = "p_business_registration";
    if (orderProduct.dataValues.product_type.indexOf("/qcfw/") > -1) {
      productType = "p_vat";
    }
    ;
    var o = {
      "version": "1.0",
      "caller": "trade",
      "componentName": "trade",
      "eventId": "5b2b14b118121",
      "timestamp": Date.now(),
      "interface": {
        "interfaceName": "save",
        "para": {
          "msgType": "dealDeliveryCallback",
          "msgContent": {
            "type": productType,
            "dealName": pobj.orderNum,
            "deliveryResult": 3
          }
        }
      }
    }
    // var r = await this.execPostByTimeOut(o, "http://msgqueue.sandbox.com");
    // if (r.status < 1) {
    //   return system.getResultFail(-102, "Post error");
    // }
    var self = this;
    return this.db.transaction(async function (t) {
      await self.update({ id: orderinfo.id, order_status: 320 }, t)
      var orderPayobj = {
        tx_orders_num: orderinfo.tx_orders_num,
        order_num: orderinfo.order_num,
        user_id: orderinfo.user_id,
        op_type: 2,
        op_type_name: "支",
        pay_total_sum: orderinfo.pay_total_sum,
        user_name: orderinfo.user_name
      }
      await self.orderStatementDao.create(orderPayobj, t);
      var orderRefundobj = {
        tx_orders_num: orderinfo.tx_orders_num,
        order_num: orderinfo.order_num,
        user_id: orderinfo.user_id,
        pay_total_sum: orderinfo.pay_total_sum,
        user_name: orderinfo.user_name
      }
      await self.orderRefundDao.create(orderRefundobj, t);
      return system.getResultSuccess();
    })

  }

  //计费时间修改
  async jftime(pobj) {
    if (!pobj.orderNum) {
      return system.getResultFail(-101, "orderNum is empty");
    }
    if (!pobj.startTime) {
      return system.getResultFail(-101, "startTime is empty");
    }
    if (!pobj.entTime) {
      return system.getResultFail(-101, "entTime is empty");
    }
    try {
      var orderproduct = await this.orderProductDao.findOne({ order_num: pobj.orderNum });
      if (!orderproduct) {
        return system.getResultFail(-101, "orderproduct is empty");
      }
      orderproduct.dataValues.start_time = new Date(pobj.startTime)
      orderproduct.dataValues.ent_time = new Date(pobj.entTime)
      await this.orderProductDao.update(orderproduct.dataValues);
      return system.getResultSuccess();
    } catch (error) {
      return system.getResultFail(510, error);
    }

  }

  //隔离
  async isolateResource(pobj) {


  }

  // async gsOrderSubmit(pobj) {
  //   if (!pobj.actionBody.Info) {
  //     return system.getResultFail(-101, "Info is empty");
  //   }
  //   pobj.actionBody.Info=JSON.parse(pobj.actionBody.Info);
  //   if (pobj.actionBody.Info.length < 1) {
  //     return system.getResultFail(-101, "info is empty");
  //   }
  //   if (!pobj.actionBody.Info[0].productSnapshot) {
  //     return system.getResultFail(-101, "productSnapshot is empty");
  //   }
  //   if (!pobj.actionBody.Info[0].product) {
  //     return system.getResultFail(-101, "product is empty");
  //   }
  //   if (!pobj.actionBody.Info[0].showInfo) {
  //     return system.getResultFail(-101, "showInfo is empty");
  //   }

  //   var txorderobj = {
  //     "version": 1,
  //     "componentName": "qcbuy",
  //     "eventId": "n152351534",
  //     "timestamp": 1496196202296,
  //     "user": "auto",
  //     "interface": {
  //       "interfaceName": "qcloud.Deal.generateDeals",
  //       "para": {
  //         "uin": pobj.actionBody.form.UserId,
  //         "ownerUin": pobj.actionBody.form.UserId,
  //         "appId": 251007582,
  //         "goods": [
  //           {
  //             "goodsCategoryId": 101630,
  //             "goodsNum": 1,
  //             "payMode": 1,
  //             "regionId": 1,
  //             "projectId": 0,
  //             "goodsDetail": {
  //               "productCode": "p_business_registration",
  //               "subProductCode": "sp_business_registration_company_registration",
  //               "productInfo": [
  //                 {
  //                   "name": "公司名称",
  //                   "value": pobj.actionBody.form.companyName
  //                 },
  //                 {
  //                   "name": "注册地址",
  //                   "value": pobj.actionBody.form.fullAddress != "--" ? pobj.actionBody.form.fullAddress : "腾讯云地址",
  //                 },
  //                 {
  //                   "name": "纳税人类型",
  //                   "value": pobj.actionBody.form.taxpayerType
  //                 },
  //                 {
  //                   "name": "公司性质",
  //                   "value": pobj.actionBody.form.companyProperties
  //                 },
  //                 {
  //                   "name": "从事行业",
  //                   "value": pobj.actionBody.form.engagedIndustry
  //                 }
  //               ],
  //               "service": "DR_COM_NEW",
  //               "autoRenewFlag": 0,
  //               "pid": "1000760",
  //               "timeSpan": "1",
  //               "timeUnit": "n",
  //               "sv_pstn_count": "1",
  //               "sv_pstn_num_ctd": "2",
  //               "extparam": {
  //                 "tranId": "xxxxxxxxxxxxxxx"
  //               }
  //             }
  //           }
  //         ],
  //         "cpsUin": "1369988980"
  //       }
  //     },
  //     "seqId": "702d4148-9ac0-cb47-21fa-cdee20234ea0"
  //   }
  //   var goodsinfo = {
  //     goodsCategoryId: goodsCategoryId, //商品ID
  //     regionId: 1, //地域ID
  //     projectId: 0, //项目ID
  //     zoneId: 100001, //可用区ID
  //     goodsNum: 1, //购买数量
  //     payMode: 1, //计费模式，1表示包年包月（预付费）
  //     // goodsDetail内容详见下方文档链接
  //     goodsDetail: {
  //       timeUnit: "p",
  //       timeSpan: 1,
  //       pid: "11546",//购买商品的pid
  //       productInfo: []   //产品详情，用于展示商品配置详情

  //     }
  //   };
  //   goodsinfo.goodsDetail = pobj.actionBody.Info[0].productSnapshot;
  //   goodsinfo.goodsDetail.product = pobj.actionBody.Info[0].product;
  //   goodsinfo.goodsDetail.productInfo = pobj.actionBody.Info[0].showInfo;
  //   goodsinfo.goodsDetail.formInfo = pobj.actionBody.Info[0].formInfo;
  //   txorderobj.interface.para.goods.push(goodsinfo);
  //   if (pobj.actionBody.Info.length >= 2) {
  //     var newgoodsinfo = JSON.parse(JSON.stringify(goodsinfo));
  //     newgoodsinfo.goodsDetail.product = pobj.actionBody.Info[1].product;
  //     newgoodsinfo.goodsDetail = pobj.actionBody.Info[1].productSnapshot;
  //     newgoodsinfo.goodsDetail.productInfo = pobj.actionBody.Info[1].showInfo;
  //     newgoodsinfo.goodsDetail.formInfo = pobj.actionBody.Info[1].formInfo;
  //     txorderobj.interface.para.goods.push(newgoodsinfo);
  //   }
  //   if (pobj.actionBody.Info.length == 3) {
  //     var newgoodsinfo1 = JSON.parse(JSON.stringify(goodsinfo));
  //     newgoodsinfo1.goodsDetail.product = pobj.actionBody.Info[2].product;
  //     newgoodsinfo1.goodsDetail = pobj.actionBody.Info[2].productSnapshot;
  //     newgoodsinfo1.goodsDetail.productInfo = pobj.actionBody.Info[2].showInfo;
  //     newgoodsinfo1.goodsDetail.formInfo = pobj.actionBody.Info[2].formInfo;
  //     txorderobj.interface.para.goods.push(newgoodsinfo1);
  //   }
  //   var txorderinfo = await this.execPostByTimeOut(txorderobj, "http://trade.sandbox.com/interfaces/interface.php");
  //   if (txorderinfo.returnValue < 0) {
  //     return system.getResultFail(-101, "txorderinfo is error");
  //   }
  //   var newpobj = pobj;
  //   pobj.actionBody.product[0].orderNum;
  //   pobj.actionBody.product[0].orderNum; bigDealId
  //   newpobj.actionBody.product = pobj.actionBody.product[0];
  //   newpobj.actionBody.productSnapshot = pobj.actionBody.productSnapshot[0];
  //   newpobj.actionBody.productInfo = pobj.actionBody.productInfo[0];
  //   var gsorder = await this.orderCreate(newpobj);
  //   var kzorder = null;
  //   if (pobj.actionBody.form.isWhether) {
  //     newpobj.product = pobj.product[1];
  //     newpobj.productSnapshot = pobj.productSnapshot[1];
  //     kzorder = await this.orderCreate(newpobj);
  //   }

  // }

  // //订单创建
  // async orderCreate(pobj) {
  //   var actionBody = pobj.actionBody.form;
  //   if (!actionBody.userId) {
  //     return system.getResultFail(-101, "user is empty");
  //   }
  //   return await self.db.transaction(async function (t) {
  //     //创建订单
  //     var orderobj = {
  //       order_num: actionBody.orderNum,
  //       need_num: actionBody.needNum || "",
  //       user_id: actionBody.userId,
  //       user_name: actionBody.userName || "",
  //       quantity: actionBody.quantity,
  //       total_sum: actionBody.totalSum || 0,
  //       discount_amount: actionBody.discountAmount || 0,
  //       pay_total_sum: actionBody.payTotalSum || 0,
  //       refund_sum: actionBody.refundSum || 0,
  //       order_status: 0,
  //       order_status_name: "待支付",
  //     }
  //     var orderinfo = await self.create(orderobj, t);
  //     //创建订单产品
  //     var orderProductobj = {
  //       order_num: pobj.actionBody.orderNum,
  //       user_id: actionBody.userId,
  //       user_name: actionBody.userName || "",
  //       region_id: actionBody.regionId || 0,
  //       region_name: actionBody.regionName || "",
  //       product_icon: actionBody.product.productIcon || 0,
  //       product_type: actionBody.product.productType || 0,
  //       product_type_name: actionBody.product.productTypeName || "",
  //       order_snapshot: actionBody.orderSnapshot || {},
  //       product_snapshot: actionBody.productSnapshot || {},
  //       servicer_code: actionBody.product.servicerCode || "",
  //       servicer_name: actionBody.product.servicerName || "",
  //       // tx_order_snapshot: actionBody.txOrderSnapshot || {}
  //     }
  //     var orderProductinfo = await self.orderProductDao.create(orderProductobj, t);
  //     // //创建订单交付单
  //     // var orderDeliveryobj = {
  //     //   order_num: order_num,
  //     //   user_id: actionBody.userId,
  //     //   user_name: actionBody.userName || "",
  //     //   delivery_status: 1,
  //     //   delivery_status_name: "待接单"
  //     // }
  //     // var orderDeliveryinfo = await self.orderProductDao.create(orderDeliveryinfo, t);
  //     return system.getResultSuccess();
  //   });
  // }

}
module.exports = OrderInfoService;



