var system = require("../../../system");
var settings = require("../../../../config/settings");
const AppServiceBase = require("../../app.base");
const sha256 = require('sha256');

class UtilsMsgSendService extends AppServiceBase {
    constructor() {
        super();
        this.redisClient = system.getObject("util.redisClient");
        this.prefix = "brg-user-center:sendCode:";
    }
    /**
     * 发送验证码
     * @param {*} phoneNumber 手机号
     */
    async sendVerificationCode(phoneNumber) {
        var params = { phoneNumber: phoneNumber };
        var key = this.prefix + phoneNumber;
        var existSend = await this.redisClient.exists(key);
        if (existSend) {
            return system.getResult(null, "操作过于频繁，请稍后再试");
        }
        var randomInt = await this.getUidInfo(6, 10);
        params.messageBody = "验证码为" + randomInt + "（切勿将验证码告知他人），请在页面中60秒内输入完成验证";
        var tmpParams = {
            phoneList: [params]
        }
        var sendResult = await this.sendMessageVerify(tmpParams);
        if (sendResult.status === 1) {
            this.redisClient.setWithEx(key, randomInt, 60);
        }
        return sendResult;
    }
    /**
     * 获取验证码
     * @param {*} phoneNumber 手机号
     */
    async getVerificationCode(phoneNumber) {
        if (!phoneNumber) {
            return system.getResult(null, "手机号不能为空");
        }
        if (!(/^1[3|4|5|6|7|8|9][0-9]\d{8}$/.test(phoneNumber))) {
            return system.getResult(null, "手机号有误，请输入正确手机号");
        }
        var key = this.prefix + phoneNumber;
        return await this.redisClient.getCache(key);
    }
    /**
     * 发送信息
     * @param {*} params 格式：
      {
        phoneList:[{phoneNumber:手机号,messageBody:消息内容}],
        subAccountList:[{title:标题,subAccount:子账号,messageBody:消息内容-站内信}],
        wechatList:[{title:标题,wechatNumber:微信号,messageBody:消息内容}],     
        emailList:[{email:邮箱,messageBody:消息内容}]
      }
     * @param {*} setCacheEx 设置缓存时间，多久不能再次请求
     */
    async sendMessageVerify(params, setCacheEx = 3) {
        var shaStr = await sha256(JSON.stringify(params));
        var existsKey = await this.redisClient.exists(shaStr);
        if (existsKey) {
            return system.getResult(null, "操作过于频繁，请稍后再试");
        }
        if (!params) {
            return system.getResult(null, "params参数不能为空");
        }
        var keyCount = Object.keys(params).length;
        if (keyCount === 0) {
            return system.getResult(null, "params参数不能为空!");
        }
        var verifyResult = null;
        var reqParam = {
            titleTpl: [],
            smsTpl: [],
            siteTpl: [],
            wechatTpl: [],
            emailTpl: [],

            phoneList: [],
            subAccountList: [],
            wechatList: [],
            emailList: []
        }
        if (params.phoneList && params.phoneList.length > 0) {
            for (let index = 0; index < params.phoneList.length; index++) {
                var element = params.phoneList[index];
                if (element) {
                    if (!element.phoneNumber) {
                        verifyResult = system.getResult(null, "手机号不能为空");
                        break;
                    }
                    if (!(/^1[3|4|5|6|7|8|9][0-9]\d{8}$/.test(element.phoneNumber))) {
                        verifyResult = system.getResult(null, "手机号有误，请输入正确手机号");
                        break;
                    }
                    if (!element.messageBody) {
                        verifyResult = system.getResult(null, "消息主体不能为空");
                        break;
                    }
                    params.phoneList[index].phoneNumber = element.phoneNumber.indexOf("86+") >= 0 ? element.phoneNumber : "86+" + element.phoneNumber;
                    reqParam.smsTpl.push(element.messageBody);
                    reqParam.phoneList.push(params.phoneList[index].phoneNumber);
                }
            }
        }
        if (verifyResult) {
            return verifyResult;
        }
        if (params.subAccountList && params.subAccountList.length > 0) {
            for (let index = 0; index < params.subAccountList.length; index++) {
                var element = params.subAccountList[index];
                if (element) {
                    if (!element.title) {
                        verifyResult = system.getResult(null, "站内信标题不能为空");
                        break;
                    }
                    if (!element.subAccount) {
                        verifyResult = system.getResult(null, "子账号不能为空");
                        break;
                    }
                    if (!element.messageBody) {
                        verifyResult = system.getResult(null, "站内信消息主体不能为空");
                        break;
                    }
                    reqParam.titleTpl.push(element.title);
                    reqParam.siteTpl.push(element.messageBody);
                    reqParam.subAccountList.push(element.subAccount);
                }
            }
        }
        if (verifyResult) {
            return verifyResult;
        }
        if (params.wechatList && params.wechatList.length > 0) {
            for (let index = 0; index < params.wechatList.length; index++) {
                var element = params.wechatList[index];
                if (element) {
                    if (!element.title) {
                        verifyResult = system.getResult(null, "微信标题不能为空");
                        break;
                    }
                    if (!element.wechatNumber) {
                        verifyResult = system.getResult(null, "微信号不能为空");
                        break;
                    }
                    if (!element.messageBody) {
                        verifyResult = system.getResult(null, "微信消息主体不能为空");
                        break;
                    }
                    reqParam.titleTpl.push(element.title);
                    reqParam.wechatTpl.push(element.messageBody);
                    reqParam.wechatList.push(element.wechatNumber);
                }
            }
        }
        var sendResult = await this.sendMessage(reqParam);
        if (sendResult.status == 1) {
            this.redisClient.setWithEx(shaStr, 1, setCacheEx);
        }
        console.log(sendResult, "发送通知消息-----------------------------------------------");
        return sendResult;
    }
    /**
     * 发送消息模板
     * @param {*} obj 
        {
            titleTpl: [],
            smsTpl: [],
            siteTpl: [],
            wechatTpl: [],
            emailTpl: [],

            phoneList: [],
            subAccountList: [],
            wechatList: [],
            emailList: []
        }
     */
    async sendMessage(obj) {
        var params = {
            "version": 1,
            "caller": "postman",
            "componentName": "MC",
            "eventId": 1376088908,
            "interface": {
                "interfaceName": "message.message.sendMsg4Unsubscribe",
                "para": {
                    "ownerUin": 798950673,
                    "themeId": 364,
                    "tplParams": {
                        // "titleTpl": obj.titleTpl,
                        // "smsTpl": obj.smsTpl,
                        // "siteTpl": obj.siteTpl,
                        // "wechatTpl": obj.wechatTpl,
                        // "emailTpl": obj.emailTpl
                    },
                    "receiver": {
                        // "phoneList": obj.phoneList,
                        // "subAccountList": obj.subAccountList,
                        // "wechatList": obj.wechatList,
                        // "emailList": obj.emailList
                    },
                    "lang": "zh",
                    "sendChannel": 0
                }
            }
        }
        var sendChannel = 0;//1站内信、2邮件、4短信、8微信
        if (obj.titleTpl && obj.titleTpl.length > 0) {
            params.interface.para.tplParams["titleTpl"] = obj.titleTpl;
        }
        if (obj.smsTpl && obj.smsTpl.length > 0 && obj.phoneList && obj.phoneList.length > 0) {
            params.interface.para.tplParams["smsTpl"] = obj.smsTpl;
            params.interface.para.receiver["phoneList"] = obj.phoneList;
            sendChannel = sendChannel + 4;
        }
        if (obj.siteTpl && obj.siteTpl.length > 0 && obj.subAccountList && obj.subAccountList.length > 0) {
            params.interface.para.tplParams["siteTpl"] = obj.siteTpl;
            params.interface.para.receiver["subAccountList"] = obj.subAccountList;
            sendChannel = sendChannel + 1;
        }
        if (obj.wechatTpl && obj.wechatTpl.length > 0 && obj.wechatList && obj.wechatList.length > 0) {
            params.interface.para.tplParams["wechatTpl"] = obj.wechatTpl;
            params.interface.para.receiver["wechatList"] = obj.wechatList;
            sendChannel = sendChannel + 8;
        }
        if (obj.emailTpl && obj.emailTpl.length > 0 && obj.emailList && obj.emailList.length > 0) {
            params.interface.para.tplParams["emailTpl"] = obj.emailTpl;
            params.interface.para.receiver["emailList"] = obj.emailList;
            sendChannel = sendChannel + 2;
        }
        params.interface.para.sendChannel = sendChannel;
        var result = await this.execPostByTimeOut(params, "http://dev.message.tencentyun.com");
        if (result.status != 1 || !result.data || !result.data.codeDesc || result.data.codeDesc != "success") {
            return system.getResult(null, "获取失败");
        }
        return system.getResultSuccess(null, "获取成功");
    }
}

module.exports = UtilsMsgSendService;