var fs = require("fs");
var objsettings = require("../config/objsettings");
var settings = require("../config/settings");
const request = require('request');
class System {
	static declare(ns) {
		var ar = ns.split('.');
		var root = System;
		for (var i = 0, len = ar.length; i < len; ++i) {
			var n = ar[i];
			if (!root[n]) {
				root[n] = {};
				root = root[n];
			} else {
				root = root[n];
			}
		}
	}
	static async delReq(url, qdata) {
		let rtn = {}
		let promise = new Promise(function (resv, rej) {
			request.del({
				url: url,
				qs: qdata
			}, function (error, response, body) {
				rtn.statusCode = response.statusCode
				if (!error) {
					if (body) {
						let data = JSON.parse(body)
						rtn.data = data
					} else {
						rtn.data = null
					}
					resv(rtn);
				} else {
					rej(error)
				}
			});
		})
		return promise;
	}
	static async getReq(url, qdata) {
		let rtn = {}
		let promise = new Promise(function (resv, rej) {
			request.get({
				url: url,
				json: true,
				qs: qdata
			}, function (error, response, body) {
				rtn.statusCode = response.statusCode;
				if (!error) {
					if (body) {
						rtn.data = body
					} else {
						rtn.data = null
					}
					resv(rtn);
				} else {
					rej(error);
				}
			});
		})
		return promise;
	}
	static async postJsonTypeReq(url, data, md = "POST") {
		let rtn = {}
		let promise = new Promise(function (resv, rej) {
			request({
				url: url,
				method: md,
				json: true,
				headers: {
					"content-type": "application/json",
				},
				body: data
			}, function (error, response, body) {
				console.log(error)
				rtn.statusCode = response.statusCode
				if (!error) {
					if (body) {
						rtn.data = body
					} else {
						rtn.data = null
					}
					resv(rtn);
				} else {
					rej(error)
				}
			});
		})
		return promise;
	}
	static async post3wFormTypeReq(url, data) {
		let rtn = {}
		let promise = new Promise(function (resv, rej) {
			request.post({
				url: url,
				form: data
			}, function (error, response, body) {
				rtn.statusCode = response.statusCode
				if (!error) {
					let data = JSON.parse(body)
					rtn.data = data
					resv(rtn);
				} else {
					rej(error)
				}
			});
		})
		return promise;
	}
	static async postMpFormTypeReq(url, formdata) {
		let promise = new Promise(function (resv, rej) {
			request.post({
				url: url,
				formData: formdata
			}, function (error, response, body) {
				if (!error && response.statusCode == 200) {
					resv(body);
				} else {
					rej(error)
				}
			});
		})
		return promise;
	}

	/**
	 * 请求返回成功
	 * @param {*} data 操作成功返回的数据,有值为成功，无值为失败
	 * @param {*} okmsg 操作成功的描述
	 * @param {*} req 请求头信息
	 */
	static getResult(data, opmsg = "操作成功", req) {
		return {
			status: !data ? -1 : 1,
			message: opmsg,
			data: data
		};
	}

	/**
	 * tx请求返回成功
	 */
	static getResultTX(status, componentName, message, data) {
		return {
			"version": 1,
			"componentName": componentName,
			"returnValue": status,
			"returnCode": status,
			"returnMessage": message,
			"timestamp": Date.now(),
			"data": data
		}
	}


	/**
	 * 请求返回成功
	 * @param {*} data 操作成功返回的数据
	 * @param {*} okmsg 操作成功的描述
	 */
	static getResultSuccess(data, okmsg = "success") {
		return {
			status: 1,
			message: okmsg,
			data: data,
		};
	}
	/**
	 * 请求返回失败
	 * @param {*} status 操作失败状态，默认为-1
	 * @param {*} errmsg 操作失败的描述，默认为fail
	 * @param {*} data 操作失败返回的数据
	 */
	static getResultFail(status = -1, errmsg = "fail", data = null) {
		return {
			status: status,
			message: errmsg,
			data: data,
		};
	}
	/**
	 * 请求处理异常
	 * @param {*} errmsg 操作失败的描述，默认为fail
	 * @param {*} data 操作失败返回的数据
	 */
	static getResultError(errmsg = "fail", data = null) {
		return {
			status: -200,
			message: errmsg,
			data: data,
		};
	}
	static register(key, ClassObj, groupName, filename) {
		if (System.objTable[key] != null) {
			throw new Error("相同key的对象已经存在");
		} else {
			let obj;
			if (ClassObj.name === "ServiceBase") {
				obj = new ClassObj(groupName, filename.replace("Sve", "Dao"));
			} else {
				obj = new ClassObj(groupName, filename);
			}
			System.objTable[key] = obj;
		}

		return System.objTable[key];
	}
	static getObject(objpath) {
		var pathArray = objpath.split(".");
		var packageName = pathArray[0];
		var groupName = pathArray[1];
		var filename = pathArray[2];
		var classpath = "";
		if (filename) {
			classpath = objsettings[packageName] + "/" + groupName;
		} else {
			classpath = objsettings[packageName];
			filename = groupName;
		}

		var objabspath = classpath + "/" + filename + ".js";

		//判断文件的存在性
		//如果不存在，需要查看packageName
		//如果packageName=web.service,dao

		if (System.objTable[objabspath] != null) {
			return System.objTable[objabspath];
		} else {
			var ClassObj = null;
			try {
				ClassObj = require(objabspath);
			} catch (e) {
				console.log(e.stack, "......getObject......");
				let fname = objsettings[packageName + "base"];
				ClassObj = require(fname);
			}
			if (ClassObj.name == "Dao") {
				let modelname = filename.substring(0, filename.lastIndexOf("Dao"))
				return System.register(objabspath, ClassObj, modelname);
			}
			return System.register(objabspath, ClassObj, groupName, filename);
		}
	}
	static get_client_ip(req) {
		var ip = req.headers['x-forwarded-for'] ||
			req.ip ||
			req.connection.remoteAddress ||
			req.socket.remoteAddress ||
			(req.connection.socket && req.connection.socket.remoteAddress) || '';
		var x = ip.match(/(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9])\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9]|0)\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9]|0)\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[0-9])$/);
		if (x) {
			return x[0];
		} else {
			return "localhost";
		}

	};

}
Date.prototype.Format = function (fmt) { //author: meizz
	var o = {
		"M+": this.getMonth() + 1,                 //月份
		"d+": this.getDate(),                    //日
		"h+": this.getHours(),                   //小时
		"m+": this.getMinutes(),                 //分
		"s+": this.getSeconds(),                 //秒
		"q+": Math.floor((this.getMonth() + 3) / 3), //季度
		"S": this.getMilliseconds()             //毫秒
	};
	if (/(y+)/.test(fmt))
		fmt = fmt.replace(RegExp.$1, (this.getFullYear() + "").substr(4 - RegExp.$1.length));
	for (var k in o)
		if (new RegExp("(" + k + ")").test(fmt))
			fmt = fmt.replace(RegExp.$1, (RegExp.$1.length == 1) ? (o[k]) : (("00" + o[k]).substr(("" + o[k]).length)));
	return fmt;
}

System.objTable = {};

module.exports = System;